# Makefile.am.inc
# Include file with common automake definitions for plugins
#
# Wireshark - Network traffic analyzer
# By Gerald Combs <gerald@wireshark.org>
# Copyright 1998 Gerald Combs
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

LIBS = @PLUGIN_LIBS@

PLUGIN_CPPFLAGS = $(INCLUDEDIRS) $(WS_CPPFLAGS) $(GLIB_CFLAGS)

PLUGIN_CFLAGS =

PLUGIN_LDFLAGS = -module -avoid-version

#
# Source files are divided up along several axes:
#
# C vs. C++ - this is used on Windows to generated lists of object files
# with .c=.obj or .cpp=.obj
#
# Register vs. non-register - register files are scanned for registration
# functions, non-register files aren't.
#
# Flex-generated, Lemon-generated, and non-generated:
#
#	we distribute non-generated files, as they're part of the source,
#	and distribute Flex-generated files, as we don't require that
#	people have Flex installed and don't distribute it ourself and
#	thus can't guarantee that we can run Flex in the build process,
#	but we don't distribute Lemon-generated files, as we distribute
#	Lemon and can run it in the build process;
#
#	"make maintainer-clean" on UN*X remove all generated files;
#
#	"make distclean" on UN*X removes Lemon-generated files, as they're
#	not in the distribution, but not Flex-generated files, as they
#	are in the distribution;
#
#	"make distclean" on Windows removes both Lemon-generated and
#	Flex-generated files, as the Flex-generated files in the
#	distribution were generated by Flex on UN*X, and won't compile
#	on Windows;
#
#	Flex-generated files can't be built with full warnings
#	turned on, and can't be run through the checkAPI scripts,
#	as they generate code that won't pass (we've tweaked
#	Lemon to generate code that will pass).
#

#
# All source files to be scanned for registration routines.
#
REGISTER_SRC_FILES = \
	$(FLEX_GENERATED_REGISTER_C_FILES) \
	$(FLEX_GENERATED_REGISTER_CPP_FILES) \
	$(LEMON_GENERATED_REGISTER_C_FILES) \
	$(LEMON_GENERATED_REGISTER_CPP_FILES) \
	$(NONGENERATED_REGISTER_C_FILES) \
	$(NONGENERATED_REGISTER_CPP_FILES)

#
# All distributed source files.
#
SRC_FILES = \
	$(FLEX_GENERATED_C_FILES) \
	$(FLEX_GENERATED_CPP_FILES) \
	$(NONGENERATED_C_FILES) \
	$(NONGENERATED_CPP_FILES)

#
# All non-distributed source files.
#
NODIST_SRC_FILES = \
	$(LEMON_GENERATED_C_FILES) \
	$(LEMON_GENERATED_CPP_FILES)

#
# All non-distributed header files.
#
NODIST_HEADER_FILES = \
	$(LEMON_GENERATED_HEADER_FILES)

#
# All Flex-generated source files.
#
FLEX_GENERATED_SRC_FILES = \
	$(FLEX_GENERATED_C_FILES) \
	$(FLEX_GENERATED_CPP_FILES)

#
# All Lemon-generated source files.
#
LEMON_GENERATED_SRC_FILES = \
	$(LEMON_GENERATED_C_FILES) \
	$(LEMON_GENERATED_CPP_FILES)

#
# All generated source files.
#
GENERATED_SRC_FILES = \
	$(FLEX_GENERATED_SRC_FILES) \
	$(LEMON_GENERATED_SRC_FILES)

#
# All generated header files.
#
GENERATED_HEADER_FILES = \
	$(FLEX_GENERATED_HEADER_FILES) \
	$(LEMON_GENERATED_HEADER_FILES)

#
# All "clean" source files; they can be compiled with the regular
# warning options, including -Werror with GCC-compatible compilers,
# and can be run through checkAPI.  Neither Flex-generated nor
# Lemon-generated files can currently be guaranteed to be clean.
#
CLEAN_SRC_FILES = \
	$(NONGENERATED_C_FILES) \
	$(NONGENERATED_CPP_FILES)

# C source files
C_FILES = \
	$(FLEX_GENERATED_C_FILES) \
	$(LEMON_GENERATED_C_FILES) \
	$(NONGENERATED_C_FILES)

# C++ source files
CPP_FILES = \
	$(FLEX_GENERATED_CPP_FILES) \
	$(LEMON_GENERATED_CPP_FILES) \
	$(NONGENERATED_CPP_FILES)

#
# Build plugin.c, which contains the plugin version[] string, a
# function plugin_register() that calls the register routines for all
# protocols, and a function plugin_reg_handoff() that calls the handoff
# registration routines for all protocols.
#
# We do this by scanning sources.  If that turns out to be too slow,
# maybe we could just require every .o file to have an register routine
# of a given name (packet-aarp.o -> proto_register_aarp, etc.).
#
# Formatting conventions:  The name of the proto_register_* routines an
# proto_reg_handoff_* routines must start in column zero, or must be
# preceded only by "void " starting in column zero, and must not be
# inside #if.
#
# REGISTER_SRC_FILES is assumed to have all the files that need to be scanned.
#
# For some unknown reason, having a big "for" loop in the Makefile
# to scan all the files doesn't work with some "make"s; they seem to
# pass only the first few names in the list to the shell, for some
# reason.
#
# Therefore, we use a script to generate the register.c file.
# The first argument is the directory in which the source files live.
# The second argument is "plugin", to indicate that we should build
# a plugin.c file for a plugin.
# All subsequent arguments are the files to scan.
#
plugin.c: $(REGISTER_SRC_FILES) $(top_srcdir)/tools/make-dissector-reg.py
	@echo Making plugin.c
	@$(PYTHON) $(top_srcdir)/tools/make-dissector-reg.py $(srcdir) \
		plugin $(REGISTER_SRC_FILES)

#
# Currently plugin.c can be included in the distribution because
# we always build all protocol dissectors. We used to have to check
# whether or not to build the snmp dissector. If we again need to
# variably build something, making plugin.c non-portable, uncomment
# the dist-hook line below.
#
# Oh, yuk.  We don't want to include "plugin.c" in the distribution, as
# its contents depend on the configuration, and therefore we want it
# to be built when the first "make" is done; however, Automake insists
# on putting *all* source into the distribution.
#
# We work around this by having a "dist-hook" rule that deletes
# "plugin.c", so that "dist" won't pick it up.
#
#dist-hook:
#	@rm -f $(distdir)/plugin.c

checkapi:
	$(PERL) $(top_srcdir)/tools/checkAPIs.pl -g abort -g termoutput -build \
	-sourcedir=$(srcdir) \
	$(CLEAN_SRC_FILES) $(CLEAN_HEADER_FILES)
