/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.construction;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.ChoiceAction;
import rene.gui.Global;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.lister.Lister;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.dialogs.HelpCloseDialog;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class ConstructionDisplay
extends HelpCloseDialog
implements ClipboardOwner {
    Lister V;
    Vector W;
    Construction C;
    ZirkelCanvas ZC;
    Choice Ch;
    Checkbox Sort;
    public static String[] Choices = new String[]{"all", "visible", "expressions", "points", "lines", "circles", "angles", "other", "invalid"};
    int State = 0;

    public ConstructionDisplay(Frame frame, ZirkelCanvas zirkelCanvas) {
        super(frame, Zirkel.name("constructiondisplay.title", "Construction"), true);
        this.C = zirkelCanvas.getConstruction();
        this.ZC = zirkelCanvas;
        this.V = new Lister(){

            public Dimension getPreferredSize() {
                return new Dimension(500, 400);
            }
        };
        this.V.setMode(true, false, false, false);
        if (Global.Background != null) {
            this.V.setBackground(Global.Background);
        }
        this.V.setFont(Global.FixedFont);
        this.State = Global.getParameter("constructiondisplay.state", 1);
        this.setLayout(new BorderLayout());
        MyPanel myPanel = new MyPanel();
        myPanel.setLayout(new GridLayout(0, 2));
        myPanel.add(new MyLabel(Zirkel.name("constructiondisplay.select")));
        this.Ch = new ChoiceAction(this, "choices");
        for (int i = 0; i < Choices.length; ++i) {
            this.Ch.add(Zirkel.name("constructiondisplay." + Choices[i]));
        }
        myPanel.add(this.Ch);
        this.Ch.select(this.State);
        myPanel.add(new MyLabel(Zirkel.name("constructiondisplay.sorted")));
        this.Sort = new CheckboxAction(this, "", "Sort");
        this.Sort.setState(Global.getParameter("constructiondisplay.sort", true));
        myPanel.add(this.Sort);
        this.add("North", new Panel3D(myPanel));
        this.add("Center", this.V);
        MyPanel myPanel2 = new MyPanel();
        myPanel2.add(new ButtonAction(this, Zirkel.name("constructiondisplay.copy"), "Copy"));
        myPanel2.add(new ButtonAction(this, Zirkel.name("constructiondisplay.edit"), "Edit"));
        myPanel2.add(new ButtonAction(this, Zirkel.name("close", "Close"), "Close"));
        this.addHelp(myPanel2, "construction");
        this.add("South", myPanel2);
        this.pack();
        this.setSize("constructiondialog");
        this.center(frame);
        this.reload();
        this.setVisible(true);
    }

    public void reload() {
        this.V.clear();
        Enumeration enumeration = null;
        enumeration = this.Sort.getState() ? this.C.getSortedElements() : this.C.elements();
        this.W = new Vector();
        block10: while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            switch (this.State) {
                case 1: {
                    if (!constructionObject.mustHide(this.ZC)) break;
                    continue block10;
                }
                case 2: {
                    if (!constructionObject.mustHide(this.ZC) && (constructionObject instanceof ExpressionObject || constructionObject instanceof FunctionObject)) break;
                    continue block10;
                }
                case 3: {
                    if (!constructionObject.mustHide(this.ZC) && constructionObject instanceof PointObject) break;
                    continue block10;
                }
                case 4: {
                    if (!constructionObject.mustHide(this.ZC) && constructionObject instanceof PrimitiveLineObject && !(constructionObject instanceof FixedAngleObject)) break;
                    continue block10;
                }
                case 5: {
                    if (!constructionObject.mustHide(this.ZC) && constructionObject instanceof PrimitiveCircleObject) break;
                    continue block10;
                }
                case 6: {
                    if (!constructionObject.mustHide(this.ZC) && (constructionObject instanceof AngleObject || constructionObject instanceof FixedAngleObject)) break;
                    continue block10;
                }
                case 7: {
                    if (!constructionObject.mustHide(this.ZC) && !(constructionObject instanceof PointObject) && !(constructionObject instanceof PrimitiveLineObject) && !(constructionObject instanceof PrimitiveCircleObject) && !(constructionObject instanceof AngleObject) && !(constructionObject instanceof ExpressionObject) && !(constructionObject instanceof FunctionObject)) break;
                    continue block10;
                }
                case 8: {
                    if (!constructionObject.valid()) break;
                    continue block10;
                }
            }
            this.V.addElement(constructionObject);
            this.W.addElement(constructionObject);
        }
        this.V.showLast();
        this.V.updateDisplay();
    }

    public void doAction(String string) {
        this.noteSize("constructiondialog");
        Global.setParameter("constructiondisplay.sort", this.Sort.getState());
        if (string.equals("Edit")) {
            super.doAction("Close");
            int n = this.V.getSelectedIndex();
            if (n >= 0) {
                Enumeration enumeration = this.W.elements();
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
                    if (n2 == n) {
                        constructionObject.edit(this.ZC);
                        return;
                    }
                    ++n2;
                }
            }
        } else if (string.equals("Copy")) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50000);
                PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(byteArrayOutputStream), true);
                this.V.save(printWriter);
                printWriter.close();
                String string2 = byteArrayOutputStream.toString();
                Clipboard clipboard = this.getToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string2);
                clipboard.setContents(stringSelection, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.doAction(string);
    }

    public void itemAction(String string, boolean bl) {
        if (string.equals("Sort")) {
            this.reload();
        } else if (bl) {
            this.State = this.Ch.getSelectedIndex();
            Global.setParameter("constructiondisplay.state", this.State);
            this.reload();
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

