target=pavage groupe question algo schema translation
\author{Bernadette Perrin-Riou}
\email{bpr@math.u-psud.fr}

\text{dir=datamodule/geometry/pavages}
\integer{choixMotif= \confparm4= ? randint(1..4) : randitem(\confparm4)}
Option reseau ou pas
\integer{choixReseau=\confparm2= ? 1 : randitem(\confparm2)}
Option dessin du pav de base
\integer{choixBase=\confparm3= ? 1 : randitem(\confparm3)}
\integer{CHOIX = \choixMotif <=4  ? 1:2}

\text{style = <style type="text/css">
 .question  {
  background-color: #FFFFCC;
  margin : 2% 5%;
  padding : 2%;}
  .reponse {background-color : #ffcc99;
          color : black;
          margin : 2% 5%;
          padding : 2%;
  }
 </style>
 }
 
\text{choixPav=randint(1..17)}
\text{choixPav=9}
#if #TARGET(pavage)
\title{Ornement plan : rseau du pavage}
#endif
#if #TARGET(groupe)
\title{Ornement plan : Groupe}
#endif
#if #TARGET(question)
\title{Ornement plan : questions sur son groupe}
#endif
#if #TARGET(algo)
\title{Ornement plan : dtermination}
#endif

#if #TARGET(schema)
\title{Ornement plan : lments de symtrie}
#endif
#if #TARGET(translation)
\title{Ornement plan : dessiner le rseau}
\integer{choixMotif= randint(1..4)}
\integer{CHOIX = 1}
\integer{choixReseau=2}
#endif

#if #TARGET(centre)
\title{Ornement plan : centres de symtrie}
\integer{choixMotif= randint(1..4)}
\integer{CHOIX = 1}
\integer{choixReseau=2}
#endif

#if #TARGET(schema)
\matrix{mix = 1,2,3,4,5,6,7,8,9,10,11,12
13,14,15,16,17}
\text{poss = shuffle(\mix[randint(1..2);])}
\text{poss=\poss[1..3]}
\text{rep_click=randint(1..3)}
\text{choixPav = \poss[\rep_click]}
\text{losange=1}
#endif

#if #TARGET(pavage) || #TARGET(groupe) || #TARGET(question) || #TARGET(algo) || #TARGET(schema) || #TARGET(translation) || #TARGET(centre)

#include "nom.inc"
#include "caract.inc"

\if{\CHOIX =1}{
#include "motif.inc"
#include "draw.inc"
}
\if{\CHOIX = 2}{
\text{dossier = \NOM[2;\choixPav]}
 \text{ fig = wims(lookup \dossier in \dir/index.imgs)}
 \text{fig=randitem(\fig)} 
}
#endif
\C \special{expandlines \translation} \special{expandlines \MOTIF} <img src=\PAVAGE1> <img src=\dessin_Motif>
#if #TARGET(pavage)
\statement{\fig \style
\if{\CHOIX=2}{Voici un pavage du plan (ne pas tenir compte des couleurs)}{
\if{\CHOIX=1}{On a pav un plan (vous devez tenir compte des couleurs). 
Le rseau associ admet comme base les vecteurs 
  \(u) et \(v) indiqus.}
}
<table align="center"><tr><td>
\if{\CHOIX=1}{<img src="\PAVAGE">}
\if{\CHOIX=2}{\img{\imagedir/\dossier/\fig width=200}}</td>

    <td valign=top>
<div class="question">
Le groupe ponctuel [\special{help ponctuel,Dtail}] est d'ordre 
<p align="center">\embed{reply 2}</p></div>
<div class="question">Parmi les types de rseaux suivants, indiquer celui
 dont le groupe de symtrie est "le plus proche" de ce groupe ponctuel. 
<ul>
  \for{r = 1 to 5}{<li>\embed{reply1, \r}</li>}
</ul>
</div>
</td>
</tr></table>
</p>
}
\answer{Type de rseau}{\rep_reseau;\Reseau}{type=radio}
\answer{Ordre du groupe ponctuel}{\cnt_ponctuel}{type=numeric}

#endif
#if #TARGET(groupe)
\text{rep_element=}
\for{i=1 to \cnt_ponctuel}{
   \text{vect=item(1,wims(declosing \groupe[\i]))}
   \text{rep_element=\rep_element, position(\vect,\element)}
}
\text{element=wims(makelist \(x) for x in \element)}
\text{rep_element=wims(nonempty items \rep_element)}
\statement{Voici le pavage d'un plan. 
  \if{\CHOIX=1}{Le rseau associ admet comme base les vecteurs 
  \(u) et \(v) indiqus.}
  {Le vecteur \(u) est horizontal. }  
  <p>
Parmi les isomtries (vectorielles) suivantes du plan [\special{help ponctuel,Dtail}], dire 
lesquelles sont le compos d'une translation et d'une isomtrie
laissant invariant ce pavage.

<p><table align="center"><tr><td>
\if{\CHOIX=1}{<img src="\PAVAGE">}
\if{\CHOIX=2}{
\img{\imagedir/\dossier/\fig width=200}}
    <td valign=top>
<div class="question"><ul>
  \for{r = 1 to 8}{<li>\embed{reply1, \r}</li>}
</ul>
</div>
</td>
 <td valign=top>
<div class="question"><ul>
  \for{r = 9 to 14}{<li>\embed{reply1, \r}</li>}
</ul></div>
</td>
</tr></table>
</p>
}

\answer{Isomtries}{\rep_element;\element}{type=checkbox}{option=split}
#endif

#if #TARGET(question)
#include "propriete.inc"
\text{ouinon=oui,non}

\text{axglis=axiales,glisses}
\text{rep1 = \choixPav isitemof \rotation ? 1:2}
\text{rep2 = \choixPav isitemof \symetrie ? 1:2}
\text{rep3 = \ordre_rota[\choixPav]}
\text{rep4 = \systeme[\choixPav]}
\text{rep5 = \choixPav isitemof \axiale ? 1}
\text{rep5 = \choixPav isitemof \glissee ? \rep5,2}
\text{rep5 = wims(nonempty items \rep5)}
\text{rep6 = \choixPav isitemof \glisssym ?1:2}
\text{rep7 = \choixPav isitemof \centre ?1:2}
\text{rep8 = \choixPav isitemof \axe ?1:2}

\text{rep5_cnt=items(\rep5)}

\text{STEP2=\rep1=1 ? reply3}
\text{STEP2=\rep2=1 ?\STEP2,reply4}
\text{STEP2=wims(nonempty items \STEP2)}
\text{STEP3=\rep2=1 ? reply5}
\text{STEP4=\rep2=1 and 2 isin \rep5 ? reply6}
\text{STEP4=\rep2=1  and \rep1=1 ? \STEP4,reply7}
\text{STEP4=\rep4>2  ? \STEP4,reply8}
\text{STEP4=wims(nonempty items \STEP4)}
\matrix{STEP=reply1,reply2
\STEP2
\STEP3
\STEP4
reply9
}

\text{STEP_row=wims(replace internal ;; by ; in  \STEP)}
\text{STEP_row=wims(replace internal ;; by ; in  \STEP_row)}
\text{STEP_row =rows(\STEP_row)}
\steps{\STEP}

\text{question3=\rep1=1 ?L'ordre maximal des rotations est }
\text{question4=\rep2=1 ?Le nombre de systmes d'axes de symtries ou d'axe de glissage est }
\text{question5=\rep2=1 ?Les symtries sont }
\text{question6=\rep2=1 and 2 isin \rep5 ?Il y a  un axe de glissage qui n'est pas un axe de symtrie}
\text{question7=\rep1=1 and \rep2=1 ?Les centres de rotation sont tous sur les axes de symtrie}
\text{question8=\rep4 >2 ?Il y a  des axes de symtrie s'intersectant  45 degrs}

\statement{\style
 
 Rpondre aux questions sur  ce pavage du plan.
<p>
<table align="center"><tr><td>
\if{\CHOIX=1}{<img src="\PAVAGE">}
\if{\CHOIX=2}{\img{\imagedir/\dossier/\fig width=200}}
</td>
    <td valign=top>
\if{\step=1}{<div class="question">Son  groupe de symtrie
      <ul class="question">
      <li>contient une rotation : \embed{reply1}
      <li>contient une rflexion ou une symtrie glisse : \embed{reply2}</li>
      </ul>
      </div>
    }
    {<div class="reponse">
      Son groupe de symtrie \if{\rep1=1}{contient au moins une }{ne contient pas de  } rotation.
      Il \if{\rep2=1}{contient au moins une  }{ne contient pas de } rflexion ou symtrie glisse.
      </div>}
      
 \if{\step=2}{
   \if{\rep1=1}{<div class="question">\question3 \embed{reply3,5}</div>}
   \if{\rep2=1}{<div class="question">\question4 \embed{reply4,5}</div>}
   }
 \if{\step>2}{
   \if{\rep1=1}{<div class="reponse">\question3 \ordre_rota[\choixPav].</div>}
   \if{\rep2=1}{<div class="reponse">\question4 \systeme[\choixPav].</div>}
  }
 \if{\step=3}{\if{\rep2=1}{<div class="question">\question5 \embed{reply5}</div>}}
 \if{\step>3}{<div class="reponse">\question5 \if{\rep5_cnt=1}{\axglis[\rep5]}{\axglis[1] ou \axglis[2]}.</div>}
 
 \if{\step=4}{
    \if{\rep2=1 and 2 isin \rep5}{<div class="question">\question6 
    <p align="center">\embed{reply6}</p></div>}
    \if{\rep2=1 and \rep1=1}{<div class="question">\question7 
    <p align="center">\embed{reply7}</p></div>}
    \if{\rep4>2}{<div class="question">\question8 
    <p align="center">\embed{reply8}</p></div>}
 }
 \if{\step>4}{    
    \if{\rep2=1 and 2 isin \rep5}{
    <div class="reponse"> 
      \if{\rep6=1}{Il y a un axe de glissage qui n'est pas axe de symtrie.}
         {Tous les axes de glissage sont des axes de symtrie.}
     </div>
   }
    \if{\rep2=1 and \rep1=1}{<div class="reponse"> 
      \if{\rep7=1}{Les centres de rotation sont tous sur des axes de symtrie.}
        {Les centres de rotation ne sont pas tous sur les axes de symtrie.}
        </div>
     }
    \if{\rep4>2}{<div class="reponse"> 
      \if{\rep8=1}{Il y a des axes }{Il n'y a pas d'axes }
      de symtrie s'intersectant  45 degrs.
     </div>
     }
   }
</td></tr></table>
</p>
  \if{\step=\STEP_row}{Quel est le nom du groupe [\special{help class,Dtail}]? 
  <p align="center"> \embed{reply9} </p>
   }
 }

\answer{Rotation}{\rep1;\ouinon}{type=radio}
\answer{Symtrie}{\rep2;\ouinon}{type=radio}
\answer{Ordre des rotations}{\rep3}{type=numeric}
\answer{Systmes de symtries}{\rep4}{type=numeric}
\answer{Axiales ou glisses}{\rep5;\axglis}{type=checkbox}
\answer{Axes de glissage}{\rep6;\ouinon}{type=radio}
\answer{Centre de rotation}{\rep7;\ouinon}{type=radio}
\answer{Angles des axes}{\rep8;\ouinon}{type=radio}
\answer{Nom du groupe de l'ornement}{\choixPav ;\NOM[3;]}{type=radio}
#endif


#if #TARGET(algo)
#include "propriete.inc"
\text{question= Choisissez la question que vous voulez vous poser,
Quel est l'ordre maximal des rotations, 
Y a-t-il une rflexion,
Y a-t-il un axe de glissage qui n'est pas un axe de symtrie,
Y a-t-il une symtrie glisse,
Y a-t-il des symtries axiales dans deux directions diffrentes,
Tous les centres de rotation sont-ils sur les axes de symtrie,
Y a-t-il des axes de symtrie se coupant  45 degrs,
Je peux maintenant dterminer de quel ornement il s'agit
}

\text{questionM= wims(replace internal , by ; in \question)}

\text{listerep=}
\text{liste1=}
question utile (une ligne par type de pavage)
\matrix{utile=2,3,5
2,3,5
2,3,4
2,3,5
2,3,6,7
2,3,6
2,3,5
2,3,4
2,3,6,7
2,3
2,3,8
2,3,8
2,3
2,3,7
2,3,7
2,3
2,3}

\text{ouinon=oui,non}

\text{rep2= \ordre_rota[\choixPav]}
\text{rep3 = \choixPav isitemof \axiale ? 1:2}
\text{rep4 = \choixPav isitemof \glissee and \choixPav notitemof \axiale ? 1:2}
\text{rep5 = \choixPav isitemof \glissee ? 1:2}
\text{rep6 = \systeme[\choixPav] >1 ? 1:2}
\text{rep7 = \choixPav isitemof \centre ? 1:2}
\text{rep8 = \choixPav isitemof \axe ?1:2}

\matrix{reponse=aaa}
\matrix{reponse= \rep2 = 1 ?\reponse
Il n'y a pas de rotation non triviale : 
\reponse
Il y a une rotation d'ordre \rep2}

\matrix{reponse= \rep3 = 1 ?\reponse
Il y a une rflexion: 
\reponse
Il n'y a pas de rflexion}

\matrix{reponse= \rep4 = 1 ?\reponse
Il y a un axe de glissage qui n'est pas un axe de symtrie: 
\reponse
Les axes de glissage sont des axes de symtrie}

\matrix{reponse= \rep5 = 1 ?\reponse
Il y a une symtrie glisse: 
\reponse
Il n'y a pas de symtrie glisse}

\matrix{reponse= \rep6 = 1 ?\reponse
Il y a des axes de symtrie dans au moins deux directions diffrentes: 
\reponse
Il y a des axes de symtrie dans au plus une direction}

\matrix{reponse= \rep7 = 1 ? \reponse
Tous les centres de rotations sont sur les axes de symtrie: 
\reponse
Certains centres de rotation ne sont pas sur des axes de symtrie}
\matrix{reponse= \rep8 = 1 ? \reponse
Il existe des axes de symtrie se coupant  45 degrs: 
\reponse
Il n'existe pas d'axes de symtrie se coupant  45 degrs}

\text{nstep=r1}
\nextstep{\nstep}
\text{numero=1}
\text{listereponse=}
\integer{st=0}
\integer{liste1_cnt = -1}
\integer{u_step = 0}
\text{listebis=}

\text{listeprov=}
\text{listenextstep=}
\text{liste=wims(makelist x for x = 2 to 9)}
\text{listequestion = \liste}
\integer{cnt=items(\utile[\choixPav;])}

#include "schema.inc"

\statement{
\style
Voici un pavage du plan.
 Vous devez dterminer  son type [\special{help class,Dtail}]. Pour cela, vous 
 pouvez poser et rpondre  des
questions sur les lments de son groupe de symtrie. A vous de choisir ces questions 
pour arriver au but le plus rapidement possible. 

<i>Par contre, si vous rpondez trop tt, c'est--dire sans avoir suffisament d'lments
de rponse, vous serez pnalis. </i>
<p>
<table align="center"><tr>
<td>
\if{\CHOIX=1}{<img src="\PAVAGE">}
\if{\CHOIX=2}{\img{\imagedir/\dossier/\fig width=200}}
</td>
    <td valign=top>
  \for{u = 1 to \liste1_cnt}{<div class="reponse">
 \reponse[\liste1[\u];]
 </div>
 }
  \if{\numero < 9}{ <div class="question">
  \question[\numero] 
  \if{\step iswordof 2 4 6 8 10 12 14}{dans le groupe de symtrie du pavage : }
  <p align=center>\embed{\nstep}</p></div>
  }
  \if{\numero = 9}{<div class="question">
  \question[\numero]
  <table><tr><td>
  <ul>\for{n=1 to 9}{<li>\embed{\nstep, \n} </li>}
  </ul>
 </td><td>
 <ul>\for{n=10 to 17}{<li>\embed{\nstep, \n} </li>}
  </ul>
  </td></tr></table> </div>}
 </td></tr></table>
 </p>
 
 \rep1,\rep2,\rep3,\rep4,\rep5,\rep6,\rep7,\rep8}


\integer{st= \step%2}
\integer{ste= \step-1}
\integer{numero=1}
\text{listebis=}
\text{listereponse = \reply1,\reply3,\reply5,\reply7,\reply9,\reply11,\reply13}
\if{\st = 0}{ 
   \text{listeprov = wims(listintersect \listereponse and  \question[2..9])}
   \for{ tmp  in \listereponse}{
     \text{listebis=\listebis,position(\tmp,\question)}
     \text{listebis=wims(nonempty items \listebis)}
  }
  \text{liste1 = wims(nonempty items \listebis)}
  \text{numero=\listebis[-1]}
  \if{\numero != and \numero != 1 and \numero != 0}{ 
         \if{\numero != 9}{
            \integer{u_step = 2*(\numero-1)}
            \text{nstep= r \u_step}
            \text{listenextstep=\listenextstep,\nstep}
            \text{listenextstep=wims(nonempty items \listenextstep)}
            }{
            \text{nstep=r15}}
   }
}
{ \if{ 9 notitemof \liste1}{
    \text{nstep = r\step}}{
    \text{nstep=}
    \text{numero=10}
    }
  \text{listenextstep=\listenextstep,\nstep}
}

\integer{liste1_cnt=\st=0 ? items(\liste1)-1 :\liste1_cnt +1}
\answer{Question}{\rep11;\question[\listequestion]}{type=menu}{weight=0}
\answer{\question[2]}{\rep2}{type=numeric}{weight=2}
\answer{Question}{\rep12;\question[\listequestion]}{type=menu}{weight=0}
\answer{\question[3]}{\rep3;\ouinon}{type=radio}{weight=10}
\answer{Question}{\rep13;\question[\listequestion]}{type=menu}{weight=0}
\answer{\question[4]}{\rep4;\ouinon}{type=radio}{weight=10}
\answer{Question}{\rep14;\question[\listequestion]}{type=menu}{weight=0}
\answer{\question[5]}{\rep5;\ouinon}{type=radio}{weight=10}
\answer{Question}{\rep15;\question[\listequestion]}{type=menu}{weight=0}
\answer{\question[6]}{\rep6;\ouinon}{type=radio}{weight=10}
\answer{Question}{\rep16;\question[\listequestion]}{type=menu}{weight=0}
\answer{\question[7]}{\rep7;\ouinon}{type=radio}{weight=10}
\answer{Question}{\rep17;\question[\listequestion]}{type=menu}{weight=0}
\answer{\question[8]}{\rep8;\ouinon}{type=radio}{weight=10}
\answer{Dtermination}{\choixPav;\NOM[3;]}{type=radio}{weight=10}

\text{test =0,\rep2,\rep3,\rep4,\rep5,\rep6,\rep7,\rep8}
\text{test=\test[\liste1]}
\text{TEST=}
\matrix{TESTh=}
\for{ h = 1 to 17}{
  \text{testh =\ordre_rota[\h]}
  \text{Rep3 = \h isitemof \axiale ? 1:2}
  \text{Rep4 = \h isitemof \glissee and \h notitemof \axiale ? 1:2}
  \text{Rep5 = \h isitemof \glissee ? 1:2}
  \text{Rep6 = \systeme[\h] >1 ? 1:2}
  \text{Rep7 = \h isitemof \centre ? 1:2}
  \text{Rep8 = \h isitemof \axe ?1:2}
  \text{testh=0,\ordre_rota[\h],\Rep3,\Rep4,\Rep5,\Rep6,\Rep7,\Rep8}
  \text{testh=\testh[\liste1]}
  \text{test1=pari(print(if([\testh]==[\test],\h,x)))}
  \text{TEST =\TEST,\test1}
}
\text{TEST=wims(replace internal x by in \TEST)}
\text{TEST=wims(nonempty items \TEST)}
\text{TEST1=wims(listcomplement \choixPav in \TEST)}
\text{test=items(\TEST)}
\text{etape= (\step=3 and \reply1 issametext \question[9])
  or (\step = 5 and \reply3 issametext \question[9])
  or (\step = 7 and \reply5 issametext \question[9])
  or (\step = 9 and \reply7 issametext \question[9])
  or (\step = 11 and \reply9 issametext \question[9])
  or (\step = 13 and \reply11 issametext \question[9])
  or (\step = 15 and \reply13 issametext \question[9]) ? 1:0}
\condition{Assez d'lments pour rpondre}{\test=1}

\feedback{\test!= 1 and \etape == 1}{
<div class="reponse">
Vous avez bien dtermin l'ornement 
mais vous avez rpondu trop tt : 
vous ne pouviez pas conclure avec les rponses
aux questions que vous avez pos car les ornements de type
\NOM[3;\TEST1] vrifient les mmes proprits. 
</div>}

\integer{test2 = items(\liste1)-\cnt}
\condition{}{\test2 <=0 }{option=hide}
\feedback{\test2 > 0}{
<div class="reponse">Vous auriez pu ne poser que les questions suivantes : 
<ul>
\for{m = 1 to \cnt}{
  <li> \questionM[\utile[\choixPav;\m];] </li>
 }
 </ul>
 </div>
}

\feedback{1=1}{\listequestion Voici le schma des lments de symtrie de l'ornement plan prsent : 

<p align="center"> <img src="\GRID"><p>
}
#endif

#if #TARGET(schema)
\text{size=200}
\text{Grid_choix=}
\for{h=1 to 3}{
\text{choixPav = \poss[\h]}
#include "schema.inc"

\text{Grid_choix= \Grid_choix, <img src="\GRID">}
}

\text{Grid_choix=wims(nonempty items \Grid_choix)}

\statement{
Voici un pavage du plan. 
<p align="center">
\if{\CHOIX=1}{<img src="\PAVAGE">}
\if{\CHOIX=2}{\img{\imagedir/\dossier/\fig width=200}}
</p>
Parmi les schmas suivants reprsentant les axes de symtrie, les centres
de rotation [\special{help schema, Dtail}], lequel lui correspond ? 
<p align="center"> \embed{reply1} </p>
}

\answer{}{\rep_click;\Grid_choix}{type=click}

\help{\if{\help_subject issametext schema or \help_subject issametext}{
Les lments de symtrie sont reprsents de la manire suivante : 
<ul>
<li> axe de rflexion : ligne pleine </li>
<li> axe de symtrie glisse : ligne pointille </li>
<li> centre de rotation binaire (c'est--dire centre de symtrie
centrale) : point rouge ou magenta</li>
<li> centre de rotation ternaire : points bleus</li>
<li> centre de rotation  quaternaire : points jaunes</li>
<li> centre de rotation sextenaire : points bleu marine</li>
</ul>

Une famille de points quivalents par les translations du groupe de symtrie
t reprsente en noir, 
 moins qu'ils ne soient des centres de rotation ou de symtrie. }
}
#endif

#if #TARGET(translation)
\text{rectangle= \range[1],\range[1],\range[2],\range[2]}
\text{V=slib(draw/convpixel \vu[1,2],\size,\size,\range,\range,0,pixels)}
\text{V=\V,slib(draw/convpixel \vu[3,4],\size,\size,\range,\range,0,pixels)}
\text{V=\V,slib(draw/convpixel \vu[5,6],\size,\size,\range,\range,0,pixels)}
\text{V=\V,slib(draw/convpixel \vu[7,8],\size,\size,\range,\range,0,pixels)}

\statement{
On a pav un plan (vous devez tenir compte des couleurs). 
Tracer un paralllogramme de base du rseau associ (un de ses cts
est port par la flche noire et a l'extrmit de gauche comme extrmit).
<p align="center">
\embed{reply1,\size x \size}
</p>
}

\answer{}{\PAVAGE_u;polygon,\V}{type=javacurve}
#endif

#if #TARGET(centre)
\text{listePoint=\listePoint1}
,\listePoint2,\listePoint3,\listePoint4
\text{listePoint=wims(nonempty items \listePoint)}
\text{V=}
\integer{cnt_point=items(\listePoint)/2}
\for{i=1 to \cnt_point}{
  \text{V=\V,slib(draw/convpixel \listePoint[2*\i-1,2*\i],\size,\size,\range,\range,0,pixels)}
}
\text{V=wims(nonempty items \V)}
\statement{\V ... \choixPav\rectangle Point1:\listePoint1 
<p>
Point2:\listePoint2
<p>
Point3:\listePoint3
<p>
Point4:\listePoint4

<p>
On a pav un plan (vous devez tenir compte des couleurs). 
Cliquer sur les centres de symtrie qui se trouvent  l'intrieur
du rectangle noir. 
<p align="center">
\embed{reply1,\size x \size}
</p>
}

\answer{}{\PAVAGE;points,\V}{type=javacurve}


#endif


#if #TARGET(question) || #TARGET(pavage) || #TARGET(groupe) || #TARGET(algo)
\help{\if{\help_subject issametext ponctuel}{
#include "help.inc"
}
<p>
\if{\help_subject issametext class or \help_subject issametext}{
#include "class.inc"
}

}
#endif
