/*
 * WMA compatible decoder
 * copyright (c) 2002 The FFmpeg Project
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * @file wmadata.h
 * Various WMA tables.
 */

#define IBSS_ATTR
#define ICONST_ATTR
#define ICODE_ATTR

static const uint16_t wma_critical_freqs[25] = {
    100,   200,  300, 400,   510,  630,  770,    920,
    1080, 1270, 1480, 1720, 2000, 2320, 2700,   3150,
    3700, 4400, 5300, 6400, 7700, 9500, 12000, 15500,
    24500,
};

/* first value is number of bands */
static const uint8_t exponent_band_22050[3][25] = {
    { 10, 4, 8, 4, 8, 8, 12, 20, 24, 24, 16, },
    { 14, 4, 8, 8, 4, 12, 12, 16, 24, 16, 20, 24, 32, 40, 36, },
    { 23, 4, 4, 4, 8, 4, 4, 8, 8, 8, 8, 8, 12, 12, 16, 16, 24, 24, 32, 44, 48, 60, 84, 72, },
};

static const uint8_t exponent_band_32000[3][25] = {
    { 11, 4, 4, 8, 4, 4, 12, 16, 24, 20, 28, 4, },
    { 15, 4, 8, 4, 4, 8, 8, 16, 20, 12, 20, 20, 28, 40, 56, 8, },
    { 16, 8, 4, 8, 8, 12, 16, 20, 24, 40, 32, 32, 44, 56, 80, 112, 16, },
};

static const uint8_t exponent_band_44100[3][25] = {
    { 12,  4,   4,   4,   4,   4,   8,   8,   8,  12,  16,  20,  36, },
    { 15,  4,   8,   4,   8,   8,   4,   8,   8,  12,  12,  12,  24,  28,  40,  76, },
    { 17,  4,   8,   8,   4,  12,  12,   8,   8,  24,  16,  20,  24,  32,  40,  60,  80, 152, },
};

static const uint16_t hgain_huffcodes[37] = {
 0x00003, 0x002e7, 0x00001, 0x005cd, 0x0005d, 0x005c9, 0x0005e, 0x00003,
 0x00016, 0x0000b, 0x00001, 0x00006, 0x00001, 0x00006, 0x00004, 0x00005,
 0x00004, 0x00007, 0x00003, 0x00007, 0x00004, 0x0000a, 0x0000a, 0x00002,
 0x00003, 0x00000, 0x00005, 0x00002, 0x0005f, 0x00004, 0x00003, 0x00002,
 0x005c8, 0x000b8, 0x005ca, 0x005cb, 0x005cc,
};

static const uint8_t hgain_huffbits[37] = {
 10, 12, 10, 13,  9, 13,  9,  8,
  7,  5,  5,  4,  4,  3,  3,  3,
  4,  3,  4,  4,  5,  5,  6,  8,
  7, 10,  8, 10,  9,  8,  9,  9,
 13, 10, 13, 13, 13,
};

static const int32_t lsp_codebook[NB_LSP_COEFS][16] = {
{0x1fcc2,0x1fabd,0x1f8c7,0x1f66d,0x1f34c,0x1eef1,0x1e83e,0x1dca6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
{0x1f8fc,0x1f5f9,0x1f328,0x1f025,0x1ecd8,0x1e8fc,0x1e46f,0x1df1b,0x1d87c,0x1d047,0x1c6b5,0x1bb8f,0x1add8,0x19c0e,0x18220,0x154ca},
{0x1e6ae,0x1dd65,0x1d58e,0x1cd3b,0x1c439,0x1ba69,0x1af5e,0x1a32c,0x195c4,0x18498,0x16fd2,0x156ea,0x13de4,0x11f63,0xf7ae,0xbd90},
{0x1c4fa,0x1ada0,0x19976,0x1891d,0x17986,0x1697f,0x15858,0x145fd,0x1316b,0x11900,0xfcfa,0xdf55,0xbe63,0x9902,0x6e83,0x2e05},
{0x16f2d,0x15205,0x135f3,0x11b14,0x10170,0xe743,0xcdec,0xb504,0x9ab2,0x7f86,0x6296,0x4565,0x24e2,0x90,0xffffd52f,0xffffa172},
{0xffbc,0xd786,0xb521,0x943e,0x7876,0x5ea3,0x44ad,0x2bf0,0x1274,0xfffff829,0xfffe9981,0xffffbfab,0xffffa0bb,0xffff7d3f,0xffff59e3,0xffff3269},
{0x43e1,0x102a,0xffffe94a,0xffffc9fa,0xffffb076,0xffff9a6b,0xffff871c,0xffff7555,0xffff62b4,0xffff4f81,0xffff3bf4,0xffff25f7,0xffff0c0f,0xfffeef53,0xfffecb7e,0xfffe9fb3},
{0xffff75ea,0xffff4325,0xffff1da2,0xfffefd23,0xfffeddb9,0xfffebb51,0xfffe945f,0xfffe6131,0xfffee5fe,0xfffed5ba,0xfffec442,0xfffeb224,0xfffe9f95,0xfffe880e,0xfffe6c7a,0xfffe54c1},
{0xffff9d2e,0xffff709e,0xffff5489,0xffff3d5e,0xffff295b,0xffff1761,0xffff06a2,0xfffef68a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
{0xfffe7045,0xfffe572f,0xfffe45ea,0xfffe38af,0xfffe2d8f,0xfffe2347,0xfffe18df,0xfffe0d42,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}
};

static const uint32_t scale_huffcodes[121] = {
 0x3ffe8, 0x3ffe6, 0x3ffe7, 0x3ffe5, 0x7fff5, 0x7fff1, 0x7ffed, 0x7fff6,
 0x7ffee, 0x7ffef, 0x7fff0, 0x7fffc, 0x7fffd, 0x7ffff, 0x7fffe, 0x7fff7,
 0x7fff8, 0x7fffb, 0x7fff9, 0x3ffe4, 0x7fffa, 0x3ffe3, 0x1ffef, 0x1fff0,
 0x0fff5, 0x1ffee, 0x0fff2, 0x0fff3, 0x0fff4, 0x0fff1, 0x07ff6, 0x07ff7,
 0x03ff9, 0x03ff5, 0x03ff7, 0x03ff3, 0x03ff6, 0x03ff2, 0x01ff7, 0x01ff5,
 0x00ff9, 0x00ff7, 0x00ff6, 0x007f9, 0x00ff4, 0x007f8, 0x003f9, 0x003f7,
 0x003f5, 0x001f8, 0x001f7, 0x000fa, 0x000f8, 0x000f6, 0x00079, 0x0003a,
 0x00038, 0x0001a, 0x0000b, 0x00004, 0x00000, 0x0000a, 0x0000c, 0x0001b,
 0x00039, 0x0003b, 0x00078, 0x0007a, 0x000f7, 0x000f9, 0x001f6, 0x001f9,
 0x003f4, 0x003f6, 0x003f8, 0x007f5, 0x007f4, 0x007f6, 0x007f7, 0x00ff5,
 0x00ff8, 0x01ff4, 0x01ff6, 0x01ff8, 0x03ff8, 0x03ff4, 0x0fff0, 0x07ff4,
 0x0fff6, 0x07ff5, 0x3ffe2, 0x7ffd9, 0x7ffda, 0x7ffdb, 0x7ffdc, 0x7ffdd,
 0x7ffde, 0x7ffd8, 0x7ffd2, 0x7ffd3, 0x7ffd4, 0x7ffd5, 0x7ffd6, 0x7fff2,
 0x7ffdf, 0x7ffe7, 0x7ffe8, 0x7ffe9, 0x7ffea, 0x7ffeb, 0x7ffe6, 0x7ffe0,
 0x7ffe1, 0x7ffe2, 0x7ffe3, 0x7ffe4, 0x7ffe5, 0x7ffd7, 0x7ffec, 0x7fff4,
 0x7fff3,
};

static const uint8_t scale_huffbits[121] = {
 18, 18, 18, 18, 19, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 19,
 19, 19, 19, 18, 19, 18, 17, 17,
 16, 17, 16, 16, 16, 16, 15, 15,
 14, 14, 14, 14, 14, 14, 13, 13,
 12, 12, 12, 11, 12, 11, 10, 10,
 10,  9,  9,  8,  8,  8,  7,  6,
  6,  5,  4,  3,  1,  4,  4,  5,
  6,  6,  7,  7,  8,  8,  9,  9,
 10, 10, 10, 11, 11, 11, 11, 12,
 12, 13, 13, 13, 14, 14, 16, 15,
 16, 15, 18, 19, 19, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 19,
 19,
};

static const uint32_t coef0_huffcodes[666] = {
 0x00258, 0x0003d, 0x00000, 0x00005, 0x00008, 0x00008, 0x0000c, 0x0001b,
 0x0001f, 0x00015, 0x00024, 0x00032, 0x0003a, 0x00026, 0x0002c, 0x0002f,
 0x0004a, 0x0004d, 0x00061, 0x00070, 0x00073, 0x00048, 0x00052, 0x0005a,
 0x0005d, 0x0006e, 0x00099, 0x0009e, 0x000c1, 0x000ce, 0x000e4, 0x000f0,
 0x00093, 0x0009e, 0x000a2, 0x000a1, 0x000b8, 0x000d2, 0x000d3, 0x0012e,
 0x00130, 0x000de, 0x0012d, 0x0019b, 0x001e4, 0x00139, 0x0013a, 0x0013f,
 0x0014f, 0x0016d, 0x001a2, 0x0027c, 0x0027e, 0x00332, 0x0033c, 0x0033f,
 0x0038b, 0x00396, 0x003c5, 0x00270, 0x0027c, 0x0025a, 0x00395, 0x00248,
 0x004bd, 0x004fb, 0x00662, 0x00661, 0x0071b, 0x004e6, 0x004ff, 0x00666,
 0x0071c, 0x0071a, 0x0071f, 0x00794, 0x00536, 0x004e2, 0x0078e, 0x004ee,
 0x00518, 0x00535, 0x004fb, 0x0078d, 0x00530, 0x00680, 0x0068f, 0x005cb,
 0x00965, 0x006a6, 0x00967, 0x0097f, 0x00682, 0x006ae, 0x00cd0, 0x00e28,
 0x00f13, 0x00f1f, 0x009f5, 0x00cd3, 0x00f11, 0x00926, 0x00964, 0x00f32,
 0x00f12, 0x00f30, 0x00966, 0x00d0b, 0x00a68, 0x00b91, 0x009c7, 0x00b73,
 0x012fa, 0x0131d, 0x013f9, 0x01ca0, 0x0199c, 0x01c7a, 0x0198c, 0x01248,
 0x01c74, 0x01c64, 0x0139e, 0x012fd, 0x00a77, 0x012fc, 0x01c7b, 0x012ca,
 0x014cc, 0x014d2, 0x014e3, 0x014dc, 0x012dc, 0x03344, 0x02598, 0x0263c,
 0x0333b, 0x025e6, 0x01a1c, 0x01e3c, 0x014e2, 0x033d4, 0x01a11, 0x03349,
 0x03cce, 0x014e1, 0x01a34, 0x0273e, 0x02627, 0x0273f, 0x038ee, 0x03971,
 0x03c67, 0x03c61, 0x0333d, 0x038c2, 0x0263f, 0x038cd, 0x02638, 0x02e41,
 0x0351f, 0x03348, 0x03c66, 0x03562, 0x02989, 0x027d5, 0x0333c, 0x02e4f,
 0x0343b, 0x02ddf, 0x04bc8, 0x029c0, 0x02e57, 0x04c72, 0x025b7, 0x03547,
 0x03540, 0x029d3, 0x04c45, 0x025bb, 0x06600, 0x04c73, 0x04bce, 0x0357b,
 0x029a6, 0x029d2, 0x0263e, 0x0298a, 0x07183, 0x06602, 0x07958, 0x04b66,
 0x0537d, 0x05375, 0x04fe9, 0x04b67, 0x0799f, 0x04bc9, 0x051fe, 0x06a3b,
 0x05bb6, 0x04fa8, 0x0728f, 0x05376, 0x0492c, 0x0537e, 0x0795a, 0x06a3c,
 0x0e515, 0x07887, 0x0683a, 0x051f9, 0x051fd, 0x0cc6a, 0x06a8a, 0x0cc6d,
 0x05bb3, 0x0683b, 0x051fc, 0x05378, 0x0728e, 0x07886, 0x05bb7, 0x0f2a4,
 0x0795b, 0x0683c, 0x09fc1, 0x0683d, 0x0b752, 0x09678, 0x0a3e8, 0x06ac7,
 0x051f0, 0x0b759, 0x06af3, 0x04b6b, 0x0f2a0, 0x0f2ad, 0x096c3, 0x0e518,
 0x0b75c, 0x0d458, 0x0cc6b, 0x0537c, 0x067aa, 0x04fea, 0x0343a, 0x0cc71,
 0x0967f, 0x09fc4, 0x096c2, 0x0e516, 0x0f2a1, 0x0d45c, 0x0d45d, 0x0d45e,
 0x12fb9, 0x0967e, 0x1982f, 0x09883, 0x096c4, 0x0b753, 0x12fb8, 0x0f2a8,
 0x1ca21, 0x096c5, 0x0e51a, 0x1ca27, 0x12f3c, 0x0d471, 0x0f2aa, 0x0b75b,
 0x12fbb, 0x0f2a9, 0x0f2ac, 0x0d45a, 0x0b74f, 0x096c8, 0x16e91, 0x096ca,
 0x12fbf, 0x0d0a7, 0x13103, 0x0d516, 0x16e99, 0x12cbd, 0x0a3ea, 0x19829,
 0x0b755, 0x29ba7, 0x1ca28, 0x29ba5, 0x16e93, 0x1982c, 0x19828, 0x25994,
 0x0a3eb, 0x1ca29, 0x16e90, 0x1ca25, 0x1982d, 0x1ca26, 0x16e9b, 0x0b756,
 0x0967c, 0x25997, 0x0b75f, 0x198d3, 0x0b757, 0x19a2a, 0x0d45b, 0x0e517,
 0x1ca24, 0x1ca23, 0x1ca22, 0x0b758, 0x16e97, 0x0cd14, 0x13100, 0x00007,
 0x0003b, 0x0006b, 0x00097, 0x00138, 0x00125, 0x00173, 0x00258, 0x00335,
 0x0028e, 0x004c6, 0x00715, 0x00729, 0x004ef, 0x00519, 0x004ed, 0x00532,
 0x0068c, 0x00686, 0x00978, 0x00e5d, 0x00e31, 0x009f4, 0x00b92, 0x012f8,
 0x00d06, 0x00a67, 0x00d44, 0x00a76, 0x00d59, 0x012cd, 0x01c78, 0x01c75,
 0x0199f, 0x0198f, 0x01c67, 0x014c6, 0x01c79, 0x01c76, 0x00b94, 0x00d1b,
 0x01e32, 0x01e31, 0x01ab0, 0x01a05, 0x01aa1, 0x0333a, 0x025e5, 0x02626,
 0x03541, 0x03544, 0x03421, 0x03546, 0x02e55, 0x02e56, 0x0492d, 0x02dde,
 0x0299b, 0x02ddc, 0x0357a, 0x0249c, 0x0668b, 0x1c77f, 0x1ca20, 0x0d45f,
 0x09886, 0x16e9a, 0x0f2a7, 0x0b751, 0x0a3ee, 0x0cf59, 0x0cf57, 0x0b754,
 0x0d0a6, 0x16e98, 0x0b760, 0x06ac6, 0x0a3f0, 0x12fbe, 0x13104, 0x0f2a5,
 0x0a3ef, 0x0d472, 0x12cba, 0x1982e, 0x16e9c, 0x1c77e, 0x198d0, 0x13105,
 0x16e92, 0x0b75d, 0x0d459, 0x0001a, 0x000c0, 0x0016c, 0x003cd, 0x00350,
 0x0067b, 0x0051e, 0x006a9, 0x009f4, 0x00b72, 0x00d09, 0x01249, 0x01e3d,
 0x01ca1, 0x01a1f, 0x01721, 0x01a8a, 0x016e8, 0x03347, 0x01a35, 0x0249d,
 0x0299a, 0x02596, 0x02e4e, 0x0298b, 0x07182, 0x04c46, 0x025ba, 0x02e40,
 0x027d6, 0x04fe8, 0x06607, 0x05310, 0x09884, 0x072e1, 0x06a3d, 0x04b6a,
 0x04c7a, 0x06603, 0x04c7b, 0x03428, 0x06605, 0x09664, 0x09fc0, 0x071de,
 0x06601, 0x05bb2, 0x09885, 0x0a3e2, 0x1c61f, 0x12cbb, 0x0b750, 0x0cf58,
 0x0967d, 0x25995, 0x668ad, 0x0b75a, 0x09fc2, 0x0537f, 0x0b75e, 0x13fae,
 0x12fbc, 0x00031, 0x001c4, 0x004c5, 0x005b8, 0x00cf4, 0x0096f, 0x00d46,
 0x01e57, 0x01a04, 0x02625, 0x03346, 0x028f9, 0x04c47, 0x072e0, 0x04b69,
 0x03420, 0x07957, 0x06639, 0x0799e, 0x07959, 0x07881, 0x04b68, 0x09fc3,
 0x09fd6, 0x0cc70, 0x0a3f1, 0x12cbe, 0x0e30e, 0x0e51b, 0x06af2, 0x12cbc,
 0x1c77d, 0x0f2ab, 0x12fbd, 0x1aa2f, 0x0a3ec, 0x0d473, 0x05377, 0x0a3e9,
 0x1982b, 0x0e300, 0x12f3f, 0x0cf5f, 0x096c0, 0x38c3c, 0x16e94, 0x16e95,
 0x12f3d, 0x29ba4, 0x29ba6, 0x1c77c, 0x6a8ba, 0x3545c, 0x33457, 0x668ac,
 0x6a8bb, 0x16e9d, 0x0e519, 0x25996, 0x12f3e, 0x00036, 0x0033e, 0x006ad,
 0x00d03, 0x012c8, 0x0124a, 0x03c42, 0x03ccd, 0x06606, 0x07880, 0x06852,
 0x06a3a, 0x05bb4, 0x0f2a2, 0x09fc7, 0x12cb9, 0x0cc6c, 0x0a6e8, 0x096c1,
 0x0004a, 0x00355, 0x012f9, 0x014e8, 0x01abe, 0x025b6, 0x0492e, 0x09fc6,
 0x051ff, 0x0cc6f, 0x096cb, 0x0d071, 0x198d1, 0x12cb8, 0x38c3d, 0x13faf,
 0x096c9, 0x0009d, 0x00539, 0x012ce, 0x0341f, 0x029c1, 0x04b33, 0x0a3e3,
 0x0d070, 0x16e96, 0x0b763, 0x000a0, 0x009ce, 0x038cc, 0x0343d, 0x051fa,
 0x09888, 0x12fba, 0x000df, 0x00a75, 0x029a7, 0x09fc5, 0x0e301, 0x0967b,
 0x001e7, 0x012c9, 0x051fb, 0x09889, 0x0f2a6, 0x0016f, 0x01cb9, 0x0cf5a,
 0x12cbf, 0x09679, 0x00272, 0x01a15, 0x0967a, 0x003cb, 0x025f6, 0x0b762,
 0x0028d, 0x03c60, 0x0cf5e, 0x00352, 0x03ccc, 0x0072f, 0x07186, 0x004ec,
 0x05379, 0x0068e, 0x09887, 0x006a7, 0x06af1, 0x00e29, 0x0cf5b, 0x00f31,
 0x0d470, 0x009c6, 0x013fb, 0x13102, 0x019a5, 0x13101, 0x01983, 0x01c65,
 0x0124f, 0x014c7, 0x01726, 0x01abf, 0x03304, 0x02624, 0x03c41, 0x027d7,
 0x02ddd, 0x02e54, 0x0343c, 0x06604, 0x07181, 0x0663a, 0x04fa9, 0x0663b,
 0x05311, 0x0537a, 0x06839, 0x05bb5, 0x0492f, 0x06af0, 0x096c7, 0x0cc6e,
 0x0537b, 0x0cf5c, 0x0cf56, 0x198d2, 0x0cf5d, 0x0a3ed, 0x0f2a3, 0x1982a,
 0x0b761, 0x096c6,
};

static const uint8_t coef0_huffbits[666] = {
 11,  6,  2,  3,  4,  5,  5,  5,
  5,  6,  6,  6,  6,  7,  7,  7,
  7,  7,  7,  7,  7,  8,  8,  8,
  8,  8,  8,  8,  8,  8,  8,  8,
  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 11, 11, 11, 10, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 12, 12, 11, 12,
 12, 12, 12, 11, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 13, 13, 12,
 12, 12, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 14,
 13, 13, 13, 13, 13, 13, 13, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 13, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 15,
 15, 14, 14, 15, 15, 15, 14, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 14, 15, 15, 15, 15, 16,
 16, 16, 15, 16, 15, 15, 16, 16,
 16, 16, 15, 16, 16, 16, 15, 16,
 16, 15, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 15, 15, 16, 16,
 15, 16, 16, 16, 17, 17, 17, 16,
 16, 17, 16, 16, 16, 16, 17, 16,
 17, 17, 16, 16, 15, 15, 15, 16,
 17, 16, 17, 16, 16, 17, 17, 17,
 17, 17, 17, 16, 17, 17, 17, 16,
 17, 17, 16, 17, 17, 17, 16, 17,
 17, 16, 16, 17, 17, 17, 18, 17,
 17, 17, 17, 17, 18, 18, 17, 17,
 17, 19, 17, 19, 18, 17, 17, 18,
 17, 17, 18, 17, 17, 17, 18, 17,
 17, 18, 17, 17, 17, 17, 17, 16,
 17, 17, 17, 17, 18, 16, 17,  4,
  6,  8,  9,  9, 10, 10, 10, 10,
 11, 11, 11, 11, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 14, 13, 13, 13, 13,
 13, 13, 14, 14, 14, 14, 14, 14,
 15, 15, 15, 15, 15, 15, 16, 15,
 15, 15, 15, 15, 15, 17, 17, 17,
 16, 18, 16, 17, 17, 16, 16, 17,
 17, 18, 17, 16, 17, 17, 17, 16,
 17, 17, 18, 17, 18, 17, 17, 17,
 18, 17, 17,  5,  8, 10, 10, 11,
 11, 12, 12, 12, 13, 13, 14, 13,
 13, 14, 14, 14, 14, 14, 14, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 16, 16, 15, 16, 16,
 15, 15, 15, 15, 15, 16, 16, 15,
 15, 16, 16, 17, 17, 18, 17, 16,
 17, 18, 19, 17, 16, 16, 17, 17,
 17,  6,  9, 11, 12, 12, 13, 13,
 13, 14, 14, 14, 15, 15, 15, 16,
 15, 15, 15, 15, 15, 15, 16, 16,
 16, 16, 17, 18, 16, 16, 16, 18,
 17, 16, 17, 18, 17, 17, 16, 17,
 17, 16, 17, 16, 17, 18, 18, 18,
 17, 19, 19, 17, 20, 19, 18, 19,
 20, 18, 16, 18, 17,  7, 10, 12,
 13, 13, 14, 14, 14, 15, 15, 16,
 16, 16, 16, 16, 18, 16, 17, 17,
  8, 11, 13, 14, 14, 15, 16, 16,
 16, 16, 17, 17, 17, 18, 18, 17,
 17,  8, 12, 14, 15, 15, 15, 17,
 17, 18, 17,  9, 12, 14, 15, 16,
 16, 17,  9, 13, 15, 16, 16, 17,
  9, 13, 16, 16, 16, 10, 13, 16,
 18, 17, 10, 14, 17, 10, 14, 17,
 11, 14, 16, 11, 14, 11, 15, 12,
 16, 12, 16, 12, 16, 12, 16, 12,
 17, 13, 13, 17, 13, 17, 13, 13,
 14, 14, 14, 14, 14, 14, 14, 15,
 15, 15, 15, 15, 15, 15, 16, 15,
 16, 16, 16, 16, 16, 16, 17, 16,
 16, 16, 16, 17, 16, 17, 16, 17,
 17, 17,
};

static const uint32_t coef1_huffcodes[555] = {
 0x00115, 0x00002, 0x00001, 0x00000, 0x0000d, 0x00007, 0x00013, 0x0001d,
 0x00008, 0x0000c, 0x00023, 0x0002b, 0x0003f, 0x00017, 0x0001b, 0x00043,
 0x00049, 0x00050, 0x00055, 0x00054, 0x00067, 0x00064, 0x0007b, 0x0002d,
 0x00028, 0x0002a, 0x00085, 0x00089, 0x0002b, 0x00035, 0x00090, 0x00091,
 0x00094, 0x00088, 0x000c1, 0x000c6, 0x000f2, 0x000e3, 0x000c5, 0x000e2,
 0x00036, 0x000f0, 0x000a7, 0x000cd, 0x000fb, 0x00059, 0x00116, 0x00103,
 0x00108, 0x0012b, 0x0012d, 0x00188, 0x0012e, 0x0014c, 0x001c3, 0x00187,
 0x001e7, 0x0006f, 0x00094, 0x00069, 0x001e6, 0x001ca, 0x00147, 0x00195,
 0x000a7, 0x00213, 0x00209, 0x00303, 0x00295, 0x00289, 0x0028c, 0x0028d,
 0x00312, 0x00330, 0x0029b, 0x00308, 0x00328, 0x0029a, 0x0025e, 0x003c5,
 0x00384, 0x0039f, 0x00397, 0x00296, 0x0032e, 0x00332, 0x003c6, 0x003e6,
 0x0012d, 0x000d1, 0x00402, 0x000dd, 0x00161, 0x0012b, 0x00127, 0x0045d,
 0x00601, 0x004ab, 0x0045f, 0x00410, 0x004bf, 0x00528, 0x0045c, 0x00424,
 0x00400, 0x00511, 0x00618, 0x0073d, 0x0063a, 0x00614, 0x0073c, 0x007c0,
 0x007cf, 0x00802, 0x00966, 0x00964, 0x00951, 0x008a0, 0x00346, 0x00803,
 0x00a52, 0x0024a, 0x007c1, 0x0063f, 0x00126, 0x00406, 0x00789, 0x008a2,
 0x00960, 0x00967, 0x00c05, 0x00c70, 0x00c79, 0x00a5d, 0x00c26, 0x00c4d,
 0x00372, 0x008a5, 0x00c08, 0x002c5, 0x00f11, 0x00cc4, 0x00f8e, 0x00e16,
 0x00496, 0x00e77, 0x00f9c, 0x00c25, 0x00f1e, 0x00c27, 0x00f1f, 0x00e17,
 0x00ccd, 0x00355, 0x00c09, 0x00c78, 0x00f90, 0x00521, 0x00357, 0x00356,
 0x0068e, 0x00f9d, 0x00c04, 0x00e58, 0x00a20, 0x00a2c, 0x00c4c, 0x0052f,
 0x00f8d, 0x01178, 0x01053, 0x01097, 0x0180f, 0x0180d, 0x012fb, 0x012aa,
 0x0202a, 0x00a40, 0x018ed, 0x01ceb, 0x01455, 0x018e3, 0x012a1, 0x00354,
 0x00353, 0x00f1c, 0x00c7b, 0x00c37, 0x0101d, 0x012cb, 0x01142, 0x0197d,
 0x01095, 0x01e3b, 0x0186b, 0x00588, 0x01c2a, 0x014b8, 0x01e3a, 0x018ec,
 0x01f46, 0x012fa, 0x00a53, 0x01ce8, 0x00a55, 0x01c29, 0x0117b, 0x01052,
 0x012a0, 0x00589, 0x00950, 0x01c2b, 0x00a50, 0x0208b, 0x0180e, 0x02027,
 0x02556, 0x01e20, 0x006e7, 0x01c28, 0x0197a, 0x00684, 0x020a2, 0x01f22,
 0x03018, 0x039cf, 0x03e25, 0x02557, 0x0294c, 0x028a6, 0x00d11, 0x028a9,
 0x02979, 0x00d46, 0x00a56, 0x039ce, 0x030cc, 0x0329a, 0x0149d, 0x0510f,
 0x0451c, 0x02028, 0x03299, 0x01ced, 0x014b9, 0x00f85, 0x00c7a, 0x01800,
 0x00341, 0x012ca, 0x039c8, 0x0329d, 0x00d0d, 0x03e20, 0x05144, 0x00d45,
 0x030d0, 0x0186d, 0x030d5, 0x00d0f, 0x00d40, 0x04114, 0x020a1, 0x0297f,
 0x03e24, 0x032f1, 0x04047, 0x030d4, 0x028a8, 0x00d0e, 0x0451d, 0x04044,
 0x0297e, 0x04042, 0x030d2, 0x030cf, 0x03e21, 0x03e26, 0x028a5, 0x0451a,
 0x00d48, 0x01a16, 0x00d44, 0x04518, 0x0149b, 0x039ca, 0x01498, 0x0403d,
 0x0451b, 0x0149c, 0x032f3, 0x030cb, 0x08073, 0x03e22, 0x0529a, 0x020aa,
 0x039cc, 0x0738a, 0x06530, 0x07389, 0x06193, 0x08071, 0x04043, 0x030ce,
 0x05147, 0x07388, 0x05145, 0x08072, 0x04521, 0x00d47, 0x0297c, 0x030cd,
 0x030ca, 0x0000b, 0x0000c, 0x00083, 0x000e4, 0x00048, 0x00102, 0x001cc,
 0x001f5, 0x00097, 0x0020b, 0x00124, 0x00453, 0x00627, 0x00639, 0x00605,
 0x00517, 0x001b8, 0x00663, 0x00667, 0x007c3, 0x00823, 0x00961, 0x00963,
 0x00e5a, 0x00e59, 0x00a2b, 0x00cbf, 0x00292, 0x00a2d, 0x007d0, 0x00953,
 0x00cc5, 0x00f84, 0x004ab, 0x014a7, 0x0068a, 0x0117a, 0x0052e, 0x01442,
 0x0052c, 0x00c77, 0x00f8f, 0x004aa, 0x01094, 0x01801, 0x012c4, 0x0297b,
 0x00952, 0x01f19, 0x006a5, 0x01149, 0x012c5, 0x01803, 0x022f2, 0x0329b,
 0x04520, 0x0149e, 0x00d13, 0x01f16, 0x01ce9, 0x0101c, 0x006e6, 0x039c9,
 0x06191, 0x07c8e, 0x06192, 0x0ca63, 0x039cd, 0x06190, 0x06884, 0x06885,
 0x07382, 0x00d49, 0x00d41, 0x0450c, 0x0149a, 0x030d1, 0x08077, 0x03e23,
 0x01a15, 0x0e701, 0x0e702, 0x08079, 0x0822a, 0x0a218, 0x07887, 0x0403f,
 0x0520b, 0x0529b, 0x0e700, 0x04519, 0x00007, 0x000e0, 0x000d0, 0x0039b,
 0x003e5, 0x00163, 0x0063e, 0x007c9, 0x00806, 0x00954, 0x01044, 0x01f44,
 0x0197c, 0x01f45, 0x00a51, 0x01f47, 0x00951, 0x0052d, 0x02291, 0x0092f,
 0x00a54, 0x00d12, 0x0297d, 0x00d0c, 0x01499, 0x0329e, 0x032f0, 0x02025,
 0x039c6, 0x00a57, 0x03e46, 0x00d42, 0x0738b, 0x05146, 0x04046, 0x08078,
 0x0510e, 0x07886, 0x02904, 0x04156, 0x04157, 0x06032, 0x030d3, 0x08bce,
 0x04040, 0x0403e, 0x0a414, 0x10457, 0x08075, 0x06887, 0x07c8f, 0x039c7,
 0x07387, 0x08070, 0x08bcf, 0x1482a, 0x10456, 0x1482b, 0x01a17, 0x06886,
 0x0450d, 0x00013, 0x0006b, 0x00615, 0x0080b, 0x0082b, 0x00952, 0x00e5b,
 0x018e2, 0x0186c, 0x01f18, 0x0329f, 0x00d43, 0x03e29, 0x05140, 0x05141,
 0x0ca62, 0x06033, 0x03c42, 0x03e28, 0x0450f, 0x0a21a, 0x07384, 0x0a219,
 0x0e703, 0x0a21b, 0x01a14, 0x07383, 0x045e6, 0x0007a, 0x0012c, 0x00ccc,
 0x0068f, 0x01802, 0x00a52, 0x00953, 0x04045, 0x01a20, 0x0451f, 0x000a4,
 0x00735, 0x01cec, 0x02029, 0x020a3, 0x0451e, 0x00069, 0x00c24, 0x02024,
 0x032f2, 0x05142, 0x00196, 0x00523, 0x000a6, 0x0197b, 0x0030b, 0x0092e,
 0x003e9, 0x03e27, 0x00160, 0x05143, 0x00652, 0x04041, 0x00734, 0x028a7,
 0x0080f, 0x01483, 0x0097c, 0x00340, 0x0068b, 0x00522, 0x01054, 0x01096,
 0x01f17, 0x0202b, 0x01cea, 0x020a0, 0x02978, 0x02026, 0x0297a, 0x039cb,
 0x03e2b, 0x0149f, 0x0329c, 0x07385, 0x08074, 0x0450e, 0x03e2a, 0x05149,
 0x08076, 0x07386, 0x05148,
};

static const uint8_t coef1_huffbits[555] = {
  9,  5,  2,  4,  4,  5,  5,  5,
  6,  6,  6,  6,  6,  7,  7,  7,
  7,  7,  7,  7,  7,  7,  7,  8,
  8,  8,  8,  8,  8,  8,  8,  8,
  8,  8,  8,  8,  8,  8,  8,  8,
  9,  8,  8,  8,  8,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,
  9, 10, 10, 10,  9,  9,  9,  9,
 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 11, 11, 11, 11, 11, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 13, 12, 12, 12, 12, 12, 12, 12,
 13, 12, 12, 12, 12, 12, 12, 12,
 12, 13, 12, 12, 12, 13, 13, 13,
 13, 12, 12, 12, 12, 12, 12, 13,
 12, 13, 13, 13, 13, 13, 13, 13,
 14, 14, 13, 13, 13, 13, 13, 13,
 13, 12, 12, 12, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 14, 13, 14, 13, 13, 13,
 13, 13, 14, 13, 14, 14, 13, 14,
 14, 13, 14, 13, 13, 14, 14, 13,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 15, 14, 14, 14, 14, 15, 15,
 15, 14, 14, 13, 13, 12, 12, 13,
 13, 13, 14, 14, 15, 14, 15, 15,
 14, 13, 14, 15, 15, 15, 14, 14,
 14, 14, 15, 14, 14, 15, 15, 15,
 14, 15, 14, 14, 14, 14, 14, 15,
 15, 16, 15, 15, 15, 14, 15, 15,
 15, 15, 14, 14, 16, 14, 15, 14,
 14, 15, 15, 15, 15, 16, 15, 14,
 15, 15, 15, 16, 15, 15, 14, 14,
 14,  4,  7,  8,  8,  9,  9,  9,
  9, 10, 10, 11, 11, 11, 11, 11,
 11, 12, 11, 11, 11, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 11, 12,
 12, 12, 13, 13, 13, 13, 13, 13,
 13, 12, 12, 13, 13, 13, 13, 14,
 14, 13, 14, 13, 13, 13, 14, 14,
 15, 15, 14, 13, 13, 13, 14, 14,
 15, 15, 15, 16, 14, 15, 17, 17,
 15, 15, 15, 15, 15, 14, 16, 14,
 16, 16, 16, 16, 16, 16, 15, 15,
 17, 15, 16, 15,  6,  8, 10, 10,
 10, 11, 11, 11, 12, 12, 13, 13,
 13, 13, 14, 13, 14, 13, 14, 14,
 14, 14, 14, 15, 15, 14, 14, 14,
 14, 14, 14, 15, 15, 15, 15, 16,
 15, 15, 16, 15, 15, 15, 14, 16,
 15, 15, 18, 17, 16, 17, 15, 14,
 15, 16, 16, 19, 17, 19, 16, 17,
 15,  7, 10, 11, 12, 12, 12, 12,
 13, 13, 13, 14, 15, 14, 15, 15,
 16, 15, 14, 14, 15, 16, 15, 16,
 16, 16, 16, 15, 15,  7, 11, 12,
 13, 13, 14, 14, 15, 15, 15,  8,
 11, 13, 14, 14, 15,  9, 12, 14,
 14, 15,  9, 13, 10, 13, 10, 14,
 10, 14, 11, 15, 11, 15, 11, 14,
 12, 15, 12, 13, 13, 13, 13, 13,
 13, 14, 13, 14, 14, 14, 14, 14,
 14, 15, 14, 15, 16, 15, 14, 15,
 16, 15, 15,
};

static const uint32_t coef2_huffcodes[1336] = {
 0x003e6, 0x000f6, 0x00000, 0x00002, 0x00006, 0x0000f, 0x0001b, 0x00028,
 0x00039, 0x0003f, 0x0006b, 0x00076, 0x000b7, 0x000e8, 0x000ef, 0x00169,
 0x001a7, 0x001d4, 0x001dc, 0x002c4, 0x00349, 0x00355, 0x00391, 0x003dc,
 0x00581, 0x005b2, 0x00698, 0x0070c, 0x00755, 0x0073a, 0x00774, 0x007cf,
 0x00b0a, 0x00b66, 0x00d2e, 0x00d5e, 0x00e1b, 0x00eac, 0x00e5a, 0x00f7e,
 0x00fa1, 0x0163e, 0x01a37, 0x01a52, 0x01c39, 0x01ab3, 0x01d5f, 0x01cb6,
 0x01f52, 0x01dd9, 0x02c04, 0x02c2e, 0x02c2d, 0x02c23, 0x03467, 0x034a3,
 0x0351b, 0x03501, 0x03a5d, 0x0351c, 0x03875, 0x03dea, 0x0397b, 0x039db,
 0x03df1, 0x039d8, 0x03bb4, 0x0580a, 0x0584d, 0x05842, 0x05b13, 0x058ea,
 0x0697d, 0x06a06, 0x068cc, 0x06ac7, 0x06a96, 0x072f4, 0x07543, 0x072b4,
 0x07d20, 0x0b003, 0x073b5, 0x07be6, 0x0d180, 0x07bd1, 0x07cb8, 0x07d06,
 0x07d25, 0x0d2f2, 0x0d19a, 0x0d334, 0x0e1dc, 0x0d529, 0x0d584, 0x0e1d2,
 0x0e5e3, 0x0eec4, 0x0e564, 0x0fa49, 0x16001, 0x0eedc, 0x0f7fa, 0x1a32c,
 0x16131, 0x16003, 0x0f9c8, 0x1ef80, 0x1d2a0, 0x1aa4b, 0x0f7ce, 0x1abfe,
 0x1aa50, 0x1a458, 0x1a816, 0x1cae4, 0x1d2fe, 0x1d52e, 0x1aa4c, 0x2c245,
 0x1d2a1, 0x1a35d, 0x1ca1b, 0x1d5d8, 0x1f531, 0x1ca1c, 0x1f389, 0x1f4af,
 0x3a5e7, 0x351fb, 0x2c24b, 0x34bce, 0x2c24d, 0x2c249, 0x2c24a, 0x72dfc,
 0x357ef, 0x35002, 0x3a5e6, 0x39431, 0x5843b, 0x34a77, 0x58431, 0x3a5f3,
 0x3a5dd, 0x3e5e5, 0x356bd, 0x3976e, 0x6a3d2, 0x3500d, 0x694c4, 0x580bd,
 0x3e5e8, 0x74b95, 0x34a6e, 0x3977c, 0x39432, 0x5b0d2, 0x6a3d8, 0x580b8,
 0x5b0cb, 0x5b0d7, 0x72dee, 0x72ded, 0x72dec, 0x74b9c, 0x3977f, 0x72dea,
 0x74b9e, 0x7be7d, 0x580bf, 0x5b0d5, 0x7cba8, 0x74b91, 0x3e5dd, 0xb6171,
 0xd46b3, 0xd46b9, 0x7cba1, 0x74b9f, 0x72de1, 0xe59f5, 0x3e5eb, 0x00004,
 0x00015, 0x00038, 0x00075, 0x000e8, 0x001d3, 0x00347, 0x0039c, 0x00690,
 0x0074a, 0x00b60, 0x00e93, 0x00f74, 0x0163d, 0x01a5a, 0x01d24, 0x01cbe,
 0x01f4b, 0x03468, 0x03562, 0x03947, 0x03e82, 0x05804, 0x05b12, 0x05803,
 0x0696d, 0x06a9e, 0x0697c, 0x06978, 0x06afb, 0x074b2, 0x072f5, 0x073c0,
 0x07541, 0x06944, 0x074b7, 0x070d3, 0x07ba9, 0x0b0b1, 0x0d1af, 0x0e1dd,
 0x0e5e2, 0x0e1a3, 0x0eec3, 0x1612f, 0x0e961, 0x0eeda, 0x0e78e, 0x0fa48,
 0x1612c, 0x0e511, 0x0e565, 0x0e953, 0x1aa4a, 0x0e59d, 0x1d52c, 0x1a811,
 0x1cae7, 0x1abfc, 0x1d52d, 0x1cacf, 0x1cf05, 0x2c254, 0x34a72, 0x1f4ac,
 0x3976b, 0x34a71, 0x2c6d9, 0x2d873, 0x34a6a, 0x357e7, 0x3464c, 0x3e5f5,
 0x58433, 0x1f53a, 0x3500a, 0x357ea, 0x34a73, 0x3942f, 0x357e5, 0x39775,
 0x694cd, 0x39772, 0x7cba5, 0x6a3ef, 0x35483, 0x74b98, 0x5b0c1, 0x39770,
 0x3a5d7, 0x39433, 0x39434, 0x694ce, 0x580be, 0x3e5ff, 0x6a3ec, 0xb616f,
 0xd46b1, 0x6a3d1, 0x72de5, 0x74b6e, 0x72de9, 0x3e700, 0xd46b6, 0x6a3e9,
 0x74b69, 0xe5675, 0xd46b8, 0x7cbaa, 0x3a5d1, 0x0000c, 0x0003c, 0x000eb,
 0x001f1, 0x003a4, 0x006a8, 0x007d5, 0x00d43, 0x00e77, 0x016c5, 0x01cb1,
 0x02c5d, 0x03a55, 0x03a56, 0x03e51, 0x03bb5, 0x05b0a, 0x06a9f, 0x074b8,
 0x07d28, 0x0d187, 0x0d40e, 0x0d52e, 0x0d425, 0x0eae3, 0x0e1d3, 0x1612e,
 0x0e59e, 0x0eec2, 0x0e578, 0x0e51a, 0x0e579, 0x0e515, 0x0e960, 0x0d183,
 0x0d220, 0x0d2cb, 0x0e512, 0x16c3e, 0x16002, 0x16c42, 0x1cae9, 0x3461a,
 0x1d2fa, 0x1a308, 0x1a849, 0x1cf07, 0x1f38f, 0x34b65, 0x2c253, 0x1ef9e,
 0x1cbc3, 0x1cbc1, 0x2c255, 0x1f384, 0x58435, 0x2c5cd, 0x3a5f7, 0x2c252,
 0x3959c, 0x2c6d8, 0x3a5d3, 0x6ad78, 0x6a3f2, 0x7cba9, 0xb6176, 0x72deb,
 0x39764, 0x3e5f6, 0x3a5d8, 0x74a8c, 0x6a3e6, 0x694d1, 0x6ad79, 0x1a4592,
 0xe59fb, 0x7cbb3, 0x5b0cd, 0x00017, 0x000b5, 0x002c3, 0x005b7, 0x00b1c,
 0x00e5c, 0x0163f, 0x01ab2, 0x01efa, 0x0348a, 0x0396e, 0x058da, 0x06963,
 0x06a30, 0x072cd, 0x073cf, 0x07ce7, 0x0d2ca, 0x0d2d8, 0x0e764, 0x0e794,
 0x16008, 0x16167, 0x1617e, 0x1aa49, 0x1a30b, 0x1a813, 0x2c6da, 0x1a580,
 0x1cbc2, 0x0f9ca, 0x1617f, 0x1d2fe, 0x0f7fc, 0x16c40, 0x0e513, 0x0eec5,
 0x0f7c3, 0x1d508, 0x1a81e, 0x1d2fd, 0x39430, 0x35486, 0x3e5fd, 0x2c24c,
 0x2c75a, 0x34a74, 0x3a5f4, 0x3464d, 0x694ca, 0x3a5f1, 0x1d509, 0x1d5c0,
 0x34648, 0x3464e, 0x6a3d5, 0x6a3e8, 0x6a3e7, 0x5b0c3, 0x2c248, 0x1f38a,
 0x3a5f2, 0x6a3e5, 0x00029, 0x00168, 0x0058c, 0x00b67, 0x00f9d, 0x01c3d,
 0x01cbf, 0x02c20, 0x0351d, 0x03df6, 0x06af9, 0x072b5, 0x0b1d7, 0x0b0b2,
 0x0d40a, 0x0d52b, 0x0e952, 0x0e797, 0x163c3, 0x1c3a0, 0x1f386, 0x1ca21,
 0x34655, 0x2c247, 0x1f53b, 0x2c250, 0x2c24f, 0x1f385, 0x1ef5d, 0x1cf15,
 0x1caea, 0x1ab0a, 0x1cf19, 0x1f53d, 0x1d5c2, 0x1d2fb, 0x1ef58, 0x34a78,
 0x357ec, 0x1f533, 0x3a5e1, 0x694d2, 0x58482, 0x3a5ee, 0x2c6dc, 0x357eb,
 0x5b0c4, 0x39778, 0x6a3e1, 0x7cbb4, 0x3a5e1, 0x74b68, 0x3a5ef, 0x3a5d2,
 0x39424, 0x72de2, 0xe59f6, 0xe59f7, 0x3e702, 0x3e5ec, 0x1f38b, 0x0003b,
 0x001f0, 0x00777, 0x00fa8, 0x01cb2, 0x02d84, 0x03a57, 0x03dd6, 0x06917,
 0x06a11, 0x07d07, 0x0eae2, 0x0e796, 0x0f9c9, 0x0f7fb, 0x16166, 0x16160,
 0x1ab1b, 0x1abfa, 0x2d87b, 0x1d2f7, 0x39768, 0x1f38c, 0x34653, 0x34651,
 0x6a3d9, 0x35001, 0x3abbd, 0x38742, 0x39426, 0x34a76, 0x3a5ec, 0x34a75,
 0x35000, 0x35488, 0x1cf10, 0x2c6db, 0x357ed, 0x357e8, 0x357e9, 0x3a5f0,
 0x694c2, 0xb6178, 0x72df5, 0x39425, 0x3942b, 0x74b6d, 0x74b6f, 0xb6177,
 0xb6179, 0x74b6a, 0xb6172, 0x58487, 0x3e5ee, 0x3e5ed, 0x72df2, 0x72df4,
 0x7cbae, 0x6a3ca, 0x70e86, 0x34bcf, 0x6a3c8, 0x00059, 0x00384, 0x00d5b,
 0x01c38, 0x03560, 0x0395b, 0x0584e, 0x06964, 0x073cd, 0x0b1e7, 0x0e798,
 0x0e78d, 0x0fa43, 0x1a848, 0x1a32f, 0x1aa4e, 0x3464a, 0x1f4ab, 0x1f38d,
 0x3a5eb, 0x3a5d4, 0x3548a, 0x6a3c7, 0x5b0d0, 0x6a3c5, 0x7cbb0, 0x694cb,
 0x3a5e5, 0x3e5e2, 0x3942c, 0x2d872, 0x1f4ae, 0x3a5d5, 0x694d3, 0x58481,
 0x35009, 0x39774, 0x58432, 0xb616c, 0x5b0db, 0x3548b, 0xb6174, 0x1d5d95,
 0xb004c, 0x7cbb2, 0x3a5e5, 0x74a8f, 0xe59f9, 0x72df6, 0xe59fd, 0x7cbad,
 0xd427d, 0x72cff, 0x3977a, 0x5b0d9, 0xb616d, 0xb616b, 0x1a4593, 0x7cbaf,
 0x5b0da, 0x00071, 0x003eb, 0x01603, 0x02c6c, 0x03961, 0x068c8, 0x06a31,
 0x072bd, 0x0d2c2, 0x0e51b, 0x0e5e6, 0x1abfb, 0x1d2ff, 0x1cae5, 0x1ef5c,
 0x1ef5e, 0x1cf13, 0x34a6d, 0x3976d, 0xb616a, 0x3e5f2, 0x6a3c4, 0xb6169,
 0x3e5dc, 0x580b9, 0x74b99, 0x75764, 0x58434, 0x3a5d9, 0x6945a, 0x69459,
 0x3548c, 0x3a5e9, 0x69457, 0x72df1, 0x6945e, 0x6a35e, 0x3e701, 0xb6168,
 0x5b0dd, 0x3a5de, 0x6a3c2, 0xd4278, 0x6a3cc, 0x72dfd, 0xb6165, 0x16009a,
 0x7cbb1, 0xd427c, 0xb6162, 0xe765e, 0x1cecbe, 0x7cbb6, 0x69454, 0xb6160,
 0xd427a, 0x1d5d96, 0xb1d6d, 0xe59f4, 0x72de8, 0x3a5db, 0x0007a, 0x006ae,
 0x01c3c, 0x03aba, 0x058e9, 0x072cc, 0x0d2dd, 0x0d22d, 0x0eec1, 0x0eedb,
 0x1d2a2, 0x1ef5b, 0x357e2, 0x3abbf, 0x1d2f9, 0x35004, 0x3a5dc, 0x351fc,
 0x3976c, 0x6a3c6, 0x6a3cb, 0x3e5ea, 0xe59f3, 0x6a3ce, 0x69452, 0xe59f0,
 0x74b90, 0xd4279, 0xd427b, 0x7cbb5, 0x5b0c5, 0x3a5e3, 0x3a5e2, 0x000d0,
 0x00775, 0x01efe, 0x03dd5, 0x0728c, 0x07cb9, 0x0e1a2, 0x0ea85, 0x0eed8,
 0x1a30a, 0x1aa4f, 0x3a5df, 0x35008, 0x3a5e0, 0x3e5f4, 0x3e5f7, 0xb1d6c,
 0x5843e, 0x34a70, 0x72df8, 0x74b6b, 0xd427f, 0x72df0, 0x5b0bf, 0x5b0c0,
 0xd46b0, 0x72def, 0xe59f8, 0x162e64, 0xb1d6f, 0x3a5e0, 0x39427, 0x69166,
 0x6a3e2, 0x6a3e3, 0x74a8d, 0xd427e, 0x1d5d97, 0xd46b4, 0x5b0d8, 0x6a3d3,
 0x000e0, 0x00b63, 0x034cc, 0x06a33, 0x073c9, 0x0e1a0, 0x0f7fd, 0x0f9cc,
 0x1617d, 0x1caeb, 0x1f4a9, 0x3abb3, 0x69450, 0x39420, 0x39777, 0x3e5e0,
 0x6a3d4, 0x6a3ed, 0xb6166, 0xe59f1, 0xb1d6e, 0xe5676, 0x6a3ea, 0xe5674,
 0xb6163, 0xd46b7, 0x7cba6, 0xd46ba, 0x1d5d94, 0xb6164, 0x6a3f1, 0x7cba2,
 0x69451, 0x72dfa, 0xd46bb, 0x72df7, 0x74b94, 0x1cecbf, 0xe59fa, 0x16009b,
 0x6a3e4, 0x000e6, 0x00e94, 0x03876, 0x070ef, 0x0d52a, 0x16015, 0x16014,
 0x1abf9, 0x1cf17, 0x34a79, 0x34650, 0x3e705, 0x6a3d0, 0x58430, 0x74b9d,
 0x7be7e, 0x5b0be, 0x39773, 0x6a3de, 0x000fb, 0x00f7b, 0x03dd7, 0x07bd0,
 0x0e59c, 0x0f9cd, 0x1cf18, 0x1d2ff, 0x34a7a, 0x39429, 0x3500c, 0x72de0,
 0x69456, 0x7be7c, 0xd46b5, 0xd46b2, 0x6a3dd, 0x001a2, 0x0163b, 0x06913,
 0x0b016, 0x0fa42, 0x1a32d, 0x1cf06, 0x34a7c, 0x34a7d, 0xb6161, 0x35481,
 0x3e5fa, 0x7cba0, 0x7be7f, 0x7cba3, 0x7cba7, 0x5b0d3, 0x72de6, 0x6a3dc,
 0x001a9, 0x01ab4, 0x06a34, 0x0d46a, 0x16130, 0x1ef5f, 0x1f532, 0x1f536,
 0x3942e, 0x58436, 0x6a3db, 0x6945b, 0x001c9, 0x01ca0, 0x0728b, 0x0eed9,
 0x1f539, 0x1ca1d, 0x39765, 0x39766, 0x58439, 0x6945d, 0x39767, 0x001d3,
 0x01f2c, 0x07bfc, 0x16161, 0x34652, 0x3a5ed, 0x3548d, 0x58438, 0x6a3da,
 0x002c1, 0x02c5e, 0x0d335, 0x1ab1a, 0x2d874, 0x35006, 0x35484, 0x5b0cc,
 0x74b9a, 0x72df3, 0x6a3d6, 0x002da, 0x034b3, 0x0d5ae, 0x1caee, 0x2d871,
 0x357e3, 0x74b97, 0x72df9, 0x580ba, 0x5b0d4, 0x0034d, 0x0354e, 0x0f750,
 0x1cbc0, 0x3a5e7, 0x3a5e4, 0x00385, 0x03a58, 0x16c41, 0x2c5cf, 0x3e5e1,
 0x74b6c, 0xe5677, 0x6a3df, 0x00390, 0x03e50, 0x163c2, 0x2d876, 0x35482,
 0x5b0d6, 0x5843a, 0x0039f, 0x0585e, 0x1a583, 0x3500f, 0x74b93, 0x39771,
 0x003e4, 0x06912, 0x16c43, 0x357e1, 0x0058a, 0x0696f, 0x1f538, 0x5b0c9,
 0x6a3cf, 0x005b6, 0x06af8, 0x1f534, 0x58483, 0x6a3e0, 0x00695, 0x07d02,
 0x1cae8, 0x58485, 0x006a2, 0x0754a, 0x357ee, 0x3977b, 0x00748, 0x074b2,
 0x34a7b, 0x00729, 0x0b1e0, 0x34649, 0x3e5e3, 0x0073d, 0x0d2c4, 0x3e5e6,
 0x007bb, 0x0b099, 0x39762, 0x5b0ce, 0x6945f, 0x007d1, 0x0d5ab, 0x39779,
 0x007d3, 0x0d52f, 0x39763, 0x6945c, 0x00b1a, 0x0d2c5, 0x35489, 0x00d23,
 0x0eaed, 0x3e5f8, 0x00d32, 0x16016, 0x3e5fb, 0x00d41, 0x0e768, 0x3a5ed,
 0x00e1f, 0x16017, 0x58027, 0x00ead, 0x0fa07, 0x69455, 0x00e54, 0x1612b,
 0x00e55, 0x1a581, 0x00f78, 0x1a32b, 0x580bc, 0x6a3ee, 0x00f79, 0x1abfd,
 0x00f95, 0x1ab18, 0x6a3f0, 0x01637, 0x1aa4d, 0x0162d, 0x1f53c, 0x6a3f3,
 0x01a31, 0x1a810, 0x39769, 0x01a50, 0x1caef, 0x01a36, 0x1a32e, 0x01a67,
 0x1f38e, 0x01a85, 0x1ef59, 0x01aa6, 0x1ef83, 0x01d51, 0x2c012, 0x01d53,
 0x2d879, 0x01d5e, 0x35005, 0x01cba, 0x1cf04, 0x69453, 0x01d2d, 0x351ff,
 0x01f2d, 0x2d86f, 0x01f29, 0x35007, 0x02c22, 0x351fa, 0x02c03, 0x3a5ec,
 0x02c5f, 0x3a5eb, 0x02c58, 0x34a6b, 0x03469, 0x356be, 0x02c59, 0x34a6c,
 0x0346a, 0x3a5ea, 0x034bd, 0x034bf, 0x356bf, 0x0386a, 0x03ab9, 0x5843f,
 0x0386b, 0x3a5f5, 0x03a4b, 0x39421, 0x03aa4, 0x3a5e9, 0x03a5a, 0x03960,
 0x3977e, 0x03de9, 0x03958, 0x03df7, 0x039e1, 0x3e5e4, 0x0395f, 0x69458,
 0x03e91, 0x03df2, 0x39428, 0x058f2, 0x03e80, 0x6a3c3, 0x03e93, 0x694c0,
 0x058b8, 0x5b0ca, 0x0584f, 0x694c1, 0x058f1, 0x068d6, 0x06a10, 0x06ac3,
 0x06a32, 0x070d2, 0x06911, 0x074b1, 0x07494, 0x06ad4, 0x06ad6, 0x072b8,
 0x06afa, 0x074b3, 0x07540, 0x073ce, 0x0b005, 0x074b3, 0x07495, 0x074b9,
 0x0d336, 0x07bff, 0x07763, 0x073c8, 0x07d29, 0x0b622, 0x0d221, 0x0d181,
 0x0b1d1, 0x074b8, 0x0b1d0, 0x0d19b, 0x0d2c3, 0x0b172, 0x0d2dc, 0x0b623,
 0x0d5aa, 0x0d426, 0x0d182, 0x0e795, 0x0e1d1, 0x0d337, 0x0e96c, 0x0e5e4,
 0x0e514, 0x0eaee, 0x16000, 0x0e767, 0x0e1a1, 0x0e78f, 0x16004, 0x0f7c2,
 0x0e799, 0x0e5e7, 0x0e566, 0x0e769, 0x0f751, 0x0eede, 0x0fa06, 0x16005,
 0x0fa9f, 0x1a5e6, 0x0e766, 0x1636f, 0x0eedd, 0x0eec0, 0x1a309, 0x1ceca,
 0x163cd, 0x0f9cb, 0x0eedf, 0x1a582, 0x1612d, 0x0e5e5, 0x1abf8, 0x1a30c,
 0x1ca1f, 0x163cc, 0x1a35c, 0x1ca1e, 0x1aa51, 0x163ac, 0x1a84e, 0x1a53f,
 0x1cf16, 0x1d2fc, 0x1a5b3, 0x1ab19, 0x1a81f, 0x1d5c3, 0x16c3f, 0x1d5c1,
 0x1d2fc, 0x1f4aa, 0x1a812, 0x1f535, 0x1cf12, 0x1a817, 0x1617c, 0x1ab0b,
 0x1d2f8, 0x1ef82, 0x2d87a, 0x1d52f, 0x1f530, 0x1aa48, 0x35487, 0x1d2fd,
 0x1f4ad, 0x1cf11, 0x3461b, 0x35485, 0x1ca20, 0x1caed, 0x1cae6, 0x1abff,
 0x3464f, 0x34a6f, 0x1ef81, 0x3464b, 0x39d96, 0x1f383, 0x1f537, 0x1cf14,
 0x2c5ce, 0x3500e, 0x2c251, 0x1caec, 0x1f387, 0x34654, 0x357e4, 0x2d878,
 0x3500b, 0x35480, 0x3a5e8, 0x3548e, 0x34b64, 0x1f4a8, 0x35003, 0x3e5df,
 0x2d870, 0x357e6, 0x3e5f0, 0x1ef5a, 0x3a5ea, 0x1f388, 0x3e703, 0x2c24e,
 0x3a5e2, 0x351fd, 0x2c6dd, 0x3e704, 0x351fe, 0x2d875, 0x5b0c7, 0x3976a,
 0x3a5e6, 0x39423, 0x58480, 0x2c246, 0x3a5e3, 0x2d877, 0x3e5f1, 0x3abbe,
 0x58489, 0x3e5f9, 0x357e0, 0x3abbc, 0x5b0c6, 0x69167, 0x69165, 0x3e5e9,
 0x39422, 0x3976f, 0x3977d, 0x3e5de, 0x6a3c9, 0x58b98, 0x3a5f6, 0x3a5d0,
 0x58486, 0x6a3c1, 0x3e5fc, 0x5b0dc, 0x3548f, 0x3942d, 0x694c9, 0x58484,
 0x3a5e8, 0x74b9b, 0x74b96, 0x694d0, 0x58488, 0x3a5e4, 0x3942a, 0x72ec2,
 0x39776, 0x5b0d1, 0x5b0cf, 0x3a5d6, 0xe59fc, 0x5b0c8, 0x3e5e7, 0x7cbb7,
 0x70e87, 0x7cbab, 0x5b0c2, 0x694c3, 0x74a8e, 0x3e5f3, 0x6a3cd, 0x72dfe,
 0x73b2e, 0x72ec0, 0x694c5, 0x58437, 0x694c8, 0x72dff, 0x39435, 0x5843d,
 0x6a3d7, 0x72ec1, 0xd22c8, 0x694cf, 0xb6173, 0x3e5fe, 0x580bb, 0xe59f2,
 0xb616e, 0xb6175, 0x3a5da, 0x5b0bd, 0x694cc, 0x5843c, 0x694c7, 0x74b92,
 0x72ec3, 0x694c6, 0xb6170, 0x7cbac, 0xb1733, 0x7cba4, 0xb6167, 0x72de7,
 0x72de4, 0x6a3c0, 0x3e5ef, 0x162e65, 0x72de3, 0x72dfb, 0x6a35f, 0x6a3eb,
};

static const uint8_t coef2_huffbits[1336] = {
 11,  9,  2,  3,  4,  4,  5,  6,
  6,  7,  7,  8,  8,  8,  9,  9,
  9,  9, 10, 10, 10, 10, 11, 11,
 11, 11, 11, 11, 11, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 16, 15, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 18, 17, 17, 17, 17,
 17, 17, 17, 18, 18, 17, 17, 18,
 17, 17, 18, 17, 18, 18, 18, 18,
 19, 18, 18, 18, 18, 18, 18, 20,
 18, 18, 18, 19, 19, 18, 19, 18,
 19, 19, 18, 19, 19, 18, 19, 19,
 19, 19, 18, 19, 19, 19, 19, 19,
 19, 19, 20, 20, 20, 19, 19, 20,
 19, 20, 19, 19, 20, 19, 19, 20,
 20, 20, 20, 19, 20, 21, 19,  3,
  5,  7,  8,  9,  9, 10, 11, 11,
 12, 12, 12, 13, 13, 13, 13, 14,
 14, 14, 14, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 16, 16,
 15, 15, 15, 15, 16, 16, 16, 16,
 17, 16, 17, 17, 16, 17, 17, 17,
 17, 17, 17, 16, 17, 17, 17, 17,
 18, 17, 17, 18, 18, 18, 18, 18,
 19, 18, 18, 18, 18, 18, 18, 19,
 19, 18, 18, 18, 18, 19, 18, 19,
 19, 19, 20, 19, 18, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 20,
 20, 19, 20, 19, 20, 19, 20, 19,
 19, 21, 20, 20, 19,  4,  7,  8,
 10, 11, 11, 12, 12, 13, 13, 14,
 14, 14, 14, 15, 15, 15, 15, 15,
 16, 16, 16, 16, 16, 16, 16, 17,
 17, 17, 17, 17, 17, 17, 16, 16,
 16, 16, 17, 17, 17, 17, 18, 18,
 18, 17, 17, 18, 18, 18, 18, 18,
 18, 18, 18, 18, 19, 18, 18, 18,
 19, 18, 19, 19, 19, 20, 20, 20,
 19, 19, 19, 19, 19, 19, 19, 21,
 21, 20, 19,  5,  8, 10, 11, 12,
 13, 13, 13, 14, 14, 15, 15, 15,
 15, 16, 16, 16, 16, 16, 17, 17,
 17, 17, 17, 17, 17, 17, 18, 17,
 18, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 19, 18, 19, 18,
 18, 18, 18, 18, 19, 18, 17, 17,
 18, 18, 19, 19, 19, 19, 18, 18,
 18, 19,  6,  9, 11, 12, 13, 13,
 14, 14, 14, 15, 15, 16, 16, 16,
 16, 16, 16, 17, 17, 17, 18, 18,
 18, 18, 18, 18, 18, 18, 18, 18,
 18, 17, 18, 18, 17, 18, 18, 18,
 18, 18, 18, 19, 19, 18, 18, 18,
 19, 19, 19, 20, 19, 19, 18, 19,
 19, 20, 21, 21, 19, 19, 18,  6,
 10, 12, 13, 14, 14, 14, 15, 15,
 15, 16, 16, 17, 17, 17, 17, 17,
 17, 17, 18, 18, 19, 18, 18, 18,
 19, 18, 18, 18, 19, 18, 18, 18,
 18, 18, 18, 18, 18, 18, 18, 18,
 19, 20, 20, 19, 19, 19, 19, 20,
 20, 19, 20, 19, 19, 19, 20, 20,
 20, 19, 19, 18, 19,  7, 10, 12,
 13, 14, 15, 15, 15, 16, 16, 17,
 17, 17, 17, 17, 17, 18, 18, 18,
 18, 19, 18, 19, 19, 19, 20, 19,
 18, 19, 19, 18, 18, 19, 19, 19,
 18, 19, 19, 20, 19, 18, 20, 21,
 20, 20, 19, 19, 21, 20, 21, 20,
 20, 20, 19, 19, 20, 20, 21, 20,
 19,  7, 11, 13, 14, 15, 15, 15,
 16, 16, 17, 17, 17, 17, 18, 18,
 18, 18, 18, 19, 20, 19, 19, 20,
 19, 19, 19, 19, 19, 19, 19, 19,
 18, 18, 19, 20, 19, 19, 19, 20,
 19, 19, 19, 20, 19, 20, 20, 21,
 20, 20, 20, 21, 22, 20, 19, 20,
 20, 21, 20, 21, 20, 19,  8, 11,
 13, 14, 15, 16, 16, 16, 17, 17,
 17, 18, 18, 18, 18, 18, 19, 18,
 19, 19, 19, 19, 21, 19, 19, 21,
 19, 20, 20, 20, 19, 18, 18,  8,
 12, 14, 15, 16, 16, 16, 16, 17,
 17, 17, 19, 18, 18, 19, 19, 20,
 19, 18, 20, 19, 20, 20, 19, 19,
 20, 20, 21, 21, 20, 19, 19, 19,
 19, 19, 19, 20, 21, 20, 19, 19,
  8, 12, 14, 15, 16, 16, 17, 17,
 17, 18, 18, 18, 19, 19, 19, 19,
 19, 19, 20, 21, 20, 21, 19, 21,
 20, 20, 20, 20, 21, 20, 19, 20,
 19, 20, 20, 20, 19, 22, 21, 21,
 19,  9, 12, 14, 15, 16, 17, 17,
 17, 18, 18, 18, 19, 19, 19, 19,
 20, 19, 19, 19,  9, 13, 15, 16,
 17, 17, 18, 18, 18, 19, 18, 20,
 19, 20, 20, 20, 19,  9, 13, 15,
 16, 17, 17, 18, 18, 18, 20, 18,
 19, 20, 20, 20, 20, 19, 20, 19,
  9, 13, 15, 16, 17, 18, 18, 18,
 19, 19, 19, 19, 10, 14, 16, 17,
 18, 18, 19, 19, 19, 19, 19, 10,
 14, 16, 17, 18, 18, 18, 19, 19,
 10, 14, 16, 17, 18, 18, 18, 19,
 19, 20, 19, 10, 14, 16, 18, 18,
 18, 19, 20, 19, 19, 10, 14, 17,
 18, 18, 18, 10, 15, 17, 18, 19,
 19, 21, 19, 11, 15, 17, 18, 18,
 19, 19, 11, 15, 17, 18, 19, 19,
 11, 15, 17, 18, 11, 15, 18, 19,
 19, 11, 15, 18, 19, 19, 11, 16,
 18, 19, 11, 15, 18, 19, 11, 16,
 18, 12, 16, 18, 19, 12, 16, 19,
 12, 16, 19, 19, 19, 12, 16, 19,
 12, 16, 19, 19, 12, 16, 18, 12,
 16, 19, 12, 17, 19, 12, 17, 19,
 12, 17, 19, 12, 17, 19, 13, 17,
 13, 17, 13, 17, 19, 19, 13, 17,
 13, 17, 19, 13, 17, 13, 18, 19,
 13, 17, 19, 13, 18, 13, 17, 13,
 18, 13, 18, 13, 18, 13, 18, 13,
 18, 13, 18, 14, 18, 19, 14, 18,
 14, 18, 14, 18, 14, 18, 14, 19,
 14, 19, 14, 18, 14, 18, 14, 18,
 14, 19, 14, 14, 18, 14, 14, 19,
 14, 18, 14, 19, 14, 19, 14, 15,
 19, 15, 15, 15, 15, 19, 15, 19,
 15, 15, 19, 15, 15, 19, 15, 19,
 15, 19, 15, 19, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 16,
 15, 15, 15, 16, 16, 16, 15, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 17, 16, 16, 16, 17,
 17, 16, 17, 17, 16, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 18,
 17, 17, 17, 17, 17, 17, 17, 17,
 18, 17, 17, 18, 17, 17, 17, 17,
 18, 18, 17, 17, 17, 17, 17, 17,
 17, 18, 17, 18, 18, 17, 17, 17,
 18, 18, 18, 17, 18, 17, 18, 18,
 18, 18, 18, 18, 18, 18, 18, 17,
 18, 18, 18, 18, 19, 18, 18, 18,
 18, 18, 18, 18, 18, 18, 18, 18,
 18, 18, 18, 18, 18, 18, 18, 19,
 18, 18, 19, 18, 18, 18, 19, 18,
 19, 18, 18, 19, 18, 18, 19, 19,
 19, 19, 19, 18, 19, 18, 19, 18,
 19, 19, 18, 18, 19, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 18, 19,
 19, 19, 19, 19, 18, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 20,
 19, 19, 19, 19, 21, 19, 19, 20,
 19, 20, 19, 19, 19, 19, 19, 20,
 20, 20, 19, 19, 19, 20, 19, 19,
 19, 20, 20, 19, 20, 19, 19, 21,
 20, 20, 19, 19, 19, 19, 19, 19,
 20, 19, 20, 20, 20, 20, 20, 20,
 20, 19, 19, 21, 20, 20, 19, 19,
};

static const uint32_t coef3_huffcodes[1072] = {
 0x001b2, 0x00069, 0x00000, 0x00004, 0x00006, 0x0000e, 0x00014, 0x00019,
 0x00016, 0x0002b, 0x00030, 0x0003d, 0x0003c, 0x0005a, 0x0005f, 0x0006d,
 0x0007e, 0x0005f, 0x0007f, 0x000b6, 0x000bc, 0x000d8, 0x000f2, 0x000fe,
 0x000bc, 0x000fc, 0x00161, 0x0016e, 0x00174, 0x00176, 0x001a2, 0x001e3,
 0x001f3, 0x00174, 0x0017a, 0x001ea, 0x002a8, 0x002c4, 0x002e6, 0x00314,
 0x00346, 0x00367, 0x003e9, 0x002e5, 0x002ee, 0x003d6, 0x00555, 0x00554,
 0x00557, 0x005c3, 0x005d6, 0x006e0, 0x0062f, 0x006e2, 0x00799, 0x00789,
 0x007fa, 0x005ce, 0x007fe, 0x005ec, 0x007cc, 0x007af, 0x00aa7, 0x00b19,
 0x00b94, 0x00b85, 0x00b9f, 0x00c48, 0x00c45, 0x00dd8, 0x00c4c, 0x00c4b,
 0x00d99, 0x00d1f, 0x00dc2, 0x00f95, 0x00fa2, 0x00bb5, 0x00b9f, 0x00f5d,
 0x00bbf, 0x00f47, 0x0154a, 0x00fd5, 0x00f45, 0x00f7f, 0x0160d, 0x01889,
 0x01757, 0x01722, 0x018b3, 0x0172d, 0x01a39, 0x01a18, 0x01bb3, 0x01b30,
 0x01e63, 0x0173c, 0x01b35, 0x01723, 0x01e80, 0x01fee, 0x01761, 0x01ffc,
 0x01f7f, 0x02c7c, 0x01fa1, 0x0177b, 0x01755, 0x0175a, 0x01fa6, 0x02eab,
 0x0310a, 0x02c69, 0x03669, 0x03127, 0x03103, 0x02e43, 0x03662, 0x03165,
 0x03124, 0x0313b, 0x03111, 0x03668, 0x0343b, 0x03c52, 0x03efc, 0x02e6c,
 0x03fda, 0x03ef8, 0x02e7b, 0x03ee2, 0x03cc5, 0x03d72, 0x058c0, 0x03df8,
 0x02ea9, 0x03e7e, 0x0556d, 0x05c82, 0x03d71, 0x03e7b, 0x03c42, 0x058d7,
 0x03f4e, 0x06200, 0x03d70, 0x05cb2, 0x05c96, 0x05cb0, 0x03f45, 0x05cb1,
 0x02e6d, 0x03110, 0x02f68, 0x05c90, 0x07ca6, 0x07c88, 0x06204, 0x062c8,
 0x078a6, 0x07986, 0x079d5, 0x0b1ad, 0x07989, 0x0b079, 0x05cdd, 0x0aad4,
 0x05de8, 0x07dcd, 0x07987, 0x05d67, 0x05d99, 0x0b91d, 0x07cf1, 0x05d9b,
 0x079d7, 0x0b07b, 0x05c85, 0x05d9a, 0x07dcc, 0x07ebf, 0x07dce, 0x07dfb,
 0x07ec0, 0x07d1a, 0x07a07, 0x05c84, 0x0c471, 0x07cf2, 0x0baef, 0x0b9d2,
 0x05deb, 0x07bd6, 0x0b845, 0x05d98, 0x0b91a, 0x0bae8, 0x0c4e0, 0x0dc31,
 0x0f93d, 0x0bbce, 0x0d1d2, 0x0f7a9, 0x0d9b9, 0x0bbcb, 0x0b900, 0x0aad7,
 0x0babd, 0x0c4e1, 0x0f46f, 0x0c588, 0x0c58b, 0x160e6, 0x0bbcf, 0x0bac3,
 0x0f945, 0x0f7a3, 0x0d1c1, 0x0fb8e, 0x0f7a4, 0x0fb8c, 0x0f40c, 0x0c473,
 0x0fd72, 0x0bbcd, 0x0fffa, 0x0f940, 0x0bbc9, 0x0f7a8, 0x1a1ed, 0x0bbc5,
 0x1f26f, 0x163fd, 0x160c7, 0x1a1f5, 0x0f947, 0x163fc, 0x154b3, 0x0fff6,
 0x163f6, 0x160e9, 0x1a1f0, 0x0bab9, 0x0baba, 0x17086, 0x0b903, 0x0fd75,
 0x0f308, 0x176f3, 0x163ff, 0x0fd7d, 0x1bb78, 0x163fb, 0x188db, 0x1a1f7,
 0x154b2, 0x172fd, 0x163f4, 0x1bb73, 0x172ff, 0x0babc, 0x0f97d, 0x1a1f3,
 0x1bb6d, 0x1ffd5, 0x1a1f4, 0x1f272, 0x17380, 0x17382, 0x1ffe7, 0x0bac8,
 0x0bbc4, 0x188d3, 0x160e0, 0x0fd7b, 0x1725f, 0x172f5, 0x1bb79, 0x1fad9,
 0x1f269, 0x188d0, 0x0bac4, 0x0bac5, 0x31185, 0x188d2, 0x188cc, 0x31187,
 0x3e7fe, 0x188d1, 0x1bb6c, 0x1f268, 0x1fad2, 0x1ffd9, 0x1a1ea, 0x1bb68,
 0x1facb, 0x3fdb2, 0x1e81a, 0x188ce, 0x172fb, 0x1a1ef, 0x1face, 0x1bb70,
 0x0bac1, 0x1bb6b, 0x172f8, 0x1bb66, 0x1ffdf, 0x1bb6a, 0x1ffd7, 0x1f266,
 0x176f8, 0x37653, 0x1fa7e, 0x31182, 0x1fac8, 0x2c7e3, 0x370ee, 0x176ec,
 0x176e9, 0x2e4bc, 0x160c5, 0x3765a, 0x3ce9c, 0x17373, 0x176e8, 0x188d4,
 0x176f1, 0x176ef, 0x37659, 0x1bb7c, 0x1ffde, 0x176f2, 0x3118b, 0x2c7d4,
 0x37651, 0x5ce9f, 0x37650, 0x31191, 0x3f4f6, 0x3f4f5, 0x7a06c, 0x1fac1,
 0x5c97b, 0x2c7e0, 0x79d3a, 0x3e7fd, 0x2c7df, 0x3f4f0, 0x7a06d, 0x376c1,
 0x79d3b, 0x00004, 0x00014, 0x00059, 0x000ab, 0x000b8, 0x00177, 0x001f5,
 0x001f2, 0x00315, 0x003fc, 0x005bd, 0x0062d, 0x006e8, 0x007dd, 0x00b04,
 0x007cd, 0x00b1e, 0x00d1e, 0x00f15, 0x00f3b, 0x00f41, 0x01548, 0x018b0,
 0x0173b, 0x01884, 0x01a1c, 0x01bb4, 0x01f25, 0x017b5, 0x0176d, 0x01ef8,
 0x02e73, 0x03107, 0x03125, 0x03105, 0x02e49, 0x03ce8, 0x03ef9, 0x03e5e,
 0x02e72, 0x03471, 0x03fd9, 0x0623f, 0x078a0, 0x06867, 0x05cb3, 0x06272,
 0x068ec, 0x06e9a, 0x079d4, 0x06e98, 0x0b1aa, 0x06e1a, 0x07985, 0x068ee,
 0x06e9b, 0x05c88, 0x0b1ac, 0x07dfa, 0x05d65, 0x07cf0, 0x07cbf, 0x0c475,
 0x160eb, 0x1bb7e, 0x0f7a6, 0x1fedd, 0x160e3, 0x0fffb, 0x0fb8d, 0x0fff9,
 0x0d1c0, 0x0c58c, 0x1a1e9, 0x0bab8, 0x0f5cf, 0x0fff5, 0x376c5, 0x1a1ec,
 0x160ed, 0x1fede, 0x1fac9, 0x1a1eb, 0x1f224, 0x176ee, 0x0fd79, 0x17080,
 0x17387, 0x1bb7a, 0x1ffe9, 0x176f7, 0x17385, 0x17781, 0x2c7d5, 0x17785,
 0x1ffe3, 0x163f5, 0x1fac2, 0x3e7f9, 0x3118d, 0x3fdb1, 0x1ffe2, 0x1f226,
 0x3118a, 0x2c7d9, 0x31190, 0x3118c, 0x3f4f3, 0x1bb7f, 0x1bb72, 0x31184,
 0xb92f4, 0x3e7fb, 0x6e1d9, 0x1faca, 0x62300, 0x3fdb8, 0x3d037, 0x3e7fc,
 0x62301, 0x3f4f2, 0x1f26a, 0x0000e, 0x00063, 0x000f8, 0x001ee, 0x00377,
 0x003f7, 0x006e3, 0x005cc, 0x00b05, 0x00dd2, 0x00fd4, 0x0172e, 0x0172a,
 0x01e23, 0x01f2d, 0x01763, 0x01769, 0x0176c, 0x02e75, 0x03104, 0x02ec1,
 0x03e58, 0x0583f, 0x03f62, 0x03f44, 0x058c5, 0x0623c, 0x05cf4, 0x07bd7,
 0x05d9d, 0x0aad2, 0x05d66, 0x0b1a9, 0x0b078, 0x07cfe, 0x0b918, 0x0c46f,
 0x0b919, 0x0b847, 0x06e1b, 0x0b84b, 0x0aad8, 0x0fd74, 0x172f4, 0x17081,
 0x0f97c, 0x1f273, 0x0f7a0, 0x0fd7c, 0x172f7, 0x0fd7a, 0x1bb77, 0x172fe,
 0x1f270, 0x0fd73, 0x1bb7b, 0x1a1bc, 0x1bb7d, 0x0bbc3, 0x172f6, 0x0baeb,
 0x0fb8f, 0x3f4f4, 0x3fdb4, 0x376c8, 0x3e7fa, 0x1ffd0, 0x62303, 0xb92f5,
 0x1f261, 0x31189, 0x3fdb5, 0x2c7db, 0x376c9, 0x1fad6, 0x1fad1, 0x00015,
 0x000f0, 0x002e0, 0x0058e, 0x005d7, 0x00c4d, 0x00fa1, 0x00bdb, 0x01756,
 0x01f70, 0x02c19, 0x0313c, 0x0370f, 0x03cc0, 0x02ea8, 0x058c6, 0x058c7,
 0x02eb7, 0x058d0, 0x07d18, 0x0aa58, 0x0b848, 0x05d9e, 0x05d6c, 0x0b84c,
 0x0c589, 0x0b901, 0x163f8, 0x0bac9, 0x0b9c5, 0x0f93c, 0x188d8, 0x0bbc7,
 0x160ec, 0x0fd6f, 0x188d9, 0x160ea, 0x0f7a7, 0x0f944, 0x0baab, 0x0dc3a,
 0x188cf, 0x176fb, 0x2c7d8, 0x2c7d7, 0x1bb75, 0x5ce9e, 0x62302, 0x370ed,
 0x176f4, 0x1ffd1, 0x370ef, 0x3f4f8, 0x376c7, 0x1ffe1, 0x376c6, 0x176ff,
 0x6e1d8, 0x176f6, 0x17087, 0x0f5cd, 0x00035, 0x001a0, 0x0058b, 0x00aac,
 0x00b9a, 0x0175f, 0x01e22, 0x01e8c, 0x01fb2, 0x0310b, 0x058d1, 0x0552e,
 0x05c27, 0x0686e, 0x07ca7, 0x0c474, 0x0dc33, 0x07bf2, 0x05de9, 0x07a35,
 0x0baaa, 0x0b9eb, 0x0fb95, 0x0b9b8, 0x17381, 0x1f262, 0x188cd, 0x17088,
 0x172fa, 0x0f7a2, 0x1fad3, 0x0bac0, 0x3765c, 0x1fedf, 0x1f225, 0x1fad4,
 0x2c7da, 0x5ce9d, 0x3e7f8, 0x1e203, 0x188d7, 0x00054, 0x002c0, 0x007a1,
 0x00f78, 0x01b36, 0x01fa3, 0x0313a, 0x03436, 0x0343a, 0x07d1d, 0x07bd8,
 0x05cdf, 0x0b846, 0x0b189, 0x0d9b8, 0x0fff8, 0x0d9be, 0x0c58a, 0x05dea,
 0x0d1d3, 0x160e4, 0x1f26b, 0x188da, 0x1e202, 0x2c7d2, 0x163fe, 0x31193,
 0x17782, 0x376c2, 0x2c7d1, 0x3fdb0, 0x3765d, 0x2c7d0, 0x1fad0, 0x1e201,
 0x188dd, 0x2c7e2, 0x37657, 0x37655, 0x376c4, 0x376c0, 0x176ea, 0x0006f,
 0x003cf, 0x00dd5, 0x01f23, 0x02c61, 0x02ed0, 0x05d54, 0x0552d, 0x07883,
 0x0b1a8, 0x0b91c, 0x0babf, 0x0b902, 0x0f7aa, 0x0f7a5, 0x1a1e8, 0x1ffd6,
 0x0babe, 0x1a1bf, 0x163f3, 0x1ffd8, 0x1fad7, 0x1f275, 0x1ffdc, 0x0007d,
 0x005bc, 0x01549, 0x02a99, 0x03def, 0x06273, 0x079d6, 0x07d1b, 0x0aad3,
 0x0d0fc, 0x2c7dd, 0x188d6, 0x0bac2, 0x2c7e1, 0x1bb76, 0x1a1bd, 0x31186,
 0x0fd78, 0x1a1be, 0x31183, 0x3fdb6, 0x3f4f1, 0x37652, 0x1fad5, 0x3f4f9,
 0x3e7ff, 0x5ce9c, 0x3765b, 0x31188, 0x17372, 0x000bd, 0x0078b, 0x01f21,
 0x03c43, 0x03ded, 0x0aad6, 0x07ec1, 0x0f942, 0x05c86, 0x17089, 0x0babb,
 0x1ffe8, 0x2c7de, 0x1f26e, 0x1fac4, 0x3f4f7, 0x37656, 0x1fa7d, 0x376c3,
 0x3fdb3, 0x3118f, 0x1fac6, 0x000f8, 0x007ed, 0x01efd, 0x03e7a, 0x05c91,
 0x0aad9, 0x0baec, 0x0dc32, 0x0f46e, 0x1e200, 0x176fa, 0x3765e, 0x3fdb7,
 0x2c7d6, 0x3fdb9, 0x37654, 0x37658, 0x3118e, 0x1ffdb, 0x000f6, 0x00c43,
 0x03106, 0x068ef, 0x0b84d, 0x0b188, 0x0bbcc, 0x1f264, 0x1bb69, 0x17386,
 0x1fac0, 0x00171, 0x00f39, 0x03e41, 0x068ed, 0x0d9bc, 0x0f7a1, 0x1bb67,
 0x1ffdd, 0x176f9, 0x001b9, 0x00f7d, 0x03f63, 0x0d0fd, 0x0b9ea, 0x188dc,
 0x1fac3, 0x1a1f2, 0x31192, 0x1ffe4, 0x001f6, 0x01754, 0x06865, 0x0f309,
 0x160e5, 0x176f5, 0x3765f, 0x1facc, 0x001e9, 0x01a1a, 0x06201, 0x0f105,
 0x176f0, 0x002df, 0x01756, 0x05d6d, 0x163fa, 0x176ed, 0x00342, 0x02e40,
 0x0d0ff, 0x17082, 0x003cd, 0x02a98, 0x0fffc, 0x2c7dc, 0x1fa7f, 0x003fe,
 0x03764, 0x0fffd, 0x176fc, 0x1fac5, 0x002f7, 0x02ed1, 0x0fb97, 0x0058a,
 0x02edc, 0x0bbc8, 0x005d4, 0x0623d, 0x160e8, 0x0062e, 0x05830, 0x163f9,
 0x006eb, 0x06205, 0x1f274, 0x007de, 0x062c9, 0x1f265, 0x005c9, 0x05cde,
 0x1ffd3, 0x005d4, 0x07988, 0x007ce, 0x0b849, 0x00b1b, 0x05c89, 0x1fac7,
 0x00b93, 0x05c83, 0x00b9e, 0x0f14f, 0x00c4a, 0x0b9c7, 0x00dd4, 0x0c470,
 0x1f271, 0x00f38, 0x0fb96, 0x176eb, 0x00fa0, 0x163f7, 0x00bb2, 0x0b91b,
 0x00bbe, 0x0f102, 0x00f44, 0x0f946, 0x1facd, 0x00f79, 0x0d9bd, 0x0154d,
 0x0bbc6, 0x00fd2, 0x160e7, 0x0172b, 0x188cb, 0x0175e, 0x0fd76, 0x0175c,
 0x1bb71, 0x0189f, 0x1a1ee, 0x01f24, 0x1a1f6, 0x01ba7, 0x0bbca, 0x01f7d,
 0x0ffff, 0x01f2e, 0x1bb65, 0x01bb5, 0x172f9, 0x01fef, 0x1f26c, 0x01f3e,
 0x0fd77, 0x01762, 0x1bb6e, 0x01ef9, 0x172fc, 0x01fa0, 0x02ab7, 0x02e4a,
 0x1f267, 0x01fb3, 0x1ffda, 0x02e42, 0x03101, 0x17780, 0x0313d, 0x03475,
 0x17784, 0x03126, 0x1facf, 0x03c51, 0x17783, 0x03e40, 0x1ffe5, 0x03663,
 0x1ffe0, 0x03e8f, 0x1f26d, 0x0343c, 0x03cc1, 0x176fd, 0x03e45, 0x02ec0,
 0x03f61, 0x03dee, 0x03fd8, 0x0583e, 0x02e45, 0x03e59, 0x03d02, 0x05ce8,
 0x05568, 0x176fe, 0x02f69, 0x1fad8, 0x058c1, 0x05c83, 0x1ffe6, 0x06271,
 0x06e1c, 0x062c7, 0x068e1, 0x0552f, 0x06864, 0x06866, 0x06e99, 0x05cbc,
 0x07ca5, 0x078a1, 0x05c82, 0x07dcf, 0x0623b, 0x0623e, 0x068e8, 0x07a36,
 0x05d9c, 0x0b077, 0x07cf3, 0x07a34, 0x07ca4, 0x07d19, 0x079d2, 0x07d1c,
 0x07bd9, 0x0b84a, 0x0fb94, 0x0aad5, 0x0dc30, 0x07bf3, 0x0baee, 0x0b07a,
 0x0c472, 0x0b91e, 0x0d9ba, 0x05d9f, 0x0d0fe, 0x0b9c6, 0x05c87, 0x0f14e,
 0x0baed, 0x0b92e, 0x0f103, 0x0b9c4, 0x0fb91, 0x0d9bb, 0x0b1ab, 0x0c58d,
 0x0fffe, 0x0f93b, 0x0f941, 0x0baea, 0x0b91f, 0x0f5cc, 0x0d9bf, 0x0f943,
 0x0f104, 0x1f260, 0x0fb92, 0x0f93f, 0x0f3a6, 0x0bac7, 0x0f7ab, 0x0bac6,
 0x17383, 0x0fd6d, 0x0bae9, 0x0fd6e, 0x1e74f, 0x188ca, 0x1f227, 0x0fb93,
 0x0fb90, 0x0fff7, 0x17085, 0x17083, 0x160e1, 0x17084, 0x0f93e, 0x160e2,
 0x160c6, 0x1a1f1, 0x1bb6f, 0x17384, 0x0fd70, 0x1f263, 0x188d5, 0x173a6,
 0x0f5ce, 0x163f2, 0x0fd71, 0x1ffd2, 0x160c4, 0x1ffd4, 0x2c7d3, 0x1bb74,
};

static const uint8_t coef3_huffbits[1072] = {
  9,  7,  2,  3,  4,  4,  5,  5,
  6,  6,  6,  6,  7,  7,  7,  7,
  7,  8,  8,  8,  8,  8,  8,  8,
  9,  9,  9,  9,  9,  9,  9,  9,
  9, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11,
 11, 12, 11, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13,
 13, 14, 13, 14, 14, 13, 14, 13,
 13, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 15,
 14, 14, 15, 14, 14, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 14, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 14, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 16, 15, 16, 16, 16,
 16, 15, 15, 16, 16, 16, 16, 16,
 15, 16, 16, 16, 15, 16, 15, 15,
 16, 15, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 17, 16, 17, 16, 17, 17, 16,
 17, 16, 17, 16, 16, 17, 17, 17,
 16, 17, 16, 16, 17, 16, 17, 16,
 17, 17, 16, 16, 17, 17, 17, 17,
 17, 17, 17, 17, 16, 17, 17, 16,
 17, 17, 17, 17, 17, 17, 17, 17,
 16, 18, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 16, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 18,
 17, 17, 17, 17, 18, 17, 17, 18,
 19, 17, 17, 17, 18, 17, 17, 17,
 18, 18, 18, 17, 17, 17, 18, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 18, 18, 18, 18, 18, 18, 18, 18,
 18, 18, 17, 18, 18, 18, 18, 17,
 18, 18, 18, 17, 17, 18, 18, 18,
 18, 19, 18, 18, 19, 19, 20, 18,
 19, 18, 19, 19, 18, 19, 20, 18,
 19,  4,  6,  7,  8,  9,  9,  9,
 10, 10, 10, 11, 11, 11, 11, 12,
 12, 12, 12, 12, 12, 13, 13, 13,
 13, 13, 13, 13, 13, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 16, 15, 15, 15,
 15, 16, 16, 15, 16, 16, 15, 16,
 17, 17, 17, 17, 17, 16, 16, 16,
 16, 16, 17, 17, 17, 16, 18, 17,
 17, 17, 18, 17, 17, 18, 17, 17,
 17, 17, 17, 18, 17, 18, 18, 18,
 17, 17, 18, 19, 18, 18, 17, 17,
 18, 18, 18, 18, 19, 17, 17, 18,
 20, 19, 19, 18, 19, 18, 19, 19,
 19, 19, 17,  5,  7,  9, 10, 10,
 11, 11, 12, 12, 12, 13, 13, 13,
 13, 13, 14, 14, 14, 14, 14, 15,
 14, 15, 15, 15, 15, 15, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 15, 16, 16, 17, 17, 17,
 16, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 16,
 16, 19, 18, 18, 19, 17, 19, 20,
 17, 18, 18, 18, 18, 18, 18,  6,
  8, 10, 11, 12, 12, 12, 13, 13,
 13, 14, 14, 14, 14, 15, 15, 15,
 15, 15, 15, 16, 16, 16, 16, 16,
 16, 17, 17, 17, 16, 16, 17, 17,
 17, 17, 17, 17, 17, 16, 16, 16,
 17, 18, 18, 18, 17, 19, 19, 18,
 18, 17, 18, 19, 18, 17, 18, 18,
 19, 18, 17, 17,  6,  9, 11, 12,
 13, 13, 13, 14, 14, 14, 15, 15,
 15, 15, 15, 16, 16, 16, 16, 16,
 16, 17, 16, 17, 17, 17, 17, 17,
 17, 17, 18, 17, 18, 17, 17, 18,
 18, 19, 19, 17, 17,  7, 10, 12,
 13, 13, 14, 14, 14, 14, 15, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 17, 17, 17, 17, 18, 17, 18,
 18, 18, 18, 18, 18, 18, 18, 17,
 17, 18, 18, 18, 18, 18, 18,  7,
 10, 12, 13, 14, 15, 15, 15, 15,
 16, 16, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 18, 17, 17,  8,
 11, 13, 14, 15, 15, 15, 15, 16,
 16, 18, 17, 17, 18, 17, 17, 18,
 17, 17, 18, 18, 19, 18, 18, 19,
 19, 19, 18, 18, 18,  8, 11, 13,
 14, 15, 16, 16, 16, 16, 17, 17,
 17, 18, 17, 18, 19, 18, 18, 18,
 18, 18, 18,  8, 12, 14, 15, 15,
 16, 16, 16, 17, 17, 18, 18, 18,
 18, 18, 18, 18, 18, 17,  9, 12,
 14, 15, 16, 16, 17, 17, 17, 17,
 18,  9, 12, 14, 15, 16, 17, 17,
 17, 18,  9, 13, 15, 16, 17, 17,
 18, 17, 18, 17,  9, 13, 15, 16,
 17, 18, 18, 18, 10, 13, 15, 16,
 18, 10, 14, 16, 17, 18, 10, 14,
 16, 17, 10, 14, 16, 18, 18, 10,
 14, 16, 18, 18, 11, 15, 16, 11,
 15, 17, 11, 15, 17, 11, 15, 17,
 11, 15, 17, 11, 15, 17, 12, 16,
 17, 12, 15, 12, 16, 12, 16, 18,
 12, 16, 12, 16, 12, 16, 12, 16,
 17, 12, 16, 18, 12, 17, 13, 16,
 13, 16, 13, 16, 18, 13, 16, 13,
 17, 13, 17, 13, 17, 13, 17, 13,
 17, 13, 17, 13, 17, 13, 17, 13,
 16, 13, 17, 13, 17, 13, 17, 14,
 17, 14, 17, 14, 17, 14, 14, 14,
 17, 14, 17, 14, 14, 18, 14, 14,
 18, 14, 18, 14, 18, 14, 17, 14,
 17, 14, 17, 14, 14, 18, 14, 15,
 15, 15, 14, 15, 15, 14, 15, 15,
 15, 18, 15, 18, 15, 15, 17, 15,
 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 16, 15, 15, 15, 15, 16,
 16, 16, 16, 16, 15, 15, 15, 15,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 17, 16, 16,
 16, 17, 16, 16, 16, 17, 17, 17,
 17, 17, 16, 17, 17, 17, 17, 16,
 16, 16, 17, 17, 17, 17, 16, 17,
 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 18, 17,
};

static const uint32_t coef4_huffcodes[476] = {
 0x00f01, 0x0001e, 0x00000, 0x00004, 0x00006, 0x0000d, 0x0000a, 0x00017,
 0x0001d, 0x00017, 0x0002c, 0x00031, 0x00039, 0x0003e, 0x00039, 0x0005a,
 0x00066, 0x00070, 0x0007b, 0x00070, 0x00077, 0x000af, 0x000c9, 0x000f2,
 0x000f4, 0x000b2, 0x000e3, 0x0015b, 0x0015d, 0x00181, 0x0019d, 0x001e3,
 0x001c5, 0x002b5, 0x002db, 0x00338, 0x003c3, 0x003cc, 0x003f0, 0x002cd,
 0x003fa, 0x003a1, 0x005b4, 0x00657, 0x007ab, 0x0074d, 0x0074c, 0x00ac1,
 0x00ac5, 0x0076b, 0x00ca8, 0x00f04, 0x00f00, 0x00fe3, 0x00f3c, 0x00f10,
 0x00f39, 0x00fe6, 0x00e26, 0x00e90, 0x016c5, 0x01827, 0x01954, 0x015c5,
 0x01958, 0x01f8a, 0x01c4a, 0x02b0f, 0x02b41, 0x02b0e, 0x033c6, 0x03050,
 0x01c4f, 0x02d88, 0x0305c, 0x03c18, 0x02b4f, 0x02cc2, 0x03a47, 0x05680,
 0x0569d, 0x06442, 0x06443, 0x06446, 0x0656e, 0x06444, 0x07120, 0x0748a,
 0x0c1ba, 0x07e22, 0x07aa6, 0x07f25, 0x07aa7, 0x07e20, 0x0c11b, 0x0c118,
 0x07aa5, 0x0ad0a, 0x0f389, 0x19ebb, 0x0caad, 0x0fe42, 0x0fe40, 0x16c34,
 0x2b4e5, 0x33d65, 0x16c30, 0x1e7ae, 0x1e25c, 0x18370, 0x1e703, 0x19eba,
 0x16c37, 0x0e234, 0x16c6e, 0x00004, 0x0002a, 0x00061, 0x00075, 0x000cb,
 0x000ff, 0x00190, 0x001eb, 0x001d1, 0x002b9, 0x00307, 0x00339, 0x0033f,
 0x003fb, 0x003b4, 0x0060c, 0x00679, 0x00645, 0x0067d, 0x0078a, 0x007e3,
 0x00749, 0x00ac4, 0x00ad2, 0x00ae3, 0x00c10, 0x00c16, 0x00ad1, 0x00cf4,
 0x00fe2, 0x01586, 0x00e9d, 0x019f1, 0x01664, 0x01e26, 0x01d38, 0x02b4d,
 0x033c5, 0x01fc2, 0x01fc3, 0x01d28, 0x03c1d, 0x0598e, 0x0f094, 0x07aa4,
 0x0ad38, 0x0ac0c, 0x0c11a, 0x079ea, 0x0c881, 0x0fe44, 0x0b635, 0x0ac0d,
 0x0b61e, 0x05987, 0x07121, 0x0f382, 0x0f387, 0x0e237, 0x0fe47, 0x0f383,
 0x0f091, 0x0f385, 0x0e233, 0x182ee, 0x19eb8, 0x1663e, 0x0f093, 0x00014,
 0x00058, 0x00159, 0x00167, 0x00300, 0x003d4, 0x005b5, 0x0079d, 0x0076a,
 0x00b67, 0x00b60, 0x00f05, 0x00cf0, 0x00f17, 0x00e95, 0x01822, 0x01913,
 0x016c2, 0x0182f, 0x01959, 0x01fcb, 0x01e27, 0x01c40, 0x033c7, 0x01e7b,
 0x01c49, 0x02d89, 0x01e23, 0x01660, 0x03f12, 0x02cc6, 0x033e1, 0x05b34,
 0x0609a, 0x06569, 0x07488, 0x07e21, 0x0cf5f, 0x0712c, 0x0389d, 0x067cf,
 0x07f28, 0x1663f, 0x33d67, 0x1663d, 0x1e25d, 0x3c1ab, 0x15c44, 0x16c36,
 0x0001f, 0x000ec, 0x00323, 0x005b2, 0x0079f, 0x00ac2, 0x00f16, 0x00e9e,
 0x01956, 0x01e0f, 0x019ea, 0x01666, 0x02b89, 0x02b02, 0x02d8c, 0x03c1b,
 0x03c19, 0x032b5, 0x03f9c, 0x02ccf, 0x03897, 0x05b35, 0x0ad02, 0x07f29,
 0x06441, 0x03884, 0x07888, 0x0784e, 0x06568, 0x0c1bb, 0x05986, 0x067cc,
 0x0fe49, 0x0fe48, 0x0c1bc, 0x0fe41, 0x18371, 0x1663c, 0x0e231, 0x0711e,
 0x0ad09, 0x0f092, 0x0002d, 0x001db, 0x00781, 0x00c1a, 0x00f55, 0x01580,
 0x01ea8, 0x02d9b, 0x032af, 0x03f16, 0x03c1c, 0x07834, 0x03c45, 0x0389c,
 0x067ce, 0x06445, 0x0c1b9, 0x07889, 0x07f3a, 0x0784f, 0x07f2b, 0x0ad0b,
 0x0f090, 0x0c11d, 0x0e94e, 0x0711f, 0x0e9f1, 0x0f38e, 0x079e9, 0x0ad03,
 0x0f09b, 0x0caae, 0x0fe46, 0x2b4e6, 0x0e9f0, 0x19eb6, 0x67ac1, 0x67ac0,
 0x33d66, 0x0f388, 0x00071, 0x003a0, 0x00ca9, 0x01829, 0x01d39, 0x02b43,
 0x02cc4, 0x06554, 0x0f09a, 0x0b61f, 0x067cd, 0x0711c, 0x0b636, 0x07f2a,
 0x0b634, 0x0c11f, 0x0cf5e, 0x0b61d, 0x0f06b, 0x0caab, 0x0c1be, 0x0e94c,
 0x0f099, 0x182ed, 0x0e94f, 0x0c119, 0x0e232, 0x2b4e4, 0x0f38a, 0x19eb4,
 0x1e25f, 0x0e94d, 0x000b7, 0x00785, 0x016cc, 0x03051, 0x033c4, 0x0656f,
 0x03891, 0x0711d, 0x0caaf, 0x0f097, 0x07489, 0x0f098, 0x0c880, 0x0caaa,
 0x0f386, 0x19eb7, 0x16c6f, 0x0f384, 0x182e8, 0x182e9, 0x0e230, 0x1e700,
 0x33d62, 0x33d63, 0x33d64, 0x16c33, 0x0e216, 0x000fd, 0x00c15, 0x01665,
 0x03c4a, 0x07f3b, 0x07896, 0x0c11c, 0x0e215, 0x16c32, 0x0f38b, 0x0f38d,
 0x182ea, 0x1e701, 0x712df, 0x15c46, 0x00194, 0x00fe0, 0x03f13, 0x0748b,
 0x0f096, 0x0cf80, 0x1e25e, 0xe25bd, 0x33d61, 0x16c31, 0x001f9, 0x01912,
 0x05710, 0x0f3d0, 0x0c1bf, 0x00301, 0x01e24, 0x0ad08, 0x003cd, 0x01c41,
 0x0c1bd, 0x00563, 0x03a52, 0x0f3d1, 0x00570, 0x02cce, 0x0e217, 0x0067b,
 0x0655d, 0x0074b, 0x06447, 0x00c12, 0x074fb, 0x00f08, 0x0b61c, 0x00e22,
 0x0fe43, 0x016c7, 0x01836, 0x019f2, 0x01c43, 0x01d3f, 0x01fcf, 0x02b4c,
 0x0304c, 0x032b6, 0x03a46, 0x05607, 0x03f17, 0x02cc5, 0x0609b, 0x0655c,
 0x07e23, 0x067c1, 0x07f26, 0x07f27, 0x0f095, 0x0e9f3, 0x0cf81, 0x0c11e,
 0x0caac, 0x0f38f, 0x0e9f2, 0x074fa, 0x0e236, 0x0fe45, 0x1c428, 0x0e235,
 0x182ef, 0x19eb5, 0x0f3d6, 0x182ec, 0x16c35, 0x0f38c, 0x2b4e7, 0x15c47,
 0xe25bc, 0x1e702, 0x1c4b6, 0x0e25a, 0x3c1aa, 0x15c45, 0x1c429, 0x19eb9,
 0x1e7af, 0x182eb, 0x1e0d4, 0x3896e,
};

static const uint8_t coef4_huffbits[476] = {
 12,  6,  2,  3,  4,  4,  5,  5,
  5,  6,  6,  6,  6,  6,  7,  7,
  7,  7,  7,  8,  8,  8,  8,  8,
  8,  9,  9,  9,  9,  9,  9,  9,
 10, 10, 10, 10, 10, 10, 10, 11,
 10, 11, 11, 11, 11, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 13, 13, 13, 13, 13, 13,
 13, 13, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 16, 16,
 16, 15, 15, 15, 15, 15, 16, 16,
 15, 16, 16, 17, 16, 16, 16, 17,
 18, 18, 17, 17, 17, 17, 17, 17,
 17, 17, 17,  4,  6,  7,  8,  8,
  8,  9,  9, 10, 10, 10, 10, 10,
 10, 11, 11, 11, 11, 11, 11, 11,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 13, 13, 13, 14, 13, 14, 14,
 14, 13, 13, 14, 14, 16, 16, 15,
 16, 16, 16, 15, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 17, 16, 16,
 16, 16, 17, 17, 17, 18, 16,  5,
  8,  9, 10, 10, 10, 11, 11, 12,
 12, 12, 12, 12, 12, 13, 13, 13,
 13, 13, 13, 13, 13, 14, 14, 13,
 14, 14, 13, 14, 14, 15, 14, 15,
 15, 15, 16, 15, 16, 16, 15, 15,
 15, 18, 18, 18, 17, 18, 17, 17,
  6,  9, 10, 11, 11, 12, 12, 13,
 13, 13, 13, 14, 14, 14, 14, 14,
 14, 14, 14, 15, 15, 15, 16, 15,
 15, 15, 15, 15, 15, 16, 16, 15,
 16, 16, 16, 16, 17, 18, 17, 16,
 16, 16,  7, 10, 11, 12, 12, 13,
 13, 14, 14, 14, 14, 15, 14, 15,
 15, 15, 16, 15, 15, 15, 15, 16,
 16, 16, 17, 16, 17, 16, 15, 16,
 16, 16, 16, 18, 17, 17, 19, 19,
 18, 16,  7, 11, 12, 13, 14, 14,
 15, 15, 16, 16, 15, 16, 16, 15,
 16, 16, 16, 16, 16, 16, 16, 17,
 16, 17, 17, 16, 17, 18, 16, 17,
 17, 17,  8, 11, 13, 14, 14, 15,
 15, 16, 16, 16, 16, 16, 16, 16,
 16, 17, 17, 16, 17, 17, 17, 17,
 18, 18, 18, 17, 17,  8, 12, 14,
 14, 15, 15, 16, 17, 17, 16, 16,
 17, 17, 20, 17,  9, 12, 14, 16,
 16, 16, 17, 21, 18, 17,  9, 13,
 15, 16, 16, 10, 13, 16, 10, 14,
 16, 11, 15, 16, 11, 15, 17, 11,
 15, 12, 15, 12, 16, 12, 16, 13,
 16, 13, 13, 13, 14, 14, 13, 14,
 14, 14, 15, 15, 14, 15, 15, 15,
 15, 15, 15, 15, 16, 17, 16, 16,
 16, 16, 17, 16, 17, 16, 18, 17,
 17, 17, 16, 17, 17, 16, 18, 17,
 21, 17, 18, 17, 18, 17, 18, 17,
 17, 17, 17, 19,
};

static const uint32_t coef5_huffcodes[435] = {
 0x00347, 0x0000b, 0x00001, 0x00001, 0x0000c, 0x00004, 0x00010, 0x00015,
 0x0001f, 0x0000b, 0x00023, 0x00026, 0x00029, 0x00035, 0x00037, 0x00001,
 0x00015, 0x0001a, 0x0001d, 0x0001c, 0x0001e, 0x0004e, 0x00049, 0x00051,
 0x00078, 0x00004, 0x00000, 0x00008, 0x0000d, 0x0007b, 0x00005, 0x00032,
 0x00095, 0x00091, 0x00096, 0x000a1, 0x000d9, 0x00003, 0x00019, 0x00061,
 0x00066, 0x00060, 0x00017, 0x0000e, 0x00063, 0x001a0, 0x001b7, 0x001e6,
 0x001e7, 0x001b6, 0x00018, 0x001e8, 0x00038, 0x00031, 0x00005, 0x0003d,
 0x00027, 0x001ea, 0x0001a, 0x000c5, 0x000f9, 0x000ff, 0x000db, 0x00250,
 0x000fc, 0x0025c, 0x00008, 0x00075, 0x003d7, 0x003d3, 0x001b0, 0x0007c,
 0x003ca, 0x00036, 0x00189, 0x004a6, 0x004a2, 0x004fb, 0x000c0, 0x0007f,
 0x0009a, 0x00311, 0x0006e, 0x0009b, 0x0068c, 0x006c0, 0x00484, 0x00012,
 0x000c3, 0x0094f, 0x00979, 0x009f9, 0x00d09, 0x00da6, 0x00da8, 0x00901,
 0x000c1, 0x00373, 0x00d08, 0x009fa, 0x00d8b, 0x00d85, 0x00d86, 0x000df,
 0x006e2, 0x000ce, 0x00f24, 0x009fe, 0x001f7, 0x007c1, 0x000cf, 0x009fc,
 0x009ff, 0x00d89, 0x00da9, 0x009fd, 0x001f8, 0x01a36, 0x0128c, 0x0129d,
 0x01a37, 0x00196, 0x003ea, 0x00f8b, 0x00d93, 0x01e45, 0x01e58, 0x01e4b,
 0x01e59, 0x013f1, 0x00309, 0x00265, 0x00308, 0x0243a, 0x027e1, 0x00f89,
 0x00324, 0x03cbc, 0x03c86, 0x03695, 0x0243c, 0x0243b, 0x0243e, 0x01e4a,
 0x003a5, 0x03468, 0x03428, 0x03c84, 0x027e0, 0x025e2, 0x01880, 0x00197,
 0x00325, 0x03cb7, 0x0791e, 0x007ec, 0x06c75, 0x004c8, 0x04bc7, 0x004c6,
 0x00983, 0x0481e, 0x01b53, 0x0251b, 0x01b58, 0x00984, 0x04fa8, 0x03cbb,
 0x00f8a, 0x00322, 0x0346a, 0x0243d, 0x00326, 0x03469, 0x0481f, 0x0481d,
 0x00746, 0x09032, 0x01b50, 0x01d13, 0x0d8e4, 0x0481b, 0x06c74, 0x0796b,
 0x07969, 0x00985, 0x0d8e3, 0x00986, 0x00fa2, 0x01301, 0x06c7c, 0x00987,
 0x03cb8, 0x0f4af, 0x00e88, 0x1b1c0, 0x00fce, 0x033eb, 0x03f6a, 0x03f69,
 0x00fcf, 0x0791f, 0x004c9, 0x04871, 0x00fcd, 0x00982, 0x00fcc, 0x00fa3,
 0x01d12, 0x0796c, 0x01b47, 0x00321, 0x0796a, 0x0d8e2, 0x04872, 0x04873,
 0x0000e, 0x00014, 0x0000a, 0x000a0, 0x00012, 0x0007d, 0x001a2, 0x0003b,
 0x0025f, 0x000dd, 0x0027c, 0x00343, 0x00368, 0x0036b, 0x0003e, 0x001fa,
 0x00485, 0x001b3, 0x0007f, 0x001b1, 0x0019e, 0x004ba, 0x007ad, 0x00339,
 0x00066, 0x007a4, 0x00793, 0x006c6, 0x0007e, 0x000f1, 0x00372, 0x009fb,
 0x00d83, 0x00d8a, 0x00947, 0x009f4, 0x001d0, 0x01b09, 0x01b4b, 0x007ec,
 0x003e1, 0x000ca, 0x003ec, 0x02539, 0x04fa9, 0x01b57, 0x03429, 0x03d2a,
 0x00d97, 0x003a7, 0x00dc0, 0x00d96, 0x00dc1, 0x007eb, 0x03cba, 0x00c43,
 0x00c41, 0x01b52, 0x007ef, 0x00323, 0x03cb9, 0x03c83, 0x007d0, 0x007ed,
 0x06c7f, 0x09033, 0x03f6c, 0x36383, 0x1e95d, 0x06c78, 0x00747, 0x01b51,
 0x00022, 0x00016, 0x00039, 0x00252, 0x00079, 0x00486, 0x00338, 0x00369,
 0x00d88, 0x00026, 0x00d87, 0x00f4b, 0x00d82, 0x00027, 0x001e1, 0x01a15,
 0x007c7, 0x012f0, 0x001e0, 0x006d0, 0x01a16, 0x01e44, 0x01e5f, 0x03690,
 0x00d90, 0x00c42, 0x00daf, 0x00d92, 0x00f80, 0x00cfb, 0x0342f, 0x0487f,
 0x01b46, 0x07968, 0x00d95, 0x00d91, 0x01b55, 0x03f68, 0x04bc6, 0x03cbd,
 0x00f81, 0x00320, 0x00069, 0x000fe, 0x006d5, 0x0033f, 0x000de, 0x007c6,
 0x01e40, 0x00d94, 0x00f88, 0x03c8e, 0x03694, 0x00dae, 0x00dad, 0x00267,
 0x003a6, 0x00327, 0x0487e, 0x007ee, 0x00749, 0x004c7, 0x03692, 0x01b56,
 0x00fd1, 0x07a56, 0x06c77, 0x09031, 0x00748, 0x06c7a, 0x0796d, 0x033ea,
 0x06c76, 0x00fd0, 0x36382, 0x1e417, 0x00745, 0x04faf, 0x0d8e1, 0x03f6b,
 0x1e95c, 0x04fad, 0x0009e, 0x004bd, 0x0067c, 0x01b08, 0x003eb, 0x01b45,
 0x03691, 0x0d8e5, 0x07904, 0x00981, 0x007ea, 0x019f4, 0x06c7d, 0x04fab,
 0x04fac, 0x06c7e, 0x01300, 0x06c7b, 0x0006f, 0x003f7, 0x03c85, 0x004c4,
 0x0001e, 0x006e1, 0x03693, 0x01b44, 0x00241, 0x01e46, 0x0019d, 0x00266,
 0x004bb, 0x02538, 0x007ac, 0x01b54, 0x00902, 0x04870, 0x00da7, 0x00900,
 0x00185, 0x06c79, 0x006e3, 0x003e9, 0x01e94, 0x003ed, 0x003f2, 0x0342e,
 0x0346b, 0x0251a, 0x004c5, 0x01881, 0x0481c, 0x01b59, 0x03c87, 0x04fae,
 0x007e9, 0x03f6d, 0x0f20a, 0x09030, 0x04faa, 0x0d8e6, 0x03f6f, 0x0481a,
 0x03f6e, 0x1e416, 0x0d8e7,
};

static const uint8_t coef5_huffbits[435] = {
 10,  4,  2,  4,  4,  5,  5,  5,
  5,  6,  6,  6,  6,  6,  6,  7,
  7,  7,  7,  7,  7,  7,  7,  7,
  7,  8,  8,  8,  8,  7,  8,  8,
  8,  8,  8,  8,  8,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9, 10,  9, 10, 10, 10, 10,
 10,  9, 10, 10, 10, 10, 10, 10,
 10, 10, 11, 11, 10, 10, 11, 11,
 10, 11, 11, 11, 11, 11, 12, 12,
 12, 12, 12, 12, 11, 11, 11, 12,
 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 13,
 13, 13, 12, 12, 13, 13, 13, 12,
 12, 12, 12, 12, 13, 13, 13, 13,
 13, 14, 14, 14, 14, 13, 13, 13,
 13, 13, 14, 14, 14, 14, 14, 14,
 15, 14, 14, 14, 14, 14, 14, 13,
 14, 14, 14, 14, 14, 14, 15, 14,
 15, 14, 15, 15, 15, 15, 15, 15,
 16, 15, 15, 14, 15, 16, 15, 14,
 14, 15, 14, 14, 15, 14, 15, 15,
 15, 16, 15, 17, 16, 15, 15, 15,
 15, 16, 16, 16, 16, 17, 15, 16,
 14, 16, 16, 17, 16, 16, 16, 16,
 16, 15, 15, 15, 16, 16, 16, 16,
 17, 15, 15, 15, 15, 16, 15, 15,
  4,  7,  8,  8,  9,  9,  9, 10,
 10, 10, 10, 10, 10, 10, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 12,
 12, 11, 11, 11, 12, 12, 12, 12,
 12, 12, 12, 12, 13, 13, 13, 13,
 12, 13, 14, 14, 15, 15, 14, 14,
 14, 14, 14, 14, 14, 15, 14, 14,
 14, 15, 15, 15, 14, 14, 15, 15,
 15, 16, 16, 18, 17, 15, 15, 15,
  6,  9, 10, 10, 11, 11, 12, 12,
 12, 13, 12, 12, 12, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 14,
 14, 14, 14, 14, 14, 14, 14, 15,
 15, 15, 14, 14, 15, 16, 15, 14,
 14, 15,  7, 10, 11, 12, 13, 13,
 13, 14, 14, 14, 14, 14, 14, 14,
 14, 15, 15, 15, 15, 15, 14, 15,
 16, 15, 15, 16, 15, 15, 15, 16,
 15, 16, 18, 17, 15, 15, 16, 16,
 17, 15,  8, 11, 13, 13, 14, 15,
 14, 16, 15, 16, 15, 15, 15, 15,
 15, 15, 17, 15,  9, 12, 14, 15,
 10, 13, 14, 15, 10, 13, 11, 14,
 11, 14, 11, 15, 12, 15, 12, 12,
 13, 15, 13, 14, 13, 14, 14, 14,
 14, 14, 15, 15, 15, 15, 14, 15,
 15, 16, 16, 16, 15, 16, 16, 15,
 16, 17, 16,
};

static const uint16_t levels0[60] = {
317, 92, 62, 60, 19, 17, 10,  7,
  6,  5,  5,  3,  3,  3,  2,  2,
  2,  2,  2,  2,  2,  1,  2,  2,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,
};

static const uint16_t levels1[40] = {
311, 91, 61, 28, 10,  6,  5,  2,
  2,  2,  2,  2,  2,  2,  2,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
};

static const uint16_t levels2[340] = {
181,110, 78, 63, 61, 62, 60, 61,
 33, 41, 41, 19, 17, 19, 12, 11,
  9, 11, 10,  6,  8,  7,  6,  4,
  5,  5,  4,  4,  3,  4,  3,  5,
  3,  4,  3,  3,  3,  3,  3,  3,
  2,  2,  4,  2,  3,  2,  3,  3,
  2,  2,  2,  2,  2,  2,  2,  2,
  3,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  1,  2,  1,  2,  2,
  2,  2,  1,  2,  1,  1,  1,  2,
  2,  1,  2,  1,  2,  2,  2,  2,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,
};

static const uint16_t levels3[180] = {
351,122, 76, 61, 41, 42, 24, 30,
 22, 19, 11,  9, 10,  8,  5,  5,
  4,  5,  5,  3,  3,  3,  3,  3,
  3,  3,  2,  2,  3,  2,  2,  2,
  3,  3,  2,  2,  2,  3,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  1,  1,
  2,  2,  1,  2,  1,  2,  2,  2,
  2,  2,  2,  1,  2,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  2,
  2,  1,  2,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,
};

static const uint16_t levels4[70] = {
113, 68, 49, 42, 40, 32, 27, 15,
 10,  5,  3,  3,  3,  3,  2,  2,
  2,  2,  2,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,
};

static const uint16_t levels5[40] = {
214, 72, 42, 40, 18,  4,  4,  2,
  2,  2,  2,  2,  1,  1,  2,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,
};

static const CoefVLCTable coef_vlcs[6] = {
    {
        sizeof(coef0_huffbits), coef0_huffcodes, coef0_huffbits, levels0,
    },
    {
        sizeof(coef1_huffbits), coef1_huffcodes, coef1_huffbits, levels1,
    },
    {
        sizeof(coef2_huffbits), coef2_huffcodes, coef2_huffbits, levels2,
    },
    {
        sizeof(coef3_huffbits), coef3_huffcodes, coef3_huffbits, levels3,
    },
    {
        sizeof(coef4_huffbits), coef4_huffcodes, coef4_huffbits, levels4,
    },
    {
        sizeof(coef5_huffbits), coef5_huffcodes, coef5_huffbits, levels5,
    },
};

/*table of the values of 10^(index*.05)*/
const int64_t pow_table[] =
    {   0x199a, 0x1cb9, 0x203a, 0x2429, 0x2893, 0x2d86, 0x3314, 0x3950, 0x404e,
        0x4827, 0x50f4, 0x5ad5, 0x65ea, 0x725a, 0x804e, 0x8ff6, 0xa186, 0xb53c,
        0xcb59, 0xe429, 0x10000LL,0x11f3dLL,0x14249LL,0x1699cLL,0x195bcLL,
        0x1c73dLL,0x1fec9LL,0x23d1dLL,0x2830bLL,0x2d182LL, 0x3298bLL,0x38c53LL,
        0x3fb28LL,0x47783LL,0x5030aLL,0x59f98LL,0x64f40LL,0x71457LL,0x7f17bLL,
        0x8e99aLL,0xa0000LL,0xb385eLL,0xc96d9LL,0xe2019LL,0xfd954LL,0x11c865LL,
        0x13f3dfLL,0x166320LL,0x191e6eLL,0x1c2f10LL,0x1f9f6eLL,0x237b39LL,
        0x27cf8bLL,0x2cab1aLL,0x321e65LL,0x383bf0LL,0x3f1882LL,0x46cb6aLL,
        0x4f6eceLL,0x592006LL,0x640000LL,0x7033acLL,0x7de47eLL,0x8d40f6LL,
        0x9e7d44LL,0xb1d3f4LL,0xc786b7LL,0xdfdf43LL,0xfb304bLL,0x119d69aLL,
        0x13c3a4eLL,0x162d03aLL,0x18e1b70LL,0x1beaf00LL,0x1f52feeLL,
        0x2325760LL,0x276f514LL,0x2c3f220LL,0x31a5408LL,0x37b403cLL,0x3e80000LL,
        0x46204b8LL,0x4eaece8LL,0x58489a0LL,0x630e4a8LL,0x6f24788LL,0x7cb4328LL,
        0x8beb8a0LL,0x9cfe2f0LL,0xb026200LL,0xc5a4710LL,0xddc2240LL,0xf8d1260LL,
        0x1172d600LL,0x1393df60LL,0x15f769c0LL,0x18a592c0LL,0x1ba77540LL,
        0x1f074840LL,0x22d08280LL,0x27100000LL,0x2bd42f40LL,0x312d4100LL,
        0x372d6000LL,0x3de8ee80LL,0x4576cb80LL,0x4df09f80LL,0x57733600LL,
        0x621edd80LL,0x6e17d480LL,0x7b86c700LL,0x8a995700LL,0x9b82b800LL,
        0xae7c5c00LL,0xc3c6b900LL,0xdbaa2200LL,0xf677bc00LL,0x1148a9400LL,
        0x13648d200LL,0x15c251800LL,0x186a00000LL,0x1b649d800LL,0x1ebc48a00LL,
        0x227c5c000LL,0x26b195000LL,0x2b6a3f000LL,0x30b663c00LL,0x36a801c00LL,
        0x3d534a400LL,0x44cee4800LL,0x4d343c800LL,0x569fd6000LL,0x6131b2800LL,
        0x6d0db9800LL,0x7a5c33800LL,0x894a55000LL,0x9a0ad6000LL,0xacd69d000LL,
        0xc1ed84000LL,0xd9972f000LL,0xf42400000LL,0x111ee28000LL,0x1335ad6000LL,
        0x158db98000LL,0x182efd4000LL,0x1b22676000LL,0x1e71fe6000LL,
        0x2229014000LL,0x26540e8000LL,0x2b014f0000LL,0x3040a5c000LL,
        0x3623e60000LL,0x3cbf0fc000LL,0x4428940000LL,0x4c79a08000LL,
        0x55ce758000LL,0x6046c58000LL,0x6c06220000LL,0x7934728000LL,
        0x87fe7d0000LL,0x9896800000LL,0xab34d90000LL,0xc018c60000LL,
        0xd7893f0000LL,0xf1d5e40000LL,0x10f580a0000LL,0x13073f00000LL,
        0x1559a0c0000LL,0x17f48900000LL,0x1ae0d160000LL,0x1e286780000LL,
        0x21d66fc0000LL,0x25f769c0000LL,0x2a995c80000LL,0x2fcc0440000LL,
        0x35a10940000LL,0x3c2c3b80000LL,0x4383d500000LL,0x4bc0c780000LL,
        0x54ff0e80000LL,0x5f5e1000000LL,0x6b010780000LL,0x780f7c00000LL,
        0x86b5c800000LL,0x9725ae00000LL,0xa9970600000LL,0xbe487500000LL,
        0xd5804700000LL,0xef8d5a00000LL,0x10cc82e00000LL,0x12d940c00000LL,
        0x152605c00000LL,0x17baa2200000LL,0x1a9fd9c00000LL,0x1ddf82a00000LL,
        0x2184a5c00000LL,0x259ba5400000LL,0x2a3265400000LL,0x2f587cc00000LL,
        0x351f69000000LL,0x3b9aca000000LL,0x42e0a4800000LL,0x4b09ad800000LL,
        0x54319d000000LL,0x5e778d000000LL,0x69fe64000000LL,0x76ed49800000LL,
        0x85702c000000LL,0x95b858000000LL,0xa7fd1c000000LL,0xbc7c87000000LL,
        0xd37c3a000000LL,0xed4a55000000LL,0x10a3e82000000LL,0x12abb1a000000LL,
        0x14f2e7a000000LL,0x1781474000000LL,0x1a5f7f4000000LL,0x1d974de000000LL,
        0x2133a18000000LL
    };

/*  10^(index/16).  We'll need to accomidate negative indicies too.
    The algorithm sort of implies that there should be 128 values starting at -60,
    however this has not been confirmed.  More values may be needed.
*/
const int32_t pow_10_to_yover16[] ICONST_ATTR=
{
    /*60 negative indicies (-60 to -1)*/
    0xc, 0xd, 0x10, 0x12, 0x15, 0x18, 0x1c, 0x20, 0x25, 0x2b, 0x31, 0x39, 0x42,
    0x4c, 0x57, 0x65, 0x75, 0x87, 0x9b, 0xb3, 0xcf, 0xef, 0x114, 0x13f, 0x171, 
    0x1aa, 0x1eb, 0x238, 0x28f, 0x2f5, 0x36a, 0x3f1, 0x48d, 0x542, 0x612, 0x703,
    0x818, 0x959, 0xacc, 0xc77, 0xe65, 0x10a0, 0x1333, 0x162b, 0x199a, 0x1d90, 
    0x2223, 0x276c, 0x2d86, 0x3492, 0x3cb5, 0x461b, 0x50f4, 0x5d7c, 0x6bf4, 
    0x7caa, 0x8ff6, 0xa63e, 0xbff9, 0xddb0,
    /*non-negative indicies (0-68)*/
    0x10000, 0x127a0, 0x15562, 0x18a39, 0x1c73d, 0x20db4, 0x25f12, 0x2bd09, 
    0x3298b, 0x3a6d9, 0x4378b, 0x4dea3, 0x59f98, 0x67e6b, 0x77fbb, 0x8a8de, 
    0xa0000, 0xb8c3e, 0xd55d1, 0xf6636, 0x11c865, 0x148906, 0x17b6b7, 0x1b625b,
    0x1f9f6e, 0x248475, 0x2a2b6e, 0x30b25e, 0x383bf0, 0x40f02b, 0x4afd4b, 
    0x5698b0, 0x640000, 0x737a6b, 0x855a26, 0x99fe1e, 0xb1d3f4, 0xcd5a3e, 
    0xed232b, 0x111d78b, 0x13c3a4f, 0x16d2c94, 0x1a5b24e, 0x1e6f7b0, 0x2325761,
    0x28961b3, 0x2ede4eb, 0x361f6de, 0x3e80000, 0x482c830, 0x535857d, 0x603ed31,
    0x6f24787, 0x8058668, 0x9435fab, 0xab26b6d, 0xc5a4715, 0xe43bdc4, 
    0x1078f70c, 0x1305acdd, 0x15f769cb, 0x195dd0fa, 0x1d4af12d, 0x21d3a4ab, 
    0x27100000, 0x2d1bd1e1, 0x341736de, 0x3c2743e8, 0x4576cb4a
};

const int32_t pow_a_table[] =
{
    0x1004,0x1008,0x100c,0x1010,0x1014,0x1018,0x101c,0x1021,0x1025,0x1029,0x102d,
    0x1031,0x1036,0x103a,0x103e,0x1043,0x1047,0x104b,0x1050,0x1054,0x1059,0x105d,
    0x1062,0x1066,0x106b,0x106f,0x1074,0x1078,0x107d,0x1082,0x1086,0x108b,0x1090,
    0x1095,0x1099,0x109e,0x10a3,0x10a8,0x10ad,0x10b2,0x10b7,0x10bc,0x10c1,0x10c6,
    0x10cb,0x10d0,0x10d5,0x10da,0x10df,0x10e5,0x10ea,0x10ef,0x10f5,0x10fa,0x10ff,
    0x1105,0x110a,0x1110,0x1115,0x111b,0x1120,0x1126,0x112c,0x1131,0x1137,0x113d,
    0x1143,0x1149,0x114f,0x1155,0x115a,0x1161,0x1167,0x116d,0x1173,0x1179,0x117f,
    0x1186,0x118c,0x1192,0x1199,0x119f,0x11a6,0x11ac,0x11b3,0x11b9,0x11c0,0x11c7,
    0x11ce,0x11d4,0x11db,0x11e2,0x11e9,0x11f0,0x11f8,0x11ff,0x1206,0x120d,0x1215,
    0x121c,0x1223,0x122b,0x1233,0x123a,0x1242,0x124a,0x1251,0x1259,0x1261,0x1269,
    0x1271,0x127a,0x1282,0x128a,0x1293,0x129b,0x12a4,0x12ac,0x12b5,0x12be,0x12c7,
    0x12d0,0x12d9,0x12e2,0x12eb,0x12f4,0x12fe,0x1307
};


/* 32.32 unsigned fixed format */
/* This is a table of exponent values for an IEEE SP float.  Theres never anything less then about index 115
 * making the size of this table fairly ridiculous.
 */
const int64_t lsp_pow_e_table[] =
{
    0xb504f30000000000LL, 0x9837f00000000000LL, 0x8000000000000000LL, 0x6ba27e8000000000LL, 0x5a82798000000000LL,
    0x4c1bf80000000000LL, 0x4000000000000000LL, 0x35d13f4000000000LL, 0x2d413cc000000000LL, 0x260dfc0000000000LL,
    0x2000000000000000LL, 0x1ae89fa000000000LL, 0x16a09e6000000000LL, 0x1306fe0000000000LL, 0x1000000000000000LL,
    0xd744fd000000000LL, 0xb504f3000000000LL, 0x9837f0000000000LL, 0x800000000000000LL, 0x6ba27e800000000LL,
    0x5a8279800000000LL, 0x4c1bf8000000000LL, 0x400000000000000LL, 0x35d13f400000000LL, 0x2d413cc00000000LL,
    0x260dfc000000000LL, 0x200000000000000LL, 0x1ae89fa00000000LL, 0x16a09e600000000LL, 0x1306fe000000000LL,
    0x100000000000000LL, 0xd744fd00000000LL, 0xb504f300000000LL, 0x9837f000000000LL, 0x80000000000000LL,
    0x6ba27e80000000LL, 0x5a827980000000LL, 0x4c1bf800000000LL, 0x40000000000000LL, 0x35d13f40000000LL,
    0x2d413cc0000000LL, 0x260dfc00000000LL, 0x20000000000000LL, 0x1ae89fa0000000LL, 0x16a09e60000000LL,
    0x1306fe00000000LL, 0x10000000000000LL, 0xd744fd0000000LL, 0xb504f30000000LL, 0x9837f00000000LL,
    0x8000000000000LL, 0x6ba27e8000000LL, 0x5a82798000000LL, 0x4c1bf80000000LL, 0x4000000000000LL,
    0x35d13f4000000LL, 0x2d413cc000000LL, 0x260dfc0000000LL, 0x2000000000000LL, 0x1ae89fa000000LL,
    0x16a09e6000000LL, 0x1306fe0000000LL, 0x1000000000000LL, 0xd744fd000000LL, 0xb504f3000000LL,
    0x9837f0000000LL, 0x800000000000LL, 0x6ba27e800000LL, 0x5a8279800000LL, 0x4c1bf8000000LL,
    0x400000000000LL, 0x35d13f400000LL, 0x2d413cc00000LL, 0x260dfc000000LL, 0x200000000000LL,
    0x1ae89fa00000LL, 0x16a09e600000LL, 0x1306fe000000LL, 0x100000000000LL, 0xd744fd00000LL,
    0xb504f300000LL, 0x9837f000000LL, 0x80000000000LL, 0x6ba27e80000LL, 0x5a827980000LL,
    0x4c1bf800000LL, 0x40000000000LL, 0x35d13f40000LL, 0x2d413cc0000LL, 0x260dfc00000LL,
    0x20000000000LL, 0x1ae89fa0000LL, 0x16a09e60000LL, 0x1306fe00000LL, 0x10000000000LL,
    0xd744fd0000LL, 0xb504f30000LL, 0x9837f00000LL, 0x8000000000LL, 0x6ba27e8000LL,
    0x5a82798000LL, 0x4c1bf80000LL, 0x4000000000LL, 0x35d13f4000LL, 0x2d413cc000LL,
    0x260dfc0000LL, 0x2000000000LL, 0x1ae89fa000LL, 0x16a09e6000LL, 0x1306fe0000LL,
    0x1000000000LL, 0xd744fd000LL, 0xb504f3000LL, 0x9837f0000LL, 0x800000000LL,
    0x6ba27e800LL, 0x5a8279800LL, 0x4c1bf8000LL, 0x400000000LL, 0x35d13f400LL,
    0x2d413cc00LL, 0x260dfc000LL, 0x200000000LL, 0x1ae89fa00LL, 0x16a09e600LL,
    0x1306fe000LL, 0x100000000LL, 0xd744fd00LL, 0xb504f300LL, 0x9837f000LL,
    0x80000000LL, 0x6ba27e80LL, 0x5a827980LL, 0x4c1bf800LL, 0x40000000LL,
    0x35d13f40LL, 0x2d413cc0LL, 0x260dfc00LL, 0x20000000LL, 0x1ae89fa0LL,
    0x16a09e60LL, 0x1306fe00LL, 0x10000000LL, 0xd744fd0LL, 0xb504f30LL,
    0x9837f00LL, 0x8000000LL, 0x6ba27e8LL, 0x5a82798LL, 0x4c1bf80LL,
    0x4000000LL, 0x35d13f4LL, 0x2d413ccLL, 0x260dfc0LL, 0x2000000LL,
    0x1ae89faLL, 0x16a09e6LL, 0x1306fe0LL, 0x1000000LL, 0xd744fdLL,
    0xb504f3LL, 0x9837f0LL, 0x800000LL, 0x6ba27eLL, 0x5a8279LL,
    0x4c1bf8LL, 0x400000LL, 0x35d13fLL, 0x2d413cLL, 0x260dfcLL,
    0x200000LL, 0x1ae89fLL, 0x16a09eLL, 0x1306feLL, 0x100000LL,
    0xd744fLL, 0xb504fLL, 0x9837fLL, 0x80000LL, 0x6ba27LL,
    0x5a827LL, 0x4c1bfLL, 0x40000LL, 0x35d13LL, 0x2d413LL,
    0x260dfLL, 0x20000LL, 0x1ae89LL, 0x16a09LL, 0x1306fLL,
    0x10000LL, 0xd744LL, 0xb504LL, 0x9837LL, 0x8000LL,
    0x6ba2LL, 0x5a82LL, 0x4c1bLL, 0x4000LL, 0x35d1LL,
    0x2d41LL, 0x260dLL, 0x2000LL, 0x1ae8LL, 0x16a0LL,
    0x1306LL, 0x1000LL, 0xd74LL, 0xb50LL, 0x983LL,
    0x800LL, 0x6baLL, 0x5a8LL, 0x4c1LL, 0x400LL,
    0x35dLL, 0x2d4LL, 0x260LL, 0x200LL, 0x1aeLL,
    0x16aLL, 0x130LL, 0x100LL, 0xd7LL, 0xb5LL,
    0x98LL, 0x80LL, 0x6bLL, 0x5aLL, 0x4cLL,
    0x40LL, 0x35LL, 0x2dLL, 0x26LL, 0x20LL,
    0x1aLL, 0x16LL, 0x13LL, 0x10LL, 0xdLL,
    0xbLL, 0x9LL, 0x8LL, 0x6LL, 0x5LL,
    0x4LL, 0x4LL, 0x3LL, 0x2LL, 0x2LL,
    0x2LL, 0x1LL, 0x1LL, 0x1LL, 0x1LL,
    0x0LL
};

/* table of exp noise values multiplied by 16 in order to reduce rounding error */
int32_t noisetable_exp[] =
{
    0x5, 0xfffffa2e, 0xc2c, 0xb47, 0xffffaebe, 0xfffffa63, 0xfffff7ff, 0x16bd,
    0xffffe704, 0xffffe34e, 0x71ee, 0x396e, 0xffff8bfd, 0x3b4, 0x562f, 0xffffc362,
    0x5327, 0xffffae19, 0x6cb4, 0x26b0, 0x87c4, 0x21dc, 0x8017, 0x1db0,
    0xffffe49e, 0xffffb162, 0xffffc808, 0xffffafea, 0xfffffe80, 0xfffffeb8, 0xffff8b6e, 0xffffc7a1,
    0x3f46, 0x5e8, 0x374f, 0xffff8fba, 0x87fd, 0x21e7, 0xffff9198, 0x78a0,
    0x7f7c, 0x864f, 0xffffca94, 0x42a7, 0xfffffcd6, 0xffffb916, 0x247a, 0x5679,
    0x8d9f, 0xffffb350, 0xffff9592, 0xffffcf73, 0x552d, 0xffffeb8c, 0x8622, 0xffff8091,
    0x238, 0x3ee8, 0x5c2f, 0x6e25, 0xffffe5cb, 0x86a1, 0xffffa8ca, 0xfe2,
    0x5dac, 0x2da2, 0x5ad1, 0xffffa94f, 0x729, 0xfffffdc0, 0xffff825c, 0x8bcd,
    0xffff7d05, 0xffff7d9e, 0xffffb5b6, 0x58a3, 0xffff8a3f, 0xffffd9c0, 0xffff8142, 0x596f,
    0x78aa, 0x2694, 0x78f5, 0xffff8a84, 0x43b3, 0x498a, 0xffffdfe5, 0xffffbba9,
    0xffff7228, 0xffff72c9, 0xfffff174, 0xffff9a76, 0x64d5, 0x221c, 0x88dd, 0xffffd319,
    0xfffffe14, 0xfffff99f, 0xffff8ba4, 0x6e34, 0x6cc, 0x3208, 0xfffffb14, 0x6670,
    0xffffd5ff, 0xffffa502, 0x641d, 0xffff75b6, 0xec2, 0xffffedf2, 0xffffb925, 0xffffe271,
    0xffffb727, 0xffff7450, 0xfffff421, 0x89e7, 0xfffff635, 0xffffa841, 0xffffda00, 0xffffc94e,
    0xef9, 0x28cc, 0xffffd477, 0xffff82b9, 0x2a7, 0xffff7540, 0x24c2, 0x4349,
    0xffffdf34, 0xdf7, 0x323d, 0xffffbce7, 0x29c5, 0x4700, 0x10b0, 0x1eb6,
    0x1172, 0x84be, 0xffffcee4, 0xffffe7bd, 0x1166, 0xffff7df0, 0xffffe115, 0x2383,
    0x23a0, 0x784a, 0x6f8e, 0xffff9043, 0x2b66, 0xffffc79e, 0xffff8966, 0xffffbfac,
    0x5fb1, 0xffffb183, 0x3602, 0x3d19, 0xffff7df4, 0x3ffe, 0xffffc919, 0x5ac7,
    0xffffa3e8, 0xfffff2ea, 0x47b9, 0xffffe344, 0x12f0, 0xffffc4e8, 0xfffff3fc, 0xffffcacd,
    0xffffd23b, 0x893a, 0x5e82, 0xffff8d36, 0x50e0, 0x49a6, 0x29dd, 0x16fa,
    0x451d, 0x8315, 0xffffe455, 0x749, 0x8624, 0x2fe5, 0x3ab5, 0xffffb4f1,
    0x72d, 0xffffccdf, 0x2b05, 0xffffa816, 0xffff9570, 0xffffd2e7, 0xffffa6ac, 0x2fc2,
    0xae4, 0x4c93, 0xfffffce1, 0xffffdb9f, 0x8102, 0x6bb1, 0xffffd5bf, 0xffff80e0,
    0xffffd70e, 0x568f, 0xc12, 0xffff9823, 0x700c, 0xffffa1aa, 0xffffa86c, 0xffffd303,
    0xffffbe7a, 0x38c9, 0xffff9f18, 0xffffcd7a, 0xffff8d75, 0x6955, 0xffffe70a, 0xffffbf49,
    0xffffc423, 0x31f, 0xffffe44a, 0x118a, 0xffffebfa, 0xffffedec, 0xffffee42, 0xffffd865,
    0xffff9b30, 0xffff8759, 0xffff827c, 0xffffbc26, 0xfffffb02, 0xffff8bee, 0xffffe6c2, 0x72f3,
    0xffffc2c9, 0xffff74ff, 0x2434, 0x1eb4, 0x11c9, 0x61c1, 0xffffa964, 0x89a3,
    0x6a43, 0x3d7f, 0xffffd09f, 0x14d8, 0x37bc, 0xfffffc31, 0xffffdb03, 0xfffff4e1,
    0x5547, 0xffffdc87, 0xffff929a, 0x73cc, 0x246f, 0x194e, 0xffffb4ce, 0x86b5,
    0x2f57, 0x7f05, 0x252b, 0xffff9b05, 0x5b7a, 0x164, 0x57cf, 0x7f86,
    0x5421, 0xffffa478, 0xffffbbda, 0x1b3c, 0xfffff4cb, 0xffffda7e, 0x5d8e, 0x1957,
    0xffffb3a7, 0x1979, 0xffff8ddd, 0xffffd7b9, 0xfffff028, 0xffff8c90, 0x476a, 0x6be6,
    0x419e, 0xfffffd2d, 0x8294, 0xffffc931, 0xffffe1ab, 0xffffdd4f, 0x46f0, 0x1930,
    0x4e5e, 0x8429, 0xffffde0a, 0xffff8e69, 0x2972, 0x387f, 0x3dd8, 0xffffbcc6,
    0x121b, 0x6d3d, 0x1fa4, 0xffffa3ea, 0xffffbbef, 0xffffcbd2, 0xffffbe04, 0xffffb424,
    0xffff7533, 0x70cd, 0x2370, 0x4822, 0xffff756e, 0xffffbe8c, 0x4131, 0x1ead,
    0x47de, 0xffffed53, 0xffff917e, 0x5f93, 0xffffe264, 0xffffde05, 0xffff9dc3, 0xffffc1d9,
    0xffff9b25, 0x3ade, 0xfffff9b7, 0xffffac80, 0x239e, 0xffffb980, 0xffffc9a4, 0x788c,
    0xffffbb6d, 0x3bb7, 0x6483, 0xffffeac0, 0x25ea, 0xffffbdfc, 0x333d, 0x8c0d,
    0x6d9a, 0xffffafe8, 0xffff8a74, 0x6067, 0xffff8642, 0x1a64, 0xfffff921, 0x3f3b,
    0xae4, 0x5112, 0x43a4, 0x1573, 0xffffc977, 0xffffa3b4, 0x21be, 0xffff96df,
    0xfffff035, 0x473b, 0xffff8d26, 0xb75, 0xffffecdc, 0x4455, 0x47d5, 0xffff7581,
    0xeca, 0xffffb3fe, 0xffff9f6a, 0xffffea15, 0xffffb9c3, 0x5516, 0xffffb654, 0x7f91,
    0x80b, 0xffff96b7, 0x2b60, 0x36b7, 0xffffc581, 0x285b, 0xffffa002, 0xffffc7e5,
    0x4965, 0xffff94d4, 0xffff764b, 0x1cd2, 0x5599, 0xffffd272, 0xffffcbfb, 0xffffae6d,
    0xffffd496, 0x3183, 0xffffe4f5, 0xffffa59f, 0x43df, 0x4569, 0xffffb185, 0x1d56,
    0xffff933a, 0xffff7a2c, 0x38d0, 0xffffb815, 0x5203, 0xfffffd89, 0xffff93ea, 0xffffa4dd,
    0x1f13, 0xffffad7d, 0xffffff4f, 0xffffe13c, 0xffffd60a, 0x8c88, 0x8276, 0xffffeaaf,
    0xffff8a66, 0xffff7888, 0xffff91e9, 0x8bdf, 0xdcf, 0xfffff282, 0xffffe91b, 0x1eb1,
    0x6fc, 0xffff81f6, 0x1617, 0xffffad02, 0xffffafaf, 0x60d5, 0x6f2b, 0x4e8b,
    0x2347, 0x3257, 0x29cf, 0x86c4, 0x75b3, 0x7745, 0xfffffcc7, 0x49cd,
    0x558f, 0xffff7c7a, 0x52e1, 0xffff7626, 0x7690, 0xffffb357, 0xffff7dbf, 0xffffa1ee,
    0xffffa874, 0xffff846f, 0xffffab72, 0x5cef, 0xffffb0cf, 0xffff8c24, 0xffff8e10, 0xffffe200,
    0x2a45, 0xfffff883, 0x5155, 0x37c9, 0xad6, 0x1ed9, 0x79e2, 0x1f4c,
    0x45f8, 0x48ec, 0xffffa331, 0x34a1, 0xffffc7b0, 0x2eb5, 0x5dc, 0x4cdd,
    0x4e5c, 0xffffa7c7, 0x3b08, 0x2776, 0x2e1a, 0x788d, 0x162b, 0x1fa7,
    0x466c, 0x5ca2, 0xfffff3ac, 0xffffa62f, 0xfffffd4c, 0x5f48, 0x779, 0x2a5e,
    0xffffe14e, 0x196, 0xffffaba1, 0x404c, 0xffffdc5b, 0x238f, 0x274, 0xffffa5c6,
    0xffff9e2b, 0x6201, 0xfffff195, 0xfffff3b0, 0x2285, 0xffffc7f0, 0xffffdff4, 0xffffc43d,
    0xffffac57, 0xffffb7a6, 0xffffe88c, 0xffffd3ac, 0xffffbb5c, 0x2cbd, 0x44d6, 0x5e30,
    0xffffeb53, 0x6d8b, 0xffff7f8b, 0xffff99a3, 0xffff7a4e, 0xffffbc82, 0x6a49, 0xfffff220,
    0xffffeaca, 0x4146, 0x8d72, 0xffffdcb7, 0xffffe2f3, 0xfffff736, 0x557f, 0x13fd,
    0x66a, 0x5d9, 0x29ee, 0xffffda1e, 0xd38, 0xffffe70f, 0xffffbbd7, 0xffffe1ee,
    0x4a0d, 0x502e, 0xffff8c37, 0xffffaccc, 0xffffdd0b, 0xffff7401, 0x3a89, 0x73b4,
    0x71b7, 0x5b43, 0xffff9baf, 0x4d76, 0x25f, 0x7f97, 0xffffcb71, 0x6b4c,
    0xffffe999, 0x3fd5, 0xffffd40b, 0x3f0d, 0xffffc17b, 0x3de9, 0x87f7, 0x6446,
    0x5be, 0xffffd88a, 0x7d05, 0xfffffe16, 0x467e, 0x1454, 0xffffca4e, 0xffffa047,
    0xffff92ac, 0xffffddc9, 0x72a9, 0xffffc902, 0x3605, 0xe47, 0x280c, 0x7662,
    0x609d, 0xffffae0a, 0x78e0, 0xffffa02a, 0x1c87, 0xfffff91b, 0xffff7792, 0xffff745e,
    0xffff8097, 0xffff8583, 0xffffe7e4, 0x61a5, 0x36a8, 0x7fe7, 0xffffaecc, 0xffff90f7,
    0x5ad9, 0x7e2f, 0xffffffca, 0x75c7, 0x7134, 0xffffd7fe, 0x3c22, 0x314c,
    0x7c97, 0x2068, 0xffff7926, 0x3e7c, 0x6926, 0x67f9, 0x3e28, 0x7c65,
    0x76b9, 0x25cf, 0x1039, 0xffffdf97, 0x8779, 0xffffe8fd, 0xffff9f74, 0x770a,
    0x8a50, 0xffffd241, 0xffffddee, 0x5aab, 0xffffc97f, 0x4572, 0x3276, 0xffffe7ec,
    0xffff8cc2, 0x6331, 0xfffffedf, 0x3b86, 0x3038, 0xffffd628, 0x2645, 0xffff737c,
    0x72fe, 0xffff8474, 0x23fb, 0x78f, 0x194c, 0x95a, 0xffff91d0, 0xffff8014,
    0x56e9, 0x2efe, 0xffffae5b, 0x614, 0xffffca3d, 0xffffd77e, 0x73e1, 0x35f7,
    0x71f3, 0xffff9279, 0xffffe6f3, 0x404b, 0x548d, 0x32a3, 0xc11, 0x637a,
    0xffff7605, 0x2ba8, 0xffff8f35, 0x8157, 0x423f, 0xffff9711, 0xffffb980, 0xffffb4b1,
    0x3494, 0xffffc9dd, 0x6c43, 0x563f, 0x52c, 0xffff9680, 0x8b7a, 0xffffcf49,
    0xffffa40b, 0x6daf, 0xffff840e, 0x29cd, 0xffffbf5c, 0x68b7, 0xffffedf3, 0xffffe329,
    0xfffff634, 0x8619, 0x33bc, 0x28b4, 0x5ed8, 0xffffcfbb, 0x883a, 0xfffffdf6,
    0xffffb980, 0x7bac, 0xfffffd6d, 0x418f, 0x4a25, 0xffffbed3, 0x4272, 0xffffef42,
    0x800f, 0x78e3, 0x82c8, 0x24e1, 0xffffcfa3, 0xffffb385, 0x86b, 0x645b,
    0x38aa, 0x6a22, 0xffffc21b, 0x60f0, 0x9b6, 0x912, 0x7621, 0xffff94cc,
    0xffffd5c9, 0xfffffdb5, 0xffffd93a, 0x2a11, 0xffff8b3d, 0xffffc0d2, 0xffffa00f, 0xffffe965,
    0xfffffa0f, 0xffffbfa9, 0x5e78, 0xffff925b, 0xffffeac8, 0xffffd5af, 0xffffba37, 0x395a,
    0xffffdc75, 0xfffffdf2, 0xffff7c7b, 0xffff89a3, 0x3766, 0xffffe8a9, 0x7118, 0x399e,
    0xffff7ff5, 0xffffac9a, 0xffff7d74, 0xffffa5d2, 0x4c27, 0x787f, 0x586, 0x7ce4,
    0xffffb38e, 0xffffb93d, 0x240d, 0x5a90, 0xffffb448, 0xffff8e29, 0xffffbc06, 0x3bf3,
    0xffffda90, 0xffffb78d, 0xffffc747, 0xffffa5c0, 0xffffe2dd, 0x7fbd, 0x8946, 0xffff8d50,
    0x2451, 0x18f9, 0xffffc1d4, 0xffffb689, 0xffffc37b, 0xffffbe2f, 0xffffbe9e, 0x8117,
    0x7050, 0xfffff504, 0x2b9, 0x464f, 0x298d, 0x2367, 0xffffe8c3, 0x79f1,
    0x4e38, 0x5cc8, 0x2928, 0xffffb486, 0x7cd6, 0xffffdbd9, 0xfffff110, 0xffffeff7,
    0x19b8, 0xffffeb99, 0xffff847c, 0xffff7612, 0xffffd542, 0x2966, 0xffff8ce2, 0x38fe,
    0xffffdeaa, 0x5238, 0x67c4, 0xffffa5e7, 0x4e6d, 0xffffd82e, 0x5973, 0x351b,
    0x74e8, 0xffffafcd, 0x66dd, 0x20e4, 0x609d, 0xffffade3, 0x509f, 0xffffa21f,
    0x2cce, 0x54c2, 0x1953, 0x85ce, 0x6bee, 0x3222, 0x6ff6, 0x3773,
    0x5a64, 0xffffe40f, 0xffffc6df, 0x3556, 0x80a9, 0xffff76c5, 0x495b, 0x1ae4,
    0xffffca33, 0x31f2, 0x833e, 0x89c3, 0x5f43, 0xffffbee7, 0x3ab2, 0x87af,
    0x4c74, 0xffff810b, 0xffffbed0, 0x6795, 0xffff785c, 0xffffbc0b, 0x520e, 0x4348,
    0xe03, 0x4541, 0x2557, 0xffff9110, 0x4044, 0x1947, 0x4dab, 0xcbe,
    0x3f72, 0x4507, 0xffffa362, 0xffffc20b, 0x6c1b, 0x27c7, 0xffff9bf2, 0x6506,
    0xffff89cc, 0x5c3e, 0x4509, 0x409a, 0xffff98db, 0x1674, 0xffff9324, 0x7328,
    0xffff99cf, 0xcd8, 0x730a, 0x14b9, 0x672d, 0xffffd620, 0x1dd8, 0x3bec,
    0xffff94b6, 0xffffb689, 0x7dfd, 0x3ffd, 0xffff9cb6, 0x3560, 0xffffbaf8, 0xffff8604,
    0x8795, 0xffff7aec, 0x66a5, 0x6a0b, 0x564b, 0xffff8d00, 0xffffed20, 0x11b8,
    0xffffdc27, 0x595d, 0xffffddf0, 0xfffffc70, 0xffffd5bf, 0x6714, 0xffffaf69, 0xdb2,
    0x3786, 0xffffbf9d, 0x7ca7, 0x5a53, 0xffff7c6a, 0xffff8465, 0xffffe4c6, 0xffffa238,
    0xffff7f9b, 0x6887, 0x3838, 0x7115, 0x5bce, 0xeae, 0x47c, 0xffffd54a,
    0xffffb9d5, 0x6183, 0x9c3, 0xbd5, 0xffffe217, 0x8237, 0x51d7, 0x52fe,
    0x6424, 0xffffb192, 0xffff7ebb, 0xffffd373, 0xffff9cf7, 0x390b, 0xffffa473, 0x8953,
    0xffff90c9, 0x594a, 0xc6e, 0x32ba, 0xffffae73, 0x86c7, 0xffffd7a0, 0xffffa82e,
    0x8d66, 0xffffabcf, 0xffff84d0, 0x3a84, 0xffffe8bd, 0x4948, 0x3f2a, 0xfffff4e5,
    0xffffb0bd, 0x4961, 0xffffd95b, 0xffffd96c, 0xffffce34, 0x57ff, 0xffffdf08, 0x2330,
    0xffffa8c7, 0x24cb, 0x740a, 0xffffdbcf, 0xffffad36, 0x306f, 0xffffa30b, 0xffffc488,
    0xffff8022, 0x464a, 0x6f00, 0xffffb419, 0xffff8450, 0x2ddb, 0x2731, 0x63fd,
    0x2946, 0x5c28, 0xffffb064, 0xffffb277, 0x1e0f, 0x6d71, 0xffff7ff3, 0xfffffb02,
    0xf2a, 0xffffd69c, 0x638, 0xffffe8ff, 0xffffbd7e, 0xffffb26f, 0xffffe153, 0xffff9879,
    0xffff849c, 0x1f73, 0xffff9b21, 0x2bb1, 0xffffa95b, 0xffffd582, 0xffffdbfa, 0xd2c,
    0xffffa86f, 0x2ab3, 0xffff9d78, 0x1074, 0xffffbcb5, 0x3990, 0xffffe869, 0xffffb422,
    0x2dc8, 0xffffca25, 0xffffcfe8, 0xaf1, 0xffff82c8, 0x36a, 0x2f4e, 0xfffffdcd,
    0x77fa, 0xffffad4f, 0xffffa54a, 0x50b9, 0x6eab, 0x5178, 0x8982, 0xffffe4dd,
    0xffff9a82, 0x45a2, 0x784e, 0xffffbd6e, 0x5019, 0xffffcc5c, 0x8009, 0x5d96,
    0xffffac8d, 0xffff8ec9, 0x4c, 0x4222, 0xfffffa7f, 0x3227, 0x67ea, 0xffffe679,
    0x3dc8, 0xffffb5b5, 0x1424, 0x3e4a, 0xfffff175, 0xffffaf4b, 0x4657, 0x1374,
    0xffff7233, 0x7190, 0x332, 0xaf0, 0x68c0, 0xffff85ad, 0xffffd0af, 0x2b1,
    0xffff8d54, 0x1f99, 0xffffe8d5, 0xffffc30b, 0x2877, 0xffff9d40, 0xffff8852, 0xffffb01a,
    0x4b32, 0x3279, 0xffff9099, 0x5f4f, 0xffffe08c, 0xffff9fe0, 0xffff9ecc, 0xfffff557,
    0xfffffc25, 0xffffa719, 0xffff920a, 0x62ac, 0xfffff11d, 0x152d, 0xfffff5d6, 0x5223,
    0xfffff438, 0xffff73f3, 0x34e1, 0x49a9, 0x6a73, 0x2ad3, 0x1f51, 0x824,
    0x1bc9, 0x5170, 0x552d, 0x52b5, 0xfffff12a, 0xffffec44, 0x7924, 0x5294,
    0xb63, 0x822f, 0xffff9afd, 0x7e29, 0x2d91, 0x42ad, 0xfffff589, 0xfffff6e9,
    0x2792, 0x4269, 0xffff9639, 0xffff726f, 0x4074, 0xffffa179, 0x8a6b, 0xffffb431,
    0x850f, 0xffff903f, 0x6b22, 0x738, 0x16a0, 0xffff917f, 0x8a5a, 0xb61,
    0xffffcce6, 0x6369, 0xffffb671, 0x66c0, 0x68e6, 0x41aa, 0x2fc3, 0x2382,
    0xffffabd5, 0x62c, 0x5041, 0xffff9903, 0x846b, 0x86f6, 0x8111, 0x15c,
    0x62ed, 0xfffff411, 0x517c, 0xffffbb6d, 0x8256, 0x141e, 0xfffffd31, 0x8777,
    0xffffabbe, 0x4eb5, 0xffffbae4, 0x75a2, 0x2bfc, 0xffff799f, 0x26bd, 0x2296,
    0x7b36, 0xffffddc6, 0x7517, 0x155a, 0x16b1, 0x25b4, 0xfffff8ce, 0x54e9,
    0xffffeb3c, 0x7e5e, 0xffffa981, 0xfffffdbb, 0x87f7, 0xfffff4fe, 0x5657, 0x2add,
    0x5113, 0x7bff, 0xffffbcec, 0x37fb, 0x59a3, 0xffffd989, 0xffff9ac8, 0xffff8e9e,
    0x5ea9, 0x1bbf, 0x8ca1, 0xffff7365, 0x4d65, 0x874c, 0x4119, 0x63ee,
    0xffff91ea, 0x8074, 0x8a3c, 0xffff74b0, 0xffffb940, 0x3c7a, 0x50f, 0xffffe11e,
    0x6c76, 0x5731, 0xf34, 0xffff8ace, 0xffffdb12, 0x4cb2, 0xffffa624, 0x8999,
    0xffff94e3, 0x469e, 0x4101, 0xffffe271, 0x850d, 0xffff95cf, 0xffff93fa, 0x3357,
    0x8fe, 0xffff9b75, 0xffffbd9b, 0x6a34, 0x1db7, 0xb19, 0xffffee5f, 0xffffc9c1,
    0x763, 0xffff9c09, 0x26a7, 0xffffb6c5, 0xf48, 0xe3e, 0x854f, 0xfffffa24,
    0xffffb689, 0x34bc, 0xffff7a74, 0xffff7240, 0x5849, 0xfffffa7f, 0xffffbd17, 0x17e4,
    0x8e6, 0xfffff805, 0xffffd6d6, 0xffffecd0, 0xffff8b9c, 0xffffed0b, 0x198e, 0x5422,
    0x8549, 0x8dc7, 0xffffb649, 0x1cb6, 0x5ba9, 0xffffc4f6, 0x7b31, 0xffff8611,
    0x62a9, 0xc49, 0xffff7b22, 0xffffd5f0, 0xffff9fce, 0x3f16, 0xffff72a8, 0xffff9a53,
    0xffffa401, 0xffff9f41, 0x53b8, 0xffffca3e, 0x86a2, 0xffffa27c, 0xffffb022, 0x7c4,
    0x3425, 0x344e, 0xffffcb0a, 0x6d47, 0x63b3, 0x677c, 0x4077, 0x72b,
    0x5a90, 0x4348, 0xffff8b9d, 0xffffbcef, 0xffff8e3f, 0x58fa, 0xffffe0a8, 0xffffaf0c,
    0x4698, 0x3da0, 0xffffd44c, 0xffffe85d, 0x455f, 0x5746, 0x5168, 0xfffff3ad,
    0xffffd7bb, 0x56b0, 0xffff7845, 0xffff8d1d, 0x8fa, 0xffffe8c1, 0xffffb00f, 0x6f65,
    0xffffb97c, 0x83b9, 0x4e67, 0x5e2a, 0x787f, 0x8d66, 0x397e, 0x7e75,
    0x4789, 0x7be7, 0x8a38, 0x7ce2, 0xffff9005, 0x3391, 0x873d, 0x5ade,
    0x71e5, 0xffffb84e, 0x4718, 0x438, 0x8700, 0xffffdf0d, 0xfffffed4, 0x88,
    0xfffff494, 0xffffab9a, 0x6c68, 0xffffece3, 0xffff9e05, 0x5590, 0xffffeda6, 0x491d,
    0x7376, 0x6e88, 0x75df, 0xffffd5a8, 0x88b7, 0xffffe707, 0x356d, 0xffff9881,
    0xffffef0f, 0xffffa40f, 0xffff8f5e, 0x3b0f, 0x3da, 0xfffff8d1, 0x6809, 0x83dd,
    0x876d, 0x3c44, 0xffffe878, 0x3faf, 0x78f, 0xffff7a85, 0xffffc78b, 0xffffd711,
    0xffff9d6b, 0x79c8, 0xd65, 0xffffe3e3, 0x478, 0x7129, 0xffff7dda, 0xffffab18,
    0xffffcd44, 0xffff7cfc, 0x723a, 0x5c3, 0x3737, 0x3451, 0x650a, 0xffffa327,
    0xfd9, 0xffff7bae, 0x1f5b, 0x2978, 0x8c99, 0x4cd4, 0xffffb3d6, 0x4036,
    0x2a0e, 0x35ea, 0x50b, 0xffff9518, 0xffff85c1, 0xffffcdc6, 0xffffdc56, 0xffff8d75,
    0xffff90f3, 0x11cb, 0xffffa7dd, 0xffff884c, 0xffffc35a, 0xffffc3cf, 0xffffad4a, 0xffffc75a,
    0xffffa170, 0x8adb, 0x7441, 0xffffe8d1, 0x42b4, 0xffffe1ad, 0xffffdd4a, 0xffff98bf,
    0x4cc2, 0xffff8b07, 0x334c, 0x5e4d, 0xffffb14a, 0xffff9c04, 0xffffb744, 0xffffa616,
    0x187d, 0x495a, 0xffffb1c3, 0x524d, 0xffffc04b, 0x6110, 0x6dff, 0x55b8,
    0x8de1, 0x3394, 0x886f, 0xc21, 0xffff995f, 0xd71, 0xffff90e8, 0xffff983a,
    0xffff92d8, 0xffffcce2, 0xffff90e7, 0xffff94ff, 0x4e0b, 0xffff9334, 0xffffeacb, 0xffff8f75,
    0x48aa, 0x7631, 0xfffffbf9, 0xffffd3e0, 0x6850, 0xffffa651, 0xffff8745, 0xffffe780,
    0xfffff596, 0xfffffed5, 0x3b41, 0x55cd, 0x5a08, 0xffffa0cf, 0xffff75a0, 0xe58,
    0xffffff64, 0x6763, 0xffff8c5f, 0x69b7, 0x453b, 0xffffba78, 0x7554, 0x4fba,
    0x6031, 0x1ed6, 0x30a2, 0x3c52, 0xfffffc1a, 0xffffecfe, 0xffffa280, 0xffff9d76,
    0xffffa66c, 0xffff8dc0, 0xffffaa2b, 0xffffbc38, 0x1cd9, 0xfffff3fa, 0x7078, 0xfffffecb,
    0x800e, 0xfffffa73, 0xffff9a9f, 0xffffb5c5, 0xffffda01, 0x68c8, 0x7787, 0xffffe959,
    0xffffc008, 0x357a, 0x37fb, 0xffff9b65, 0x4df5, 0x8ad5, 0x53aa, 0xffffcc5a,
    0xffff74a9, 0xffffed23, 0x4c8e, 0xffffbd47, 0xb95, 0x774c, 0x5109, 0xffffd8ef,
    0x4095, 0xffffad7a, 0x8a82, 0x2d80, 0xffff8d9a, 0xd43, 0x6bf9, 0x223,
    0x3eed, 0xffffc475, 0x3854, 0xffffa438, 0x1ac0, 0x990, 0x50f8, 0xfffffce9,
    0xffff72ab, 0x41f2, 0x845e, 0xffffef06, 0x7241, 0xffffcf1a, 0x7888, 0x5bf5,
    0xffffc6a5, 0xffffdbe1, 0x1573, 0x65ba, 0x1f5a, 0xffff9e88, 0xffffef80, 0x580c,
    0xffff8254, 0x5da1, 0xffff7a42, 0x220e, 0xffff7947, 0xffff7a6b, 0xffffaa90, 0x7b4,
    0xfffff0e5, 0xf4, 0xd7c, 0x3754, 0xffffa34c, 0x4314, 0x4e93, 0x5f33,
    0xffffd600, 0x150b, 0xffff867a, 0x5eee, 0x54fd, 0x630d, 0xfffff8e2, 0xffffdd08,
    0xffffdd29, 0xffff7350, 0xffffbc1a, 0x1429, 0xffffda45, 0x3e79, 0xffffca86, 0x1523,
    0x620c, 0xa9e, 0xfffffdb9, 0xffffb00f, 0xffff82bf, 0xfffffb63, 0xffff78de, 0x25ad,
    0x54ac, 0x3831, 0x66b6, 0x696e, 0x4e31, 0xffff81c0, 0xffff854a, 0xa8e,
    0x8ce6, 0x52dd, 0xffffa6c6, 0xffffe575, 0xffff9907, 0xffff9743, 0x2156, 0xffff8199,
    0x76ea, 0x7361, 0x8d23, 0xfffffa98, 0xfffffb0d, 0xffffa7b3, 0x12e3, 0x4239,
    0x4aeb, 0x7461, 0xe02, 0x987, 0x68b5, 0xfffffc95, 0x7ac, 0x7238,
    0xfffff148, 0xfffff26d, 0x58f4, 0x50b3, 0xffff869d, 0xffff8582, 0x5d94, 0x30fd,
    0x1e62, 0x83ab, 0xfffffa33, 0xffffb49d, 0x18e9, 0x4781, 0x6d8, 0x7bab,
    0x1aef, 0x2ca6, 0x81a9, 0x2f34, 0x248d, 0xffff9a23, 0xffffdd8a, 0xffffd9a2,
    0xfffffba7, 0x754, 0xffffdbe5, 0x28cc, 0xffff9659, 0x2219, 0x6bea, 0xffffe7ad,
    0xffff856e, 0xffffd3c1, 0x14ff, 0x350, 0x42f3, 0xffffd69d, 0xffffb4b5, 0xffffccd7,
    0x6500, 0x2fb6, 0xffff95b5, 0xffffe293, 0x5baa, 0xffffc45a, 0xffffda2f, 0xffff8de6,
    0xffff87ec, 0x5f0e, 0xffffca76, 0xffffac52, 0xfffff9a4, 0xffff9e0d, 0x771a, 0xd62,
    0x32f3, 0x8367, 0xffff982d, 0x240a, 0x20d, 0xfffff430, 0xffffba8d, 0xffffb810,
    0xffffcfd1, 0x8044, 0xffffcba1, 0xffff9772, 0xffffee63, 0xfffffd51, 0xfffff324, 0x101e,
    0xffffe7c7, 0xfffffb15, 0xffffc5eb, 0x8585, 0x427, 0xffffcdbf, 0xffffcc26, 0x21fb,
    0xffff7c96, 0xffff7705, 0xffffb428, 0xffffa3f8, 0x3906, 0x5787, 0xffffd8af, 0xffffd7d1,
    0xffff77d7, 0x5504, 0xffff73a1, 0x116e, 0x32d8, 0x16f2, 0x5c09, 0xfffff98c,
    0x7350, 0x6462, 0xffffada1, 0x3f1b, 0x6378, 0xffff81e0, 0x2dd3, 0xfffff52a,
    0x8142, 0x89e0, 0xffff9fc6, 0xffff7bf1, 0xffffd116, 0xffffebf0, 0xd84, 0x1669,
    0xffff9bca, 0x5050, 0x6f8a, 0x2c50, 0x8590, 0x32fd, 0x6abf, 0x6af0,
    0xffffa4de, 0x2042, 0xffff9f0b, 0x726, 0xffffcb98, 0x12a1, 0x497b, 0xffffa677,
    0xfffff6f1, 0x2433, 0xffffebc9, 0xffffd8cd, 0x2939, 0x2438, 0xffff79b3, 0xffff9226,
    0xffff9ca1, 0x4884, 0x6fe7, 0x2f89, 0x812a, 0xffffa72e, 0xffffb33c, 0xffff815e,
    0xffff8866, 0x3b83, 0xfffff5b5, 0x3fb2, 0x8221, 0xffffd486, 0x2665, 0xffffa540,
    0x5ce5, 0x893c, 0x4b34, 0x1b5d, 0xffff8b00, 0x8b56, 0xffffb3ab, 0xfffff0d7,
    0x353f, 0x63ce, 0xffff9b0b, 0xffff9689, 0xfffffe5a, 0x50c5, 0x3f3d, 0x1917,
    0x3045, 0xffffdb17, 0x2f69, 0x7ecc, 0xffff7f93, 0xffffa392, 0x9ed, 0xffff94dc,
    0x11e, 0xffffdcb5, 0xffff934b, 0xfffff44a, 0xffffd194, 0xffffe03b, 0x5841, 0xffffd49a,
    0x26f3, 0xfffffc5a, 0x8d0e, 0x6441, 0x2fc5, 0xffffed7a, 0xffffe739, 0xffffd2ff,
    0xffffb541, 0xffff8f9e, 0x807, 0xffff8e7d, 0xffff85b9, 0xffff8fc7, 0x778a, 0x8451,
    0xffffa75f, 0xffffe5b1, 0x2aeb, 0x7fe6, 0xffffc2b3, 0x8534, 0x268a, 0x6711,
    0xffff8cf8, 0xffffd800, 0xffff7913, 0x7c1b, 0x4e76, 0xffffde5d, 0x1545, 0xfffff355,
    0xffffc1bb, 0x398c, 0xffff798a, 0xffffdc27, 0x40ed, 0xfffff8fc, 0xfffff918, 0x7ef5,
    0x5182, 0x8369, 0x47af, 0xffffd6d5, 0xffff7e09, 0xffffa12e, 0x5363, 0xffffce2c,
    0xffffdc79, 0xfffff095, 0xffff7760, 0x4905, 0xffffd192, 0xffff9ca8, 0x39dc, 0xffffd67b,
    0x680, 0xffffb5a4, 0xffffd7d7, 0xffffb5a5, 0x7fcd, 0x7305, 0xffff8e3b, 0x179d,
    0xffffebf4, 0xffffad3c, 0xffff791f, 0xffffb513, 0x7d2e, 0x361f, 0x1a0f, 0xffffd336,
    0xffff7531, 0xffff73ec, 0x8acc, 0x85bf, 0xffff8a29, 0xd3c, 0x392, 0x4482,
    0x7272, 0xffff8403, 0x7d3e, 0xfffff055, 0x6ae2, 0xffffc5b3, 0x74ac, 0x30f6,
    0xfffff4bd, 0x19ba, 0xffffc488, 0xffffeec2, 0x877, 0xa9d, 0xfc1, 0x57a0,
    0x4879, 0x175a, 0xffffa0c0, 0x533, 0x8765, 0x2d23, 0x7ae9, 0x1d9e,
    0x16b2, 0x58c4, 0xffffe64f, 0xffff79ba, 0x68cd, 0x5c30, 0xffffb8e0, 0xffffc5d1,
    0xfffff04f, 0x5fec, 0x19ca, 0xffff8c02, 0x15ab, 0x8897, 0xffffebeb, 0x70d7,
    0x1662, 0x8c83, 0x8bc8, 0x21c8, 0xffffa728, 0x6513, 0xffff92f4, 0xffffadb2,
    0x7a29, 0xffffe450, 0x2136, 0xffffc6db, 0x26e, 0x8221, 0x3097, 0x5883,
    0xffffa134, 0x8284, 0xffffa6d9, 0x1c76, 0xffff8524, 0x164e, 0xffffa415, 0xffff841e,
    0x309d, 0xffffd4e1, 0xffff99a3, 0x4e11, 0xffff90a2, 0x51bf, 0xffffec39, 0xffff9073,
    0xe4e, 0xffff7a6a, 0x26b0, 0x64e4, 0x1a95, 0xffffeed3, 0x8049, 0x67b0,
    0x23e0, 0xffffb836, 0xf72, 0x2c0f, 0xffffacff, 0xffffa183, 0x87b8, 0xffff7e3a,
    0xffffef41, 0xffff796e, 0xfffffd33, 0x4c73, 0xffffd590, 0xffffdfac, 0xfffff5fb, 0xffff9594,
    0xffffba62, 0xffffa2d2, 0x496a, 0x1501, 0xffff9a7a, 0xffffc542, 0xffff8a89, 0xffffdda6,
    0xffff7f5e, 0xffffbf34, 0xffffe1e1, 0xffffb26c, 0xffffe9c3, 0x67cc, 0xffffb506, 0x6416,
    0x454, 0x3724, 0xffff9c3d, 0x2f27, 0x45cb, 0x670f, 0xffff7969, 0xffffdc9e,
    0xffff87e1, 0x1948, 0xfffffe4e, 0x1fdd, 0xffffe119, 0x5c64, 0xffffc383, 0x1062,
    0x6828, 0x6dd8, 0x2238, 0x12d5, 0xffffd611, 0xffff8739, 0x137a, 0x52c6,
    0x441c, 0xffffc74c, 0xffffee23, 0x583a, 0xffffd369, 0x3c68, 0xffff99a0, 0xffffb914,
    0xffffbe62, 0xffffcd86, 0x1438, 0xffffe64d, 0x53da, 0x2358, 0x89f6, 0x6e04,
    0x459f, 0xffffb2a5, 0xffffdaf4, 0xfffface2, 0x6673, 0xfffff8df, 0x594d, 0xffffeedd,
    0xffffa520, 0xffff8687, 0x70b0, 0x5dba, 0xffffe645, 0x3bbc, 0xffff8028, 0xffffea28,
    0xffffc7ba, 0x36ca, 0x7c40, 0x34ce, 0xffff7a62, 0x10bf, 0x5ee1, 0xffff98ab,
    0x10be, 0x3b49, 0x8c53, 0x8386, 0xffff7a09, 0xffff7a77, 0xffff7acd, 0x2cc4,
    0xffff93aa, 0x574, 0xffffc3ed, 0x2586, 0xffffeca4, 0x750e, 0xffffb075, 0x6308,
    0x67ac, 0xffffc8a3, 0x49c1, 0xfffff006, 0x89c9, 0x4f36, 0x3909, 0xffffd5d0,
    0xffffe4c1, 0xffff7a19, 0xffff8552, 0x7a2b, 0xffff9d63, 0x88e9, 0xfffffde4, 0x190a,
    0xffff826f, 0xffffecd9, 0x1983, 0xffffe551, 0xffff92e2, 0x2c5c, 0xffffd03c, 0x4adf,
    0x6865, 0xffff7e20, 0xffffea03, 0x841d, 0x4e37, 0x3d59, 0x3171, 0x673a,
    0x1afc, 0xffffa098, 0xffffde36, 0xfffffbbd, 0x47a5, 0x65be, 0x3738, 0x2beb,
    0x3e11, 0x6cff, 0x8da8, 0x22a6, 0xffffdf4a, 0x1151, 0xffffc349, 0x3485,
    0xffffee00, 0xffff864e, 0x865, 0x5989, 0x4145, 0xffff8999, 0xffff835e, 0xffffc2ad,
    0x2f00, 0xffffdc98, 0x7dfe, 0xffffc2fe, 0x1234, 0xfffff5da, 0xffffd55c, 0x119e,
    0xffff7dc3, 0xffffb27e, 0x7aae, 0xffff7b34, 0xffffde8e, 0x797, 0xffffab7e, 0xffffe6ce,
    0x7685, 0x600f, 0x7285, 0x6045, 0xffffe2f4, 0x69e7, 0xffffdfd8, 0x14a,
    0xffffda78, 0xffffabc0, 0x89c3, 0xffffbeac, 0xc37, 0x6df4, 0xffffe0d2, 0xffffc632,
    0xffffa62e, 0xffff8d46, 0xffff78fa, 0x3003, 0xfffff74e, 0x42a9, 0xffffe8d6, 0xffff7863,
    0x6a8e, 0xffff8696, 0x1844, 0xffffa06f, 0xd36, 0xffffd8d8, 0xffffe27c, 0x387e,
    0x30fb, 0xfffff762, 0x808a, 0x2d5b, 0x6717, 0xffffff14, 0x845b, 0xffff9586,
    0x68b, 0xffffe56f, 0xffff96b9, 0x6295, 0xffffb26c, 0x2a02, 0xfffffd8b, 0x6b98,
    0xffff8ca4, 0x501a, 0x5f44, 0xffffa9ac, 0xffffa063, 0xffff9030, 0xffff80d2, 0xffffcd8c,
    0x4c8c, 0xffffc0f8, 0x397, 0x819c, 0x767c, 0x7d99, 0xfffff123, 0x1b50,
    0x2c29, 0xffffd70f, 0xffffcca8, 0xffffa017, 0xfffff2b7, 0xffff74f0, 0xffffa9ed, 0x233b,
    0x1516, 0xffffbb9f, 0xffff97bc, 0x23c4, 0xfffff299, 0x7db1, 0xa52, 0xffff9161,
    0xffff8541, 0xffff75a7, 0xe20, 0x7dd3, 0xffffcc27, 0xffff9e5e, 0xffffe9ee, 0xb6e,
    0xffffe271, 0xffffe9e6, 0x6d72, 0xfffffd38, 0xffffa167, 0x6246, 0x83b, 0xffffa571,
    0xaeb, 0xffff8759, 0xffffa37f, 0xffffea7c, 0x6061, 0x8b6c, 0xffffb904, 0xffff88ea,
    0xffffa8f7, 0xffffd266, 0xffffa1bf, 0x343a, 0x6f9c, 0xffffd56b, 0x37ef, 0xffff8566,
    0x4eb7, 0xffffd9b3, 0xffffd22e, 0x8af7, 0x1d78, 0xfffff575, 0x391e, 0x4836,
    0xffffeaf1, 0xffff89a2, 0x6ac6, 0x611f, 0x8458, 0x2af6, 0x588f, 0x8e5,
    0x8bf6, 0xffffac56, 0x35d8, 0x6e0, 0x371b, 0xffff7743, 0xffffc693, 0x146c,
    0xffff80e3, 0xffffb207, 0xffffe58c, 0xffff8e50, 0xffffb07b, 0xfffff121, 0xffff9b54, 0x5dd4,
    0x700d, 0xffffe8a8, 0xffffdc38, 0xffffe745, 0x3734, 0x1db6, 0xffff8353, 0xffff7e3b,
    0x8eb, 0x6019, 0x2c5c, 0xffff8bd0, 0x8a7f, 0x7bc1, 0xfffff710, 0x4002,
    0x3650, 0xffffce4a, 0xffff7cce, 0xb70, 0x359a, 0x3013, 0x362, 0xffffa441,
    0x5b8e, 0xfffffe99, 0xffff7813, 0x7fdf, 0xffff8fc1, 0x5912, 0xffff8122, 0xfffff92a,
    0xffff8c22, 0x46a0, 0x5d05, 0xffffc4c0, 0xffffbc37, 0xffff9f62, 0x3103, 0xfffffb57,
    0xffffdf3b, 0xffffbde0, 0xffffe2fd, 0xffffcb24, 0x7291, 0xffffc112, 0x305d, 0x60f4,
    0xffffc8ae, 0xffff7574, 0xffffe0d9, 0xe58, 0xfffffeba, 0x66e, 0xffff8463, 0x8643,
    0xffffa427, 0x405e, 0xffffa5f5, 0xffffcb8f, 0xffffb04c, 0xffff79aa, 0x1a22, 0xffff896c,
    0xffff7d81, 0x7bda, 0x6989, 0x3996, 0x870e, 0x3a69, 0x3b4a, 0xffff9e08,
    0x2c97, 0x7ebd, 0xffffbf71, 0x1973, 0xffffdf6b, 0xffffbad9, 0x196a, 0x81e8,
    0x1c4, 0x61c5, 0x76e9, 0x25c5, 0x5131, 0xffff9e6e, 0xffff9637, 0xffff7d1a,
    0x5111, 0xffffff97, 0xffff8424, 0xffffbf3b, 0xffffb4f9, 0x2eaf, 0x7b44, 0x409e,
    0xffffe706, 0x1099, 0x328c, 0x401c, 0x2e7, 0x5b34, 0xffffd2f2, 0xffff9853,
    0xffff7804, 0xfffff344, 0xfffff283, 0x8ce9, 0xffff8fc2, 0xfffff155, 0xffffe2fe, 0xffff9d35,
    0x846f, 0xffffe3cf, 0x53f2, 0x67e4, 0xffffb405, 0xffff9c2a, 0x69a7, 0xfffff279,
    0xffffcd7b, 0xffffe05c, 0x5f40, 0x7110, 0x5c7d, 0xffffc8b4, 0xffffb97c, 0xfffffd3e,
    0x6b8f, 0xffffa8f4, 0xffffe8d7, 0xffffee7e, 0xa4e, 0xffff8a06, 0x4499, 0x65,
    0xffff9c0e, 0xffffdb63, 0xffff9123, 0x1fdb, 0x424a, 0xffffecca, 0xffffbde3, 0xb4,
    0xffffd7b7, 0xffffbb82, 0xffffa8bb, 0xffffcf0c, 0x1c1, 0xffff87e5, 0xfffff7cc, 0xffffc4dd,
    0xfffff3f1, 0x86c6, 0x3063, 0xffffbf8c, 0x2ddf, 0x7a9, 0x3d41, 0xfffff150,
    0xffff9224, 0xffffe905, 0xffffbd32, 0x76c2, 0x4021, 0xffff86cd, 0xffff895a, 0xffffd092,
    0x3b93, 0xffffbf5b, 0xffffe7f1, 0x44e, 0x7e09, 0x514f, 0xffffdae2, 0xffff8ae4,
    0xffffd626, 0x8cf6, 0xffffc1e5, 0xffff8d3e, 0xffffc16c, 0x5b5, 0xffff8d48, 0x264a,
    0x6750, 0x5f3f, 0x442e, 0xfffff88b, 0xffffe7d2, 0x73ce, 0xffffffac, 0x3302,
    0x5125, 0x590c, 0xffffe068, 0xffffb765, 0x473d, 0xffffd9cc, 0x9ae, 0x3ae0,
    0xffffdd98, 0x4346, 0xbe1, 0x506e, 0xffffe5dd, 0xffff8b4d, 0x6ac3, 0x89a1,
    0x229b, 0xffffa8bf, 0xffffb463, 0xffffb8aa, 0xffffb1bb, 0xffff8205, 0x76ba, 0x1117,
    0xffffae9e, 0xddf, 0xffffaf93, 0x1661, 0x490b, 0xffff798e, 0x4d5f, 0xffffbca8,
    0x13c4, 0x814a, 0x8340, 0xfffffe42, 0xffffc27f, 0xb42, 0xffffbeae, 0x39a3,
    0x5caa, 0xffffd38d, 0x2dba, 0xfffffe91, 0x5451, 0x768d, 0x827a, 0xffffbf93,
    0x5ff2, 0xffffeaa2, 0xffffb0fc, 0x677a, 0xffff758a, 0xffffbcc6, 0xffff9166, 0xffff9b70,
    0xffffa468, 0x36bf, 0xffffbf31, 0x2f3d, 0xffffd890, 0xfffff4af, 0x3b4b, 0xffffc047,
    0xffff98b3, 0xffffea02, 0xffff9ed7, 0x45b0, 0x8c73, 0xffffa371, 0xfffff4fa, 0xffffe309,
    0x3fce, 0x3020, 0x7e45, 0x40bb, 0x506c, 0x63a1, 0x52cd, 0xffff7a93,
    0x3108, 0xffffbf0a, 0xffffe87a, 0xffff782f, 0xffffcb8e, 0x3e37, 0x619a, 0xfffff75a,
    0xffffeb8a, 0x621f, 0xffff87fb, 0x594b, 0x70ee, 0x519c, 0xfffffa39, 0x540b,
    0xffff9ea8, 0x5321, 0xffff9ba2, 0xffff8804, 0x1049, 0x6249, 0xffffc186, 0x6915,
    0x45ba, 0xffffc569, 0x1275, 0x1141, 0xffff7d0c, 0xfffff6a0, 0xc88, 0xffffd0cf,
    0x5493, 0xffffca10, 0x8ba5, 0x5479, 0x56a5, 0xffff72c4, 0xffffc49a, 0x1f28,
    0x26e2, 0x1842, 0x5690, 0xffff8ee0, 0xffff7d53, 0x1896, 0xffffbaf2, 0x724a,
    0xffffc881, 0x2913, 0xffff8e93, 0x1318, 0x288c, 0xffff985d, 0x70ef, 0xffffaa46,
    0x114b, 0x5357, 0x36e9, 0xffff8651, 0xffffb4bb, 0xffffd3a5, 0xffffe071, 0xffffbc9d,
    0x6d70, 0xffff93f4, 0xffff939a, 0xffffbf01, 0xffff9dd5, 0x3632, 0x22dd, 0x290a,
    0xfffff94e, 0xfffffd3f, 0x240b, 0x1dd7, 0xfffff422, 0xffffedb5, 0xffffae3f, 0x3131,
    0xffffb91a, 0xff0, 0xffffa875, 0xffffc56b, 0x7819, 0x2174, 0xfffffc53, 0xfffff477,
    0x6134, 0x4655, 0x94, 0xffffd1ee, 0xffff7e80, 0xffff82ef, 0xffffff54, 0x7000,
    0x1e7c, 0xffffc0d0, 0x84a4, 0x5a2, 0xffff7ba9, 0xffffd915, 0xffff757e, 0x2b2b,
    0x2182, 0xffff9958, 0x3d0d, 0xffffe4af, 0x5c62, 0x7512, 0x4e8, 0xffffa6ed,
    0x2f28, 0xffff8ff9, 0x1a0f, 0xffffd103, 0xffff85f6, 0x69f7, 0xffffb04f, 0x41fe,
    0xffffbc7e, 0x427b, 0xffffa03e, 0xffffee6f, 0xffff9910, 0xffffa897, 0xffff7e20, 0xffffc977,
    0x266c, 0xffffd8e3, 0x3c0a, 0x22b0, 0xffff92ff, 0x1b5d, 0x24f4, 0x3bb7,
    0x425b, 0xffff90a5, 0xffffb687, 0x156d, 0x58ef, 0x1b16, 0xffffd3e1, 0x582,
    0xffffb1b1, 0x691d, 0xfffff853, 0x4c0a, 0x4887, 0xfffffa27, 0xffffbdae, 0xffff8d31,
    0xfffffdb2, 0xffffd009, 0x6287, 0xfffff1ff, 0xffffa748, 0xffffccdf, 0xffffa977, 0x16dd,
    0x281e, 0x8047, 0x66a, 0x2c5a, 0xffff86b5, 0x854a, 0x2a5a, 0x70dd,
    0xfffffeb6, 0x873f, 0xffffdd1a, 0xffffaa65, 0xffff8ca8, 0xffff83da, 0x67c9, 0x4745,
    0x1b41, 0xffffebf0, 0xffff740b, 0x30d7, 0x2afa, 0xffff761e, 0x5539, 0x23e9,
    0xffffabd8, 0xffff931a, 0x408b, 0xfffff2cb, 0x67dc, 0xffff7807, 0xffff964a, 0x5288,
    0xffffc66d, 0x2366, 0x148e, 0x38cb, 0x157f, 0xffff8346, 0xffffb678, 0xffffc4f2,
    0x1549, 0xffffcdb8, 0xffffc5b7, 0xffffd59b, 0xffffd217, 0x6f4e, 0xffffb9ba, 0x8263,
    0xfffff2df, 0xffffd860, 0xffffd9d7, 0xffff9597, 0xffffec05, 0xffff81f3, 0x8be0, 0xffffe4a7,
    0xffff85a4, 0x2fc4, 0x86e9, 0x701, 0x61d3, 0x69ff, 0xffff7563, 0xffff76ce,
    0xffffc010, 0x822f, 0xffff7b66, 0x5e31, 0xffffc663, 0xfffff119, 0x15f0, 0x85d0,
    0x28f1, 0x3fd6, 0xffffa127, 0xffff9166, 0xffffb044, 0x2e04, 0x322c, 0xffffb132,
    0xfffff73e, 0xffffb6b0, 0x3ea8, 0xffffac4d, 0x4a5b, 0xffffa5e8, 0xffff7697, 0x16e,
    0x49ca, 0x1272, 0x4a93, 0x44ce, 0x53e2, 0xfffff35b, 0xffff778a, 0xffffd189,
    0xffffb7e4, 0x90c, 0xffff8795, 0xffff96e2, 0x73ed, 0x3b2c, 0x5db2, 0xffff761f,
    0xffffdc8b, 0x4a06, 0xffffa033, 0xfc9, 0xffffe5e2, 0x7fed, 0xffffca3a, 0x218d,
    0xffffcb3d, 0x2af8, 0xffffb770, 0x8b27, 0xffffcd03, 0x8615, 0xffff7dd4, 0xffff7494,
    0x7f51, 0xffffdf3d, 0xffffbc52, 0xffffa686, 0xffffe0e6, 0xffffd409, 0xffffcd88, 0x5d0f,
    0x6c9c, 0x77ed, 0x69e2, 0x30b8, 0xffff894c, 0xffffe9c1, 0xffffa2b0, 0xffffff92,
    0xffffeecb, 0xffff7486, 0xfffff3a4, 0x4b1a, 0x15cf, 0xffffd171, 0xffffce83, 0xffffb1f3,
    0x2d8f, 0xffffa1a2, 0xffff90d0, 0x10a2, 0x4e89, 0xffff730e, 0xffffb689, 0x8bf3,
    0xffffc917, 0x3a3c, 0x28c6, 0x7a05, 0xffffc793, 0xffff944b, 0xffff8c4f, 0x13b6,
    0x6540, 0x3b3c, 0x1b68, 0xa31, 0xfffffce2, 0xffffa0f0, 0x4d63, 0xa6,
    0x290, 0xffff7f48, 0xffffb06c, 0x5986, 0xffffe2e9, 0xffffe281, 0x6fd1, 0xffff9467,
    0xffffa53c, 0xffffda9c, 0xfffffb90, 0x8a9b, 0x55f2, 0x646f, 0x517f, 0xa33,
    0x1a6, 0xffff8fda, 0xffff890b, 0xffff81f3, 0xffffaac7, 0xffffd83a, 0x7f, 0x2782,
    0x6083, 0xfffff711, 0xffffe8c7, 0x5553, 0x55b7, 0x4d1, 0x56e4, 0xffff8f89,
    0xffffbab6, 0xfffff28b, 0x232b, 0x5139, 0xbe4, 0x3b5e, 0xffffa73f, 0xffffdf16,
    0xcce, 0x5e29, 0xca2, 0xffffd78f, 0xffff861d, 0xffff8ef5, 0x63a9, 0x3d30,
    0xffffb006, 0xffffa007, 0x4596, 0x2801, 0x4936, 0x2816, 0x3f0a, 0xffff92c9,
    0x145, 0x4f85, 0x2c8, 0xc72, 0x36a8, 0xffff81cf, 0xffffeffc, 0xffffde3f,
    0xffffd5f2, 0x5692, 0x60d4, 0x4861, 0x339d, 0x6449, 0xffffdd43, 0xffff8c56,
    0xffffeb4d, 0xffff98b3, 0xfffff4cf, 0x455a, 0xffffb995, 0xffffce66, 0x1dce, 0x1f3e,
    0xffff92ea, 0xfffff303, 0x5783, 0x4aae, 0x29e6, 0xc20, 0x78b9, 0xffff878d,
    0x637, 0xffffb102, 0xffff7e5e, 0x6193, 0x5e68, 0xffffd7d8, 0x654c, 0xffffe71d,
    0xfffff721, 0x339e, 0xffff7e57, 0x5529, 0xfffffcf2, 0xffffe584, 0x26cf, 0xffffce2b,
    0xffffff6b, 0x6600, 0xffffe4e1, 0xffffb27a, 0xffff7760, 0xffff8f2d, 0xffffb0b8, 0xffffc68b,
    0x6907, 0x1110, 0xffffef9b, 0x27, 0xb8d, 0x2872, 0xffffc27e, 0x1bfd,
    0x123a, 0xffffdb77, 0xffffa828, 0x4f0a, 0x6fd6, 0xffff7358, 0xffffafee, 0xffffc050,
    0xffffc121, 0x2dc7, 0xffffe42c, 0x8dbf, 0x2698, 0x7efd, 0xffff98d6, 0xffff9eea,
    0xffffec08, 0x16a3, 0xd9f, 0x6ccb, 0xffff7e32, 0xffff7561, 0x6907, 0x651b,
    0xffff9d8d, 0xffff826f, 0x5a7e, 0x7a70, 0xffff9108, 0x54c, 0x84d0, 0x4a6e,
    0xffffc829, 0x5726, 0xffff9518, 0xffffeb06, 0xdcf, 0x143d, 0x385a, 0xffff8005,
    0xfffff2a7, 0xffffcd4e, 0xffff8b6d, 0xffffec7a, 0x536b, 0xffff8148, 0xffff7ff7, 0x3098,
    0x6fd7, 0x6a8c, 0xffff83fd, 0x52ca, 0x8cc1, 0x251c, 0x3fd6, 0xffffd96c,
    0x26de, 0x710, 0xffff9146, 0xffff9808, 0xffff790a, 0x46c7, 0xffff9cf3, 0x290d,
    0xffffe6b9, 0xffff9078, 0xffff75f7, 0x678a, 0xfffff708, 0x26f2, 0xfffff7aa, 0x583f,
    0x2e8f, 0xffffb64c, 0xffffc0bc, 0xffffa35b, 0x264a, 0xffffc82c, 0xcfc, 0x7d89,
    0x11e0, 0xffffce25, 0xffff9499, 0xffff7aa5, 0xe3c, 0xac7, 0x81c5, 0x7159,
    0x8c01, 0xb5c, 0xfffffc6c, 0xffffa6c9, 0x8249, 0x7524, 0xffff735e, 0xffffce06,
    0x10c7, 0x6334, 0xffff7b8d, 0xffffa314, 0xffffce5d, 0x4f8f, 0x3a7e, 0x277f,
    0x17b8, 0x8cd8, 0xffff9909, 0xffffc891, 0x5de9, 0xffffc012, 0x54d6, 0xffff8015,
    0xffff90d5, 0x15d, 0x703e, 0x3236, 0xffffdd2d, 0xffffca7a, 0x43c6, 0xb61,
    0x6fd2, 0x336c, 0xffff9509, 0xffffa109, 0x17f4, 0x18a4, 0x38d9, 0x6b5e,
    0xffffe932, 0x1fee, 0xffffd6a5, 0xffffeb7f, 0x5284, 0x1655, 0x15c9, 0x1fc6,
    0x6cd5, 0xffffa187, 0x60f5, 0x7248, 0xffff814d, 0xd14, 0x884e, 0xffff8616,
    0xffffab6c, 0x8c75, 0x1005, 0x57fc, 0xffff9c74, 0x84f, 0xffffb6a1, 0xffffd988,
    0xffff7530, 0x782, 0xffffa7be, 0xffff9cf5, 0x1497, 0xffffd560, 0xffffe680, 0xffffdf92,
    0x2ead, 0x8694, 0xffff9c30, 0x3b22, 0xa82, 0x1f5d, 0xffffba52, 0x5743,
    0xffffb4ee, 0xffffd01e, 0x119a, 0xffff7eff, 0x86da, 0x3771, 0xffffbc56, 0xffff89e1,
    0x483, 0xffffdbd8, 0xffffc090, 0x225, 0xac3, 0x4c86, 0x26f7, 0xfffff1fa,
    0xffff76a6, 0x2bb6, 0x6553, 0xffffb0ba, 0x1b0e, 0x4f6f, 0xffffc8f3, 0x787f,
    0x8416, 0x392, 0x18cd, 0xffff8c51, 0xffffb50d, 0xfffff2e8, 0x74bb, 0xffffc84a,
    0xffffca8d, 0xffff8508, 0xfffff79a, 0x5867, 0xffffbde9, 0xffffc76c, 0x5966, 0xffffa1a3,
    0x3ef6, 0xffffaf76, 0xffffb2a6, 0x62b4, 0xffffaf21, 0x1f61, 0xffff8de2, 0x6ae4,
    0x1711, 0x2848, 0xffffc6e4, 0xfffff285, 0xffffce37, 0xfffff33d, 0x10fa, 0x14a2,
    0x8c4b, 0x56d5, 0x6170, 0x2ce9, 0x10d8, 0x350e, 0x3e1e, 0xffffa4e0,
    0x5090, 0x8035, 0x43bb, 0xffffc129, 0x1cdb, 0x7cf4, 0x5897, 0xffffe38a,
    0xfffffda4, 0xffff8f8f, 0x1711, 0x73fe, 0x641b, 0x24f7, 0x53da, 0x3e9d,
    0xffffdd78, 0xffff857b, 0x34e7, 0x7881, 0xffffecc8, 0x80b8, 0xffffd388, 0xffffe600,
    0xffffea29, 0xffffecc9, 0xffff8b09, 0xfffffb67, 0xffffa4ea, 0x6e11, 0x631b, 0x332,
    0xffffcdfd, 0x1236, 0xaf1, 0x720, 0x2ab7, 0xffffa89c, 0xffffeab4, 0x65c1,
    0xffffff40, 0x203b, 0x2c2, 0x4c30, 0xffff94df, 0xffffe58b, 0x71fa, 0xffff8350,
    0xffff888f, 0x33d, 0xffffa878, 0x3d07, 0x199c, 0x644b, 0x5d3d, 0x2c5,
    0x783b, 0x855d, 0xfffffe0f, 0x29cf, 0x4bcf, 0x2631, 0xfffff8a4, 0xffffdd94,
    0x1d61, 0xfffffafc, 0xffff7e05, 0x24a0, 0xffff8a5a, 0x262a, 0x5c5b, 0x229f,
    0xffffe6a8, 0xffffcde6, 0xffffa684, 0x178, 0x37cf, 0x534, 0x190a, 0x86d9,
    0xffffd70b, 0xdf9, 0x8a0d, 0x7218, 0xfffff793, 0x420e, 0xffffa733, 0x811f,
    0xffffa1b0, 0x8cfc, 0xffffb39f, 0xffffb277, 0x8c8d, 0x188, 0x4b59, 0x660c,
    0xffffc5c1, 0xffffc2c9, 0xffffe996, 0x2fd7, 0x1650, 0x6209, 0xffffa6a9, 0x4c28,
    0x7291, 0x587e, 0x4ef5, 0xffffaa02, 0xffffb81c, 0xc34, 0xffff79d4, 0xbe0,
    0x6bc9, 0x49c7, 0xffffb6eb, 0x120a, 0x455f, 0xffffa242, 0x19e1, 0x5b62,
    0x5cec, 0xffff8be5, 0xfffff857, 0xffffc764, 0xa02, 0xffff8856, 0x702c, 0xffff7b18,
    0xffff85d1, 0xdb3, 0x6296, 0x3ef2, 0x55a0, 0xffffe47a, 0x3213, 0xffffdcb1,
    0x2a00, 0x2c6d, 0xfffff530, 0x77d2, 0xfffff051, 0xffff82cc, 0xffffe0f7, 0x603e,
    0xffffcdcf, 0x3ee8, 0xffff9788, 0x4ee3, 0xffff8a08, 0x44d7, 0xffffae63, 0xffffa7bc,
    0x151e, 0x5de1, 0xffffe129, 0x7ec1, 0xffff82e1, 0x7a8a, 0xffff7c0f, 0x866a,
    0x1c48, 0x63fd, 0xfffffdf7, 0x681d, 0xffffeb26, 0x6d6c, 0xfffff7b5, 0x63e,
    0xffffcbab, 0xffffedcd, 0xffffe5d6, 0x4967, 0x834b, 0x28eb, 0x6365, 0x7e4b,
    0xffffd7aa, 0xffff759e, 0x5cad, 0x22f6, 0xffffa019, 0xffff7a60, 0xffffb158, 0xffff9830,
    0xffff88fa, 0x5381, 0xffff9edf, 0xffffb70e, 0xffffb5e0, 0x28b9, 0xffffd778, 0x4aa9,
    0x1029, 0x4de8, 0x85a, 0xffffa5af, 0xffff9598, 0x694a, 0x442f, 0xffffc325,
    0x1646, 0x40b4, 0x51b0, 0x50c4, 0xfffff810, 0x6afc, 0x1611, 0x7c33,
    0x2c36, 0xffffadd9, 0xffffff75, 0xffffa472, 0x2a6f, 0x1ea3, 0x5389, 0x42ec,
    0xffff7734, 0x10df, 0x7e19, 0xffffbe25, 0x45dc, 0x52d1, 0xffff7b84, 0xfffff9d9,
    0x202c, 0x6f8c, 0xffff96b0, 0x4581, 0x13a9, 0x7c2c, 0x2c73, 0x456a,
    0xffff90d7, 0xffff918e, 0x4daf, 0xffff883f, 0x292d, 0xffffd140, 0x4599, 0x7022,
    0x6e51, 0x6fd8, 0xffffcc81, 0x55a, 0xffffb012, 0xffff8234, 0xffff8e12, 0xffff866e,
    0xffff82ab, 0x3a12, 0x77f1, 0xffff8e5c, 0xffffb9db, 0x8114, 0xffffb4d1, 0xffffaa27,
    0xffffef2b, 0x512b, 0xfffff599, 0x2614, 0xffffec61, 0x2e53, 0xffffe14a, 0x8762,
    0x15ea, 0xffffa04a, 0xa9c, 0x3db3, 0xffff9da7, 0x1ba7, 0x6f1, 0x7046,
    0x40d8, 0x2807, 0xfffff498, 0x4003, 0xb8b, 0x80d9, 0xffffc968, 0xffffb091,
    0x6a11, 0x575d, 0xffffbd30, 0x59b7, 0xffffec68, 0x3bc3, 0xffff9852, 0x8d97,
    0x3bdd, 0xffff7b05, 0x3a08, 0x796a, 0xffffde73, 0x23d7, 0xffff937c, 0xffff8364,
    0x2c86, 0xfffff529, 0xffffb941, 0x4f9f, 0x300a, 0xffffb69a, 0xffff8ae2, 0xffff76f4,
    0x6281, 0xffff7a7f, 0xffff8cae, 0x6a9b, 0xffffc3e3, 0x6b24, 0x1a7f, 0xffffbbaa,
    0xffff9898, 0xfffff100, 0xffff9a77, 0xfffffeb5, 0x8062, 0x26f6, 0x72a6, 0x82a8,
    0xffff8d48, 0xffffad0b, 0xffff78ed, 0x39d9, 0xffff8cbd, 0xffffe4fb, 0xffff73d3, 0xffff8749,
    0xffff7787, 0x186d, 0xffff8a66, 0xffffd430, 0x675d, 0x6208, 0x1e0a, 0xffffd207,
    0x7627, 0x272d, 0xffffe162, 0xffff7f78, 0xffff97cd, 0xffffe52f, 0xffff9648, 0xffffbde7,
    0x4a2, 0xffffab13, 0x408e, 0xffffaf5a, 0xfffffccf, 0xffffcaee, 0x3ce9, 0xffff9f86,
    0xffffbdf6, 0x6f7d, 0x1ac0, 0xffff7d8f, 0xffffb5f4, 0x15d5, 0xffffb317, 0xffff8d69,
    0xffffd179, 0xffff9256, 0xffffaed4, 0xfffffd69, 0xffffe67c, 0x8a5d, 0xffffb985, 0x7bd5,
    0x1eaa, 0xffff7ea6, 0x7a6, 0xffffcc73, 0x45fe, 0xffff9312, 0xffff8963, 0xffffcd75,
    0x3534, 0x29af, 0xffffa890, 0xffff81d1, 0x3c3a, 0xffffcbc4, 0x43ba, 0x320c,
    0x70c6, 0x2ec5, 0x189d, 0xffff768f, 0xfffffcf4, 0x3ea8, 0x8212, 0xffffabef,
    0xffffc162, 0x22d4, 0x5755, 0xffffc5a0, 0x87f4, 0xffffb7da, 0xffffa9f3, 0x6eb4,
    0x1abc, 0x5caf, 0x3043, 0x4be4, 0x557b, 0x18e5, 0x2499, 0x7f,
    0xffffcd2d, 0xffffd93e, 0x3af4, 0xffff8c49, 0xffffc5a9, 0xffffb1ba, 0xffff9c0c, 0x18ba,
    0x2cbe, 0xffff8efc, 0xffffa34b, 0x3b05, 0x49d, 0xffffe7b4, 0xffffd9de, 0xfffff909,
    0x5f8, 0x3651, 0xffff7d02, 0x5eda, 0xffffb6f3, 0xffffaa6d, 0x201e, 0xffffc0d0,
    0xd3c, 0x11dd, 0x8c01, 0xfffff81f, 0x84fb, 0xffffe312, 0x7cdc, 0x6d33,
    0xffff8b40, 0x79af, 0xfffff0d5, 0xffffe4ee, 0x73a8, 0x20e6, 0xffff927f, 0x8592,
    0xffffb092, 0x5012, 0x76b, 0xffffa971, 0x8ba1, 0xffffb512, 0x22f3, 0x8ae3,
    0x4217, 0x70e6, 0xffff8854, 0xffffa794, 0x69dd, 0xffffea58, 0x30f6, 0xffffa42d,
    0xffff9908, 0x5e1e, 0x2fd4, 0x329, 0x775a, 0xffff95b2, 0xffffa71e, 0xde7,
    0x2e22, 0x776e, 0x16d4, 0xffff8616, 0xffffb167, 0xffff85b5, 0x57da, 0x72eb,
    0xffffbaf7, 0xffffc299, 0x59ef, 0xfae, 0x1907, 0x4adb, 0x7242, 0x5bd3,
    0x189e, 0x5ad4, 0xffff8e3c, 0xffffedaa, 0xbe0, 0xffffffdc, 0xd45, 0x2ef8,
    0xffff7cd2, 0xffffaddd, 0x685a, 0x832e, 0xffffcf75, 0xffffd4dd, 0xbd6, 0x149f,
    0x3cdb, 0x7691, 0xffffc1e2, 0xffffa1c4, 0x7548, 0xffffa014, 0xffffe53b, 0xfffff6f1,
    0xffffeecb, 0xffffa681, 0xffffafc8, 0x6811, 0x875b, 0x1578, 0xffffdcbe, 0xffff8206,
    0x483f, 0xffff7c5c, 0xffffbf83, 0x2b71, 0x7789, 0xffff733b, 0xffffe5d4, 0x5b88,
    0x7751, 0xffffc109, 0x4a86, 0x7284, 0x67d8, 0x28d4, 0xffffa41e, 0xffff7baf,
    0x761d, 0xffffff5a, 0x3e9e, 0x4e25, 0x2a7a, 0xfffff846, 0xffff873f, 0x43a9,
    0xffffeeea, 0xffff840b, 0x716f, 0xffffacf0, 0x5da3, 0xffffb902, 0xffffaf05, 0x4b57,
    0x73da, 0xffff956d, 0x4cf1, 0x7716, 0x33dd, 0x464, 0xffffeb6c, 0x4007,
    0xfffff3b4, 0x1fe3, 0x721, 0xffffe758, 0xffffabb3, 0x19d8, 0xffffbc97, 0xffff751d,
    0x7cc7, 0xffffb5e3, 0xffff8625, 0x8590, 0xffff8fb2, 0x168b, 0x8a88, 0x5368,
    0x7a0a, 0xffffff50, 0xffff7c26, 0x2c26, 0x5a95, 0xffffd991, 0x19e2, 0xffff7a6d,
    0x3e4b, 0x2e49, 0x4b7a, 0xffffcaf0, 0xffffff91, 0x1fc2, 0x4ed5, 0xfffff2a5,
    0xffffcc85, 0x52ac, 0xffffcef3, 0x13ae, 0xffff7590, 0x4c03, 0x860a, 0x1715,
    0xfffff3b6, 0x3e42, 0xec, 0x5e30, 0x7f7b, 0xffff8325, 0xffffcc59, 0x3c5a,
    0x1730, 0xffff84b9, 0x543c, 0xffffc431, 0x210c, 0xffffff67, 0x3247, 0x78fa,
    0x6646, 0xffffb35a, 0xffffebe6, 0x74d8, 0xffff7d83, 0x696b, 0x2502, 0xffff898c,
    0xffffa4a3, 0xffffe1a7, 0xffffd2c6, 0xfffff1db, 0x8425, 0x4794, 0xfffff992, 0x5bec,
    0xffff999e, 0x4e2, 0xffffa80f, 0xffffee33, 0x6505, 0xfffffe03, 0xffffb529, 0x14ad,
    0xffff8511, 0xffffd437, 0xffffd6f4, 0xffffa716, 0x6fbe, 0xffffb2c5, 0x28fb, 0x9a7,
    0xffff72d3, 0xffffe490, 0x7ad4, 0x534e, 0x883e, 0x69a3, 0xffff9ebc, 0x36c1,
    0x3ac1, 0x8cc2, 0x4363, 0xffff980d, 0x42a1, 0xffff94ce, 0x7fa5, 0x59d0,
    0x2d35, 0xffffaddc, 0xffffc82e, 0x679d, 0xffffff04, 0xfffff390, 0x75c1, 0xfffff28e,
    0xffff8261, 0x7609, 0x6cc6, 0xffffeb00, 0xffffcdb1, 0xffff97c2, 0x2ec8, 0x7a4d,
    0x5a53, 0x4a2b, 0xfffff160, 0xffff7c7e, 0x8af1, 0xffffa8aa, 0x8a2, 0xffffd8c4,
    0x15e7, 0xffffa490, 0x35bb, 0x3846, 0x8b8f, 0xfffff39f, 0x115f, 0x26ed,
    0x3580, 0xffffdd48, 0xffff763b, 0xffffa8ec, 0xc2d, 0x7e4, 0x73c, 0xffffec28,
    0xffffb1ff, 0xffffd69c, 0xecc, 0xffff8a47, 0x1570, 0x5278, 0x7478, 0xffffa96c,
    0x87f7, 0x6c6d, 0xffff9c2a, 0x3e44, 0x4451, 0xffffe66f, 0x77a7, 0xffffa196,
    0xfffff4c8, 0x4d8, 0xffffda98, 0xffffb107, 0xffffe5f6, 0xffffd073, 0xfffffb60, 0xffffd970,
    0x7134, 0x1b66, 0xfffffed6, 0xfffffffb, 0x2f5d, 0xffffc33f, 0xffffb63a, 0x17aa,
    0xffffb6c7, 0xffffb5dd, 0x9a7, 0xffffb6ee, 0xffffce02, 0x4f50, 0xefc, 0xffffe4de,
    0xffff9e9b, 0xffffd397, 0xffffabfb, 0x771d, 0x7313, 0xffff8f5d, 0xbc, 0xffffa767,
    0xffff7a43, 0x1a04, 0x7e99, 0x5029, 0x2c61, 0xffffcf61, 0x6e6f, 0xffff8786,
    0x832e, 0xfffff079, 0x76f0, 0x6720, 0xb72, 0xffffc9bb, 0xffffb384, 0x8b40,
    0x4f6f, 0xffff9c0e, 0xffff7248, 0x8721, 0xffffb61c, 0x3264, 0x4af3, 0x26fa,
    0xffff78cb, 0x3f99, 0x519b, 0x3d38, 0xffff9e3c, 0x6363, 0xfffff082, 0x61,
    0x80e3, 0x882c, 0x1ad9, 0xfffff42c, 0xffffe5d7, 0xffff78aa, 0x7f81, 0x6333,
    0xe4b, 0x99, 0xfffff37c, 0xffffd8b0, 0x5f1f, 0xffffa399, 0x2fe4, 0x413f,
    0x2fb, 0x2d48, 0xffff9550, 0xffffd960, 0x8c72, 0xffff83f3, 0x3d50, 0x85ec,
    0xffffb965, 0x1cdd, 0xffff8626, 0xffffa6c0, 0xffffa058, 0xffffb314, 0x77c1, 0xffffa6dc,
    0x73d6, 0xffffbbbb, 0xfffffbf9, 0xffffcf13, 0xffffd10c, 0x8c3e, 0x5f5c, 0x4af5,
    0xffffd141, 0xffffd407, 0xffffc119, 0xffff86b0, 0xffffb16c, 0xfffff4f1, 0x404a, 0x6bab,
    0xffff9021, 0xffffd5f5, 0xffff87b0, 0xfffffb85, 0xffffbc33, 0x3ef, 0x16dd, 0xfffffc0a,
    0x346, 0xf7b, 0xffffb212, 0xffffe5b9, 0x1c45, 0x5a37, 0xffff8f95, 0xffffccda,
    0x11d2, 0xffff74a0, 0x52c1, 0xfffff70b, 0xffff90dd, 0x5ab1, 0x3ecb, 0x70d0,
    0x8ac4, 0xedb, 0x1091, 0xffff874d, 0xffffdce4, 0x4603, 0x157f, 0x4db,
    0xffffb596, 0x5604, 0xffff7a31, 0xffffe7e6, 0x3bc2, 0x1ec0, 0x861, 0xffffbb57,
    0xfffff94b, 0xffff9fb4, 0xffffea52, 0xfffff479, 0xffff9909, 0xffffa95f, 0xffffa074, 0x8889,
    0x198b, 0x56f4, 0x3423, 0x8241, 0xffffe3ff, 0xffff881a, 0x4e97, 0xffffcf1b,
    0xffffa603, 0x3957, 0xfffff6d5, 0xfffff0b2, 0x8464, 0x1f13, 0xffffe04e, 0x3ed2,
    0x1636, 0x19df, 0xffff9d9c, 0xffffb4af, 0xffff764e, 0x787f, 0x42a6, 0xffffda01,
    0x5a29, 0x8d78, 0x5fae, 0xffffe92e, 0xfffff130, 0x7c51, 0xffffbf50, 0xffffb867,
    0x2ddf, 0xffffb349, 0xffffd0e9, 0x6b0b, 0x6d50, 0xffffd468, 0xffffa3b0, 0xffff97d8,
    0x1960, 0xffffdbbb, 0xffffa4af, 0xffffbd37, 0x2ef3, 0x2437, 0xffffd17e, 0x13e5,
    0x54e0, 0xffffc59f, 0x22bb, 0xffff780f, 0x6239, 0xffff7d96, 0xffffda9d, 0x6e34,
    0xfffface6, 0x295a, 0x2719, 0xffffda03, 0xffffabc0, 0x23a3, 0x1cf2, 0xffffaa50,
    0xfffff1aa, 0x6565, 0x75b1, 0xffffc795, 0xffffb3d6, 0xffffac07, 0xffff8ab8, 0xffffe135,
    0x6be2, 0xffff9a21, 0x66be, 0x1ede, 0xffff9b45, 0xffffddb2, 0x19d9, 0xffff9a42,
    0x1470, 0xfffffd5c, 0x1e7e, 0x6407, 0x6ab4, 0x9cd, 0x1ce7, 0x7246,
    0xffffcc0e, 0x334a, 0x8d32, 0xffffdd26, 0xffff876d, 0x5f42, 0xffffce4d, 0x746f,
    0x23a2, 0xffffbddd, 0x1b98, 0xffffc9e3, 0xffff921c, 0xffffb30e, 0x3477, 0xffffa587,
    0x4067, 0x18a0, 0x361e, 0xffd, 0xffff880f, 0xffffef9a, 0xffffce51, 0x3ed,
    0x139b, 0x4957, 0xffffc1b0, 0x5718, 0x4e72, 0x898c, 0x1e76, 0xfffffc63,
    0x5a7e, 0x3388, 0xffff8b15, 0x8c3, 0x42ed, 0xffff9b9a, 0x1fff, 0xfffff544,
    0x66a4, 0xffff7c9f, 0xf3d, 0x8823, 0xffffab00, 0x8d96, 0xffff9a08, 0x16d3,
    0x55a3, 0xffffc3a3, 0x5f6e, 0xffffa6c2, 0xffff982e, 0xffffe233, 0x3b85, 0x4b3b,
    0xfffff53f, 0x31d2, 0x58f0, 0x8345, 0xffffb052, 0x8516, 0x1013, 0x3e91,
    0xffffdf3d, 0xffffb256, 0xffff8937, 0x7307, 0x6544, 0xffff9898, 0x26fc, 0x7aaa,
    0x5d8c, 0x45c4, 0x8168, 0xffffe0d2, 0xffffa15f, 0xffff8c32, 0x23e2, 0x2f6d,
    0x4e73, 0x5b19, 0xfffff7a0, 0x1530, 0x8a57, 0x5994, 0x7668, 0x8658,
    0x7810, 0x5ae5, 0xffffdd59, 0xffffe2e3, 0x6ade, 0xffff84ab, 0x2286, 0x3324,
    0x34d6, 0x6fa3, 0xffff9c8c, 0x1649, 0xffff9152, 0xffffde80, 0x140c, 0xffffe31f,
    0xffffab3a, 0x85b6, 0x870d, 0x21cd, 0x33ee, 0xffff8aa8, 0xffffcb20, 0x584,
    0xffffcdb5, 0x4b6c, 0x4b54, 0x559c, 0xffffc9b9, 0xffffc227, 0xffff93ec, 0xffffaf9c,
    0x2314, 0x4cd1, 0xffff9b8a, 0xffffa7f7, 0xffffe946, 0x6412, 0x8698, 0xfffff049,
    0xffffe24f, 0xffffbc02, 0xfffff5dc, 0x248b, 0xffffa1a1, 0xfffff591, 0x17f8, 0x7c7f,
    0x2a38, 0xffffc4b7, 0x50f4, 0x4567, 0xffffe9b3, 0x1139, 0xffffdc63, 0xffffaf43,
    0xffff921e, 0x38b5, 0x6f7c, 0x7e35, 0x4cb7, 0xffffdbdb, 0xfffffc86, 0x14e0,
    0xffffb500, 0xffff8fd7, 0xffffc44e, 0xffffe8ae, 0x615, 0x73de, 0x513c, 0xffff8c2d,
    0xffffa65e, 0x733b, 0xffffaa1a, 0xffff9823, 0x390f, 0x81e5, 0x6388, 0x2547,
    0x618c, 0xffffc2b5, 0xfe5, 0x61cf, 0xffff8162, 0xffff8c51, 0x8872, 0x5eae,
    0x5a61, 0xffffab35, 0xffff790b, 0xffff894f, 0xffff7e7f, 0x2ef3, 0xffffa954, 0xffff94a3,
    0xffffec89, 0xffffe3e7, 0x886c, 0xffff9f5c, 0x6429, 0x5828, 0xffffb33b, 0x38d4,
    0x3fb6, 0xffffe5df, 0x5e4, 0xffffa316, 0xffffdea1, 0xffffefe5, 0xbb0, 0xf7c,
    0xfffff415, 0x7f2, 0xfffff4ab, 0x8d31, 0xffffb9b1, 0xffffbbdd, 0xffffc868, 0xfffff245,
    0xffff91ae, 0x62db, 0xffffd076, 0xffffc4c5, 0x5575, 0x43af, 0xffffe6f3, 0x7cc1,
    0x6c8b, 0xffffb56c, 0xffffe101, 0xfffffe07, 0xffff8a88, 0xffff9931, 0xfffff933, 0xffffd4bd,
    0x355e, 0xffffd3df, 0x1e2d, 0x5b90, 0x6ce5, 0xffffff81, 0x5d0e, 0x514b,
    0xffffa086, 0x1caf, 0x300d, 0xffffc1e2, 0x357c, 0x2820, 0x4be, 0xffff9c0b,
    0x2e68, 0xffffb03b, 0x8ab1, 0x2aed, 0x3cc8, 0xffffa250, 0xffffca57, 0xffff8fe0,
    0xffffbc0e, 0xffffa87c, 0x3681, 0xffffff03, 0x6f96, 0xfffff6e8, 0x3818, 0xffff91eb,
    0x460a, 0xffffc57c, 0x23bf, 0xffffa010, 0x6ae0, 0x38fa, 0x6c95, 0xffffe509,
    0x2594, 0xffff892e, 0xffffd6fd, 0x4dbf, 0xffff7bca, 0x595b, 0x5265, 0xffff722c,
    0xffff9bbe, 0x6f1b, 0xffffa0d6, 0xffffb61d, 0xfffff32c, 0xac6, 0xffff8448, 0x37b3,
    0xffffb59c, 0x6132, 0xffff820a, 0xffffb87e, 0x7e80, 0xffffddb7, 0xffff84db, 0xffff868b,
    0x1498, 0x5ece, 0x4761, 0xffffbe71, 0xffff7b6f, 0x2492, 0x6b0e, 0xfffffcba,
    0xa45, 0xd5d, 0x361d, 0xf45, 0x82fe, 0xffffd7cf, 0xffffc64e, 0xffff8ad6,
    0xffffb43b, 0xfffff00e, 0xffff7b5b, 0xffff9858, 0x3756, 0xffffe97b, 0x6167, 0x52b9,
    0xfffffc14, 0x4bf6, 0x2c11, 0x5c7b, 0x75fc, 0xfffff1b7, 0x47f4, 0xffffc8ca,
    0x5fbc, 0xc3f, 0xffff9e06, 0xffffb109, 0xffff791e, 0x6661, 0x8942, 0xffff92b4,
    0xd4f, 0x15a8, 0x625d, 0x3878, 0xffff9a70, 0x636b, 0xffffad1a, 0xfffffc36,
    0x1abe, 0xfffff303, 0x4b0a, 0xffffe7cc, 0xffff904c, 0xffffe288, 0x5acd, 0xfffff71e,
    0x3252, 0xce1, 0x2db2, 0xffffc97a, 0xfffff8e7, 0xffffbb28, 0x7a7d, 0x6ed5,
    0xffffae7d, 0x8dbe, 0xffff744e, 0xffff8e03, 0x6cb, 0x86a7, 0xffffdc22, 0xffffd8fb,
    0xffffd18d, 0x4626, 0x8c87, 0xffffc3ae, 0xffffb882, 0x689a, 0x3791, 0xffffc0a0,
    0x7223, 0x3c, 0x8fe, 0xffff9ecf, 0xffffd89a, 0xffff7e2d, 0xffffa145, 0x56e7,
    0xfffffb34, 0x480c, 0xffffb7b6, 0x4d54, 0xffffc5f6, 0xffffde25, 0x4d3e, 0x7302,
    0xffffdb67, 0x4fb7, 0xfffffb02, 0x8765, 0xffffab7b, 0xda7, 0xffffb04f, 0xffffc9e5,
    0x15b6, 0x2718, 0xffffc98c, 0xffffe2eb, 0x8011, 0x8b74, 0x7aa7, 0xa1a,
    0x5d48, 0xffff9ffa, 0x1d7, 0xffffef63, 0xffff9746, 0x7c5b, 0xffff816e, 0x6c68,
    0x156f, 0x85b8, 0x16bc, 0xffffc689, 0xffff8006, 0xffffe2ec, 0xfffff102, 0xffffeb7d,
    0x8956, 0xfffff640, 0x4713, 0x7bad, 0x41bb, 0xffff9f79, 0x3691, 0xffff7b9d,
    0x7ca6, 0x5c98, 0x81e4, 0xffff9084, 0x7825, 0x543a, 0xffff8b4b, 0xffffd2f9,
    0xffff7f0a, 0xffff7655, 0x665e, 0xffffd3df, 0xffff8b05, 0x2da3, 0x2c10, 0x4dcf,
    0x23e0, 0x4e27, 0x5fb6, 0x82f3, 0xffffe5cb, 0x6d98, 0xffff9691, 0xa4a,
    0x3f51, 0x2573, 0x894c, 0xffff8107, 0x5091, 0xffffe034, 0x83db, 0x2029,
    0xffff8d63, 0x6ee6, 0xffff92d2, 0xfffffe7e, 0x5f72, 0x6704, 0xffffd1f6, 0x4d40,
    0xffffb1f6, 0x2766, 0x4b84, 0x7e47, 0x728a, 0x51f7, 0xffff9a48, 0x1149,
    0xffffc964, 0x456f, 0xffffa797, 0x6112, 0xffff7e4c, 0xffffea92, 0x8a8b, 0xffffc9bf,
    0xffffbc0c, 0x6591, 0xffffd69c, 0xffffe54f, 0xffff7adb, 0x581b, 0xffffad1f, 0xffff9607,
    0x3e51, 0xffffe644, 0x80a4, 0x272e, 0xffffd8d5, 0x4c15, 0x639a, 0x7345,
    0xffff7d10, 0x1f97, 0xffffe213, 0xffffcd19, 0xffffb907, 0x7196, 0x348c, 0xffffcd02,
    0xffffc4b0, 0xfffff3d3, 0x56d5, 0xffff7712, 0x2415, 0x19c9, 0xffffaa34, 0x5be0,
    0xffffbe3d, 0x3edb, 0xffff7ba6, 0xffff8704, 0xffff9b22, 0xffff7398, 0x1ad2, 0x2b12,
    0xfffffa9e, 0x82a0, 0x289f, 0x20c1, 0xffffa302, 0xffff8bac, 0x5528, 0x5b36,
    0xffff9f0e, 0x300, 0x76ab, 0xe31, 0x54dc, 0x14c2, 0xfffff3f7, 0xffff9727,
    0xffffb8a1, 0xfffffd6c, 0x668c, 0x12ce, 0x5e2b, 0x837f, 0x79d9, 0xffff9f2c,
    0xffffe8c0, 0x5569, 0xffffa931, 0xffff9828, 0x5447, 0xe70, 0xffffc612, 0xffffbdc8,
    0xffff8100, 0xffff948f, 0xffffd762, 0x165, 0x7caf, 0xffffe5ba, 0xffffd76a, 0x1b3f,
    0xffffbace, 0x75b9, 0x266, 0x3be3, 0xffffb139, 0xffffdf94, 0x2528, 0xffff85e5,
    0x63ec, 0xffffea79, 0x784, 0x12c5, 0xffffcf6d, 0xffff941e, 0xffffd6c0, 0xffffe17c,
    0xffffde73, 0x317d, 0xffff7430, 0x2eea, 0x2d4d, 0xffff7937, 0xfffffb7c, 0xffff802d,
    0xffff902a, 0xfffff7d6, 0xffffbdb7, 0xffffdf44, 0xffffd10a, 0xffffc6a9, 0x36fe, 0xffffc98c,
    0xffff732c, 0xffffe42e, 0xffffd1e4, 0x6c5e, 0xffffa8ab, 0x7624, 0xffffdd12, 0xffffaf68,
    0x4d98, 0x5f15, 0x865d, 0xffff8d23, 0x5266, 0x276c, 0x295e, 0x1d29,
    0x5e0b, 0x772f, 0x2942, 0x459e, 0xffffe4eb, 0xffff73dd, 0xffffd004, 0xffff886f,
    0xffffcaf9, 0x18e0, 0xc66, 0xffffd08d, 0xffff7a9f, 0xffffd290, 0x88d8, 0xffff7c4b,
    0xffff86dd, 0xe4c, 0x15ef, 0xffff99f5, 0xffffde0e, 0x44db, 0x6855, 0x29de,
    0x3458, 0xffffc7a8, 0xffffdc32, 0xffffb3ec, 0x6e1b, 0xffff8dfd, 0x86a6, 0x685d,
    0xffffee8d, 0xffff92e9, 0xffffc182, 0xfffff271, 0x39d5, 0xffff86a2, 0xffff7472, 0xffffecba,
    0xffffd44d, 0xffff7fef, 0xffffd860, 0xffffeb6d, 0x3822, 0xffff91b2, 0xffffe1ea, 0x657f,
    0xffff98be, 0x7c56, 0xffffe379, 0x1286, 0xfffff440, 0xffffefd4, 0xffffc00c, 0xffffef9d,
    0xffffbb0a, 0xffffe423, 0x717a, 0xffff8177, 0xffffc56c, 0xffff87c0, 0x389, 0xffffbd6f,
    0x6a85, 0x6072, 0xffff8991, 0x6768, 0xffffb310, 0x55a0, 0x3566, 0xffffa763,
    0x6ad8, 0xffffecf0, 0x6e47, 0x460f, 0xffff74c3, 0xffffa827, 0xffff8ed2, 0x63a8,
    0x6785, 0xffff9ab6, 0x8721, 0xffffb48d, 0xffff8e1d, 0x1b24, 0x4cad, 0x32a8,
    0xffffa063, 0x3cc6, 0x3f51, 0x27c7, 0x32e2, 0xffff9cf7, 0xffffeca9, 0x6a39,
    0x58fa, 0x305d, 0xffffb237, 0xffff8301, 0x2b29, 0x4d40, 0xbfb, 0xffffea6f,
    0x15a1, 0xffffcc4f, 0xffffc735, 0xffffdaca, 0x26e5, 0xffff9e2f, 0xffffc05a, 0xffff8cf2,
    0x7a37, 0x4531, 0xfffffa02, 0xffffb210, 0x8633, 0x4f0f, 0x754, 0xffffed54,
    0xffff8740, 0x59d2, 0xffff767e, 0xffff855a, 0x3d85, 0x71b9, 0x72cd, 0x4d3b,
    0x78a1, 0xffffa6c1, 0x6c3e, 0xffff9317, 0x2926, 0x119a, 0x44d2, 0xffffb033,
    0xffff935e, 0xffffc224, 0x4ba1, 0xffffdba2, 0xffffb9b7, 0x17e4, 0xffff8b75, 0x2f37,
    0xffff73b2, 0xffffcc5c, 0xffff88bc, 0x213a, 0x47b0, 0x13d5, 0x3ca1, 0x51a7,
    0x2e56, 0xffffc38a, 0x7f7a, 0xffffe80b, 0xffff8832, 0x7270, 0xffff8f10, 0xffff7ca1,
    0x6c56, 0x8390, 0xffffb0bf, 0xffff9200, 0x6bbb, 0x46c8, 0xfffff4db, 0x2ab3,
    0xffffa2c1, 0x7288, 0xfffff4a6, 0x5ec3, 0x7c3, 0xffff81af, 0x3cc2, 0x28f7,
    0x4a58, 0xfffff026, 0x7ff0, 0xfffffc62, 0xffff9148, 0xd8f, 0x185, 0x59f4,
    0x1caa, 0x39dd, 0x3787, 0x4a31, 0xffffed74, 0x4336, 0xffffa9ea, 0x4646,
    0xffffd6f7, 0x175a, 0xffffe833, 0xffff95e8, 0xffff79ef, 0x7509, 0x68b8, 0x5445,
    0xffffe6a9, 0x49e4, 0xee4, 0x5e83, 0xffff9812, 0xffff9b80, 0xffffcd5b, 0xffff905e,
    0x6959, 0x38cf, 0xffffbce0, 0x758b, 0x3d88, 0xffffc47d, 0xffff86ca, 0x1c6a,
    0x10f2, 0x2934, 0xffffeb47, 0xffffa621, 0xfffff453, 0x8822, 0xffffd84d, 0x88a8,
    0xffff7738, 0x2211, 0x278b, 0xffffb4fd, 0x4a25, 0x24a1, 0xffff9982, 0x4316,
    0x1f4, 0xffffec51, 0xffffaf4d, 0xfffff10f, 0x452d, 0xffffed98, 0xffff89e2, 0xffff9770,
    0xffff7393, 0x2e9a, 0xffffa805, 0x870c, 0xffffb79d, 0xffffdcb9, 0x190f, 0xffffaf36,
    0xffffae0b, 0x35a8, 0xffffcb81, 0x49b6, 0x5b81, 0xffffad9f, 0x4b00, 0x59f6,
    0xbcf, 0x2bf6, 0xffff83b9, 0x56a, 0x478b, 0xfffff9a6, 0xffffefb1, 0xd52,
    0xffff977e, 0xfffffde7, 0x2281, 0x486b, 0xffff7a45, 0x38, 0xffffa31e, 0x545b,
    0x5f67, 0x759e, 0x7227, 0x4710, 0xffffda15, 0xffffde83, 0xffffb16f, 0x445a,
    0xffffb2a9, 0xffffe77a, 0x8ff, 0x136f, 0xffffaa07, 0xffff739c, 0x16f8, 0xffffd05a,
    0x1bc1, 0xffffbd49, 0x6534, 0xffff8187, 0x30d6, 0xffff7c5a, 0x8038, 0xffffc927,
    0x81d3, 0x6e7, 0x7d71, 0x5eed, 0x2dbc, 0x7779, 0x49d9, 0xffffa59c,
    0xffff7c2e, 0xffff7a46, 0x1461, 0xffffcbc6, 0x47cd, 0x6df4, 0xffff9c8b, 0xffffba56,
    0xffffc1aa, 0xffffe2c4, 0xffffb8b3, 0x354f, 0xffffba6f, 0x7e32, 0x88d2, 0x1dda,
    0x65c3, 0xffff7a23, 0xffffa941, 0x772d, 0xffffa8e4, 0x6cac, 0x6006, 0xffff8cc0,
    0x2c22, 0xffff8f93, 0xffffd510, 0x4ac1, 0xffffcac2, 0xffffbfc5, 0xffff772e, 0xffffd90e,
    0xffffc04b, 0x1858, 0xffffdb53, 0x4730, 0xffff87ca, 0xfffff776, 0xb2b, 0x5f04,
    0xffff7deb, 0xffffafc4, 0x273c, 0xffffa9ad, 0x2f96, 0x1df3, 0xffff99ab, 0x3ccb,
    0x8cb2, 0x69c, 0xffffb855, 0xffffa904, 0x8a40, 0x1b30, 0xffffbfe7, 0x8a23,
    0x70f8, 0x57da, 0xffff75fe, 0x2214, 0x2be1, 0xffff990b, 0xffff9394, 0xffffe908,
    0xffffb2c4, 0xffffa067, 0xfffff7c6, 0xffff97cd, 0xffff7498, 0x3af8, 0x1241, 0x10e3,
    0xffffa621, 0xfffff296, 0x698e, 0xffffa28b, 0xffff9084, 0x12cf, 0xffffb1f9, 0x4359,
    0x336c, 0xffffcf1e, 0xffffa763, 0x80bf, 0x4019, 0x47d5, 0xffffec7a, 0xffff83f6,
    0xffffd75a, 0xffffb050, 0xffff9104, 0xfffffb14, 0xffffd821, 0xffff8b8d, 0xffffb3fd, 0xffffebb6,
    0x124e, 0xffffd263, 0xffff7eab, 0xb78, 0xffffb115, 0xffffa4e5, 0xffffe296, 0x1f8,
    0xffffdd28, 0x3378, 0xffff9498, 0x3617, 0xffffb7c3, 0xffffe507, 0xffffe6ae, 0x47b2,
    0x18a5, 0xffff77c3, 0xffffa734, 0xffffc105, 0xffff8925, 0x7add, 0xfffffab0, 0xffffe3ec,
    0x39d4, 0x74ba, 0x56ea, 0xffffebec, 0xffff8e36, 0x3b63, 0x931, 0xfffff745,
    0x81c5, 0x368d, 0xffffbca4, 0xffff80b1, 0xffffe01f, 0xfffff52c, 0xffffacf4, 0x486f,
    0xffffc5e0, 0xfffffaae, 0x10d4, 0x5ea8, 0x4832, 0x38b4, 0x6894, 0x6002,
    0xffffdf3b, 0xffffa4a1, 0xffffe890, 0xffffb7b1, 0x3fee, 0x3c88, 0x1b52, 0xffff8883,
    0x1f6c, 0xfffff5ac, 0xffffc0cb, 0xac9, 0xcd4, 0x14f7, 0xffffa823, 0x21e2,
    0xffff8831, 0x5526, 0xffffc6a1, 0x4551, 0xffffa492, 0xffff9837, 0xffffa222, 0xffffde9d,
    0x1efc, 0xffffec4e, 0xffffd75b, 0x3268, 0xffffc8d6, 0xffff7a3f, 0x4c9b, 0xffff86a0,
    0x45e3, 0xffffddfb, 0xffff806b, 0x7aef, 0xffffcfa4, 0x30ef, 0x7f2b, 0xffffa3bf,
    0x46d7, 0xfffff316, 0x3720, 0x6dd9, 0xffffdb02, 0xffffbc61, 0xffffdd72, 0x81b9,
    0x1bf4, 0xffffb670, 0xffffcd6c, 0x37d8, 0xffffbd23, 0x4df6, 0xfffff2eb, 0xfffff687,
    0x8b59, 0xffff909b, 0x34cd, 0xffffc786, 0x143b, 0x8570, 0xffffc38e, 0x965,
    0xffffd3a1, 0xffffac12, 0xffffbb63, 0xffffe93f, 0x12d2, 0xffffe053, 0x3b2b, 0x4bcd,
    0x52f2, 0xfffff538, 0xffffb301, 0xf71, 0xffffb774, 0xffffd5ba, 0xffffbe11, 0x1121,
    0xffffa83d, 0x1a5a, 0x1ce, 0x8a49, 0xffffccb0, 0x82d2, 0xffffb440, 0xffff8a82,
    0xffff91fe, 0xffff8bad, 0x3e1d, 0x5005, 0xffffb167, 0xffff8f02, 0x1a0b, 0xffffc6d1,
    0x6303, 0xffffb2fe, 0xffffae6b, 0x507c, 0xffff907f, 0xffffeecd, 0xffff801b, 0x7b03,
    0xffffe69a, 0xffff8454, 0xffff8110, 0x2195, 0x60df, 0xffffe944, 0xffff7ac8, 0x21d,
    0x798, 0xffffed4d, 0xffff78b9, 0x36fa, 0xffff7616, 0xffffbf0e, 0x32c0, 0xffffcc92,
    0x294d, 0x819b, 0x2413, 0xffffaa63, 0x7ae7, 0xffff72bb, 0x6505, 0xfffff0e8,
    0x7b0f, 0xffff7b00, 0xffff8a4b, 0xffff8f23, 0x2336, 0xffffe49d, 0xffff9a9c, 0x478d,
    0xffffc085, 0x6059, 0xffffd216, 0xffff9e9b, 0x5e49, 0xffff7f3e, 0x6038, 0x6ad9,
    0xffffc10b, 0xffffd364, 0xffff7ecc, 0x6fef, 0xffff7809, 0xffffc298, 0x835f, 0xffffb70d,
    0xffffbc76, 0xffffc2fa, 0x1779, 0x247d, 0xffffdbe8, 0xffffb8de, 0xffffb96f, 0xffff81ff,
    0xffffbea1, 0xffffa830, 0xffff7fcd, 0xfffff310, 0x51fe, 0x65dd, 0xffff9f9f, 0xffffc799,
    0xffff8390, 0xffffd9da, 0xffffbb03, 0xffffb886, 0x6e67, 0x5799, 0x677b, 0x45ad,
    0xffff934b, 0x70b5, 0x44d0, 0x2f7e, 0xffff7568, 0x15b2, 0xffffbb0d, 0x7bf6,
    0x2605, 0x2b90, 0x4916, 0xffff9cd0, 0xffffaef8, 0xffffe9ab, 0x7fbe, 0xffffac1a,
    0x846, 0xffffc2d1, 0xffffbfba, 0x7699, 0xffffbfb5, 0xffffdef6, 0xffffbfed, 0x2d29,
    0xffffee6e, 0xffffb0c7, 0x8879, 0x8584, 0x3415, 0xffffc2e9, 0xffffc15a, 0xffffa8c4,
    0x3d0c, 0x31ab, 0xffffc3e1, 0xffff8bd4, 0x2ce5, 0x409c, 0x4243, 0xfffff9ce,
    0xffffecff, 0x27c6, 0xffffcddf, 0x6137, 0xffff96f2, 0xffff8d64, 0xffff9537, 0x8566,
    0xffffdf03, 0x6ef9, 0x7ada, 0x1413, 0x46e4, 0xfd7, 0x2c50, 0x7295,
    0xffff8827, 0x8938, 0x3392, 0xffffe413, 0x6e09, 0xffff811b, 0xffffba76, 0xffffc622,
    0x4554, 0xffffba5e, 0x6476, 0xffffb6f3, 0x2589, 0xffffcb99, 0x121a, 0x7e6d,
    0xffffd01a, 0x5bb5, 0xfffff271, 0x5031, 0x528d, 0x63f7, 0x7e28, 0xffffec61,
    0x18e, 0x1915, 0xffffaa49, 0xfffffd82, 0x6e94, 0x80c3, 0xfffff9b9, 0xffff9231,
    0x2b46, 0xffffb3c1, 0x8ef, 0x220e, 0xffffa349, 0x3649, 0x8397, 0xffff981d,
    0x6ad9, 0xffffaee7, 0x1fa9, 0xffffab33, 0x1e07, 0x7698, 0x7732, 0xffffe853,
    0xffff7232, 0x4f9f, 0xffffcbbf, 0xffff7feb, 0x68ce, 0xffffbdf9, 0x17d4, 0x2ee8,
    0x12c4, 0x8112, 0xffffb67d, 0x4914, 0xffffd9a2, 0xffff9e22, 0x74c8, 0xffffd9d8,
    0x5ed2, 0xc27, 0x3957, 0x39ca, 0xffffae61, 0x4edd, 0x15d8, 0x50b9,
    0x5077, 0xffff9787, 0x421a, 0xffff7ec0, 0xffffb93c, 0xffff922c, 0x867f, 0x855c,
    0xffff91fc, 0xffff8bc5, 0xffff8a93, 0x3e3f, 0xffff7c92, 0x772f, 0xffffaedc, 0x474e,
    0xffffb582, 0x135b, 0xffffb468, 0xfffff11d, 0x6298, 0x43bd, 0xffff9698, 0x43e1,
    0xffffc5a7, 0xfffffed5, 0xffffd9be, 0x4176, 0x322d, 0x6eef, 0xffffbdda, 0xffffce75,
    0xffff990d, 0x1857, 0xffffe0bc, 0x639e, 0xffffb5de, 0xfffffa1b, 0x70c8, 0x3404,
    0xffffd256, 0xffffd016, 0x7b8b, 0x69ad, 0x843c, 0xffffe02d, 0xffff7409, 0x4bc2,
    0xffffa87d, 0xffff7408, 0xffffd4d3, 0x27a2, 0xffff74a7, 0xffffc225, 0xffffc7a1, 0xffffcaa1,
    0x3a52, 0x2fe3, 0x36c3, 0x4f3c, 0xffffb5b5, 0x1ec0, 0xffffac64, 0x5f2c,
    0x1f24, 0xffff9dbf, 0x482e, 0x384b, 0xffffb6ca, 0x1acf, 0x66d6, 0x2652,
    0xffffd61d, 0xffff88fc, 0xffff7bed, 0x1862, 0xffffcf25, 0xffffb8e2, 0xffff9823, 0x526f,
    0xffff8e92, 0x6309, 0x4888, 0xffffe6f9, 0x631, 0xffffd94a, 0x1cd3, 0xffffa01b,
    0x43d8, 0x2793, 0x6557, 0x794b, 0x1383, 0x269, 0x1240, 0xffffe15c,
    0x69c5, 0xffffe7b1, 0x8d62, 0x2ecc, 0x7ab3, 0xffff7c8a, 0xffff7d9c, 0x7270,
    0x5c06, 0x7667, 0x1006, 0x7c60, 0x53af, 0xffff8990, 0x4bf4, 0x7183,
    0x2675, 0x30f1, 0x2478, 0x6124, 0xffff8265, 0x116e, 0xffffab22, 0xffffda7e,
    0xffff8517, 0x89fc, 0xffff7a6e, 0xffffb9f7, 0xffffd29e, 0xffffa22b, 0x461, 0xffff8708,
    0x1bcb, 0x7e6d, 0xffffc54a, 0x5d4d, 0x88a1, 0xffffdf3b, 0x1d91, 0x12b6,
    0xffffeb16, 0xffffe8ea, 0x30f0, 0xffff7427, 0xffff7d09, 0xfffff64e, 0xffff8896, 0xffffa354,
    0xfffff72e, 0xffff81d9, 0xffff996c, 0xffff74a4, 0xffffc3cf, 0xfffff2d2, 0xffffbf2c, 0xffff741d,
    0xffffd89c, 0xffffc38a, 0xffffde7d, 0x5f1c, 0xffffb1bb, 0xffffa21f, 0xffffb38e, 0x8236,
    0xfffff3ed, 0xffffce5d, 0x585e, 0xffffbe23, 0xffff8372, 0xffffaf4d, 0x3fcf, 0x3927,
    0x5dda, 0xffffa074, 0xf76, 0x6969, 0x4196, 0x875e, 0xffffb681, 0x35bc,
    0xffffbf70, 0x15af, 0xfffff405, 0x8b2a, 0x6d4c, 0x218d, 0x89bc, 0xffff9efe,
    0xffffc56b, 0xffff942b, 0xffff8aa0, 0x4739, 0x6f8f, 0xffff8a85, 0x6c68, 0xffff958c,
    0xffff9507, 0xffff9771, 0x3fb7, 0xffff8354, 0x6186, 0xffff90d7, 0x1520, 0xffffe018,
    0x3b58, 0x411d, 0xffffdc5f, 0x1ecd, 0xc86, 0xffffa92a, 0xffffeaa6, 0x73a,
    0x3def, 0x58de, 0x4933, 0x675d, 0x5e3, 0x25e2, 0x3eb, 0x714d,
    0xa3a, 0xffff8420, 0xffffcb78, 0xffff887a, 0xffff7747, 0xffffff76, 0x280b, 0x2abd,
    0xffffbdcd, 0x7dc1, 0xffffac20, 0xffffc30a, 0xffff7238, 0x27f3, 0xffffce4b, 0x398d,
    0x4244, 0x3750, 0xffffc875, 0xffffc657, 0xffff9c8c, 0x3779, 0x55ce, 0x49d2,
    0xfffff9b4, 0xffffd3a7, 0xffffade9, 0x3b41, 0x681f, 0xffff8812, 0xffff7a5a, 0xffffc989,
    0x49e6, 0x3783, 0xffffb5f4, 0x70ba, 0xffffbf48, 0x8933, 0x3314, 0x2047,
    0x111e, 0xffffd1e0, 0xffffea38, 0xffff779e, 0xffffabe9, 0xffffe109, 0xffff9c1c, 0x3fdd,
    0x157b, 0x2726, 0x480, 0xffff7635, 0xffffb05d, 0xffff82de, 0xcec, 0xfffff7d9,
    0xffffb171, 0x45f9, 0x8a9f, 0x1d04, 0x1b06, 0x80b, 0x39a9, 0xfffff58c,
    0x274c, 0x1abd, 0xffff7ae0, 0xffffc2a1, 0xffffce98, 0xffff9427, 0xffffa278, 0xffff8c58,
    0x31d6, 0x6f95, 0xef0, 0xffffd311, 0xffff95a0, 0x7c0b, 0xffffaf59, 0x934,
    0x73b3, 0xffff98df, 0xffffa574, 0x6069, 0xffffead8, 0x671f, 0x5c9f, 0x4354,
    0x23dc, 0x1c3f, 0xffffbc97, 0x22d2, 0xffffdd4e, 0x1239, 0x3af3, 0xffffefad,
    0x6121, 0xffffd1e6, 0x66da, 0xffffcc0a, 0x63ea, 0xfffffc17, 0xffffc2d6, 0xffffa0f2,
    0xffffc2d3, 0xffffa772, 0x4b13, 0xffffcfba, 0xffffee11, 0x6561, 0x38cc, 0xffffabbe,
    0xffffe3f2, 0x4c6b, 0xfffff7ef, 0x6373, 0xffffeed8, 0x34cf, 0x59d9, 0x2699,
    0xffffd7fa, 0xfffffa92, 0xffffac49, 0x62d7, 0x6daa, 0x4ab3, 0xffffaf00, 0xffffce18,
    0xffff7e6c, 0x118, 0x72fe, 0xffff874a, 0x645, 0x2d6f, 0xffffa91f, 0x7443,
    0xffff82ca, 0x553f, 0xffffb391, 0xffff83c6, 0x581a, 0x4124, 0x4d68, 0x5981,
    0x40c2, 0xffff925c, 0x10e3, 0xffff957f, 0x7b13, 0xffff9008, 0x3563, 0xffffb7d3,
    0xffff8c80, 0x8508, 0x8a7e, 0xffffd76b, 0x5321, 0x39bb, 0xffffe271, 0xffffa6fa,
    0x758e, 0x3092, 0xffffd014, 0x2666, 0xffff745f, 0xffffb06f, 0xffff861c, 0xffffe4c9,
    0x306f, 0xffffc98f, 0xffff950b, 0x2139, 0x7698, 0xffff9796, 0x1df5, 0xfffff0f9,
    0x112c, 0x467a, 0x211b, 0x4469, 0x168f, 0x38b7, 0x2007, 0x2908,
    0x24, 0x280e, 0x5051, 0xffffb28f, 0x4c68, 0x836a, 0xffffea37, 0xffff9080,
    0xffff95e1, 0xffffe897, 0xffffcabd, 0xffff87dc, 0x88c2, 0x4507, 0xffff8a98, 0x405f,
    0x52c8, 0xffffc450, 0x204a, 0xffff8690, 0xffffec68, 0x28a5, 0xffffdb3c, 0xffffa42c,
    0x13e2, 0xffffb958, 0x595d, 0x4eae, 0xffff8001, 0xffff7f70, 0x4a8c, 0x748b,
    0xffffb9ea, 0xffff87ba, 0x4a61, 0xa72, 0xfffffc5b, 0xffff9428, 0xfffff71c, 0xffffa0d7,
    0xffffd5c7, 0xffffcd3f, 0xffff77eb, 0xfffff986, 0xffff92c6, 0x57a0, 0xffffe759, 0x815c,
    0xffff8cb3, 0xffffcdc4, 0x6a3f, 0x1a8, 0xffff7840, 0x60bd, 0xffffb606, 0xffff8946,
    0xffffebc2, 0xffffaae5, 0xffffce9d, 0xffffca7c, 0xffff761c, 0x3ffb, 0xffffc9e6, 0xffff94b5,
    0xffff7888, 0x63fc, 0xffff8da1, 0xffffd969, 0x21b0, 0x47be, 0x39e9, 0xffffee2b,
    0xffffbc45, 0x82a2, 0x243d, 0x75bc, 0xffff88cf, 0x8c54, 0xffffb154, 0xffffa214,
    0xffffb8bb, 0x8a04, 0xffff87de, 0x8cd6, 0xffffd8d3, 0xffffc81e, 0xffffdf1c, 0xffffb674,
    0x5782, 0xffffa361, 0xffffcd7b, 0xffffe9d7, 0xffff9bbf, 0xffffcae9, 0xffffeab3, 0xffffd75e,
    0xfffffab2, 0xd68, 0x8288, 0x5177, 0x5f43, 0xffffeebd, 0xffffc78f, 0xffff72d2,
    0x812, 0x752a, 0xffffc8ce, 0xfffff6d2, 0xdb9, 0x6b64, 0x3527, 0xfffff063,
    0x79be, 0x6579, 0xffffe19c, 0x226f, 0xffff9529, 0x1eb8, 0x8747, 0x41e2,
    0xffffde27, 0x46e7, 0x86bf, 0xffffa714, 0xffff93c7, 0xffffe02a, 0xffffc1e6, 0x36de,
    0xffffc76e, 0x43ed, 0x65a, 0x6cf4, 0x57f3, 0x4916, 0xffffecae, 0x7ca7,
    0x5c09, 0x48f0, 0xffffb23e, 0xffffaecc, 0xffffa88b, 0xffff7d10, 0x87c4, 0x669f,
    0x56c2, 0x43d, 0x8c6b, 0xfffff478, 0x87cb, 0xffffd0f4, 0xffffa7a1, 0x25e7,
    0x5a3d, 0x1df, 0xfffff384, 0x3438, 0x1ce8, 0x800, 0xffff8048, 0xffffad8a,
    0xffff9d72, 0xffff73f5, 0x818d, 0x420a, 0xffffae9d, 0xffffc332, 0xffffbe39, 0xffffce52,
    0x5b09, 0xffff8635, 0x1157, 0xffffb3d7, 0x33d1, 0xffff8149, 0xffffbe1d, 0xffffff1d,
    0xe7c, 0xa66, 0xffff8167, 0x191d, 0x1beb, 0xffff82ec, 0xffffa8a3, 0xffff78af,
    0x52ca, 0xffff7862, 0x7c41, 0x8b97, 0xffffbe29, 0xffffcaac, 0x7279, 0x893c,
    0x3b70, 0x7947, 0xffffed3c, 0xffffe6e8, 0x3dcb, 0x1d01, 0x88cf, 0xffffb5ae,
    0xffffa7ef, 0xffffece8, 0xfffffb0a, 0x1c20, 0x3691, 0x4f, 0x40aa, 0xffffebe0,
    0x5fa0, 0x38, 0x44dd, 0xffff8ab5, 0x2c13, 0xffffd8b8, 0xffff9f3d, 0x8815,
    0x8683, 0x6a60, 0x1a12, 0xffffa788, 0x5215, 0xffffcc46, 0xffff75bd, 0xffff8c9d,
    0x2871, 0xffff889e, 0xffff9608, 0x8d91, 0x8c85, 0xffffc2ee, 0x458b, 0x48e7,
    0x1d47, 0xffffe974, 0xffffa020, 0xffffe1fd, 0x6f80, 0x8264, 0x885, 0x4317,
    0xffffd135, 0x89c9, 0xffffb412, 0xffff7b42, 0x5b21, 0x5a98, 0xffffbc39, 0x16c0,
    0xffff7c6e, 0x286b, 0x1996, 0xffffd5e6, 0x5fb3, 0xffff950f, 0xe62, 0x215d,
    0x2328, 0xffff7dc1, 0xffffacb9, 0x1483, 0x3da9, 0x74e7, 0x410e, 0x8253,
    0x4216, 0x1ff1, 0x4d3a, 0x3771, 0x817a, 0xffff73f2, 0x624e, 0xffffff16,
    0x3dc5, 0x1384, 0x377c, 0xf2, 0x4bf2, 0xffff74f7, 0x3060, 0x728d,
    0x2aee, 0x7273, 0xffff8fbf, 0x1106, 0xffff89df, 0xffffc920, 0x3582, 0x25fd,
    0xffffce73, 0xffffe0f1, 0x6219, 0xffffadc3, 0xfe9, 0xffff837f, 0xffff9048, 0x781f,
    0xffffb93b, 0x189f, 0xfffffb71, 0x16d2, 0xf5e, 0xffffb0bf, 0x62f8, 0x51e2,
    0x2c58, 0x5d59, 0xffffc837, 0x161a, 0xffffa164, 0x39c, 0x10a3, 0xffff79f8,
    0xfffffd31, 0xffffb4e3, 0xffffc92d, 0x6f16, 0xffffab27, 0xfffff0ba, 0x1be7, 0xffffb0a9,
    0xffffe906, 0x3a70, 0xffffaf42, 0x8b55, 0xffffa625, 0xffffca7e, 0xffff7fdb, 0x4078,
    0x5d41, 0x7798, 0xfffff767, 0xffff964e, 0xffffd7df, 0xffffa537, 0x3b4a, 0x35d0,
    0x5ba2, 0xffffd3b1, 0xffffb2e2, 0xffffd0e7, 0x3602, 0x72f1, 0xffff8dcc, 0xffff7ade,
    0xffffb1ee, 0xffffafa9, 0xffffdad2, 0xffffea6a, 0x6667, 0xffff941e, 0xfffff259, 0xfffff365,
    0x15be, 0x1280, 0xfffffcab, 0x8bb6, 0xffffbf10, 0xffffb64d, 0x408f, 0xfffff18a,
    0xffff9956, 0xffffa946, 0x71e3, 0xffffe7e8, 0xffff7ddc, 0xfffff570, 0x1c0f, 0xffffc10d,
    0x6e81, 0x367d, 0x2846, 0x635e, 0xffff74fc, 0x4b36, 0xfffff47b, 0x8b6b,
    0x7d7, 0xffffeb07, 0xfffff577, 0xffffb507, 0x42a5, 0x733c, 0xffffe9a2, 0xffffe885,
    0xfffff77a, 0xd37, 0x5f47, 0xffffc515, 0xfffffd88, 0xffffeb05, 0xffffcb7f, 0xffffa183,
    0x63df, 0x896f, 0x7fd9, 0x5f5, 0xffffc008, 0x29ac, 0x360e, 0x259d,
    0x7d1, 0xfffff226, 0x3d55, 0xffffabfd, 0x54b4, 0x3085, 0x59a1, 0x8a1e,
    0xffff85f4, 0xffffef3e, 0x49e5, 0xffffe51a, 0xfffffe96, 0xffffdea7, 0x328a, 0xffffa638,
    0x4ced, 0xffffb2d8, 0xffffec06, 0x854b, 0x46a, 0xfffff0e7, 0x8922, 0x8266,
    0x280a, 0x68a6, 0x5210, 0x6a2, 0x4142, 0xffffca2d, 0xffff9e3b, 0x5dd5,
    0xffffe648, 0xffffaac4, 0x22d9, 0xfffff89e, 0x4059, 0xffffab1f, 0xffffd230, 0xffff8d23,
    0x6cf, 0x6067, 0xffffed0e, 0xffff74f8, 0x58ee, 0xffff964e, 0xffffe204, 0x5e81,
    0xffff9d1e, 0xffffa77a, 0xffffef8a, 0xffff8f01, 0xffff7694, 0x6c0b, 0x7293, 0x72b2,
    0xffffa48b, 0xffffeb04, 0x1953, 0x1d, 0xffff888f, 0xffff7b0a, 0xffffa134, 0x7fe3,
    0xffffacc2, 0x471, 0x999, 0x4397, 0xfffff6a0, 0x7af2, 0xffffaac9, 0xffffe255,
    0x1170, 0xffffaaec, 0x2b92, 0xffff96a5, 0xffffd8b4, 0x3e4a, 0x44b0, 0xffffefdf,
    0xffffc299, 0xffff7360, 0xffff7ec4, 0x4be8, 0x2e91, 0xffffc8dc, 0xffffb89a, 0xffff8894,
    0xffff9818, 0xffffb4a1, 0x669, 0x892, 0x8c52, 0xffffe05d, 0x6fc3, 0xffff861c,
    0x19f4, 0x876d, 0x2260, 0xffff873f, 0x363e, 0xfffff093, 0x1434, 0x840b,
    0x648b, 0xffff8ebb, 0x1a62, 0x604e, 0x5874, 0x4304, 0x6f7e, 0xffff8c56,
    0x603b, 0xffffbaa1, 0xffffe654, 0xffff7ea9, 0xffff9791, 0xffffc749, 0xffffa7d9, 0x11e6,
    0xffffa58d, 0x6995, 0x4a1c, 0x362e, 0xffff9be4, 0x8266, 0x304, 0xffffbe5c,
    0xffffb4e6, 0xffffa022, 0xffff821f, 0x1170, 0xffff8639, 0xffffcbf0, 0x2364, 0x6c9a,
    0xffff8726, 0xffff9417, 0xffffea48, 0xffffb072, 0x5f33, 0x4896, 0xffff7762, 0x65e9,
    0xfffffd0a, 0x57f, 0x3b2c, 0xffff751d, 0xffff8c1f, 0xffffef92, 0x7117, 0xffffed28,
    0x8b9f, 0x764b, 0xfffff95d, 0xffff8346, 0xffffada7, 0xffffcd90, 0xffffa794, 0x22f6,
    0x5821, 0x2a57, 0xffff7575, 0xffffc0a9, 0xffffc11c, 0xffff954c, 0x921, 0xffffb22e,
    0x6fa4, 0x5f18, 0xffffcc0d, 0xffffd4eb, 0xffff8fd0, 0xffffd740, 0xffffc4d2, 0x5b17,
    0x7391, 0xffffdc3a, 0xffff923d, 0x4572, 0xffffaf19, 0xffffc9fb, 0xd70, 0x4c5d,
    0xffffb57d, 0x7eda, 0x60ce, 0x3db6, 0x6478, 0xffff81ca, 0xffff8e3f, 0xffffae43,
    0x8aad, 0xffff76a0, 0x2d2d, 0xffffc6ed, 0x89c4, 0xfffff0bd, 0xfffff634, 0xffff86cc,
    0x8934, 0x5c28, 0xfffff07a, 0xffffc810, 0xffffc4d5, 0xffff931a, 0x6cc1, 0xffff820d,
    0x4ad9, 0xffffe2ec, 0x5400, 0xffffce27, 0xffffa35b, 0xfffffa9a, 0xffffc984, 0x29db,
    0x198b, 0xb84, 0xffff7987, 0x43fc, 0x475f, 0x432d, 0xffffe7cc, 0xffff9245,
    0xffffef67, 0x60c2, 0xffffa260, 0x3a6a, 0x6739, 0x6685, 0x1b66, 0xa0,
    0xffff76b4, 0x2f5f, 0x8857, 0xffffa00d, 0xffff8549, 0x203e, 0x841f, 0x28a6,
    0x4193, 0xffffa1d6, 0x798f, 0x5d16, 0x279b, 0x9b1, 0xffffd61c, 0xffff9bce,
    0x3ecd, 0xffffc062, 0xffffac02, 0xffffac45, 0x150e, 0x7e22, 0xffffc92e, 0xffffe529,
    0x60da, 0x3950, 0x3d86, 0x1575, 0x182f, 0x7ee7, 0xffff8da9, 0x1a01,
    0x2e85, 0x7cd5, 0xffff8cc0, 0xffff730f, 0xffff8fe1, 0xffffeb15, 0x3bb7, 0x2d60,
    0xfffffaa0, 0xffffbd0f, 0x33b2, 0xffffd0be, 0xffffc2df, 0xffff7f81, 0x6400, 0xffffd43b,
    0xffffc823, 0x418c, 0xd2f, 0xffffa895, 0x8c3c, 0xffffbaeb, 0x7f05, 0xffffa145,
    0x660d, 0xffffa464, 0xfffff7ba, 0x8a12, 0x5b5a, 0xffffc222, 0xffff999e, 0xffffe91a,
    0x1bd9, 0xffffb0f5, 0x8202, 0x7319, 0xffff877a, 0xffff97b7, 0xffffc451, 0xffffa669,
    0x34b1, 0xffffbcda, 0xffffb333, 0x76fa, 0x4fb3, 0x1bfa, 0x8822, 0xffffcd78,
    0xffff7440, 0xfffffb6c, 0xffffb200, 0x4f19, 0x33ed, 0xffffb977, 0x26b, 0xfffff89d,
    0xffffa1de, 0x61ec, 0x1d9c, 0xffff76c0, 0xffffb7c1, 0xfffff027, 0x700c, 0xffff841a,
    0xfffffd62, 0xffff8baf, 0x4562, 0x7eab, 0x2ac8, 0xffffca3d, 0x6a8c, 0xffffc5c5,
    0xffff76cf, 0x454e, 0x44b2, 0x2e49, 0x551c, 0x4b86, 0x734c, 0xffff9db0,
    0x1d8, 0xffff9219, 0xffffe716, 0xffff7e4f, 0xffffcad7, 0x208, 0xffffa001, 0xffffe587,
    0xffffeed7, 0xffffc27b, 0xffffc41d, 0x4531, 0x7ee, 0xffff755f, 0xa10, 0x1d02,
    0xffff75fe, 0xffff9543, 0x237f, 0xffffabf2, 0xd2, 0xae9, 0x2785, 0xffff85c8,
    0xffff9b84, 0xffffc2d6, 0xffffe149, 0x28ae, 0xffff75f9, 0xffff9667, 0x5647, 0x76e9,
    0xfffff7f3, 0xffffa9ae, 0xffffc163, 0xffff8412, 0xfaf, 0x1cde, 0xffff888f, 0xffff7e2f,
    0xffffd400, 0xffff8602, 0x37de, 0xffffb80c, 0xffffd2e9, 0x11ba, 0xffffb448, 0xffff9253,
    0x603a, 0x71c9, 0x4d23, 0x48c7, 0xffffc84d, 0xffffe1fb, 0x47db, 0x1877,
    0x45af, 0xfffff561, 0xffffd599, 0x7c57, 0xffff8cd4, 0xffffbc8b, 0x61db, 0x37a0,
    0x1544, 0xffffca6a, 0x8d85, 0x768f, 0xffff897a, 0xffff923c, 0xffffecde, 0xfffff499,
    0x100c, 0x5097, 0x8dd1, 0x1d2c, 0xffffd766, 0x31a3, 0xffff9f7e, 0x31e8,
    0x2744, 0x8dad, 0xffffd73e, 0x33ab, 0x3fed, 0xfffff38c, 0xffffe07f, 0x7827,
    0xfffffc55, 0x6531, 0x526b, 0x2399, 0x3c8c, 0x4633, 0xffffaafa, 0x11da,
    0xfffffca9, 0xffff7c90, 0x4499, 0x3445, 0x12c4, 0x2210, 0xffffe1e1, 0x431b,
    0x45da, 0xffff72cf, 0xffffdae7, 0x6ee7, 0xffffb843, 0x7930, 0xfffffc7c, 0xffffda3e,
    0xffff89d1, 0x8d06, 0xe73, 0xffff82c9, 0xffffeeb8, 0xffffc7dc, 0x3e13, 0xffff9f2f,
    0xffff7e2a, 0xffff7eaf, 0x6cb0, 0x5077, 0xc26, 0xffff9fcb, 0xffff7e45, 0x1bc3,
    0x6cd7, 0x800e, 0x333f, 0xffffef38, 0x3294, 0x38c5, 0xffff9860, 0x7fe2,
    0x1846, 0xffffc870, 0x8798, 0xffffa794, 0x3433, 0x70a5, 0xffffe031, 0xffffbd5a,
    0x626c, 0xfffff816, 0x7b1, 0x83fc, 0xffff9362, 0x306, 0x7587, 0xffffdb69,
    0xffff89e4, 0x1da2, 0x5532, 0xfffffd49, 0xffffba57, 0xffff8941, 0xc84, 0x6b89,
    0xffffecd4, 0x2578, 0x8a3e, 0xffffbd94, 0xffff8bc6, 0x7a73, 0x5cfc, 0xffffa543,
    0x4605, 0xffffbde5, 0x8cfe, 0x150b, 0xffffd23e, 0xffffa042, 0xffff7b69, 0xfffff168,
    0x1c44, 0xffff72f5, 0xfffff3c2, 0xfffff9ed, 0xffffeca1, 0x2d48, 0xffff9bce, 0x272b,
    0xffffc260, 0xffff929d, 0x3cb9, 0x5c11, 0x5d4, 0xffff8ad7, 0x6aa9, 0xfffffb80,
    0x572b, 0x2cbd, 0x5e8a, 0xffffb586, 0xfffff8e7, 0x6f5b, 0x28ce, 0x11a,
    0x71f5, 0xfffff744, 0x1be2, 0xffff95cd, 0x6cef, 0xffffc7f6, 0x1ac3, 0x8c96,
    0xffff760f, 0xffffa1ba, 0x370, 0x3277, 0xffff817a, 0xffffcee6, 0x195e, 0xffff7ccb,
    0xffffca7b, 0xffff9d90, 0x540e, 0x6725, 0xffff75a3, 0x48a5, 0xffffada6, 0xfffffdad,
    0x32e4, 0x1e1e, 0xffffe0eb, 0xffffed3c, 0xfd, 0xffff9fbf, 0x4878, 0x8dbc,
    0x3ef3, 0xfffffcd0, 0x80e5, 0x77b5, 0x8b4b, 0x7003, 0xffffb759, 0x8938,
    0x4a57, 0xca9, 0x6783, 0x27ee, 0x2c7a, 0xffff8bf7, 0xffffe754, 0x2a23,
    0x60ea, 0xffffc6bc, 0xffffb024, 0x34b2, 0xffffe44f, 0x2f16, 0x3df3, 0x883c,
    0x3eb1, 0xffff81dd, 0x5e00, 0x7ae1, 0x62bc, 0xffffcb8d, 0xffffd0eb, 0x457f,
    0x6bb3, 0x72a2, 0xffffb521, 0xffff7d69, 0xffffd032, 0x4d2, 0xffff9dcb, 0xfffffd7d,
    0x44d, 0x3c01, 0x34ed, 0xfffff07f, 0x74a6, 0x894, 0x524d, 0xdb3,
    0xcb3, 0xffff9661, 0xffff9d9a, 0xffffdae6, 0xffffd8df, 0xffffe241, 0x14a9, 0xffff79ad,
    0x1d71, 0x17e9, 0xffffcee6, 0x58cc, 0xffffa52b, 0x7b08, 0xec7, 0x5a66,
    0xffff7f3c, 0xffffc522, 0x210d, 0x109c, 0x162d, 0x4654, 0xfffffee4, 0x1b68,
    0x7e7b, 0xffffb804, 0xffff9c77, 0xffffa259, 0xfffffcdc, 0xffffb126, 0x6f3e, 0x597e,
    0xffff8c8b, 0xffffb09a, 0x4d39, 0x8bc3, 0x1208, 0x63f, 0x7e6a, 0x3bb1,
    0x8dd9, 0x4cac, 0xffff803c, 0xffff9d29, 0xffffa2d6, 0x1a9a, 0x16fe, 0xffffc6c9,
    0x6ff1, 0xffffb441, 0xffffbdc5, 0xfcd, 0xffffe445, 0xffffa0f3, 0xffffef93, 0xffffdd4e,
    0x3fe8, 0x40a2, 0xffffeac0, 0x6f7d, 0xffff83d1, 0x459e, 0x6eee, 0x7da,
    0xffff9f26, 0xffff9da6, 0xffffb81c, 0x25c8, 0x32a6, 0x2351, 0xffff7450, 0xffff90f0,
    0x16ee, 0xffffa868, 0xffffa2cb, 0xffff79fc, 0xfffffe99, 0x6a31, 0x1a59, 0xffffbca9,
    0xffff8d29, 0xffffc840, 0xffffd7e8, 0xffff9128, 0xfffff92c, 0xffffd49d, 0xffffa0a4, 0x7533,
    0x748, 0x4245, 0x34bc, 0x366c, 0xffffc838, 0x3265, 0x8226, 0x4aca,
    0xffffe761, 0x19e, 0x46bb, 0xffffdafa, 0xffffdd98, 0xffffc1b8, 0x7aa8, 0xffffc744,
    0xffff7766, 0xffffeb0c, 0x675b, 0x573, 0x5b52, 0xffffd638, 0x49a1, 0x5235,
    0xffffcd48, 0xffff8960, 0xffff8468, 0xffffc6b1, 0xfffff7c1, 0x6995, 0x5eb4, 0xffffc196,
    0xffff7779, 0x6104, 0xffff8f5b, 0x2928, 0x6cf0, 0x1b93, 0xffffbdd9, 0x1ca5,
    0x81b, 0x64c3, 0xfffff230, 0xffffc185, 0xffffd191, 0xffff858e, 0x6eb8, 0xffffd904,
    0x89ca, 0xffff8102, 0xffffc709, 0x39e2, 0x5bde, 0x1e9e, 0xffffb9c8, 0x81c2,
    0xffffb753, 0xffff9bba, 0xfe5, 0xffffaabf, 0xffff82e0, 0xffffcc44, 0x22e0, 0x1053,
    0x6b07, 0x2522, 0x6316, 0x5ddf, 0xfffff8fe, 0xffff896b, 0x8a7d, 0xffff9398,
    0xffffa42f, 0x4f57, 0x71a, 0xffffef95, 0xffffb170, 0x12e9, 0xffff8147, 0xffffdc5c,
    0xffff9d76, 0x2a39, 0x2a4a, 0x2d76, 0xffffa31c, 0xffffafcf, 0xffffb76e, 0x617c,
    0xa00, 0xffff878f, 0xffff737a, 0x6f54, 0x7516, 0xffffbc9a, 0x39c8, 0x5bbe,
    0x4d20, 0x32b6, 0xffff8d2f, 0xffffcee7, 0x46ef, 0x3bdb, 0xffffc557, 0xffffe1a6,
    0xffff7a54, 0x6572, 0xffff9a6d, 0x7b59, 0x3be8, 0xffffd635, 0x1acd, 0xffffe77a,
    0xffffa8c9, 0x531c, 0xffff8a3a, 0xfffff65d, 0xb96, 0x49b8, 0x735b, 0x791,
    0x682b, 0xfffff0f6, 0x179e, 0xfffff2ef, 0x3992, 0xffffc2d8, 0xffffb85c, 0xffff9e2d,
    0xffffdc7a, 0x1202, 0xffff761e, 0xffffae43, 0xffffddc9, 0xffff8377, 0xffffd6dc, 0x124,
    0x493d, 0x2f55, 0xfffff8c8, 0x5f25, 0xfffff800, 0xffff738a, 0x3465, 0x1089,
    0x4ea3, 0xffff83ec, 0x4f50, 0xffffaac4, 0x1c54, 0x58c5, 0xffffe6ab, 0xffff8a2e,
    0x74b2, 0x6032, 0xfffff56b, 0x836c, 0xffff8f09, 0x8316, 0xffffeb3e, 0x257c,
    0xffffd7c8, 0x671f, 0x4eab, 0x1220, 0xffff7c40, 0x3c05, 0xffffd400, 0x841,
    0xffff7c1a, 0x5119, 0x371c, 0xffffb126, 0xffffa46d, 0xffff8f00, 0xfffffed8, 0x6db7,
    0x1608, 0xffff7c99, 0x72a6, 0x7cad, 0xffff7831, 0x810d, 0x79d5, 0x1b55,
    0xffffd273, 0x5d84, 0x5983, 0xffffff4a, 0x5005, 0x69bf, 0xffffe75f, 0xffffd029,
    0xffffe1e8, 0xffff9e76, 0xff2, 0xfffff4d4, 0xffffe108, 0xffffb618, 0xffffed8b, 0xd27,
    0x94d, 0x52ff, 0x8634, 0xffffa360, 0xffffffe3, 0xffffb0d8, 0xffffaaee, 0xfffff959,
    0xffffbdaf, 0xffffc563, 0x2506, 0x4a98, 0xfffff9bb, 0x4ad2, 0x25f4, 0xffff9987,
    0x5bf9, 0x8d03, 0x58d7, 0xffff988b, 0xffffe7b6, 0x1aeb, 0xffffdd88, 0xffffd037,
    0xffff9db8, 0xffff77f7, 0x693, 0x8863, 0xffff9329, 0xffffb19f, 0x5447, 0x2606,
    0x77dd, 0xffffbd47, 0xfffffb00, 0x4c00, 0xffff9169, 0x7d2a, 0x8548, 0xffffe574,
    0x44b, 0xffffe68c, 0xffff9738, 0x4689, 0x27f6, 0x5a2c, 0x37a7, 0x529d,
    0xffff7c73, 0x76f2, 0x242f, 0x8134, 0x30a8, 0x3ab2, 0xfffffe83, 0x3bd5,
    0xffffc9ed, 0xffff7be3, 0x6356, 0xffffab4b, 0x6d2d, 0xffffb6dc, 0x1d24, 0x6908,
    0x6aa6, 0x4fe3, 0xffffe221, 0xffff8985, 0x3389, 0x6062, 0x8700, 0x4834,
    0x8cba, 0x842c, 0x15dd, 0x86ac, 0xffffa5c2, 0x375c, 0xffffc3e1, 0x2517,
    0x2a44, 0xffffa391, 0xffffec55, 0xffff7bec, 0xffffb1e1, 0x5156, 0x7b17, 0xd57,
    0x962, 0x4e52, 0x3b2e, 0xffffab67, 0xffffda44, 0x69e8, 0xffff78ec, 0xffffd084,
    0xffff8488, 0x773a, 0x6c60, 0xffffa9c9, 0x6d4a, 0xfffffe96, 0xffffe0e0, 0x1bef,
    0xffffde02, 0xaae, 0xffff9a10, 0x557, 0x4da9, 0x867c, 0x1741, 0x42f8,
    0xffffd09b, 0xffffd2d1, 0xffffe212, 0xfffff266, 0x45ed, 0xffffe717, 0x6837, 0x76c1,
    0xfffffef7, 0x5baf, 0xffffbee3, 0xffff830d, 0xffffb4fa, 0x372b, 0xffffb440, 0xffff8e7e,
    0xffffa00d, 0xffffbb90, 0xffff92d7, 0xffffa723, 0xffffe18b, 0xfffffbe0, 0xffffdf88, 0xffff76d1,
    0xffffd2af, 0x3a01, 0x8c46, 0xfffff48e, 0xffff8ada, 0xffffb3f4, 0x46ba, 0xffffa696,
    0x4a04, 0x8cf1, 0x362f, 0xffffc320, 0x73d2, 0xffffa00f, 0xfffff6ad, 0x7269,
    0x695e, 0x4812, 0x3b16, 0x6442, 0xffffa02b, 0xffffc2c0, 0xffffe410, 0xffffb923,
    0x6012, 0xffffdcd3, 0xffffbdfe, 0xffff97be, 0x6ad6, 0xffffe081, 0xffff97e9, 0xffff8adf,
    0xd9e, 0xffff7e8f, 0xffffc9c6, 0x6a7e, 0x53b9, 0xffff7fb5, 0x8314, 0xffff81f5,
    0x1d86, 0x3e5d, 0xfffffd9d, 0x201e, 0xffffde6d, 0x2055, 0x7317, 0x167c,
    0xffffcfa0, 0xffff9bbc, 0xffffa8e0, 0x2d83, 0x5a8d, 0xffffb0bd, 0x3926, 0x669f,
    0x4b9e, 0x6345, 0x2c7, 0xffff91c9, 0xffff745a, 0x5091, 0x56a3, 0x6e45,
    0x31ac, 0xffff9847, 0xffffbb04, 0x617c, 0x1374, 0x8dd7, 0xffffe142, 0xffffeb42,
    0x9d4, 0xffff8b2d, 0x84fc, 0x3b6, 0x604a, 0xffffd453, 0xffffd691, 0xffff7927,
    0xc47, 0x169d, 0x70bb, 0x10d4, 0x6b25, 0xffff8965, 0xffffc874, 0xffff7571,
    0x2165, 0xffffbb50, 0xffff7623, 0xffffab6f, 0xfffff47a, 0xffffb87b, 0x14d1, 0xffffff82,
    0xffffe1b8, 0xf6b, 0xffff74f4, 0xffffefb6, 0xffff88c0, 0x2eec, 0xffffade2, 0xffffdcd2,
    0xffffb1cc, 0x334f, 0xffffc569, 0xffff8414, 0x8070, 0x7bfa, 0x8992, 0xffffcc6d,
    0xffffa65a, 0x251f, 0x8bbf, 0x2463, 0xffff74d2, 0xfffff0cf, 0xffffde9a, 0x4f4a,
    0xffff8446, 0xffffa4e2, 0x808a, 0xfffffadd, 0x723e, 0xffffd82d, 0x1f14, 0x8c71,
    0xffffdc75, 0x6c3c, 0x4435, 0x472f, 0xffff7252, 0x22e5, 0x19c0, 0x88aa,
    0xffffd423, 0xffff8758, 0x2758, 0xffffd33d, 0xffffe1bb, 0x83b3, 0x8535, 0xaa5,
    0x7864, 0x6b59, 0x2ab7, 0x7e5b, 0x6df6, 0x6f3e, 0xffff908a, 0xffffb6d4,
    0x4eca, 0xffffa83f, 0xffffff3f, 0xffff7a6a, 0xffff74aa, 0x37e9, 0xffff8a5e, 0xfffff391,
    0xffffc4c1, 0x36fb, 0x21e2, 0x623d, 0xffff7306, 0xfffff202, 0x39cb, 0xffffcd47,
    0x13b6, 0x630e, 0xffffa3e6, 0xffffeb86, 0x5eb8, 0xffff73c0, 0xfffffa42, 0x49fb,
    0xffffed95, 0x718f, 0xffff7e6a, 0x1914, 0xffffa5e9, 0x8cf1, 0x2ae3, 0xfffff9e8,
    0xffffec23, 0x697d, 0x5ab9, 0x77f0, 0xfffff222, 0x5ff0, 0xffffa34d, 0x82bc,
    0x5950, 0x13c1, 0x5a9b, 0x570c, 0x4992, 0x405c, 0x3ecd, 0xfffff886,
    0x1362, 0x1704, 0xffff87b3, 0xffffe31c, 0x7e6c, 0x27e7, 0x355a, 0xffff84c4,
    0xffffe078, 0xffffc000, 0xffffd37a, 0x2690, 0x130d, 0xffffd22b, 0xffffa6c1, 0x12dd,
    0x36db, 0x5507, 0xffff8c14, 0xffffb616, 0x71ab, 0xffffd884, 0xffff7ed4, 0x1871,
    0x212a, 0xffff8acf, 0x353, 0x3bca, 0x7cfc, 0xffff7a5d, 0x5990, 0x4bb,
    0xffff7606, 0x6328, 0x386, 0xffffd02b, 0xffffe3b6, 0xfffff0bb, 0x4b6f, 0x8dc,
    0xfffff3ea, 0x169c, 0x3ed8, 0xffffa125, 0x3c69, 0xfffffedb, 0x6c9b, 0x17de,
    0xffffb5f8, 0xef6, 0xfffffbc6, 0xffff82b9, 0xffff7a4e, 0x6193, 0x6994, 0xffffe6b5,
    0xffffdb01, 0x5c14, 0x68a8, 0x26a4, 0xffffb021, 0x7bcc, 0xffff9f05, 0x814,
    0x162c, 0xffffb3e7, 0x2c53, 0xffffc8e1, 0x6920, 0xffff7254, 0x6d49, 0xffffb4c2,
    0xffffcaca, 0xffffe1cd, 0xffffd576, 0xffffbad8, 0xffffc4db, 0xffff7f6b, 0x758b, 0x1f19,
    0x4407, 0x3b61, 0xffffa2ea, 0xfffff403, 0x26b, 0x6789, 0x5ca7, 0x3b3,
    0x458b, 0xffffd823, 0xffff83b7, 0x2dc6, 0xffffbd8d, 0xffff7964, 0x77a3, 0x18bd,
    0x7ada, 0xffffc92e, 0x32e2, 0xffffe36a, 0xffff79db, 0x6ca2, 0xffffafdb, 0xffffba78,
    0x23cb, 0xffffc5ad, 0xffffe3f4, 0x89d5, 0x86ee, 0x13ca, 0xfffff25b, 0x3ebb,
    0x680d, 0x628a, 0xffffce21, 0x44c, 0xffff7532, 0xffff72a6, 0xffff88d5, 0x8599,
    0xffffe7cf, 0xffffbeed, 0xffffbcf5, 0x675c, 0x481d, 0x6ac3, 0xffffc0ae, 0x4ce4,
    0x46ef, 0x2b3f, 0x47fd, 0x35f4, 0xc48, 0x3038, 0x7b9b, 0x302d,
    0xffff85f4, 0x6652, 0xffff7f44, 0xffffec9b, 0xffffedd2, 0x2863, 0x2faa, 0x8cf1,
    0xffffc4e8, 0xcb3, 0xffff925c, 0xffffc9c0, 0xffffad2f, 0x5eb1, 0x5697, 0x66bd,
    0xffff8080, 0xffff98b1, 0x2955, 0xffffcdbd, 0xffffd6d8, 0xffff84a6, 0xffffe29c, 0xffff9edd,
    0x391f, 0x625c, 0xffff8094, 0xffffbad3, 0xffff8b97, 0x7d06, 0xffffadce, 0x1036,
    0xffffcbd0, 0x3027, 0xfffff405, 0x3104, 0xffffd411, 0x614d, 0x426b, 0x410,
    0x3524, 0xffffddf3, 0x3c3b, 0x7663, 0x4d40, 0x7c3e, 0xffffa330, 0xffffbd4a,
    0xffffce53, 0x989, 0xffffddc9, 0xffff92ed, 0x4449, 0xffffa2d2, 0xfffff261, 0x5c84,
    0xfffff447, 0xfffff6c6, 0x4520, 0xffffa40d, 0xffffd253, 0xffffbf75, 0xffffaeea, 0x8c96,
    0xffff7c66, 0xffffc745, 0x572b, 0x5167, 0xffffdc8a, 0x46cc, 0x5b66, 0xffffd61c,
    0x3fc6, 0x7a63, 0xffffc4d8, 0xffffe8b4, 0xffffdc6a, 0x6f63, 0xffffd716, 0xffffbb46,
    0x7426, 0xffff7dde, 0x26f1, 0xffffcd18, 0x1776, 0x4d89, 0x20c5, 0x6457,
    0x371c, 0xffff8c94, 0xffff72e4, 0x7cc, 0x835b, 0xffffb776, 0xffff93e1, 0xffff83cd,
    0x7241, 0xffffcfc4, 0xffffbda6, 0x63f0, 0xffffaa19, 0x7cf5, 0xffff8f8d, 0x1942,
    0xffff87ae, 0x4e6d, 0xffff78d5, 0x6e8c, 0x3539, 0xffffc063, 0x73c, 0x76dc,
    0xfffff8ff, 0xffffb5a1, 0x19bf, 0xffff7694, 0xf15, 0xfffff136, 0xffff82b9, 0xffffcc83,
    0xffff88a4, 0xffffc7e0, 0xffff7256, 0xffffe068, 0x25b4, 0xffffed48, 0xffff8d7d, 0x5f8c,
    0x1892, 0xffffd1e5, 0xffff7417, 0x7ecc, 0xfffffb74, 0x8c0c, 0x4758, 0xffffc7d7,
    0xffffe764, 0xfffffe29, 0xffff88fa, 0xffffe66d, 0xffffdeb4, 0x2f2d, 0x646b, 0xffffce8c,
    0x3769, 0x3912, 0xffffe6fb, 0xffffc166, 0xffffce02, 0x4dc7, 0x80b5, 0xffffc70d,
    0xffffc36a, 0x30ea, 0x7441, 0x5fe4, 0xffff7812, 0xffffe92e, 0xffffcc86, 0xffffe27b,
    0x49e2, 0x71c0, 0xffffab47, 0xffff9c51, 0x7377, 0xfffffc50, 0x7be0, 0x13e0,
    0xffffe5f2, 0x2db1, 0x2610, 0xffff8258, 0xffff978f, 0x282b, 0x395, 0x1031,
    0xffffb66c, 0xffff749b, 0xffffbf6f, 0xffffa7e1, 0x12f1, 0xffffcfa7, 0xfffff7fd, 0x6a21,
    0x8a4d, 0x4ff5, 0x71be, 0x8096, 0x5502, 0x4f40, 0x81c5, 0x5a75,
    0xffff8d39, 0x1bc0, 0xffff7827, 0xa59, 0xffff9929, 0x8db3, 0x5df1, 0xfffff7b2,
    0x420a, 0x6544, 0x6509, 0x7451, 0x1e7f, 0x4f76, 0x315a, 0x3620,
    0x5091, 0x4403, 0xffffd3e4, 0x5c0c, 0x80c2, 0x36c4, 0x5107, 0xffff943d,
    0x6452, 0xffffad40, 0xffff9b98, 0x58ab, 0x27b3, 0xffff8be9, 0xffffa656, 0xffffa5f8,
    0xffffbd22, 0xffff73fd, 0x2758, 0xffffa764, 0x62ed, 0xffff90c5, 0x1e51, 0xffff897b,
    0xffff82b3, 0x2d25, 0x76ad, 0xffff7f02, 0xfffffa89, 0x2d4f, 0x2ab, 0x5685,
    0x8ce1, 0xfffff7de, 0x5522, 0xffffbc64, 0xffff9e79, 0xffffef8b, 0xffff84f0, 0xffff933c,
    0x102e, 0x8bc, 0x5a44, 0xfffffe4f, 0xffffaed9, 0x7aee, 0xffffa2ae, 0x12e0,
    0x7c7b, 0x3a66, 0xffffb1f5, 0xffffa575, 0x3bf3, 0xffffe14f, 0xffffedca, 0xfffffb3d,
    0xffff8279, 0x296b, 0x8bc7, 0xc1b, 0xffffea63, 0x65cd, 0xffffa851, 0x878f,
    0xe37, 0x501a, 0x581c, 0x16c3, 0x6279, 0xffff9e12, 0xfffffc2c, 0x7d4c,
    0x4c95, 0xffffced3, 0xffff8b07, 0xffff87b0, 0xffffa928, 0x6ce2, 0xffff8bc1, 0xffff7fab,
    0x5249, 0xffffbf8f, 0x8074, 0x1ab9, 0xffffe2ed, 0xffffebbb, 0xfffffd25, 0x474f,
    0xffffe439, 0xffffe258, 0xffffb947, 0xfffffa1b, 0xffff90ea, 0x8134, 0x6eed, 0xffffc392,
    0xffff934a, 0xffffb921, 0xd9a, 0x6581, 0x37f2, 0xffffe672, 0xffffafd9, 0x30eb,
    0xffffa08e, 0xffffa39d, 0xffff9657, 0x26d0, 0xffffb97f, 0x5df, 0xffff9257, 0x3a34,
    0xfffffd43, 0xffffc367, 0x8bf0, 0x186, 0x1692, 0x5420, 0x7d2c, 0x83dd,
    0x4ad1, 0xfffffc05, 0x67a4, 0x7b06, 0xffffacd2, 0x7c2, 0x4f9a, 0x586a,
    0xffffdacd, 0xfffff2e4, 0xffffa666, 0xffffa2f2, 0xffffdd98, 0x50ec, 0xffffec94, 0xffffe01d,
    0xffffe6a5, 0x2b32, 0xffff9128, 0xffffba30, 0xffff82ba, 0xffffe9fc, 0xffffe738, 0x20fa,
    0x3c1b, 0xffffce2f, 0x533, 0x8bdf, 0x79be, 0xffff86e9, 0x82cf, 0xffffab3e,
    0x591d, 0xfffffeb2, 0xffff7424, 0x8932, 0xffffe0f9, 0xffff9d92, 0xffff7b20, 0x2495,
    0x879d, 0x85a3, 0x6f1f, 0x1cf2, 0x1220, 0x65c2, 0xffffc751, 0xffffa10f,
    0xffffa5df, 0xffffd1fd, 0xffffac41, 0xffff73d2, 0xffffc38e, 0xffffa17a, 0xffff9f58, 0x6600,
    0xffff95d8, 0x8400, 0x38dc, 0xffff9844, 0xffff9378, 0x5fdc, 0x3ed8, 0xb4b,
    0xffffb1fd, 0xffff72a1, 0x6313, 0x3acb, 0xffffd03c, 0xffffe6bb, 0x59f7, 0x5a17,
    0x20c2, 0xffffddc9, 0x60e0, 0xffffb1ff, 0x7867, 0xffffad34, 0x8cb0, 0xffff89ed,
    0xffff9cf1, 0x57ed, 0x186b, 0x85bb, 0x1ed9, 0xffffd073, 0x755, 0x39d,
    0xffffe507, 0x5144, 0x3bdd, 0xffff748f, 0x5a22, 0x2f8c, 0xffffe210, 0xffff8285,
    0x2ffa, 0x17c1, 0x11b5, 0xffffa5ff, 0x3950, 0x6b7f, 0xffffc962, 0xfffff345,
    0x80c6, 0xffffbb45, 0xffffac73, 0xffff941e, 0xffff9774, 0xffffe733, 0x35cb, 0xffffb0e4,
    0x8a90, 0x296d, 0xffffea99, 0xffffb292, 0x3778, 0xffffff27, 0x3422, 0x2bd4,
    0xffffb0ac, 0xffffda12, 0x3f00, 0x36ed, 0x38ec, 0xffff9a13, 0xffff9d40, 0x5ec5,
    0x5a1b, 0x5a7d, 0xffffccab, 0xfffffcd1, 0xffffa33b, 0xffff9848, 0x31d8, 0x2224,
    0x2eb0, 0xffffa658, 0xffff9e76, 0xffffd97a, 0x65a8, 0xffff8029, 0xf42, 0x2c21
};
