/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_object_inspector_h
#define _vdkb_object_inspector_h
#include <vdk/vdk.h>
#include <vdkb2/vdkb_object.h>

class VDKBEventBox;

class VDKBObjectInspector: public VDKForm
{
  protected:
  VDKEntry* name;
  VDKBObject* active; //  active widget
  VDKCombo *colortypecombo;
  VDKNotebook *nbook;
  VDKCustomList *sigtable,*evtable;
  VDKCombo *sigcombo;
  VDKCustomButton* add_remove_event;
  VDKBox *sigpageBox,*evpageBox;
  VDKTable* connectTable;
  VDKBox* MakeSignalsPage();
  VDKArray<VDKCustomButton*> connectButtons;
  VDKArray<int> slots;
  VDKArray<VDKEntry*> sigEntries;
  VDKMenu* popmenu,*treepopmenu;
  VDKMenuItem *delConnection,*dropwidget;
  VDKEntry* font;
  VDKCheckButton *enabled,*visible,*fill,*expand,*declarePublic;
  VDKSpinButton *padding;
  VDKCustomButton *repackButton,
    *fontButton,*nameButton,*justifyButton,*tipButton,*tagButton,
    *set_tag,*mul_connect;
  VDKCustomButton *colorButton,*restoreDefaultButton;
  VDKCombo *justification;
  VDKFrame* subclassFrame,*CommonPropertiesFrame;
  VDKEntry *tip,*tag;
  VDKBox* mainbox;
  VDKPaned* mainpane;
  VDKDockerBox* dockerbox;
  VDKTable* CommonPropertyTable;
  void LoadStaticTable();
  void SetSlotEntries();
  void DisableInspector();
  bool LoadRGB(StringList& colors);
  VDKBox* MakePropertiesPage();
  VDKBox* MakeWidgetsTreePage();
  VDKBox* MakeFormEventsPage();
  VDKObjectContainer* extrawidget;
  VDKString oldWidgetName;
  VDKHLButtonBar *treeToolbar; 
 public:
  bool ForceToClose;
  VDKCheckButton *preview;
  VDKCustomTree *WidgetsTree;
  VDKBObjectInspector(VDKForm* owner, VDKBObject* active,
		 char* title = "", 
		 int mode = v_box,
		 GtkWindowType display = GTK_WINDOW_TOPLEVEL);
  virtual ~VDKBObjectInspector();
  void Setup();
  void SetActive(VDKBObject* act, bool loadWidgetsTree = true);
  void RemoveExtraWidget();
  void AddExtraWidget(VDKObjectContainer* wid);
  void OnShow(VDKForm*);
  void FormNeedToBeChanged(bool flag = true);
  void LoadTree(VDKBGuiForm* owner);
  void SelectWidgetByTree(VDKBObject* object);
  bool OnChangeColor(VDKObject*);
  bool OnRestoreDefaultStyle(VDKObject* sender);
  bool SetWidgetName(VDKObject*);
  bool OnPageSwitch(VDKObject*);
  // can be closed only by project manager
  bool CanClose();
  bool OnSignalListButtonPress(VDKObject* sender, GdkEvent* event);
  bool OnWidgetsTreeButtonPress(VDKObject* sender, GdkEvent* event);
  bool DeleteConnection(VDKObject* sender);
  bool OnSelectTable(VDKObject*);
  bool OnSelectEventTable(VDKObject*);
  bool ConnectToFormEvent(VDKObject*);
  bool OnActivateSlotName(VDKObject* sender);
  bool OnConnectSignal(VDKObject* sender);
  bool OnSelectVisible(VDKObject*);
  bool OnSelectEnabled(VDKObject*);
  bool OnSelectFont(VDKObject*);
  bool RepackWidget(VDKObject*);
  bool SetWidgetTip(VDKObject*);
  bool ColorSelectionChanged(VDKObject*);
  bool OnSelectPreview(VDKObject*);
  bool OnSelectWidgetsTree(VDKObject*);
  bool DropWidget(VDKObject*);
  bool OnClickColumnWidgetsTree(VDKObject*);
  bool OnJumpToFormEventHandler(VDKObject*);
  bool OnMultipleConnect(VDKObject*);
  bool SetWidgetTag(VDKObject*);
  bool OnDeclarePublic(VDKObject*);
  static void OnTreeMove (GtkCTree *ctree,
			  GtkCTreeNode *child,
			  GtkCTreeNode *parent, 
			  GtkCTreeNode *sibling,
			  gpointer data);
  bool OnToolbarClicked(VDKObject* sender);
  void PasteOthers(VDKBObject* selected_object);
  bool OnDocked(VDKObject*);
  DECLARE_SIGNAL_LIST(VDKBObjectInspector);
  DECLARE_SIGNAL_MAP(VDKBObjectInspector);
  DECLARE_EVENT_LIST(VDKBObjectInspector);
};
#endif

