/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean _lock_used;
};

static gint ValaField_private_offset;
static gpointer vala_field_parent_class = NULL;
static ValaLockableIface * vala_field_vala_lockable_parent_iface = NULL;

static void vala_field_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_field_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_field_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node);
static void vala_field_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static gboolean vala_field_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_field_finalize (ValaCodeNode * obj);
static GType vala_field_get_type_once (void);

static inline gpointer
vala_field_get_instance_private (ValaField* self)
{
	return G_STRUCT_MEMBER_P (self, ValaField_private_offset);
}

ValaMemberBinding
vala_field_get_binding (ValaField* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_field_set_binding (ValaField* self,
                        ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_field_get_is_volatile (ValaField* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_volatile;
	return result;
}

void
vala_field_set_is_volatile (ValaField* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_volatile = value;
}

static gboolean
vala_field_real_get_lock_used (ValaLockable* base)
{
	gboolean result;
	ValaField* self;
	self = (ValaField*) base;
	result = self->priv->_lock_used;
	return result;
}

static void
vala_field_real_set_lock_used (ValaLockable* base,
                               gboolean value)
{
	ValaField* self;
	self = (ValaField*) base;
	self->priv->_lock_used = value;
}

/**
 * Creates a new field.
 *
 * @param name              field name
 * @param variable_type     field type
 * @param initializer       initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created field
 */
ValaField*
vala_field_construct (GType object_type,
                      const gchar* name,
                      ValaDataType* variable_type,
                      ValaExpression* initializer,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaField* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaField*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, comment);
	return self;
}

ValaField*
vala_field_new (const gchar* name,
                ValaDataType* variable_type,
                ValaExpression* initializer,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}

static void
vala_field_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaField * self;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_field (visitor, self);
}

static void
vala_field_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}

static void
vala_field_real_replace_expression (ValaCodeNode* base,
                                    ValaExpression* old_node,
                                    ValaExpression* new_node)
{
	ValaField * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_field_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_field_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaField * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaTypeSymbol* _tmp30_;
	ValaTypeSymbol* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSemanticAnalyzer* _tmp33_;
	ValaDataType* _tmp34_;
	ValaTypeSymbol* _tmp35_;
	ValaTypeSymbol* _tmp36_;
	ValaDataType* _tmp47_;
	ValaDataType* _tmp48_;
	gboolean _tmp49_;
	gboolean _tmp50_;
	ValaSemanticAnalyzer* _tmp55_;
	ValaSemanticAnalyzer* _tmp56_;
	ValaDataType* _tmp57_;
	ValaDataType* _tmp58_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp69_;
	ValaDataType* _tmp70_;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp73_ = FALSE;
	ValaArrayType* _tmp74_;
	gboolean _tmp86_ = FALSE;
	gboolean _tmp87_ = FALSE;
	ValaArrayType* _tmp88_;
	ValaExpression* _tmp97_;
	ValaExpression* _tmp98_;
	gboolean _tmp221_ = FALSE;
	ValaMemberBinding _tmp222_;
	gboolean field_in_header = FALSE;
	ValaSymbol* _tmp227_;
	ValaSymbol* _tmp228_;
	gboolean _tmp237_ = FALSE;
	gboolean _tmp238_ = FALSE;
	gboolean _tmp239_;
	gboolean _tmp240_;
	ValaSemanticAnalyzer* _tmp255_;
	ValaSemanticAnalyzer* _tmp256_;
	ValaSourceFile* _tmp257_;
	ValaSemanticAnalyzer* _tmp258_;
	ValaSemanticAnalyzer* _tmp259_;
	ValaSymbol* _tmp260_;
	gboolean _tmp261_;
	gboolean _tmp262_;
	gboolean result = FALSE;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp25_ = _tmp24_;
	if (VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp27_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_data_type_get_type_symbol (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_code_context_get_analyzer (context);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_->va_list_type;
	_tmp35_ = vala_data_type_get_type_symbol (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp31_ == _tmp36_) {
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaTypeSymbol* _tmp41_;
		ValaTypeSymbol* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_get_type_symbol (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strdup_printf ("`%s' not supported as field type", _tmp44_);
		_tmp46_ = _tmp45_;
		vala_report_error (_tmp38_, _tmp46_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp47_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp48_ = _tmp47_;
	vala_code_node_check ((ValaCodeNode*) _tmp48_, context);
	_tmp49_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp50_ = _tmp49_;
	if (!_tmp50_) {
		ValaSemanticAnalyzer* _tmp51_;
		ValaSemanticAnalyzer* _tmp52_;
		ValaDataType* _tmp53_;
		ValaDataType* _tmp54_;
		_tmp51_ = vala_code_context_get_analyzer (context);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp54_ = _tmp53_;
		vala_semantic_analyzer_check_type (_tmp52_, _tmp54_);
	}
	_tmp55_ = vala_code_context_get_analyzer (context);
	_tmp56_ = _tmp55_;
	_tmp57_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp58_ = _tmp57_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp56_, (ValaSymbol*) self, _tmp58_)) {
		ValaSourceReference* _tmp59_;
		ValaSourceReference* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_code_node_to_string ((ValaCodeNode*) _tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_strdup_printf ("field type `%s' is less accessible than field `%s'", _tmp64_, _tmp66_);
		_tmp68_ = _tmp67_;
		vala_report_error (_tmp60_, _tmp68_);
		_g_free0 (_tmp68_);
		_g_free0 (_tmp66_);
		_g_free0 (_tmp64_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp69_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp70_ = _tmp69_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp70_) ? ((ValaArrayType*) _tmp70_) : NULL;
	_tmp74_ = variable_array_type;
	if (_tmp74_ != NULL) {
		ValaArrayType* _tmp75_;
		gboolean _tmp76_;
		gboolean _tmp77_;
		_tmp75_ = variable_array_type;
		_tmp76_ = vala_array_type_get_inline_allocated (_tmp75_);
		_tmp77_ = _tmp76_;
		_tmp73_ = _tmp77_;
	} else {
		_tmp73_ = FALSE;
	}
	if (_tmp73_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		_tmp78_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp79_ = _tmp78_;
		_tmp72_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp79_);
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		ValaExpression* _tmp80_;
		ValaExpression* _tmp81_;
		ValaInitializerList* _tmp82_;
		ValaInitializerList* _tmp83_;
		_tmp80_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp81_ = _tmp80_;
		_tmp82_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp83_ = _tmp82_;
		_tmp71_ = _tmp83_ == NULL;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		ValaSourceReference* _tmp84_;
		ValaSourceReference* _tmp85_;
		_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp85_ = _tmp84_;
		vala_report_warning (_tmp85_, "Inline allocated arrays don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp88_ = variable_array_type;
	if (_tmp88_ != NULL) {
		ValaArrayType* _tmp89_;
		gboolean _tmp90_;
		gboolean _tmp91_;
		_tmp89_ = variable_array_type;
		_tmp90_ = vala_array_type_get_inline_allocated (_tmp89_);
		_tmp91_ = _tmp90_;
		_tmp87_ = _tmp91_;
	} else {
		_tmp87_ = FALSE;
	}
	if (_tmp87_) {
		ValaArrayType* _tmp92_;
		gboolean _tmp93_;
		gboolean _tmp94_;
		_tmp92_ = variable_array_type;
		_tmp93_ = vala_array_type_get_fixed_length (_tmp92_);
		_tmp94_ = _tmp93_;
		_tmp86_ = !_tmp94_;
	} else {
		_tmp86_ = FALSE;
	}
	if (_tmp86_) {
		ValaSourceReference* _tmp95_;
		ValaSourceReference* _tmp96_;
		_tmp95_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp96_ = _tmp95_;
		vala_report_error (_tmp96_, "Inline allocated array as field requires to have fixed length");
	}
	_tmp97_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp98_ = _tmp97_;
	if (_tmp98_ != NULL) {
		ValaExpression* _tmp99_;
		ValaExpression* _tmp100_;
		ValaDataType* _tmp101_;
		ValaDataType* _tmp102_;
		gboolean is_initializer_list = FALSE;
		gint initializer_size = 0;
		ValaExpression* _tmp103_;
		ValaExpression* _tmp104_;
		ValaExpression* _tmp109_;
		ValaExpression* _tmp110_;
		ValaExpression* _tmp111_;
		ValaExpression* _tmp112_;
		ValaDataType* _tmp113_;
		ValaDataType* _tmp114_;
		ValaExpression* _tmp117_;
		ValaExpression* _tmp118_;
		ValaDataType* _tmp119_;
		ValaDataType* _tmp120_;
		ValaDataType* _tmp121_;
		ValaDataType* _tmp122_;
		gboolean _tmp137_ = FALSE;
		gboolean _tmp138_ = FALSE;
		gboolean _tmp139_ = FALSE;
		ValaArrayType* _tmp140_;
		gboolean _tmp154_ = FALSE;
		gboolean _tmp155_ = FALSE;
		ValaArrayType* _tmp156_;
		ValaExpression* _tmp166_;
		ValaExpression* _tmp167_;
		ValaDataType* _tmp168_;
		ValaDataType* _tmp169_;
		gboolean _tmp179_ = FALSE;
		ValaSymbol* _tmp180_;
		ValaSymbol* _tmp181_;
		gboolean _tmp186_ = FALSE;
		gboolean _tmp187_ = FALSE;
		ValaSymbol* _tmp188_;
		ValaSymbol* _tmp189_;
		gboolean _tmp203_ = FALSE;
		gboolean _tmp204_ = FALSE;
		gboolean _tmp205_ = FALSE;
		ValaMemberBinding _tmp206_;
		gboolean _tmp217_;
		gboolean _tmp218_;
		_tmp99_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp100_ = _tmp99_;
		_tmp101_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp102_ = _tmp101_;
		vala_expression_set_target_type (_tmp100_, _tmp102_);
		is_initializer_list = FALSE;
		initializer_size = -1;
		_tmp103_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp104_ = _tmp103_;
		if (VALA_IS_INITIALIZER_LIST (_tmp104_)) {
			ValaExpression* _tmp105_;
			ValaExpression* _tmp106_;
			gint _tmp107_;
			gint _tmp108_;
			_tmp105_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp106_ = _tmp105_;
			_tmp107_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp108_ = _tmp107_;
			initializer_size = _tmp108_;
			is_initializer_list = TRUE;
		}
		_tmp109_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp110_ = _tmp109_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp110_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp111_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_expression_get_value_type (_tmp112_);
		_tmp114_ = _tmp113_;
		if (_tmp114_ == NULL) {
			ValaSourceReference* _tmp115_;
			ValaSourceReference* _tmp116_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp116_ = _tmp115_;
			vala_report_error (_tmp116_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp117_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp118_ = _tmp117_;
		_tmp119_ = vala_expression_get_value_type (_tmp118_);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp122_ = _tmp121_;
		if (!vala_data_type_compatible (_tmp120_, _tmp122_)) {
			ValaSourceReference* _tmp123_;
			ValaSourceReference* _tmp124_;
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			ValaDataType* _tmp127_;
			ValaDataType* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			ValaDataType* _tmp131_;
			ValaDataType* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			gchar* _tmp136_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp123_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp124_ = _tmp123_;
			_tmp125_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp126_ = _tmp125_;
			_tmp127_ = vala_expression_get_value_type (_tmp126_);
			_tmp128_ = _tmp127_;
			_tmp129_ = vala_code_node_to_string ((ValaCodeNode*) _tmp128_);
			_tmp130_ = _tmp129_;
			_tmp131_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_code_node_to_string ((ValaCodeNode*) _tmp132_);
			_tmp134_ = _tmp133_;
			_tmp135_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp130_, _tmp134_);
			_tmp136_ = _tmp135_;
			vala_report_error (_tmp124_, _tmp136_);
			_g_free0 (_tmp136_);
			_g_free0 (_tmp134_);
			_g_free0 (_tmp130_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp140_ = variable_array_type;
		if (_tmp140_ != NULL) {
			ValaArrayType* _tmp141_;
			gboolean _tmp142_;
			gboolean _tmp143_;
			_tmp141_ = variable_array_type;
			_tmp142_ = vala_array_type_get_inline_allocated (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp139_ = _tmp143_;
		} else {
			_tmp139_ = FALSE;
		}
		if (_tmp139_) {
			ValaArrayType* _tmp144_;
			gboolean _tmp145_;
			gboolean _tmp146_;
			_tmp144_ = variable_array_type;
			_tmp145_ = vala_array_type_get_fixed_length (_tmp144_);
			_tmp146_ = _tmp145_;
			_tmp138_ = !_tmp146_;
		} else {
			_tmp138_ = FALSE;
		}
		if (_tmp138_) {
			_tmp137_ = is_initializer_list;
		} else {
			_tmp137_ = FALSE;
		}
		if (_tmp137_) {
			ValaArrayType* _tmp147_;
			gchar* _tmp148_;
			gchar* _tmp149_;
			ValaIntegerLiteral* _tmp150_;
			ValaIntegerLiteral* _tmp151_;
			ValaArrayType* _tmp152_;
			ValaArrayType* _tmp153_;
			_tmp147_ = variable_array_type;
			_tmp148_ = g_strdup_printf ("%i", initializer_size);
			_tmp149_ = _tmp148_;
			_tmp150_ = vala_integer_literal_new (_tmp149_, NULL);
			_tmp151_ = _tmp150_;
			vala_array_type_set_length (_tmp147_, (ValaExpression*) _tmp151_);
			_vala_code_node_unref0 (_tmp151_);
			_g_free0 (_tmp149_);
			_tmp152_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp152_, TRUE);
			_tmp153_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp153_, FALSE);
		}
		_tmp156_ = variable_array_type;
		if (_tmp156_ != NULL) {
			ValaArrayType* _tmp157_;
			gboolean _tmp158_;
			gboolean _tmp159_;
			_tmp157_ = variable_array_type;
			_tmp158_ = vala_array_type_get_inline_allocated (_tmp157_);
			_tmp159_ = _tmp158_;
			_tmp155_ = _tmp159_;
		} else {
			_tmp155_ = FALSE;
		}
		if (_tmp155_) {
			ValaExpression* _tmp160_;
			ValaExpression* _tmp161_;
			ValaDataType* _tmp162_;
			ValaDataType* _tmp163_;
			_tmp160_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp161_ = _tmp160_;
			_tmp162_ = vala_expression_get_value_type (_tmp161_);
			_tmp163_ = _tmp162_;
			_tmp154_ = !VALA_IS_ARRAY_TYPE (_tmp163_);
		} else {
			_tmp154_ = FALSE;
		}
		if (_tmp154_) {
			ValaSourceReference* _tmp164_;
			ValaSourceReference* _tmp165_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp165_ = _tmp164_;
			vala_report_error (_tmp165_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp166_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp167_ = _tmp166_;
		_tmp168_ = vala_expression_get_value_type (_tmp167_);
		_tmp169_ = _tmp168_;
		if (vala_data_type_is_disposable (_tmp169_)) {
			gboolean _tmp170_ = FALSE;
			ValaDataType* _tmp171_;
			ValaDataType* _tmp172_;
			_tmp171_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp172_ = _tmp171_;
			if (!VALA_IS_POINTER_TYPE (_tmp172_)) {
				ValaDataType* _tmp173_;
				ValaDataType* _tmp174_;
				gboolean _tmp175_;
				gboolean _tmp176_;
				_tmp173_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp174_ = _tmp173_;
				_tmp175_ = vala_data_type_get_value_owned (_tmp174_);
				_tmp176_ = _tmp175_;
				_tmp170_ = !_tmp176_;
			} else {
				_tmp170_ = FALSE;
			}
			if (_tmp170_) {
				ValaSourceReference* _tmp177_;
				ValaSourceReference* _tmp178_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp177_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp178_ = _tmp177_;
				vala_report_error (_tmp178_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp180_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp181_ = _tmp180_;
		if (VALA_IS_NAMESPACE (_tmp181_)) {
			ValaExpression* _tmp182_;
			ValaExpression* _tmp183_;
			_tmp182_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp183_ = _tmp182_;
			_tmp179_ = !vala_expression_is_constant (_tmp183_);
		} else {
			_tmp179_ = FALSE;
		}
		if (_tmp179_) {
			ValaSourceReference* _tmp184_;
			ValaSourceReference* _tmp185_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp185_ = _tmp184_;
			vala_report_error (_tmp185_, "Non-constant field initializers not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp188_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp189_ = _tmp188_;
		if (VALA_IS_NAMESPACE (_tmp189_)) {
			ValaExpression* _tmp190_;
			ValaExpression* _tmp191_;
			_tmp190_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp191_ = _tmp190_;
			_tmp187_ = vala_expression_is_constant (_tmp191_);
		} else {
			_tmp187_ = FALSE;
		}
		if (_tmp187_) {
			ValaExpression* _tmp192_;
			ValaExpression* _tmp193_;
			_tmp192_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp193_ = _tmp192_;
			_tmp186_ = vala_expression_is_non_null (_tmp193_);
		} else {
			_tmp186_ = FALSE;
		}
		if (_tmp186_) {
			gboolean _tmp194_ = FALSE;
			ValaDataType* _tmp195_;
			ValaDataType* _tmp196_;
			_tmp195_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp196_ = _tmp195_;
			if (vala_data_type_is_disposable (_tmp196_)) {
				ValaDataType* _tmp197_;
				ValaDataType* _tmp198_;
				gboolean _tmp199_;
				gboolean _tmp200_;
				_tmp197_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp198_ = _tmp197_;
				_tmp199_ = vala_data_type_get_value_owned (_tmp198_);
				_tmp200_ = _tmp199_;
				_tmp194_ = _tmp200_;
			} else {
				_tmp194_ = FALSE;
			}
			if (_tmp194_) {
				ValaSourceReference* _tmp201_;
				ValaSourceReference* _tmp202_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp201_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp202_ = _tmp201_;
				vala_report_error (_tmp202_, "Owned namespace fields can only be initialized in a function or method");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp206_ = self->priv->_binding;
		if (_tmp206_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp207_;
			ValaSymbol* _tmp208_;
			_tmp207_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp208_ = _tmp207_;
			_tmp205_ = VALA_IS_CLASS (_tmp208_);
		} else {
			_tmp205_ = FALSE;
		}
		if (_tmp205_) {
			ValaSymbol* _tmp209_;
			ValaSymbol* _tmp210_;
			gboolean _tmp211_;
			gboolean _tmp212_;
			_tmp209_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp210_ = _tmp209_;
			_tmp211_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp210_, VALA_TYPE_CLASS, ValaClass));
			_tmp212_ = _tmp211_;
			_tmp204_ = _tmp212_;
		} else {
			_tmp204_ = FALSE;
		}
		if (_tmp204_) {
			ValaExpression* _tmp213_;
			ValaExpression* _tmp214_;
			_tmp213_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp214_ = _tmp213_;
			_tmp203_ = !vala_expression_is_constant (_tmp214_);
		} else {
			_tmp203_ = FALSE;
		}
		if (_tmp203_) {
			ValaSourceReference* _tmp215_;
			ValaSourceReference* _tmp216_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp216_ = _tmp215_;
			vala_report_error (_tmp216_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp217_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp218_ = _tmp217_;
		if (_tmp218_) {
			ValaSourceReference* _tmp219_;
			ValaSourceReference* _tmp220_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp219_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp220_ = _tmp219_;
			vala_report_error (_tmp220_, "External fields cannot use initializers");
		}
	}
	_tmp222_ = self->priv->_binding;
	if (_tmp222_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp223_;
		ValaSymbol* _tmp224_;
		_tmp223_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp224_ = _tmp223_;
		_tmp221_ = VALA_IS_INTERFACE (_tmp224_);
	} else {
		_tmp221_ = FALSE;
	}
	if (_tmp221_) {
		ValaSourceReference* _tmp225_;
		ValaSourceReference* _tmp226_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp225_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp226_ = _tmp225_;
		vala_report_error (_tmp226_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	field_in_header = !vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	_tmp227_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp228_ = _tmp227_;
	if (VALA_IS_CLASS (_tmp228_)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp229_;
		ValaSymbol* _tmp230_;
		ValaClass* _tmp231_;
		gboolean _tmp232_ = FALSE;
		ValaClass* _tmp233_;
		gboolean _tmp234_;
		gboolean _tmp235_;
		_tmp229_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp230_ = _tmp229_;
		_tmp231_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp230_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp231_;
		_tmp233_ = cl;
		_tmp234_ = vala_class_get_is_compact (_tmp233_);
		_tmp235_ = _tmp234_;
		if (_tmp235_) {
			ValaClass* _tmp236_;
			_tmp236_ = cl;
			_tmp232_ = !vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp236_);
		} else {
			_tmp232_ = FALSE;
		}
		if (_tmp232_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp239_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp240_ = _tmp239_;
	if (!_tmp240_) {
		gboolean _tmp241_;
		gboolean _tmp242_;
		_tmp241_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp242_ = _tmp241_;
		_tmp238_ = !_tmp242_;
	} else {
		_tmp238_ = FALSE;
	}
	if (_tmp238_) {
		ValaSymbol* _tmp243_;
		ValaSymbol* _tmp244_;
		_tmp243_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp244_ = _tmp243_;
		_tmp237_ = _tmp244_ != NULL;
		_vala_code_node_unref0 (_tmp244_);
	} else {
		_tmp237_ = FALSE;
	}
	if (_tmp237_) {
		ValaSourceReference* _tmp245_;
		ValaSourceReference* _tmp246_;
		gchar* _tmp247_;
		gchar* _tmp248_;
		ValaSymbol* _tmp249_;
		ValaSymbol* _tmp250_;
		gchar* _tmp251_;
		gchar* _tmp252_;
		gchar* _tmp253_;
		gchar* _tmp254_;
		_tmp245_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp246_ = _tmp245_;
		_tmp247_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp248_ = _tmp247_;
		_tmp249_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp250_ = _tmp249_;
		_tmp251_ = vala_symbol_get_full_name (_tmp250_);
		_tmp252_ = _tmp251_;
		_tmp253_ = g_strdup_printf ("%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp248_, _tmp252_);
		_tmp254_ = _tmp253_;
		vala_report_warning (_tmp246_, _tmp254_);
		_g_free0 (_tmp254_);
		_g_free0 (_tmp252_);
		_vala_code_node_unref0 (_tmp250_);
		_g_free0 (_tmp248_);
	}
	_tmp255_ = vala_code_context_get_analyzer (context);
	_tmp256_ = _tmp255_;
	_tmp257_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp256_, _tmp257_);
	_tmp258_ = vala_code_context_get_analyzer (context);
	_tmp259_ = _tmp258_;
	_tmp260_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp259_, _tmp260_);
	_tmp261_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp262_ = _tmp261_;
	result = !_tmp262_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_field_class_init (ValaFieldClass * klass,
                       gpointer klass_data)
{
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_adjust_private_offset (klass, &ValaField_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_field_real_check;
}

static void
vala_field_vala_lockable_interface_init (ValaLockableIface * iface,
                                         gpointer iface_data)
{
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_field_real_get_lock_used;
	iface->set_lock_used = vala_field_real_set_lock_used;
}

static void
vala_field_instance_init (ValaField * self,
                          gpointer klass)
{
	self->priv = vala_field_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
}

static void
vala_field_finalize (ValaCodeNode * obj)
{
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace field.
 */
static GType
vala_field_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
	static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_field_type_id;
	vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
	g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
	ValaField_private_offset = g_type_add_instance_private (vala_field_type_id, sizeof (ValaFieldPrivate));
	return vala_field_type_id;
}

GType
vala_field_get_type (void)
{
	static volatile gsize vala_field_type_id__volatile = 0;
	if (g_once_init_enter (&vala_field_type_id__volatile)) {
		GType vala_field_type_id;
		vala_field_type_id = vala_field_get_type_once ();
		g_once_init_leave (&vala_field_type_id__volatile, vala_field_type_id);
	}
	return vala_field_type_id__volatile;
}

