/*****************************************************************************

	unsort - reorder files semi-randomly
	Copyright (C) 2007, 2008  Wessel Dankers <wsl@fruit.je>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

	$Id: filebuf.h 1332 2008-06-10 20:01:01Z wsl $
	$URL: http://rot.zo.oi/svn/wsl/src/unsort/filebuf.h $

*****************************************************************************/

#ifndef FILEBUF_H
#define FILEBUF_H

#include <stdint.h>
#include <sys/types.h>

typedef struct filebuf {
	void *buf;
	size_t len;
	const char *name;
	uint32_t start;
	uint32_t count;
	uint32_t cursor;
} filebuf_t;

extern const filebuf_t filebuf_0;

extern void filebuf_init(filebuf_t *, int);

#endif
