/*****************************************************************************

	unsort - reorder files semi-randomly
	Copyright (C) 2006, 2007  Wessel Dankers <wsl@fruit.je>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

	$Id: error.c 1332 2008-06-10 20:01:01Z wsl $
	$URL: http://rot.zo.oi/svn/wsl/src/unsort/error.c $

*****************************************************************************/

#include <stdint.h>
#include <inttypes.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include "error.h"

void exit_error(error_code e, const char *msg, ...) {
	va_list ap;

	if(msg) {
		va_start(ap, msg);
		vfprintf(stderr, msg, ap);
		va_end(ap);
		putc('\n', stderr);
	}

	exit((int)e);
}

void warn_error(const char *msg, ...) {
	va_list ap;

	if(msg) {
		va_start(ap, msg);
		vfprintf(stderr, msg, ap);
		va_end(ap);
		putc('\n', stderr);
	}
}

void exit_perror(error_code e, const char *msg, ...) {
	va_list ap;

	if(msg) {
		va_start(ap, msg);
		vfprintf(stderr, msg, ap);
		va_end(ap);
		fprintf(stderr, ": %s\n", strerror(errno));
	}

	exit((int)e);
}

void warn_perror(const char *msg, ...) {
	va_list ap;

	if(msg) {
		va_start(ap, msg);
		vfprintf(stderr, msg, ap);
		va_end(ap);
		fprintf(stderr, ": %s\n", strerror(errno));
	}
}

void *xalloc(size_t len) {
	void *buf = malloc(len);
	if(!buf)
		exit_perror(ERROR_SYSTEM, "Can't malloc(%"PRIu64")", (uint64_t)len);
	return buf;
}
