/*
 * Copyright (C) 2019 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU  Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/&gt;.
 *
 */

#ifndef COMMON_H
#define COMMON_H

#define PANEL_DEFAULT_SIZE 32
#define PANEL_MINIMUM_SIZE 16
#define PANEL_MAXIMUM_SIZE 200
#define PANEL_HIDE_SIZE 4

#define PANEL_DEFAULT_ICON_SIZE 22
#define PANEL_DEFAULT_LINE_COUNT 1

#define PANEL_DEFAULT_BACKGROUND_COLOR "#CCCCCC"

#define PANEL_HIDE_DELAY 500
#define PANEL_HIDE_FIRST_TIME (5000 - PANEL_HIDE_DELAY)

#define PANEL_SHOW_DELAY 0

#define SETTINGS_SAVE_DELAY 1000

// Config keys and groups
#define CFG_KEY_SCREENNUM          "desktop"
#define CFG_KEY_POSITION           "position"
#define CFG_KEY_LINECNT            "lineCount"
#define CFG_KEY_LENGTH             "width"
#define CFG_KEY_PERCENT            "width-percent"
#define CFG_KEY_ALIGNMENT          "alignment"
#define CFG_KEY_RESERVESPACE       "reserve-space"
#define CFG_KEY_PLUGINS            "plugins"
#define CFG_KEY_HIDABLE            "hidable"
#define CFG_KEY_VISIBLE_MARGIN     "visible-margin"
#define CFG_KEY_ANIMATION          "animation-duration"
#define CFG_KEY_SHOW_DELAY         "show-delay"
#define CFG_KEY_LOCKPANEL          "lockPanel"
#define CFG_KEY_PLUGINS_PC         "plugins-pc"
#define CFG_KEY_PLUGINS_PAD         "plugins-pad"

#define GSETTINGS_SCHEMA_SCREENSAVER "org.mate.interface"
#define KEY_MODE "gtk-theme"

#define PANEL_SIZE_LARGE  92
#define PANEL_SIZE_MEDIUM 70
#define PANEL_SIZE_SMALL  46
#define ICON_SIZE_LARGE   64
#define ICON_SIZE_MEDIUM  48
#define ICON_SIZE_SMALL   32
#define PANEL_SIZE_LARGE_V 70
#define PANEL_SIZE_MEDIUM_V 62
#define PANEL_SIZE_SMALL_V 47
#define POPUP_BORDER_SPACING 4
#define SETTINGS_SAVE_DELAY 1000
//panel gsettings
#define PANEL_SETTINGS      "org.ukui.panel.settings"
#define PANEL_SIZE_KEY      "panelsize"
#define ICON_SIZE_KEY       "iconsize"
#define PANEL_POSITION_KEY  "panelposition"
#define SHOW_TASKVIEW_KEY   "showtaskview"
#define LOCK_PANEL_KEY          "lockpanel"
#define HIDE_PANEL_KEY          "hidepanel"
#define ABOUT_KYLIN_DISPLAY "aboutkylin-display"

#define GROUPING_ENABLE     "groupingenable"
#define TASKBAR_BTN_SPAN    "taskbarbtnspan"
//panel-daemon DBUS
#define UKUI_PANEL_DAEMON           "org.ukui.panel.daemon"
#define UKUI_PANEL_DAEMON_PATH      "/convert/desktopwid"
#define UKUI_PANEL_DAEMON_INTERFACE "org.ukui.panel.daemon"
#define UKUI_PANEL_DAEMON_METHOD    "WIDToDesktop"

#define TRANSPARENCY_SETTINGS       "org.ukui.control-center.personalise"
#define TRANSPARENCY_KEY            "transparency"

#define UKUI_SERVICE        "org.gnome.SessionManager"
#define UKUI_PATH           "/org/gnome/SessionManager"
#define UKUI_INTERFACE      "org.gnome.SessionManager"

#define ORG_UKUI_STYLE              "org.ukui.style"
#define STYLE_NAME                  "styleName"
#define STYLE_NAME_KEY_DARK         "ukui-dark"
#define STYLE_NAME_KEY_DEFAULT      "ukui-default"
#define STYLE_NAME_KEY_BLACK        "ukui-black"
#define STYLE_NAME_KEY_LIGHT        "ukui-light"
#define STYLE_NAME_KEY_WHITE        "ukui-white"
#define STYLE_NAME_KEY_ICONTHEME    "iconThemeName"
#define SYSTEM_FONT_SIZE            "systemFontSize"
#define WINDOW_RADIUS               "windowRadius"

//USD primary screen changed Infomation
#define USD_SERVICE                "org.ukui.SettingsDaemon"
#define USD_XRANDER_PATH           "/org/ukui/SettingsDaemon/xrandr"
#define USD_XRANDER_INTERFACE      "org.ukui.SettingsDaemon.xrandr"
#define PRIMARY_CHANGED            "primaryChanged"

//开始菜单DBUS
#define UKUI_MENU_SERVICE           "org.ukui.menu"
#define UKUI_MENU_PATH              "/org/ukui/menu"
#define UKUI_MENU_INTERFACE         "org.ukui.menu"
#define WIN_KEY_RESPONSE            "WinKeyResponse"

//系统登录
#define LOGIN_SERVICE               "org.freedesktop.login1"
#define LOGIN_PATH                  "/org/freedesktop/login1"
#define LOGIN_INTERFACE             "org.freedesktop.login1.Manager"
#define CAN_SUSPEND_METHOD          "CanSuspend"
#define CAN_HIBERNATE_METHOD        "CanHibernate"

//系统账户
#define ACCOUNTS_SERVICE            "org.freedesktop.Accounts"
#define ACCOUNTS_PATH               "/org/freedesktop/Accounts"
#define HAS_MULTIPLE_USER           "HasMultipleUsers"

//系统显示
#define DISPLAYMANAGER_SERVICE      "org.freedesktop.DisplayManager"
#define DISPLAYMANAGER_PATH         "/org/freedesktop/DisplayManager/Seat0"
#define PROPERTIES_INTERFACE        "org.freedesktop.DBus.Properties"
#define DISPLAYMANAGER_INTERFACE    "org.freedesktop.DisplayManager.Seat"
#define CAN_SWITCH_METHOD           "CanSwitch"

//系统更新
#define SYSTEMUPGRADE_SERVICE       "com.kylin.systemupgrade"
#define SYSTEMUPGRADE_PATH          "/com/kylin/systemupgrade"
#define SYSTEMUPGRADE_INTERFACE     "com.kylin.systemupgrade.interface"
#define CHECK_INSTALL_REQUIRED      "CheckInstallRequired"
#define TRIGGER_INSTALL_ON_SHUTDOWN "TriggerInstallOnShutdown"

//窗管
#define OPENGL               "gl2"
#define XRENDER              "xrender"

#define UKUI_KWIN_SERVICE    "org.ukui.KWin"
#define UKUI_KWIN_PATH       "/Compositor"
#define UKUI_KWIN_INTERFACE  "org.ukui.kwin.Compositing"
#define COMPOSITING_TYPE     "compositingType"

#define SDK2CPP(func) []()->QString { char* p = func(); QString str(p); free(p); return str; }

//查询desktop文件
#define UKUI_PANEL_DAEMON           "org.ukui.panel.daemon"
#define UKUI_PANEL_DAEMON_PATH      "/convert/desktopwid"
#define UKUI_PANEL_DAEMON_INTERFACE "org.ukui.panel.daemon"
#define UKUI_PANEL_DAEMON_METHOD    "WIDToDesktop"
#define DESKTOP_FILE_PATH          "/usr/share/applications/"
#define ANDROID_DESKTOP_FILE_PATH  "/.local/share/applications/"

#define MAX_SIZE_OF_Thumb   16777215
#define PANEL_CONFIG_PATH  "/usr/share/ukui/ukui-panel/panel-commission.ini"

#endif // COMMON_H

