/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef PASSWORDBAR_H
#define PASSWORDBAR_H

#include <QWidget>
#include <QLabel>
#include <QPushButton>
#include <QGSettings/QGSettings>
#include <QVariant>

#define UKUI_QT_STYLE                      "org.ukui.style"
#define UKUI_STYLE_KEY                     "style-name"

class PasswordBar : public QWidget
{
public:
    PasswordBar(QWidget *parent = nullptr);
    ~PasswordBar();

    void setLength(int l);
    void setBallRadius(int l);
    void setBallSpan(int l);
    void addFillBall();
    void delFillBall();
    void setFillBall(int l);
    int getFillBall();

private:
    void initUI();
    void adjSize();

protected:
    void paintEvent(QPaintEvent *event);
    QSize sizeHint() const;

private:
    int m_bitLen;
    int m_ballRadius;
    int m_fillBallCnt;
    int m_ballSpan;
    QGSettings *m_style = nullptr;
};
#endif // PASSWORDBAR_H
