;;;
;;; Copyright (c) 2010-2013 uim Project http://code.google.com/p/uim/
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;

(define ja-rk-rule-basic
  '(
    ((("-"). ())("" "" ""))
    (((","). ())("" "" ""))
    ((("."). ())("" "" ""))
    ((("!"). ())("" "" "!"))
    ((("\""). ())("" "" "\""))
    ((("#"). ())("" "" "#"))
    ((("$"). ())("" "" "$"))
    ((("%"). ())("" "" "%"))
    ((("&"). ())("" "" "&"))
    ((("'"). ())("" "" "'"))
    ((("("). ())("" "" "("))
    (((")"). ())("" "" ")"))
    ((("~"). ())("" "" "~"))
    ((("="). ())("" "" "="))
    ((("^"). ())("" "" "^"))
    ((("\\"). ())("" "" "\\"))
    ((("|"). ())("" "" "|"))
    ((("`"). ())("" "" "`"))
    ((("@"). ())("" "" "@"))
    ((("{"). ())("" "" "{"))
    ((("["). ())("" "" ""))
    ((("+"). ())("" "" "+"))
    (((";"). ())("" "" ";"))
    ((("*"). ())("" "" "*"))
    (((":"). ())("" "" ":"))
    ((("}"). ())("" "" "}"))
    ((("]"). ())("" "" ""))
    ((("<"). ())("" "" "<"))
    (((">"). ())("" "" ">"))
    ((("?"). ())("" "" "?"))
    ((("/"). ())("" "" "/"))
    ((("_"). ())("" "" "_"))
    ;; Since ordinary Japanese users press the "yen sign" key on
    ;; Japanese keyboard in romaji-halfwidth-kana-mode "to input
    ;; character code 134" rather than "to input yen sign symbol", I
    ;; changed the fullwidth yen sign with backslash.
    ;;   -- YamaKen 2007-09-17
    ;; ((("yen"). ())("" "" "")) ;; XXX
    ((("yen"). ())("" "" "\\"))

    ((("1"). ())("1" "1" "1"))
    ((("2"). ())("2" "2" "2"))
    ((("3"). ())("3" "3" "3"))
    ((("4"). ())("4" "4" "4"))
    ((("5"). ())("5" "5" "5"))
    ((("6"). ())("6" "6" "6"))
    ((("7"). ())("7" "7" "7"))
    ((("8"). ())("8" "8" "8"))
    ((("9"). ())("9" "9" "9"))
    ((("0"). ())("0" "0" "0"))

    ((("a"). ())("" "" ""))
    ((("i"). ())("" "" ""))
    ((("u"). ())("" "" ""))
    ((("e"). ())("" "" ""))
    ((("o"). ())("" "" ""))

    ((("x" "a"). ())("" "" ""))
    ((("x" "i"). ())("" "" ""))
    ((("x" "y" "i"). ())("" "" ""))
    ((("x" "u"). ())("" "" ""))
    ((("x" "e"). ())("" "" ""))
    ((("x" "y" "e"). ())("" "" ""))
    ((("x" "o"). ())("" "" ""))

    ((("l" "a"). ())("" "" ""))
    ((("l" "i"). ())("" "" ""))
    ((("l" "u"). ())("" "" ""))
    ((("l" "e"). ())("" "" ""))
    ((("l" "o"). ())("" "" ""))

    ((("k" "k"). ("k"))("" "" ""))

    ((("k" "a"). ())("" "" ""))
    ((("k" "i"). ())("" "" ""))
    ((("k" "u"). ())("" "" ""))
    ((("k" "e"). ())("" "" ""))
    ((("k" "o"). ())("" "" ""))
    ((("k" "y" "a"). ())(("" "" "") ("" "" "")))
    ((("k" "y" "i"). ())(("" "" "") ("" "" "")))
    ((("k" "y" "u"). ())(("" "" "") ("" "" "")))
    ((("k" "y" "e"). ())(("" "" "") ("" "" "")))
    ((("k" "y" "o"). ())(("" "" "") ("" "" "")))

    ((("g" "g"). ("g"))("" "" ""))


    ((("g" "a"). ())("" "" ""))
    ((("g" "i"). ())("" "" ""))
    ((("g" "u"). ())("" "" ""))
    ((("g" "e"). ())("" "" ""))
    ((("g" "o"). ())("" "" ""))

    ((("g" "y" "a"). ())(("" "" "") ("" "" "")))
    ((("g" "y" "i"). ())(("" "" "") ("" "" "")))
    ((("g" "y" "u"). ())(("" "" "") ("" "" "")))
    ((("g" "y" "e"). ())(("" "" "") ("" "" "")))
    ((("g" "y" "o"). ())(("" "" "") ("" "" "")))

    ((("q" "a"). ())(("" "" "") ("" "" "")))
    ((("q" "i"). ())(("" "" "") ("" "" "")))
    ((("q" "u"). ())("" "" ""))
    ((("q" "e"). ())(("" "" "") ("" "" "")))
    ((("q" "o"). ())(("" "" "") ("" "" "")))

    ((("s" "s"). ("s"))("" "" ""))

    ((("s" "a"). ())("" "" ""))
    ((("s" "i"). ())("" "" ""))
    ((("s" "u"). ())("" "" ""))
    ((("s" "e"). ())("" "" ""))
    ((("s" "o"). ())("" "" ""))

    ((("s" "y" "a"). ())(("" "" "") ("" "" "")))
    ((("s" "y" "i"). ())(("" "" "") ("" "" "")))
    ((("s" "y" "u"). ())(("" "" "") ("" "" "")))
    ((("s" "y" "e"). ())(("" "" "") ("" "" "")))
    ((("s" "y" "o"). ())(("" "" "") ("" "" "")))

    ((("z" "z"). ("z"))("" "" ""))

    ((("z" "a"). ())("" "" ""))
    ((("z" "i"). ())("" "" ""))
    ((("z" "u"). ())("" "" ""))
    ((("z" "e"). ())("" "" ""))
    ((("z" "o"). ())("" "" ""))
    ((("z" "y" "a"). ())(("" "" "") ("" "" "")))
    ((("z" "y" "i"). ())(("" "" "") ("" "" "")))
    ((("z" "y" "u"). ())(("" "" "") ("" "" "")))
    ((("z" "y" "e"). ())(("" "" "") ("" "" "")))
    ((("z" "y" "o"). ())(("" "" "") ("" "" "")))

    ((("j" "j"). ("j"))("" "" ""))

    ((("j" "a"). ())(("" "" "") ("" "" "")))
    ((("j" "i"). ())("" "" ""))
    ((("j" "u"). ())(("" "" "") ("" "" "")))
    ((("j" "e"). ())(("" "" "") ("" "" "")))
    ((("j" "o"). ())(("" "" "") ("" "" "")))

    ((("j" "y" "a"). ())(("" "" "") ("" "" "")))
    ((("j" "y" "i"). ())(("" "" "") ("" "" "")))
    ((("j" "y" "u"). ())(("" "" "") ("" "" "")))
    ((("j" "y" "e"). ())(("" "" "") ("" "" "")))
    ((("j" "y" "o"). ())(("" "" "") ("" "" "")))

    ((("t" "t"). ("t"))("" "" ""))
    ((("t" "c"). ("c"))("" "" ""))

    ((("t" "a"). ())("" "" ""))
    ((("t" "i"). ())("" "" ""))
    ((("t" "u"). ())("" "" ""))
    ((("t" "e"). ())("" "" ""))
    ((("t" "o"). ())("" "" ""))

    ((("t" "y" "a"). ())(("" "" "") ("" "" "")))
    ((("t" "y" "i"). ())(("" "" "") ("" "" "")))
    ((("t" "y" "u"). ())(("" "" "") ("" "" "")))
    ((("t" "y" "e"). ())(("" "" "") ("" "" "")))
    ((("t" "y" "o"). ())(("" "" "") ("" "" "")))

    ((("t" "s" "a"). ())(("" "" "") ("" "" "")))
    ((("t" "s" "i"). ())(("" "" "") ("" "" "")))
    ((("t" "s" "u"). ())("" "" ""))
    ((("t" "s" "e"). ())(("" "" "") ("" "" "")))
    ((("t" "s" "o"). ())(("" "" "") ("" "" "")))

    ((("c" "y" "a"). ())(("" "" "") ("" "" "")))
    ((("c" "y" "i"). ())(("" "" "") ("" "" "")))
    ((("c" "y" "u"). ())(("" "" "") ("" "" "")))
    ((("c" "y" "e"). ())(("" "" "") ("" "" "")))
    ((("c" "y" "o"). ())(("" "" "") ("" "" "")))

    ((("x" "t" "u"). ())("" "" ""))
    ((("x" "t" "s" "u"). ())("" "" ""))
    ((("c" "c"). ("c"))("" "" ""))

    ((("d" "d"). ("d"))("" "" ""))

    ((("d" "a"). ())("" "" ""))
    ((("d" "i"). ())("" "" ""))
    ((("d" "u"). ())("" "" ""))
    ((("d" "e"). ())("" "" "Î"))
    ((("d" "o"). ())("" "" "Ď"))

    ((("d" "y" "a"). ())(("" "" "") ("" "" "")))
    ((("d" "y" "i"). ())(("" "" "") ("" "" "")))
    ((("d" "y" "u"). ())(("" "" "") ("" "" "")))
    ((("d" "y" "e"). ())(("" "" "") ("" "" "")))
    ((("d" "y" "o"). ())(("" "" "") ("" "" "")))

    ((("n" "n"). ())("" "" ""))
    ((("n" "'"). ())("" "" ""))
    ((("n"). ())("" "" ""))

    ((("n" "a"). ())("" "" ""))
    ((("n" "i"). ())("" "" ""))
    ((("n" "u"). ())("" "" ""))
    ((("n" "e"). ())("" "" ""))
    ((("n" "o"). ())("" "" ""))

    ((("n" "y" "a"). ())(("" "" "") ("" "" "")))
    ((("n" "y" "i"). ())(("" "" "") ("" "" "")))
    ((("n" "y" "u"). ())(("" "" "") ("" "" "")))
    ((("n" "y" "e"). ())(("" "" "") ("" "" "")))
    ((("n" "y" "o"). ())(("" "" "") ("" "" "")))

    ((("h" "h"). ("h"))("" "" ""))

    ((("h" "a"). ())("" "" ""))
    ((("h" "i"). ())("" "" ""))
    ((("h" "u"). ())("" "" ""))
    ((("h" "e"). ())("" "" ""))
    ((("h" "o"). ())("" "" ""))

    ((("h" "y" "a"). ())(("" "" "") ("" "" "")))
    ((("h" "y" "i"). ())(("" "" "") ("" "" "")))
    ((("h" "y" "u"). ())(("" "" "") ("" "" "")))
    ((("h" "y" "e"). ())(("" "" "") ("" "" "")))
    ((("h" "y" "o"). ())(("" "" "") ("" "" "")))

    ((("f" "f"). ("f"))("" "" ""))

    ((("f" "a"). ())(("" "" "") ("" "" "")))
    ((("f" "i"). ())(("" "" "") ("" "" "")))
    ((("f" "u"). ())("" "" ""))
    ((("f" "e"). ())(("" "" "") ("" "" "")))
    ((("f" "o"). ())(("" "" "") ("" "" "")))

    ((("f" "y" "a"). ())(("" "" "") ("" "" "")))
    ((("f" "y" "i"). ())(("" "" "") ("" "" "")))
    ((("f" "y" "u"). ())(("" "" "") ("" "" "")))
    ((("f" "y" "e"). ())(("" "" "") ("" "" "")))
    ((("f" "y" "o"). ())(("" "" "") ("" "" "")))

    ((("b" "b"). ("b"))("" "" ""))

    ((("b" "a"). ())("" "" "ʎ"))
    ((("b" "i"). ())("" "" "ˎ"))
    ((("b" "u"). ())("" "" "̎"))
    ((("b" "e"). ())("" "" "͎"))
    ((("b" "o"). ())("" "" "Ύ"))

    ((("b" "y" "a"). ())(("" "" "ˎ") ("" "" "")))
    ((("b" "y" "i"). ())(("" "" "ˎ") ("" "" "")))
    ((("b" "y" "u"). ())(("" "" "ˎ") ("" "" "")))
    ((("b" "y" "e"). ())(("" "" "ˎ") ("" "" "")))
    ((("b" "y" "o"). ())(("" "" "ˎ") ("" "" "")))

    ((("p" "p"). ("p"))("" "" ""))

    ((("p" "a"). ())("" "" "ʎ"))
    ((("p" "i"). ())("" "" "ˎ"))
    ((("p" "u"). ())("" "" "̎"))
    ((("p" "e"). ())("" "" "͎"))
    ((("p" "o"). ())("" "" "Ύ"))

    ((("p" "y" "a"). ())(("" "" "ˎ") ("" "" "")))
    ((("p" "y" "i"). ())(("" "" "ˎ") ("" "" "")))
    ((("p" "y" "u"). ())(("" "" "ˎ") ("" "" "")))
    ((("p" "y" "e"). ())(("" "" "ˎ") ("" "" "")))
    ((("p" "y" "o"). ())(("" "" "ˎ") ("" "" "")))

    ((("m" "m"). ("m"))("" "" ""))

    ((("m" "b"). ("b"))("" "" ""))
    ((("m" "p"). ("p"))("" "" ""))

    ((("m" "a"). ())("" "" ""))
    ((("m" "i"). ())("" "" ""))
    ((("m" "u"). ())("" "" ""))
    ((("m" "e"). ())("" "" ""))
    ((("m" "o"). ())("" "" ""))

    ((("m" "y" "a"). ())(("" "" "") ("" "" "")))
    ((("m" "y" "i"). ())(("" "" "") ("" "" "")))
    ((("m" "y" "u"). ())(("" "" "") ("" "" "")))
    ((("m" "y" "e"). ())(("" "" "") ("" "" "")))
    ((("m" "y" "o"). ())(("" "" "") ("" "" "")))

    ((("y" "y"). ("y"))("" "" ""))

    ((("y" "a"). ())("" "" ""))
    ((("y" "u"). ())("" "" ""))
    ((("y" "e"). ())(("" "" "") ("" "" "")))
    ((("y" "o"). ())("" "" ""))

    ((("x" "c" "a"). ())("" "" ""))
    ((("x" "k" "a"). ())("" "" ""))
    ((("x" "k" "e"). ())("" "" ""))

    ((("x" "y" "a"). ())("" "" ""))
    ((("x" "y" "u"). ())("" "" ""))
    ((("x" "y" "o"). ())("" "" ""))

    ((("r" "r"). ("r"))("" "" ""))

    ((("r" "a"). ())("" "" ""))
    ((("r" "i"). ())("" "" ""))
    ((("r" "u"). ())("" "" ""))
    ((("r" "e"). ())("" "" ""))
    ((("r" "o"). ())("" "" ""))

    ((("l" "t" "u"). ())("" "" ""))
    ((("l" "t" "s" "u"). ())("" "" ""))

    ((("l" "y" "a"). ())("" "" ""))
    ((("l" "y" "i"). ())("" "" ""))
    ((("l" "y" "u"). ())("" "" ""))
    ((("l" "y" "e"). ())("" "" ""))
    ((("l" "y" "o"). ())("" "" ""))

    ((("r" "y" "a"). ())(("" "" "") ("" "" "")))
    ((("r" "y" "i"). ())(("" "" "") ("" "" "")))
    ((("r" "y" "u"). ())(("" "" "") ("" "" "")))
    ((("r" "y" "e"). ())(("" "" "") ("" "" "")))
    ((("r" "y" "o"). ())(("" "" "") ("" "" "")))

    ((("w" "w"). ("w"))("" "" ""))

    ((("w" "a"). ())("" "" ""))
    ((("w" "i"). ())(("" "" "") ("" "" "")))
    ((("w" "u"). ())("" "" ""))
    ((("w" "e"). ())(("" "" "") ("" "" "")))
    ((("w" "o"). ())("" "" ""))
    ((("w" "h" "a"). ())(("" "" "") ("" "" "")))
    ((("w" "h" "i"). ())(("" "" "") ("" "" "")))
    ((("w" "h" "u"). ())("" "" ""))
    ((("w" "h" "e"). ())(("" "" "") ("" "" "")))
    ((("w" "h" "o"). ())(("" "" "") ("" "" "")))

    ((("v" "v"). ("v"))("" "" ""))

    ((("v" "a"). ())(("" "" "") ("" "" "")))
    ((("v" "i"). ())(("" "" "") ("" "" "")))
    ((("v" "u"). ())("" "" ""))
    ((("v" "e"). ())(("" "" "") ("" "" "")))
    ((("v" "o"). ())(("" "" "") ("" "" "")))

    ((("v" "y" "a"). ())(("" "" "") ("" "" "")))
    ((("v" "y" "u"). ())(("" "" "") ("" "" "")))
    ((("v" "y" "o"). ())(("" "" "") ("" "" "")))

    ((("z" "k"). ())("" "" ""))
    ((("z" "j"). ())("" "" ""))
    ((("z" "h"). ())("" "" ""))
    ((("z" "l"). ())("" "" ""))
    ((("z" "-"). ())("" "" ""))
    ((("z" "["). ())("" "" ""))
    ((("z" "]"). ())("" "" ""))
    ((("z" ","). ())("" "" ""))
    ((("z" "."). ())("" "" ""))
    ((("z" "/"). ())("" "" ""))
    ))

(define ja-rk-rule-basic-uim ja-rk-rule-basic)

(define ja-rk-rule-rule->table (lambda (rule)
  (map
    (lambda (item)
      ; ((("k" "a")) ("" "" "")) -> ("ka" "" "")
      ; ((("k" "k") "k") ("" "" "")) -> ("kk" "k" "")
      ; ((("k" "y" "a")) (("" "" "") ("" "" ""))) -> ("kya" "" "")
      (list
        ; ((("k" "a")) ("" "" "")) -> "ka"
        (fold-right string-append ""
          (caar item))
        (let ((next-input (cdar item)))
          (or
            (and
              ; ((("k" "a")) ("" "" "")) -> ""
              (null? next-input) "")
            ; ((("k" "k") "k") ("" "" "")) -> "k"
            (car next-input)))
        (let*
          ((output (cadr item))
            (single-output (car output))
            (eucjp->utf8 (lambda (str)
               (and-let* ((ic (iconv-open "UTF-8" "EUC-JP"))
                           (converted-str (iconv-code-conv ic str)))
                 (and ic
                   (iconv-release ic))
                 converted-str))))
          (or
            (and
              ; ((("k" "a")) ("" "" "")) -> ""
              (string? single-output)
              (eucjp->utf8 single-output))
            ; ((("k" "y" "a")) (("" "" "") ("" "" ""))) -> ""
            (eucjp->utf8
              (string-join
                (map first output) "")))))) rule)))

(define ja-rk-rule-table->rule (lambda (table)
  (map
    (lambda (item)
      ; ("ka" "" "") -> ((("k" "a")) ("" "" ""))
      ; ("kk" "k" "") -> ((("k" "k") "k") ("" "" ""))
      ; ("kya" "" "") -> ((("k" "y" "a")) (("" "" "") ("" "" "")))
      (list
        (cons
          (let ((input (car item)))
            (or
              (and
                (string=? input "yen")
                ; ("yen" "" "") -> ("yen")
                '("yen"))
              ; ("ka" "" "") -> ("k" "a")
              (map string
                (string->list input))))
          (let ((next-input (cadr item)))
            (or
              (and
                ; ("ka" "" "") -> none
                (string=? next-input "") '())
              ; ("kk" "k" "") -> "k"
              (cons next-input '()))))
        (let* ((output (caddr item))
               (utf8->eucjp (lambda (str)
                 (and-let* ((ic (iconv-open "EUC-JP" "UTF-8"))
                             (converted-str (iconv-code-conv ic str)))
                   (and ic
                     (iconv-release ic))
                   converted-str)))
               (eucjp-output (utf8->eucjp output))
               (eucjp-output-list (string-to-list eucjp-output)))
          (or
            (and
              (=
                (length eucjp-output-list) 1)
              ; ("ka" "" "") ->  ("" "" "")
              (ja-find-kana-list-from-rule ja-rk-rule eucjp-output))
            ; ("kya" "" "") -> (("" "" "") ("" "" ""))
            (map
              (lambda (char)
                (ja-find-kana-list-from-rule ja-rk-rule char))
                  (reverse eucjp-output-list)))))) table)))

(define-custom-group 'ja-rk-rule
                     (N_ "Japanese Romaji-Kana")
                     (N_ "long description will be here."))

(define-custom-group 'composing-rule
                     (N_ "Composing rule")
                     (N_ "long description will be here."))

(define-custom 'ja-rk-rule-type 'uim
               '(ja-rk-rule composing-rule)
               (list 'choice
	         (list 'uim (N_ "uim") (N_ "uim native"))
	         (list 'custom (N_ "Custom") (N_ "Custom")))
               (N_ "Composing rule type")
               (N_ "long description will be here."))

(define-custom 'ja-rk-rule-table-basic
               (ja-rk-rule-rule->table ja-rk-rule-basic-uim)
               '(ja-rk-rule composing-rule)
               (list 'table
                 (list 'input (N_ "Input") (N_ "Input"))
		 (list 'next-input (N_ "Next input") (N_ "Next input"))
                 (list 'output (N_ "Output") (N_ "Output")))
               (N_ "Custom composing rule")
               (N_ "long description will be here."))

(define-custom 'ja-rk-rule-keep-consonant? #f
               '(ja-rk-rule composing-rule)
               '(boolean)
               (N_ "Keep consonant Romaji not convertible to Kana")
               (N_ "long description will be here."))

(custom-add-hook 'ja-rk-rule-table-basic
                 'custom-set-hooks
                 (lambda ()
                   (and
                     (eq? ja-rk-rule-type 'uim)
                       (set! ja-rk-rule-basic ja-rk-rule-basic-uim))
                   (ja-rk-rule-update)))

(custom-add-hook 'ja-rk-rule-table-basic
                 'custom-activity-hooks
                 (lambda ()
                   (eq? ja-rk-rule-type 'custom)))

(custom-add-hook 'ja-rk-rule-keep-consonant?
                 'custom-set-hooks
                 (lambda ()
                   (ja-rk-rule-keep-consonant-update)))
