/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.packet;

import java.io.IOException;
import java.util.LinkedList;
import net.tinyos.packet.AbstractSource;
import net.tinyos.packet.ByteSource;
import net.tinyos.util.Crc;
import net.tinyos.util.Messenger;

public class Packetizer
extends AbstractSource
implements Runnable {
    static final boolean DEBUG = false;
    static final int SYNC_BYTE = 126;
    static final int ESCAPE_BYTE = 125;
    static final int MTU = 256;
    static final int ACK_TIMEOUT = 1000;
    static final int P_ACK = 67;
    static final int P_PACKET_ACK = 68;
    static final int P_PACKET_NO_ACK = 69;
    static final int P_UNKNOWN = 255;
    private ByteSource io;
    private boolean inSync;
    private byte[] receiveBuffer = new byte[256];
    private int seqNo;
    private Thread reader;
    private LinkedList[] received;
    private static byte[] ackPacket = new byte[0];

    Packetizer(String string, ByteSource byteSource) {
        super(string);
        this.io = byteSource;
        this.inSync = false;
        this.seqNo = 13;
        this.reader = new Thread(this);
        this.received = new LinkedList[256];
        this.received[67] = new LinkedList();
        this.received[69] = new LinkedList();
    }

    public synchronized void open(Messenger messenger) throws IOException {
        super.open(messenger);
        if (!this.reader.isAlive()) {
            this.reader.start();
        }
    }

    protected void openSource() throws IOException {
        this.io.open();
    }

    protected void closeSource() {
        this.io.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readProtocolPacket(int n, long l) throws IOException {
        LinkedList linkedList;
        LinkedList linkedList2 = linkedList = this.received[n];
        synchronized (linkedList2) {
            while (linkedList.isEmpty()) {
                long l2 = System.currentTimeMillis();
                if (l != 0L && l2 >= l) {
                    return null;
                }
                try {
                    linkedList.wait(l != 0L ? l - l2 : 0L);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("interrupted");
                }
            }
            return (byte[])linkedList.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushProtocolPacket(int n, byte[] byArray) {
        LinkedList linkedList = this.received[n];
        if (linkedList != null) {
            LinkedList linkedList2 = linkedList;
            synchronized (linkedList2) {
                linkedList.add(byArray);
                linkedList.notify();
            }
        }
        if (n != 255) {
            try {
                this.writeFramedPacket(255, n, ackPacket, 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.message(this.name + ": ignoring unknown packet type 0x" + Integer.toHexString(n));
        }
    }

    protected byte[] readSourcePacket() throws IOException {
        byte[] byArray;
        while ((byArray = this.readProtocolPacket(69, 0L)).length < 1) {
        }
        return byArray;
    }

    protected boolean writeSourcePacket(byte[] byArray) throws IOException {
        for (int i = 0; i < 25; ++i) {
            this.writeFramedPacket(68, ++this.seqNo, byArray, byArray.length);
            long l = System.currentTimeMillis() + 1000L;
            byte[] byArray2 = this.readProtocolPacket(67, l);
            if (byArray2 == null || byArray2[0] != (byte)this.seqNo) continue;
            return true;
        }
        return false;
    }

    public void run() {
        try {
            while (true) {
                byte[] byArray = this.readFramedPacket();
                int n = byArray[0] & 0xFF;
                int n2 = 1;
                if (n == 68) {
                    this.writeFramedPacket(67, byArray[1], ackPacket, 0);
                    n = 69;
                    n2 = 2;
                }
                int n3 = byArray.length - n2;
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                this.pushProtocolPacket(n, byArray2);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private byte[] readFramedPacket() throws IOException {
        int n = 0;
        boolean bl = false;
        while (true) {
            if (!this.inSync) {
                this.message(this.name + ": resynchronising");
                while (this.io.readByte() != 126) {
                }
                this.inSync = true;
                n = 0;
                bl = false;
            }
            if (n >= 256) {
                this.message(this.name + ": packet too long");
                this.inSync = false;
                continue;
            }
            byte by = this.io.readByte();
            if (bl) {
                if (by == 126) {
                    this.message(this.name + ": unexpected sync byte");
                    this.inSync = false;
                    continue;
                }
                by = (byte)(by ^ 0x20);
                bl = false;
            } else {
                if (by == 125) {
                    bl = true;
                    continue;
                }
                if (by == 126) {
                    if (n < 4) {
                        n = 0;
                        continue;
                    }
                    byte[] byArray = new byte[n - 2];
                    System.arraycopy(this.receiveBuffer, 0, byArray, 0, n - 2);
                    int n2 = this.receiveBuffer[n - 2] & 0xFF | (this.receiveBuffer[n - 1] & 0xFF) << 8;
                    int n3 = Crc.calc(byArray, byArray.length);
                    if (n2 == n3) {
                        return byArray;
                    }
                    this.message(this.name + ": bad packet");
                    n = 0;
                    continue;
                }
            }
            this.receiveBuffer[n++] = by;
        }
    }

    private synchronized void writeFramedPacket(int n, int n2, byte[] byArray, int n3) throws IOException {
        int n4;
        Escaper escaper = new Escaper(n3 + 6);
        escaper.nextByte(n);
        escaper.nextByte(n2);
        for (n4 = 0; n4 < n3; ++n4) {
            escaper.nextByte(byArray[n4]);
        }
        n4 = escaper.crc;
        escaper.nextByte(n4 & 0xFF);
        escaper.nextByte(n4 >> 8);
        escaper.terminate();
        byte[] byArray2 = new byte[escaper.escapePtr];
        System.arraycopy(escaper.escaped, 0, byArray2, 0, escaper.escapePtr);
        this.io.writeBytes(byArray2);
    }

    static class Escaper {
        byte[] escaped;
        int escapePtr;
        int crc;

        Escaper(int n) {
            this.escaped = new byte[2 * n];
            this.escapePtr = 0;
            this.crc = 0;
            this.escaped[this.escapePtr++] = 126;
        }

        private static boolean needsEscape(int n) {
            return n == 126 || n == 125;
        }

        void nextByte(int n) {
            this.crc = Crc.calcByte(this.crc, n &= 0xFF);
            if (Escaper.needsEscape(n)) {
                this.escaped[this.escapePtr++] = 125;
                this.escaped[this.escapePtr++] = (byte)(n ^ 0x20);
            } else {
                this.escaped[this.escapePtr++] = (byte)n;
            }
        }

        void terminate() {
            this.escaped[this.escapePtr++] = 126;
        }
    }
}

