/*   Theorur - A GUI for Ogg/Theora streaming
 *   Copyright (C) 2006-2009 Rafael Diniz <rafael@riseup.net>
 *
 *   This file is part of Theorur.
 *
 *   Theorur is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Theorur is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Theorur.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */

#ifndef __GTK_H__
#include <gtk/gtk.h>
#endif

#ifndef __GLOBAL_H__
#include "global.h"
#endif

#ifdef USE_TOOLTIP
#define TOOLTIP 1
#else 
#define TOOLTIP 0
#endif

#include <stdio.h>
#include <stdlib.h>
#include <libintl.h>

void set_all_tooltips(){
  tooltip = gtk_tooltips_new ();

  if (TOOLTIP) {
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltip), entry_server, gettext("Field that indicates the name of the server.\nEg: orelha2.radiolivre.org"), "");
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltip), entry_port, gettext("Field that indicates the server port that you'll connect.\nEg: 8000"), "");
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltip), entry_mountpoint, gettext("Field that indicates the mount point for the stream.\nEg: tvxiado.ogg\n Remember to put a \".ogg\" at the end of the mountpoint!"), "");
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltip), entry_pass, gettext("Field that indicates the password for the stream, provided by the server administrator."), "");

    gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltip), (GTK_COMBO(combo_v4ldevice))->entry, gettext("If you want to \
stream from a ieee1394 device (dv) this option will have no use (dvgrab will take care of dv capture). \
\nIf you want to stream from a Video4Linux device, set this option to the apropriate v4l device."), "");
  }
  else /* if compiling without tooltip */
    free (tooltip);
    
}
