// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5

// RUN:  %clang_cc1 -triple=aarch64-unknown-linux-gnu -fmath-errno -O3 -emit-llvm -o - -x c++ %s | FileCheck %s -check-prefixes=CHECK,NoNewStructPathTBAA
// RUN:  %clang_cc1 -triple=aarch64-unknown-linux-gnu -fmath-errno -O3 -new-struct-path-tbaa -emit-llvm -o - -x c++ %s | FileCheck %s -check-prefixes=CHECK,NewStructPathTBAA

extern "C" float expf(float);

// Emit int TBAA metadata on FP math libcalls, which is useful for alias analysis

// CHECK-LABEL: define dso_local float @foo(
// CHECK-SAME: ptr nocapture noundef readonly [[NUM:%.*]], float noundef [[R2INV:%.*]], i32 noundef [[N:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[NUM]], i64 40
// CHECK-NEXT:    [[TMP0:%.*]] = load float, ptr [[ARRAYIDX]], align 4, !tbaa [[TBAA2:![0-9]+]]
// CHECK-NEXT:    [[CALL:%.*]] = tail call float @expf(float noundef [[TMP0]]) #[[ATTR2:[0-9]+]], !tbaa [[TBAA6:![0-9]+]]
// CHECK-NEXT:    [[MUL:%.*]] = fmul float [[TMP0]], [[CALL]]
// CHECK-NEXT:    ret float [[MUL]]
//
extern "C" float foo (float num[], float r2inv, int n) {
   const float expm2 =  expf(num[10]);  // Emit TBAA metadata on @expf
   float tmp = expm2 * num[10];
   return tmp;
}
//.
// NoNewStructPathTBAA: [[TBAA2]] = !{[[META3:![0-9]+]], [[META3]], i64 0}
// NoNewStructPathTBAA: [[META3]] = !{!"float", [[META4:![0-9]+]], i64 0}
// NoNewStructPathTBAA: [[META4]] = !{!"omnipotent char", [[META5:![0-9]+]], i64 0}
// NoNewStructPathTBAA: [[META5]] = !{!"Simple C++ TBAA"}
// NoNewStructPathTBAA: [[TBAA6]] = !{[[META7:![0-9]+]], [[META7]], i64 0}
// NoNewStructPathTBAA: [[META7]] = !{!"int", [[META4]], i64 0}
//.
// NewStructPathTBAA: [[TBAA2]] = !{[[META3:![0-9]+]], [[META3]], i64 0, i64 4}
// NewStructPathTBAA: [[META3]] = !{[[META4:![0-9]+]], i64 4, !"float"}
// NewStructPathTBAA: [[META4]] = !{[[META5:![0-9]+]], i64 1, !"omnipotent char"}
// NewStructPathTBAA: [[META5]] = !{!"Simple C++ TBAA"}
// NewStructPathTBAA: [[TBAA6]] = !{[[META7:![0-9]+]], [[META7]], i64 0, i64 4}
// NewStructPathTBAA: [[META7]] = !{[[META4]], i64 4, !"int"}
//.
//// NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
// NewStructPathTBAA: {{.*}}
// NoNewStructPathTBAA: {{.*}}
