# Generated by generate-specs

#################### null_nilkey_nilvalue ####################

shared_examples_for 'null_nilkey_nilvalue' do
  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[0] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = 0
    store[nil] = nil
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[nil] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = 0
    store[0] = nil
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[0] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = nil
    store[nil] = 0
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[nil] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = nil
    store[0] = 0
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, nil, options).should == nil
  end
end

#################### store_nilkey_nilvalue ####################

shared_examples_for 'store_nilkey_nilvalue' do
  it 'writes values to keys that like a Hash' do
    store[0] = 0
    store[0].should == 0
    store.load(0).should == 0
  end

  it 'returns true from key? if a key is available' do
    store[0] = 0
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(0, value).should equal(value)
    store[0].should == 0
    store.load(0).should == 0
  end

  it 'stores values after clear' do
    store[0] = 0
    store[nil] = nil
    store.clear.should equal(store)
    store[0] = 0
    store[0].should == 0
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = 0
    store.delete(0).should == 0
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = 0
    store[0].should == 0
    store[0] = nil
    store[0].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = 0
    store[nil].should == 0
    store.load(nil).should == 0
  end

  it 'returns true from key? if a key is available' do
    store[nil] = 0
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(nil, value).should equal(value)
    store[nil].should == 0
    store.load(nil).should == 0
  end

  it 'stores values after clear' do
    store[nil] = 0
    store[0] = nil
    store.clear.should equal(store)
    store[nil] = 0
    store[nil].should == 0
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = 0
    store.delete(nil).should == 0
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = 0
    store[nil].should == 0
    store[nil] = nil
    store[nil].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[0] = nil
    store[0].should == nil
    store.load(0).should == nil
  end

  it 'returns true from key? if a key is available' do
    store[0] = nil
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(0, value).should equal(value)
    store[0].should == nil
    store.load(0).should == nil
  end

  it 'stores values after clear' do
    store[0] = nil
    store[nil] = 0
    store.clear.should equal(store)
    store[0] = nil
    store[0].should == nil
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = nil
    store.delete(0).should == nil
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = nil
    store[0].should == nil
    store[0] = 0
    store[0].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = nil
    store[nil].should == nil
    store.load(nil).should == nil
  end

  it 'returns true from key? if a key is available' do
    store[nil] = nil
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(nil, value).should equal(value)
    store[nil].should == nil
    store.load(nil).should == nil
  end

  it 'stores values after clear' do
    store[nil] = nil
    store[0] = 0
    store.clear.should equal(store)
    store[nil] = nil
    store[nil].should == nil
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = nil
    store.delete(nil).should == nil
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = nil
    store[nil].should == nil
    store[nil] = 0
    store[nil].should == 0
  end
end

#################### persist_nilkey_nilvalue ####################

shared_examples_for 'persist_nilkey_nilvalue' do
  it 'persists values' do
    store[0] = 0
    store.close
    @store = nil
    store[0].should == 0
  end

  it 'persists values' do
    store[nil] = 0
    store.close
    @store = nil
    store[nil].should == 0
  end

  it 'persists values' do
    store[0] = nil
    store.close
    @store = nil
    store[0].should == nil
  end

  it 'persists values' do
    store[nil] = nil
    store.close
    @store = nil
    store[nil].should == nil
  end
end

#################### null_nilkey_integervalue ####################

shared_examples_for 'null_nilkey_integervalue' do
  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[0] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = 41
    store[nil] = -12
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[nil] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = 41
    store[0] = -12
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[0] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = -12
    store[nil] = 41
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, -12, options).should == -12
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[nil] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = -12
    store[0] = 41
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, -12, options).should == -12
  end
end

#################### store_nilkey_integervalue ####################

shared_examples_for 'store_nilkey_integervalue' do
  it 'writes values to keys that like a Hash' do
    store[0] = 41
    store[0].should == 41
    store.load(0).should == 41
  end

  it 'returns true from key? if a key is available' do
    store[0] = 41
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(0, value).should equal(value)
    store[0].should == 41
    store.load(0).should == 41
  end

  it 'stores values after clear' do
    store[0] = 41
    store[nil] = -12
    store.clear.should equal(store)
    store[0] = 41
    store[0].should == 41
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = 41
    store.delete(0).should == 41
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = 41
    store[0].should == 41
    store[0] = -12
    store[0].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = 41
    store.fetch(0, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = 41
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = 41
    store[nil].should == 41
    store.load(nil).should == 41
  end

  it 'returns true from key? if a key is available' do
    store[nil] = 41
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(nil, value).should equal(value)
    store[nil].should == 41
    store.load(nil).should == 41
  end

  it 'stores values after clear' do
    store[nil] = 41
    store[0] = -12
    store.clear.should equal(store)
    store[nil] = 41
    store[nil].should == 41
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = 41
    store.delete(nil).should == 41
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = 41
    store[nil].should == 41
    store[nil] = -12
    store[nil].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = 41
    store.fetch(nil, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = 41
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = -12
    store[0].should == -12
    store.load(0).should == -12
  end

  it 'returns true from key? if a key is available' do
    store[0] = -12
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(0, value).should equal(value)
    store[0].should == -12
    store.load(0).should == -12
  end

  it 'stores values after clear' do
    store[0] = -12
    store[nil] = 41
    store.clear.should equal(store)
    store[0] = -12
    store[0].should == -12
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = -12
    store.delete(0).should == -12
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = -12
    store[0].should == -12
    store[0] = 41
    store[0].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = -12
    store.fetch(0, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = -12
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = -12
    store[nil].should == -12
    store.load(nil).should == -12
  end

  it 'returns true from key? if a key is available' do
    store[nil] = -12
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(nil, value).should equal(value)
    store[nil].should == -12
    store.load(nil).should == -12
  end

  it 'stores values after clear' do
    store[nil] = -12
    store[0] = 41
    store.clear.should equal(store)
    store[nil] = -12
    store[nil].should == -12
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = -12
    store.delete(nil).should == -12
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = -12
    store[nil].should == -12
    store[nil] = 41
    store[nil].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = -12
    store.fetch(nil, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = -12
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_nilkey_integervalue ####################

shared_examples_for 'persist_nilkey_integervalue' do
  it 'persists values' do
    store[0] = 41
    store.close
    @store = nil
    store[0].should == 41
  end

  it 'persists values' do
    store[nil] = 41
    store.close
    @store = nil
    store[nil].should == 41
  end

  it 'persists values' do
    store[0] = -12
    store.close
    @store = nil
    store[0].should == -12
  end

  it 'persists values' do
    store[nil] = -12
    store.close
    @store = nil
    store[nil].should == -12
  end
end

#################### null_nilkey_booleanvalue ####################

shared_examples_for 'null_nilkey_booleanvalue' do
  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[0] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = true
    store[nil] = false
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[nil] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = true
    store[0] = false
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[0] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = false
    store[nil] = true
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[nil] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = false
    store[0] = true
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, false, options).should == false
  end
end

#################### store_nilkey_booleanvalue ####################

shared_examples_for 'store_nilkey_booleanvalue' do
  it 'writes values to keys that like a Hash' do
    store[0] = true
    store[0].should == true
    store.load(0).should == true
  end

  it 'returns true from key? if a key is available' do
    store[0] = true
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(0, value).should equal(value)
    store[0].should == true
    store.load(0).should == true
  end

  it 'stores values after clear' do
    store[0] = true
    store[nil] = false
    store.clear.should equal(store)
    store[0] = true
    store[0].should == true
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = true
    store.delete(0).should == true
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = true
    store[0].should == true
    store[0] = false
    store[0].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = true
    store.fetch(0, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = true
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = true
    store[nil].should == true
    store.load(nil).should == true
  end

  it 'returns true from key? if a key is available' do
    store[nil] = true
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(nil, value).should equal(value)
    store[nil].should == true
    store.load(nil).should == true
  end

  it 'stores values after clear' do
    store[nil] = true
    store[0] = false
    store.clear.should equal(store)
    store[nil] = true
    store[nil].should == true
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = true
    store.delete(nil).should == true
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = true
    store[nil].should == true
    store[nil] = false
    store[nil].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = true
    store.fetch(nil, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = true
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = false
    store[0].should == false
    store.load(0).should == false
  end

  it 'returns true from key? if a key is available' do
    store[0] = false
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(0, value).should equal(value)
    store[0].should == false
    store.load(0).should == false
  end

  it 'stores values after clear' do
    store[0] = false
    store[nil] = true
    store.clear.should equal(store)
    store[0] = false
    store[0].should == false
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = false
    store.delete(0).should == false
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = false
    store[0].should == false
    store[0] = true
    store[0].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = false
    store.fetch(0, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = false
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = false
    store[nil].should == false
    store.load(nil).should == false
  end

  it 'returns true from key? if a key is available' do
    store[nil] = false
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(nil, value).should equal(value)
    store[nil].should == false
    store.load(nil).should == false
  end

  it 'stores values after clear' do
    store[nil] = false
    store[0] = true
    store.clear.should equal(store)
    store[nil] = false
    store[nil].should == false
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = false
    store.delete(nil).should == false
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = false
    store[nil].should == false
    store[nil] = true
    store[nil].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = false
    store.fetch(nil, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = false
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_nilkey_booleanvalue ####################

shared_examples_for 'persist_nilkey_booleanvalue' do
  it 'persists values' do
    store[0] = true
    store.close
    @store = nil
    store[0].should == true
  end

  it 'persists values' do
    store[nil] = true
    store.close
    @store = nil
    store[nil].should == true
  end

  it 'persists values' do
    store[0] = false
    store.close
    @store = nil
    store[0].should == false
  end

  it 'persists values' do
    store[nil] = false
    store.close
    @store = nil
    store[nil].should == false
  end
end

#################### null_nilkey_stringvalue ####################

shared_examples_for 'null_nilkey_stringvalue' do
  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[0] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = "strval1"
    store[nil] = "strval2"
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[nil] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = "strval1"
    store[0] = "strval2"
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[0] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = "strval2"
    store[nil] = "strval1"
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, "strval2", options).should == "strval2"
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[nil] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = "strval2"
    store[0] = "strval1"
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, "strval2", options).should == "strval2"
  end
end

#################### store_nilkey_stringvalue ####################

shared_examples_for 'store_nilkey_stringvalue' do
  it 'writes values to keys that like a Hash' do
    store[0] = "strval1"
    store[0].should == "strval1"
    store.load(0).should == "strval1"
  end

  it 'returns true from key? if a key is available' do
    store[0] = "strval1"
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(0, value).should equal(value)
    store[0].should == "strval1"
    store.load(0).should == "strval1"
  end

  it 'stores values after clear' do
    store[0] = "strval1"
    store[nil] = "strval2"
    store.clear.should equal(store)
    store[0] = "strval1"
    store[0].should == "strval1"
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = "strval1"
    store.delete(0).should == "strval1"
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = "strval1"
    store[0].should == "strval1"
    store[0] = "strval2"
    store[0].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = "strval1"
    store.fetch(0, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = "strval1"
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = "strval1"
    store[nil].should == "strval1"
    store.load(nil).should == "strval1"
  end

  it 'returns true from key? if a key is available' do
    store[nil] = "strval1"
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(nil, value).should equal(value)
    store[nil].should == "strval1"
    store.load(nil).should == "strval1"
  end

  it 'stores values after clear' do
    store[nil] = "strval1"
    store[0] = "strval2"
    store.clear.should equal(store)
    store[nil] = "strval1"
    store[nil].should == "strval1"
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = "strval1"
    store.delete(nil).should == "strval1"
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = "strval1"
    store[nil].should == "strval1"
    store[nil] = "strval2"
    store[nil].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = "strval1"
    store.fetch(nil, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = "strval1"
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = "strval2"
    store[0].should == "strval2"
    store.load(0).should == "strval2"
  end

  it 'returns true from key? if a key is available' do
    store[0] = "strval2"
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(0, value).should equal(value)
    store[0].should == "strval2"
    store.load(0).should == "strval2"
  end

  it 'stores values after clear' do
    store[0] = "strval2"
    store[nil] = "strval1"
    store.clear.should equal(store)
    store[0] = "strval2"
    store[0].should == "strval2"
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = "strval2"
    store.delete(0).should == "strval2"
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = "strval2"
    store[0].should == "strval2"
    store[0] = "strval1"
    store[0].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = "strval2"
    store.fetch(0, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = "strval2"
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = "strval2"
    store[nil].should == "strval2"
    store.load(nil).should == "strval2"
  end

  it 'returns true from key? if a key is available' do
    store[nil] = "strval2"
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(nil, value).should equal(value)
    store[nil].should == "strval2"
    store.load(nil).should == "strval2"
  end

  it 'stores values after clear' do
    store[nil] = "strval2"
    store[0] = "strval1"
    store.clear.should equal(store)
    store[nil] = "strval2"
    store[nil].should == "strval2"
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = "strval2"
    store.delete(nil).should == "strval2"
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = "strval2"
    store[nil].should == "strval2"
    store[nil] = "strval1"
    store[nil].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = "strval2"
    store.fetch(nil, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = "strval2"
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_nilkey_stringvalue ####################

shared_examples_for 'returndifferent_nilkey_stringvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[0] = value
    store[0].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[nil] = value
    store[nil].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[0] = value
    store[0].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[nil] = value
    store[nil].should_not be_equal(value)
  end
end

#################### returnsame_nilkey_stringvalue ####################

shared_examples_for 'returnsame_nilkey_stringvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[0] = value
    store[0].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[nil] = value
    store[nil].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[0] = value
    store[0].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[nil] = value
    store[nil].should be_equal(value)
  end
end

#################### persist_nilkey_stringvalue ####################

shared_examples_for 'persist_nilkey_stringvalue' do
  it 'persists values' do
    store[0] = "strval1"
    store.close
    @store = nil
    store[0].should == "strval1"
  end

  it 'persists values' do
    store[nil] = "strval1"
    store.close
    @store = nil
    store[nil].should == "strval1"
  end

  it 'persists values' do
    store[0] = "strval2"
    store.close
    @store = nil
    store[0].should == "strval2"
  end

  it 'persists values' do
    store[nil] = "strval2"
    store.close
    @store = nil
    store[nil].should == "strval2"
  end
end

#################### null_nilkey_hashvalue ####################

shared_examples_for 'null_nilkey_hashvalue' do
  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[0] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = {"hashval1"=>["array1", 1]}
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[nil] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[0] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[nil] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### store_nilkey_hashvalue ####################

shared_examples_for 'store_nilkey_hashvalue' do
  it 'writes values to keys that like a Hash' do
    store[0] = {"hashval1"=>["array1", 1]}
    store[0].should == {"hashval1"=>["array1", 1]}
    store.load(0).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from key? if a key is available' do
    store[0] = {"hashval1"=>["array1", 1]}
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(0, value).should equal(value)
    store[0].should == {"hashval1"=>["array1", 1]}
    store.load(0).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[0] = {"hashval1"=>["array1", 1]}
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[0] = {"hashval1"=>["array1", 1]}
    store[0].should == {"hashval1"=>["array1", 1]}
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = {"hashval1"=>["array1", 1]}
    store.delete(0).should == {"hashval1"=>["array1", 1]}
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = {"hashval1"=>["array1", 1]}
    store[0].should == {"hashval1"=>["array1", 1]}
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = {"hashval1"=>["array1", 1]}
    store.fetch(0, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store[nil].should == {"hashval1"=>["array1", 1]}
    store.load(nil).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from key? if a key is available' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(nil, value).should equal(value)
    store[nil].should == {"hashval1"=>["array1", 1]}
    store.load(nil).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[nil] = {"hashval1"=>["array1", 1]}
    store[nil].should == {"hashval1"=>["array1", 1]}
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store.delete(nil).should == {"hashval1"=>["array1", 1]}
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store[nil].should == {"hashval1"=>["array1", 1]}
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store.fetch(nil, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(0).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from key? if a key is available' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(0, value).should equal(value)
    store[0].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(0).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(0).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0] = {"hashval1"=>["array1", 1]}
    store[0].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(0, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(nil).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from key? if a key is available' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(nil, value).should equal(value)
    store[nil].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(nil).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(nil).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil] = {"hashval1"=>["array1", 1]}
    store[nil].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(nil, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_nilkey_hashvalue ####################

shared_examples_for 'returndifferent_nilkey_hashvalue' do
  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[0] = value
    store[0].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[nil] = value
    store[nil].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0] = value
    store[0].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil] = value
    store[nil].should_not be_equal(value)
  end
end

#################### returnsame_nilkey_hashvalue ####################

shared_examples_for 'returnsame_nilkey_hashvalue' do
  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[0] = value
    store[0].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[nil] = value
    store[nil].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0] = value
    store[0].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil] = value
    store[nil].should be_equal(value)
  end
end

#################### persist_nilkey_hashvalue ####################

shared_examples_for 'persist_nilkey_hashvalue' do
  it 'persists values' do
    store[0] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[0].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[nil].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[0].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'persists values' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[nil].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### null_nilkey_objectvalue ####################

shared_examples_for 'null_nilkey_objectvalue' do
  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[0] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = Value.new(:objval1)
    store[nil] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[nil] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = Value.new(:objval1)
    store[0] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[0] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = Value.new(:objval2)
    store[nil] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, Value.new(:objval2), options).should == Value.new(:objval2)
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[nil] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = Value.new(:objval2)
    store[0] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, Value.new(:objval2), options).should == Value.new(:objval2)
  end
end

#################### store_nilkey_objectvalue ####################

shared_examples_for 'store_nilkey_objectvalue' do
  it 'writes values to keys that like a Hash' do
    store[0] = Value.new(:objval1)
    store[0].should == Value.new(:objval1)
    store.load(0).should == Value.new(:objval1)
  end

  it 'returns true from key? if a key is available' do
    store[0] = Value.new(:objval1)
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(0, value).should equal(value)
    store[0].should == Value.new(:objval1)
    store.load(0).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[0] = Value.new(:objval1)
    store[nil] = Value.new(:objval2)
    store.clear.should equal(store)
    store[0] = Value.new(:objval1)
    store[0].should == Value.new(:objval1)
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = Value.new(:objval1)
    store.delete(0).should == Value.new(:objval1)
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = Value.new(:objval1)
    store[0].should == Value.new(:objval1)
    store[0] = Value.new(:objval2)
    store[0].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = Value.new(:objval1)
    store.fetch(0, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = Value.new(:objval1)
    store[nil].should == Value.new(:objval1)
    store.load(nil).should == Value.new(:objval1)
  end

  it 'returns true from key? if a key is available' do
    store[nil] = Value.new(:objval1)
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(nil, value).should equal(value)
    store[nil].should == Value.new(:objval1)
    store.load(nil).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[nil] = Value.new(:objval1)
    store[0] = Value.new(:objval2)
    store.clear.should equal(store)
    store[nil] = Value.new(:objval1)
    store[nil].should == Value.new(:objval1)
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = Value.new(:objval1)
    store.delete(nil).should == Value.new(:objval1)
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = Value.new(:objval1)
    store[nil].should == Value.new(:objval1)
    store[nil] = Value.new(:objval2)
    store[nil].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = Value.new(:objval1)
    store.fetch(nil, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = Value.new(:objval2)
    store[0].should == Value.new(:objval2)
    store.load(0).should == Value.new(:objval2)
  end

  it 'returns true from key? if a key is available' do
    store[0] = Value.new(:objval2)
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(0, value).should equal(value)
    store[0].should == Value.new(:objval2)
    store.load(0).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[0] = Value.new(:objval2)
    store[nil] = Value.new(:objval1)
    store.clear.should equal(store)
    store[0] = Value.new(:objval2)
    store[0].should == Value.new(:objval2)
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = Value.new(:objval2)
    store.delete(0).should == Value.new(:objval2)
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = Value.new(:objval2)
    store[0].should == Value.new(:objval2)
    store[0] = Value.new(:objval1)
    store[0].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = Value.new(:objval2)
    store.fetch(0, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = Value.new(:objval2)
    store[nil].should == Value.new(:objval2)
    store.load(nil).should == Value.new(:objval2)
  end

  it 'returns true from key? if a key is available' do
    store[nil] = Value.new(:objval2)
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(nil, value).should equal(value)
    store[nil].should == Value.new(:objval2)
    store.load(nil).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[nil] = Value.new(:objval2)
    store[0] = Value.new(:objval1)
    store.clear.should equal(store)
    store[nil] = Value.new(:objval2)
    store[nil].should == Value.new(:objval2)
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = Value.new(:objval2)
    store.delete(nil).should == Value.new(:objval2)
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = Value.new(:objval2)
    store[nil].should == Value.new(:objval2)
    store[nil] = Value.new(:objval1)
    store[nil].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = Value.new(:objval2)
    store.fetch(nil, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_nilkey_objectvalue ####################

shared_examples_for 'returndifferent_nilkey_objectvalue' do
  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[0] = value
    store[0].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[nil] = value
    store[nil].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[0] = value
    store[0].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[nil] = value
    store[nil].should_not be_equal(value)
  end
end

#################### returnsame_nilkey_objectvalue ####################

shared_examples_for 'returnsame_nilkey_objectvalue' do
  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[0] = value
    store[0].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[nil] = value
    store[nil].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[0] = value
    store[0].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[nil] = value
    store[nil].should be_equal(value)
  end
end

#################### persist_nilkey_objectvalue ####################

shared_examples_for 'persist_nilkey_objectvalue' do
  it 'persists values' do
    store[0] = Value.new(:objval1)
    store.close
    @store = nil
    store[0].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[nil] = Value.new(:objval1)
    store.close
    @store = nil
    store[nil].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[0] = Value.new(:objval2)
    store.close
    @store = nil
    store[0].should == Value.new(:objval2)
  end

  it 'persists values' do
    store[nil] = Value.new(:objval2)
    store.close
    @store = nil
    store[nil].should == Value.new(:objval2)
  end
end

#################### null_integerkey_nilvalue ####################

shared_examples_for 'null_integerkey_nilvalue' do
  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[-10] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = 0
    store[42] = nil
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[42] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = 0
    store[-10] = nil
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[-10] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = nil
    store[42] = 0
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[42] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = nil
    store[-10] = 0
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, nil, options).should == nil
  end
end

#################### store_integerkey_nilvalue ####################

shared_examples_for 'store_integerkey_nilvalue' do
  it 'writes values to keys that like a Hash' do
    store[-10] = 0
    store[-10].should == 0
    store.load(-10).should == 0
  end

  it 'returns true from key? if a key is available' do
    store[-10] = 0
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(-10, value).should equal(value)
    store[-10].should == 0
    store.load(-10).should == 0
  end

  it 'stores values after clear' do
    store[-10] = 0
    store[42] = nil
    store.clear.should equal(store)
    store[-10] = 0
    store[-10].should == 0
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = 0
    store.delete(-10).should == 0
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = 0
    store[-10].should == 0
    store[-10] = nil
    store[-10].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[42] = 0
    store[42].should == 0
    store.load(42).should == 0
  end

  it 'returns true from key? if a key is available' do
    store[42] = 0
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(42, value).should equal(value)
    store[42].should == 0
    store.load(42).should == 0
  end

  it 'stores values after clear' do
    store[42] = 0
    store[-10] = nil
    store.clear.should equal(store)
    store[42] = 0
    store[42].should == 0
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = 0
    store.delete(42).should == 0
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = 0
    store[42].should == 0
    store[42] = nil
    store[42].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = nil
    store[-10].should == nil
    store.load(-10).should == nil
  end

  it 'returns true from key? if a key is available' do
    store[-10] = nil
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(-10, value).should equal(value)
    store[-10].should == nil
    store.load(-10).should == nil
  end

  it 'stores values after clear' do
    store[-10] = nil
    store[42] = 0
    store.clear.should equal(store)
    store[-10] = nil
    store[-10].should == nil
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = nil
    store.delete(-10).should == nil
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = nil
    store[-10].should == nil
    store[-10] = 0
    store[-10].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store[42] = nil
    store[42].should == nil
    store.load(42).should == nil
  end

  it 'returns true from key? if a key is available' do
    store[42] = nil
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(42, value).should equal(value)
    store[42].should == nil
    store.load(42).should == nil
  end

  it 'stores values after clear' do
    store[42] = nil
    store[-10] = 0
    store.clear.should equal(store)
    store[42] = nil
    store[42].should == nil
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = nil
    store.delete(42).should == nil
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = nil
    store[42].should == nil
    store[42] = 0
    store[42].should == 0
  end
end

#################### persist_integerkey_nilvalue ####################

shared_examples_for 'persist_integerkey_nilvalue' do
  it 'persists values' do
    store[-10] = 0
    store.close
    @store = nil
    store[-10].should == 0
  end

  it 'persists values' do
    store[42] = 0
    store.close
    @store = nil
    store[42].should == 0
  end

  it 'persists values' do
    store[-10] = nil
    store.close
    @store = nil
    store[-10].should == nil
  end

  it 'persists values' do
    store[42] = nil
    store.close
    @store = nil
    store[42].should == nil
  end
end

#################### null_integerkey_integervalue ####################

shared_examples_for 'null_integerkey_integervalue' do
  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[-10] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = 41
    store[42] = -12
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[42] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = 41
    store[-10] = -12
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[-10] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = -12
    store[42] = 41
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, -12, options).should == -12
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[42] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = -12
    store[-10] = 41
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, -12, options).should == -12
  end
end

#################### store_integerkey_integervalue ####################

shared_examples_for 'store_integerkey_integervalue' do
  it 'writes values to keys that like a Hash' do
    store[-10] = 41
    store[-10].should == 41
    store.load(-10).should == 41
  end

  it 'returns true from key? if a key is available' do
    store[-10] = 41
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(-10, value).should equal(value)
    store[-10].should == 41
    store.load(-10).should == 41
  end

  it 'stores values after clear' do
    store[-10] = 41
    store[42] = -12
    store.clear.should equal(store)
    store[-10] = 41
    store[-10].should == 41
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = 41
    store.delete(-10).should == 41
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = 41
    store[-10].should == 41
    store[-10] = -12
    store[-10].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = 41
    store.fetch(-10, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = 41
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = 41
    store[42].should == 41
    store.load(42).should == 41
  end

  it 'returns true from key? if a key is available' do
    store[42] = 41
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(42, value).should equal(value)
    store[42].should == 41
    store.load(42).should == 41
  end

  it 'stores values after clear' do
    store[42] = 41
    store[-10] = -12
    store.clear.should equal(store)
    store[42] = 41
    store[42].should == 41
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = 41
    store.delete(42).should == 41
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = 41
    store[42].should == 41
    store[42] = -12
    store[42].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = 41
    store.fetch(42, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = 41
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = -12
    store[-10].should == -12
    store.load(-10).should == -12
  end

  it 'returns true from key? if a key is available' do
    store[-10] = -12
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(-10, value).should equal(value)
    store[-10].should == -12
    store.load(-10).should == -12
  end

  it 'stores values after clear' do
    store[-10] = -12
    store[42] = 41
    store.clear.should equal(store)
    store[-10] = -12
    store[-10].should == -12
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = -12
    store.delete(-10).should == -12
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = -12
    store[-10].should == -12
    store[-10] = 41
    store[-10].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = -12
    store.fetch(-10, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = -12
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = -12
    store[42].should == -12
    store.load(42).should == -12
  end

  it 'returns true from key? if a key is available' do
    store[42] = -12
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(42, value).should equal(value)
    store[42].should == -12
    store.load(42).should == -12
  end

  it 'stores values after clear' do
    store[42] = -12
    store[-10] = 41
    store.clear.should equal(store)
    store[42] = -12
    store[42].should == -12
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = -12
    store.delete(42).should == -12
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = -12
    store[42].should == -12
    store[42] = 41
    store[42].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = -12
    store.fetch(42, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = -12
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_integerkey_integervalue ####################

shared_examples_for 'persist_integerkey_integervalue' do
  it 'persists values' do
    store[-10] = 41
    store.close
    @store = nil
    store[-10].should == 41
  end

  it 'persists values' do
    store[42] = 41
    store.close
    @store = nil
    store[42].should == 41
  end

  it 'persists values' do
    store[-10] = -12
    store.close
    @store = nil
    store[-10].should == -12
  end

  it 'persists values' do
    store[42] = -12
    store.close
    @store = nil
    store[42].should == -12
  end
end

#################### null_integerkey_booleanvalue ####################

shared_examples_for 'null_integerkey_booleanvalue' do
  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[-10] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = true
    store[42] = false
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[42] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = true
    store[-10] = false
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[-10] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = false
    store[42] = true
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[42] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = false
    store[-10] = true
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, false, options).should == false
  end
end

#################### store_integerkey_booleanvalue ####################

shared_examples_for 'store_integerkey_booleanvalue' do
  it 'writes values to keys that like a Hash' do
    store[-10] = true
    store[-10].should == true
    store.load(-10).should == true
  end

  it 'returns true from key? if a key is available' do
    store[-10] = true
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(-10, value).should equal(value)
    store[-10].should == true
    store.load(-10).should == true
  end

  it 'stores values after clear' do
    store[-10] = true
    store[42] = false
    store.clear.should equal(store)
    store[-10] = true
    store[-10].should == true
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = true
    store.delete(-10).should == true
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = true
    store[-10].should == true
    store[-10] = false
    store[-10].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = true
    store.fetch(-10, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = true
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = true
    store[42].should == true
    store.load(42).should == true
  end

  it 'returns true from key? if a key is available' do
    store[42] = true
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(42, value).should equal(value)
    store[42].should == true
    store.load(42).should == true
  end

  it 'stores values after clear' do
    store[42] = true
    store[-10] = false
    store.clear.should equal(store)
    store[42] = true
    store[42].should == true
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = true
    store.delete(42).should == true
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = true
    store[42].should == true
    store[42] = false
    store[42].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = true
    store.fetch(42, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = true
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = false
    store[-10].should == false
    store.load(-10).should == false
  end

  it 'returns true from key? if a key is available' do
    store[-10] = false
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(-10, value).should equal(value)
    store[-10].should == false
    store.load(-10).should == false
  end

  it 'stores values after clear' do
    store[-10] = false
    store[42] = true
    store.clear.should equal(store)
    store[-10] = false
    store[-10].should == false
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = false
    store.delete(-10).should == false
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = false
    store[-10].should == false
    store[-10] = true
    store[-10].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = false
    store.fetch(-10, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = false
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = false
    store[42].should == false
    store.load(42).should == false
  end

  it 'returns true from key? if a key is available' do
    store[42] = false
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(42, value).should equal(value)
    store[42].should == false
    store.load(42).should == false
  end

  it 'stores values after clear' do
    store[42] = false
    store[-10] = true
    store.clear.should equal(store)
    store[42] = false
    store[42].should == false
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = false
    store.delete(42).should == false
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = false
    store[42].should == false
    store[42] = true
    store[42].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = false
    store.fetch(42, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = false
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_integerkey_booleanvalue ####################

shared_examples_for 'persist_integerkey_booleanvalue' do
  it 'persists values' do
    store[-10] = true
    store.close
    @store = nil
    store[-10].should == true
  end

  it 'persists values' do
    store[42] = true
    store.close
    @store = nil
    store[42].should == true
  end

  it 'persists values' do
    store[-10] = false
    store.close
    @store = nil
    store[-10].should == false
  end

  it 'persists values' do
    store[42] = false
    store.close
    @store = nil
    store[42].should == false
  end
end

#################### null_integerkey_stringvalue ####################

shared_examples_for 'null_integerkey_stringvalue' do
  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[-10] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = "strval1"
    store[42] = "strval2"
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[42] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = "strval1"
    store[-10] = "strval2"
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[-10] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = "strval2"
    store[42] = "strval1"
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, "strval2", options).should == "strval2"
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[42] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = "strval2"
    store[-10] = "strval1"
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, "strval2", options).should == "strval2"
  end
end

#################### store_integerkey_stringvalue ####################

shared_examples_for 'store_integerkey_stringvalue' do
  it 'writes values to keys that like a Hash' do
    store[-10] = "strval1"
    store[-10].should == "strval1"
    store.load(-10).should == "strval1"
  end

  it 'returns true from key? if a key is available' do
    store[-10] = "strval1"
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(-10, value).should equal(value)
    store[-10].should == "strval1"
    store.load(-10).should == "strval1"
  end

  it 'stores values after clear' do
    store[-10] = "strval1"
    store[42] = "strval2"
    store.clear.should equal(store)
    store[-10] = "strval1"
    store[-10].should == "strval1"
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = "strval1"
    store.delete(-10).should == "strval1"
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = "strval1"
    store[-10].should == "strval1"
    store[-10] = "strval2"
    store[-10].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = "strval1"
    store.fetch(-10, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = "strval1"
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = "strval1"
    store[42].should == "strval1"
    store.load(42).should == "strval1"
  end

  it 'returns true from key? if a key is available' do
    store[42] = "strval1"
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(42, value).should equal(value)
    store[42].should == "strval1"
    store.load(42).should == "strval1"
  end

  it 'stores values after clear' do
    store[42] = "strval1"
    store[-10] = "strval2"
    store.clear.should equal(store)
    store[42] = "strval1"
    store[42].should == "strval1"
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = "strval1"
    store.delete(42).should == "strval1"
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = "strval1"
    store[42].should == "strval1"
    store[42] = "strval2"
    store[42].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = "strval1"
    store.fetch(42, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = "strval1"
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = "strval2"
    store[-10].should == "strval2"
    store.load(-10).should == "strval2"
  end

  it 'returns true from key? if a key is available' do
    store[-10] = "strval2"
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(-10, value).should equal(value)
    store[-10].should == "strval2"
    store.load(-10).should == "strval2"
  end

  it 'stores values after clear' do
    store[-10] = "strval2"
    store[42] = "strval1"
    store.clear.should equal(store)
    store[-10] = "strval2"
    store[-10].should == "strval2"
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = "strval2"
    store.delete(-10).should == "strval2"
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = "strval2"
    store[-10].should == "strval2"
    store[-10] = "strval1"
    store[-10].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = "strval2"
    store.fetch(-10, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = "strval2"
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = "strval2"
    store[42].should == "strval2"
    store.load(42).should == "strval2"
  end

  it 'returns true from key? if a key is available' do
    store[42] = "strval2"
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(42, value).should equal(value)
    store[42].should == "strval2"
    store.load(42).should == "strval2"
  end

  it 'stores values after clear' do
    store[42] = "strval2"
    store[-10] = "strval1"
    store.clear.should equal(store)
    store[42] = "strval2"
    store[42].should == "strval2"
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = "strval2"
    store.delete(42).should == "strval2"
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = "strval2"
    store[42].should == "strval2"
    store[42] = "strval1"
    store[42].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = "strval2"
    store.fetch(42, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = "strval2"
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_integerkey_stringvalue ####################

shared_examples_for 'returndifferent_integerkey_stringvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[-10] = value
    store[-10].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[42] = value
    store[42].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[-10] = value
    store[-10].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[42] = value
    store[42].should_not be_equal(value)
  end
end

#################### returnsame_integerkey_stringvalue ####################

shared_examples_for 'returnsame_integerkey_stringvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[-10] = value
    store[-10].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[42] = value
    store[42].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[-10] = value
    store[-10].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[42] = value
    store[42].should be_equal(value)
  end
end

#################### persist_integerkey_stringvalue ####################

shared_examples_for 'persist_integerkey_stringvalue' do
  it 'persists values' do
    store[-10] = "strval1"
    store.close
    @store = nil
    store[-10].should == "strval1"
  end

  it 'persists values' do
    store[42] = "strval1"
    store.close
    @store = nil
    store[42].should == "strval1"
  end

  it 'persists values' do
    store[-10] = "strval2"
    store.close
    @store = nil
    store[-10].should == "strval2"
  end

  it 'persists values' do
    store[42] = "strval2"
    store.close
    @store = nil
    store[42].should == "strval2"
  end
end

#################### null_integerkey_hashvalue ####################

shared_examples_for 'null_integerkey_hashvalue' do
  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[-10] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[42] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = {"hashval1"=>["array1", 1]}
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[-10] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[42] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### store_integerkey_hashvalue ####################

shared_examples_for 'store_integerkey_hashvalue' do
  it 'writes values to keys that like a Hash' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store[-10].should == {"hashval1"=>["array1", 1]}
    store.load(-10).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from key? if a key is available' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(-10, value).should equal(value)
    store[-10].should == {"hashval1"=>["array1", 1]}
    store.load(-10).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[-10] = {"hashval1"=>["array1", 1]}
    store[-10].should == {"hashval1"=>["array1", 1]}
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store.delete(-10).should == {"hashval1"=>["array1", 1]}
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store[-10].should == {"hashval1"=>["array1", 1]}
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store.fetch(-10, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = {"hashval1"=>["array1", 1]}
    store[42].should == {"hashval1"=>["array1", 1]}
    store.load(42).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from key? if a key is available' do
    store[42] = {"hashval1"=>["array1", 1]}
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(42, value).should equal(value)
    store[42].should == {"hashval1"=>["array1", 1]}
    store.load(42).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[42] = {"hashval1"=>["array1", 1]}
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[42] = {"hashval1"=>["array1", 1]}
    store[42].should == {"hashval1"=>["array1", 1]}
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = {"hashval1"=>["array1", 1]}
    store.delete(42).should == {"hashval1"=>["array1", 1]}
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = {"hashval1"=>["array1", 1]}
    store[42].should == {"hashval1"=>["array1", 1]}
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = {"hashval1"=>["array1", 1]}
    store.fetch(42, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(-10).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from key? if a key is available' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(-10, value).should equal(value)
    store[-10].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(-10).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(-10).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10] = {"hashval1"=>["array1", 1]}
    store[-10].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(-10, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(42).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from key? if a key is available' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(42, value).should equal(value)
    store[42].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(42).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(42).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42] = {"hashval1"=>["array1", 1]}
    store[42].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(42, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_integerkey_hashvalue ####################

shared_examples_for 'returndifferent_integerkey_hashvalue' do
  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[-10] = value
    store[-10].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[42] = value
    store[42].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10] = value
    store[-10].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42] = value
    store[42].should_not be_equal(value)
  end
end

#################### returnsame_integerkey_hashvalue ####################

shared_examples_for 'returnsame_integerkey_hashvalue' do
  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[-10] = value
    store[-10].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[42] = value
    store[42].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10] = value
    store[-10].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42] = value
    store[42].should be_equal(value)
  end
end

#################### persist_integerkey_hashvalue ####################

shared_examples_for 'persist_integerkey_hashvalue' do
  it 'persists values' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[-10].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[42] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[42].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[-10].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'persists values' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[42].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### null_integerkey_objectvalue ####################

shared_examples_for 'null_integerkey_objectvalue' do
  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[-10] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = Value.new(:objval1)
    store[42] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[42] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = Value.new(:objval1)
    store[-10] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[-10] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = Value.new(:objval2)
    store[42] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, Value.new(:objval2), options).should == Value.new(:objval2)
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[42] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = Value.new(:objval2)
    store[-10] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, Value.new(:objval2), options).should == Value.new(:objval2)
  end
end

#################### store_integerkey_objectvalue ####################

shared_examples_for 'store_integerkey_objectvalue' do
  it 'writes values to keys that like a Hash' do
    store[-10] = Value.new(:objval1)
    store[-10].should == Value.new(:objval1)
    store.load(-10).should == Value.new(:objval1)
  end

  it 'returns true from key? if a key is available' do
    store[-10] = Value.new(:objval1)
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(-10, value).should equal(value)
    store[-10].should == Value.new(:objval1)
    store.load(-10).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[-10] = Value.new(:objval1)
    store[42] = Value.new(:objval2)
    store.clear.should equal(store)
    store[-10] = Value.new(:objval1)
    store[-10].should == Value.new(:objval1)
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = Value.new(:objval1)
    store.delete(-10).should == Value.new(:objval1)
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = Value.new(:objval1)
    store[-10].should == Value.new(:objval1)
    store[-10] = Value.new(:objval2)
    store[-10].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = Value.new(:objval1)
    store.fetch(-10, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = Value.new(:objval1)
    store[42].should == Value.new(:objval1)
    store.load(42).should == Value.new(:objval1)
  end

  it 'returns true from key? if a key is available' do
    store[42] = Value.new(:objval1)
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(42, value).should equal(value)
    store[42].should == Value.new(:objval1)
    store.load(42).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[42] = Value.new(:objval1)
    store[-10] = Value.new(:objval2)
    store.clear.should equal(store)
    store[42] = Value.new(:objval1)
    store[42].should == Value.new(:objval1)
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = Value.new(:objval1)
    store.delete(42).should == Value.new(:objval1)
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = Value.new(:objval1)
    store[42].should == Value.new(:objval1)
    store[42] = Value.new(:objval2)
    store[42].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = Value.new(:objval1)
    store.fetch(42, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = Value.new(:objval2)
    store[-10].should == Value.new(:objval2)
    store.load(-10).should == Value.new(:objval2)
  end

  it 'returns true from key? if a key is available' do
    store[-10] = Value.new(:objval2)
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(-10, value).should equal(value)
    store[-10].should == Value.new(:objval2)
    store.load(-10).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[-10] = Value.new(:objval2)
    store[42] = Value.new(:objval1)
    store.clear.should equal(store)
    store[-10] = Value.new(:objval2)
    store[-10].should == Value.new(:objval2)
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = Value.new(:objval2)
    store.delete(-10).should == Value.new(:objval2)
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = Value.new(:objval2)
    store[-10].should == Value.new(:objval2)
    store[-10] = Value.new(:objval1)
    store[-10].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = Value.new(:objval2)
    store.fetch(-10, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = Value.new(:objval2)
    store[42].should == Value.new(:objval2)
    store.load(42).should == Value.new(:objval2)
  end

  it 'returns true from key? if a key is available' do
    store[42] = Value.new(:objval2)
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(42, value).should equal(value)
    store[42].should == Value.new(:objval2)
    store.load(42).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[42] = Value.new(:objval2)
    store[-10] = Value.new(:objval1)
    store.clear.should equal(store)
    store[42] = Value.new(:objval2)
    store[42].should == Value.new(:objval2)
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = Value.new(:objval2)
    store.delete(42).should == Value.new(:objval2)
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = Value.new(:objval2)
    store[42].should == Value.new(:objval2)
    store[42] = Value.new(:objval1)
    store[42].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = Value.new(:objval2)
    store.fetch(42, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_integerkey_objectvalue ####################

shared_examples_for 'returndifferent_integerkey_objectvalue' do
  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[-10] = value
    store[-10].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[42] = value
    store[42].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[-10] = value
    store[-10].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[42] = value
    store[42].should_not be_equal(value)
  end
end

#################### returnsame_integerkey_objectvalue ####################

shared_examples_for 'returnsame_integerkey_objectvalue' do
  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[-10] = value
    store[-10].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[42] = value
    store[42].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[-10] = value
    store[-10].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[42] = value
    store[42].should be_equal(value)
  end
end

#################### persist_integerkey_objectvalue ####################

shared_examples_for 'persist_integerkey_objectvalue' do
  it 'persists values' do
    store[-10] = Value.new(:objval1)
    store.close
    @store = nil
    store[-10].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[42] = Value.new(:objval1)
    store.close
    @store = nil
    store[42].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[-10] = Value.new(:objval2)
    store.close
    @store = nil
    store[-10].should == Value.new(:objval2)
  end

  it 'persists values' do
    store[42] = Value.new(:objval2)
    store.close
    @store = nil
    store[42].should == Value.new(:objval2)
  end
end

#################### null_booleankey_nilvalue ####################

shared_examples_for 'null_booleankey_nilvalue' do
  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[true] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = 0
    store[false] = nil
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[false] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = 0
    store[true] = nil
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[true] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = nil
    store[false] = 0
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[false] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = nil
    store[true] = 0
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, nil, options).should == nil
  end
end

#################### store_booleankey_nilvalue ####################

shared_examples_for 'store_booleankey_nilvalue' do
  it 'writes values to keys that like a Hash' do
    store[true] = 0
    store[true].should == 0
    store.load(true).should == 0
  end

  it 'returns true from key? if a key is available' do
    store[true] = 0
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(true, value).should equal(value)
    store[true].should == 0
    store.load(true).should == 0
  end

  it 'stores values after clear' do
    store[true] = 0
    store[false] = nil
    store.clear.should equal(store)
    store[true] = 0
    store[true].should == 0
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = 0
    store.delete(true).should == 0
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = 0
    store[true].should == 0
    store[true] = nil
    store[true].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[false] = 0
    store[false].should == 0
    store.load(false).should == 0
  end

  it 'returns true from key? if a key is available' do
    store[false] = 0
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(false, value).should equal(value)
    store[false].should == 0
    store.load(false).should == 0
  end

  it 'stores values after clear' do
    store[false] = 0
    store[true] = nil
    store.clear.should equal(store)
    store[false] = 0
    store[false].should == 0
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = 0
    store.delete(false).should == 0
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = 0
    store[false].should == 0
    store[false] = nil
    store[false].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[true] = nil
    store[true].should == nil
    store.load(true).should == nil
  end

  it 'returns true from key? if a key is available' do
    store[true] = nil
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(true, value).should equal(value)
    store[true].should == nil
    store.load(true).should == nil
  end

  it 'stores values after clear' do
    store[true] = nil
    store[false] = 0
    store.clear.should equal(store)
    store[true] = nil
    store[true].should == nil
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = nil
    store.delete(true).should == nil
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = nil
    store[true].should == nil
    store[true] = 0
    store[true].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store[false] = nil
    store[false].should == nil
    store.load(false).should == nil
  end

  it 'returns true from key? if a key is available' do
    store[false] = nil
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(false, value).should equal(value)
    store[false].should == nil
    store.load(false).should == nil
  end

  it 'stores values after clear' do
    store[false] = nil
    store[true] = 0
    store.clear.should equal(store)
    store[false] = nil
    store[false].should == nil
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = nil
    store.delete(false).should == nil
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = nil
    store[false].should == nil
    store[false] = 0
    store[false].should == 0
  end
end

#################### persist_booleankey_nilvalue ####################

shared_examples_for 'persist_booleankey_nilvalue' do
  it 'persists values' do
    store[true] = 0
    store.close
    @store = nil
    store[true].should == 0
  end

  it 'persists values' do
    store[false] = 0
    store.close
    @store = nil
    store[false].should == 0
  end

  it 'persists values' do
    store[true] = nil
    store.close
    @store = nil
    store[true].should == nil
  end

  it 'persists values' do
    store[false] = nil
    store.close
    @store = nil
    store[false].should == nil
  end
end

#################### null_booleankey_integervalue ####################

shared_examples_for 'null_booleankey_integervalue' do
  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[true] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = 41
    store[false] = -12
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[false] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = 41
    store[true] = -12
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[true] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = -12
    store[false] = 41
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, -12, options).should == -12
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[false] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = -12
    store[true] = 41
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, -12, options).should == -12
  end
end

#################### store_booleankey_integervalue ####################

shared_examples_for 'store_booleankey_integervalue' do
  it 'writes values to keys that like a Hash' do
    store[true] = 41
    store[true].should == 41
    store.load(true).should == 41
  end

  it 'returns true from key? if a key is available' do
    store[true] = 41
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(true, value).should equal(value)
    store[true].should == 41
    store.load(true).should == 41
  end

  it 'stores values after clear' do
    store[true] = 41
    store[false] = -12
    store.clear.should equal(store)
    store[true] = 41
    store[true].should == 41
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = 41
    store.delete(true).should == 41
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = 41
    store[true].should == 41
    store[true] = -12
    store[true].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = 41
    store.fetch(true, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = 41
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = 41
    store[false].should == 41
    store.load(false).should == 41
  end

  it 'returns true from key? if a key is available' do
    store[false] = 41
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(false, value).should equal(value)
    store[false].should == 41
    store.load(false).should == 41
  end

  it 'stores values after clear' do
    store[false] = 41
    store[true] = -12
    store.clear.should equal(store)
    store[false] = 41
    store[false].should == 41
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = 41
    store.delete(false).should == 41
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = 41
    store[false].should == 41
    store[false] = -12
    store[false].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = 41
    store.fetch(false, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = 41
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[true] = -12
    store[true].should == -12
    store.load(true).should == -12
  end

  it 'returns true from key? if a key is available' do
    store[true] = -12
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(true, value).should equal(value)
    store[true].should == -12
    store.load(true).should == -12
  end

  it 'stores values after clear' do
    store[true] = -12
    store[false] = 41
    store.clear.should equal(store)
    store[true] = -12
    store[true].should == -12
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = -12
    store.delete(true).should == -12
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = -12
    store[true].should == -12
    store[true] = 41
    store[true].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = -12
    store.fetch(true, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = -12
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = -12
    store[false].should == -12
    store.load(false).should == -12
  end

  it 'returns true from key? if a key is available' do
    store[false] = -12
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(false, value).should equal(value)
    store[false].should == -12
    store.load(false).should == -12
  end

  it 'stores values after clear' do
    store[false] = -12
    store[true] = 41
    store.clear.should equal(store)
    store[false] = -12
    store[false].should == -12
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = -12
    store.delete(false).should == -12
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = -12
    store[false].should == -12
    store[false] = 41
    store[false].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = -12
    store.fetch(false, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = -12
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_booleankey_integervalue ####################

shared_examples_for 'persist_booleankey_integervalue' do
  it 'persists values' do
    store[true] = 41
    store.close
    @store = nil
    store[true].should == 41
  end

  it 'persists values' do
    store[false] = 41
    store.close
    @store = nil
    store[false].should == 41
  end

  it 'persists values' do
    store[true] = -12
    store.close
    @store = nil
    store[true].should == -12
  end

  it 'persists values' do
    store[false] = -12
    store.close
    @store = nil
    store[false].should == -12
  end
end

#################### null_booleankey_booleanvalue ####################

shared_examples_for 'null_booleankey_booleanvalue' do
  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[true] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = true
    store[false] = false
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[false] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = true
    store[true] = false
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[true] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = false
    store[false] = true
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[false] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = false
    store[true] = true
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, false, options).should == false
  end
end

#################### store_booleankey_booleanvalue ####################

shared_examples_for 'store_booleankey_booleanvalue' do
  it 'writes values to keys that like a Hash' do
    store[true] = true
    store[true].should == true
    store.load(true).should == true
  end

  it 'returns true from key? if a key is available' do
    store[true] = true
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(true, value).should equal(value)
    store[true].should == true
    store.load(true).should == true
  end

  it 'stores values after clear' do
    store[true] = true
    store[false] = false
    store.clear.should equal(store)
    store[true] = true
    store[true].should == true
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = true
    store.delete(true).should == true
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = true
    store[true].should == true
    store[true] = false
    store[true].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = true
    store.fetch(true, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = true
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = true
    store[false].should == true
    store.load(false).should == true
  end

  it 'returns true from key? if a key is available' do
    store[false] = true
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(false, value).should equal(value)
    store[false].should == true
    store.load(false).should == true
  end

  it 'stores values after clear' do
    store[false] = true
    store[true] = false
    store.clear.should equal(store)
    store[false] = true
    store[false].should == true
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = true
    store.delete(false).should == true
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = true
    store[false].should == true
    store[false] = false
    store[false].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = true
    store.fetch(false, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = true
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[true] = false
    store[true].should == false
    store.load(true).should == false
  end

  it 'returns true from key? if a key is available' do
    store[true] = false
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(true, value).should equal(value)
    store[true].should == false
    store.load(true).should == false
  end

  it 'stores values after clear' do
    store[true] = false
    store[false] = true
    store.clear.should equal(store)
    store[true] = false
    store[true].should == false
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = false
    store.delete(true).should == false
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = false
    store[true].should == false
    store[true] = true
    store[true].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = false
    store.fetch(true, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = false
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = false
    store[false].should == false
    store.load(false).should == false
  end

  it 'returns true from key? if a key is available' do
    store[false] = false
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(false, value).should equal(value)
    store[false].should == false
    store.load(false).should == false
  end

  it 'stores values after clear' do
    store[false] = false
    store[true] = true
    store.clear.should equal(store)
    store[false] = false
    store[false].should == false
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = false
    store.delete(false).should == false
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = false
    store[false].should == false
    store[false] = true
    store[false].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = false
    store.fetch(false, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = false
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_booleankey_booleanvalue ####################

shared_examples_for 'persist_booleankey_booleanvalue' do
  it 'persists values' do
    store[true] = true
    store.close
    @store = nil
    store[true].should == true
  end

  it 'persists values' do
    store[false] = true
    store.close
    @store = nil
    store[false].should == true
  end

  it 'persists values' do
    store[true] = false
    store.close
    @store = nil
    store[true].should == false
  end

  it 'persists values' do
    store[false] = false
    store.close
    @store = nil
    store[false].should == false
  end
end

#################### null_booleankey_stringvalue ####################

shared_examples_for 'null_booleankey_stringvalue' do
  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[true] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = "strval1"
    store[false] = "strval2"
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[false] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = "strval1"
    store[true] = "strval2"
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[true] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = "strval2"
    store[false] = "strval1"
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, "strval2", options).should == "strval2"
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[false] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = "strval2"
    store[true] = "strval1"
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, "strval2", options).should == "strval2"
  end
end

#################### store_booleankey_stringvalue ####################

shared_examples_for 'store_booleankey_stringvalue' do
  it 'writes values to keys that like a Hash' do
    store[true] = "strval1"
    store[true].should == "strval1"
    store.load(true).should == "strval1"
  end

  it 'returns true from key? if a key is available' do
    store[true] = "strval1"
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(true, value).should equal(value)
    store[true].should == "strval1"
    store.load(true).should == "strval1"
  end

  it 'stores values after clear' do
    store[true] = "strval1"
    store[false] = "strval2"
    store.clear.should equal(store)
    store[true] = "strval1"
    store[true].should == "strval1"
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = "strval1"
    store.delete(true).should == "strval1"
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = "strval1"
    store[true].should == "strval1"
    store[true] = "strval2"
    store[true].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = "strval1"
    store.fetch(true, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = "strval1"
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = "strval1"
    store[false].should == "strval1"
    store.load(false).should == "strval1"
  end

  it 'returns true from key? if a key is available' do
    store[false] = "strval1"
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(false, value).should equal(value)
    store[false].should == "strval1"
    store.load(false).should == "strval1"
  end

  it 'stores values after clear' do
    store[false] = "strval1"
    store[true] = "strval2"
    store.clear.should equal(store)
    store[false] = "strval1"
    store[false].should == "strval1"
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = "strval1"
    store.delete(false).should == "strval1"
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = "strval1"
    store[false].should == "strval1"
    store[false] = "strval2"
    store[false].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = "strval1"
    store.fetch(false, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = "strval1"
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[true] = "strval2"
    store[true].should == "strval2"
    store.load(true).should == "strval2"
  end

  it 'returns true from key? if a key is available' do
    store[true] = "strval2"
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(true, value).should equal(value)
    store[true].should == "strval2"
    store.load(true).should == "strval2"
  end

  it 'stores values after clear' do
    store[true] = "strval2"
    store[false] = "strval1"
    store.clear.should equal(store)
    store[true] = "strval2"
    store[true].should == "strval2"
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = "strval2"
    store.delete(true).should == "strval2"
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = "strval2"
    store[true].should == "strval2"
    store[true] = "strval1"
    store[true].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = "strval2"
    store.fetch(true, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = "strval2"
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = "strval2"
    store[false].should == "strval2"
    store.load(false).should == "strval2"
  end

  it 'returns true from key? if a key is available' do
    store[false] = "strval2"
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(false, value).should equal(value)
    store[false].should == "strval2"
    store.load(false).should == "strval2"
  end

  it 'stores values after clear' do
    store[false] = "strval2"
    store[true] = "strval1"
    store.clear.should equal(store)
    store[false] = "strval2"
    store[false].should == "strval2"
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = "strval2"
    store.delete(false).should == "strval2"
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = "strval2"
    store[false].should == "strval2"
    store[false] = "strval1"
    store[false].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = "strval2"
    store.fetch(false, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = "strval2"
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_booleankey_stringvalue ####################

shared_examples_for 'returndifferent_booleankey_stringvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[true] = value
    store[true].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[false] = value
    store[false].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[true] = value
    store[true].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[false] = value
    store[false].should_not be_equal(value)
  end
end

#################### returnsame_booleankey_stringvalue ####################

shared_examples_for 'returnsame_booleankey_stringvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[true] = value
    store[true].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[false] = value
    store[false].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[true] = value
    store[true].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[false] = value
    store[false].should be_equal(value)
  end
end

#################### persist_booleankey_stringvalue ####################

shared_examples_for 'persist_booleankey_stringvalue' do
  it 'persists values' do
    store[true] = "strval1"
    store.close
    @store = nil
    store[true].should == "strval1"
  end

  it 'persists values' do
    store[false] = "strval1"
    store.close
    @store = nil
    store[false].should == "strval1"
  end

  it 'persists values' do
    store[true] = "strval2"
    store.close
    @store = nil
    store[true].should == "strval2"
  end

  it 'persists values' do
    store[false] = "strval2"
    store.close
    @store = nil
    store[false].should == "strval2"
  end
end

#################### null_booleankey_hashvalue ####################

shared_examples_for 'null_booleankey_hashvalue' do
  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[true] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = {"hashval1"=>["array1", 1]}
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[false] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = {"hashval1"=>["array1", 1]}
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[true] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[false] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### store_booleankey_hashvalue ####################

shared_examples_for 'store_booleankey_hashvalue' do
  it 'writes values to keys that like a Hash' do
    store[true] = {"hashval1"=>["array1", 1]}
    store[true].should == {"hashval1"=>["array1", 1]}
    store.load(true).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from key? if a key is available' do
    store[true] = {"hashval1"=>["array1", 1]}
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(true, value).should equal(value)
    store[true].should == {"hashval1"=>["array1", 1]}
    store.load(true).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[true] = {"hashval1"=>["array1", 1]}
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[true] = {"hashval1"=>["array1", 1]}
    store[true].should == {"hashval1"=>["array1", 1]}
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = {"hashval1"=>["array1", 1]}
    store.delete(true).should == {"hashval1"=>["array1", 1]}
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = {"hashval1"=>["array1", 1]}
    store[true].should == {"hashval1"=>["array1", 1]}
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = {"hashval1"=>["array1", 1]}
    store.fetch(true, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = {"hashval1"=>["array1", 1]}
    store[false].should == {"hashval1"=>["array1", 1]}
    store.load(false).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from key? if a key is available' do
    store[false] = {"hashval1"=>["array1", 1]}
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(false, value).should equal(value)
    store[false].should == {"hashval1"=>["array1", 1]}
    store.load(false).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[false] = {"hashval1"=>["array1", 1]}
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[false] = {"hashval1"=>["array1", 1]}
    store[false].should == {"hashval1"=>["array1", 1]}
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = {"hashval1"=>["array1", 1]}
    store.delete(false).should == {"hashval1"=>["array1", 1]}
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = {"hashval1"=>["array1", 1]}
    store[false].should == {"hashval1"=>["array1", 1]}
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = {"hashval1"=>["array1", 1]}
    store.fetch(false, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(true).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from key? if a key is available' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(true, value).should equal(value)
    store[true].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(true).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(true).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true] = {"hashval1"=>["array1", 1]}
    store[true].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(true, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(false).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from key? if a key is available' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(false, value).should equal(value)
    store[false].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(false).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(false).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false] = {"hashval1"=>["array1", 1]}
    store[false].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(false, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_booleankey_hashvalue ####################

shared_examples_for 'returndifferent_booleankey_hashvalue' do
  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[true] = value
    store[true].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[false] = value
    store[false].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true] = value
    store[true].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false] = value
    store[false].should_not be_equal(value)
  end
end

#################### returnsame_booleankey_hashvalue ####################

shared_examples_for 'returnsame_booleankey_hashvalue' do
  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[true] = value
    store[true].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[false] = value
    store[false].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true] = value
    store[true].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false] = value
    store[false].should be_equal(value)
  end
end

#################### persist_booleankey_hashvalue ####################

shared_examples_for 'persist_booleankey_hashvalue' do
  it 'persists values' do
    store[true] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[true].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[false] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[false].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[true].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'persists values' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[false].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### null_booleankey_objectvalue ####################

shared_examples_for 'null_booleankey_objectvalue' do
  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[true] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = Value.new(:objval1)
    store[false] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[false] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = Value.new(:objval1)
    store[true] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[true] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = Value.new(:objval2)
    store[false] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, Value.new(:objval2), options).should == Value.new(:objval2)
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[false] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = Value.new(:objval2)
    store[true] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, Value.new(:objval2), options).should == Value.new(:objval2)
  end
end

#################### store_booleankey_objectvalue ####################

shared_examples_for 'store_booleankey_objectvalue' do
  it 'writes values to keys that like a Hash' do
    store[true] = Value.new(:objval1)
    store[true].should == Value.new(:objval1)
    store.load(true).should == Value.new(:objval1)
  end

  it 'returns true from key? if a key is available' do
    store[true] = Value.new(:objval1)
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(true, value).should equal(value)
    store[true].should == Value.new(:objval1)
    store.load(true).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[true] = Value.new(:objval1)
    store[false] = Value.new(:objval2)
    store.clear.should equal(store)
    store[true] = Value.new(:objval1)
    store[true].should == Value.new(:objval1)
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = Value.new(:objval1)
    store.delete(true).should == Value.new(:objval1)
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = Value.new(:objval1)
    store[true].should == Value.new(:objval1)
    store[true] = Value.new(:objval2)
    store[true].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = Value.new(:objval1)
    store.fetch(true, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = Value.new(:objval1)
    store[false].should == Value.new(:objval1)
    store.load(false).should == Value.new(:objval1)
  end

  it 'returns true from key? if a key is available' do
    store[false] = Value.new(:objval1)
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(false, value).should equal(value)
    store[false].should == Value.new(:objval1)
    store.load(false).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[false] = Value.new(:objval1)
    store[true] = Value.new(:objval2)
    store.clear.should equal(store)
    store[false] = Value.new(:objval1)
    store[false].should == Value.new(:objval1)
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = Value.new(:objval1)
    store.delete(false).should == Value.new(:objval1)
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = Value.new(:objval1)
    store[false].should == Value.new(:objval1)
    store[false] = Value.new(:objval2)
    store[false].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = Value.new(:objval1)
    store.fetch(false, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[true] = Value.new(:objval2)
    store[true].should == Value.new(:objval2)
    store.load(true).should == Value.new(:objval2)
  end

  it 'returns true from key? if a key is available' do
    store[true] = Value.new(:objval2)
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(true, value).should equal(value)
    store[true].should == Value.new(:objval2)
    store.load(true).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[true] = Value.new(:objval2)
    store[false] = Value.new(:objval1)
    store.clear.should equal(store)
    store[true] = Value.new(:objval2)
    store[true].should == Value.new(:objval2)
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = Value.new(:objval2)
    store.delete(true).should == Value.new(:objval2)
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = Value.new(:objval2)
    store[true].should == Value.new(:objval2)
    store[true] = Value.new(:objval1)
    store[true].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = Value.new(:objval2)
    store.fetch(true, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = Value.new(:objval2)
    store[false].should == Value.new(:objval2)
    store.load(false).should == Value.new(:objval2)
  end

  it 'returns true from key? if a key is available' do
    store[false] = Value.new(:objval2)
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(false, value).should equal(value)
    store[false].should == Value.new(:objval2)
    store.load(false).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[false] = Value.new(:objval2)
    store[true] = Value.new(:objval1)
    store.clear.should equal(store)
    store[false] = Value.new(:objval2)
    store[false].should == Value.new(:objval2)
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = Value.new(:objval2)
    store.delete(false).should == Value.new(:objval2)
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = Value.new(:objval2)
    store[false].should == Value.new(:objval2)
    store[false] = Value.new(:objval1)
    store[false].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = Value.new(:objval2)
    store.fetch(false, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_booleankey_objectvalue ####################

shared_examples_for 'returndifferent_booleankey_objectvalue' do
  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[true] = value
    store[true].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[false] = value
    store[false].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[true] = value
    store[true].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[false] = value
    store[false].should_not be_equal(value)
  end
end

#################### returnsame_booleankey_objectvalue ####################

shared_examples_for 'returnsame_booleankey_objectvalue' do
  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[true] = value
    store[true].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[false] = value
    store[false].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[true] = value
    store[true].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[false] = value
    store[false].should be_equal(value)
  end
end

#################### persist_booleankey_objectvalue ####################

shared_examples_for 'persist_booleankey_objectvalue' do
  it 'persists values' do
    store[true] = Value.new(:objval1)
    store.close
    @store = nil
    store[true].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[false] = Value.new(:objval1)
    store.close
    @store = nil
    store[false].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[true] = Value.new(:objval2)
    store.close
    @store = nil
    store[true].should == Value.new(:objval2)
  end

  it 'persists values' do
    store[false] = Value.new(:objval2)
    store.close
    @store = nil
    store[false].should == Value.new(:objval2)
  end
end

#################### null_stringkey_nilvalue ####################

shared_examples_for 'null_stringkey_nilvalue' do
  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = 0
    store["strkey2"] = nil
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = 0
    store["strkey1"] = nil
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = nil
    store["strkey2"] = 0
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = nil
    store["strkey1"] = 0
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", nil, options).should == nil
  end
end

#################### store_stringkey_nilvalue ####################

shared_examples_for 'store_stringkey_nilvalue' do
  it 'writes values to keys that like a Hash' do
    store["strkey1"] = 0
    store["strkey1"].should == 0
    store.load("strkey1").should == 0
  end

  it 'returns true from key? if a key is available' do
    store["strkey1"] = 0
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == 0
    store.load("strkey1").should == 0
  end

  it 'stores values after clear' do
    store["strkey1"] = 0
    store["strkey2"] = nil
    store.clear.should equal(store)
    store["strkey1"] = 0
    store["strkey1"].should == 0
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = 0
    store.delete("strkey1").should == 0
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = 0
    store["strkey1"].should == 0
    store["strkey1"] = nil
    store["strkey1"].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = 0
    store["strkey2"].should == 0
    store.load("strkey2").should == 0
  end

  it 'returns true from key? if a key is available' do
    store["strkey2"] = 0
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == 0
    store.load("strkey2").should == 0
  end

  it 'stores values after clear' do
    store["strkey2"] = 0
    store["strkey1"] = nil
    store.clear.should equal(store)
    store["strkey2"] = 0
    store["strkey2"].should == 0
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = 0
    store.delete("strkey2").should == 0
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = 0
    store["strkey2"].should == 0
    store["strkey2"] = nil
    store["strkey2"].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = nil
    store["strkey1"].should == nil
    store.load("strkey1").should == nil
  end

  it 'returns true from key? if a key is available' do
    store["strkey1"] = nil
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == nil
    store.load("strkey1").should == nil
  end

  it 'stores values after clear' do
    store["strkey1"] = nil
    store["strkey2"] = 0
    store.clear.should equal(store)
    store["strkey1"] = nil
    store["strkey1"].should == nil
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = nil
    store.delete("strkey1").should == nil
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = nil
    store["strkey1"].should == nil
    store["strkey1"] = 0
    store["strkey1"].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = nil
    store["strkey2"].should == nil
    store.load("strkey2").should == nil
  end

  it 'returns true from key? if a key is available' do
    store["strkey2"] = nil
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == nil
    store.load("strkey2").should == nil
  end

  it 'stores values after clear' do
    store["strkey2"] = nil
    store["strkey1"] = 0
    store.clear.should equal(store)
    store["strkey2"] = nil
    store["strkey2"].should == nil
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = nil
    store.delete("strkey2").should == nil
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = nil
    store["strkey2"].should == nil
    store["strkey2"] = 0
    store["strkey2"].should == 0
  end
end

#################### persist_stringkey_nilvalue ####################

shared_examples_for 'persist_stringkey_nilvalue' do
  it 'persists values' do
    store["strkey1"] = 0
    store.close
    @store = nil
    store["strkey1"].should == 0
  end

  it 'persists values' do
    store["strkey2"] = 0
    store.close
    @store = nil
    store["strkey2"].should == 0
  end

  it 'persists values' do
    store["strkey1"] = nil
    store.close
    @store = nil
    store["strkey1"].should == nil
  end

  it 'persists values' do
    store["strkey2"] = nil
    store.close
    @store = nil
    store["strkey2"].should == nil
  end
end

#################### null_stringkey_integervalue ####################

shared_examples_for 'null_stringkey_integervalue' do
  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = 41
    store["strkey2"] = -12
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = 41
    store["strkey1"] = -12
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = -12
    store["strkey2"] = 41
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", -12, options).should == -12
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = -12
    store["strkey1"] = 41
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", -12, options).should == -12
  end
end

#################### store_stringkey_integervalue ####################

shared_examples_for 'store_stringkey_integervalue' do
  it 'writes values to keys that like a Hash' do
    store["strkey1"] = 41
    store["strkey1"].should == 41
    store.load("strkey1").should == 41
  end

  it 'returns true from key? if a key is available' do
    store["strkey1"] = 41
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == 41
    store.load("strkey1").should == 41
  end

  it 'stores values after clear' do
    store["strkey1"] = 41
    store["strkey2"] = -12
    store.clear.should equal(store)
    store["strkey1"] = 41
    store["strkey1"].should == 41
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = 41
    store.delete("strkey1").should == 41
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = 41
    store["strkey1"].should == 41
    store["strkey1"] = -12
    store["strkey1"].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = 41
    store.fetch("strkey1", -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = 41
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = 41
    store["strkey2"].should == 41
    store.load("strkey2").should == 41
  end

  it 'returns true from key? if a key is available' do
    store["strkey2"] = 41
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == 41
    store.load("strkey2").should == 41
  end

  it 'stores values after clear' do
    store["strkey2"] = 41
    store["strkey1"] = -12
    store.clear.should equal(store)
    store["strkey2"] = 41
    store["strkey2"].should == 41
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = 41
    store.delete("strkey2").should == 41
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = 41
    store["strkey2"].should == 41
    store["strkey2"] = -12
    store["strkey2"].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = 41
    store.fetch("strkey2", -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = 41
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = -12
    store["strkey1"].should == -12
    store.load("strkey1").should == -12
  end

  it 'returns true from key? if a key is available' do
    store["strkey1"] = -12
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == -12
    store.load("strkey1").should == -12
  end

  it 'stores values after clear' do
    store["strkey1"] = -12
    store["strkey2"] = 41
    store.clear.should equal(store)
    store["strkey1"] = -12
    store["strkey1"].should == -12
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = -12
    store.delete("strkey1").should == -12
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = -12
    store["strkey1"].should == -12
    store["strkey1"] = 41
    store["strkey1"].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = -12
    store.fetch("strkey1", 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = -12
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = -12
    store["strkey2"].should == -12
    store.load("strkey2").should == -12
  end

  it 'returns true from key? if a key is available' do
    store["strkey2"] = -12
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == -12
    store.load("strkey2").should == -12
  end

  it 'stores values after clear' do
    store["strkey2"] = -12
    store["strkey1"] = 41
    store.clear.should equal(store)
    store["strkey2"] = -12
    store["strkey2"].should == -12
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = -12
    store.delete("strkey2").should == -12
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = -12
    store["strkey2"].should == -12
    store["strkey2"] = 41
    store["strkey2"].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = -12
    store.fetch("strkey2", 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = -12
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_stringkey_integervalue ####################

shared_examples_for 'persist_stringkey_integervalue' do
  it 'persists values' do
    store["strkey1"] = 41
    store.close
    @store = nil
    store["strkey1"].should == 41
  end

  it 'persists values' do
    store["strkey2"] = 41
    store.close
    @store = nil
    store["strkey2"].should == 41
  end

  it 'persists values' do
    store["strkey1"] = -12
    store.close
    @store = nil
    store["strkey1"].should == -12
  end

  it 'persists values' do
    store["strkey2"] = -12
    store.close
    @store = nil
    store["strkey2"].should == -12
  end
end

#################### null_stringkey_booleanvalue ####################

shared_examples_for 'null_stringkey_booleanvalue' do
  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = true
    store["strkey2"] = false
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = true
    store["strkey1"] = false
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = false
    store["strkey2"] = true
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = false
    store["strkey1"] = true
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", false, options).should == false
  end
end

#################### store_stringkey_booleanvalue ####################

shared_examples_for 'store_stringkey_booleanvalue' do
  it 'writes values to keys that like a Hash' do
    store["strkey1"] = true
    store["strkey1"].should == true
    store.load("strkey1").should == true
  end

  it 'returns true from key? if a key is available' do
    store["strkey1"] = true
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == true
    store.load("strkey1").should == true
  end

  it 'stores values after clear' do
    store["strkey1"] = true
    store["strkey2"] = false
    store.clear.should equal(store)
    store["strkey1"] = true
    store["strkey1"].should == true
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = true
    store.delete("strkey1").should == true
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = true
    store["strkey1"].should == true
    store["strkey1"] = false
    store["strkey1"].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = true
    store.fetch("strkey1", false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = true
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = true
    store["strkey2"].should == true
    store.load("strkey2").should == true
  end

  it 'returns true from key? if a key is available' do
    store["strkey2"] = true
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == true
    store.load("strkey2").should == true
  end

  it 'stores values after clear' do
    store["strkey2"] = true
    store["strkey1"] = false
    store.clear.should equal(store)
    store["strkey2"] = true
    store["strkey2"].should == true
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = true
    store.delete("strkey2").should == true
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = true
    store["strkey2"].should == true
    store["strkey2"] = false
    store["strkey2"].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = true
    store.fetch("strkey2", false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = true
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = false
    store["strkey1"].should == false
    store.load("strkey1").should == false
  end

  it 'returns true from key? if a key is available' do
    store["strkey1"] = false
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == false
    store.load("strkey1").should == false
  end

  it 'stores values after clear' do
    store["strkey1"] = false
    store["strkey2"] = true
    store.clear.should equal(store)
    store["strkey1"] = false
    store["strkey1"].should == false
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = false
    store.delete("strkey1").should == false
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = false
    store["strkey1"].should == false
    store["strkey1"] = true
    store["strkey1"].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = false
    store.fetch("strkey1", true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = false
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = false
    store["strkey2"].should == false
    store.load("strkey2").should == false
  end

  it 'returns true from key? if a key is available' do
    store["strkey2"] = false
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == false
    store.load("strkey2").should == false
  end

  it 'stores values after clear' do
    store["strkey2"] = false
    store["strkey1"] = true
    store.clear.should equal(store)
    store["strkey2"] = false
    store["strkey2"].should == false
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = false
    store.delete("strkey2").should == false
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = false
    store["strkey2"].should == false
    store["strkey2"] = true
    store["strkey2"].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = false
    store.fetch("strkey2", true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = false
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_stringkey_booleanvalue ####################

shared_examples_for 'persist_stringkey_booleanvalue' do
  it 'persists values' do
    store["strkey1"] = true
    store.close
    @store = nil
    store["strkey1"].should == true
  end

  it 'persists values' do
    store["strkey2"] = true
    store.close
    @store = nil
    store["strkey2"].should == true
  end

  it 'persists values' do
    store["strkey1"] = false
    store.close
    @store = nil
    store["strkey1"].should == false
  end

  it 'persists values' do
    store["strkey2"] = false
    store.close
    @store = nil
    store["strkey2"].should == false
  end
end

#################### null_stringkey_stringvalue ####################

shared_examples_for 'null_stringkey_stringvalue' do
  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = "strval1"
    store["strkey2"] = "strval2"
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = "strval1"
    store["strkey1"] = "strval2"
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = "strval2"
    store["strkey2"] = "strval1"
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", "strval2", options).should == "strval2"
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = "strval2"
    store["strkey1"] = "strval1"
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", "strval2", options).should == "strval2"
  end
end

#################### store_stringkey_stringvalue ####################

shared_examples_for 'store_stringkey_stringvalue' do
  it 'writes values to keys that like a Hash' do
    store["strkey1"] = "strval1"
    store["strkey1"].should == "strval1"
    store.load("strkey1").should == "strval1"
  end

  it 'returns true from key? if a key is available' do
    store["strkey1"] = "strval1"
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == "strval1"
    store.load("strkey1").should == "strval1"
  end

  it 'stores values after clear' do
    store["strkey1"] = "strval1"
    store["strkey2"] = "strval2"
    store.clear.should equal(store)
    store["strkey1"] = "strval1"
    store["strkey1"].should == "strval1"
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = "strval1"
    store.delete("strkey1").should == "strval1"
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = "strval1"
    store["strkey1"].should == "strval1"
    store["strkey1"] = "strval2"
    store["strkey1"].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = "strval1"
    store.fetch("strkey1", "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = "strval1"
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = "strval1"
    store["strkey2"].should == "strval1"
    store.load("strkey2").should == "strval1"
  end

  it 'returns true from key? if a key is available' do
    store["strkey2"] = "strval1"
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == "strval1"
    store.load("strkey2").should == "strval1"
  end

  it 'stores values after clear' do
    store["strkey2"] = "strval1"
    store["strkey1"] = "strval2"
    store.clear.should equal(store)
    store["strkey2"] = "strval1"
    store["strkey2"].should == "strval1"
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = "strval1"
    store.delete("strkey2").should == "strval1"
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = "strval1"
    store["strkey2"].should == "strval1"
    store["strkey2"] = "strval2"
    store["strkey2"].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = "strval1"
    store.fetch("strkey2", "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = "strval1"
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = "strval2"
    store["strkey1"].should == "strval2"
    store.load("strkey1").should == "strval2"
  end

  it 'returns true from key? if a key is available' do
    store["strkey1"] = "strval2"
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == "strval2"
    store.load("strkey1").should == "strval2"
  end

  it 'stores values after clear' do
    store["strkey1"] = "strval2"
    store["strkey2"] = "strval1"
    store.clear.should equal(store)
    store["strkey1"] = "strval2"
    store["strkey1"].should == "strval2"
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = "strval2"
    store.delete("strkey1").should == "strval2"
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = "strval2"
    store["strkey1"].should == "strval2"
    store["strkey1"] = "strval1"
    store["strkey1"].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = "strval2"
    store.fetch("strkey1", "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = "strval2"
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = "strval2"
    store["strkey2"].should == "strval2"
    store.load("strkey2").should == "strval2"
  end

  it 'returns true from key? if a key is available' do
    store["strkey2"] = "strval2"
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == "strval2"
    store.load("strkey2").should == "strval2"
  end

  it 'stores values after clear' do
    store["strkey2"] = "strval2"
    store["strkey1"] = "strval1"
    store.clear.should equal(store)
    store["strkey2"] = "strval2"
    store["strkey2"].should == "strval2"
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = "strval2"
    store.delete("strkey2").should == "strval2"
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = "strval2"
    store["strkey2"].should == "strval2"
    store["strkey2"] = "strval1"
    store["strkey2"].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = "strval2"
    store.fetch("strkey2", "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = "strval2"
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_stringkey_stringvalue ####################

shared_examples_for 'returndifferent_stringkey_stringvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store["strkey1"] = value
    store["strkey1"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store["strkey2"] = value
    store["strkey2"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store["strkey1"] = value
    store["strkey1"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store["strkey2"] = value
    store["strkey2"].should_not be_equal(value)
  end
end

#################### returnsame_stringkey_stringvalue ####################

shared_examples_for 'returnsame_stringkey_stringvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store["strkey1"] = value
    store["strkey1"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store["strkey2"] = value
    store["strkey2"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store["strkey1"] = value
    store["strkey1"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store["strkey2"] = value
    store["strkey2"].should be_equal(value)
  end
end

#################### persist_stringkey_stringvalue ####################

shared_examples_for 'persist_stringkey_stringvalue' do
  it 'persists values' do
    store["strkey1"] = "strval1"
    store.close
    @store = nil
    store["strkey1"].should == "strval1"
  end

  it 'persists values' do
    store["strkey2"] = "strval1"
    store.close
    @store = nil
    store["strkey2"].should == "strval1"
  end

  it 'persists values' do
    store["strkey1"] = "strval2"
    store.close
    @store = nil
    store["strkey1"].should == "strval2"
  end

  it 'persists values' do
    store["strkey2"] = "strval2"
    store.close
    @store = nil
    store["strkey2"].should == "strval2"
  end
end

#################### null_stringkey_hashvalue ####################

shared_examples_for 'null_stringkey_hashvalue' do
  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### store_stringkey_hashvalue ####################

shared_examples_for 'store_stringkey_hashvalue' do
  it 'writes values to keys that like a Hash' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store["strkey1"].should == {"hashval1"=>["array1", 1]}
    store.load("strkey1").should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from key? if a key is available' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == {"hashval1"=>["array1", 1]}
    store.load("strkey1").should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store["strkey1"].should == {"hashval1"=>["array1", 1]}
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store.delete("strkey1").should == {"hashval1"=>["array1", 1]}
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store["strkey1"].should == {"hashval1"=>["array1", 1]}
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store.fetch("strkey1", {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store["strkey2"].should == {"hashval1"=>["array1", 1]}
    store.load("strkey2").should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from key? if a key is available' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == {"hashval1"=>["array1", 1]}
    store.load("strkey2").should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store["strkey2"].should == {"hashval1"=>["array1", 1]}
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store.delete("strkey2").should == {"hashval1"=>["array1", 1]}
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store["strkey2"].should == {"hashval1"=>["array1", 1]}
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store.fetch("strkey2", {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load("strkey1").should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from key? if a key is available' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load("strkey1").should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete("strkey1").should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store["strkey1"].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch("strkey1", {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load("strkey2").should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from key? if a key is available' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load("strkey2").should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete("strkey2").should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store["strkey2"].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch("strkey2", {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_stringkey_hashvalue ####################

shared_examples_for 'returndifferent_stringkey_hashvalue' do
  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store["strkey1"] = value
    store["strkey1"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store["strkey2"] = value
    store["strkey2"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"] = value
    store["strkey1"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"] = value
    store["strkey2"].should_not be_equal(value)
  end
end

#################### returnsame_stringkey_hashvalue ####################

shared_examples_for 'returnsame_stringkey_hashvalue' do
  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store["strkey1"] = value
    store["strkey1"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store["strkey2"] = value
    store["strkey2"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"] = value
    store["strkey1"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"] = value
    store["strkey2"].should be_equal(value)
  end
end

#################### persist_stringkey_hashvalue ####################

shared_examples_for 'persist_stringkey_hashvalue' do
  it 'persists values' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store["strkey1"].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store["strkey2"].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store["strkey1"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'persists values' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store["strkey2"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### null_stringkey_objectvalue ####################

shared_examples_for 'null_stringkey_objectvalue' do
  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = Value.new(:objval1)
    store["strkey2"] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = Value.new(:objval1)
    store["strkey1"] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = Value.new(:objval2)
    store["strkey2"] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", Value.new(:objval2), options).should == Value.new(:objval2)
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = Value.new(:objval2)
    store["strkey1"] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", Value.new(:objval2), options).should == Value.new(:objval2)
  end
end

#################### store_stringkey_objectvalue ####################

shared_examples_for 'store_stringkey_objectvalue' do
  it 'writes values to keys that like a Hash' do
    store["strkey1"] = Value.new(:objval1)
    store["strkey1"].should == Value.new(:objval1)
    store.load("strkey1").should == Value.new(:objval1)
  end

  it 'returns true from key? if a key is available' do
    store["strkey1"] = Value.new(:objval1)
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == Value.new(:objval1)
    store.load("strkey1").should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store["strkey1"] = Value.new(:objval1)
    store["strkey2"] = Value.new(:objval2)
    store.clear.should equal(store)
    store["strkey1"] = Value.new(:objval1)
    store["strkey1"].should == Value.new(:objval1)
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = Value.new(:objval1)
    store.delete("strkey1").should == Value.new(:objval1)
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = Value.new(:objval1)
    store["strkey1"].should == Value.new(:objval1)
    store["strkey1"] = Value.new(:objval2)
    store["strkey1"].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = Value.new(:objval1)
    store.fetch("strkey1", Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = Value.new(:objval1)
    store["strkey2"].should == Value.new(:objval1)
    store.load("strkey2").should == Value.new(:objval1)
  end

  it 'returns true from key? if a key is available' do
    store["strkey2"] = Value.new(:objval1)
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == Value.new(:objval1)
    store.load("strkey2").should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store["strkey2"] = Value.new(:objval1)
    store["strkey1"] = Value.new(:objval2)
    store.clear.should equal(store)
    store["strkey2"] = Value.new(:objval1)
    store["strkey2"].should == Value.new(:objval1)
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = Value.new(:objval1)
    store.delete("strkey2").should == Value.new(:objval1)
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = Value.new(:objval1)
    store["strkey2"].should == Value.new(:objval1)
    store["strkey2"] = Value.new(:objval2)
    store["strkey2"].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = Value.new(:objval1)
    store.fetch("strkey2", Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = Value.new(:objval2)
    store["strkey1"].should == Value.new(:objval2)
    store.load("strkey1").should == Value.new(:objval2)
  end

  it 'returns true from key? if a key is available' do
    store["strkey1"] = Value.new(:objval2)
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == Value.new(:objval2)
    store.load("strkey1").should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store["strkey1"] = Value.new(:objval2)
    store["strkey2"] = Value.new(:objval1)
    store.clear.should equal(store)
    store["strkey1"] = Value.new(:objval2)
    store["strkey1"].should == Value.new(:objval2)
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = Value.new(:objval2)
    store.delete("strkey1").should == Value.new(:objval2)
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = Value.new(:objval2)
    store["strkey1"].should == Value.new(:objval2)
    store["strkey1"] = Value.new(:objval1)
    store["strkey1"].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = Value.new(:objval2)
    store.fetch("strkey1", Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = Value.new(:objval2)
    store["strkey2"].should == Value.new(:objval2)
    store.load("strkey2").should == Value.new(:objval2)
  end

  it 'returns true from key? if a key is available' do
    store["strkey2"] = Value.new(:objval2)
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == Value.new(:objval2)
    store.load("strkey2").should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store["strkey2"] = Value.new(:objval2)
    store["strkey1"] = Value.new(:objval1)
    store.clear.should equal(store)
    store["strkey2"] = Value.new(:objval2)
    store["strkey2"].should == Value.new(:objval2)
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = Value.new(:objval2)
    store.delete("strkey2").should == Value.new(:objval2)
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = Value.new(:objval2)
    store["strkey2"].should == Value.new(:objval2)
    store["strkey2"] = Value.new(:objval1)
    store["strkey2"].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = Value.new(:objval2)
    store.fetch("strkey2", Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_stringkey_objectvalue ####################

shared_examples_for 'returndifferent_stringkey_objectvalue' do
  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store["strkey1"] = value
    store["strkey1"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store["strkey2"] = value
    store["strkey2"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store["strkey1"] = value
    store["strkey1"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store["strkey2"] = value
    store["strkey2"].should_not be_equal(value)
  end
end

#################### returnsame_stringkey_objectvalue ####################

shared_examples_for 'returnsame_stringkey_objectvalue' do
  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store["strkey1"] = value
    store["strkey1"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store["strkey2"] = value
    store["strkey2"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store["strkey1"] = value
    store["strkey1"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store["strkey2"] = value
    store["strkey2"].should be_equal(value)
  end
end

#################### persist_stringkey_objectvalue ####################

shared_examples_for 'persist_stringkey_objectvalue' do
  it 'persists values' do
    store["strkey1"] = Value.new(:objval1)
    store.close
    @store = nil
    store["strkey1"].should == Value.new(:objval1)
  end

  it 'persists values' do
    store["strkey2"] = Value.new(:objval1)
    store.close
    @store = nil
    store["strkey2"].should == Value.new(:objval1)
  end

  it 'persists values' do
    store["strkey1"] = Value.new(:objval2)
    store.close
    @store = nil
    store["strkey1"].should == Value.new(:objval2)
  end

  it 'persists values' do
    store["strkey2"] = Value.new(:objval2)
    store.close
    @store = nil
    store["strkey2"].should == Value.new(:objval2)
  end
end

#################### null_objectkey_nilvalue ####################

shared_examples_for 'null_objectkey_nilvalue' do
  it 'reads from keys like a Hash' do
    store[Value.new(:objkey1)].should be_nil
    store.load(Value.new(:objkey1)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[Value.new(:objkey1)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey1)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey1)] = 0
    store[Value.new(:objkey2)] = nil
    store.clear.should equal(store)
    store.key?(Value.new(:objkey1)).should be_false
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey1), 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey1)
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey1), options).should be_false
    store.load(Value.new(:objkey1), options).should be_nil
    store.fetch(Value.new(:objkey1), 42, options).should == 42
    store.fetch(Value.new(:objkey1), options) { 42 }.should == 42
    store.delete(Value.new(:objkey1), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey1), 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey2)].should be_nil
    store.load(Value.new(:objkey2)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[Value.new(:objkey2)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey2)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey2)] = 0
    store[Value.new(:objkey1)] = nil
    store.clear.should equal(store)
    store.key?(Value.new(:objkey2)).should be_false
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey2), 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey2)
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey2), options).should be_false
    store.load(Value.new(:objkey2), options).should be_nil
    store.fetch(Value.new(:objkey2), 42, options).should == 42
    store.fetch(Value.new(:objkey2), options) { 42 }.should == 42
    store.delete(Value.new(:objkey2), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey2), 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey1)].should be_nil
    store.load(Value.new(:objkey1)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[Value.new(:objkey1)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey1)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey1)] = nil
    store[Value.new(:objkey2)] = 0
    store.clear.should equal(store)
    store.key?(Value.new(:objkey1)).should be_false
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey1), nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey1)
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey1), options).should be_false
    store.load(Value.new(:objkey1), options).should be_nil
    store.fetch(Value.new(:objkey1), 42, options).should == 42
    store.fetch(Value.new(:objkey1), options) { 42 }.should == 42
    store.delete(Value.new(:objkey1), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey1), nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey2)].should be_nil
    store.load(Value.new(:objkey2)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[Value.new(:objkey2)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey2)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey2)] = nil
    store[Value.new(:objkey1)] = 0
    store.clear.should equal(store)
    store.key?(Value.new(:objkey2)).should be_false
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey2), nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey2)
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey2), options).should be_false
    store.load(Value.new(:objkey2), options).should be_nil
    store.fetch(Value.new(:objkey2), 42, options).should == 42
    store.fetch(Value.new(:objkey2), options) { 42 }.should == 42
    store.delete(Value.new(:objkey2), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey2), nil, options).should == nil
  end
end

#################### store_objectkey_nilvalue ####################

shared_examples_for 'store_objectkey_nilvalue' do
  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey1)] = 0
    store[Value.new(:objkey1)].should == 0
    store.load(Value.new(:objkey1)).should == 0
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey1)] = 0
    store.key?(Value.new(:objkey1)).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(Value.new(:objkey1), value).should equal(value)
    store[Value.new(:objkey1)].should == 0
    store.load(Value.new(:objkey1)).should == 0
  end

  it 'stores values after clear' do
    store[Value.new(:objkey1)] = 0
    store[Value.new(:objkey2)] = nil
    store.clear.should equal(store)
    store[Value.new(:objkey1)] = 0
    store[Value.new(:objkey1)].should == 0
    store[Value.new(:objkey2)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey1)] = 0
    store.delete(Value.new(:objkey1)).should == 0
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey1)] = 0
    store[Value.new(:objkey1)].should == 0
    store[Value.new(:objkey1)] = nil
    store[Value.new(:objkey1)].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey2)] = 0
    store[Value.new(:objkey2)].should == 0
    store.load(Value.new(:objkey2)).should == 0
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey2)] = 0
    store.key?(Value.new(:objkey2)).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(Value.new(:objkey2), value).should equal(value)
    store[Value.new(:objkey2)].should == 0
    store.load(Value.new(:objkey2)).should == 0
  end

  it 'stores values after clear' do
    store[Value.new(:objkey2)] = 0
    store[Value.new(:objkey1)] = nil
    store.clear.should equal(store)
    store[Value.new(:objkey2)] = 0
    store[Value.new(:objkey2)].should == 0
    store[Value.new(:objkey1)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey2)] = 0
    store.delete(Value.new(:objkey2)).should == 0
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey2)] = 0
    store[Value.new(:objkey2)].should == 0
    store[Value.new(:objkey2)] = nil
    store[Value.new(:objkey2)].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey1)] = nil
    store[Value.new(:objkey1)].should == nil
    store.load(Value.new(:objkey1)).should == nil
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey1)] = nil
    store.key?(Value.new(:objkey1)).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(Value.new(:objkey1), value).should equal(value)
    store[Value.new(:objkey1)].should == nil
    store.load(Value.new(:objkey1)).should == nil
  end

  it 'stores values after clear' do
    store[Value.new(:objkey1)] = nil
    store[Value.new(:objkey2)] = 0
    store.clear.should equal(store)
    store[Value.new(:objkey1)] = nil
    store[Value.new(:objkey1)].should == nil
    store[Value.new(:objkey2)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey1)] = nil
    store.delete(Value.new(:objkey1)).should == nil
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey1)] = nil
    store[Value.new(:objkey1)].should == nil
    store[Value.new(:objkey1)] = 0
    store[Value.new(:objkey1)].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey2)] = nil
    store[Value.new(:objkey2)].should == nil
    store.load(Value.new(:objkey2)).should == nil
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey2)] = nil
    store.key?(Value.new(:objkey2)).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(Value.new(:objkey2), value).should equal(value)
    store[Value.new(:objkey2)].should == nil
    store.load(Value.new(:objkey2)).should == nil
  end

  it 'stores values after clear' do
    store[Value.new(:objkey2)] = nil
    store[Value.new(:objkey1)] = 0
    store.clear.should equal(store)
    store[Value.new(:objkey2)] = nil
    store[Value.new(:objkey2)].should == nil
    store[Value.new(:objkey1)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey2)] = nil
    store.delete(Value.new(:objkey2)).should == nil
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey2)] = nil
    store[Value.new(:objkey2)].should == nil
    store[Value.new(:objkey2)] = 0
    store[Value.new(:objkey2)].should == 0
  end
end

#################### persist_objectkey_nilvalue ####################

shared_examples_for 'persist_objectkey_nilvalue' do
  it 'persists values' do
    store[Value.new(:objkey1)] = 0
    store.close
    @store = nil
    store[Value.new(:objkey1)].should == 0
  end

  it 'persists values' do
    store[Value.new(:objkey2)] = 0
    store.close
    @store = nil
    store[Value.new(:objkey2)].should == 0
  end

  it 'persists values' do
    store[Value.new(:objkey1)] = nil
    store.close
    @store = nil
    store[Value.new(:objkey1)].should == nil
  end

  it 'persists values' do
    store[Value.new(:objkey2)] = nil
    store.close
    @store = nil
    store[Value.new(:objkey2)].should == nil
  end
end

#################### null_objectkey_integervalue ####################

shared_examples_for 'null_objectkey_integervalue' do
  it 'reads from keys like a Hash' do
    store[Value.new(:objkey1)].should be_nil
    store.load(Value.new(:objkey1)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[Value.new(:objkey1)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey1)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey1)] = 41
    store[Value.new(:objkey2)] = -12
    store.clear.should equal(store)
    store.key?(Value.new(:objkey1)).should be_false
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey1), 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey1)
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey1), options).should be_false
    store.load(Value.new(:objkey1), options).should be_nil
    store.fetch(Value.new(:objkey1), 42, options).should == 42
    store.fetch(Value.new(:objkey1), options) { 42 }.should == 42
    store.delete(Value.new(:objkey1), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey1), 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey2)].should be_nil
    store.load(Value.new(:objkey2)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[Value.new(:objkey2)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey2)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey2)] = 41
    store[Value.new(:objkey1)] = -12
    store.clear.should equal(store)
    store.key?(Value.new(:objkey2)).should be_false
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey2), 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey2)
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey2), options).should be_false
    store.load(Value.new(:objkey2), options).should be_nil
    store.fetch(Value.new(:objkey2), 42, options).should == 42
    store.fetch(Value.new(:objkey2), options) { 42 }.should == 42
    store.delete(Value.new(:objkey2), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey2), 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey1)].should be_nil
    store.load(Value.new(:objkey1)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[Value.new(:objkey1)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey1)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey1)] = -12
    store[Value.new(:objkey2)] = 41
    store.clear.should equal(store)
    store.key?(Value.new(:objkey1)).should be_false
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey1), -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey1)
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey1), options).should be_false
    store.load(Value.new(:objkey1), options).should be_nil
    store.fetch(Value.new(:objkey1), 42, options).should == 42
    store.fetch(Value.new(:objkey1), options) { 42 }.should == 42
    store.delete(Value.new(:objkey1), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey1), -12, options).should == -12
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey2)].should be_nil
    store.load(Value.new(:objkey2)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[Value.new(:objkey2)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey2)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey2)] = -12
    store[Value.new(:objkey1)] = 41
    store.clear.should equal(store)
    store.key?(Value.new(:objkey2)).should be_false
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey2), -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey2)
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey2), options).should be_false
    store.load(Value.new(:objkey2), options).should be_nil
    store.fetch(Value.new(:objkey2), 42, options).should == 42
    store.fetch(Value.new(:objkey2), options) { 42 }.should == 42
    store.delete(Value.new(:objkey2), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey2), -12, options).should == -12
  end
end

#################### store_objectkey_integervalue ####################

shared_examples_for 'store_objectkey_integervalue' do
  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey1)] = 41
    store[Value.new(:objkey1)].should == 41
    store.load(Value.new(:objkey1)).should == 41
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey1)] = 41
    store.key?(Value.new(:objkey1)).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(Value.new(:objkey1), value).should equal(value)
    store[Value.new(:objkey1)].should == 41
    store.load(Value.new(:objkey1)).should == 41
  end

  it 'stores values after clear' do
    store[Value.new(:objkey1)] = 41
    store[Value.new(:objkey2)] = -12
    store.clear.should equal(store)
    store[Value.new(:objkey1)] = 41
    store[Value.new(:objkey1)].should == 41
    store[Value.new(:objkey2)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey1)] = 41
    store.delete(Value.new(:objkey1)).should == 41
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey1)] = 41
    store[Value.new(:objkey1)].should == 41
    store[Value.new(:objkey1)] = -12
    store[Value.new(:objkey1)].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey1)] = 41
    store.fetch(Value.new(:objkey1), -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey1)] = 41
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey1)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey2)] = 41
    store[Value.new(:objkey2)].should == 41
    store.load(Value.new(:objkey2)).should == 41
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey2)] = 41
    store.key?(Value.new(:objkey2)).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(Value.new(:objkey2), value).should equal(value)
    store[Value.new(:objkey2)].should == 41
    store.load(Value.new(:objkey2)).should == 41
  end

  it 'stores values after clear' do
    store[Value.new(:objkey2)] = 41
    store[Value.new(:objkey1)] = -12
    store.clear.should equal(store)
    store[Value.new(:objkey2)] = 41
    store[Value.new(:objkey2)].should == 41
    store[Value.new(:objkey1)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey2)] = 41
    store.delete(Value.new(:objkey2)).should == 41
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey2)] = 41
    store[Value.new(:objkey2)].should == 41
    store[Value.new(:objkey2)] = -12
    store[Value.new(:objkey2)].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey2)] = 41
    store.fetch(Value.new(:objkey2), -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey2)] = 41
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey2)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey1)] = -12
    store[Value.new(:objkey1)].should == -12
    store.load(Value.new(:objkey1)).should == -12
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey1)] = -12
    store.key?(Value.new(:objkey1)).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(Value.new(:objkey1), value).should equal(value)
    store[Value.new(:objkey1)].should == -12
    store.load(Value.new(:objkey1)).should == -12
  end

  it 'stores values after clear' do
    store[Value.new(:objkey1)] = -12
    store[Value.new(:objkey2)] = 41
    store.clear.should equal(store)
    store[Value.new(:objkey1)] = -12
    store[Value.new(:objkey1)].should == -12
    store[Value.new(:objkey2)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey1)] = -12
    store.delete(Value.new(:objkey1)).should == -12
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey1)] = -12
    store[Value.new(:objkey1)].should == -12
    store[Value.new(:objkey1)] = 41
    store[Value.new(:objkey1)].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey1)] = -12
    store.fetch(Value.new(:objkey1), 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey1)] = -12
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey1)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey2)] = -12
    store[Value.new(:objkey2)].should == -12
    store.load(Value.new(:objkey2)).should == -12
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey2)] = -12
    store.key?(Value.new(:objkey2)).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(Value.new(:objkey2), value).should equal(value)
    store[Value.new(:objkey2)].should == -12
    store.load(Value.new(:objkey2)).should == -12
  end

  it 'stores values after clear' do
    store[Value.new(:objkey2)] = -12
    store[Value.new(:objkey1)] = 41
    store.clear.should equal(store)
    store[Value.new(:objkey2)] = -12
    store[Value.new(:objkey2)].should == -12
    store[Value.new(:objkey1)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey2)] = -12
    store.delete(Value.new(:objkey2)).should == -12
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey2)] = -12
    store[Value.new(:objkey2)].should == -12
    store[Value.new(:objkey2)] = 41
    store[Value.new(:objkey2)].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey2)] = -12
    store.fetch(Value.new(:objkey2), 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey2)] = -12
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey2)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_objectkey_integervalue ####################

shared_examples_for 'persist_objectkey_integervalue' do
  it 'persists values' do
    store[Value.new(:objkey1)] = 41
    store.close
    @store = nil
    store[Value.new(:objkey1)].should == 41
  end

  it 'persists values' do
    store[Value.new(:objkey2)] = 41
    store.close
    @store = nil
    store[Value.new(:objkey2)].should == 41
  end

  it 'persists values' do
    store[Value.new(:objkey1)] = -12
    store.close
    @store = nil
    store[Value.new(:objkey1)].should == -12
  end

  it 'persists values' do
    store[Value.new(:objkey2)] = -12
    store.close
    @store = nil
    store[Value.new(:objkey2)].should == -12
  end
end

#################### null_objectkey_booleanvalue ####################

shared_examples_for 'null_objectkey_booleanvalue' do
  it 'reads from keys like a Hash' do
    store[Value.new(:objkey1)].should be_nil
    store.load(Value.new(:objkey1)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[Value.new(:objkey1)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey1)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey1)] = true
    store[Value.new(:objkey2)] = false
    store.clear.should equal(store)
    store.key?(Value.new(:objkey1)).should be_false
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey1), true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey1)
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey1), options).should be_false
    store.load(Value.new(:objkey1), options).should be_nil
    store.fetch(Value.new(:objkey1), 42, options).should == 42
    store.fetch(Value.new(:objkey1), options) { 42 }.should == 42
    store.delete(Value.new(:objkey1), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey1), true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey2)].should be_nil
    store.load(Value.new(:objkey2)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[Value.new(:objkey2)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey2)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey2)] = true
    store[Value.new(:objkey1)] = false
    store.clear.should equal(store)
    store.key?(Value.new(:objkey2)).should be_false
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey2), true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey2)
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey2), options).should be_false
    store.load(Value.new(:objkey2), options).should be_nil
    store.fetch(Value.new(:objkey2), 42, options).should == 42
    store.fetch(Value.new(:objkey2), options) { 42 }.should == 42
    store.delete(Value.new(:objkey2), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey2), true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey1)].should be_nil
    store.load(Value.new(:objkey1)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[Value.new(:objkey1)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey1)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey1)] = false
    store[Value.new(:objkey2)] = true
    store.clear.should equal(store)
    store.key?(Value.new(:objkey1)).should be_false
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey1), false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey1)
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey1), options).should be_false
    store.load(Value.new(:objkey1), options).should be_nil
    store.fetch(Value.new(:objkey1), 42, options).should == 42
    store.fetch(Value.new(:objkey1), options) { 42 }.should == 42
    store.delete(Value.new(:objkey1), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey1), false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey2)].should be_nil
    store.load(Value.new(:objkey2)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[Value.new(:objkey2)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey2)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey2)] = false
    store[Value.new(:objkey1)] = true
    store.clear.should equal(store)
    store.key?(Value.new(:objkey2)).should be_false
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey2), false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey2)
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey2), options).should be_false
    store.load(Value.new(:objkey2), options).should be_nil
    store.fetch(Value.new(:objkey2), 42, options).should == 42
    store.fetch(Value.new(:objkey2), options) { 42 }.should == 42
    store.delete(Value.new(:objkey2), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey2), false, options).should == false
  end
end

#################### store_objectkey_booleanvalue ####################

shared_examples_for 'store_objectkey_booleanvalue' do
  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey1)] = true
    store[Value.new(:objkey1)].should == true
    store.load(Value.new(:objkey1)).should == true
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey1)] = true
    store.key?(Value.new(:objkey1)).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(Value.new(:objkey1), value).should equal(value)
    store[Value.new(:objkey1)].should == true
    store.load(Value.new(:objkey1)).should == true
  end

  it 'stores values after clear' do
    store[Value.new(:objkey1)] = true
    store[Value.new(:objkey2)] = false
    store.clear.should equal(store)
    store[Value.new(:objkey1)] = true
    store[Value.new(:objkey1)].should == true
    store[Value.new(:objkey2)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey1)] = true
    store.delete(Value.new(:objkey1)).should == true
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey1)] = true
    store[Value.new(:objkey1)].should == true
    store[Value.new(:objkey1)] = false
    store[Value.new(:objkey1)].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey1)] = true
    store.fetch(Value.new(:objkey1), false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey1)] = true
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey1)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey2)] = true
    store[Value.new(:objkey2)].should == true
    store.load(Value.new(:objkey2)).should == true
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey2)] = true
    store.key?(Value.new(:objkey2)).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(Value.new(:objkey2), value).should equal(value)
    store[Value.new(:objkey2)].should == true
    store.load(Value.new(:objkey2)).should == true
  end

  it 'stores values after clear' do
    store[Value.new(:objkey2)] = true
    store[Value.new(:objkey1)] = false
    store.clear.should equal(store)
    store[Value.new(:objkey2)] = true
    store[Value.new(:objkey2)].should == true
    store[Value.new(:objkey1)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey2)] = true
    store.delete(Value.new(:objkey2)).should == true
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey2)] = true
    store[Value.new(:objkey2)].should == true
    store[Value.new(:objkey2)] = false
    store[Value.new(:objkey2)].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey2)] = true
    store.fetch(Value.new(:objkey2), false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey2)] = true
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey2)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey1)] = false
    store[Value.new(:objkey1)].should == false
    store.load(Value.new(:objkey1)).should == false
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey1)] = false
    store.key?(Value.new(:objkey1)).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(Value.new(:objkey1), value).should equal(value)
    store[Value.new(:objkey1)].should == false
    store.load(Value.new(:objkey1)).should == false
  end

  it 'stores values after clear' do
    store[Value.new(:objkey1)] = false
    store[Value.new(:objkey2)] = true
    store.clear.should equal(store)
    store[Value.new(:objkey1)] = false
    store[Value.new(:objkey1)].should == false
    store[Value.new(:objkey2)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey1)] = false
    store.delete(Value.new(:objkey1)).should == false
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey1)] = false
    store[Value.new(:objkey1)].should == false
    store[Value.new(:objkey1)] = true
    store[Value.new(:objkey1)].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey1)] = false
    store.fetch(Value.new(:objkey1), true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey1)] = false
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey1)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey2)] = false
    store[Value.new(:objkey2)].should == false
    store.load(Value.new(:objkey2)).should == false
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey2)] = false
    store.key?(Value.new(:objkey2)).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(Value.new(:objkey2), value).should equal(value)
    store[Value.new(:objkey2)].should == false
    store.load(Value.new(:objkey2)).should == false
  end

  it 'stores values after clear' do
    store[Value.new(:objkey2)] = false
    store[Value.new(:objkey1)] = true
    store.clear.should equal(store)
    store[Value.new(:objkey2)] = false
    store[Value.new(:objkey2)].should == false
    store[Value.new(:objkey1)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey2)] = false
    store.delete(Value.new(:objkey2)).should == false
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey2)] = false
    store[Value.new(:objkey2)].should == false
    store[Value.new(:objkey2)] = true
    store[Value.new(:objkey2)].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey2)] = false
    store.fetch(Value.new(:objkey2), true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey2)] = false
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey2)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_objectkey_booleanvalue ####################

shared_examples_for 'persist_objectkey_booleanvalue' do
  it 'persists values' do
    store[Value.new(:objkey1)] = true
    store.close
    @store = nil
    store[Value.new(:objkey1)].should == true
  end

  it 'persists values' do
    store[Value.new(:objkey2)] = true
    store.close
    @store = nil
    store[Value.new(:objkey2)].should == true
  end

  it 'persists values' do
    store[Value.new(:objkey1)] = false
    store.close
    @store = nil
    store[Value.new(:objkey1)].should == false
  end

  it 'persists values' do
    store[Value.new(:objkey2)] = false
    store.close
    @store = nil
    store[Value.new(:objkey2)].should == false
  end
end

#################### null_objectkey_stringvalue ####################

shared_examples_for 'null_objectkey_stringvalue' do
  it 'reads from keys like a Hash' do
    store[Value.new(:objkey1)].should be_nil
    store.load(Value.new(:objkey1)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[Value.new(:objkey1)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey1)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey1)] = "strval1"
    store[Value.new(:objkey2)] = "strval2"
    store.clear.should equal(store)
    store.key?(Value.new(:objkey1)).should be_false
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey1), "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey1)
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey1), options).should be_false
    store.load(Value.new(:objkey1), options).should be_nil
    store.fetch(Value.new(:objkey1), 42, options).should == 42
    store.fetch(Value.new(:objkey1), options) { 42 }.should == 42
    store.delete(Value.new(:objkey1), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey1), "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey2)].should be_nil
    store.load(Value.new(:objkey2)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[Value.new(:objkey2)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey2)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey2)] = "strval1"
    store[Value.new(:objkey1)] = "strval2"
    store.clear.should equal(store)
    store.key?(Value.new(:objkey2)).should be_false
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey2), "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey2)
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey2), options).should be_false
    store.load(Value.new(:objkey2), options).should be_nil
    store.fetch(Value.new(:objkey2), 42, options).should == 42
    store.fetch(Value.new(:objkey2), options) { 42 }.should == 42
    store.delete(Value.new(:objkey2), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey2), "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey1)].should be_nil
    store.load(Value.new(:objkey1)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[Value.new(:objkey1)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey1)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey1)] = "strval2"
    store[Value.new(:objkey2)] = "strval1"
    store.clear.should equal(store)
    store.key?(Value.new(:objkey1)).should be_false
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey1), "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey1)
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey1), options).should be_false
    store.load(Value.new(:objkey1), options).should be_nil
    store.fetch(Value.new(:objkey1), 42, options).should == 42
    store.fetch(Value.new(:objkey1), options) { 42 }.should == 42
    store.delete(Value.new(:objkey1), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey1), "strval2", options).should == "strval2"
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey2)].should be_nil
    store.load(Value.new(:objkey2)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[Value.new(:objkey2)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey2)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey2)] = "strval2"
    store[Value.new(:objkey1)] = "strval1"
    store.clear.should equal(store)
    store.key?(Value.new(:objkey2)).should be_false
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey2), "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey2)
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey2), options).should be_false
    store.load(Value.new(:objkey2), options).should be_nil
    store.fetch(Value.new(:objkey2), 42, options).should == 42
    store.fetch(Value.new(:objkey2), options) { 42 }.should == 42
    store.delete(Value.new(:objkey2), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey2), "strval2", options).should == "strval2"
  end
end

#################### store_objectkey_stringvalue ####################

shared_examples_for 'store_objectkey_stringvalue' do
  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey1)] = "strval1"
    store[Value.new(:objkey1)].should == "strval1"
    store.load(Value.new(:objkey1)).should == "strval1"
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey1)] = "strval1"
    store.key?(Value.new(:objkey1)).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(Value.new(:objkey1), value).should equal(value)
    store[Value.new(:objkey1)].should == "strval1"
    store.load(Value.new(:objkey1)).should == "strval1"
  end

  it 'stores values after clear' do
    store[Value.new(:objkey1)] = "strval1"
    store[Value.new(:objkey2)] = "strval2"
    store.clear.should equal(store)
    store[Value.new(:objkey1)] = "strval1"
    store[Value.new(:objkey1)].should == "strval1"
    store[Value.new(:objkey2)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey1)] = "strval1"
    store.delete(Value.new(:objkey1)).should == "strval1"
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey1)] = "strval1"
    store[Value.new(:objkey1)].should == "strval1"
    store[Value.new(:objkey1)] = "strval2"
    store[Value.new(:objkey1)].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey1)] = "strval1"
    store.fetch(Value.new(:objkey1), "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey1)] = "strval1"
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey1)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey2)] = "strval1"
    store[Value.new(:objkey2)].should == "strval1"
    store.load(Value.new(:objkey2)).should == "strval1"
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey2)] = "strval1"
    store.key?(Value.new(:objkey2)).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(Value.new(:objkey2), value).should equal(value)
    store[Value.new(:objkey2)].should == "strval1"
    store.load(Value.new(:objkey2)).should == "strval1"
  end

  it 'stores values after clear' do
    store[Value.new(:objkey2)] = "strval1"
    store[Value.new(:objkey1)] = "strval2"
    store.clear.should equal(store)
    store[Value.new(:objkey2)] = "strval1"
    store[Value.new(:objkey2)].should == "strval1"
    store[Value.new(:objkey1)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey2)] = "strval1"
    store.delete(Value.new(:objkey2)).should == "strval1"
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey2)] = "strval1"
    store[Value.new(:objkey2)].should == "strval1"
    store[Value.new(:objkey2)] = "strval2"
    store[Value.new(:objkey2)].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey2)] = "strval1"
    store.fetch(Value.new(:objkey2), "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey2)] = "strval1"
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey2)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey1)] = "strval2"
    store[Value.new(:objkey1)].should == "strval2"
    store.load(Value.new(:objkey1)).should == "strval2"
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey1)] = "strval2"
    store.key?(Value.new(:objkey1)).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(Value.new(:objkey1), value).should equal(value)
    store[Value.new(:objkey1)].should == "strval2"
    store.load(Value.new(:objkey1)).should == "strval2"
  end

  it 'stores values after clear' do
    store[Value.new(:objkey1)] = "strval2"
    store[Value.new(:objkey2)] = "strval1"
    store.clear.should equal(store)
    store[Value.new(:objkey1)] = "strval2"
    store[Value.new(:objkey1)].should == "strval2"
    store[Value.new(:objkey2)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey1)] = "strval2"
    store.delete(Value.new(:objkey1)).should == "strval2"
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey1)] = "strval2"
    store[Value.new(:objkey1)].should == "strval2"
    store[Value.new(:objkey1)] = "strval1"
    store[Value.new(:objkey1)].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey1)] = "strval2"
    store.fetch(Value.new(:objkey1), "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey1)] = "strval2"
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey1)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey2)] = "strval2"
    store[Value.new(:objkey2)].should == "strval2"
    store.load(Value.new(:objkey2)).should == "strval2"
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey2)] = "strval2"
    store.key?(Value.new(:objkey2)).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(Value.new(:objkey2), value).should equal(value)
    store[Value.new(:objkey2)].should == "strval2"
    store.load(Value.new(:objkey2)).should == "strval2"
  end

  it 'stores values after clear' do
    store[Value.new(:objkey2)] = "strval2"
    store[Value.new(:objkey1)] = "strval1"
    store.clear.should equal(store)
    store[Value.new(:objkey2)] = "strval2"
    store[Value.new(:objkey2)].should == "strval2"
    store[Value.new(:objkey1)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey2)] = "strval2"
    store.delete(Value.new(:objkey2)).should == "strval2"
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey2)] = "strval2"
    store[Value.new(:objkey2)].should == "strval2"
    store[Value.new(:objkey2)] = "strval1"
    store[Value.new(:objkey2)].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey2)] = "strval2"
    store.fetch(Value.new(:objkey2), "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey2)] = "strval2"
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey2)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_objectkey_stringvalue ####################

shared_examples_for 'returndifferent_objectkey_stringvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[Value.new(:objkey1)] = value
    store[Value.new(:objkey1)].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[Value.new(:objkey2)] = value
    store[Value.new(:objkey2)].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[Value.new(:objkey1)] = value
    store[Value.new(:objkey1)].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[Value.new(:objkey2)] = value
    store[Value.new(:objkey2)].should_not be_equal(value)
  end
end

#################### returnsame_objectkey_stringvalue ####################

shared_examples_for 'returnsame_objectkey_stringvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[Value.new(:objkey1)] = value
    store[Value.new(:objkey1)].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[Value.new(:objkey2)] = value
    store[Value.new(:objkey2)].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[Value.new(:objkey1)] = value
    store[Value.new(:objkey1)].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[Value.new(:objkey2)] = value
    store[Value.new(:objkey2)].should be_equal(value)
  end
end

#################### persist_objectkey_stringvalue ####################

shared_examples_for 'persist_objectkey_stringvalue' do
  it 'persists values' do
    store[Value.new(:objkey1)] = "strval1"
    store.close
    @store = nil
    store[Value.new(:objkey1)].should == "strval1"
  end

  it 'persists values' do
    store[Value.new(:objkey2)] = "strval1"
    store.close
    @store = nil
    store[Value.new(:objkey2)].should == "strval1"
  end

  it 'persists values' do
    store[Value.new(:objkey1)] = "strval2"
    store.close
    @store = nil
    store[Value.new(:objkey1)].should == "strval2"
  end

  it 'persists values' do
    store[Value.new(:objkey2)] = "strval2"
    store.close
    @store = nil
    store[Value.new(:objkey2)].should == "strval2"
  end
end

#################### null_objectkey_hashvalue ####################

shared_examples_for 'null_objectkey_hashvalue' do
  it 'reads from keys like a Hash' do
    store[Value.new(:objkey1)].should be_nil
    store.load(Value.new(:objkey1)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[Value.new(:objkey1)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey1)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey1)] = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey2)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(Value.new(:objkey1)).should be_false
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey1), {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey1)
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey1), options).should be_false
    store.load(Value.new(:objkey1), options).should be_nil
    store.fetch(Value.new(:objkey1), 42, options).should == 42
    store.fetch(Value.new(:objkey1), options) { 42 }.should == 42
    store.delete(Value.new(:objkey1), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey1), {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey2)].should be_nil
    store.load(Value.new(:objkey2)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[Value.new(:objkey2)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey2)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey2)] = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey1)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(Value.new(:objkey2)).should be_false
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey2), {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey2)
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey2), options).should be_false
    store.load(Value.new(:objkey2), options).should be_nil
    store.fetch(Value.new(:objkey2), 42, options).should == 42
    store.fetch(Value.new(:objkey2), options) { 42 }.should == 42
    store.delete(Value.new(:objkey2), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey2), {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey1)].should be_nil
    store.load(Value.new(:objkey1)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[Value.new(:objkey1)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey1)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey1)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey2)] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(Value.new(:objkey1)).should be_false
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey1), {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey1)
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey1), options).should be_false
    store.load(Value.new(:objkey1), options).should be_nil
    store.fetch(Value.new(:objkey1), 42, options).should == 42
    store.fetch(Value.new(:objkey1), options) { 42 }.should == 42
    store.delete(Value.new(:objkey1), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey1), {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey2)].should be_nil
    store.load(Value.new(:objkey2)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[Value.new(:objkey2)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey2)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey2)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey1)] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(Value.new(:objkey2)).should be_false
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey2), {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey2)
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey2), options).should be_false
    store.load(Value.new(:objkey2), options).should be_nil
    store.fetch(Value.new(:objkey2), 42, options).should == 42
    store.fetch(Value.new(:objkey2), options) { 42 }.should == 42
    store.delete(Value.new(:objkey2), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey2), {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### store_objectkey_hashvalue ####################

shared_examples_for 'store_objectkey_hashvalue' do
  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey1)] = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey1)].should == {"hashval1"=>["array1", 1]}
    store.load(Value.new(:objkey1)).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey1)] = {"hashval1"=>["array1", 1]}
    store.key?(Value.new(:objkey1)).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(Value.new(:objkey1), value).should equal(value)
    store[Value.new(:objkey1)].should == {"hashval1"=>["array1", 1]}
    store.load(Value.new(:objkey1)).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[Value.new(:objkey1)] = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey2)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[Value.new(:objkey1)] = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey1)].should == {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey2)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey1)] = {"hashval1"=>["array1", 1]}
    store.delete(Value.new(:objkey1)).should == {"hashval1"=>["array1", 1]}
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey1)] = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey1)].should == {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey1)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey1)].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey1)] = {"hashval1"=>["array1", 1]}
    store.fetch(Value.new(:objkey1), {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey1)] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey1)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey2)] = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey2)].should == {"hashval1"=>["array1", 1]}
    store.load(Value.new(:objkey2)).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey2)] = {"hashval1"=>["array1", 1]}
    store.key?(Value.new(:objkey2)).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(Value.new(:objkey2), value).should equal(value)
    store[Value.new(:objkey2)].should == {"hashval1"=>["array1", 1]}
    store.load(Value.new(:objkey2)).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[Value.new(:objkey2)] = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey1)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[Value.new(:objkey2)] = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey2)].should == {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey1)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey2)] = {"hashval1"=>["array1", 1]}
    store.delete(Value.new(:objkey2)).should == {"hashval1"=>["array1", 1]}
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey2)] = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey2)].should == {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey2)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey2)].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey2)] = {"hashval1"=>["array1", 1]}
    store.fetch(Value.new(:objkey2), {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey2)] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey2)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey1)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey1)].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(Value.new(:objkey1)).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey1)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(Value.new(:objkey1)).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(Value.new(:objkey1), value).should equal(value)
    store[Value.new(:objkey1)].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(Value.new(:objkey1)).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[Value.new(:objkey1)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey2)] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[Value.new(:objkey1)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey1)].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey2)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey1)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(Value.new(:objkey1)).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey1)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey1)].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey1)] = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey1)].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey1)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(Value.new(:objkey1), {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey1)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey1)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey2)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey2)].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(Value.new(:objkey2)).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey2)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(Value.new(:objkey2)).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(Value.new(:objkey2), value).should equal(value)
    store[Value.new(:objkey2)].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(Value.new(:objkey2)).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[Value.new(:objkey2)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey1)] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[Value.new(:objkey2)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey2)].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey1)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey2)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(Value.new(:objkey2)).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey2)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey2)].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey2)] = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey2)].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey2)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(Value.new(:objkey2), {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey2)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey2)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_objectkey_hashvalue ####################

shared_examples_for 'returndifferent_objectkey_hashvalue' do
  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey1)] = value
    store[Value.new(:objkey1)].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey2)] = value
    store[Value.new(:objkey2)].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey1)] = value
    store[Value.new(:objkey1)].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey2)] = value
    store[Value.new(:objkey2)].should_not be_equal(value)
  end
end

#################### returnsame_objectkey_hashvalue ####################

shared_examples_for 'returnsame_objectkey_hashvalue' do
  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey1)] = value
    store[Value.new(:objkey1)].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[Value.new(:objkey2)] = value
    store[Value.new(:objkey2)].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey1)] = value
    store[Value.new(:objkey1)].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[Value.new(:objkey2)] = value
    store[Value.new(:objkey2)].should be_equal(value)
  end
end

#################### persist_objectkey_hashvalue ####################

shared_examples_for 'persist_objectkey_hashvalue' do
  it 'persists values' do
    store[Value.new(:objkey1)] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[Value.new(:objkey1)].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[Value.new(:objkey2)] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[Value.new(:objkey2)].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[Value.new(:objkey1)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[Value.new(:objkey1)].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'persists values' do
    store[Value.new(:objkey2)] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[Value.new(:objkey2)].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### null_objectkey_objectvalue ####################

shared_examples_for 'null_objectkey_objectvalue' do
  it 'reads from keys like a Hash' do
    store[Value.new(:objkey1)].should be_nil
    store.load(Value.new(:objkey1)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[Value.new(:objkey1)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey1)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey1)] = Value.new(:objval1)
    store[Value.new(:objkey2)] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(Value.new(:objkey1)).should be_false
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey1), Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey1)
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey1), options).should be_false
    store.load(Value.new(:objkey1), options).should be_nil
    store.fetch(Value.new(:objkey1), 42, options).should == 42
    store.fetch(Value.new(:objkey1), options) { 42 }.should == 42
    store.delete(Value.new(:objkey1), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey1), Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey2)].should be_nil
    store.load(Value.new(:objkey2)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[Value.new(:objkey2)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey2)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey2)] = Value.new(:objval1)
    store[Value.new(:objkey1)] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(Value.new(:objkey2)).should be_false
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey2), Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey2)
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey2), options).should be_false
    store.load(Value.new(:objkey2), options).should be_nil
    store.fetch(Value.new(:objkey2), 42, options).should == 42
    store.fetch(Value.new(:objkey2), options) { 42 }.should == 42
    store.delete(Value.new(:objkey2), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey2), Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey1)].should be_nil
    store.load(Value.new(:objkey1)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[Value.new(:objkey1)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey1)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey1)] = Value.new(:objval2)
    store[Value.new(:objkey2)] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(Value.new(:objkey1)).should be_false
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey1), Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey1)
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey1), options).should be_false
    store.load(Value.new(:objkey1), options).should be_nil
    store.fetch(Value.new(:objkey1), 42, options).should == 42
    store.fetch(Value.new(:objkey1), options) { 42 }.should == 42
    store.delete(Value.new(:objkey1), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey1), Value.new(:objval2), options).should == Value.new(:objval2)
  end

  it 'reads from keys like a Hash' do
    store[Value.new(:objkey2)].should be_nil
    store.load(Value.new(:objkey2)).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[Value.new(:objkey2)] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(Value.new(:objkey2)).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[Value.new(:objkey2)] = Value.new(:objval2)
    store[Value.new(:objkey1)] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(Value.new(:objkey2)).should be_false
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(Value.new(:objkey2), Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = Value.new(:objkey2)
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(Value.new(:objkey2), options).should be_false
    store.load(Value.new(:objkey2), options).should be_nil
    store.fetch(Value.new(:objkey2), 42, options).should == 42
    store.fetch(Value.new(:objkey2), options) { 42 }.should == 42
    store.delete(Value.new(:objkey2), options).should be_nil
    store.clear(options).should equal(store)
    store.store(Value.new(:objkey2), Value.new(:objval2), options).should == Value.new(:objval2)
  end
end

#################### store_objectkey_objectvalue ####################

shared_examples_for 'store_objectkey_objectvalue' do
  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey1)] = Value.new(:objval1)
    store[Value.new(:objkey1)].should == Value.new(:objval1)
    store.load(Value.new(:objkey1)).should == Value.new(:objval1)
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey1)] = Value.new(:objval1)
    store.key?(Value.new(:objkey1)).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(Value.new(:objkey1), value).should equal(value)
    store[Value.new(:objkey1)].should == Value.new(:objval1)
    store.load(Value.new(:objkey1)).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[Value.new(:objkey1)] = Value.new(:objval1)
    store[Value.new(:objkey2)] = Value.new(:objval2)
    store.clear.should equal(store)
    store[Value.new(:objkey1)] = Value.new(:objval1)
    store[Value.new(:objkey1)].should == Value.new(:objval1)
    store[Value.new(:objkey2)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey1)] = Value.new(:objval1)
    store.delete(Value.new(:objkey1)).should == Value.new(:objval1)
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey1)] = Value.new(:objval1)
    store[Value.new(:objkey1)].should == Value.new(:objval1)
    store[Value.new(:objkey1)] = Value.new(:objval2)
    store[Value.new(:objkey1)].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey1)] = Value.new(:objval1)
    store.fetch(Value.new(:objkey1), Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey1)] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey1)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey2)] = Value.new(:objval1)
    store[Value.new(:objkey2)].should == Value.new(:objval1)
    store.load(Value.new(:objkey2)).should == Value.new(:objval1)
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey2)] = Value.new(:objval1)
    store.key?(Value.new(:objkey2)).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(Value.new(:objkey2), value).should equal(value)
    store[Value.new(:objkey2)].should == Value.new(:objval1)
    store.load(Value.new(:objkey2)).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[Value.new(:objkey2)] = Value.new(:objval1)
    store[Value.new(:objkey1)] = Value.new(:objval2)
    store.clear.should equal(store)
    store[Value.new(:objkey2)] = Value.new(:objval1)
    store[Value.new(:objkey2)].should == Value.new(:objval1)
    store[Value.new(:objkey1)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey2)] = Value.new(:objval1)
    store.delete(Value.new(:objkey2)).should == Value.new(:objval1)
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey2)] = Value.new(:objval1)
    store[Value.new(:objkey2)].should == Value.new(:objval1)
    store[Value.new(:objkey2)] = Value.new(:objval2)
    store[Value.new(:objkey2)].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey2)] = Value.new(:objval1)
    store.fetch(Value.new(:objkey2), Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey2)] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey2)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey1)] = Value.new(:objval2)
    store[Value.new(:objkey1)].should == Value.new(:objval2)
    store.load(Value.new(:objkey1)).should == Value.new(:objval2)
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey1)] = Value.new(:objval2)
    store.key?(Value.new(:objkey1)).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(Value.new(:objkey1), value).should equal(value)
    store[Value.new(:objkey1)].should == Value.new(:objval2)
    store.load(Value.new(:objkey1)).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[Value.new(:objkey1)] = Value.new(:objval2)
    store[Value.new(:objkey2)] = Value.new(:objval1)
    store.clear.should equal(store)
    store[Value.new(:objkey1)] = Value.new(:objval2)
    store[Value.new(:objkey1)].should == Value.new(:objval2)
    store[Value.new(:objkey2)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey1)] = Value.new(:objval2)
    store.delete(Value.new(:objkey1)).should == Value.new(:objval2)
    store.key?(Value.new(:objkey1)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey1)] = Value.new(:objval2)
    store[Value.new(:objkey1)].should == Value.new(:objval2)
    store[Value.new(:objkey1)] = Value.new(:objval1)
    store[Value.new(:objkey1)].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey1)] = Value.new(:objval2)
    store.fetch(Value.new(:objkey1), Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey1)] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey1)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[Value.new(:objkey2)] = Value.new(:objval2)
    store[Value.new(:objkey2)].should == Value.new(:objval2)
    store.load(Value.new(:objkey2)).should == Value.new(:objval2)
  end

  it 'returns true from key? if a key is available' do
    store[Value.new(:objkey2)] = Value.new(:objval2)
    store.key?(Value.new(:objkey2)).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(Value.new(:objkey2), value).should equal(value)
    store[Value.new(:objkey2)].should == Value.new(:objval2)
    store.load(Value.new(:objkey2)).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[Value.new(:objkey2)] = Value.new(:objval2)
    store[Value.new(:objkey1)] = Value.new(:objval1)
    store.clear.should equal(store)
    store[Value.new(:objkey2)] = Value.new(:objval2)
    store[Value.new(:objkey2)].should == Value.new(:objval2)
    store[Value.new(:objkey1)].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[Value.new(:objkey2)] = Value.new(:objval2)
    store.delete(Value.new(:objkey2)).should == Value.new(:objval2)
    store.key?(Value.new(:objkey2)).should be_false
  end

  it 'overwrites existing values' do
    store[Value.new(:objkey2)] = Value.new(:objval2)
    store[Value.new(:objkey2)].should == Value.new(:objval2)
    store[Value.new(:objkey2)] = Value.new(:objval1)
    store[Value.new(:objkey2)].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[Value.new(:objkey2)] = Value.new(:objval2)
    store.fetch(Value.new(:objkey2), Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[Value.new(:objkey2)] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(Value.new(:objkey2)) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_objectkey_objectvalue ####################

shared_examples_for 'returndifferent_objectkey_objectvalue' do
  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[Value.new(:objkey1)] = value
    store[Value.new(:objkey1)].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[Value.new(:objkey2)] = value
    store[Value.new(:objkey2)].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[Value.new(:objkey1)] = value
    store[Value.new(:objkey1)].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[Value.new(:objkey2)] = value
    store[Value.new(:objkey2)].should_not be_equal(value)
  end
end

#################### returnsame_objectkey_objectvalue ####################

shared_examples_for 'returnsame_objectkey_objectvalue' do
  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[Value.new(:objkey1)] = value
    store[Value.new(:objkey1)].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[Value.new(:objkey2)] = value
    store[Value.new(:objkey2)].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[Value.new(:objkey1)] = value
    store[Value.new(:objkey1)].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[Value.new(:objkey2)] = value
    store[Value.new(:objkey2)].should be_equal(value)
  end
end

#################### persist_objectkey_objectvalue ####################

shared_examples_for 'persist_objectkey_objectvalue' do
  it 'persists values' do
    store[Value.new(:objkey1)] = Value.new(:objval1)
    store.close
    @store = nil
    store[Value.new(:objkey1)].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[Value.new(:objkey2)] = Value.new(:objval1)
    store.close
    @store = nil
    store[Value.new(:objkey2)].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[Value.new(:objkey1)] = Value.new(:objval2)
    store.close
    @store = nil
    store[Value.new(:objkey1)].should == Value.new(:objval2)
  end

  it 'persists values' do
    store[Value.new(:objkey2)] = Value.new(:objval2)
    store.close
    @store = nil
    store[Value.new(:objkey2)].should == Value.new(:objval2)
  end
end

#################### null_hashkey_nilvalue ####################

shared_examples_for 'null_hashkey_nilvalue' do
  it 'reads from keys like a Hash' do
    store[{"hashkey1"=>"hashkey2"}].should be_nil
    store.load({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[{"hashkey1"=>"hashkey2"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey1"=>"hashkey2"}] = 0
    store[{"hashkey3"=>"hashkey4"}] = nil
    store.clear.should equal(store)
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey1"=>"hashkey2"}, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey1"=>"hashkey2"}
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey1"=>"hashkey2"}, options).should be_false
    store.load({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.fetch({"hashkey1"=>"hashkey2"}, 42, options).should == 42
    store.fetch({"hashkey1"=>"hashkey2"}, options) { 42 }.should == 42
    store.delete({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey1"=>"hashkey2"}, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey3"=>"hashkey4"}].should be_nil
    store.load({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[{"hashkey3"=>"hashkey4"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey3"=>"hashkey4"}] = 0
    store[{"hashkey1"=>"hashkey2"}] = nil
    store.clear.should equal(store)
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey3"=>"hashkey4"}, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey3"=>"hashkey4"}
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey3"=>"hashkey4"}, options).should be_false
    store.load({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.fetch({"hashkey3"=>"hashkey4"}, 42, options).should == 42
    store.fetch({"hashkey3"=>"hashkey4"}, options) { 42 }.should == 42
    store.delete({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey3"=>"hashkey4"}, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey1"=>"hashkey2"}].should be_nil
    store.load({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[{"hashkey1"=>"hashkey2"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey1"=>"hashkey2"}] = nil
    store[{"hashkey3"=>"hashkey4"}] = 0
    store.clear.should equal(store)
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey1"=>"hashkey2"}, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey1"=>"hashkey2"}
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey1"=>"hashkey2"}, options).should be_false
    store.load({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.fetch({"hashkey1"=>"hashkey2"}, 42, options).should == 42
    store.fetch({"hashkey1"=>"hashkey2"}, options) { 42 }.should == 42
    store.delete({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey1"=>"hashkey2"}, nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey3"=>"hashkey4"}].should be_nil
    store.load({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[{"hashkey3"=>"hashkey4"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey3"=>"hashkey4"}] = nil
    store[{"hashkey1"=>"hashkey2"}] = 0
    store.clear.should equal(store)
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey3"=>"hashkey4"}, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey3"=>"hashkey4"}
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey3"=>"hashkey4"}, options).should be_false
    store.load({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.fetch({"hashkey3"=>"hashkey4"}, 42, options).should == 42
    store.fetch({"hashkey3"=>"hashkey4"}, options) { 42 }.should == 42
    store.delete({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey3"=>"hashkey4"}, nil, options).should == nil
  end
end

#################### store_hashkey_nilvalue ####################

shared_examples_for 'store_hashkey_nilvalue' do
  it 'writes values to keys that like a Hash' do
    store[{"hashkey1"=>"hashkey2"}] = 0
    store[{"hashkey1"=>"hashkey2"}].should == 0
    store.load({"hashkey1"=>"hashkey2"}).should == 0
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey1"=>"hashkey2"}] = 0
    store.key?({"hashkey1"=>"hashkey2"}).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store({"hashkey1"=>"hashkey2"}, value).should equal(value)
    store[{"hashkey1"=>"hashkey2"}].should == 0
    store.load({"hashkey1"=>"hashkey2"}).should == 0
  end

  it 'stores values after clear' do
    store[{"hashkey1"=>"hashkey2"}] = 0
    store[{"hashkey3"=>"hashkey4"}] = nil
    store.clear.should equal(store)
    store[{"hashkey1"=>"hashkey2"}] = 0
    store[{"hashkey1"=>"hashkey2"}].should == 0
    store[{"hashkey3"=>"hashkey4"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey1"=>"hashkey2"}] = 0
    store.delete({"hashkey1"=>"hashkey2"}).should == 0
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey1"=>"hashkey2"}] = 0
    store[{"hashkey1"=>"hashkey2"}].should == 0
    store[{"hashkey1"=>"hashkey2"}] = nil
    store[{"hashkey1"=>"hashkey2"}].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey3"=>"hashkey4"}] = 0
    store[{"hashkey3"=>"hashkey4"}].should == 0
    store.load({"hashkey3"=>"hashkey4"}).should == 0
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey3"=>"hashkey4"}] = 0
    store.key?({"hashkey3"=>"hashkey4"}).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store({"hashkey3"=>"hashkey4"}, value).should equal(value)
    store[{"hashkey3"=>"hashkey4"}].should == 0
    store.load({"hashkey3"=>"hashkey4"}).should == 0
  end

  it 'stores values after clear' do
    store[{"hashkey3"=>"hashkey4"}] = 0
    store[{"hashkey1"=>"hashkey2"}] = nil
    store.clear.should equal(store)
    store[{"hashkey3"=>"hashkey4"}] = 0
    store[{"hashkey3"=>"hashkey4"}].should == 0
    store[{"hashkey1"=>"hashkey2"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey3"=>"hashkey4"}] = 0
    store.delete({"hashkey3"=>"hashkey4"}).should == 0
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey3"=>"hashkey4"}] = 0
    store[{"hashkey3"=>"hashkey4"}].should == 0
    store[{"hashkey3"=>"hashkey4"}] = nil
    store[{"hashkey3"=>"hashkey4"}].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey1"=>"hashkey2"}] = nil
    store[{"hashkey1"=>"hashkey2"}].should == nil
    store.load({"hashkey1"=>"hashkey2"}).should == nil
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey1"=>"hashkey2"}] = nil
    store.key?({"hashkey1"=>"hashkey2"}).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store({"hashkey1"=>"hashkey2"}, value).should equal(value)
    store[{"hashkey1"=>"hashkey2"}].should == nil
    store.load({"hashkey1"=>"hashkey2"}).should == nil
  end

  it 'stores values after clear' do
    store[{"hashkey1"=>"hashkey2"}] = nil
    store[{"hashkey3"=>"hashkey4"}] = 0
    store.clear.should equal(store)
    store[{"hashkey1"=>"hashkey2"}] = nil
    store[{"hashkey1"=>"hashkey2"}].should == nil
    store[{"hashkey3"=>"hashkey4"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey1"=>"hashkey2"}] = nil
    store.delete({"hashkey1"=>"hashkey2"}).should == nil
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey1"=>"hashkey2"}] = nil
    store[{"hashkey1"=>"hashkey2"}].should == nil
    store[{"hashkey1"=>"hashkey2"}] = 0
    store[{"hashkey1"=>"hashkey2"}].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey3"=>"hashkey4"}] = nil
    store[{"hashkey3"=>"hashkey4"}].should == nil
    store.load({"hashkey3"=>"hashkey4"}).should == nil
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey3"=>"hashkey4"}] = nil
    store.key?({"hashkey3"=>"hashkey4"}).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store({"hashkey3"=>"hashkey4"}, value).should equal(value)
    store[{"hashkey3"=>"hashkey4"}].should == nil
    store.load({"hashkey3"=>"hashkey4"}).should == nil
  end

  it 'stores values after clear' do
    store[{"hashkey3"=>"hashkey4"}] = nil
    store[{"hashkey1"=>"hashkey2"}] = 0
    store.clear.should equal(store)
    store[{"hashkey3"=>"hashkey4"}] = nil
    store[{"hashkey3"=>"hashkey4"}].should == nil
    store[{"hashkey1"=>"hashkey2"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey3"=>"hashkey4"}] = nil
    store.delete({"hashkey3"=>"hashkey4"}).should == nil
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey3"=>"hashkey4"}] = nil
    store[{"hashkey3"=>"hashkey4"}].should == nil
    store[{"hashkey3"=>"hashkey4"}] = 0
    store[{"hashkey3"=>"hashkey4"}].should == 0
  end
end

#################### persist_hashkey_nilvalue ####################

shared_examples_for 'persist_hashkey_nilvalue' do
  it 'persists values' do
    store[{"hashkey1"=>"hashkey2"}] = 0
    store.close
    @store = nil
    store[{"hashkey1"=>"hashkey2"}].should == 0
  end

  it 'persists values' do
    store[{"hashkey3"=>"hashkey4"}] = 0
    store.close
    @store = nil
    store[{"hashkey3"=>"hashkey4"}].should == 0
  end

  it 'persists values' do
    store[{"hashkey1"=>"hashkey2"}] = nil
    store.close
    @store = nil
    store[{"hashkey1"=>"hashkey2"}].should == nil
  end

  it 'persists values' do
    store[{"hashkey3"=>"hashkey4"}] = nil
    store.close
    @store = nil
    store[{"hashkey3"=>"hashkey4"}].should == nil
  end
end

#################### null_hashkey_integervalue ####################

shared_examples_for 'null_hashkey_integervalue' do
  it 'reads from keys like a Hash' do
    store[{"hashkey1"=>"hashkey2"}].should be_nil
    store.load({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[{"hashkey1"=>"hashkey2"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey1"=>"hashkey2"}] = 41
    store[{"hashkey3"=>"hashkey4"}] = -12
    store.clear.should equal(store)
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey1"=>"hashkey2"}, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey1"=>"hashkey2"}
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey1"=>"hashkey2"}, options).should be_false
    store.load({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.fetch({"hashkey1"=>"hashkey2"}, 42, options).should == 42
    store.fetch({"hashkey1"=>"hashkey2"}, options) { 42 }.should == 42
    store.delete({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey1"=>"hashkey2"}, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey3"=>"hashkey4"}].should be_nil
    store.load({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[{"hashkey3"=>"hashkey4"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey3"=>"hashkey4"}] = 41
    store[{"hashkey1"=>"hashkey2"}] = -12
    store.clear.should equal(store)
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey3"=>"hashkey4"}, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey3"=>"hashkey4"}
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey3"=>"hashkey4"}, options).should be_false
    store.load({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.fetch({"hashkey3"=>"hashkey4"}, 42, options).should == 42
    store.fetch({"hashkey3"=>"hashkey4"}, options) { 42 }.should == 42
    store.delete({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey3"=>"hashkey4"}, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey1"=>"hashkey2"}].should be_nil
    store.load({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[{"hashkey1"=>"hashkey2"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey1"=>"hashkey2"}] = -12
    store[{"hashkey3"=>"hashkey4"}] = 41
    store.clear.should equal(store)
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey1"=>"hashkey2"}, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey1"=>"hashkey2"}
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey1"=>"hashkey2"}, options).should be_false
    store.load({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.fetch({"hashkey1"=>"hashkey2"}, 42, options).should == 42
    store.fetch({"hashkey1"=>"hashkey2"}, options) { 42 }.should == 42
    store.delete({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey1"=>"hashkey2"}, -12, options).should == -12
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey3"=>"hashkey4"}].should be_nil
    store.load({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[{"hashkey3"=>"hashkey4"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey3"=>"hashkey4"}] = -12
    store[{"hashkey1"=>"hashkey2"}] = 41
    store.clear.should equal(store)
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey3"=>"hashkey4"}, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey3"=>"hashkey4"}
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey3"=>"hashkey4"}, options).should be_false
    store.load({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.fetch({"hashkey3"=>"hashkey4"}, 42, options).should == 42
    store.fetch({"hashkey3"=>"hashkey4"}, options) { 42 }.should == 42
    store.delete({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey3"=>"hashkey4"}, -12, options).should == -12
  end
end

#################### store_hashkey_integervalue ####################

shared_examples_for 'store_hashkey_integervalue' do
  it 'writes values to keys that like a Hash' do
    store[{"hashkey1"=>"hashkey2"}] = 41
    store[{"hashkey1"=>"hashkey2"}].should == 41
    store.load({"hashkey1"=>"hashkey2"}).should == 41
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey1"=>"hashkey2"}] = 41
    store.key?({"hashkey1"=>"hashkey2"}).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store({"hashkey1"=>"hashkey2"}, value).should equal(value)
    store[{"hashkey1"=>"hashkey2"}].should == 41
    store.load({"hashkey1"=>"hashkey2"}).should == 41
  end

  it 'stores values after clear' do
    store[{"hashkey1"=>"hashkey2"}] = 41
    store[{"hashkey3"=>"hashkey4"}] = -12
    store.clear.should equal(store)
    store[{"hashkey1"=>"hashkey2"}] = 41
    store[{"hashkey1"=>"hashkey2"}].should == 41
    store[{"hashkey3"=>"hashkey4"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey1"=>"hashkey2"}] = 41
    store.delete({"hashkey1"=>"hashkey2"}).should == 41
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey1"=>"hashkey2"}] = 41
    store[{"hashkey1"=>"hashkey2"}].should == 41
    store[{"hashkey1"=>"hashkey2"}] = -12
    store[{"hashkey1"=>"hashkey2"}].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = 41
    store.fetch({"hashkey1"=>"hashkey2"}, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = 41
    unaltered = 'unaltered'
    store.fetch({"hashkey1"=>"hashkey2"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey3"=>"hashkey4"}] = 41
    store[{"hashkey3"=>"hashkey4"}].should == 41
    store.load({"hashkey3"=>"hashkey4"}).should == 41
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey3"=>"hashkey4"}] = 41
    store.key?({"hashkey3"=>"hashkey4"}).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store({"hashkey3"=>"hashkey4"}, value).should equal(value)
    store[{"hashkey3"=>"hashkey4"}].should == 41
    store.load({"hashkey3"=>"hashkey4"}).should == 41
  end

  it 'stores values after clear' do
    store[{"hashkey3"=>"hashkey4"}] = 41
    store[{"hashkey1"=>"hashkey2"}] = -12
    store.clear.should equal(store)
    store[{"hashkey3"=>"hashkey4"}] = 41
    store[{"hashkey3"=>"hashkey4"}].should == 41
    store[{"hashkey1"=>"hashkey2"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey3"=>"hashkey4"}] = 41
    store.delete({"hashkey3"=>"hashkey4"}).should == 41
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey3"=>"hashkey4"}] = 41
    store[{"hashkey3"=>"hashkey4"}].should == 41
    store[{"hashkey3"=>"hashkey4"}] = -12
    store[{"hashkey3"=>"hashkey4"}].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = 41
    store.fetch({"hashkey3"=>"hashkey4"}, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = 41
    unaltered = 'unaltered'
    store.fetch({"hashkey3"=>"hashkey4"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey1"=>"hashkey2"}] = -12
    store[{"hashkey1"=>"hashkey2"}].should == -12
    store.load({"hashkey1"=>"hashkey2"}).should == -12
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey1"=>"hashkey2"}] = -12
    store.key?({"hashkey1"=>"hashkey2"}).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store({"hashkey1"=>"hashkey2"}, value).should equal(value)
    store[{"hashkey1"=>"hashkey2"}].should == -12
    store.load({"hashkey1"=>"hashkey2"}).should == -12
  end

  it 'stores values after clear' do
    store[{"hashkey1"=>"hashkey2"}] = -12
    store[{"hashkey3"=>"hashkey4"}] = 41
    store.clear.should equal(store)
    store[{"hashkey1"=>"hashkey2"}] = -12
    store[{"hashkey1"=>"hashkey2"}].should == -12
    store[{"hashkey3"=>"hashkey4"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey1"=>"hashkey2"}] = -12
    store.delete({"hashkey1"=>"hashkey2"}).should == -12
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey1"=>"hashkey2"}] = -12
    store[{"hashkey1"=>"hashkey2"}].should == -12
    store[{"hashkey1"=>"hashkey2"}] = 41
    store[{"hashkey1"=>"hashkey2"}].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = -12
    store.fetch({"hashkey1"=>"hashkey2"}, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = -12
    unaltered = 'unaltered'
    store.fetch({"hashkey1"=>"hashkey2"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey3"=>"hashkey4"}] = -12
    store[{"hashkey3"=>"hashkey4"}].should == -12
    store.load({"hashkey3"=>"hashkey4"}).should == -12
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey3"=>"hashkey4"}] = -12
    store.key?({"hashkey3"=>"hashkey4"}).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store({"hashkey3"=>"hashkey4"}, value).should equal(value)
    store[{"hashkey3"=>"hashkey4"}].should == -12
    store.load({"hashkey3"=>"hashkey4"}).should == -12
  end

  it 'stores values after clear' do
    store[{"hashkey3"=>"hashkey4"}] = -12
    store[{"hashkey1"=>"hashkey2"}] = 41
    store.clear.should equal(store)
    store[{"hashkey3"=>"hashkey4"}] = -12
    store[{"hashkey3"=>"hashkey4"}].should == -12
    store[{"hashkey1"=>"hashkey2"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey3"=>"hashkey4"}] = -12
    store.delete({"hashkey3"=>"hashkey4"}).should == -12
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey3"=>"hashkey4"}] = -12
    store[{"hashkey3"=>"hashkey4"}].should == -12
    store[{"hashkey3"=>"hashkey4"}] = 41
    store[{"hashkey3"=>"hashkey4"}].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = -12
    store.fetch({"hashkey3"=>"hashkey4"}, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = -12
    unaltered = 'unaltered'
    store.fetch({"hashkey3"=>"hashkey4"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_hashkey_integervalue ####################

shared_examples_for 'persist_hashkey_integervalue' do
  it 'persists values' do
    store[{"hashkey1"=>"hashkey2"}] = 41
    store.close
    @store = nil
    store[{"hashkey1"=>"hashkey2"}].should == 41
  end

  it 'persists values' do
    store[{"hashkey3"=>"hashkey4"}] = 41
    store.close
    @store = nil
    store[{"hashkey3"=>"hashkey4"}].should == 41
  end

  it 'persists values' do
    store[{"hashkey1"=>"hashkey2"}] = -12
    store.close
    @store = nil
    store[{"hashkey1"=>"hashkey2"}].should == -12
  end

  it 'persists values' do
    store[{"hashkey3"=>"hashkey4"}] = -12
    store.close
    @store = nil
    store[{"hashkey3"=>"hashkey4"}].should == -12
  end
end

#################### null_hashkey_booleanvalue ####################

shared_examples_for 'null_hashkey_booleanvalue' do
  it 'reads from keys like a Hash' do
    store[{"hashkey1"=>"hashkey2"}].should be_nil
    store.load({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[{"hashkey1"=>"hashkey2"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey1"=>"hashkey2"}] = true
    store[{"hashkey3"=>"hashkey4"}] = false
    store.clear.should equal(store)
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey1"=>"hashkey2"}, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey1"=>"hashkey2"}
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey1"=>"hashkey2"}, options).should be_false
    store.load({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.fetch({"hashkey1"=>"hashkey2"}, 42, options).should == 42
    store.fetch({"hashkey1"=>"hashkey2"}, options) { 42 }.should == 42
    store.delete({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey1"=>"hashkey2"}, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey3"=>"hashkey4"}].should be_nil
    store.load({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[{"hashkey3"=>"hashkey4"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey3"=>"hashkey4"}] = true
    store[{"hashkey1"=>"hashkey2"}] = false
    store.clear.should equal(store)
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey3"=>"hashkey4"}, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey3"=>"hashkey4"}
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey3"=>"hashkey4"}, options).should be_false
    store.load({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.fetch({"hashkey3"=>"hashkey4"}, 42, options).should == 42
    store.fetch({"hashkey3"=>"hashkey4"}, options) { 42 }.should == 42
    store.delete({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey3"=>"hashkey4"}, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey1"=>"hashkey2"}].should be_nil
    store.load({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[{"hashkey1"=>"hashkey2"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey1"=>"hashkey2"}] = false
    store[{"hashkey3"=>"hashkey4"}] = true
    store.clear.should equal(store)
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey1"=>"hashkey2"}, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey1"=>"hashkey2"}
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey1"=>"hashkey2"}, options).should be_false
    store.load({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.fetch({"hashkey1"=>"hashkey2"}, 42, options).should == 42
    store.fetch({"hashkey1"=>"hashkey2"}, options) { 42 }.should == 42
    store.delete({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey1"=>"hashkey2"}, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey3"=>"hashkey4"}].should be_nil
    store.load({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[{"hashkey3"=>"hashkey4"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey3"=>"hashkey4"}] = false
    store[{"hashkey1"=>"hashkey2"}] = true
    store.clear.should equal(store)
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey3"=>"hashkey4"}, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey3"=>"hashkey4"}
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey3"=>"hashkey4"}, options).should be_false
    store.load({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.fetch({"hashkey3"=>"hashkey4"}, 42, options).should == 42
    store.fetch({"hashkey3"=>"hashkey4"}, options) { 42 }.should == 42
    store.delete({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey3"=>"hashkey4"}, false, options).should == false
  end
end

#################### store_hashkey_booleanvalue ####################

shared_examples_for 'store_hashkey_booleanvalue' do
  it 'writes values to keys that like a Hash' do
    store[{"hashkey1"=>"hashkey2"}] = true
    store[{"hashkey1"=>"hashkey2"}].should == true
    store.load({"hashkey1"=>"hashkey2"}).should == true
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey1"=>"hashkey2"}] = true
    store.key?({"hashkey1"=>"hashkey2"}).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store({"hashkey1"=>"hashkey2"}, value).should equal(value)
    store[{"hashkey1"=>"hashkey2"}].should == true
    store.load({"hashkey1"=>"hashkey2"}).should == true
  end

  it 'stores values after clear' do
    store[{"hashkey1"=>"hashkey2"}] = true
    store[{"hashkey3"=>"hashkey4"}] = false
    store.clear.should equal(store)
    store[{"hashkey1"=>"hashkey2"}] = true
    store[{"hashkey1"=>"hashkey2"}].should == true
    store[{"hashkey3"=>"hashkey4"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey1"=>"hashkey2"}] = true
    store.delete({"hashkey1"=>"hashkey2"}).should == true
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey1"=>"hashkey2"}] = true
    store[{"hashkey1"=>"hashkey2"}].should == true
    store[{"hashkey1"=>"hashkey2"}] = false
    store[{"hashkey1"=>"hashkey2"}].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = true
    store.fetch({"hashkey1"=>"hashkey2"}, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = true
    unaltered = 'unaltered'
    store.fetch({"hashkey1"=>"hashkey2"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey3"=>"hashkey4"}] = true
    store[{"hashkey3"=>"hashkey4"}].should == true
    store.load({"hashkey3"=>"hashkey4"}).should == true
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey3"=>"hashkey4"}] = true
    store.key?({"hashkey3"=>"hashkey4"}).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store({"hashkey3"=>"hashkey4"}, value).should equal(value)
    store[{"hashkey3"=>"hashkey4"}].should == true
    store.load({"hashkey3"=>"hashkey4"}).should == true
  end

  it 'stores values after clear' do
    store[{"hashkey3"=>"hashkey4"}] = true
    store[{"hashkey1"=>"hashkey2"}] = false
    store.clear.should equal(store)
    store[{"hashkey3"=>"hashkey4"}] = true
    store[{"hashkey3"=>"hashkey4"}].should == true
    store[{"hashkey1"=>"hashkey2"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey3"=>"hashkey4"}] = true
    store.delete({"hashkey3"=>"hashkey4"}).should == true
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey3"=>"hashkey4"}] = true
    store[{"hashkey3"=>"hashkey4"}].should == true
    store[{"hashkey3"=>"hashkey4"}] = false
    store[{"hashkey3"=>"hashkey4"}].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = true
    store.fetch({"hashkey3"=>"hashkey4"}, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = true
    unaltered = 'unaltered'
    store.fetch({"hashkey3"=>"hashkey4"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey1"=>"hashkey2"}] = false
    store[{"hashkey1"=>"hashkey2"}].should == false
    store.load({"hashkey1"=>"hashkey2"}).should == false
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey1"=>"hashkey2"}] = false
    store.key?({"hashkey1"=>"hashkey2"}).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store({"hashkey1"=>"hashkey2"}, value).should equal(value)
    store[{"hashkey1"=>"hashkey2"}].should == false
    store.load({"hashkey1"=>"hashkey2"}).should == false
  end

  it 'stores values after clear' do
    store[{"hashkey1"=>"hashkey2"}] = false
    store[{"hashkey3"=>"hashkey4"}] = true
    store.clear.should equal(store)
    store[{"hashkey1"=>"hashkey2"}] = false
    store[{"hashkey1"=>"hashkey2"}].should == false
    store[{"hashkey3"=>"hashkey4"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey1"=>"hashkey2"}] = false
    store.delete({"hashkey1"=>"hashkey2"}).should == false
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey1"=>"hashkey2"}] = false
    store[{"hashkey1"=>"hashkey2"}].should == false
    store[{"hashkey1"=>"hashkey2"}] = true
    store[{"hashkey1"=>"hashkey2"}].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = false
    store.fetch({"hashkey1"=>"hashkey2"}, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = false
    unaltered = 'unaltered'
    store.fetch({"hashkey1"=>"hashkey2"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey3"=>"hashkey4"}] = false
    store[{"hashkey3"=>"hashkey4"}].should == false
    store.load({"hashkey3"=>"hashkey4"}).should == false
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey3"=>"hashkey4"}] = false
    store.key?({"hashkey3"=>"hashkey4"}).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store({"hashkey3"=>"hashkey4"}, value).should equal(value)
    store[{"hashkey3"=>"hashkey4"}].should == false
    store.load({"hashkey3"=>"hashkey4"}).should == false
  end

  it 'stores values after clear' do
    store[{"hashkey3"=>"hashkey4"}] = false
    store[{"hashkey1"=>"hashkey2"}] = true
    store.clear.should equal(store)
    store[{"hashkey3"=>"hashkey4"}] = false
    store[{"hashkey3"=>"hashkey4"}].should == false
    store[{"hashkey1"=>"hashkey2"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey3"=>"hashkey4"}] = false
    store.delete({"hashkey3"=>"hashkey4"}).should == false
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey3"=>"hashkey4"}] = false
    store[{"hashkey3"=>"hashkey4"}].should == false
    store[{"hashkey3"=>"hashkey4"}] = true
    store[{"hashkey3"=>"hashkey4"}].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = false
    store.fetch({"hashkey3"=>"hashkey4"}, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = false
    unaltered = 'unaltered'
    store.fetch({"hashkey3"=>"hashkey4"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_hashkey_booleanvalue ####################

shared_examples_for 'persist_hashkey_booleanvalue' do
  it 'persists values' do
    store[{"hashkey1"=>"hashkey2"}] = true
    store.close
    @store = nil
    store[{"hashkey1"=>"hashkey2"}].should == true
  end

  it 'persists values' do
    store[{"hashkey3"=>"hashkey4"}] = true
    store.close
    @store = nil
    store[{"hashkey3"=>"hashkey4"}].should == true
  end

  it 'persists values' do
    store[{"hashkey1"=>"hashkey2"}] = false
    store.close
    @store = nil
    store[{"hashkey1"=>"hashkey2"}].should == false
  end

  it 'persists values' do
    store[{"hashkey3"=>"hashkey4"}] = false
    store.close
    @store = nil
    store[{"hashkey3"=>"hashkey4"}].should == false
  end
end

#################### null_hashkey_stringvalue ####################

shared_examples_for 'null_hashkey_stringvalue' do
  it 'reads from keys like a Hash' do
    store[{"hashkey1"=>"hashkey2"}].should be_nil
    store.load({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[{"hashkey1"=>"hashkey2"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey1"=>"hashkey2"}] = "strval1"
    store[{"hashkey3"=>"hashkey4"}] = "strval2"
    store.clear.should equal(store)
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey1"=>"hashkey2"}, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey1"=>"hashkey2"}
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey1"=>"hashkey2"}, options).should be_false
    store.load({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.fetch({"hashkey1"=>"hashkey2"}, 42, options).should == 42
    store.fetch({"hashkey1"=>"hashkey2"}, options) { 42 }.should == 42
    store.delete({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey1"=>"hashkey2"}, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey3"=>"hashkey4"}].should be_nil
    store.load({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[{"hashkey3"=>"hashkey4"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey3"=>"hashkey4"}] = "strval1"
    store[{"hashkey1"=>"hashkey2"}] = "strval2"
    store.clear.should equal(store)
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey3"=>"hashkey4"}, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey3"=>"hashkey4"}
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey3"=>"hashkey4"}, options).should be_false
    store.load({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.fetch({"hashkey3"=>"hashkey4"}, 42, options).should == 42
    store.fetch({"hashkey3"=>"hashkey4"}, options) { 42 }.should == 42
    store.delete({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey3"=>"hashkey4"}, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey1"=>"hashkey2"}].should be_nil
    store.load({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[{"hashkey1"=>"hashkey2"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey1"=>"hashkey2"}] = "strval2"
    store[{"hashkey3"=>"hashkey4"}] = "strval1"
    store.clear.should equal(store)
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey1"=>"hashkey2"}, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey1"=>"hashkey2"}
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey1"=>"hashkey2"}, options).should be_false
    store.load({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.fetch({"hashkey1"=>"hashkey2"}, 42, options).should == 42
    store.fetch({"hashkey1"=>"hashkey2"}, options) { 42 }.should == 42
    store.delete({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey1"=>"hashkey2"}, "strval2", options).should == "strval2"
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey3"=>"hashkey4"}].should be_nil
    store.load({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[{"hashkey3"=>"hashkey4"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey3"=>"hashkey4"}] = "strval2"
    store[{"hashkey1"=>"hashkey2"}] = "strval1"
    store.clear.should equal(store)
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey3"=>"hashkey4"}, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey3"=>"hashkey4"}
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey3"=>"hashkey4"}, options).should be_false
    store.load({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.fetch({"hashkey3"=>"hashkey4"}, 42, options).should == 42
    store.fetch({"hashkey3"=>"hashkey4"}, options) { 42 }.should == 42
    store.delete({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey3"=>"hashkey4"}, "strval2", options).should == "strval2"
  end
end

#################### store_hashkey_stringvalue ####################

shared_examples_for 'store_hashkey_stringvalue' do
  it 'writes values to keys that like a Hash' do
    store[{"hashkey1"=>"hashkey2"}] = "strval1"
    store[{"hashkey1"=>"hashkey2"}].should == "strval1"
    store.load({"hashkey1"=>"hashkey2"}).should == "strval1"
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey1"=>"hashkey2"}] = "strval1"
    store.key?({"hashkey1"=>"hashkey2"}).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store({"hashkey1"=>"hashkey2"}, value).should equal(value)
    store[{"hashkey1"=>"hashkey2"}].should == "strval1"
    store.load({"hashkey1"=>"hashkey2"}).should == "strval1"
  end

  it 'stores values after clear' do
    store[{"hashkey1"=>"hashkey2"}] = "strval1"
    store[{"hashkey3"=>"hashkey4"}] = "strval2"
    store.clear.should equal(store)
    store[{"hashkey1"=>"hashkey2"}] = "strval1"
    store[{"hashkey1"=>"hashkey2"}].should == "strval1"
    store[{"hashkey3"=>"hashkey4"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey1"=>"hashkey2"}] = "strval1"
    store.delete({"hashkey1"=>"hashkey2"}).should == "strval1"
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey1"=>"hashkey2"}] = "strval1"
    store[{"hashkey1"=>"hashkey2"}].should == "strval1"
    store[{"hashkey1"=>"hashkey2"}] = "strval2"
    store[{"hashkey1"=>"hashkey2"}].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = "strval1"
    store.fetch({"hashkey1"=>"hashkey2"}, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = "strval1"
    unaltered = 'unaltered'
    store.fetch({"hashkey1"=>"hashkey2"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey3"=>"hashkey4"}] = "strval1"
    store[{"hashkey3"=>"hashkey4"}].should == "strval1"
    store.load({"hashkey3"=>"hashkey4"}).should == "strval1"
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey3"=>"hashkey4"}] = "strval1"
    store.key?({"hashkey3"=>"hashkey4"}).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store({"hashkey3"=>"hashkey4"}, value).should equal(value)
    store[{"hashkey3"=>"hashkey4"}].should == "strval1"
    store.load({"hashkey3"=>"hashkey4"}).should == "strval1"
  end

  it 'stores values after clear' do
    store[{"hashkey3"=>"hashkey4"}] = "strval1"
    store[{"hashkey1"=>"hashkey2"}] = "strval2"
    store.clear.should equal(store)
    store[{"hashkey3"=>"hashkey4"}] = "strval1"
    store[{"hashkey3"=>"hashkey4"}].should == "strval1"
    store[{"hashkey1"=>"hashkey2"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey3"=>"hashkey4"}] = "strval1"
    store.delete({"hashkey3"=>"hashkey4"}).should == "strval1"
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey3"=>"hashkey4"}] = "strval1"
    store[{"hashkey3"=>"hashkey4"}].should == "strval1"
    store[{"hashkey3"=>"hashkey4"}] = "strval2"
    store[{"hashkey3"=>"hashkey4"}].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = "strval1"
    store.fetch({"hashkey3"=>"hashkey4"}, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = "strval1"
    unaltered = 'unaltered'
    store.fetch({"hashkey3"=>"hashkey4"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey1"=>"hashkey2"}] = "strval2"
    store[{"hashkey1"=>"hashkey2"}].should == "strval2"
    store.load({"hashkey1"=>"hashkey2"}).should == "strval2"
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey1"=>"hashkey2"}] = "strval2"
    store.key?({"hashkey1"=>"hashkey2"}).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store({"hashkey1"=>"hashkey2"}, value).should equal(value)
    store[{"hashkey1"=>"hashkey2"}].should == "strval2"
    store.load({"hashkey1"=>"hashkey2"}).should == "strval2"
  end

  it 'stores values after clear' do
    store[{"hashkey1"=>"hashkey2"}] = "strval2"
    store[{"hashkey3"=>"hashkey4"}] = "strval1"
    store.clear.should equal(store)
    store[{"hashkey1"=>"hashkey2"}] = "strval2"
    store[{"hashkey1"=>"hashkey2"}].should == "strval2"
    store[{"hashkey3"=>"hashkey4"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey1"=>"hashkey2"}] = "strval2"
    store.delete({"hashkey1"=>"hashkey2"}).should == "strval2"
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey1"=>"hashkey2"}] = "strval2"
    store[{"hashkey1"=>"hashkey2"}].should == "strval2"
    store[{"hashkey1"=>"hashkey2"}] = "strval1"
    store[{"hashkey1"=>"hashkey2"}].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = "strval2"
    store.fetch({"hashkey1"=>"hashkey2"}, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = "strval2"
    unaltered = 'unaltered'
    store.fetch({"hashkey1"=>"hashkey2"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey3"=>"hashkey4"}] = "strval2"
    store[{"hashkey3"=>"hashkey4"}].should == "strval2"
    store.load({"hashkey3"=>"hashkey4"}).should == "strval2"
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey3"=>"hashkey4"}] = "strval2"
    store.key?({"hashkey3"=>"hashkey4"}).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store({"hashkey3"=>"hashkey4"}, value).should equal(value)
    store[{"hashkey3"=>"hashkey4"}].should == "strval2"
    store.load({"hashkey3"=>"hashkey4"}).should == "strval2"
  end

  it 'stores values after clear' do
    store[{"hashkey3"=>"hashkey4"}] = "strval2"
    store[{"hashkey1"=>"hashkey2"}] = "strval1"
    store.clear.should equal(store)
    store[{"hashkey3"=>"hashkey4"}] = "strval2"
    store[{"hashkey3"=>"hashkey4"}].should == "strval2"
    store[{"hashkey1"=>"hashkey2"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey3"=>"hashkey4"}] = "strval2"
    store.delete({"hashkey3"=>"hashkey4"}).should == "strval2"
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey3"=>"hashkey4"}] = "strval2"
    store[{"hashkey3"=>"hashkey4"}].should == "strval2"
    store[{"hashkey3"=>"hashkey4"}] = "strval1"
    store[{"hashkey3"=>"hashkey4"}].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = "strval2"
    store.fetch({"hashkey3"=>"hashkey4"}, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = "strval2"
    unaltered = 'unaltered'
    store.fetch({"hashkey3"=>"hashkey4"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_hashkey_stringvalue ####################

shared_examples_for 'returndifferent_hashkey_stringvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[{"hashkey1"=>"hashkey2"}] = value
    store[{"hashkey1"=>"hashkey2"}].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[{"hashkey3"=>"hashkey4"}] = value
    store[{"hashkey3"=>"hashkey4"}].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[{"hashkey1"=>"hashkey2"}] = value
    store[{"hashkey1"=>"hashkey2"}].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[{"hashkey3"=>"hashkey4"}] = value
    store[{"hashkey3"=>"hashkey4"}].should_not be_equal(value)
  end
end

#################### returnsame_hashkey_stringvalue ####################

shared_examples_for 'returnsame_hashkey_stringvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[{"hashkey1"=>"hashkey2"}] = value
    store[{"hashkey1"=>"hashkey2"}].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[{"hashkey3"=>"hashkey4"}] = value
    store[{"hashkey3"=>"hashkey4"}].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[{"hashkey1"=>"hashkey2"}] = value
    store[{"hashkey1"=>"hashkey2"}].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[{"hashkey3"=>"hashkey4"}] = value
    store[{"hashkey3"=>"hashkey4"}].should be_equal(value)
  end
end

#################### persist_hashkey_stringvalue ####################

shared_examples_for 'persist_hashkey_stringvalue' do
  it 'persists values' do
    store[{"hashkey1"=>"hashkey2"}] = "strval1"
    store.close
    @store = nil
    store[{"hashkey1"=>"hashkey2"}].should == "strval1"
  end

  it 'persists values' do
    store[{"hashkey3"=>"hashkey4"}] = "strval1"
    store.close
    @store = nil
    store[{"hashkey3"=>"hashkey4"}].should == "strval1"
  end

  it 'persists values' do
    store[{"hashkey1"=>"hashkey2"}] = "strval2"
    store.close
    @store = nil
    store[{"hashkey1"=>"hashkey2"}].should == "strval2"
  end

  it 'persists values' do
    store[{"hashkey3"=>"hashkey4"}] = "strval2"
    store.close
    @store = nil
    store[{"hashkey3"=>"hashkey4"}].should == "strval2"
  end
end

#################### null_hashkey_hashvalue ####################

shared_examples_for 'null_hashkey_hashvalue' do
  it 'reads from keys like a Hash' do
    store[{"hashkey1"=>"hashkey2"}].should be_nil
    store.load({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[{"hashkey1"=>"hashkey2"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval1"=>["array1", 1]}
    store[{"hashkey3"=>"hashkey4"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey1"=>"hashkey2"}, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey1"=>"hashkey2"}
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey1"=>"hashkey2"}, options).should be_false
    store.load({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.fetch({"hashkey1"=>"hashkey2"}, 42, options).should == 42
    store.fetch({"hashkey1"=>"hashkey2"}, options) { 42 }.should == 42
    store.delete({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey1"=>"hashkey2"}, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey3"=>"hashkey4"}].should be_nil
    store.load({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[{"hashkey3"=>"hashkey4"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval1"=>["array1", 1]}
    store[{"hashkey1"=>"hashkey2"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey3"=>"hashkey4"}, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey3"=>"hashkey4"}
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey3"=>"hashkey4"}, options).should be_false
    store.load({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.fetch({"hashkey3"=>"hashkey4"}, 42, options).should == 42
    store.fetch({"hashkey3"=>"hashkey4"}, options) { 42 }.should == 42
    store.delete({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey3"=>"hashkey4"}, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey1"=>"hashkey2"}].should be_nil
    store.load({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[{"hashkey1"=>"hashkey2"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey3"=>"hashkey4"}] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey1"=>"hashkey2"}, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey1"=>"hashkey2"}
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey1"=>"hashkey2"}, options).should be_false
    store.load({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.fetch({"hashkey1"=>"hashkey2"}, 42, options).should == 42
    store.fetch({"hashkey1"=>"hashkey2"}, options) { 42 }.should == 42
    store.delete({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey1"=>"hashkey2"}, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey3"=>"hashkey4"}].should be_nil
    store.load({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[{"hashkey3"=>"hashkey4"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey1"=>"hashkey2"}] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey3"=>"hashkey4"}, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey3"=>"hashkey4"}
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey3"=>"hashkey4"}, options).should be_false
    store.load({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.fetch({"hashkey3"=>"hashkey4"}, 42, options).should == 42
    store.fetch({"hashkey3"=>"hashkey4"}, options) { 42 }.should == 42
    store.delete({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey3"=>"hashkey4"}, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### store_hashkey_hashvalue ####################

shared_examples_for 'store_hashkey_hashvalue' do
  it 'writes values to keys that like a Hash' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval1"=>["array1", 1]}
    store[{"hashkey1"=>"hashkey2"}].should == {"hashval1"=>["array1", 1]}
    store.load({"hashkey1"=>"hashkey2"}).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval1"=>["array1", 1]}
    store.key?({"hashkey1"=>"hashkey2"}).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store({"hashkey1"=>"hashkey2"}, value).should equal(value)
    store[{"hashkey1"=>"hashkey2"}].should == {"hashval1"=>["array1", 1]}
    store.load({"hashkey1"=>"hashkey2"}).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval1"=>["array1", 1]}
    store[{"hashkey3"=>"hashkey4"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[{"hashkey1"=>"hashkey2"}] = {"hashval1"=>["array1", 1]}
    store[{"hashkey1"=>"hashkey2"}].should == {"hashval1"=>["array1", 1]}
    store[{"hashkey3"=>"hashkey4"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval1"=>["array1", 1]}
    store.delete({"hashkey1"=>"hashkey2"}).should == {"hashval1"=>["array1", 1]}
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval1"=>["array1", 1]}
    store[{"hashkey1"=>"hashkey2"}].should == {"hashval1"=>["array1", 1]}
    store[{"hashkey1"=>"hashkey2"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey1"=>"hashkey2"}].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval1"=>["array1", 1]}
    store.fetch({"hashkey1"=>"hashkey2"}, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch({"hashkey1"=>"hashkey2"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval1"=>["array1", 1]}
    store[{"hashkey3"=>"hashkey4"}].should == {"hashval1"=>["array1", 1]}
    store.load({"hashkey3"=>"hashkey4"}).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval1"=>["array1", 1]}
    store.key?({"hashkey3"=>"hashkey4"}).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store({"hashkey3"=>"hashkey4"}, value).should equal(value)
    store[{"hashkey3"=>"hashkey4"}].should == {"hashval1"=>["array1", 1]}
    store.load({"hashkey3"=>"hashkey4"}).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval1"=>["array1", 1]}
    store[{"hashkey1"=>"hashkey2"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[{"hashkey3"=>"hashkey4"}] = {"hashval1"=>["array1", 1]}
    store[{"hashkey3"=>"hashkey4"}].should == {"hashval1"=>["array1", 1]}
    store[{"hashkey1"=>"hashkey2"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval1"=>["array1", 1]}
    store.delete({"hashkey3"=>"hashkey4"}).should == {"hashval1"=>["array1", 1]}
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval1"=>["array1", 1]}
    store[{"hashkey3"=>"hashkey4"}].should == {"hashval1"=>["array1", 1]}
    store[{"hashkey3"=>"hashkey4"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey3"=>"hashkey4"}].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval1"=>["array1", 1]}
    store.fetch({"hashkey3"=>"hashkey4"}, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch({"hashkey3"=>"hashkey4"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey1"=>"hashkey2"}].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load({"hashkey1"=>"hashkey2"}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?({"hashkey1"=>"hashkey2"}).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store({"hashkey1"=>"hashkey2"}, value).should equal(value)
    store[{"hashkey1"=>"hashkey2"}].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load({"hashkey1"=>"hashkey2"}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey3"=>"hashkey4"}] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[{"hashkey1"=>"hashkey2"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey1"=>"hashkey2"}].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey3"=>"hashkey4"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete({"hashkey1"=>"hashkey2"}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey1"=>"hashkey2"}].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey1"=>"hashkey2"}] = {"hashval1"=>["array1", 1]}
    store[{"hashkey1"=>"hashkey2"}].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch({"hashkey1"=>"hashkey2"}, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch({"hashkey1"=>"hashkey2"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey3"=>"hashkey4"}].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load({"hashkey3"=>"hashkey4"}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?({"hashkey3"=>"hashkey4"}).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store({"hashkey3"=>"hashkey4"}, value).should equal(value)
    store[{"hashkey3"=>"hashkey4"}].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load({"hashkey3"=>"hashkey4"}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey1"=>"hashkey2"}] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[{"hashkey3"=>"hashkey4"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey3"=>"hashkey4"}].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey1"=>"hashkey2"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete({"hashkey3"=>"hashkey4"}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey3"=>"hashkey4"}].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey3"=>"hashkey4"}] = {"hashval1"=>["array1", 1]}
    store[{"hashkey3"=>"hashkey4"}].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch({"hashkey3"=>"hashkey4"}, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch({"hashkey3"=>"hashkey4"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_hashkey_hashvalue ####################

shared_examples_for 'returndifferent_hashkey_hashvalue' do
  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[{"hashkey1"=>"hashkey2"}] = value
    store[{"hashkey1"=>"hashkey2"}].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[{"hashkey3"=>"hashkey4"}] = value
    store[{"hashkey3"=>"hashkey4"}].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey1"=>"hashkey2"}] = value
    store[{"hashkey1"=>"hashkey2"}].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey3"=>"hashkey4"}] = value
    store[{"hashkey3"=>"hashkey4"}].should_not be_equal(value)
  end
end

#################### returnsame_hashkey_hashvalue ####################

shared_examples_for 'returnsame_hashkey_hashvalue' do
  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[{"hashkey1"=>"hashkey2"}] = value
    store[{"hashkey1"=>"hashkey2"}].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[{"hashkey3"=>"hashkey4"}] = value
    store[{"hashkey3"=>"hashkey4"}].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey1"=>"hashkey2"}] = value
    store[{"hashkey1"=>"hashkey2"}].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[{"hashkey3"=>"hashkey4"}] = value
    store[{"hashkey3"=>"hashkey4"}].should be_equal(value)
  end
end

#################### persist_hashkey_hashvalue ####################

shared_examples_for 'persist_hashkey_hashvalue' do
  it 'persists values' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[{"hashkey1"=>"hashkey2"}].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[{"hashkey3"=>"hashkey4"}].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[{"hashkey1"=>"hashkey2"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[{"hashkey1"=>"hashkey2"}].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'persists values' do
    store[{"hashkey3"=>"hashkey4"}] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[{"hashkey3"=>"hashkey4"}].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### null_hashkey_objectvalue ####################

shared_examples_for 'null_hashkey_objectvalue' do
  it 'reads from keys like a Hash' do
    store[{"hashkey1"=>"hashkey2"}].should be_nil
    store.load({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[{"hashkey1"=>"hashkey2"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval1)
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey1"=>"hashkey2"}, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey1"=>"hashkey2"}
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey1"=>"hashkey2"}, options).should be_false
    store.load({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.fetch({"hashkey1"=>"hashkey2"}, 42, options).should == 42
    store.fetch({"hashkey1"=>"hashkey2"}, options) { 42 }.should == 42
    store.delete({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey1"=>"hashkey2"}, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey3"=>"hashkey4"}].should be_nil
    store.load({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[{"hashkey3"=>"hashkey4"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval1)
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey3"=>"hashkey4"}, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey3"=>"hashkey4"}
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey3"=>"hashkey4"}, options).should be_false
    store.load({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.fetch({"hashkey3"=>"hashkey4"}, 42, options).should == 42
    store.fetch({"hashkey3"=>"hashkey4"}, options) { 42 }.should == 42
    store.delete({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey3"=>"hashkey4"}, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey1"=>"hashkey2"}].should be_nil
    store.load({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[{"hashkey1"=>"hashkey2"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey1"=>"hashkey2"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval2)
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey1"=>"hashkey2"}, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey1"=>"hashkey2"}
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey1"=>"hashkey2"}, options).should be_false
    store.load({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.fetch({"hashkey1"=>"hashkey2"}, 42, options).should == 42
    store.fetch({"hashkey1"=>"hashkey2"}, options) { 42 }.should == 42
    store.delete({"hashkey1"=>"hashkey2"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey1"=>"hashkey2"}, Value.new(:objval2), options).should == Value.new(:objval2)
  end

  it 'reads from keys like a Hash' do
    store[{"hashkey3"=>"hashkey4"}].should be_nil
    store.load({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[{"hashkey3"=>"hashkey4"}] = value).should equal(value)
  end

  it 'returns false from key? if a key is not available' do
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete({"hashkey3"=>"hashkey4"}).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval2)
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch({"hashkey3"=>"hashkey4"}, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = {"hashkey3"=>"hashkey4"}
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?({"hashkey3"=>"hashkey4"}, options).should be_false
    store.load({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.fetch({"hashkey3"=>"hashkey4"}, 42, options).should == 42
    store.fetch({"hashkey3"=>"hashkey4"}, options) { 42 }.should == 42
    store.delete({"hashkey3"=>"hashkey4"}, options).should be_nil
    store.clear(options).should equal(store)
    store.store({"hashkey3"=>"hashkey4"}, Value.new(:objval2), options).should == Value.new(:objval2)
  end
end

#################### store_hashkey_objectvalue ####################

shared_examples_for 'store_hashkey_objectvalue' do
  it 'writes values to keys that like a Hash' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval1)
    store[{"hashkey1"=>"hashkey2"}].should == Value.new(:objval1)
    store.load({"hashkey1"=>"hashkey2"}).should == Value.new(:objval1)
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval1)
    store.key?({"hashkey1"=>"hashkey2"}).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store({"hashkey1"=>"hashkey2"}, value).should equal(value)
    store[{"hashkey1"=>"hashkey2"}].should == Value.new(:objval1)
    store.load({"hashkey1"=>"hashkey2"}).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval1)
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval2)
    store.clear.should equal(store)
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval1)
    store[{"hashkey1"=>"hashkey2"}].should == Value.new(:objval1)
    store[{"hashkey3"=>"hashkey4"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval1)
    store.delete({"hashkey1"=>"hashkey2"}).should == Value.new(:objval1)
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval1)
    store[{"hashkey1"=>"hashkey2"}].should == Value.new(:objval1)
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval2)
    store[{"hashkey1"=>"hashkey2"}].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval1)
    store.fetch({"hashkey1"=>"hashkey2"}, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch({"hashkey1"=>"hashkey2"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval1)
    store[{"hashkey3"=>"hashkey4"}].should == Value.new(:objval1)
    store.load({"hashkey3"=>"hashkey4"}).should == Value.new(:objval1)
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval1)
    store.key?({"hashkey3"=>"hashkey4"}).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store({"hashkey3"=>"hashkey4"}, value).should equal(value)
    store[{"hashkey3"=>"hashkey4"}].should == Value.new(:objval1)
    store.load({"hashkey3"=>"hashkey4"}).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval1)
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval2)
    store.clear.should equal(store)
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval1)
    store[{"hashkey3"=>"hashkey4"}].should == Value.new(:objval1)
    store[{"hashkey1"=>"hashkey2"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval1)
    store.delete({"hashkey3"=>"hashkey4"}).should == Value.new(:objval1)
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval1)
    store[{"hashkey3"=>"hashkey4"}].should == Value.new(:objval1)
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval2)
    store[{"hashkey3"=>"hashkey4"}].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval1)
    store.fetch({"hashkey3"=>"hashkey4"}, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch({"hashkey3"=>"hashkey4"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval2)
    store[{"hashkey1"=>"hashkey2"}].should == Value.new(:objval2)
    store.load({"hashkey1"=>"hashkey2"}).should == Value.new(:objval2)
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval2)
    store.key?({"hashkey1"=>"hashkey2"}).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store({"hashkey1"=>"hashkey2"}, value).should equal(value)
    store[{"hashkey1"=>"hashkey2"}].should == Value.new(:objval2)
    store.load({"hashkey1"=>"hashkey2"}).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval2)
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval1)
    store.clear.should equal(store)
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval2)
    store[{"hashkey1"=>"hashkey2"}].should == Value.new(:objval2)
    store[{"hashkey3"=>"hashkey4"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval2)
    store.delete({"hashkey1"=>"hashkey2"}).should == Value.new(:objval2)
    store.key?({"hashkey1"=>"hashkey2"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval2)
    store[{"hashkey1"=>"hashkey2"}].should == Value.new(:objval2)
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval1)
    store[{"hashkey1"=>"hashkey2"}].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval2)
    store.fetch({"hashkey1"=>"hashkey2"}, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch({"hashkey1"=>"hashkey2"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval2)
    store[{"hashkey3"=>"hashkey4"}].should == Value.new(:objval2)
    store.load({"hashkey3"=>"hashkey4"}).should == Value.new(:objval2)
  end

  it 'returns true from key? if a key is available' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval2)
    store.key?({"hashkey3"=>"hashkey4"}).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store({"hashkey3"=>"hashkey4"}, value).should equal(value)
    store[{"hashkey3"=>"hashkey4"}].should == Value.new(:objval2)
    store.load({"hashkey3"=>"hashkey4"}).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval2)
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval1)
    store.clear.should equal(store)
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval2)
    store[{"hashkey3"=>"hashkey4"}].should == Value.new(:objval2)
    store[{"hashkey1"=>"hashkey2"}].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval2)
    store.delete({"hashkey3"=>"hashkey4"}).should == Value.new(:objval2)
    store.key?({"hashkey3"=>"hashkey4"}).should be_false
  end

  it 'overwrites existing values' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval2)
    store[{"hashkey3"=>"hashkey4"}].should == Value.new(:objval2)
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval1)
    store[{"hashkey3"=>"hashkey4"}].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval2)
    store.fetch({"hashkey3"=>"hashkey4"}, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch({"hashkey3"=>"hashkey4"}) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_hashkey_objectvalue ####################

shared_examples_for 'returndifferent_hashkey_objectvalue' do
  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[{"hashkey1"=>"hashkey2"}] = value
    store[{"hashkey1"=>"hashkey2"}].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[{"hashkey3"=>"hashkey4"}] = value
    store[{"hashkey3"=>"hashkey4"}].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[{"hashkey1"=>"hashkey2"}] = value
    store[{"hashkey1"=>"hashkey2"}].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[{"hashkey3"=>"hashkey4"}] = value
    store[{"hashkey3"=>"hashkey4"}].should_not be_equal(value)
  end
end

#################### returnsame_hashkey_objectvalue ####################

shared_examples_for 'returnsame_hashkey_objectvalue' do
  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[{"hashkey1"=>"hashkey2"}] = value
    store[{"hashkey1"=>"hashkey2"}].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[{"hashkey3"=>"hashkey4"}] = value
    store[{"hashkey3"=>"hashkey4"}].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[{"hashkey1"=>"hashkey2"}] = value
    store[{"hashkey1"=>"hashkey2"}].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[{"hashkey3"=>"hashkey4"}] = value
    store[{"hashkey3"=>"hashkey4"}].should be_equal(value)
  end
end

#################### persist_hashkey_objectvalue ####################

shared_examples_for 'persist_hashkey_objectvalue' do
  it 'persists values' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval1)
    store.close
    @store = nil
    store[{"hashkey1"=>"hashkey2"}].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval1)
    store.close
    @store = nil
    store[{"hashkey3"=>"hashkey4"}].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[{"hashkey1"=>"hashkey2"}] = Value.new(:objval2)
    store.close
    @store = nil
    store[{"hashkey1"=>"hashkey2"}].should == Value.new(:objval2)
  end

  it 'persists values' do
    store[{"hashkey3"=>"hashkey4"}] = Value.new(:objval2)
    store.close
    @store = nil
    store[{"hashkey3"=>"hashkey4"}].should == Value.new(:objval2)
  end
end

#################### store_large ####################

shared_examples_for 'store_large' do
  it 'should store values up to 32k' do
    value = 'x' * (32 * 1024)
    store['large'] = value
    store['large'].should == value
  end

  it 'should store keys up to 128 bytes' do
    key = 'x' * 128
    store[key] = 'value'
    store[key].should == 'value'
  end
end

#################### not_persist ####################

shared_examples_for 'not_persist' do
  it 'does not persist values' do
    store['key'] = 'val'
    store.close
    @store = nil

    store['key'].should be_nil
  end
end

#################### multiprocess ####################

shared_examples_for 'multiprocess' do
  it 'supports access by multiple instances/processes' do
    store['key'] = 'val'
    store2 = new_store
    store2['key'].should == 'val'
    store2.close
  end
end

#################### expires ####################

shared_examples_for 'expires' do
  it 'supports expires on store and []', :retry => 3 do
    store.store('key1', 'val1', :expires => 3)
    store['key1'].should == 'val1'
    sleep 1
    store['key1'].should == 'val1'
    sleep 3
    store['key1'].should be_nil
  end

  it 'supports strict expires on store and []' do
    store.store('key1', 'val1', :expires => 2)
    store['key1'].should == 'val1'
    sleep 3 # Sleep 3 seconds because after 2 seconds the value can still exist!
    store['key1'].should be_nil
  end

  it 'supports expires on store and fetch', :retry => 3 do
    store.store('key1', 'val1', :expires => 3)
    store.fetch('key1').should == 'val1'
    sleep 1
    store.fetch('key1').should == 'val1'
    sleep 3
    store.fetch('key1').should be_nil
  end

  it 'supports strict expires on store and fetch' do
    store.store('key1', 'val1', :expires => 2)
    store.fetch('key1').should == 'val1'
    sleep 3 # Sleep 3 seconds because after 2 seconds the value can still exist!
    store.fetch('key1').should be_nil
  end

  it 'supports 0 as no-expires on store and []' do
    store.store('key1', 'val1', :expires => 0)
    store['key1'].should == 'val1'
    sleep 2
    store['key1'].should == 'val1'
  end

  it 'supports false as no-expires on store and []' do
    store.store('key1', 'val1', :expires => false)
    store['key1'].should == 'val1'
    sleep 2
    store['key1'].should == 'val1'
  end

  it 'supports expires on store and load', :retry => 3 do
    store.store('key1', 'val1', :expires => 3)
    store.load('key1').should == 'val1'
    sleep 1
    store.load('key1').should == 'val1'
    sleep 3
    store.load('key1').should be_nil
  end

  it 'supports strict expires on store and load' do
    store.store('key1', 'val1', :expires => 2)
    store.load('key1').should == 'val1'
    sleep 3 # Sleep 3 seconds because after 2 seconds the value can still exist!
    store.load('key1').should be_nil
  end

  it 'supports expires on store and key?', :retry => 3 do
    store.store('key1', 'val1', :expires => 3)
    store.key?('key1').should be_true
    sleep 1
    store.key?('key1').should be_true
    sleep 3
    store.key?('key1').should be_false
  end

  it 'supports strict expires on store and key?' do
    store.store('key1', 'val1', :expires => 2)
    store.key?('key1').should be_true
    sleep 3 # Sleep 3 seconds because after 2 seconds the value can still exist!
    store.key?('key1').should be_false
  end

  it 'supports updating the expiration time in load', :retry => 3 do
    store.store('key2', 'val2', :expires => 3)
    store['key2'].should == 'val2'
    sleep 1
    store.load('key2', :expires => 5).should == 'val2'
    store['key2'].should == 'val2'
    sleep 3
    store['key2'].should == 'val2'
    sleep 3
    store['key2'].should be_nil
  end

  it 'supports 0 as no-expires in load' do
    store.store('key1', 'val1', :expires => 2)
    store.load('key1', :expires => 0).should == 'val1'
    sleep 3
    store.load('key1').should == 'val1'
  end

  it 'supports false as no-expires in load' do
    store.store('key1', 'val1', :expires => 2)
    store.load('key1', :expires => false).should == 'val1'
    sleep 3
    store.load('key1').should == 'val1'
  end

  it 'supports updating the expiration time in key?', :retry => 3 do
    store.store('key2', 'val2', :expires => 3)
    store['key2'].should == 'val2'
    sleep 1
    store.key?('key2', :expires => 5).should be_true
    store['key2'].should == 'val2'
    sleep 3
    store['key2'].should == 'val2'
    sleep 3
    store['key2'].should be_nil
  end

  it 'supports 0 as no-expires in key?' do
    store.store('key1', 'val1', :expires => 2)
    store.key?('key1', :expires => 0).should be_true
    sleep 3
    store['key1'].should == 'val1'
  end

  it 'supports false as no-expires in key?' do
    store.store('key1', 'val1', :expires => 2)
    store.key?('key1', :expires => false ).should be_true
    sleep 3
    store['key1'].should == 'val1'
  end

  it 'supports updating the expiration time in fetch', :retry => 3 do
    store.store('key1', 'val1', :expires => 3)
    store['key1'].should == 'val1'
    sleep 1
    store.fetch('key1', nil, :expires => 5).should == 'val1'
    store['key1'].should == 'val1'
    sleep 3
    store['key1'].should == 'val1'
    sleep 3
    store['key1'].should be_nil
  end

  it 'supports 0 as no-expires in fetch' do
    store.store('key1', 'val1', :expires => 2)
    store.fetch('key1', nil, :expires => 0).should == 'val1'
    sleep 3
    store.load('key1').should == 'val1'
  end

  it 'supports false as no-expires in fetch' do
    store.store('key1', 'val1', :expires => 2)
    store.fetch('key1', nil, :expires => false).should == 'val1'
    sleep 3
    store.load('key1').should == 'val1'
  end

  it 'strictly respects expires in delete' do
    store.store('key2', 'val2', :expires => 2)
    store['key2'].should == 'val2'
    sleep 3 # Sleep 3 seconds because after 2 seconds the value can still exist!
    store.delete('key2').should be_nil
  end

  it 'respects expires in delete', :retry => 3 do
    store.store('key2', 'val2', :expires => 3)
    store['key2'].should == 'val2'
    sleep 1
    store['key2'].should == 'val2'
    sleep 3
    store.delete('key2').should be_nil
  end

  it 'supports the #expires syntactic sugar', :retry => 3 do
    store.store('persistent_key', 'persistent_value', :expires => 0)
    store.expires(1).store('key2', 'val2')
    store['key2'].should == 'val2'
    sleep 2
    store.delete('key2').should be_nil
    store['persistent_key'].should == 'persistent_value'
  end

  it 'supports false as no-expires on store and []' do
    store.store('key1', 'val1', :expires => false)
    store['key1'].should == 'val1'
    sleep 2
    store['key1'].should == 'val1'
  end

  it 'does not update the expiration time in key? when not asked to do so', :retry => 3 do
    store.store('key1', 'val1', :expires => 1)
    store.key?('key1').should be_true
    store.key?('key1', :expires => nil).should be_true
    sleep 2
    store.key?('key1').should be_false
  end

  it 'does not update the expiration time in fetch when not asked to do so', :retry => 3 do
    store.store('key1', 'val1', :expires => 1)
    store.fetch('key1').should == 'val1'
    store.fetch('key1', :expires => nil).should == 'val1'
    sleep 2
    store.fetch('key1').should be_nil
  end

  it 'does not update the expiration time in load when not asked to do so', :retry => 3 do
    store.store('key1', 'val1', :expires => 1)
    store.load('key1').should == 'val1'
    store.load('key1', :expires => nil).should == 'val1'
    sleep 2
    store.load('key1').should be_nil
  end
end

#################### default_expires ####################

shared_examples_for 'default_expires' do
  it 'does set default expiration time' do
    store['key1'] = 'val1'
    store.key?('key1').should be_true
    store.fetch('key1').should == 'val1'
    store.load('key1').should == 'val1'
    sleep 2
    store.key?('key1').should be_false
    store.fetch('key1').should be_nil
    store.load('key1').should be_nil
  end
end

#################### not_increment ####################

shared_examples_for 'not_increment' do
  it 'does not support #increment' do
    expect do
      store.increment('inckey')
    end.to raise_error(NotImplementedError)
  end

  it 'does not support #decrement' do
    expect do
      store.increment('inckey')
    end.to raise_error(NotImplementedError)
  end
end

#################### concurrent_increment ####################

shared_examples_for 'concurrent_increment' do
  def increment_thread(name)
    Thread.new do
      s = new_store
      100.times do |i|
        100.times do |j|
          s.increment("counter#{j}", 1, :expires => false)
          Thread.pass if rand(1000) >= 995
        end
        s.store("#{name}#{i}", i.to_s, :expires => false)
      end
      s.close
    end
  end

  it 'have atomic increment across multiple processes' do
    a = increment_thread('a')
    b = increment_thread('b')
    c = increment_thread('c')
    a.join
    b.join
    c.join
    100.times do |i|
      store["a#{i}"].should == i.to_s
      store["b#{i}"].should == i.to_s
      store["c#{i}"].should == i.to_s
    end
    100.times do |j|
      store.raw["counter#{j}"].should == 300.to_s
    end
  end
end

#################### concurrent_create ####################

shared_examples_for 'concurrent_create' do
  def create_thread(name)
    Thread.new do
      s = new_store
      1000.times do |i|
        s[i.to_s].should == name if s.create(i.to_s, name, :expires => false)
        Thread.pass if rand(100) >= 99
      end
      s.close
    end
  end

  it 'have atomic create across multiple processes' do
    a = create_thread('a')
    b = create_thread('b')
    c = create_thread('c')
    a.join
    b.join
    c.join
  end
end

#################### increment ####################

shared_examples_for 'increment' do
  it 'initializes in #increment with 1' do
    store.key?('inckey').should be_false
    store.increment('inckey').should == 1
    store.key?('inckey').should be_true
    store.raw['inckey'].should == '1'
    store.raw.load('inckey').should == '1'
    store.load('inckey', :raw => true).should == '1'

    store.delete('inckey', :raw => true).should == '1'
    store.key?('inckey').should be_false
  end

  it 'initializes in #increment with higher value' do
    store.increment('inckey', 42).should == 42
    store.key?('inckey').should be_true
    store.raw['inckey'].should == '42'
    store.delete('inckey', :raw => true).should == '42'
  end

  it 'initializes in #increment with 0' do
    store.increment('inckey', 0).should == 0
    store.key?('inckey').should be_true
    store.raw['inckey'].should == '0'
    store.delete('inckey', :raw => true).should == '0'
  end

  it 'initializes in #decrement with 0' do
    store.decrement('inckey', 0).should == 0
    store.raw['inckey'].should == '0'
  end

  it 'initializes in #decrement with negative value' do
    store.decrement('inckey', -42).should == 42
    store.raw['inckey'].should == '42'
  end

  it 'supports incrementing existing value by value' do
    store.increment('inckey').should == 1
    store.increment('inckey', 42).should == 43
    store.raw['inckey'].should == '43'
  end

  it 'supports decrementing existing value by value' do
    store.increment('inckey').should == 1
    store.decrement('inckey').should == 0
    store.increment('inckey', 42).should == 42
    store.decrement('inckey', 2).should == 40
    store.raw['inckey'].should == '40'
  end

  it 'supports incrementing existing value by 0' do
    store.increment('inckey').should == 1
    store.increment('inckey', 0).should == 1
    store.raw['inckey'].should == '1'
  end

  it 'supports decrementing existing value' do
    store.increment('inckey', 10).should == 10
    store.increment('inckey', -5).should == 5
    store.raw['inckey'].should == '5'
    store.increment('inckey', -5).should == 0
    store.raw['inckey'].should == '0'
  end

  it 'interprets raw value as integer' do
    store.store('inckey', '42', :raw => true)
    store.increment('inckey').should == 43
    store.raw['inckey'].should == '43'
  end

  it 'raises error in #increment on non integer value' do
    store['strkey'] = 'value'
    expect do
      store.increment('strkey')
    end.to raise_error
  end

  it 'raises error in #decrement on non integer value' do
    store['strkey'] = 'value'
    expect do
      store.decrement('strkey')
    end.to raise_error
  end

  it 'supports Semaphore' do
    a = Moneta::Semaphore.new(store, 'semaphore', 2)
    b = Moneta::Semaphore.new(store, 'semaphore', 2)
    c = Moneta::Semaphore.new(store, 'semaphore', 2)
    a.synchronize do
      a.locked?.should be_true
      b.synchronize do
        b.locked?.should be_true
        c.try_lock.should be_false
      end
    end
  end

end

#################### create ####################

shared_examples_for 'create' do
  it 'creates the given key' do
    store.create('key','value').should be_true
    store['key'].should == 'value'
  end

  it 'creates raw value with the given key' do
    store.raw.create('key','value').should be_true
    store.raw['key'].should == 'value'
  end

  it 'does not create a key if it exists' do
    store['key'] = 'value'
    store.create('key','another value').should be_false
    store['key'].should == 'value'
  end

  it 'supports Mutex' do
    a = Moneta::Mutex.new(store, 'mutex')
    b = Moneta::Mutex.new(store, 'mutex')
    a.lock.should be_true
    b.try_lock.should be_false
    a.unlock.should be_nil
  end

end

#################### not_create ####################

shared_examples_for 'not_create' do
  it 'does not support #create' do
    expect do
      store.create('key','value')
    end.to raise_error(NotImplementedError)
  end
end

#################### create_expires ####################

shared_examples_for 'create_expires' do
  it 'creates the given key and expires it' do
    store.create('key','value', :expires => 1).should be_true
    store['key'].should == 'value'
    sleep 2
    store.key?('key').should be_false
  end

  it 'does not change expires if the key exists' do
    store.store('key', 'value', :expires => false).should == 'value'
    store.create('key','another value', :expires => 1).should be_false
    store['key'].should == 'value'
    sleep 2
    store['key'].should == 'value'
    store.key?('key').should be_true
  end
end

#################### marshallable_key ####################

shared_examples_for 'marshallable_key' do
  it 'refuses to #[] from keys that cannot be marshalled' do
    expect do
      store[Struct.new(:foo).new(:bar)]
    end.to raise_error(marshal_error)
  end

  it 'refuses to load from keys that cannot be marshalled' do
    expect do
      store.load(Struct.new(:foo).new(:bar))
    end.to raise_error(marshal_error)
  end

  it 'refuses to fetch from keys that cannot be marshalled' do
    expect do
      store.fetch(Struct.new(:foo).new(:bar), true)
    end.to raise_error(marshal_error)
  end

  it 'refuses to #[]= to keys that cannot be marshalled' do
    expect do
      store[Struct.new(:foo).new(:bar)] = 'value'
    end.to raise_error(marshal_error)
  end

  it 'refuses to store to keys that cannot be marshalled' do
    expect do
      store.store Struct.new(:foo).new(:bar), 'value'
    end.to raise_error(marshal_error)
  end

  it 'refuses to check for key? if the key cannot be marshalled' do
    expect do
      store.key? Struct.new(:foo).new(:bar)
    end.to raise_error(marshal_error)
  end

  it 'refuses to delete a key if the key cannot be marshalled' do
    expect do
      store.delete Struct.new(:foo).new(:bar)
    end.to raise_error(marshal_error)
  end
end

#################### marshallable_value ####################

shared_examples_for 'marshallable_value' do
  it 'refuses to store values that cannot be marshalled' do
    expect do
      store.store 'key', Struct.new(:foo).new(:bar)
    end.to raise_error(marshal_error)
  end
end

#################### transform_value ####################

shared_examples_for 'transform_value' do
  it 'allows to bypass transformer with :raw' do
    store['key'] = 'value'
    load_value(store.load('key', :raw => true)).should == 'value'

    store.store('key', 'value', :raw => true)
    store.load('key', :raw => true).should == 'value'
    store.delete('key', :raw => true).should == 'value'
  end

  it 'allows to bypass transformer with raw syntactic sugar' do
    store['key'] = 'value'
    load_value(store.raw.load('key')).should == 'value'

    store.raw.store('key', 'value')
    store.raw['key'].should == 'value'
    store.raw.load('key').should == 'value'
    store.raw.delete('key').should == 'value'

    store.raw['key'] = 'value2'
    store.raw['key'].should == 'value2'
  end

  it 'returns unmarshalled value' do
    store.store('key', 'unmarshalled value', :raw => true)
    store.load('key', :raw => true).should == 'unmarshalled value'
  end

  it 'might raise exception on invalid value' do
    store.store('key', 'unmarshalled value', :raw => true)

    begin
      store['key'].should == load_value('unmarshalled value')
      store.delete('key').should == load_value('unmarshalled value')
    rescue Exception => ex
      expect do
        store['key']
      end.to raise_error
      expect do
        store.delete('key')
      end.to raise_error
    end
  end
end

#################### transform_value_expires ####################

shared_examples_for 'transform_value_expires' do
  it 'allows to bypass transformer with :raw' do
    store['key'] = 'value'
    load_value(store.load('key', :raw => true)).should == 'value'
    store['key'] = [1,2,3]
    load_value(store.load('key', :raw => true)).should == [[1,2,3]]
    store['key'] = nil
    load_value(store.load('key', :raw => true)).should == [nil]
    store['key'] = false
    load_value(store.load('key', :raw => true)).should be_false

    store.store('key', 'value', :expires => 10)
    load_value(store.load('key', :raw => true)).first.should == 'value'
    load_value(store.load('key', :raw => true)).last.should respond_to(:to_int)

    store.store('key', 'value', :raw => true)
    store.load('key', :raw => true).should == 'value'
    store.delete('key', :raw => true).should == 'value'
  end

  it 'returns unmarshalled value' do
    store.store('key', 'unmarshalled value', :raw => true)
    store.load('key', :raw => true).should == 'unmarshalled value'
  end

  it 'might raise exception on invalid value' do
    store.store('key', 'unmarshalled value', :raw => true)

    begin
      store['key'].should == load_value('unmarshalled value')
      store.delete('key').should == load_value('unmarshalled value')
    rescue Exception => ex
      expect do
        store['key']
      end.to raise_error
      expect do
        store.delete('key')
      end.to raise_error
    end
  end
end

#################### features ####################

shared_examples_for 'features' do
  it 'should report correct features' do
    store.features.sort_by(&:to_s).should == features
  end

  it 'should have frozen features' do
    store.features.frozen?.should be_true
  end

  it 'should have #supports?' do
    features.each do |f|
      store.supports?(f).should be_true
    end
    store.supports?(:unknown).should be_false
  end
end

