#! /bin/bash

# Test upload of a CSV file.

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

BASENAME=$(basename $0 .pl)
TMP_TEST_DB=$(echo tmp${BASENAME}$$ | sed 's/[^-0-9a-zA-Z]//g')

DB_DIR=db
DB_FILE=${DB_DIR}/test1.db
TMP_DB_BASE=${TMP_TEST_DB}.db
TMP_DB_FILE=${DB_DIR}/${TMP_DB_BASE}

cp ${DB_FILE} ${TMP_DB_FILE}

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}/bibliography"
export HTTP_HOST=${TMP_TEST_DB}.domain.net
export REQUEST_METHOD=POST
export CONTENT_TYPE="multipart/form-data; boundary=------------------------b989696a28305e74"
export REMOTE_USER=writer

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';

echo "==="

(

cat <<END
--------------------------b989696a28305e74
Content-Disposition: form-data; name="xlsfile"; filename="duck.xls"
Content-Type: application/octet-stream

nothing like correct XLS file
--------------------------b989696a28305e74
Content-Disposition: form-data; name="db"

${TMP_DB_BASE}
--------------------------b989696a28305e74
Content-Disposition: form-data; name="table"

bibliography
--------------------------b989696a28305e74--
END

) | ${INPUT_SCRIPT}

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';

rm -f ${TMP_DB_FILE}
