/*******************************************************************************
 * Copyright (c) 2010 Robert "Unlogic" Olofsson (unlogic@unlogic.se).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0-standalone.html
 ******************************************************************************/
package se.unlogic.standardutils.populators;

import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.validation.StringFormatValidator;

public class LongPopulator extends BaseStringPopulator<Long> {

   public LongPopulator() {
      super();
   }

   public LongPopulator(String populatorID, StringFormatValidator formatValidator) {
      super(populatorID, formatValidator);
   }

   public LongPopulator(String populatorID) {
      super(populatorID);
   }

   public Long getValue(String value) {

      return Long.valueOf(value);
   }

   @Override
   public boolean validateDefaultFormat(String value) {

      return NumberUtils.isLong(value);
   }

   public Class<? extends Long> getType() {

      return Long.class;
   }
}
