use strict;
use warnings;

use RT::Test tests => undef;

my $ticket = RT::Ticket->new(RT::CurrentUser->new('root'));
my ($ok, $msg) = $ticket->Create(Queue => 1, Owner => 'nobody', Subject => 'bad music');
ok($ok);

my ($baseurl, $m) = RT::Test->started_ok;

my $test_page = "/Helpers/Toggle/TicketBookmark?id=1";
my $test_path = "/Helpers/Toggle/TicketBookmark";

ok $m->login, 'logged in';

# valid referer
$m->add_header(Referer => $baseurl);
$m->get_ok($test_page);
$m->content_lacks("Possible cross-site request forgery");
$m->content_contains("star.gif");

# come from an external source
$m->add_header(Referer => 'http://example.com');
$m->get_ok($test_page);
$m->content_contains("Possible cross-site request forgery");
$m->title_is('Possible cross-site request forgery');

# come with no referer
$m->add_header(Referer => undef);
$m->get_ok($test_page);
$m->content_contains("Possible cross-site request forgery");
$m->title_is('Possible cross-site request forgery');

# clicking the resume request button gets us to the test page
$m->follow_link(text_regex => qr{resume your request});
$m->content_lacks("Possible cross-site request forgery");
like($m->response->request->uri, qr{^http://[^/]+\Q$test_path\E\?CSRF_Token=\w+$});
$m->content_contains("star.gif");

undef $m;
done_testing;
