# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2025 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from DiagLogSettings.idl.

use strict;

package Raritan::RPC::diag::DiagLogSettings;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "diag.DiagLogSettings:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::diag::DiagLogSettings::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant ERR_NONE => 0;

use constant ERR_UNKNOWN_LOG_CONTEXT_NAME => 1;

use constant ERR_UNKNOWN_LOG_LEVEL => 2;

sub resetLogLevelsForAllCtxNames($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'resetLogLevelsForAllCtxNames', $args);
}

use Raritan::RPC::diag::DiagLogSettings::LogLevelEntry;

sub getLogLevelsForAllCtxNames($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getLogLevelsForAllCtxNames', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::diag::DiagLogSettings::LogLevelEntry::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}


sub setLogLevelForAllCtxNames($$) {
    my ($self, $logLevel) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'logLevel'} = 1 * $logLevel;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setLogLevelForAllCtxNames', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}


sub getLogLevelByCtxName($$$) {
    my ($self, $ctxName, $logLevel) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'ctxName'} = "$ctxName";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getLogLevelByCtxName', $args);
    $$logLevel = $rsp->{'logLevel'};
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}


sub setLogLevelByCtxName($$$) {
    my ($self, $ctxName, $logLevel) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'ctxName'} = "$ctxName";
    $args->{'logLevel'} = 1 * $logLevel;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setLogLevelByCtxName', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('diag.DiagLogSettings', 1, 0, 0, 'Raritan::RPC::diag::DiagLogSettings');
1;
