% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git.R
\name{git_protocol}
\alias{git_protocol}
\alias{use_git_protocol}
\title{See or set the default Git protocol}
\usage{
git_protocol()

use_git_protocol(protocol)
}
\arguments{
\item{protocol}{One of "https" or "ssh"}
}
\value{
The protocol, either "https" or "ssh"
}
\description{
Git operations that address a remote use a so-called "transport protocol".
usethis supports HTTPS and SSH. The protocol dictates the Git URL format used
when usethis needs to configure the first GitHub remote for a repo:
\itemize{
\item \code{protocol = "https"} implies \verb{https://github.com/<OWNER>/<REPO>.git}
\item \code{protocol = "ssh"} implies \verb{git@github.com:<OWNER>/<REPO>.git}
}

Two helper functions are available:
\itemize{
\item \code{git_protocol()} reveals the protocol "in force". As of usethis v2.0.0,
this defaults to "https". You can change this for the duration of the
R session with \code{use_git_protocol()}. Change the default for all R
sessions with code like this in your \code{.Rprofile} (easily editable via
\code{\link[=edit_r_profile]{edit_r_profile()}}):

\if{html}{\out{<div class="sourceCode">}}\preformatted{options(usethis.protocol = "ssh")
}\if{html}{\out{</div>}}
\item \code{use_git_protocol()} sets the Git protocol for the current R session
}

This protocol only affects the Git URL for newly configured remotes. All
existing Git remote URLs are always respected, whether HTTPS or SSH.
}
\examples{
\dontrun{
git_protocol()

use_git_protocol("ssh")
git_protocol()

use_git_protocol("https")
git_protocol()
}
}
