% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parser.R
\name{freeParser}
\alias{freeParser}
\alias{freeParser,Parser-method}
\title{Free memory used by a librdf parser}
\usage{
freeParser(.Object)

\S4method{freeParser}{Parser}(.Object)
}
\arguments{
\item{.Object}{a Node object}
}
\description{
Free memory used by a librdf parser
}
\details{
After freeNode is called, the Node object is no longer usable and should
be deleted  \code{"rm(nodeName)"} and a new object created.
}
\examples{
world <- new("World")
storage <- new("Storage", world, "hashes", name="", options="hash-type='memory'")
model <- new("Model", world, storage, options="")
parser <- new("Parser", world)
filePath <- system.file("extdata/example.rdf", package="redland")
parseFileIntoModel(parser, world, filePath, model)
# At this point, some operations would be performed with the Model that has been populated
# with the parser.
# See '?redland' for a complete example.
# When the parser object is no longer needed, the resources it had allocated can be freed.
freeParser(parser)
rm(parser)
}
