% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/head-tail.R
\name{head_while}
\alias{head_while}
\alias{tail_while}
\title{Find head/tail that all satisfies a predicate.}
\usage{
head_while(.x, .p, ...)

tail_while(.x, .p, ...)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.p}{A single predicate function, a formula describing such a
predicate function, or a logical vector of the same length as \code{.x}.
Alternatively, if the elements of \code{.x} are themselves lists of
objects, a string indicating the name of a logical element in the
inner lists. Only those elements where \code{.p} evaluates to
\code{TRUE} will be modified.}

\item{...}{Additional arguments passed on to the mapped function.

We now generally recommend against using \code{...} to pass additional
(constant) arguments to \code{.f}. Instead use a shorthand anonymous function:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{# Instead of
x |> map(f, 1, 2, collapse = ",")
# do:
x |> map(\\(x) f(x, 1, 2, collapse = ","))
}\if{html}{\out{</div>}}

This makes it easier to understand which arguments belong to which
function and will tend to yield better error messages.}
}
\value{
A vector the same type as \code{.x}.
}
\description{
Find head/tail that all satisfies a predicate.
}
\examples{
pos <- function(x) x >= 0
head_while(5:-5, pos)
tail_while(5:-5, negate(pos))

big <- function(x) x > 100
head_while(0:10, big)
tail_while(0:10, big)
}
