% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pammfit.R
\name{pamm}
\alias{pamm}
\alias{is.pamm}
\alias{print.pamm}
\alias{summary.pamm}
\alias{plot.pamm}
\title{Fit a piece-wise exponential additive model}
\usage{
pamm(formula, data = list(), ..., trafo_args = NULL, engine = "gam")

is.pamm(x)

\method{print}{pamm}(x, ...)

\method{summary}{pamm}(object, ...)

\method{plot}{pamm}(x, ...)
}
\arguments{
\item{formula}{ A GAM formula, or a list of formulae (see \code{\link[mgcv]{formula.gam}} and also \code{\link[mgcv]{gam.models}}). 
These are exactly like the formula for a GLM except that smooth terms, \code{\link[mgcv]{s}}, \code{\link[mgcv]{te}}, \code{\link[mgcv]{ti}} 
and \code{\link[mgcv]{t2}}, can be added to the right hand side to specify that the linear predictor depends on smooth functions of predictors (or linear functionals of these).
}

\item{data}{ A data frame or list containing the model response variable and 
covariates required by the formula. By default the variables are taken 
from \code{environment(formula)}: typically the environment from 
which \code{gam} is called.}

\item{...}{Further arguments passed to \code{engine}.}

\item{trafo_args}{A named list. If data is not in PED format, \code{as_ped}
will be called internally with arguments provided in \code{trafo_args}.}

\item{engine}{Character name of the function that will be called to fit the
model. The intended entries are either \code{"gam"} or \code{"bam"}
(both from package \code{mgcv}).}

\item{x}{Any R object.}

\item{object}{An object of class \code{pamm} as returned by \code{\link{pamm}}.}
}
\description{
A thin wrapper around \code{\link[mgcv]{gam}}, however, some arguments are
prespecified:
\code{family=poisson()} and \code{offset=data$offset}.
These two can not be overwritten. In many cases it will also be advisable to
set \code{method="REML"}.
}
\examples{
ped <- tumor[1:100, ] \%>\%
 as_ped(Surv(days, status) ~ complications, cut = seq(0, 3000, by = 50))
pam <- pamm(ped_status ~ s(tend) + complications, data = ped)
summary(pam)
## Alternatively
pamm(
 ped_status ~ s(tend) + complications,
 data = tumor[1:100, ],
trafo_args = list(formula = Surv(days, status)~complications))
}
\seealso{
\code{\link[mgcv]{gam}}
}
\keyword{internal}
