% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setPredictThreshold.R
\name{setPredictThreshold}
\alias{setPredictThreshold}
\title{Set the probability threshold the learner should use.}
\usage{
setPredictThreshold(learner, predict.threshold)
}
\arguments{
\item{learner}{(\link{Learner} | \code{character(1)})\cr
The learner.
If you pass a string the learner will be created via \link{makeLearner}.}

\item{predict.threshold}{(\link{numeric})\cr
Threshold to produce class labels. Has to be a named vector, where names correspond to class labels.
Only for binary classification it can be a single numerical threshold for the positive class.
See \link{setThreshold} for details on how it is applied.
Default is \code{NULL} which means 0.5 / an equal threshold for each class.}
}
\value{
\link{Learner}.
}
\description{
See \code{predict.threshold} in \link{makeLearner} and \link{setThreshold}.

For complex wrappers only the top-level \code{predict.type} is currently set.
}
\seealso{
Other predict: 
\code{\link{asROCRPrediction}()},
\code{\link{getPredictionProbabilities}()},
\code{\link{getPredictionResponse}()},
\code{\link{getPredictionTaskDesc}()},
\code{\link{predict.WrappedModel}()},
\code{\link{setPredictType}()}

Other learner: 
\code{\link{LearnerProperties}},
\code{\link{getClassWeightParam}()},
\code{\link{getHyperPars}()},
\code{\link{getLearnerId}()},
\code{\link{getLearnerNote}()},
\code{\link{getLearnerPackages}()},
\code{\link{getLearnerParVals}()},
\code{\link{getLearnerParamSet}()},
\code{\link{getLearnerPredictType}()},
\code{\link{getLearnerShortName}()},
\code{\link{getLearnerType}()},
\code{\link{getParamSet}()},
\code{\link{helpLearnerParam}()},
\code{\link{helpLearner}()},
\code{\link{makeLearners}()},
\code{\link{makeLearner}()},
\code{\link{removeHyperPars}()},
\code{\link{setHyperPars}()},
\code{\link{setId}()},
\code{\link{setLearnerId}()},
\code{\link{setPredictType}()}
}
\concept{learner}
\concept{predict}
