% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-methods.R
\docType{methods}
\name{exportMzMl,MassSpectrum-method}
\alias{exportMzMl,MassSpectrum-method}
\alias{exportMzMl}
\alias{exportMzMl,list-method}
\title{Export to mzML files}
\usage{
\S4method{exportMzMl}{MassSpectrum}(x, file, force=FALSE, \ldots)

\S4method{exportMzMl}{list}(x, path, force=FALSE, \ldots)
}
\arguments{
\item{x}{a \code{\link[MALDIquant]{AbstractMassObject-class}} object or a
\code{list} of \code{\link[MALDIquant]{AbstractMassObject-class}} objects.}

\item{file}{\code{character}, file name.}

\item{force}{\code{logical}, If \code{TRUE} the \code{file} would be
overwritten or \code{path} would be created.}

\item{path}{\code{character}, path to directory in which the \code{list} of
\code{\link[MALDIquant]{MassSpectrum-class}} would be exported. If
\code{path} is a single filename all spectra will be exported to a single
mzML file.}

\item{\ldots}{arguments to be passed to internal functions.}
}
\description{
This function exports
\code{\link[MALDIquant]{MassSpectrum-class}} objects into mzML files.
}
\examples{

\dontrun{
library("MALDIquant")
library("MALDIquantForeign")

s <- list(createMassSpectrum(mass=1:5, intensity=1:5),
          createMassSpectrum(mass=1:5, intensity=1:5))

## export a single spectrum
exportMzMl(s[[1]], file="spectrum.mzML")

## export a list of spectra
exportMzMl(s, path="spectra.mzML")
}

}
\references{
\url{https://strimmerlab.github.io/software/maldiquant/}, \cr
HUPO Proteomics Standards Inititative mzML 1.1.0 Specification:
\url{https://www.psidev.info/mzML}
}
\seealso{
\code{\link[MALDIquant]{MassSpectrum-class}}
}
\author{
Sebastian Gibb
}
