% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rewire.R
\name{rewire}
\alias{rewire}
\title{Rewiring edges of a graph}
\usage{
rewire(graph, with)
}
\arguments{
\item{graph}{The graph to rewire}

\item{with}{A function call to one of the rewiring methods,
see details below.}
}
\value{
The rewired graph.
}
\description{
See the links below for the implemented rewiring methods.
}
\examples{
g <- make_ring(10)
g \%>\%
  rewire(each_edge(p = .1, loops = FALSE)) \%>\%
  plot(layout = layout_in_circle)
print_all(rewire(g, with = keeping_degseq(niter = vcount(g) * 10)))
}
\seealso{
Other rewiring functions: 
\code{\link{each_edge}()},
\code{\link{keeping_degseq}()}
}
\concept{rewiring functions}
