% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secret.R
\name{obfuscate}
\alias{obfuscate}
\alias{obfuscated}
\title{Obfuscate mildly secret information}
\usage{
obfuscate(x)

obfuscated(x)
}
\arguments{
\item{x}{A string to \code{obfuscate}, or mark as \code{obfuscated}.}
}
\value{
\code{obfuscate()} prints the \code{obfuscated()} call to include in your
code. \code{obfuscated()} returns an S3 class marking the string as obfuscated
so it can be unobfuscated when needed.
}
\description{
Use \code{obfuscate("value")} to generate a call to \code{obfuscated()}, which will
unobfuscate the value at the last possible moment. Obfuscated values only
work in limited locations:
\itemize{
\item The \code{secret} argument to \code{\link[=oauth_client]{oauth_client()}}
\item Elements of the \code{data} argument to \code{\link[=req_body_form]{req_body_form()}}, \code{req_body_json()},
and \code{req_body_multipart()}.
}

Working together this pair of functions provides a way to obfuscate mildly
confidential information, like OAuth client secrets. The secret can not be
revealed from your inspecting source code, but a skilled R programmer could
figure it out with some effort. The main goal is to protect against scraping;
there's no way for an automated tool to grab your obfuscated secrets.
}
\examples{
obfuscate("good morning")

# Every time you obfuscate you'll get a different value because it
# includes 16 bytes of random data which protects against certain types of
# brute force attack
obfuscate("good morning")
}
