% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_sets.R
\name{geom_parallel_sets}
\alias{geom_parallel_sets}
\alias{stat_parallel_sets}
\alias{stat_parallel_sets_axes}
\alias{geom_parallel_sets_axes}
\alias{geom_parallel_sets_labels}
\title{Create Parallel Sets diagrams}
\usage{
stat_parallel_sets(mapping = NULL, data = NULL, geom = "shape",
  position = "identity", n = 100, strength = 0.5, sep = 0.05,
  axis.width = 0, na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)

geom_parallel_sets(mapping = NULL, data = NULL,
  stat = "parallel_sets", position = "identity", n = 100,
  na.rm = FALSE, sep = 0.05, strength = 0.5, axis.width = 0,
  show.legend = NA, inherit.aes = TRUE, ...)

stat_parallel_sets_axes(mapping = NULL, data = NULL,
  geom = "parallel_sets_axes", position = "identity", sep = 0.05,
  axis.width = 0, na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)

geom_parallel_sets_axes(mapping = NULL, data = NULL,
  stat = "parallel_sets_axes", position = "identity", na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, ...)

geom_parallel_sets_labels(mapping = NULL, data = NULL,
  stat = "parallel_sets_axes", angle = -90, position = "identity",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{n}{The number of points to create for each of the bounding diagonals}

\item{strength}{The proportion to move the control point along the x-axis
towards the other end of the bezier curve}

\item{sep}{The proportional separation between categories within a variable}

\item{axis.width}{The width of the area around each variable axis}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{angle}{The angle of the axis label text}
}
\description{
A parallel sets diagram is a type of visualisation showing the interaction
between multiple categorical variables. If the variables has an intrinsic
order the representation can be thought of as a Sankey Diagram. If each
variable is a point in time it will resemble an alluvial diagram.
}
\details{
In a parallel sets visualization each categorical variable will be assigned
a position on the x-axis. The size of the intersection of categories from
neighboring variables are then shown as thick diagonals, scaled by the sum of
elements shared between the two categories. The natural data representation
for such as plot is to have each categorical variable in a separate column
and then have a column giving the amount/magnitude of the combination of
levels in the row. This representation is unfortunately not fitting for the
\code{ggplot2} API which needs every position encoding in the same column. To make
it easier to work with \code{ggforce} provides a helper \code{\link[=gather_set_data]{gather_set_data()}}, which
takes care of the transformation.
}
\section{Aesthetics}{

geom_parallel_sets understand the following aesthetics
(required aesthetics are in bold):
\itemize{
\item \strong{x}
\item \strong{id}
\item \strong{split}
\item \strong{value}
\item color
\item fill
\item size
\item linetype
\item alpha
\item lineend
}
}

\examples{
data <- reshape2::melt(Titanic)
data <- gather_set_data(data, 1:4)

ggplot(data, aes(x, id = id, split = y, value = value)) +
  geom_parallel_sets(aes(fill = Sex), alpha = 0.3, axis.width = 0.1) +
  geom_parallel_sets_axes(axis.width = 0.1) +
  geom_parallel_sets_labels(colour = 'white')
}
\author{
Thomas Lin Pedersen
}
