% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiv.R
\name{mvcontrast}
\alias{mvcontrast}
\title{Multivariate contrasts}
\usage{
mvcontrast(object, method = "eff", mult.name = object@roles$multresp,
  null = 0, by = object@misc$by.vars, adjust = c("sidak",
  p.adjust.methods), show.ests = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{emmGrid}}

\item{method}{A contrast method, per \code{\link{contrast.emmGrid}}}

\item{mult.name}{Character vector of names of the factors whose levels
define the multivariate means to contrast. If the model itself has a
multivariate response, that is what is used. Otherwise, \code{mult.name}
\emph{must} be specified.}

\item{null}{Scalar or conformable vector of null-hypothesis values to test against}

\item{by}{Any \code{by} variable(s). These should not include the primary
variables to be contrasted. For convenience, the \code{by} variable is
nulled-out if it would result in no primary factors being contrasted.}

\item{adjust}{Character value of a multiplicity adjustment method
(\code{"none"} for no adjustment). The available adjustment methods are
more limited that in \code{contrast}, and any default adjustment returned
via \code{method} is ignored.}

\item{show.ests}{Logical flag determining whether the multivariate means 
are displayed}

\item{...}{Additional arguments passed to \code{contrast}}
}
\value{
An object of class \code{summary_emm} containing the multivariate
  test results; or a list of the estimates and the tests if \code{show.ests}
  is \code{TRUE}. The test results include the Hotelling \eqn{T^2} statistic,
  \eqn{F} ratios, degrees of freedom, and \eqn{P} values.
}
\description{
This function displays tests of multivariate comparisons or contrasts.
The contrasts are constructed at each level of the variable in \code{mult.name},
and then we do a multivariate test that the vector of estimates is equal to
\code{null} (zero by default). The \emph{F} statistic and degrees
of freedom are determined via the Hotelling distribution. that is, if there are
\eqn{m} error degrees of freedom and multivariate dimensionality \eqn{d}, then
the resulting \eqn{F} statistic has degrees of freedom \eqn{(d, m - d + 1)}
as shown in Hotelling (1931).
}
\note{
If some interactions among the primary and \code{mult.name} factors are
absent, the covariance of the multivariate means is singular; this situation
is accommodated, but the result has reduced degrees of freedom and a message
is displayed. If there are other abnormal conditions such as non-estimable
results, estimates are shown as \code{NA}.

While designed primarily for testing contrasts, multivariate tests of the
mean vector itself can be implemented via \code{method = "identity")} (see
the examples).
}
\examples{
MOats.lm <- lm(yield ~ Variety + Block, data = MOats)
MOats.emm <- emmeans(MOats.lm, ~ Variety | rep.meas)
mvcontrast(MOats.emm, "consec", show.ests = TRUE)  # mult.name defaults to rep.meas

# Test each mean against a specified null vector
mvcontrast(MOats.emm, "identity", name = "Variety", 
           null = c(80, 100, 120, 140), adjust = "none")
# (Note 'name' is passed to contrast() and overrides default name "contrast")

# 'mult.name' need not refer to a multivariate response
mvcontrast(MOats.emm, "trt.vs.ctrl1", mult.name = "Variety")

}
\references{
Hotelling, Harold (1931) "The generalization of Student's ratio", 
  \emph{Annals of Mathematical Statistics} 2(3), 360–378. doi:10.1214/aoms/1177732979
}
