% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-do.R
\name{do}
\alias{do}
\title{Do anything}
\usage{
do(.data, ...)
}
\arguments{
\item{.data}{a tbl}

\item{...}{Expressions to apply to each group. If named, results will be
stored in a new column. If unnamed, must return a data frame. You can
use \code{.} to refer to the current group. You can not mix named and
unnamed arguments.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

\code{do()} is superseded as of dplyr 1.0.0, because its syntax never really
felt like it belonged with the rest of dplyr. It's replaced by a combination
of \code{\link[=reframe]{reframe()}} (which can produce multiple rows and multiple columns),
\code{\link[=nest_by]{nest_by()}} (which creates a \link{rowwise} tibble of nested data),
and \code{\link[=pick]{pick()}} (which allows you to access the data for the "current" group).
}
\examples{
# do() with unnamed arguments becomes reframe() or summarise()
# . becomes pick()
by_cyl <- mtcars \%>\% group_by(cyl)
by_cyl \%>\% do(head(., 2))
# ->
by_cyl \%>\% reframe(head(pick(everything()), 2))
by_cyl \%>\% slice_head(n = 2)

# Can refer to variables directly
by_cyl \%>\% do(mean = mean(.$vs))
# ->
by_cyl \%>\% summarise(mean = mean(vs))

# do() with named arguments becomes nest_by() + mutate() & list()
models <- by_cyl \%>\% do(mod = lm(mpg ~ disp, data = .))
# ->
models <- mtcars \%>\%
  nest_by(cyl) \%>\%
  mutate(mod = list(lm(mpg ~ disp, data = data)))
models \%>\% summarise(rsq = summary(mod)$r.squared)

# use broom to turn models into data
models \%>\% do(data.frame(
  var = names(coef(.$mod)),
  coef(summary(.$mod)))
)
\dontshow{if (requireNamespace("broom", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# ->
models \%>\% reframe(broom::tidy(mod))
\dontshow{\}) # examplesIf}
}
\keyword{internal}
