% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso-year-week-day.R
\name{iso-year-week-day-getters}
\alias{iso-year-week-day-getters}
\alias{get_year.clock_iso_year_week_day}
\alias{get_week.clock_iso_year_week_day}
\alias{get_day.clock_iso_year_week_day}
\alias{get_hour.clock_iso_year_week_day}
\alias{get_minute.clock_iso_year_week_day}
\alias{get_second.clock_iso_year_week_day}
\alias{get_millisecond.clock_iso_year_week_day}
\alias{get_microsecond.clock_iso_year_week_day}
\alias{get_nanosecond.clock_iso_year_week_day}
\title{Getters: iso-year-week-day}
\usage{
\method{get_year}{clock_iso_year_week_day}(x)

\method{get_week}{clock_iso_year_week_day}(x)

\method{get_day}{clock_iso_year_week_day}(x)

\method{get_hour}{clock_iso_year_week_day}(x)

\method{get_minute}{clock_iso_year_week_day}(x)

\method{get_second}{clock_iso_year_week_day}(x)

\method{get_millisecond}{clock_iso_year_week_day}(x)

\method{get_microsecond}{clock_iso_year_week_day}(x)

\method{get_nanosecond}{clock_iso_year_week_day}(x)
}
\arguments{
\item{x}{\verb{[clock_iso_year_week_day]}

A iso-year-week-day to get the component from.}
}
\value{
The component.
}
\description{
These are iso-year-week-day methods for the
\link[=clock-getters]{getter generics}.
\itemize{
\item \code{get_year()} returns the ISO year. Note that this can differ from the
Gregorian year.
\item \code{get_week()} returns the ISO week of the current ISO year.
\item \code{get_day()} returns a value between 1-7 indicating the weekday of the
current ISO week, where 1 = Monday and 7 = Sunday, in line with the
ISO standard.
\item There are sub-daily getters for extracting more precise components.
}
}
\examples{
x <- iso_year_week_day(2019, 50:52, 1:3)
x

# Get the ISO week
get_week(x)

# Gets the weekday, 1 = Monday, 7 = Sunday
get_day(x)

# Note that the ISO year can differ from the Gregorian year
iso <- iso_year_week_day(2019, 1, 1)
ymd <- as_year_month_day(iso)

get_year(iso)
get_year(ymd)
}
