% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-anova-tidiers.R
\name{tidy.TukeyHSD}
\alias{tidy.TukeyHSD}
\title{Tidy a(n) TukeyHSD object}
\usage{
\method{tidy}{TukeyHSD}(x, ...)
}
\arguments{
\item{x}{A \code{TukeyHSD} object return from \code{\link[stats:TukeyHSD]{stats::TukeyHSD()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row per comparison and columns:

\item{term}{Term for which levels are being compared}
\item{comparison}{Levels being compared, separated by -}
\item{estimate}{Estimate of difference}
\item{conf.low}{Low end of confidence interval of difference}
\item{conf.high}{High end of confidence interval of difference}
\item{adj.p.value}{P-value adjusted for multiple comparisons}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

fm1 <- aov(breaks ~ wool + tension, data = warpbreaks)
thsd <- TukeyHSD(fm1, "tension", ordered = TRUE)
tidy(thsd)

# may include comparisons on multiple terms
fm2 <- aov(mpg ~ as.factor(gear) * as.factor(cyl), data = mtcars)
tidy(TukeyHSD(fm2))

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[stats:TukeyHSD]{stats::TukeyHSD()}}

Other anova tidiers: 
\code{\link{tidy.anova}()},
\code{\link{tidy.aovlist}()},
\code{\link{tidy.aov}()},
\code{\link{tidy.manova}()}
}
\concept{anova tidiers}
