% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass-polr-tidiers.R, R/ordinal-tidiers.R,
%   R/survey-tidiers.R
\name{tidy.polr}
\alias{tidy.polr}
\alias{glance.polr}
\alias{augment.polr}
\alias{ordinal_tidiers}
\alias{tidy.clm}
\alias{tidy.clmm}
\alias{glance.clm}
\alias{glance.clmm}
\alias{augment.clm}
\alias{tidy.svyolr}
\alias{glance.svyolr}
\title{Tidying methods for ordinal logistic regression models}
\usage{
\method{tidy}{polr}(
  x,
  conf.int = FALSE,
  conf.level = 0.95,
  exponentiate = FALSE,
  quick = FALSE,
  ...
)

\method{glance}{polr}(x, ...)

\method{augment}{polr}(
  x,
  data = stats::model.frame(x),
  newdata,
  type.predict = c("probs", "class"),
  ...
)

\method{tidy}{clm}(
  x,
  conf.int = FALSE,
  conf.level = 0.95,
  exponentiate = FALSE,
  quick = FALSE,
  conf.type = c("profile", "Wald"),
  ...
)

\method{tidy}{clmm}(
  x,
  conf.int = FALSE,
  conf.level = 0.95,
  exponentiate = FALSE,
  quick = FALSE,
  conf.type = c("profile", "Wald"),
  ...
)

\method{glance}{clm}(x, ...)

\method{glance}{clmm}(x, ...)

\method{augment}{clm}(
  x,
  data = stats::model.frame(x),
  newdata,
  type.predict = c("prob", "class"),
  ...
)

\method{tidy}{svyolr}(
  x,
  conf.int = FALSE,
  conf.level = 0.95,
  exponentiate = FALSE,
  quick = FALSE,
  ...
)

\method{glance}{svyolr}(x, ...)
}
\arguments{
\item{x}{a model of class \code{clm}, \code{clmm}, \code{polr} or \code{svyolr}}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level of the interval, used only if
\code{conf.int=TRUE}}

\item{exponentiate}{whether to exponentiate the coefficient estimates
and confidence intervals (typical for ordinal logistic regression)}

\item{quick}{whether to compute a smaller and faster version, containing only
the term, estimate and coefficient_type columns}

\item{...}{extra arguments}

\item{data}{original data, defaults to the extracting it from the model}

\item{newdata}{if provided, performs predictions on the new data}

\item{type.predict}{type of prediction to compute for a CLM; passed on to
\code{\link[ordinal:predict.clm]{ordinal::predict.clm()}} or \code{predict.polr}}

\item{conf.type}{the type of confidence interval
(see \code{\link[ordinal:confint.clm]{ordinal::confint.clm()}})}
}
\value{
\code{tidy.clm}, \code{tidy.clmm}, \code{tidy.polr} and \code{tidy.svyolr}
return one row for each coefficient at each level of the response variable,
with six columns:
\item{term}{term in the model}
\item{estimate}{estimated coefficient}
\item{std.error}{standard error}
\item{statistic}{z-statistic}
\item{p.value}{two-sided p-value}
\item{coefficient_type}{type of coefficient, see \code{\link[ordinal:clm]{ordinal::clm()}}}

If \code{conf.int=TRUE}, it also includes columns for \code{conf.low} and

\code{glance.clm}, \code{glance.clmm}, \code{glance.polr} and \code{glance.svyolr}
return a one-row data.frame with the columns:
\item{edf}{the effective degrees of freedom}
\item{logLik}{the data's log-likelihood under the model}
\item{AIC}{the Akaike Information Criterion}
\item{BIC}{the Bayesian Information Criterion}
\item{df.residual}{residual degrees of freedom}

\code{augment.clm} and \code{augment.polr} returns
one row for each observation, with additional columns added to
the original data:
\item{.fitted}{fitted values of model}
\item{.se.fit}{standard errors of fitted values}

\code{augment} is not supportted for \code{\link[ordinal:clmm]{ordinal::clmm()}}
and \code{\link[survey:svyolr]{survey::svyolr()}} models.

All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.
}
\description{
These methods tidy the coefficients of ordinal logistic regression
models generated by \code{\link[ordinal:clm]{ordinal::clm()}} or \code{\link[ordinal:clmm]{ordinal::clmm()}}
of the \code{ordinal} package, \code{\link[MASS:polr]{MASS::polr()}} of the \code{MASS}
packge, or \code{\link[survey:svyolr]{survey::svyolr()}} of the \code{survey} package.
}
\examples{
if (require(ordinal)){
  clm_mod <- clm(rating ~ temp * contact, data = wine)
  tidy(clm_mod)
  tidy(clm_mod, conf.int = TRUE)
  tidy(clm_mod, conf.int = TRUE, conf.type = "Wald", exponentiate = TRUE)
  glance(clm_mod)
  augment(clm_mod)

  clm_mod2 <- clm(rating ~ temp, nominal = ~ contact, data = wine)
  tidy(clm_mod2)

  clmm_mod <- clmm(rating ~ temp + contact + (1 | judge), data = wine)
  tidy(clmm_mod)
  glance(clmm_mod)
}
if (require(MASS)) {
  polr_mod <- polr(Sat ~ Infl + Type + Cont, weights = Freq, data = housing)
  tidy(polr_mod, exponentiate = TRUE, conf.int = TRUE)
  glance(polr_mod)
  augment(polr_mod, type.predict = "class")
}
}
