/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "QtNoQuteComAlert.h"

#include "ui_NoQuteComAlert.h"

#include <model/webservices/url/WsUrl.h>

//#include <control/CQuteCom.h>
//#include <control/profile/CUserProfileHandler.h>

#include <presentation/qt/QtQuteCom.h>
#include <presentation/qt/QtToolBar.h>

#include <qtutil/SafeConnect.h>

#include <util/Logger.h>
#include <util/SafeDelete.h>

#include <QtGui/QtGui>

QtNoQuteComAlert::QtNoQuteComAlert(QWidget * parent, QtQuteCom & qtQuteCom)
	: _qtQuteCom(qtQuteCom){
	
	_NoQuteComAlert = new QDialog(parent);

	_ui = new Ui::NoQuteComAlert();
	_ui->setupUi(_NoQuteComAlert);

	SAFE_CONNECT(_ui->haveBtn, SIGNAL(clicked()), SLOT(haveButtonClicked()));
	SAFE_CONNECT(_ui->createBtn, SIGNAL(clicked()), SLOT(createButtonClicked()));
}

QtNoQuteComAlert::QtNoQuteComAlert(QWidget * parent, QtQuteCom & qtQuteCom, QString title, QString maintext)
	: _qtQuteCom(qtQuteCom){
	
	_NoQuteComAlert = new QDialog(parent);

	_ui = new Ui::NoQuteComAlert();
	_ui->setupUi(_NoQuteComAlert);
	
	_NoQuteComAlert->setWindowTitle(title);
	_ui->mainText->setText(maintext);

	SAFE_CONNECT(_ui->haveBtn, SIGNAL(clicked()), SLOT(haveButtonClicked()));
	SAFE_CONNECT(_ui->createBtn, SIGNAL(clicked()), SLOT(createButtonClicked()));
}

QtNoQuteComAlert::~QtNoQuteComAlert() {
	OWSAFE_DELETE(_ui);
}

void QtNoQuteComAlert::haveButtonClicked() {
	//dear user enjoy a disconnection....
	_qtQuteCom.getQtToolBar().logOff();
}

void QtNoQuteComAlert::createButtonClicked() {
	WsUrl::showQuteComAccountCreation();
}

void QtNoQuteComAlert::setDialogText(QString newtext) {
	_ui->mainText->setText(newtext);
}

void QtNoQuteComAlert::setTitle(QString newtitle) {
	_NoQuteComAlert->setWindowTitle(newtitle);
}
