/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FILTER_H
#define FILTER_H
#include "nco.h"

class filter
{
public:
	filter();
  filter(unsigned int len,const DSPFLOAT *fparam,unsigned int filterLen,DSPFLOAT centerFrequency,bool scaled);
	~filter();
	void allocate(unsigned int dataLength);
  void setFilterParams(const DSPFLOAT *fparam,unsigned int filterLen,DSPFLOAT centerFrequency,bool scaled);
	void processFM(short int *data);
  void processBP(short int *data);
	void processAM(short int *data);
  DSPFLOAT *filteredDataPtr() {return filteredDataBuffer;}
  DSPFLOAT *volumePtr() {return volumeBuffer;}
private:
	void normalizeGain();
	bool demoluteFM;
	DSPFLOAT *filteredDataBuffer;
	DSPFLOAT *volumeBuffer;
	DSPFLOAT *filterParams;
	unsigned int filterLength;
	DSPFLOAT *samplesI;
	DSPFLOAT *samplesQ;
  DSPFLOAT	resIprev;
  DSPFLOAT	resQprev;
	unsigned int length;
	NCO nco;
	DSPFLOAT frCenter;
	DSPFLOAT angleToFc;
  DSPFLOAT holdPrev;
	
};

#endif
