!***********************************************************************
! This file is part of OpenMolcas.                                     *
!                                                                      *
! OpenMolcas is free software; you can redistribute it and/or modify   *
! it under the terms of the GNU Lesser General Public License, v. 2.1. *
! OpenMolcas is distributed in the hope that it will be useful, but it *
! is provided "as is" and without any express or implied warranties.   *
! For more details see the full text of the license in the file        *
! LICENSE or in <http://www.gnu.org/licenses/>.                        *
!***********************************************************************

subroutine ass2b(D1,D2,PAO,tmp1_,tmp2_,nt,nrys)

use Constants, only: Zero
use Definitions, only: wp, iwp

implicit none
integer(kind=iwp), intent(in) :: nt, nrys
real(kind=wp), intent(in) :: D1(nRys,nt), D2(nRys,nt), PAO(nt)
real(kind=wp), intent(inout) :: tmp1_, tmp2_
integer(kind=iwp) :: iRys, iT
real(kind=wp) :: tmp1, tmp2

tmp1 = Zero
tmp2 = Zero

select case (nRys)

  case (1)
    do iT=1,nt
      tmp1 = tmp1+PAO(iT)*D1(1,iT)
      tmp2 = tmp2+PAO(iT)*D2(1,iT)
    end do

  case (2)
    do iT=1,nt
      tmp1 = tmp1+(D1(1,iT)+D1(2,iT))*PAO(iT)
      tmp2 = tmp2+(D2(1,iT)+D2(2,iT))*PAO(iT)
    end do

  case (3)
    do iT=1,nt
      tmp1 = tmp1+(D1(1,iT)+D1(2,iT)+D1(3,iT))*PAO(iT)
      tmp2 = tmp2+(D2(1,iT)+D2(2,iT)+D2(3,iT))*PAO(iT)
    end do

  case (4)
    do iT=1,nt
      tmp1 = tmp1+(D1(1,iT)+D1(2,iT)+D1(3,iT)+D1(4,iT))*PAO(iT)
      tmp2 = tmp2+(D2(1,iT)+D2(2,iT)+D2(3,iT)+D2(4,iT))*PAO(iT)
    end do

  case (5)
    do iT=1,nt
      tmp1 = tmp1+(D1(1,iT)+D1(2,iT)+D1(3,iT)+D1(4,iT)+D1(5,iT))*PAO(iT)
      tmp2 = tmp2+(D2(1,iT)+D2(2,iT)+D2(3,iT)+D2(4,iT)+D2(5,iT))*PAO(iT)
    end do

  case (6)
    do iT=1,nt
      tmp1 = tmp1+(D1(1,iT)+D1(2,iT)+D1(3,iT)+D1(4,iT)+D1(5,iT)+D1(6,iT))*PAO(iT)
      tmp2 = tmp2+(D2(1,iT)+D2(2,iT)+D2(3,iT)+D2(4,iT)+D2(5,iT)+D2(6,iT))*PAO(iT)
    end do

  case (7)
    do iT=1,nt
      tmp1 = tmp1+(D1(1,iT)+D1(2,iT)+D1(3,iT)+D1(4,iT)+D1(5,iT)+D1(6,iT)+D1(7,iT))*PAO(iT)
      tmp2 = tmp2+(D2(1,iT)+D2(2,iT)+D2(3,iT)+D2(4,iT)+D2(5,iT)+D2(6,iT)+D2(7,iT))*PAO(iT)
    end do

  case (8)
    do iT=1,nt
      tmp1 = tmp1+(D1(1,iT)+D1(2,iT)+D1(3,iT)+D1(4,iT)+D1(5,iT)+D1(6,iT)+D1(7,iT)+D1(8,iT))*PAO(iT)
      tmp2 = tmp2+(D2(1,iT)+D2(2,iT)+D2(3,iT)+D2(4,iT)+D2(5,iT)+D2(6,iT)+D2(7,iT)+D2(8,iT))*PAO(iT)
    end do

  case (9)
    do iT=1,nt
      tmp1 = tmp1+(D1(1,iT)+D1(2,iT)+D1(3,iT)+D1(4,iT)+D1(5,iT)+D1(6,iT)+D1(7,iT)+D1(8,iT)+D1(9,iT))*PAO(iT)
      tmp2 = tmp2+(D2(1,iT)+D2(2,iT)+D2(3,iT)+D2(4,iT)+D2(5,iT)+D2(6,iT)+D2(7,iT)+D2(8,iT)+D2(9,iT))*PAO(iT)
    end do

  case default
    do iT=1,nt
      do iRys=1,nRys
        tmp1 = tmp1+PAO(iT)*D1(iRys,iT)
        tmp2 = tmp2+PAO(iT)*D2(iRys,iT)
      end do
    end do

end select

tmp1_ = tmp1_+tmp1
tmp2_ = tmp2_+tmp2

end subroutine ass2b
