/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#ifndef OPENDRIM_SSHPROTOCOLSERVICEACCESS_H_
#define OPENDRIM_SSHPROTOCOLSERVICEACCESS_H_

#include "SSH_Common.h"

#include "OpenDRIM_SSHProtocolService.h"

int SSH_OpenDRIM_SSHProtocolService_load(const CMPIBroker* broker, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolService_unload(string& errorMessage);

int SSH_OpenDRIM_SSHProtocolService_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SSHProtocolService>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHProtocolService_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SSHProtocolService& instance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolService_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& newInstance, const OpenDRIM_SSHProtocolService& oldInstance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolService_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& instance, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolService_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& instance, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolService_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& instance, unsigned int& returnValue, const OpenDRIM_SSHProtocolService_RequestStateChange_In& in, OpenDRIM_SSHProtocolService_RequestStateChange_Out& out, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolService_StartService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& instance, unsigned int& returnValue, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolService_StopService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& instance, unsigned int& returnValue, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolService_ChangeAffectedElementsAssignedSequence(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& instance, unsigned int& returnValue, const OpenDRIM_SSHProtocolService_ChangeAffectedElementsAssignedSequence_In& in, OpenDRIM_SSHProtocolService_ChangeAffectedElementsAssignedSequence_Out& out, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolService_ListenOnPort(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& instance, unsigned int& returnValue, const OpenDRIM_SSHProtocolService_ListenOnPort_In& in, OpenDRIM_SSHProtocolService_ListenOnPort_Out& out, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolService_populate(OpenDRIM_SSHProtocolService& instance, string& errorMessage);

#endif /*OPENDRIM_SSHPROTOCOLSERVICEACCESS_H_*/
