/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#ifndef OIF_QML_INSTANTANEOUSGESTUREAREA_H_
#define OIF_QML_INSTANTANEOUSGESTUREAREA_H_

#include <QDeclarativeItem>

#include "gesturearea.h"

class InstantaneousGestureArea : public GestureArea {
  Q_OBJECT

 public:
  InstantaneousGestureArea() {}    /* To satisfy QML */
  InstantaneousGestureArea(QDeclarativeItem* parent, Primitive primitive);

  virtual bool IsGestureEventHandled(GestureEvent* event);
  virtual void HandleGestureUpdateEvent(bool end, GestureEvent* event);

 signals:
  /**
   * This handler is called when an instantaneous gesture occurs.
   *
   * The gesture parameter provides information about the gesture.
   *
   * If the accepted property of the GestureEvent parameter is set to false in
   * the handler, the gesture is rejected and no further signals will be emitted
   * for the gesture. The accepted property defaults to true.
   */
  void gestureOccurred(GestureEvent* gesture);

 private:
  Q_DISABLE_COPY(InstantaneousGestureArea)
};

QML_DECLARE_TYPE(InstantaneousGestureArea)

#endif  // OIF_QML_INSTANTANEOUSGESTUREAREA_H_
