/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi.test;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.dsm.dsi.StatusException;
import com.sourceforge.knecs.security.auth.DialogAuthListener;

public class TestChars {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: TestChars <dirurl>");
            System.err.println("       dirurl - place to create the test resources");
            System.exit(-1);
        }
        String url = args[0];
        DialogAuthListener dal = new DialogAuthListener();
        String[] chars = new String[]{"~", "`", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "+", "-", "_", "=", "{", "}", "[", "]", "|", ":", ";", "\"", "'", "<", ">", "?"};
        DSI dsi = new DSI(url, dal);
        for (int idx = 0; idx < chars.length; ++idx) {
            String name = "a" + chars[idx] + "b";
            try {
                System.out.println("----------------");
                System.out.println("File " + name);
                System.out.println("----------------");
                dsi.setURL(url + name);
                dsi.putDataSet("Testing name " + name);
            }
            catch (StatusException ex) {
                System.out.println("Error: " + name + " " + ex.getMessage());
            }
            try {
                System.out.println("----------------");
                System.out.println("Folder " + name);
                System.out.println("----------------");
                dsi.setURL(url);
                dsi.makeCollection("Folder " + name);
                continue;
            }
            catch (StatusException ex) {
                System.out.println("Error: " + name + " " + ex.getMessage());
            }
        }
        System.exit(0);
    }
}

