C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_vwn5.F 
C> The nwxcm_c_vwn5 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_vwn5 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{\sqrt{{\it t_2}}}}\\\\ 
C>   {\it t_4} &=& 1.575246635799487\,{\it t_3}\\\\ 
C>   {\it t_5} &=& \arctan \left({{6.15199081975908}\over{{\it t_4}
C>    +3.72744}}\right)\\\\ 
C>   {\it t_6} &=& 0.7876233178997433\,{\it t_3}\\\\ 
C>   {\it t_7} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_8} &=& 0.6203504908994001\,{\it t_7}\\\\ 
C>   {\it t_9} &=& {{1}\over{\left| 2.935818660072219\,{\it t_3}+{
C>    \it t_8}+12.9352\right| }}\\\\ 
C>   {\it t_{10}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.10498\right)^2\,{\it t_9}\right)\\\\ 
C>   {\it t_{11}} &=& \left| {\it t_7}\right| \\\\ 
C>   {\it t_{12}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_9}\right)\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{15}} &=& \arctan \left({{7.123108917818118}\over{{
C>    \it t_4}+1.13107}}\right)\\\\ 
C>   {\it t_{16}} &=& {{1}\over{\left| 0.8908571061768626\,{\it t_3}
C>    +{\it t_8}+13.0045\right| }}\\\\ 
C>   {\it t_{17}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.0047584\right)^2\,{\it t_{16}}\right)\\\\ 
C>   {\it t_{18}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{16}}\right)\\\\ 
C>   {\it t_{19}} &=& {{1}\over{\left| 5.560951426165705\,{\it t_3}
C>    +{\it t_8}+18.0578\right| }}\\\\ 
C>   {\it t_{20}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{\sqrt{{\it t_{20}}}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{{\it t_{20}}}}\\\\ 
C>   {\it t_{23}} &=& 0.6203504908994001\,{\it t_{22}}\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\left| {\it t_{23}}
C>    +2.935818660072219\,{\it t_{21}}+12.9352\right| }}\\\\ 
C>   {\it t_{25}} &=& \left| {\it t_{22}}\right| \\\\ 
C>   {\it t_{26}} &=& \log \left(0.6203504908994001\,{\it t_{24}}
C>    \,{\it t_{25}}\right)\\\\ 
C>   {\it t_{27}} &=& 0.7876233178997433\,{\it t_{21}}\\\\ 
C>   {\it t_{28}} &=& \log \left(1.0\,{\it t_{24}}\,\left({\it t_{27}}
C>    +0.10498\right)^2\right)\\\\ 
C>   {\it t_{29}} &=& 1.575246635799487\,{\it t_{21}}\\\\ 
C>   {\it t_{30}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{29}}+3.72744}}\right)\\\\ 
C>   {\it t_{31}} &=& {{1}\over{\left| {\it t_{23}}
C>    +0.8908571061768626\,{\it t_{21}}+13.0045\right| }}\\\\ 
C>   {\it t_{32}} &=& \log \left(0.6203504908994001\,{\it t_{31}}
C>    \,{\it t_{25}}\right)\\\\ 
C>   {\it t_{33}} &=& \log \left(1.0\,{\it t_{31}}\,\left({\it t_{27}}
C>    +0.0047584\right)^2\right)\\\\ 
C>   {\it t_{34}} &=& \arctan \left({{7.123108917818118}\over{{
C>    \it t_{29}}+1.13107}}\right)\\\\ 
C>   {\it t_{35}} &=& {{1}\over{\left| {\it t_{23}}
C>    +5.560951426165705\,{\it t_{21}}+18.0578\right| }}\\\\ 
C>   f &=& 1.0\,{\it t_1}\,\left(1.125\,\left(\left({\it t_{13}}
C>    \,{\it t_{14}}+1.0\right)^{{{4}\over{3}}}+\left(1.0-{
C>    \it t_{13}}\,{\it t_{14}}\right)^{{{4}\over{3}}}-2.0\right)
C>    \,\left({{{\it t_{13}}^4\,\left(1.709920934161365\,
C>    \left(0.01554535\,\log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{19}}\right)+0.002247867095542611\,\log \left(1.0
C>    \,\left({\it t_6}+0.325\right)^2\,{\it t_{19}}\right)
C>    -0.0310907\,{\it t_{12}}-9.690227711544375 \times 10^{-4}\,{
C>    \it t_{10}}+0.05249139316978092\,\arctan 
C>    \left({{4.730926909560114}\over{{\it t_4}+7.06042}}\right)
C>    -0.03878329487811301\,{\it t_5}\right)+0.01688686394038963
C>    \,{\it t_{18}}+6.991732350764465 \times 10^{-6}\,{\it t_{17}}
C>    +0.005365091848883603\,{\it t_{15}}\right)}\over{{\it t_1}^4}}
C>    -0.01688686394038963\,{\it t_{18}}-6.991732350764465 \times 10^{
C>    -6}\,{\it t_{17}}-0.005365091848883603\,{\it t_{15}}\right)
C>    +0.0310907\,{\it t_{12}}+9.690227711544375 \times 10^{-4}\,{
C>    \it t_{10}}+0.03878329487811301\,{\it t_5}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.5848223622634643\,\left(1.0\,
C>    \left(1.709920934161365\,\left(0.05249139316978092
C>    \,\arctan \left({{4.730926909560114}\over{{\it t_{29}}
C>    +7.06042}}\right)-0.03878329487811301\,{\it t_{30}}
C>    +0.002247867095542611\,\log \left(1.0\,{\it t_{35}}\,\left({
C>    \it t_{27}}+0.325\right)^2\right)-9.690227711544375 \times 10^{
C>    -4}\,{\it t_{28}}+0.01554535\,\log \left(0.6203504908994001
C>    \,{\it t_{35}}\,{\it t_{25}}\right)-0.0310907\,{
C>    \it t_{26}}\right)+0.005365091848883603\,{\it t_{34}}
C>    +6.991732350764465 \times 10^{-6}\,{\it t_{33}}
C>    +0.01688686394038963\,{\it t_{32}}\right)-0.005365091848883603
C>    \,{\it t_{34}}-6.991732350764465 \times 10^{-6}\,{\it t_{33}}
C>    -0.01688686394038963\,{\it t_{32}}\right)+0.03878329487811301
C>    \,{\it t_{30}}+9.690227711544375 \times 10^{-4}\,{\it t_{28}}
C>    +0.0310907\,{\it t_{26}}\right)\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] SH Vosko, L Wilk, M Nusair, Can.J.Phys. 58, 1200 (1980)  , DOI: 
C> <a href="http://dx.doi.org/10.1139/p80-159 "> 
C> 10.1139/p80-159 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_vwn5(param,tol_rho,ipol,nq,wght, 
     +rho,fnc,Amat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 4.9237251092134837d-1*t4
            t6 = 1/abs(t5+2.615517080950829d+0*t3+1.29352d+1)
            t7 = abs(t4)
            t8 = t5+2.615517080950828d+0*t3+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = 7.016926042943222d-1*t3+1.0498d-1
            t12 = t11**2
            t13 = 1.4033852085886445d+0*t3+3.72744d+0
            t14 = 1/t7
            t15 = 1/t2**3
            t16 = 1/rhoa**6.666666666666667d-1
            t17 = -2.1795975674590234d-1*t15*t16-8.206208515355806d-2/rh
     1         oa**1.3333333333333333d+0
            t18 = 1/t8
            t19 = 1/t13**2
            fnc(iq) = 2.0d+0*rhoa*(3.10907d-2*log(4.9237251092134837d-1*
     1         t6*t7)+9.690227711544375d-4*log(1.0d+0*(7.016926042943223
     2         d-1*t3+1.0498d-1)**2*t6)+3.8783294878113006d-2*atan(6.151
     3         99081975908d+0/(1.4033852085886447d+0*t3+3.72744d+0)))*wg
     4         ht+fnc(iq)
            Amat(iq,D1_RA) = 2.0d+0*rhoa*(6.314467057030004d-2*t14*(-4.9
     1         237251092134837d-1*t10*t17*t18*t7-8.206208515355806d-2*t1
     2         0*t14/rhoa**1.6666666666666666d+0)*t9+9.690227711544375d-
     3         4*(-1.0d+0*t10*t12*t17*t18-1.1694876738238703d-1*t10*t11*
     4         t15*t16)*t9/t12+2.790332964441521d-2*t15*t16*t19/(3.78469
     5         9104639999d+1*t19+1))*wght+1.0d+0*(3.10907d-2*log(4.92372
     6         51092134837d-1*t10*t7)+3.8783294878113006d-2*atan(6.15199
     7         081975908d+0/t13)+9.690227711544375d-4*log(1.0d+0*t10*t12
     8         ))*wght+Amat(iq,D1_RA)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = t2**5.0d-1
            t4 = 1/t3
            t5 = 1.5752466357994865d+0*t4
            t6 = t5+3.72744d+0
            t7 = atan(6.15199081975908d+0/t6)
            t8 = 7.876233178997433d-1*t4
            t9 = t8+1.0498d-1
            t10 = t9**2
            t11 = 1/t2
            t12 = 6.203504908994001d-1*t11
            t13 = 2.935818660072219d+0*t4+t12+1.29352d+1
            t14 = abs(t13)
            t15 = 1/t14
            t16 = log(1.0d+0*t10*t15)
            t17 = abs(t11)
            t18 = log(6.203504908994001d-1*t15*t17)
            t19 = rhoa-rhob
            t20 = 1/t1
            t21 = 1.0d+0-t19*t20
            t22 = t19*t20+1.0d+0
            t23 = t22**1.3333333333333333d+0+t21**1.3333333333333333d+0-
     1         2.0d+0
            t24 = t5+1.13107d+0
            t25 = atan(7.123108917818117d+0/t24)
            t26 = t8+4.7584000000000004d-3
            t27 = t26**2
            t28 = 8.908571061768626d-1*t4+t12+1.30045d+1
            t29 = abs(t28)
            t30 = 1/t29
            t31 = log(1.0d+0*t27*t30)
            t32 = log(6.203504908994001d-1*t17*t30)
            t33 = t19**4
            t34 = 1/t1**4
            t35 = t5+7.06042d+0
            t36 = t8+3.25d-1
            t37 = t36**2
            t38 = 5.560951426165704d+0*t4+t12+1.8057800000000002d+1
            t39 = abs(t38)
            t40 = 1/t39
            t41 = 1.709920934161365d+0*(-3.8783294878113006d-2*t7+2.2478
     1         670955426108d-3*log(1.0d+0*t37*t40)+1.554535d-2*log(6.203
     2         504908994001d-1*t17*t40)+5.249139316978092d-2*atan(4.7309
     3         269095601136d+0/t35)-3.10907d-2*t18-9.690227711544375d-4*
     4         t16)+1.688686394038963d-2*t32+6.991732350764465d-6*t31+5.
     5         365091848883603d-3*t25
            t42 = t33*t34*t41-1.688686394038963d-2*t32-6.991732350764465
     1         d-6*t31-5.365091848883603d-3*t25
            t43 = 3.8783294878113006d-2*t7+1.1250000000000002d+0*t23*t42
     1         +3.10907d-2*t18+9.690227711544375d-4*t16
            t44 = 1/t1**6.666666666666667d-1
            t45 = 1/t3**3
            t46 = 1/t6**2
            t47 = 1/(3.784699104639999d+1*t46+1)
            t48 = 6.264085709464389d-2*t44*t45*t46*t47
            t49 = 1/t10
            t50 = -2.067834969664667d-1/t1**1.3333333333333333d+0
            t51 = t50-4.8930311001203647d-1*t44*t45
            t52 = 1/t13
            t53 = -2.625411059665811d-1*t15*t44*t45*t9-1.0d+0*t10*t15*t5
     1         1*t52
            t54 = 9.690227711544375d-4*t14*t49*t53
            t55 = 1/t17
            t56 = 1/t1**1.6666666666666666d+0
            t57 = -2.067834969664667d-1*t15*t55*t56-6.203504908994001d-1
     1         *t15*t17*t51*t52
            t58 = 5.011795824473985d-2*t14*t55*t57
            t59 = 1/t24**2
            t60 = 1/(5.07386806551d+1*t59+1)
            t61 = -1.0033305979455584d-2*t44*t45*t59*t60
            t62 = 1/t27
            t63 = t50-1.4847618436281043d-1*t44*t45
            t64 = 1/t28
            t65 = -1.0d+0*t27*t30*t63*t64-2.625411059665811d-1*t26*t30*t
     1         44*t45
            t66 = -6.991732350764465d-6*t29*t62*t65
            t67 = -6.203504908994001d-1*t17*t30*t63*t64-2.06783496966466
     1         7d-1*t30*t55*t56
            t68 = -2.722148880047894d-2*t29*t55*t67
            t69 = 1/t35**2
            t70 = t50-9.26825237694284d-1*t44*t45
            t71 = 1/t38
            t72 = t33*t34*(1.709920934161365d+0*(2.2478670955426108d-3*t
     1         39*(-1.0d+0*t37*t40*t70*t71-2.625411059665811d-1*t36*t40*
     2         t44*t45)/t37+2.5058979122369923d-2*t39*t55*(-6.2035049089
     3         94001d-1*t17*t40*t70*t71-2.067834969664667d-1*t40*t55*t56
     4         )+6.519760588836059d-2*t44*t45*t69/(2.238166942360001d+1*
     5         t69+1)-5.011795824473985d-2*t14*t55*t57-9.690227711544375
     6         d-4*t14*t49*t53-6.264085709464389d-2*t44*t45*t46*t47)+2.7
     7         22148880047894d-2*t29*t55*t67+6.991732350764465d-6*t29*t6
     8         2*t65+1.0033305979455584d-2*t44*t45*t59*t60)
            t73 = -4*t33*t41/t1**5
            t74 = t19**3
            t75 = 1/t1**2
            t76 = t19*t75
            t77 = -t20
            t78 = t21**3.333333333333333d-1
            t79 = -t19*t75
            t80 = t22**3.333333333333333d-1
            t81 = 1.0d+0*t43*wght
            fnc(iq) = 1.0d+0*t1*t43*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*(1.1250000000000002d+0*t42*(1.333
     1         3333333333333d+0*(t79+t20)*t80+1.3333333333333333d+0*(t77
     2         +t76)*t78)+1.1250000000000002d+0*t23*(4*t34*t41*t74+t73+t
     3         72+t68+t66+t61)+t58+t54+t48)*wght+t81+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*(1.1250000000000002d+0*t42*(1.333
     1         3333333333333d+0*(t79+t77)*t80+1.3333333333333333d+0*(t76
     2         +t20)*t78)+1.1250000000000002d+0*t23*(-4*t34*t41*t74+t73+
     3         t72+t68+t66+t61)+t58+t54+t48)*wght+t81+Amat(iq,D1_RB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+8.908571061768626d-1*t3+1.30045d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = log(6.203504908994001d-1*t20*t9)
            t22 = t11+4.7584000000000004d-3
            t23 = t22**2
            t24 = log(1.0d+0*t20*t23)
            t25 = t15+1.13107d+0
            t26 = atan(7.123108917818117d+0/t25)
            t27 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = t11+3.25d-1
            t31 = t30**2
            t32 = t15+7.06042d+0
            t33 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         554535d-2*log(6.203504908994001d-1*t29*t9)+5.249139316978
     2         092d-2*atan(4.7309269095601136d+0/t32)+2.2478670955426108
     3         d-3*log(1.0d+0*t29*t31)-3.8783294878113006d-2*t17-9.69022
     4         7711544375d-4*t14-3.10907d-2*t10)+5.365091848883603d-3*t2
     5         6+6.991732350764465d-6*t24+1.688686394038963d-2*t21)-5.36
     6         5091848883603d-3*t26-6.991732350764465d-6*t24-1.688686394
     7         038963d-2*t21)+3.8783294878113006d-2*t17+9.69022771154437
     8         5d-4*t14+3.10907d-2*t10
            t34 = 1/t9
            t35 = -2.067834969664667d-1/rhoa**1.3333333333333333d+0
            t36 = 1/t2**3
            t37 = 1/rhoa**6.666666666666667d-1
            t38 = t35-4.8930311001203647d-1*t36*t37
            t39 = 1/t6
            t40 = 1/rhoa**1.6666666666666666d+0
            t41 = -6.203504908994001d-1*t38*t39*t8*t9-2.067834969664667d
     1         -1*t34*t40*t8
            t42 = 1/t16**2
            t43 = 1/(3.784699104639999d+1*t42+1)
            t44 = 1/t13
            t45 = -1.0d+0*t13*t38*t39*t8-2.625411059665811d-1*t12*t36*t3
     1         7*t8
            t46 = t35-1.4847618436281043d-1*t36*t37
            t47 = 1/t18
            t48 = -6.203504908994001d-1*t20*t46*t47*t9-2.067834969664667
     1         d-1*t20*t34*t40
            t49 = 1/t25**2
            t50 = 1/(5.07386806551d+1*t49+1)
            t51 = 1/t23
            t52 = -1.0d+0*t20*t23*t46*t47-2.625411059665811d-1*t20*t22*t
     1         36*t37
            t53 = t35-9.26825237694284d-1*t36*t37
            t54 = 1/t27
            t55 = 1/t32**2
            fnc(iq) = 1.0d+0*rhoa*t33*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*(5.848223622634643d-1*(1.0d+0*(
     1         1.709920934161365d+0*(2.5058979122369923d-2*t28*t34*(-6.2
     2         03504908994001d-1*t29*t53*t54*t9-2.067834969664667d-1*t29
     3         *t34*t40)-9.690227711544375d-4*t44*t45*t7-5.0117958244739
     4         85d-2*t34*t41*t7+6.519760588836059d-2*t36*t37*t55/(2.2381
     5         66942360001d+1*t55+1)+2.2478670955426108d-3*t28*(-1.0d+0*
     6         t29*t31*t53*t54-2.625411059665811d-1*t29*t30*t36*t37)/t31
     7         -6.264085709464389d-2*t36*t37*t42*t43)+6.991732350764465d
     8         -6*t19*t51*t52+1.0033305979455584d-2*t36*t37*t49*t50+2.72
     9         2148880047894d-2*t19*t34*t48)-6.991732350764465d-6*t19*t5
     :         1*t52-1.0033305979455584d-2*t36*t37*t49*t50-2.72214888004
     ;         7894d-2*t19*t34*t48)+9.690227711544375d-4*t44*t45*t7+5.01
     <         1795824473985d-2*t34*t41*t7+6.264085709464389d-2*t36*t37*
     =         t42*t43)*wght+1.0d+0*t33*wght+Amat(iq,D1_RA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+8.908571061768626d-1*t3+1.30045d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = log(6.203504908994001d-1*t20*t9)
            t22 = t11+4.7584000000000004d-3
            t23 = t22**2
            t24 = log(1.0d+0*t20*t23)
            t25 = t15+1.13107d+0
            t26 = atan(7.123108917818117d+0/t25)
            t27 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = t11+3.25d-1
            t31 = t30**2
            t32 = t15+7.06042d+0
            t33 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         554535d-2*log(6.203504908994001d-1*t29*t9)+5.249139316978
     2         092d-2*atan(4.7309269095601136d+0/t32)+2.2478670955426108
     3         d-3*log(1.0d+0*t29*t31)-3.8783294878113006d-2*t17-9.69022
     4         7711544375d-4*t14-3.10907d-2*t10)+5.365091848883603d-3*t2
     5         6+6.991732350764465d-6*t24+1.688686394038963d-2*t21)-5.36
     6         5091848883603d-3*t26-6.991732350764465d-6*t24-1.688686394
     7         038963d-2*t21)+3.8783294878113006d-2*t17+9.69022771154437
     8         5d-4*t14+3.10907d-2*t10
            t34 = 1/t9
            t35 = -2.067834969664667d-1/rhob**1.3333333333333333d+0
            t36 = 1/t2**3
            t37 = 1/rhob**6.666666666666667d-1
            t38 = t35-4.8930311001203647d-1*t36*t37
            t39 = 1/t6
            t40 = 1/rhob**1.6666666666666666d+0
            t41 = -6.203504908994001d-1*t38*t39*t8*t9-2.067834969664667d
     1         -1*t34*t40*t8
            t42 = 1/t16**2
            t43 = 1/(3.784699104639999d+1*t42+1)
            t44 = 1/t13
            t45 = -1.0d+0*t13*t38*t39*t8-2.625411059665811d-1*t12*t36*t3
     1         7*t8
            t46 = t35-1.4847618436281043d-1*t36*t37
            t47 = 1/t18
            t48 = -6.203504908994001d-1*t20*t46*t47*t9-2.067834969664667
     1         d-1*t20*t34*t40
            t49 = 1/t25**2
            t50 = 1/(5.07386806551d+1*t49+1)
            t51 = 1/t23
            t52 = -1.0d+0*t20*t23*t46*t47-2.625411059665811d-1*t20*t22*t
     1         36*t37
            t53 = t35-9.26825237694284d-1*t36*t37
            t54 = 1/t27
            t55 = 1/t32**2
            fnc(iq) = 1.0d+0*rhob*t33*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*(5.848223622634643d-1*(1.0d+0*(
     1         1.709920934161365d+0*(2.5058979122369923d-2*t28*t34*(-6.2
     2         03504908994001d-1*t29*t53*t54*t9-2.067834969664667d-1*t29
     3         *t34*t40)-9.690227711544375d-4*t44*t45*t7-5.0117958244739
     4         85d-2*t34*t41*t7+6.519760588836059d-2*t36*t37*t55/(2.2381
     5         66942360001d+1*t55+1)+2.2478670955426108d-3*t28*(-1.0d+0*
     6         t29*t31*t53*t54-2.625411059665811d-1*t29*t30*t36*t37)/t31
     7         -6.264085709464389d-2*t36*t37*t42*t43)+6.991732350764465d
     8         -6*t19*t51*t52+1.0033305979455584d-2*t36*t37*t49*t50+2.72
     9         2148880047894d-2*t19*t34*t48)-6.991732350764465d-6*t19*t5
     :         1*t52-1.0033305979455584d-2*t36*t37*t49*t50-2.72214888004
     ;         7894d-2*t19*t34*t48)+9.690227711544375d-4*t44*t45*t7+5.01
     <         1795824473985d-2*t34*t41*t7+6.264085709464389d-2*t36*t37*
     =         t42*t43)*wght+1.0d+0*t33*wght+Amat(iq,D1_RB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_vwn5 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{\sqrt{{\it t_2}}}}\\\\ 
C>   {\it t_4} &=& 1.575246635799487\,{\it t_3}\\\\ 
C>   {\it t_5} &=& \arctan \left({{6.15199081975908}\over{{\it t_4}
C>    +3.72744}}\right)\\\\ 
C>   {\it t_6} &=& 0.7876233178997433\,{\it t_3}\\\\ 
C>   {\it t_7} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_8} &=& 0.6203504908994001\,{\it t_7}\\\\ 
C>   {\it t_9} &=& {{1}\over{\left| 2.935818660072219\,{\it t_3}+{
C>    \it t_8}+12.9352\right| }}\\\\ 
C>   {\it t_{10}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.10498\right)^2\,{\it t_9}\right)\\\\ 
C>   {\it t_{11}} &=& \left| {\it t_7}\right| \\\\ 
C>   {\it t_{12}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_9}\right)\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{15}} &=& \arctan \left({{7.123108917818118}\over{{
C>    \it t_4}+1.13107}}\right)\\\\ 
C>   {\it t_{16}} &=& {{1}\over{\left| 0.8908571061768626\,{\it t_3}
C>    +{\it t_8}+13.0045\right| }}\\\\ 
C>   {\it t_{17}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.0047584\right)^2\,{\it t_{16}}\right)\\\\ 
C>   {\it t_{18}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{16}}\right)\\\\ 
C>   {\it t_{19}} &=& {{1}\over{\left| 5.560951426165705\,{\it t_3}
C>    +{\it t_8}+18.0578\right| }}\\\\ 
C>   {\it t_{20}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{\sqrt{{\it t_{20}}}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{{\it t_{20}}}}\\\\ 
C>   {\it t_{23}} &=& 0.6203504908994001\,{\it t_{22}}\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\left| {\it t_{23}}
C>    +2.935818660072219\,{\it t_{21}}+12.9352\right| }}\\\\ 
C>   {\it t_{25}} &=& \left| {\it t_{22}}\right| \\\\ 
C>   {\it t_{26}} &=& \log \left(0.6203504908994001\,{\it t_{24}}
C>    \,{\it t_{25}}\right)\\\\ 
C>   {\it t_{27}} &=& 0.7876233178997433\,{\it t_{21}}\\\\ 
C>   {\it t_{28}} &=& \log \left(1.0\,{\it t_{24}}\,\left({\it t_{27}}
C>    +0.10498\right)^2\right)\\\\ 
C>   {\it t_{29}} &=& 1.575246635799487\,{\it t_{21}}\\\\ 
C>   {\it t_{30}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{29}}+3.72744}}\right)\\\\ 
C>   {\it t_{31}} &=& {{1}\over{\left| {\it t_{23}}
C>    +0.8908571061768626\,{\it t_{21}}+13.0045\right| }}\\\\ 
C>   {\it t_{32}} &=& \log \left(0.6203504908994001\,{\it t_{31}}
C>    \,{\it t_{25}}\right)\\\\ 
C>   {\it t_{33}} &=& \log \left(1.0\,{\it t_{31}}\,\left({\it t_{27}}
C>    +0.0047584\right)^2\right)\\\\ 
C>   {\it t_{34}} &=& \arctan \left({{7.123108917818118}\over{{
C>    \it t_{29}}+1.13107}}\right)\\\\ 
C>   {\it t_{35}} &=& {{1}\over{\left| {\it t_{23}}
C>    +5.560951426165705\,{\it t_{21}}+18.0578\right| }}\\\\ 
C>   f &=& 1.0\,{\it t_1}\,\left(1.125\,\left(\left({\it t_{13}}
C>    \,{\it t_{14}}+1.0\right)^{{{4}\over{3}}}+\left(1.0-{
C>    \it t_{13}}\,{\it t_{14}}\right)^{{{4}\over{3}}}-2.0\right)
C>    \,\left({{{\it t_{13}}^4\,\left(1.709920934161365\,
C>    \left(0.01554535\,\log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{19}}\right)+0.002247867095542611\,\log \left(1.0
C>    \,\left({\it t_6}+0.325\right)^2\,{\it t_{19}}\right)
C>    -0.0310907\,{\it t_{12}}-9.690227711544375 \times 10^{-4}\,{
C>    \it t_{10}}+0.05249139316978092\,\arctan 
C>    \left({{4.730926909560114}\over{{\it t_4}+7.06042}}\right)
C>    -0.03878329487811301\,{\it t_5}\right)+0.01688686394038963
C>    \,{\it t_{18}}+6.991732350764465 \times 10^{-6}\,{\it t_{17}}
C>    +0.005365091848883603\,{\it t_{15}}\right)}\over{{\it t_1}^4}}
C>    -0.01688686394038963\,{\it t_{18}}-6.991732350764465 \times 10^{
C>    -6}\,{\it t_{17}}-0.005365091848883603\,{\it t_{15}}\right)
C>    +0.0310907\,{\it t_{12}}+9.690227711544375 \times 10^{-4}\,{
C>    \it t_{10}}+0.03878329487811301\,{\it t_5}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.5848223622634643\,\left(1.0\,
C>    \left(1.709920934161365\,\left(0.05249139316978092
C>    \,\arctan \left({{4.730926909560114}\over{{\it t_{29}}
C>    +7.06042}}\right)-0.03878329487811301\,{\it t_{30}}
C>    +0.002247867095542611\,\log \left(1.0\,{\it t_{35}}\,\left({
C>    \it t_{27}}+0.325\right)^2\right)-9.690227711544375 \times 10^{
C>    -4}\,{\it t_{28}}+0.01554535\,\log \left(0.6203504908994001
C>    \,{\it t_{35}}\,{\it t_{25}}\right)-0.0310907\,{
C>    \it t_{26}}\right)+0.005365091848883603\,{\it t_{34}}
C>    +6.991732350764465 \times 10^{-6}\,{\it t_{33}}
C>    +0.01688686394038963\,{\it t_{32}}\right)-0.005365091848883603
C>    \,{\it t_{34}}-6.991732350764465 \times 10^{-6}\,{\it t_{33}}
C>    -0.01688686394038963\,{\it t_{32}}\right)+0.03878329487811301
C>    \,{\it t_{30}}+9.690227711544375 \times 10^{-4}\,{\it t_{28}}
C>    +0.0310907\,{\it t_{26}}\right)\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] SH Vosko, L Wilk, M Nusair, Can.J.Phys. 58, 1200 (1980)  , DOI: 
C> <a href="http://dx.doi.org/10.1139/p80-159 "> 
C> 10.1139/p80-159 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_vwn5_d2(param,tol_rho,ipol,nq,wght, 
     +rho,fnc,Amat,Amat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
c 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 4.9237251092134837d-1*t4
            t6 = 1/abs(t5+2.615517080950829d+0*t3+1.29352d+1)
            t7 = abs(t4)
            t8 = t5+2.615517080950828d+0*t3+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = 7.016926042943222d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = 1.4033852085886445d+0*t3
            t15 = t14+3.72744d+0
            t16 = 1/t7
            t17 = 1/t2**3
            t18 = 1/rhoa**6.666666666666667d-1
            t19 = -2.1795975674590234d-1*t17*t18-8.206208515355806d-2/rh
     1         oa**1.3333333333333333d+0
            t20 = 1/t8
            t21 = 1/rhoa**1.6666666666666666d+0
            t22 = -4.9237251092134837d-1*t10*t19*t20*t7-8.20620851535580
     1         6d-2*t10*t16*t21
            t23 = 1/t15**2
            t24 = 3.784699104639999d+1*t23+1
            t25 = 1/t24
            t26 = 1/t13
            t27 = -1.0d+0*t10*t13*t19*t20-1.1694876738238703d-1*t10*t12*
     1         t17*t18
            t28 = 9.690227711544375d-4*t26*t27*t9+6.314467057030004d-2*t
     1         16*t22*t9+2.790332964441521d-2*t17*t18*t23*t25
            t29 = 2.0d+0*t28*wght
            t30 = 1/rhoa**2.3333333333333334d+0
            t31 = -2.470091445929572d-1*t30/(t15**5*t24**2)
            t32 = 6.526520015557556d-3*t25*t30/t15**3
            t33 = 1/abs(t5+7.93663453939179d-1*t3+1.30045d+1)
            t34 = -1.688686394038963d-2*log(4.9237251092134837d-1*t33*t7
     1         )-6.991732350764465d-6*log(1.0d+0*(t11+4.7584000000000004
     2         d-3)**2*t33)-5.365091848883603d-3*atan(7.123108917818117d
     3         +0/(t14+1.13107d+0))
            t35 = 1/rhoa**2
            t36 = 1/rhoa**1.6666666666666669d+0
            t37 = -9.301109881471736d-3*t17*t23*t25*t36
            t38 = t19**2
            t39 = 1/t8**2
            t40 = 1/t2**5
            t41 = 1/rhoa**1.3333333333333336d+0
            t42 = 5.448993918647558d-2*t40*t41+7.265325224863413d-2*t17*
     1         t36+5.470805676903872d-2/rhoa**2.333333333333333d+0
            t43 = 6.314467057030004d-2*t16*(-4.9237251092134837d-1*t10*t
     1         20*t42*t7+9.847450218426967d-1*t10*t38*t39*t7+1.641241703
     2         0711612d-1*t10*t16*t19*t20*t21+5.470805676903869d-2*t10*t
     3         16/rhoa**2.6666666666666666d+0)*t9
            t44 = -6.975832411103801d-3*t23*t25*t40*t41
            t45 = 1.0524111761716676d-2*t16*t22*t9/rhoa**9.9999999999999
     1         99d-1
            t46 = 1.1332601865197636d-4*t17*t18*t27*t9/t12**3
            t47 = 9.690227711544375d-4*t26*(-1.0d+0*t10*t13*t20*t42+2.92
     1         3719184559675d-2*t10*t12*t40*t41+2.0d+0*t10*t13*t38*t39+3
     2         .898292246079568d-2*t10*t12*t17*t36+6.838507096129838d-3*
     3         t10*t30+2.3389753476477407d-1*t10*t12*t17*t18*t19*t20)*t9
            t48 = 6.314467057030004d-2*t10*t16*t19*t22*t8
            t49 = 9.690227711544375d-4*t10*t19*t26*t27*t8
            fnc(iq) = 2.0d+0*rhoa*(3.10907d-2*log(4.9237251092134837d-1*
     1         t6*t7)+9.690227711544375d-4*log(1.0d+0*(7.016926042943223
     2         d-1*t3+1.0498d-1)**2*t6)+3.8783294878113006d-2*atan(6.151
     3         99081975908d+0/(1.4033852085886447d+0*t3+3.72744d+0)))*wg
     4         ht+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(3.10907d-2*log(4.9237251092134837d-
     1         1*t10*t7)+3.8783294878113006d-2*atan(6.15199081975908d+0/
     2         t15)+9.690227711544375d-4*log(1.0d+0*t10*t13))*wght+2.0d+
     3         0*rhoa*t28*wght+Amat(iq,D1_RA)
            Amat2(iq,D2_RA_RA) = 2.0d+0*rhoa*(t49+t48+t47+t46+t45+t44+t4
     1         3+t37+2.5000000000000006d-1*t34*t35+t32+t31)*wght+t29+Ama
     2         t2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 2.0d+0*rhoa*(t49+t48+t47+t46+t45+t44+t4
     1         3+t37-2.5000000000000006d-1*t34*t35+t32+t31)*wght+t29+Ama
     2         t2(iq,D2_RA_RB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = t2**5.0d-1
            t4 = 1/t3
            t5 = 1.5752466357994865d+0*t4
            t6 = t5+3.72744d+0
            t7 = atan(6.15199081975908d+0/t6)
            t8 = 7.876233178997433d-1*t4
            t9 = t8+1.0498d-1
            t10 = t9**2
            t11 = 1/t2
            t12 = 6.203504908994001d-1*t11
            t13 = 2.935818660072219d+0*t4+t12+1.29352d+1
            t14 = abs(t13)
            t15 = 1/t14
            t16 = log(1.0d+0*t10*t15)
            t17 = abs(t11)
            t18 = log(6.203504908994001d-1*t15*t17)
            t19 = rhoa-rhob
            t20 = 1/t1
            t21 = 1.0d+0-t19*t20
            t22 = t19*t20+1.0d+0
            t23 = t22**1.3333333333333333d+0+t21**1.3333333333333333d+0-
     1         2.0d+0
            t24 = t5+1.13107d+0
            t25 = atan(7.123108917818117d+0/t24)
            t26 = t8+4.7584000000000004d-3
            t27 = t26**2
            t28 = 8.908571061768626d-1*t4+t12+1.30045d+1
            t29 = abs(t28)
            t30 = 1/t29
            t31 = log(1.0d+0*t27*t30)
            t32 = log(6.203504908994001d-1*t17*t30)
            t33 = t19**4
            t34 = 1/t1**4
            t35 = t5+7.06042d+0
            t36 = t8+3.25d-1
            t37 = t36**2
            t38 = 5.560951426165704d+0*t4+t12+1.8057800000000002d+1
            t39 = abs(t38)
            t40 = 1/t39
            t41 = 1.709920934161365d+0*(-3.8783294878113006d-2*t7+2.2478
     1         670955426108d-3*log(1.0d+0*t37*t40)+1.554535d-2*log(6.203
     2         504908994001d-1*t17*t40)+5.249139316978092d-2*atan(4.7309
     3         269095601136d+0/t35)-3.10907d-2*t18-9.690227711544375d-4*
     4         t16)+1.688686394038963d-2*t32+6.991732350764465d-6*t31+5.
     5         365091848883603d-3*t25
            t42 = t33*t34*t41-1.688686394038963d-2*t32-6.991732350764465
     1         d-6*t31-5.365091848883603d-3*t25
            t43 = 3.8783294878113006d-2*t7+1.1250000000000002d+0*t23*t42
     1         +3.10907d-2*t18+9.690227711544375d-4*t16
            t44 = 1/t1**6.666666666666667d-1
            t45 = 1/t3**3
            t46 = 1/t6**2
            t47 = 3.784699104639999d+1*t46+1
            t48 = 1/t47
            t49 = 6.264085709464389d-2*t44*t45*t46*t48
            t50 = 1/t10
            t51 = -2.067834969664667d-1/t1**1.3333333333333333d+0
            t52 = t51-4.8930311001203647d-1*t44*t45
            t53 = 1/t13
            t54 = -2.625411059665811d-1*t15*t44*t45*t9-1.0d+0*t10*t15*t5
     1         2*t53
            t55 = 9.690227711544375d-4*t14*t50*t54
            t56 = 1/t17
            t57 = 1/t1**1.6666666666666666d+0
            t58 = -2.067834969664667d-1*t15*t56*t57-6.203504908994001d-1
     1         *t15*t17*t52*t53
            t59 = 5.011795824473985d-2*t14*t56*t58
            t60 = 1/t24**2
            t61 = 5.07386806551d+1*t60+1
            t62 = 1/t61
            t63 = -1.0033305979455584d-2*t44*t45*t60*t62
            t64 = 1/t27
            t65 = t51-1.4847618436281043d-1*t44*t45
            t66 = 1/t28
            t67 = -1.0d+0*t27*t30*t65*t66-2.625411059665811d-1*t26*t30*t
     1         44*t45
            t68 = -6.991732350764465d-6*t29*t64*t67
            t69 = -6.203504908994001d-1*t17*t30*t65*t66-2.06783496966466
     1         7d-1*t30*t56*t57
            t70 = -2.722148880047894d-2*t29*t56*t69
            t71 = 1/t35**2
            t72 = 2.238166942360001d+1*t71+1
            t73 = 1/t72
            t74 = 1/t37
            t75 = t51-9.26825237694284d-1*t44*t45
            t76 = 1/t38
            t77 = -1.0d+0*t37*t40*t75*t76-2.625411059665811d-1*t36*t40*t
     1         44*t45
            t78 = -6.203504908994001d-1*t17*t40*t75*t76-2.06783496966466
     1         7d-1*t40*t56*t57
            t79 = 1.709920934161365d+0*(2.5058979122369923d-2*t39*t56*t7
     1         8+2.2478670955426108d-3*t39*t74*t77+6.519760588836059d-2*
     2         t44*t45*t71*t73-5.011795824473985d-2*t14*t56*t58-9.690227
     3         711544375d-4*t14*t50*t54-6.264085709464389d-2*t44*t45*t46
     4         *t48)+2.722148880047894d-2*t29*t56*t69+6.991732350764465d
     5         -6*t29*t64*t67+1.0033305979455584d-2*t44*t45*t60*t62
            t80 = t33*t34*t79
            t81 = 1/t1**5
            t82 = -4*t33*t41*t81
            t83 = t19**3
            t84 = 4*t34*t41*t83+t82+t80+t70+t68+t63
            t85 = 1/t1**2
            t86 = t19*t85
            t87 = -t20
            t88 = t87+t86
            t89 = t21**3.333333333333333d-1
            t90 = -t19*t85
            t91 = t90+t20
            t92 = t22**3.333333333333333d-1
            t93 = 1.3333333333333333d+0*t91*t92+1.3333333333333333d+0*t8
     1         8*t89
            t94 = 1.1250000000000002d+0*t42*t93+1.1250000000000002d+0*t2
     1         3*t84+t59+t55+t49
            t95 = 1.0d+0*t43*wght
            t96 = -4*t34*t41*t83+t82+t80+t70+t68+t63
            t97 = t86+t20
            t98 = t90+t87
            t99 = 1.3333333333333333d+0*t92*t98+1.3333333333333333d+0*t8
     1         9*t97
            t100 = 1.1250000000000002d+0*t42*t99+1.1250000000000002d+0*t
     1         23*t96+t59+t55+t49
            t101 = 1/t1**2.3333333333333334d+0
            t102 = 1/t6**5
            t103 = 1/t47**2
            t104 = -1.2448480831567728d+0*t101*t102*t103
            t105 = 1/t6**3
            t106 = 3.289159980064472d-2*t101*t105*t48
            t107 = 1/t1**1.3333333333333336d+0
            t108 = 1/t3**5
            t109 = -3.1320428547321943d-2*t107*t108*t46*t48
            t110 = 1/t1**1.6666666666666669d+0
            t111 = -4.176057139642926d-2*t110*t45*t46*t48
            t112 = 9.690227711544375d-4*t13*t15*t50*t52*t54
            t113 = 5.011795824473985d-2*t13*t15*t52*t56*t58
            t114 = t52**2
            t115 = 1/t13**2
            t116 = 2.7571132928862224d-1/t1**2.333333333333333d+0
            t117 = 3.262020733413577d-1*t110*t45+t116+2.4465155500601823
     1         d-1*t107*t108
            t118 = 5.250822119331622d-1*t15*t44*t45*t52*t53*t9+1.7502740
     1         397772074d-1*t110*t15*t45*t9+1.3127055298329054d-1*t107*t
     2         108*t15*t9-1.0d+0*t10*t117*t15*t53+2.0d+0*t10*t114*t115*t
     3         15+3.446391616107778d-2*t101*t15
            t119 = 9.690227711544375d-4*t118*t14*t50
            t120 = 1/t9**3
            t121 = 2.544083100456872d-4*t120*t14*t44*t45*t54
            t122 = 1/t1**2.6666666666666666d+0
            t123 = 4.135669939329334d-1*t15*t52*t53*t56*t57+2.7571132928
     1         862224d-1*t122*t15*t56-6.203504908994001d-1*t117*t15*t17*
     2         t53+1.2407009817988002d+0*t114*t115*t15*t17
            t124 = 5.011795824473985d-2*t123*t14*t56
            t125 = 1/t1**9.999999999999999d-1
            t126 = 1.670598608157995d-2*t125*t14*t56*t58
            t127 = 1/t24**5
            t128 = 1/t61**2
            t129 = 2.6730712388370664d-1*t101*t127*t128
            t130 = 1/t24**3
            t131 = -5.26831049669476d-3*t101*t130*t62
            t132 = 5.016652989727792d-3*t107*t108*t60*t62
            t133 = 6.68887065297039d-3*t110*t45*t60*t62
            t134 = -6.991732350764465d-6*t28*t30*t64*t65*t67
            t135 = -2.722148880047894d-2*t28*t30*t56*t65*t69
            t136 = t65**2
            t137 = 1/t28**2
            t138 = 9.89841229085403d-2*t110*t45+t116+7.423809218140521d-
     1         2*t107*t108
            t139 = 5.250822119331622d-1*t26*t30*t44*t45*t65*t66-1.0d+0*t
     1         138*t27*t30*t66+1.7502740397772074d-1*t110*t26*t30*t45+2.
     2         0d+0*t136*t137*t27*t30+1.3127055298329054d-1*t107*t108*t2
     3         6*t30+3.446391616107778d-2*t101*t30
            t140 = -6.991732350764465d-6*t139*t29*t64
            t141 = 1/t26**3
            t142 = -1.8356171439920266d-6*t141*t29*t44*t45*t67
            t143 = 4.135669939329334d-1*t30*t56*t57*t65*t66-6.2035049089
     1         94001d-1*t138*t17*t30*t66+2.7571132928862224d-1*t122*t30*
     2         t56+1.2407009817988002d+0*t136*t137*t17*t30
            t144 = -2.722148880047894d-2*t143*t29*t56
            t145 = -9.073829600159646d-3*t125*t29*t56*t69
            t146 = -8*t33*t79*t81
            t147 = t75**2
            t148 = 1/t38**2
            t149 = 6.178834917961894d-1*t110*t45+t116+4.63412618847142d-
     1         1*t107*t108
            t150 = t33*t34*(1.709920934161365d+0*(2.5058979122369923d-2*
     1         t38*t40*t56*t75*t78+8.352993040789976d-3*t125*t39*t56*t78
     2         +2.2478670955426108d-3*t38*t40*t74*t75*t77+5.901575133296
     3         435d-4*t39*t44*t45*t77/t36**3+2.5058979122369923d-2*t39*t
     4         56*(4.135669939329334d-1*t40*t56*t57*t75*t76-6.2035049089
     5         94001d-1*t149*t17*t40*t76+2.7571132928862224d-1*t122*t40*
     6         t56+1.2407009817988002d+0*t147*t148*t17*t40)+2.2478670955
     7         426108d-3*t39*t74*(5.250822119331622d-1*t36*t40*t44*t45*t
     8         75*t76-1.0d+0*t149*t37*t40*t76+1.7502740397772074d-1*t110
     9         *t36*t40*t45+2.0d+0*t147*t148*t37*t40+1.3127055298329054d
     :         -1*t107*t108*t36*t40+3.446391616107778d-2*t101*t40)-4.346
     ;         5070592240396d-2*t110*t45*t71*t73-3.2598802944180294d-2*t
     <         107*t108*t71*t73+3.4234103112606934d-2*t101*t73/t35**3-7.
     =         662163788798045d-1*t101/(t35**5*t72**2)-5.011795824473985
     >         d-2*t13*t15*t52*t56*t58-1.670598608157995d-2*t125*t14*t56
     ?         *t58-5.011795824473985d-2*t123*t14*t56-9.690227711544375d
     @         -4*t13*t15*t50*t52*t54-2.544083100456872d-4*t120*t14*t44*
     1         t45*t54-9.690227711544375d-4*t118*t14*t50+4.1760571396429
     2         26d-2*t110*t45*t46*t48+3.1320428547321943d-2*t107*t108*t4
     3         6*t48-3.289159980064472d-2*t101*t105*t48+1.24484808315677
     4         28d+0*t101*t102*t103)+2.722148880047894d-2*t28*t30*t56*t6
     5         5*t69+9.073829600159646d-3*t125*t29*t56*t69+6.99173235076
     6         4465d-6*t28*t30*t64*t65*t67+1.8356171439920266d-6*t141*t2
     7         9*t44*t45*t67+6.991732350764465d-6*t139*t29*t64-6.6888706
     8         5297039d-3*t110*t45*t60*t62-5.016652989727792d-3*t107*t10
     9         8*t60*t62+5.26831049669476d-3*t101*t130*t62+2.72214888004
     :         7894d-2*t143*t29*t56-2.6730712388370664d-1*t101*t127*t128
     ;         )
            t151 = 20*t33*t41/t1**6
            t152 = t19**2
            t153 = 12*t152*t34*t41
            t154 = 1/t21**6.666666666666666d-1
            t155 = 1/t1**3
            t156 = -2*t155*t19
            t157 = 2*t85
            t158 = 1/t22**6.666666666666666d-1
            t159 = 2*t155*t19
            t160 = -2*t85
            fnc(iq) = 1.0d+0*t1*t43*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*t94*wght+t95+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*t100*wght+t95+Amat(iq,D1_RB)
            Amat2(iq,D2_RA_RA) = 2.0d+0*t94*wght+1.0d+0*t1*(2.2500000000
     1         000003d+0*t84*t93+1.1250000000000002d+0*t42*(1.3333333333
     2         333333d+0*(t160+t159)*t92+4.444444444444444d-1*t158*t91**
     3         2+1.3333333333333333d+0*(t157+t156)*t89+4.444444444444444
     4         d-1*t154*t88**2)+1.1250000000000002d+0*t23*(-32*t41*t81*t
     5         83+8*t34*t79*t83+t153+t151+t150+t146+t145+t144+t142+t140+
     6         t135+t134+t133+t132+t131+t129)+t126+t124+t121+t119+t113+t
     7         112+t111+t109+t106+t104)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*t1*(1.1250000000000002d+0*t84*t9
     1         9+1.1250000000000002d+0*t42*(4.444444444444444d-1*t158*t9
     2         1*t98+4.444444444444444d-1*t154*t88*t97+2.666666666666666
     3         6d+0*t155*t19*t92-2.6666666666666666d+0*t155*t19*t89)+1.1
     4         250000000000002d+0*t93*t96+1.1250000000000002d+0*t23*(-12
     5         *t152*t34*t41+t151+t150+t146+t145+t144+t142+t140+t135+t13
     6         4+t133+t132+t131+t129)+t126+t124+t121+t119+t113+t112+t111
     7         +t109+t106+t104)*wght+1.0d+0*t94*wght+1.0d+0*t100*wght+Am
     8         at2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*t1*(2.2500000000000003d+0*t96*t9
     1         9+1.1250000000000002d+0*t42*(4.444444444444444d-1*t158*t9
     2         8**2+4.444444444444444d-1*t154*t97**2+1.3333333333333333d
     3         +0*(t159+t157)*t92+1.3333333333333333d+0*(t160+t156)*t89)
     4         +1.1250000000000002d+0*t23*(32*t41*t81*t83-8*t34*t79*t83+
     5         t153+t151+t150+t146+t145+t144+t142+t140+t135+t134+t133+t1
     6         32+t131+t129)+t126+t124+t121+t119+t113+t112+t111+t109+t10
     7         6+t104)*wght+2.0d+0*t100*wght+Amat2(iq,D2_RB_RB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+8.908571061768626d-1*t3+1.30045d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = log(6.203504908994001d-1*t20*t9)
            t22 = t11+4.7584000000000004d-3
            t23 = t22**2
            t24 = log(1.0d+0*t20*t23)
            t25 = t15+1.13107d+0
            t26 = atan(7.123108917818117d+0/t25)
            t27 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = t11+3.25d-1
            t31 = t30**2
            t32 = t15+7.06042d+0
            t33 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         554535d-2*log(6.203504908994001d-1*t29*t9)+5.249139316978
     2         092d-2*atan(4.7309269095601136d+0/t32)+2.2478670955426108
     3         d-3*log(1.0d+0*t29*t31)-3.8783294878113006d-2*t17-9.69022
     4         7711544375d-4*t14-3.10907d-2*t10)+5.365091848883603d-3*t2
     5         6+6.991732350764465d-6*t24+1.688686394038963d-2*t21)-5.36
     6         5091848883603d-3*t26-6.991732350764465d-6*t24-1.688686394
     7         038963d-2*t21)+3.8783294878113006d-2*t17+9.69022771154437
     8         5d-4*t14+3.10907d-2*t10
            t34 = 1/t9
            t35 = -2.067834969664667d-1/rhoa**1.3333333333333333d+0
            t36 = 1/t2**3
            t37 = 1/rhoa**6.666666666666667d-1
            t38 = t35-4.8930311001203647d-1*t36*t37
            t39 = 1/t6
            t40 = 1/rhoa**1.6666666666666666d+0
            t41 = -6.203504908994001d-1*t38*t39*t8*t9-2.067834969664667d
     1         -1*t34*t40*t8
            t42 = 1/t16**2
            t43 = 3.784699104639999d+1*t42+1
            t44 = 1/t43
            t45 = 1/t13
            t46 = -1.0d+0*t13*t38*t39*t8-2.625411059665811d-1*t12*t36*t3
     1         7*t8
            t47 = t35-1.4847618436281043d-1*t36*t37
            t48 = 1/t18
            t49 = -6.203504908994001d-1*t20*t47*t48*t9-2.067834969664667
     1         d-1*t20*t34*t40
            t50 = 1/t25**2
            t51 = 5.07386806551d+1*t50+1
            t52 = 1/t51
            t53 = 1/t23
            t54 = -1.0d+0*t20*t23*t47*t48-2.625411059665811d-1*t20*t22*t
     1         36*t37
            t55 = t35-9.26825237694284d-1*t36*t37
            t56 = 1/t27
            t57 = -6.203504908994001d-1*t29*t55*t56*t9-2.067834969664667
     1         d-1*t29*t34*t40
            t58 = 1/t32**2
            t59 = 2.238166942360001d+1*t58+1
            t60 = 1/t59
            t61 = 1/t31
            t62 = -1.0d+0*t29*t31*t55*t56-2.625411059665811d-1*t29*t30*t
     1         36*t37
            t63 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-9
     1         .690227711544375d-4*t45*t46*t7-5.011795824473985d-2*t34*t
     2         41*t7+2.2478670955426108d-3*t28*t61*t62+6.519760588836059
     3         d-2*t36*t37*t58*t60+2.5058979122369923d-2*t28*t34*t57-6.2
     4         64085709464389d-2*t36*t37*t42*t44)+6.991732350764465d-6*t
     5         19*t53*t54+1.0033305979455584d-2*t36*t37*t50*t52+2.722148
     6         880047894d-2*t19*t34*t49)-6.991732350764465d-6*t19*t53*t5
     7         4-1.0033305979455584d-2*t36*t37*t50*t52-2.722148880047894
     8         d-2*t19*t34*t49)+9.690227711544375d-4*t45*t46*t7+5.011795
     9         824473985d-2*t34*t41*t7+6.264085709464389d-2*t36*t37*t42*
     :         t44
            t64 = 1/t43**2
            t65 = 1/t16**5
            t66 = 1/rhoa**2.3333333333333334d+0
            t67 = 1/t16**3
            t68 = 1/rhoa**1.6666666666666669d+0
            t69 = t38**2
            t70 = 1/t6**2
            t71 = 2.7571132928862224d-1/rhoa**2.333333333333333d+0
            t72 = 1/t2**5
            t73 = 1/rhoa**1.3333333333333336d+0
            t74 = 2.4465155500601823d-1*t72*t73+t71+3.262020733413577d-1
     1         *t36*t68
            t75 = 1/rhoa**2.6666666666666666d+0
            t76 = -6.203504908994001d-1*t39*t74*t8*t9+1.2407009817988002
     1         d+0*t69*t70*t8*t9+2.7571132928862224d-1*t34*t75*t8+4.1356
     2         69939329334d-1*t34*t38*t39*t40*t8
            t77 = 1/rhoa**9.999999999999999d-1
            t78 = 1/t12**3
            t79 = -1.0d+0*t13*t39*t74*t8+1.3127055298329054d-1*t12*t72*t
     1         73*t8+2.0d+0*t13*t69*t70*t8+1.7502740397772074d-1*t12*t36
     2         *t68*t8+3.446391616107778d-2*t66*t8+5.250822119331622d-1*
     3         t12*t36*t37*t38*t39*t8
            t80 = 1/t51**2
            t81 = 1/t25**5
            t82 = 1/t25**3
            t83 = t47**2
            t84 = 1/t18**2
            t85 = 7.423809218140521d-2*t72*t73+t71+9.89841229085403d-2*t
     1         36*t68
            t86 = -6.203504908994001d-1*t20*t48*t85*t9+1.240700981798800
     1         2d+0*t20*t83*t84*t9+2.7571132928862224d-1*t20*t34*t75+4.1
     2         35669939329334d-1*t20*t34*t40*t47*t48
            t87 = 1/t22**3
            t88 = -1.0d+0*t20*t23*t48*t85+2.0d+0*t20*t23*t83*t84+1.31270
     1         55298329054d-1*t20*t22*t72*t73+1.7502740397772074d-1*t20*
     2         t22*t36*t68+3.446391616107778d-2*t20*t66+5.25082211933162
     3         2d-1*t20*t22*t36*t37*t47*t48
            t89 = t55**2
            t90 = 1/t27**2
            t91 = 4.63412618847142d-1*t72*t73+t71+6.178834917961894d-1*t
     1         36*t68
            fnc(iq) = 1.0d+0*rhoa*t33*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t63*wght+1.0d+0*t33*wght+Amat(i
     1         q,D1_RA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*rhoa*(5.848223622634643d-1*(1.0d
     1         +0*(1.709920934161365d+0*(2.5058979122369923d-2*t28*t34*(
     2         -6.203504908994001d-1*t29*t56*t9*t91+1.2407009817988002d+
     3         0*t29*t89*t9*t90+2.7571132928862224d-1*t29*t34*t75+4.1356
     4         69939329334d-1*t29*t34*t40*t55*t56)+2.2478670955426108d-3
     5         *t28*t61*(-1.0d+0*t29*t31*t56*t91+2.0d+0*t29*t31*t89*t90+
     6         1.3127055298329054d-1*t29*t30*t72*t73+1.7502740397772074d
     7         -1*t29*t30*t36*t68+3.446391616107778d-2*t29*t66+5.2508221
     8         19331622d-1*t29*t30*t36*t37*t55*t56)-9.690227711544375d-4
     9         *t38*t45*t46*t6*t8-5.011795824473985d-2*t34*t38*t41*t6*t8
     :         -9.690227711544375d-4*t45*t7*t79-2.544083100456872d-4*t36
     ;         *t37*t46*t7*t78-1.670598608157995d-2*t34*t41*t7*t77+8.352
     <         993040789976d-3*t28*t34*t57*t77-5.011795824473985d-2*t34*
     =         t7*t76-3.2598802944180294d-2*t58*t60*t72*t73+3.1320428547
     >         321943d-2*t42*t44*t72*t73-4.3465070592240396d-2*t36*t58*t
     ?         60*t68+4.176057139642926d-2*t36*t42*t44*t68-3.28915998006
     @         4472d-2*t44*t66*t67+1.2448480831567728d+0*t64*t65*t66+3.4
     1         234103112606934d-2*t60*t66/t32**3-7.662163788798045d-1*t6
     2         6/(t32**5*t59**2)+2.2478670955426108d-3*t27*t29*t55*t61*t
     3         62+5.901575133296435d-4*t28*t36*t37*t62/t30**3+2.50589791
     4         22369923d-2*t27*t29*t34*t55*t57)+6.991732350764465d-6*t19
     5         *t53*t88+1.8356171439920266d-6*t19*t36*t37*t54*t87+2.7221
     6         48880047894d-2*t19*t34*t86+5.26831049669476d-3*t52*t66*t8
     7         2-2.6730712388370664d-1*t66*t80*t81+9.073829600159646d-3*
     8         t19*t34*t49*t77-5.016652989727792d-3*t50*t52*t72*t73-6.68
     9         887065297039d-3*t36*t50*t52*t68+6.991732350764465d-6*t18*
     :         t20*t47*t53*t54+2.722148880047894d-2*t18*t20*t34*t47*t49)
     ;         -6.991732350764465d-6*t19*t53*t88-1.8356171439920266d-6*t
     <         19*t36*t37*t54*t87-2.722148880047894d-2*t19*t34*t86-5.268
     =         31049669476d-3*t52*t66*t82+2.6730712388370664d-1*t66*t80*
     >         t81-9.073829600159646d-3*t19*t34*t49*t77+5.01665298972779
     ?         2d-3*t50*t52*t72*t73+6.68887065297039d-3*t36*t50*t52*t68-
     @         6.991732350764465d-6*t18*t20*t47*t53*t54-2.72214888004789
     1         4d-2*t18*t20*t34*t47*t49)+9.690227711544375d-4*t38*t45*t4
     2         6*t6*t8+5.011795824473985d-2*t34*t38*t41*t6*t8+9.69022771
     3         1544375d-4*t45*t7*t79+2.544083100456872d-4*t36*t37*t46*t7
     4         *t78+1.670598608157995d-2*t34*t41*t7*t77+5.01179582447398
     5         5d-2*t34*t7*t76-3.1320428547321943d-2*t42*t44*t72*t73-4.1
     6         76057139642926d-2*t36*t42*t44*t68+3.289159980064472d-2*t4
     7         4*t66*t67-1.2448480831567728d+0*t64*t65*t66)*wght+2.0d+0*
     8         t63*wght+Amat2(iq,D2_RA_RA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+8.908571061768626d-1*t3+1.30045d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = log(6.203504908994001d-1*t20*t9)
            t22 = t11+4.7584000000000004d-3
            t23 = t22**2
            t24 = log(1.0d+0*t20*t23)
            t25 = t15+1.13107d+0
            t26 = atan(7.123108917818117d+0/t25)
            t27 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = t11+3.25d-1
            t31 = t30**2
            t32 = t15+7.06042d+0
            t33 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         554535d-2*log(6.203504908994001d-1*t29*t9)+5.249139316978
     2         092d-2*atan(4.7309269095601136d+0/t32)+2.2478670955426108
     3         d-3*log(1.0d+0*t29*t31)-3.8783294878113006d-2*t17-9.69022
     4         7711544375d-4*t14-3.10907d-2*t10)+5.365091848883603d-3*t2
     5         6+6.991732350764465d-6*t24+1.688686394038963d-2*t21)-5.36
     6         5091848883603d-3*t26-6.991732350764465d-6*t24-1.688686394
     7         038963d-2*t21)+3.8783294878113006d-2*t17+9.69022771154437
     8         5d-4*t14+3.10907d-2*t10
            t34 = 1/t9
            t35 = -2.067834969664667d-1/rhob**1.3333333333333333d+0
            t36 = 1/t2**3
            t37 = 1/rhob**6.666666666666667d-1
            t38 = t35-4.8930311001203647d-1*t36*t37
            t39 = 1/t6
            t40 = 1/rhob**1.6666666666666666d+0
            t41 = -6.203504908994001d-1*t38*t39*t8*t9-2.067834969664667d
     1         -1*t34*t40*t8
            t42 = 1/t16**2
            t43 = 3.784699104639999d+1*t42+1
            t44 = 1/t43
            t45 = 1/t13
            t46 = -1.0d+0*t13*t38*t39*t8-2.625411059665811d-1*t12*t36*t3
     1         7*t8
            t47 = t35-1.4847618436281043d-1*t36*t37
            t48 = 1/t18
            t49 = -6.203504908994001d-1*t20*t47*t48*t9-2.067834969664667
     1         d-1*t20*t34*t40
            t50 = 1/t25**2
            t51 = 5.07386806551d+1*t50+1
            t52 = 1/t51
            t53 = 1/t23
            t54 = -1.0d+0*t20*t23*t47*t48-2.625411059665811d-1*t20*t22*t
     1         36*t37
            t55 = t35-9.26825237694284d-1*t36*t37
            t56 = 1/t27
            t57 = -6.203504908994001d-1*t29*t55*t56*t9-2.067834969664667
     1         d-1*t29*t34*t40
            t58 = 1/t32**2
            t59 = 2.238166942360001d+1*t58+1
            t60 = 1/t59
            t61 = 1/t31
            t62 = -1.0d+0*t29*t31*t55*t56-2.625411059665811d-1*t29*t30*t
     1         36*t37
            t63 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-9
     1         .690227711544375d-4*t45*t46*t7-5.011795824473985d-2*t34*t
     2         41*t7+2.2478670955426108d-3*t28*t61*t62+6.519760588836059
     3         d-2*t36*t37*t58*t60+2.5058979122369923d-2*t28*t34*t57-6.2
     4         64085709464389d-2*t36*t37*t42*t44)+6.991732350764465d-6*t
     5         19*t53*t54+1.0033305979455584d-2*t36*t37*t50*t52+2.722148
     6         880047894d-2*t19*t34*t49)-6.991732350764465d-6*t19*t53*t5
     7         4-1.0033305979455584d-2*t36*t37*t50*t52-2.722148880047894
     8         d-2*t19*t34*t49)+9.690227711544375d-4*t45*t46*t7+5.011795
     9         824473985d-2*t34*t41*t7+6.264085709464389d-2*t36*t37*t42*
     :         t44
            t64 = 1/t43**2
            t65 = 1/t16**5
            t66 = 1/rhob**2.3333333333333334d+0
            t67 = 1/t16**3
            t68 = 1/rhob**1.6666666666666669d+0
            t69 = t38**2
            t70 = 1/t6**2
            t71 = 2.7571132928862224d-1/rhob**2.333333333333333d+0
            t72 = 1/t2**5
            t73 = 1/rhob**1.3333333333333336d+0
            t74 = 2.4465155500601823d-1*t72*t73+t71+3.262020733413577d-1
     1         *t36*t68
            t75 = 1/rhob**2.6666666666666666d+0
            t76 = -6.203504908994001d-1*t39*t74*t8*t9+1.2407009817988002
     1         d+0*t69*t70*t8*t9+2.7571132928862224d-1*t34*t75*t8+4.1356
     2         69939329334d-1*t34*t38*t39*t40*t8
            t77 = 1/rhob**9.999999999999999d-1
            t78 = 1/t12**3
            t79 = -1.0d+0*t13*t39*t74*t8+1.3127055298329054d-1*t12*t72*t
     1         73*t8+2.0d+0*t13*t69*t70*t8+1.7502740397772074d-1*t12*t36
     2         *t68*t8+3.446391616107778d-2*t66*t8+5.250822119331622d-1*
     3         t12*t36*t37*t38*t39*t8
            t80 = 1/t51**2
            t81 = 1/t25**5
            t82 = 1/t25**3
            t83 = t47**2
            t84 = 1/t18**2
            t85 = 7.423809218140521d-2*t72*t73+t71+9.89841229085403d-2*t
     1         36*t68
            t86 = -6.203504908994001d-1*t20*t48*t85*t9+1.240700981798800
     1         2d+0*t20*t83*t84*t9+2.7571132928862224d-1*t20*t34*t75+4.1
     2         35669939329334d-1*t20*t34*t40*t47*t48
            t87 = 1/t22**3
            t88 = -1.0d+0*t20*t23*t48*t85+2.0d+0*t20*t23*t83*t84+1.31270
     1         55298329054d-1*t20*t22*t72*t73+1.7502740397772074d-1*t20*
     2         t22*t36*t68+3.446391616107778d-2*t20*t66+5.25082211933162
     3         2d-1*t20*t22*t36*t37*t47*t48
            t89 = t55**2
            t90 = 1/t27**2
            t91 = 4.63412618847142d-1*t72*t73+t71+6.178834917961894d-1*t
     1         36*t68
            fnc(iq) = 1.0d+0*rhob*t33*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t63*wght+1.0d+0*t33*wght+Amat(i
     1         q,D1_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*rhob*(5.848223622634643d-1*(1.0d
     1         +0*(1.709920934161365d+0*(2.5058979122369923d-2*t28*t34*(
     2         -6.203504908994001d-1*t29*t56*t9*t91+1.2407009817988002d+
     3         0*t29*t89*t9*t90+2.7571132928862224d-1*t29*t34*t75+4.1356
     4         69939329334d-1*t29*t34*t40*t55*t56)+2.2478670955426108d-3
     5         *t28*t61*(-1.0d+0*t29*t31*t56*t91+2.0d+0*t29*t31*t89*t90+
     6         1.3127055298329054d-1*t29*t30*t72*t73+1.7502740397772074d
     7         -1*t29*t30*t36*t68+3.446391616107778d-2*t29*t66+5.2508221
     8         19331622d-1*t29*t30*t36*t37*t55*t56)-9.690227711544375d-4
     9         *t38*t45*t46*t6*t8-5.011795824473985d-2*t34*t38*t41*t6*t8
     :         -9.690227711544375d-4*t45*t7*t79-2.544083100456872d-4*t36
     ;         *t37*t46*t7*t78-1.670598608157995d-2*t34*t41*t7*t77+8.352
     <         993040789976d-3*t28*t34*t57*t77-5.011795824473985d-2*t34*
     =         t7*t76-3.2598802944180294d-2*t58*t60*t72*t73+3.1320428547
     >         321943d-2*t42*t44*t72*t73-4.3465070592240396d-2*t36*t58*t
     ?         60*t68+4.176057139642926d-2*t36*t42*t44*t68-3.28915998006
     @         4472d-2*t44*t66*t67+1.2448480831567728d+0*t64*t65*t66+3.4
     1         234103112606934d-2*t60*t66/t32**3-7.662163788798045d-1*t6
     2         6/(t32**5*t59**2)+2.2478670955426108d-3*t27*t29*t55*t61*t
     3         62+5.901575133296435d-4*t28*t36*t37*t62/t30**3+2.50589791
     4         22369923d-2*t27*t29*t34*t55*t57)+6.991732350764465d-6*t19
     5         *t53*t88+1.8356171439920266d-6*t19*t36*t37*t54*t87+2.7221
     6         48880047894d-2*t19*t34*t86+5.26831049669476d-3*t52*t66*t8
     7         2-2.6730712388370664d-1*t66*t80*t81+9.073829600159646d-3*
     8         t19*t34*t49*t77-5.016652989727792d-3*t50*t52*t72*t73-6.68
     9         887065297039d-3*t36*t50*t52*t68+6.991732350764465d-6*t18*
     :         t20*t47*t53*t54+2.722148880047894d-2*t18*t20*t34*t47*t49)
     ;         -6.991732350764465d-6*t19*t53*t88-1.8356171439920266d-6*t
     <         19*t36*t37*t54*t87-2.722148880047894d-2*t19*t34*t86-5.268
     =         31049669476d-3*t52*t66*t82+2.6730712388370664d-1*t66*t80*
     >         t81-9.073829600159646d-3*t19*t34*t49*t77+5.01665298972779
     ?         2d-3*t50*t52*t72*t73+6.68887065297039d-3*t36*t50*t52*t68-
     @         6.991732350764465d-6*t18*t20*t47*t53*t54-2.72214888004789
     1         4d-2*t18*t20*t34*t47*t49)+9.690227711544375d-4*t38*t45*t4
     2         6*t6*t8+5.011795824473985d-2*t34*t38*t41*t6*t8+9.69022771
     3         1544375d-4*t45*t7*t79+2.544083100456872d-4*t36*t37*t46*t7
     4         *t78+1.670598608157995d-2*t34*t41*t7*t77+5.01179582447398
     5         5d-2*t34*t7*t76-3.1320428547321943d-2*t42*t44*t72*t73-4.1
     6         76057139642926d-2*t36*t42*t44*t68+3.289159980064472d-2*t4
     7         4*t66*t67-1.2448480831567728d+0*t64*t65*t66)*wght+2.0d+0*
     8         t63*wght+Amat2(iq,D2_RB_RB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_vwn5 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{\sqrt{{\it t_2}}}}\\\\ 
C>   {\it t_4} &=& 1.575246635799487\,{\it t_3}\\\\ 
C>   {\it t_5} &=& \arctan \left({{6.15199081975908}\over{{\it t_4}
C>    +3.72744}}\right)\\\\ 
C>   {\it t_6} &=& 0.7876233178997433\,{\it t_3}\\\\ 
C>   {\it t_7} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_8} &=& 0.6203504908994001\,{\it t_7}\\\\ 
C>   {\it t_9} &=& {{1}\over{\left| 2.935818660072219\,{\it t_3}+{
C>    \it t_8}+12.9352\right| }}\\\\ 
C>   {\it t_{10}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.10498\right)^2\,{\it t_9}\right)\\\\ 
C>   {\it t_{11}} &=& \left| {\it t_7}\right| \\\\ 
C>   {\it t_{12}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_9}\right)\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{15}} &=& \arctan \left({{7.123108917818118}\over{{
C>    \it t_4}+1.13107}}\right)\\\\ 
C>   {\it t_{16}} &=& {{1}\over{\left| 0.8908571061768626\,{\it t_3}
C>    +{\it t_8}+13.0045\right| }}\\\\ 
C>   {\it t_{17}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.0047584\right)^2\,{\it t_{16}}\right)\\\\ 
C>   {\it t_{18}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{16}}\right)\\\\ 
C>   {\it t_{19}} &=& {{1}\over{\left| 5.560951426165705\,{\it t_3}
C>    +{\it t_8}+18.0578\right| }}\\\\ 
C>   {\it t_{20}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{\sqrt{{\it t_{20}}}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{{\it t_{20}}}}\\\\ 
C>   {\it t_{23}} &=& 0.6203504908994001\,{\it t_{22}}\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\left| {\it t_{23}}
C>    +2.935818660072219\,{\it t_{21}}+12.9352\right| }}\\\\ 
C>   {\it t_{25}} &=& \left| {\it t_{22}}\right| \\\\ 
C>   {\it t_{26}} &=& \log \left(0.6203504908994001\,{\it t_{24}}
C>    \,{\it t_{25}}\right)\\\\ 
C>   {\it t_{27}} &=& 0.7876233178997433\,{\it t_{21}}\\\\ 
C>   {\it t_{28}} &=& \log \left(1.0\,{\it t_{24}}\,\left({\it t_{27}}
C>    +0.10498\right)^2\right)\\\\ 
C>   {\it t_{29}} &=& 1.575246635799487\,{\it t_{21}}\\\\ 
C>   {\it t_{30}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{29}}+3.72744}}\right)\\\\ 
C>   {\it t_{31}} &=& {{1}\over{\left| {\it t_{23}}
C>    +0.8908571061768626\,{\it t_{21}}+13.0045\right| }}\\\\ 
C>   {\it t_{32}} &=& \log \left(0.6203504908994001\,{\it t_{31}}
C>    \,{\it t_{25}}\right)\\\\ 
C>   {\it t_{33}} &=& \log \left(1.0\,{\it t_{31}}\,\left({\it t_{27}}
C>    +0.0047584\right)^2\right)\\\\ 
C>   {\it t_{34}} &=& \arctan \left({{7.123108917818118}\over{{
C>    \it t_{29}}+1.13107}}\right)\\\\ 
C>   {\it t_{35}} &=& {{1}\over{\left| {\it t_{23}}
C>    +5.560951426165705\,{\it t_{21}}+18.0578\right| }}\\\\ 
C>   f &=& 1.0\,{\it t_1}\,\left(1.125\,\left(\left({\it t_{13}}
C>    \,{\it t_{14}}+1.0\right)^{{{4}\over{3}}}+\left(1.0-{
C>    \it t_{13}}\,{\it t_{14}}\right)^{{{4}\over{3}}}-2.0\right)
C>    \,\left({{{\it t_{13}}^4\,\left(1.709920934161365\,
C>    \left(0.01554535\,\log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{19}}\right)+0.002247867095542611\,\log \left(1.0
C>    \,\left({\it t_6}+0.325\right)^2\,{\it t_{19}}\right)
C>    -0.0310907\,{\it t_{12}}-9.690227711544375 \times 10^{-4}\,{
C>    \it t_{10}}+0.05249139316978092\,\arctan 
C>    \left({{4.730926909560114}\over{{\it t_4}+7.06042}}\right)
C>    -0.03878329487811301\,{\it t_5}\right)+0.01688686394038963
C>    \,{\it t_{18}}+6.991732350764465 \times 10^{-6}\,{\it t_{17}}
C>    +0.005365091848883603\,{\it t_{15}}\right)}\over{{\it t_1}^4}}
C>    -0.01688686394038963\,{\it t_{18}}-6.991732350764465 \times 10^{
C>    -6}\,{\it t_{17}}-0.005365091848883603\,{\it t_{15}}\right)
C>    +0.0310907\,{\it t_{12}}+9.690227711544375 \times 10^{-4}\,{
C>    \it t_{10}}+0.03878329487811301\,{\it t_5}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.5848223622634643\,\left(1.0\,
C>    \left(1.709920934161365\,\left(0.05249139316978092
C>    \,\arctan \left({{4.730926909560114}\over{{\it t_{29}}
C>    +7.06042}}\right)-0.03878329487811301\,{\it t_{30}}
C>    +0.002247867095542611\,\log \left(1.0\,{\it t_{35}}\,\left({
C>    \it t_{27}}+0.325\right)^2\right)-9.690227711544375 \times 10^{
C>    -4}\,{\it t_{28}}+0.01554535\,\log \left(0.6203504908994001
C>    \,{\it t_{35}}\,{\it t_{25}}\right)-0.0310907\,{
C>    \it t_{26}}\right)+0.005365091848883603\,{\it t_{34}}
C>    +6.991732350764465 \times 10^{-6}\,{\it t_{33}}
C>    +0.01688686394038963\,{\it t_{32}}\right)-0.005365091848883603
C>    \,{\it t_{34}}-6.991732350764465 \times 10^{-6}\,{\it t_{33}}
C>    -0.01688686394038963\,{\it t_{32}}\right)+0.03878329487811301
C>    \,{\it t_{30}}+9.690227711544375 \times 10^{-4}\,{\it t_{28}}
C>    +0.0310907\,{\it t_{26}}\right)\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] SH Vosko, L Wilk, M Nusair, Can.J.Phys. 58, 1200 (1980)  , DOI: 
C> <a href="http://dx.doi.org/10.1139/p80-159 "> 
C> 10.1139/p80-159 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_vwn5_d3(param,tol_rho,ipol,nq,wght, 
     +rho,fnc,Amat,Amat2,Amat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,*)  !< [Output] The 3rd derivative wrt rho 
c 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 4.9237251092134837d-1*t4
            t6 = 1/abs(t5+2.615517080950829d+0*t3+1.29352d+1)
            t7 = abs(t4)
            t8 = t5+2.615517080950828d+0*t3+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = 7.016926042943222d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = 1.4033852085886445d+0*t3
            t15 = t14+3.72744d+0
            t16 = 1/t7
            t17 = -8.206208515355806d-2/rhoa**1.3333333333333333d+0
            t18 = 1/t2**3
            t19 = 1/rhoa**6.666666666666667d-1
            t20 = t17-2.1795975674590234d-1*t18*t19
            t21 = 1/t8
            t22 = 1/rhoa**1.6666666666666666d+0
            t23 = -4.9237251092134837d-1*t10*t20*t21*t7-8.20620851535580
     1         6d-2*t10*t16*t22
            t24 = 1/t15**2
            t25 = 3.784699104639999d+1*t24+1
            t26 = 1/t25
            t27 = 1/t13
            t28 = -1.0d+0*t10*t13*t20*t21-1.1694876738238703d-1*t10*t12*
     1         t18*t19
            t29 = 9.690227711544375d-4*t27*t28*t9+6.314467057030004d-2*t
     1         16*t23*t9+2.790332964441521d-2*t18*t19*t24*t26
            t30 = 2.0d+0*t29*wght
            t31 = 1/t25**2
            t32 = 1/t15**5
            t33 = 1/rhoa**2.3333333333333334d+0
            t34 = -2.470091445929572d-1*t31*t32*t33
            t35 = 1/t15**3
            t36 = 6.526520015557556d-3*t26*t33*t35
            t37 = t5+7.93663453939179d-1*t3+1.30045d+1
            t38 = abs(t37)
            t39 = 1/t38
            t40 = t11+4.7584000000000004d-3
            t41 = t40**2
            t42 = t14+1.13107d+0
            t43 = -1.688686394038963d-2*log(4.9237251092134837d-1*t39*t7
     1         )-5.365091848883603d-3*atan(7.123108917818117d+0/t42)-6.9
     2         91732350764465d-6*log(1.0d+0*t39*t41)
            t44 = 1/rhoa**2
            t45 = 1/rhoa**1.6666666666666669d+0
            t46 = -9.301109881471736d-3*t18*t24*t26*t45
            t47 = t20**2
            t48 = 1/t8**2
            t49 = 1/t2**5
            t50 = 1/rhoa**1.3333333333333336d+0
            t51 = 5.448993918647558d-2*t49*t50+7.265325224863413d-2*t18*
     1         t45+5.470805676903872d-2/rhoa**2.333333333333333d+0
            t52 = 1/rhoa**2.6666666666666666d+0
            t53 = -4.9237251092134837d-1*t10*t21*t51*t7+9.84745021842696
     1         7d-1*t10*t47*t48*t7+5.470805676903869d-2*t10*t16*t52+1.64
     2         12417030711612d-1*t10*t16*t20*t21*t22
            t54 = 6.314467057030004d-2*t16*t53*t9
            t55 = -6.975832411103801d-3*t24*t26*t49*t50
            t56 = 1/rhoa**9.999999999999999d-1
            t57 = 1.0524111761716676d-2*t16*t23*t56*t9
            t58 = 1/t12**3
            t59 = 1.1332601865197636d-4*t18*t19*t28*t58*t9
            t60 = -1.0d+0*t10*t13*t21*t51+2.923719184559675d-2*t10*t12*t
     1         49*t50+2.0d+0*t10*t13*t47*t48+3.898292246079568d-2*t10*t1
     2         2*t18*t45+6.838507096129838d-3*t10*t33+2.3389753476477407
     3         d-1*t10*t12*t18*t19*t20*t21
            t61 = 9.690227711544375d-4*t27*t60*t9
            t62 = 6.314467057030004d-2*t10*t16*t20*t23*t8
            t63 = 9.690227711544375d-4*t10*t20*t27*t28*t8
            t64 = t63+t62+t61+t59+t57+t55+t54+t46+2.5000000000000006d-1*
     1         t43*t44+t36+t34
            t65 = t63+t62+t61+t59+t57+t55+t54+t46-2.5000000000000006d-1*
     1         t43*t44+t36+t34
            t66 = 1/rhoa**3.3333333333333337d+0
            t67 = 4.3226600303767515d-1*t31*t32*t66
            t68 = -1.1421410027225727d-2*t26*t35*t66
            t69 = 1/rhoa**3
            t70 = 1/rhoa**3.0d+0
            t71 = 4.3732069462725337d+0*t18*t70/(t15**8*t25**3)
            t72 = -2.022119049462691d-1*t18*t31*t70/t15**6
            t73 = 2.289805413347801d-3*t18*t26*t70/t15**4
            t74 = 1/rhoa**2.666666666666667d+0
            t75 = 7.750924901226445d-3*t18*t24*t26*t74
            t76 = 6.975832411103802d-3*t24*t26*t33*t49
            t77 = 1.988000729055306d-5*t28*t33*t9/t12**4
            t78 = t17-6.613862116159824d-2*t18*t19
            t79 = 1/t37
            t80 = 1/t42**2
            t81 = -4.469329717903391d-3*t18*t19*t80/(5.07386806551d+1*t8
     1         0+1)-3.429692674920095d-2*t16*t38*(-4.9237251092134837d-1
     2         *t39*t7*t78*t79-8.206208515355806d-2*t16*t22*t39)-6.99173
     3         2350764465d-6*t38*(-1.0d+0*t39*t41*t78*t79-1.169487673823
     4         8703d-1*t18*t19*t39*t40)/t41
            t82 = 1/t2**7
            t83 = 1/rhoa**2.0d+0
            t84 = 2.906596837959916d-3*t24*t26*t82*t83
            t85 = -5.262055880858336d-3*t16*t23*t83*t9
            t86 = 1.7540186269527788d-3*t16*t23*t9/rhoa**1.9999999999999
     1         998d+0
            t87 = -3.7775339550658793d-5*t18*t28*t45*t58*t9
            t88 = t20**3
            t89 = 1/t8**3
            t90 = -2.2704141327698155d-2*t82*t83-6.054437687386176d-2*t1
     1         8*t74-5.448993918647558d-2*t33*t49-6.382606623054516d-2/r
     2         hoa**3.333333333333333d+0
            t91 = 6.314467057030004d-2*t16*t9*(-4.9237251092134837d-1*t1
     1         0*t21*t7*t90-2.95423506552809d+0*t10*t7*t88*t89+2.9542350
     2         6552809d+0*t10*t20*t48*t51*t7-1.6412417030711612d-1*t10*t
     3         16*t20*t21*t52+2.4618625546067416d-1*t10*t16*t21*t22*t51-
     4         4.923725109213483d-1*t10*t16*t22*t47*t48-6.38260662305451
     5         5d-2*t10*t16/rhoa**3.6666666666666664d+0)
            t92 = -2.833150466299409d-5*t28*t49*t50*t58*t9
            t93 = 2.1048223523433351d-2*t16*t53*t56*t9
            t94 = 2.1048223523433351d-2*t10*t16*t20*t23*t56*t8
            t95 = 2.2665203730395272d-4*t18*t19*t58*t60*t9
            t96 = 2.2665203730395272d-4*t10*t18*t19*t20*t28*t58*t8
            t97 = 9.690227711544375d-4*t27*t9*(-1.0d+0*t10*t13*t21*t90-6
     1         .0d+0*t10*t13*t88*t89-1.2182163268998646d-2*t10*t12*t82*t
     2         83-3.2485768717329727d-2*t10*t12*t18*t74-1.19673874182272
     3         18d-2*t10*t66+6.0d+0*t10*t13*t20*t48*t51+3.50846302147161
     4         1d-1*t10*t12*t18*t19*t21*t51-8.771157553679026d-2*t10*t12
     5         *t20*t21*t49*t50-2.923719184559675d-2*t10*t12*t33*t49-7.0
     6         16926042943222d-1*t10*t12*t18*t19*t47*t48-1.1694876738238
     7         703d-1*t10*t12*t18*t20*t21*t45-2.0515521288389513d-2*t10*
     8         t20*t21*t33)
            t98 = 6.314467057030004d-2*t10*t16*t23*t51*t8
            t99 = 1.262893411406001d-1*t10*t16*t20*t53*t8
            t100 = 1.938045542308875d-3*t10*t20*t27*t60*t8
            t101 = 9.690227711544375d-4*t10*t27*t28*t51*t8
            fnc(iq) = 2.0d+0*rhoa*(3.10907d-2*log(4.9237251092134837d-1*
     1         t6*t7)+9.690227711544375d-4*log(1.0d+0*(7.016926042943223
     2         d-1*t3+1.0498d-1)**2*t6)+3.8783294878113006d-2*atan(6.151
     3         99081975908d+0/(1.4033852085886447d+0*t3+3.72744d+0)))*wg
     4         ht+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(3.10907d-2*log(4.9237251092134837d-
     1         1*t10*t7)+3.8783294878113006d-2*atan(6.15199081975908d+0/
     2         t15)+9.690227711544375d-4*log(1.0d+0*t10*t13))*wght+2.0d+
     3         0*rhoa*t29*wght+Amat(iq,D1_RA)
            Amat2(iq,D2_RA_RA) = 2.0d+0*rhoa*t64*wght+t30+Amat2(iq,D2_RA
     1         _RA)
            Amat2(iq,D2_RA_RB) = 2.0d+0*rhoa*t65*wght+t30+Amat2(iq,D2_RA
     1         _RB)
            Amat3(iq,D3_RA_RA_RA) = 2.0d+0*rhoa*(t99+t98+t97+t96+t95+t94
     1         +t93+t92+t91+t87+t86+t85+t84+7.500000000000001d-1*t44*t81
     2         +t77+t76+t75+t73+t72+t71-7.5d-1*t43*t69+t68+t67+t101+t100
     3         )*wght+3.0d+0*t64*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = 2.0d+0*rhoa*(t99+t98+t97+t96+t95+t94
     1         +t93+t92+t91+t87+t86+t85+t84-2.5000000000000006d-1*t44*t8
     2         1+t77+t76+t75+t73+t72+t71+2.5000000000000006d-1*t43*t69+t
     3         68+t67+t101+t100)*wght+2.0d+0*t65*wght+1.0d+0*t64*wght+Am
     4         at3(iq,D3_RA_RA_RB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = t2**5.0d-1
            t4 = 1/t3
            t5 = 1.5752466357994865d+0*t4
            t6 = t5+3.72744d+0
            t7 = atan(6.15199081975908d+0/t6)
            t8 = 7.876233178997433d-1*t4
            t9 = t8+1.0498d-1
            t10 = t9**2
            t11 = 1/t2
            t12 = 6.203504908994001d-1*t11
            t13 = 2.935818660072219d+0*t4+t12+1.29352d+1
            t14 = abs(t13)
            t15 = 1/t14
            t16 = log(1.0d+0*t10*t15)
            t17 = abs(t11)
            t18 = log(6.203504908994001d-1*t15*t17)
            t19 = rhoa-rhob
            t20 = 1/t1
            t21 = 1.0d+0-t19*t20
            t22 = t19*t20+1.0d+0
            t23 = t22**1.3333333333333333d+0+t21**1.3333333333333333d+0-
     1         2.0d+0
            t24 = t5+1.13107d+0
            t25 = atan(7.123108917818117d+0/t24)
            t26 = t8+4.7584000000000004d-3
            t27 = t26**2
            t28 = 8.908571061768626d-1*t4+t12+1.30045d+1
            t29 = abs(t28)
            t30 = 1/t29
            t31 = log(1.0d+0*t27*t30)
            t32 = log(6.203504908994001d-1*t17*t30)
            t33 = t19**4
            t34 = 1/t1**4
            t35 = t5+7.06042d+0
            t36 = t8+3.25d-1
            t37 = t36**2
            t38 = 5.560951426165704d+0*t4+t12+1.8057800000000002d+1
            t39 = abs(t38)
            t40 = 1/t39
            t41 = 1.709920934161365d+0*(-3.8783294878113006d-2*t7+2.2478
     1         670955426108d-3*log(1.0d+0*t37*t40)+1.554535d-2*log(6.203
     2         504908994001d-1*t17*t40)+5.249139316978092d-2*atan(4.7309
     3         269095601136d+0/t35)-3.10907d-2*t18-9.690227711544375d-4*
     4         t16)+1.688686394038963d-2*t32+6.991732350764465d-6*t31+5.
     5         365091848883603d-3*t25
            t42 = t33*t34*t41-1.688686394038963d-2*t32-6.991732350764465
     1         d-6*t31-5.365091848883603d-3*t25
            t43 = 3.8783294878113006d-2*t7+1.1250000000000002d+0*t23*t42
     1         +3.10907d-2*t18+9.690227711544375d-4*t16
            t44 = 1/t1**6.666666666666667d-1
            t45 = 1/t3**3
            t46 = 1/t6**2
            t47 = 3.784699104639999d+1*t46+1
            t48 = 1/t47
            t49 = 6.264085709464389d-2*t44*t45*t46*t48
            t50 = 1/t10
            t51 = -2.067834969664667d-1/t1**1.3333333333333333d+0
            t52 = t51-4.8930311001203647d-1*t44*t45
            t53 = 1/t13
            t54 = -2.625411059665811d-1*t15*t44*t45*t9-1.0d+0*t10*t15*t5
     1         2*t53
            t55 = 9.690227711544375d-4*t14*t50*t54
            t56 = 1/t17
            t57 = 1/t1**1.6666666666666666d+0
            t58 = -2.067834969664667d-1*t15*t56*t57-6.203504908994001d-1
     1         *t15*t17*t52*t53
            t59 = 5.011795824473985d-2*t14*t56*t58
            t60 = 1/t24**2
            t61 = 5.07386806551d+1*t60+1
            t62 = 1/t61
            t63 = -1.0033305979455584d-2*t44*t45*t60*t62
            t64 = 1/t27
            t65 = t51-1.4847618436281043d-1*t44*t45
            t66 = 1/t28
            t67 = -1.0d+0*t27*t30*t65*t66-2.625411059665811d-1*t26*t30*t
     1         44*t45
            t68 = -6.991732350764465d-6*t29*t64*t67
            t69 = -6.203504908994001d-1*t17*t30*t65*t66-2.06783496966466
     1         7d-1*t30*t56*t57
            t70 = -2.722148880047894d-2*t29*t56*t69
            t71 = 1/t35**2
            t72 = 2.238166942360001d+1*t71+1
            t73 = 1/t72
            t74 = 1/t37
            t75 = t51-9.26825237694284d-1*t44*t45
            t76 = 1/t38
            t77 = -1.0d+0*t37*t40*t75*t76-2.625411059665811d-1*t36*t40*t
     1         44*t45
            t78 = -6.203504908994001d-1*t17*t40*t75*t76-2.06783496966466
     1         7d-1*t40*t56*t57
            t79 = 1.709920934161365d+0*(2.5058979122369923d-2*t39*t56*t7
     1         8+2.2478670955426108d-3*t39*t74*t77+6.519760588836059d-2*
     2         t44*t45*t71*t73-5.011795824473985d-2*t14*t56*t58-9.690227
     3         711544375d-4*t14*t50*t54-6.264085709464389d-2*t44*t45*t46
     4         *t48)+2.722148880047894d-2*t29*t56*t69+6.991732350764465d
     5         -6*t29*t64*t67+1.0033305979455584d-2*t44*t45*t60*t62
            t80 = t33*t34*t79
            t81 = 1/t1**5
            t82 = -4*t33*t41*t81
            t83 = t19**3
            t84 = 4*t34*t41*t83+t82+t80+t70+t68+t63
            t85 = 1/t1**2
            t86 = t19*t85
            t87 = -t20
            t88 = t87+t86
            t89 = t21**3.333333333333333d-1
            t90 = -t19*t85
            t91 = t90+t20
            t92 = t22**3.333333333333333d-1
            t93 = 1.3333333333333333d+0*t91*t92+1.3333333333333333d+0*t8
     1         8*t89
            t94 = 1.1250000000000002d+0*t42*t93+1.1250000000000002d+0*t2
     1         3*t84+t59+t55+t49
            t95 = 1.0d+0*t43*wght
            t96 = -4*t34*t41*t83+t82+t80+t70+t68+t63
            t97 = t86+t20
            t98 = t90+t87
            t99 = 1.3333333333333333d+0*t92*t98+1.3333333333333333d+0*t8
     1         9*t97
            t100 = 1.1250000000000002d+0*t42*t99+1.1250000000000002d+0*t
     1         23*t96+t59+t55+t49
            t101 = 1/t1**2.3333333333333334d+0
            t102 = 1/t6**5
            t103 = 1/t47**2
            t104 = -1.2448480831567728d+0*t101*t102*t103
            t105 = 1/t6**3
            t106 = 3.289159980064472d-2*t101*t105*t48
            t107 = 1/t1**1.3333333333333336d+0
            t108 = 1/t3**5
            t109 = -3.1320428547321943d-2*t107*t108*t46*t48
            t110 = 1/t1**1.6666666666666669d+0
            t111 = -4.176057139642926d-2*t110*t45*t46*t48
            t112 = 9.690227711544375d-4*t13*t15*t50*t52*t54
            t113 = 5.011795824473985d-2*t13*t15*t52*t56*t58
            t114 = t52**2
            t115 = 1/t13**2
            t116 = 2.7571132928862224d-1/t1**2.333333333333333d+0
            t117 = 3.262020733413577d-1*t110*t45+t116+2.4465155500601823
     1         d-1*t107*t108
            t118 = 5.250822119331622d-1*t15*t44*t45*t52*t53*t9+1.7502740
     1         397772074d-1*t110*t15*t45*t9+1.3127055298329054d-1*t107*t
     2         108*t15*t9-1.0d+0*t10*t117*t15*t53+2.0d+0*t10*t114*t115*t
     3         15+3.446391616107778d-2*t101*t15
            t119 = 9.690227711544375d-4*t118*t14*t50
            t120 = 1/t9**3
            t121 = 2.544083100456872d-4*t120*t14*t44*t45*t54
            t122 = 1/t1**2.6666666666666666d+0
            t123 = 4.135669939329334d-1*t15*t52*t53*t56*t57+2.7571132928
     1         862224d-1*t122*t15*t56-6.203504908994001d-1*t117*t15*t17*
     2         t53+1.2407009817988002d+0*t114*t115*t15*t17
            t124 = 5.011795824473985d-2*t123*t14*t56
            t125 = 1/t1**9.999999999999999d-1
            t126 = 1.670598608157995d-2*t125*t14*t56*t58
            t127 = 1/t24**5
            t128 = 1/t61**2
            t129 = 2.6730712388370664d-1*t101*t127*t128
            t130 = 1/t24**3
            t131 = -5.26831049669476d-3*t101*t130*t62
            t132 = 5.016652989727792d-3*t107*t108*t60*t62
            t133 = 6.68887065297039d-3*t110*t45*t60*t62
            t134 = -6.991732350764465d-6*t28*t30*t64*t65*t67
            t135 = -2.722148880047894d-2*t28*t30*t56*t65*t69
            t136 = t65**2
            t137 = 1/t28**2
            t138 = 9.89841229085403d-2*t110*t45+t116+7.423809218140521d-
     1         2*t107*t108
            t139 = 5.250822119331622d-1*t26*t30*t44*t45*t65*t66-1.0d+0*t
     1         138*t27*t30*t66+1.7502740397772074d-1*t110*t26*t30*t45+2.
     2         0d+0*t136*t137*t27*t30+1.3127055298329054d-1*t107*t108*t2
     3         6*t30+3.446391616107778d-2*t101*t30
            t140 = -6.991732350764465d-6*t139*t29*t64
            t141 = 1/t26**3
            t142 = -1.8356171439920266d-6*t141*t29*t44*t45*t67
            t143 = 4.135669939329334d-1*t30*t56*t57*t65*t66-6.2035049089
     1         94001d-1*t138*t17*t30*t66+2.7571132928862224d-1*t122*t30*
     2         t56+1.2407009817988002d+0*t136*t137*t17*t30
            t144 = -2.722148880047894d-2*t143*t29*t56
            t145 = -9.073829600159646d-3*t125*t29*t56*t69
            t146 = -8*t33*t79*t81
            t147 = 1/t35**5
            t148 = 1/t72**2
            t149 = 1/t35**3
            t150 = t75**2
            t151 = 1/t38**2
            t152 = 6.178834917961894d-1*t110*t45+t116+4.63412618847142d-
     1         1*t107*t108
            t153 = 5.250822119331622d-1*t36*t40*t44*t45*t75*t76-1.0d+0*t
     1         152*t37*t40*t76+1.7502740397772074d-1*t110*t36*t40*t45+2.
     2         0d+0*t150*t151*t37*t40+1.3127055298329054d-1*t107*t108*t3
     3         6*t40+3.446391616107778d-2*t101*t40
            t154 = 1/t36**3
            t155 = 4.135669939329334d-1*t40*t56*t57*t75*t76-6.2035049089
     1         94001d-1*t152*t17*t40*t76+2.7571132928862224d-1*t122*t40*
     2         t56+1.2407009817988002d+0*t150*t151*t17*t40
            t156 = 1.709920934161365d+0*(2.5058979122369923d-2*t38*t40*t
     1         56*t75*t78+8.352993040789976d-3*t125*t39*t56*t78+2.247867
     2         0955426108d-3*t38*t40*t74*t75*t77+5.901575133296435d-4*t1
     3         54*t39*t44*t45*t77+2.2478670955426108d-3*t153*t39*t74-4.3
     4         465070592240396d-2*t110*t45*t71*t73-3.2598802944180294d-2
     5         *t107*t108*t71*t73+3.4234103112606934d-2*t101*t149*t73-5.
     6         011795824473985d-2*t13*t15*t52*t56*t58-1.670598608157995d
     7         -2*t125*t14*t56*t58+2.5058979122369923d-2*t155*t39*t56-5.
     8         011795824473985d-2*t123*t14*t56-9.690227711544375d-4*t13*
     9         t15*t50*t52*t54-2.544083100456872d-4*t120*t14*t44*t45*t54
     :         -9.690227711544375d-4*t118*t14*t50+4.176057139642926d-2*t
     ;         110*t45*t46*t48+3.1320428547321943d-2*t107*t108*t46*t48-3
     <         .289159980064472d-2*t101*t105*t48-7.662163788798045d-1*t1
     =         01*t147*t148+1.2448480831567728d+0*t101*t102*t103)+2.7221
     >         48880047894d-2*t28*t30*t56*t65*t69+9.073829600159646d-3*t
     ?         125*t29*t56*t69+6.991732350764465d-6*t28*t30*t64*t65*t67+
     @         1.8356171439920266d-6*t141*t29*t44*t45*t67+6.991732350764
     1         465d-6*t139*t29*t64-6.68887065297039d-3*t110*t45*t60*t62-
     2         5.016652989727792d-3*t107*t108*t60*t62+5.26831049669476d-
     3         3*t101*t130*t62+2.722148880047894d-2*t143*t29*t56-2.67307
     4         12388370664d-1*t101*t127*t128
            t157 = t156*t33*t34
            t158 = 1/t1**6
            t159 = 20*t158*t33*t41
            t160 = t19**2
            t161 = 12*t160*t34*t41
            t162 = -32*t41*t81*t83+8*t34*t79*t83+t161+t159+t157+t146+t14
     1         5+t144+t142+t140+t135+t134+t133+t132+t131+t129
            t163 = t88**2
            t164 = 1/t21**6.666666666666666d-1
            t165 = 1/t1**3
            t166 = -2*t165*t19
            t167 = 2*t85
            t168 = t167+t166
            t169 = t91**2
            t170 = 1/t22**6.666666666666666d-1
            t171 = 2*t165*t19
            t172 = -2*t85
            t173 = t172+t171
            t174 = 1.3333333333333333d+0*t173*t92+1.3333333333333333d+0*
     1         t168*t89+4.444444444444444d-1*t169*t170+4.444444444444444
     2         d-1*t163*t164
            t175 = 2.2500000000000003d+0*t84*t93+1.1250000000000002d+0*t
     1         174*t42+1.1250000000000002d+0*t162*t23+t126+t124+t121+t11
     2         9+t113+t112+t111+t109+t106+t104
            t176 = -12*t160*t34*t41+t159+t157+t146+t145+t144+t142+t140+t
     1         135+t134+t133+t132+t131+t129
            t177 = 4.444444444444444d-1*t170*t91*t98+4.444444444444444d-
     1         1*t164*t88*t97+2.6666666666666666d+0*t165*t19*t92-2.66666
     2         66666666666d+0*t165*t19*t89
            t178 = 1.1250000000000002d+0*t84*t99+1.1250000000000002d+0*t
     1         93*t96+1.1250000000000002d+0*t177*t42+1.1250000000000002d
     2         +0*t176*t23+t126+t124+t121+t119+t113+t112+t111+t109+t106+
     3         t104
            t179 = 32*t41*t81*t83-8*t34*t79*t83+t161+t159+t157+t146+t145
     1         +t144+t142+t140+t135+t134+t133+t132+t131+t129
            t180 = t97**2
            t181 = t172+t166
            t182 = t98**2
            t183 = t171+t167
            t184 = 1.3333333333333333d+0*t183*t92+1.3333333333333333d+0*
     1         t181*t89+4.444444444444444d-1*t170*t182+4.444444444444444
     2         d-1*t164*t180
            t185 = 2.2500000000000003d+0*t96*t99+1.1250000000000002d+0*t
     1         184*t42+1.1250000000000002d+0*t179*t23+t126+t124+t121+t11
     2         9+t113+t112+t111+t109+t106+t104
            t186 = 1/t1**3.0d+0
            t187 = 1/t6**8
            t188 = 1/t47**3
            t189 = 4.947718859586276d+1*t186*t187*t188*t45
            t190 = 1/t6**6
            t191 = -2.2877665475865033d+0*t103*t186*t190*t45
            t192 = 1/t1**3.3333333333333337d+0
            t193 = 4.3569682910487045d+0*t102*t103*t192
            t194 = 1/t6**4
            t195 = 2.590619096601433d-2*t186*t194*t45*t48
            t196 = -1.1512059930225654d-1*t105*t192*t48
            t197 = 1/t1**2.0d+0
            t198 = 1/t3**7
            t199 = 2.610035712276828d-2*t197*t198*t46*t48
            t200 = 6.26408570946439d-2*t101*t108*t46*t48
            t201 = 1/t1**2.666666666666667d+0
            t202 = 6.96009523273821d-2*t201*t45*t46*t48
            t203 = 1.938045542308875d-3*t118*t13*t15*t50*t52
            t204 = 5.088166200913744d-4*t120*t13*t15*t44*t45*t52*t54
            t205 = 9.690227711544375d-4*t117*t13*t15*t50*t54
            t206 = 1.002359164894797d-1*t123*t13*t15*t52*t56
            t207 = 5.011795824473985d-2*t117*t13*t15*t56*t58
            t208 = 3.34119721631599d-2*t125*t13*t15*t52*t56*t58
            t209 = t52**3
            t210 = 1/t13**3
            t211 = -6.433264350067851d-1/t1**3.333333333333333d+0
            t212 = -5.436701222355962d-1*t201*t45+t211-2.038762958383485
     1         1d-1*t197*t198-4.893031100120365d-1*t101*t108
            t213 = -5.250822119331622d-1*t110*t15*t45*t52*t53*t9-3.93811
     1         65894987163d-1*t107*t108*t15*t52*t53*t9+7.876233178997433
     2         d-1*t117*t15*t44*t45*t53*t9-1.5752466357994865d+0*t114*t1
     3         15*t15*t44*t45*t9-2.917123399628679d-1*t15*t201*t45*t9-1.
     4         0939212748607545d-1*t15*t197*t198*t9-2.625411059665811d-1
     5         *t101*t108*t15*t9-1.0339174848323335d-1*t101*t15*t52*t53-
     6         1.0d+0*t10*t15*t212*t53+6.0d+0*t10*t115*t117*t15*t52-6.0d
     7         +0*t10*t15*t209*t210-1.2062370656377225d-1*t15*t192
            t214 = 9.690227711544375d-4*t14*t213*t50
            t215 = 5.088166200913744d-4*t118*t120*t14*t44*t45
            t216 = 1/t9**4
            t217 = 1.0018895862972538d-4*t101*t14*t216*t54
            t218 = -1.272041550228436d-4*t107*t108*t120*t14*t54
            t219 = -1.696055400304582d-4*t110*t120*t14*t45*t54
            t220 = 1/t1**3.6666666666666664d+0
            t221 = 6.203504908994001d-1*t117*t15*t53*t56*t57-1.240700981
     1         7988002d+0*t114*t115*t15*t56*t57-8.271339878658668d-1*t12
     2         2*t15*t52*t53*t56-6.433264350067852d-1*t15*t220*t56-6.203
     3         504908994001d-1*t15*t17*t212*t53+3.7221029453964005d+0*t1
     4         15*t117*t15*t17*t52-3.7221029453964005d+0*t15*t17*t209*t2
     5         10
            t222 = 5.011795824473985d-2*t14*t221*t56
            t223 = 3.34119721631599d-2*t123*t125*t14*t56
            t224 = -1.6705986081579946d-2*t14*t197*t56*t58
            t225 = 1/t1**1.9999999999999998d+0
            t226 = 5.568662027193316d-3*t14*t225*t56*t58
            t227 = 1/t21**1.6666666666666669d+0
            t228 = 6*t19*t34
            t229 = -6*t165
            t230 = 1/t22**1.6666666666666669d+0
            t231 = -6*t19*t34
            t232 = 6*t165
            t233 = 1/t24**8
            t234 = 1/t61**3
            t235 = -1.424318138513631d+1*t186*t233*t234*t45
            t236 = 1/t24**6
            t237 = 4.9125375556021966d-1*t128*t186*t236*t45
            t238 = -9.355749335929733d-1*t127*t128*t192
            t239 = 1/t24**4
            t240 = -4.1494441931327714d-3*t186*t239*t45*t62
            t241 = 1.8439086738431665d-2*t130*t192*t62
            t242 = -4.180544158106493d-3*t197*t198*t60*t62
            t243 = -1.0033305979455585d-2*t101*t108*t60*t62
            t244 = -1.114811775495065d-2*t201*t45*t60*t62
            t245 = -1.3983464701528928d-5*t139*t28*t30*t64*t65
            t246 = -3.671234287984053d-6*t141*t28*t30*t44*t45*t65*t67
            t247 = -6.991732350764465d-6*t138*t28*t30*t64*t67
            t248 = -5.444297760095788d-2*t143*t28*t30*t56*t65
            t249 = -2.722148880047894d-2*t138*t28*t30*t56*t69
            t250 = -1.8147659200319294d-2*t125*t28*t30*t56*t65*t69
            t251 = t65**3
            t252 = 1/t28**3
            t253 = -1.649735381809005d-1*t201*t45+t211-6.186507681783768
     1         d-2*t197*t198-1.4847618436281043d-1*t101*t108
            t254 = -5.250822119331622d-1*t110*t26*t30*t45*t65*t66-3.9381
     1         165894987163d-1*t107*t108*t26*t30*t65*t66-1.0339174848323
     2         335d-1*t101*t30*t65*t66+7.876233178997433d-1*t138*t26*t30
     3         *t44*t45*t66-1.0d+0*t253*t27*t30*t66+6.0d+0*t137*t138*t27
     4         *t30*t65-1.5752466357994865d+0*t136*t137*t26*t30*t44*t45-
     5         2.917123399628679d-1*t201*t26*t30*t45-6.0d+0*t251*t252*t2
     6         7*t30-1.0939212748607545d-1*t197*t198*t26*t30-2.625411059
     7         665811d-1*t101*t108*t26*t30-1.2062370656377225d-1*t192*t3
     8         0
            t255 = -6.991732350764465d-6*t254*t29*t64
            t256 = -3.671234287984053d-6*t139*t141*t29*t44*t45
            t257 = 1/t26**4
            t258 = -7.228874326723254d-7*t101*t257*t29*t67
            t259 = 9.178085719960132d-7*t107*t108*t141*t29*t67
            t260 = 1.2237447626613511d-6*t110*t141*t29*t45*t67
            t261 = -8.271339878658668d-1*t122*t30*t56*t65*t66+6.20350490
     1         8994001d-1*t138*t30*t56*t57*t66-6.203504908994001d-1*t17*
     2         t253*t30*t66+3.7221029453964005d+0*t137*t138*t17*t30*t65-
     3         1.2407009817988002d+0*t136*t137*t30*t56*t57-6.43326435006
     4         7852d-1*t220*t30*t56-3.7221029453964005d+0*t17*t251*t252*
     5         t30
            t262 = -2.722148880047894d-2*t261*t29*t56
            t263 = -1.8147659200319294d-2*t125*t143*t29*t56
            t264 = 9.073829600159644d-3*t197*t29*t56*t69
            t265 = -3.024609866719882d-3*t225*t29*t56*t69
            t266 = 60*t158*t33*t79
            t267 = 36*t160*t34*t79
            t268 = t75**3
            t269 = 1/t38**3
            t270 = -1.0298058196603158d+0*t201*t45+t211-3.86177182372618
     1         33d-1*t197*t198-9.26825237694284d-1*t101*t108
            t271 = t33*t34*(1.709920934161365d+0*(1.670598608157995d-2*t
     1         125*t38*t40*t56*t75*t78+2.5058979122369923d-2*t152*t38*t4
     2         0*t56*t78+2.784331013596658d-3*t225*t39*t56*t78-8.3529930
     3         40789973d-3*t197*t39*t56*t78+1.1803150266592868d-3*t154*t
     4         38*t40*t44*t45*t75*t77+2.2478670955426108d-3*t152*t38*t40
     5         *t74*t77-3.934383422197623d-4*t110*t154*t39*t45*t77+2.324
     6         1090936607786d-4*t101*t39*t77/t36**4-2.9507875666482175d-
     7         4*t107*t108*t154*t39*t77+2.5058979122369923d-2*t39*t56*(-
     8         8.271339878658668d-1*t122*t40*t56*t75*t76+6.2035049089940
     9         01d-1*t152*t40*t56*t57*t76-6.203504908994001d-1*t17*t270*
     :         t40*t76+3.7221029453964005d+0*t151*t152*t17*t40*t75-1.240
     ;         7009817988002d+0*t150*t151*t40*t56*t57-6.433264350067852d
     <         -1*t220*t40*t56-3.7221029453964005d+0*t17*t268*t269*t40)+
     =         2.2478670955426108d-3*t39*t74*(-5.250822119331622d-1*t110
     >         *t36*t40*t45*t75*t76-3.9381165894987163d-1*t107*t108*t36*
     ?         t40*t75*t76-1.0339174848323335d-1*t101*t40*t75*t76+7.8762
     @         33178997433d-1*t152*t36*t40*t44*t45*t76-1.0d+0*t270*t37*t
     1         40*t76+6.0d+0*t151*t152*t37*t40*t75-1.5752466357994865d+0
     2         *t150*t151*t36*t40*t44*t45-2.917123399628679d-1*t201*t36*
     3         t40*t45-6.0d+0*t268*t269*t37*t40-1.0939212748607545d-1*t1
     4         97*t198*t36*t40-2.625411059665811d-1*t101*t108*t36*t40-1.
     5         2062370656377225d-1*t192*t40)+4.4957341910852217d-3*t153*
     6         t38*t40*t74*t75+5.011795824473985d-2*t155*t38*t40*t56*t75
     7         +7.244178432040066d-2*t201*t45*t71*t73+2.716566912015024d
     8         -2*t197*t198*t71*t73+6.51976058883606d-2*t101*t108*t71*t7
     9         3+2.69635778788734d-2*t186*t45*t73/t35**4-1.1981936089412
     :         427d-1*t149*t192*t73+1.8009481522035156d+1*t186*t45/(t35*
     ;         *8*t72**3)-3.34119721631599d-2*t125*t13*t15*t52*t56*t58-5
     <         .568662027193316d-3*t14*t225*t56*t58+1.6705986081579946d-
     =         2*t14*t197*t56*t58-5.011795824473985d-2*t117*t13*t15*t56*
     >         t58-1.002359164894797d-1*t123*t13*t15*t52*t56+1.670598608
     ?         157995d-2*t125*t155*t39*t56-5.011795824473985d-2*t14*t221
     @         *t56-3.34119721631599d-2*t123*t125*t14*t56-5.088166200913
     1         744d-4*t120*t13*t15*t44*t45*t52*t54-9.690227711544375d-4*
     2         t117*t13*t15*t50*t54+1.696055400304582d-4*t110*t120*t14*t
     3         45*t54-1.0018895862972538d-4*t101*t14*t216*t54+1.27204155
     4         0228436d-4*t107*t108*t120*t14*t54-1.938045542308875d-3*t1
     5         18*t13*t15*t50*t52-9.690227711544375d-4*t14*t213*t50-6.96
     6         009523273821d-2*t201*t45*t46*t48-2.610035712276828d-2*t19
     7         7*t198*t46*t48-6.26408570946439d-2*t101*t108*t46*t48-2.59
     8         0619096601433d-2*t186*t194*t45*t48+1.1512059930225654d-1*
     9         t105*t192*t48+1.1803150266592868d-3*t153*t154*t39*t44*t45
     :         -5.088166200913744d-4*t118*t120*t14*t44*t45-1.40814306864
     ;         56894d+0*t148*t186*t45/t35**6+2.2877665475865033d+0*t103*
     <         t186*t190*t45-4.947718859586276d+1*t186*t187*t188*t45+2.6
     =         81757326079316d+0*t147*t148*t192-4.3569682910487045d+0*t1
     >         02*t103*t192)+1.8147659200319294d-2*t125*t28*t30*t56*t65*
     ?         t69+2.722148880047894d-2*t138*t28*t30*t56*t69+3.024609866
     @         719882d-3*t225*t29*t56*t69-9.073829600159644d-3*t197*t29*
     1         t56*t69+3.671234287984053d-6*t141*t28*t30*t44*t45*t65*t67
     2         +6.991732350764465d-6*t138*t28*t30*t64*t67-1.223744762661
     3         3511d-6*t110*t141*t29*t45*t67+7.228874326723254d-7*t101*t
     4         257*t29*t67-9.178085719960132d-7*t107*t108*t141*t29*t67+1
     5         .3983464701528928d-5*t139*t28*t30*t64*t65+5.4442977600957
     6         88d-2*t143*t28*t30*t56*t65+6.991732350764465d-6*t254*t29*
     7         t64+1.114811775495065d-2*t201*t45*t60*t62+4.1805441581064
     8         93d-3*t197*t198*t60*t62+1.0033305979455585d-2*t101*t108*t
     9         60*t62+4.1494441931327714d-3*t186*t239*t45*t62-1.84390867
     :         38431665d-2*t130*t192*t62+2.722148880047894d-2*t261*t29*t
     ;         56+1.8147659200319294d-2*t125*t143*t29*t56+3.671234287984
     <         053d-6*t139*t141*t29*t44*t45-4.9125375556021966d-1*t128*t
     =         186*t236*t45+1.424318138513631d+1*t186*t233*t234*t45+9.35
     >         5749335929733d-1*t127*t128*t192)
            t272 = -12*t156*t33*t81
            t273 = -120*t33*t41/t1**7
            t274 = -144*t160*t41*t81
            t275 = 24*t19*t34*t41
            t276 = 2.0d+0*t178*wght
            t277 = -12*t160*t34*t79
            t278 = 48*t160*t41*t81
            t279 = -24*t19*t34*t41
            fnc(iq) = 1.0d+0*t1*t43*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*t94*wght+t95+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*t100*wght+t95+Amat(iq,D1_RB)
            Amat2(iq,D2_RA_RA) = 2.0d+0*t94*wght+1.0d+0*t1*t175*wght+Ama
     1         t2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*t94*wght+1.0d+0*t1*t178*wght+1.0
     1         d+0*t100*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*t1*t185*wght+2.0d+0*t100*wght+Am
     1         at2(iq,D2_RB_RB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*t1*(3.375000000000001d+0*t162
     1         *t93+1.1250000000000002d+0*t42*(1.3333333333333333d+0*(t2
     2         32+t231)*t92-2.962962962962963d-1*t230*t91**3+1.333333333
     3         3333333d+0*t170*t173*t91+1.3333333333333333d+0*(t229+t228
     4         )*t89-2.962962962962963d-1*t227*t88**3+1.3333333333333333
     5         d+0*t164*t168*t88)+3.375000000000001d+0*t174*t84+1.125000
     6         0000000002d+0*t23*(-96*t79*t81*t83+240*t158*t41*t83+12*t1
     7         56*t34*t83+t275+t274+t273+t272+t271+t267+t266+t265+t264+t
     8         263+t262+t260+t259+t258+t256+t255+t250+t249+t248+t247+t24
     9         6+t245+t244+t243+t242+t241+t240+t238+t237+t235)+t226+t224
     :         +t223+t222+t219+t218+t217+t215+t214+t208+t207+t206+t205+t
     ;         204+t203+t202+t200+t199+t196+t195+t193+t191+t189)*wght+3.
     <         0d+0*t175*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = 1.0d+0*t1*(1.1250000000000002d+0*t16
     1         2*t99+1.1250000000000002d+0*t42*(-2.962962962962963d-1*t1
     2         69*t230*t98+4.444444444444444d-1*t170*t173*t98-2.96296296
     3         2962963d-1*t163*t227*t97+4.444444444444444d-1*t164*t168*t
     4         97+1.3333333333333333d+0*(t231+2*t165)*t92+1.777777777777
     5         7776d+0*t165*t170*t19*t91+1.3333333333333333d+0*(t228-2*t
     6         165)*t89-1.7777777777777776d+0*t164*t165*t19*t88)+1.12500
     7         00000000002d+0*t174*t96+2.2500000000000003d+0*t176*t93+2.
     8         2500000000000003d+0*t177*t84+1.1250000000000002d+0*t23*(-
     9         32*t79*t81*t83+80*t158*t41*t83+4*t156*t34*t83+t279+t278+t
     :         277+t273+t272+t271+t266+t265+t264+t263+t262+t260+t259+t25
     ;         8+t256+t255+t250+t249+t248+t247+t246+t245+t244+t243+t242+
     <         t241+t240+t238+t237+t235)+t226+t224+t223+t222+t219+t218+t
     =         217+t215+t214+t208+t207+t206+t205+t204+t203+t202+t200+t19
     >         9+t196+t195+t193+t191+t189)*wght+1.0d+0*t175*wght+t276+Am
     ?         at3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = 1.0d+0*t1*(2.2500000000000003d+0*t17
     1         6*t99+1.1250000000000002d+0*t42*(1.7777777777777776d+0*t1
     2         65*t170*t19*t98-1.7777777777777776d+0*t164*t165*t19*t97-8
     3         *t19*t34*t92-2.6666666666666666d+0*t165*t92-2.96296296296
     4         2963d-1*t182*t230*t91+4.444444444444444d-1*t170*t183*t91+
     5         8*t19*t34*t89+2.6666666666666666d+0*t165*t89-2.9629629629
     6         62963d-1*t180*t227*t88+4.444444444444444d-1*t164*t181*t88
     7         )+2.2500000000000003d+0*t177*t96+1.1250000000000002d+0*t1
     8         79*t93+1.1250000000000002d+0*t184*t84+1.1250000000000002d
     9         +0*t23*(32*t79*t81*t83-80*t158*t41*t83-4*t156*t34*t83+t27
     :         8+t277+t275+t273+t272+t271+t266+t265+t264+t263+t262+t260+
     ;         t259+t258+t256+t255+t250+t249+t248+t247+t246+t245+t244+t2
     <         43+t242+t241+t240+t238+t237+t235)+t226+t224+t223+t222+t21
     =         9+t218+t217+t215+t214+t208+t207+t206+t205+t204+t203+t202+
     >         t200+t199+t196+t195+t193+t191+t189)*wght+1.0d+0*t185*wght
     ?         +t276+Amat3(iq,D3_RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*t1*(3.375000000000001d+0*t179
     1         *t99+1.1250000000000002d+0*t42*(-2.962962962962963d-1*t23
     2         0*t98**3+1.3333333333333333d+0*t170*t183*t98-2.9629629629
     3         62963d-1*t227*t97**3+1.3333333333333333d+0*t164*t181*t97+
     4         1.3333333333333333d+0*(t231+t229)*t92+1.3333333333333333d
     5         +0*(t232+t228)*t89)+3.375000000000001d+0*t184*t96+1.12500
     6         00000000002d+0*t23*(96*t79*t81*t83-240*t158*t41*t83-12*t1
     7         56*t34*t83+t279+t274+t273+t272+t271+t267+t266+t265+t264+t
     8         263+t262+t260+t259+t258+t256+t255+t250+t249+t248+t247+t24
     9         6+t245+t244+t243+t242+t241+t240+t238+t237+t235)+t226+t224
     :         +t223+t222+t219+t218+t217+t215+t214+t208+t207+t206+t205+t
     ;         204+t203+t202+t200+t199+t196+t195+t193+t191+t189)*wght+3.
     <         0d+0*t185*wght+Amat3(iq,D3_RB_RB_RB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+8.908571061768626d-1*t3+1.30045d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = log(6.203504908994001d-1*t20*t9)
            t22 = t11+4.7584000000000004d-3
            t23 = t22**2
            t24 = log(1.0d+0*t20*t23)
            t25 = t15+1.13107d+0
            t26 = atan(7.123108917818117d+0/t25)
            t27 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = t11+3.25d-1
            t31 = t30**2
            t32 = t15+7.06042d+0
            t33 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         554535d-2*log(6.203504908994001d-1*t29*t9)+5.249139316978
     2         092d-2*atan(4.7309269095601136d+0/t32)+2.2478670955426108
     3         d-3*log(1.0d+0*t29*t31)-3.8783294878113006d-2*t17-9.69022
     4         7711544375d-4*t14-3.10907d-2*t10)+5.365091848883603d-3*t2
     5         6+6.991732350764465d-6*t24+1.688686394038963d-2*t21)-5.36
     6         5091848883603d-3*t26-6.991732350764465d-6*t24-1.688686394
     7         038963d-2*t21)+3.8783294878113006d-2*t17+9.69022771154437
     8         5d-4*t14+3.10907d-2*t10
            t34 = 1/t9
            t35 = -2.067834969664667d-1/rhoa**1.3333333333333333d+0
            t36 = 1/t2**3
            t37 = 1/rhoa**6.666666666666667d-1
            t38 = t35-4.8930311001203647d-1*t36*t37
            t39 = 1/t6
            t40 = 1/rhoa**1.6666666666666666d+0
            t41 = -6.203504908994001d-1*t38*t39*t8*t9-2.067834969664667d
     1         -1*t34*t40*t8
            t42 = 1/t16**2
            t43 = 3.784699104639999d+1*t42+1
            t44 = 1/t43
            t45 = 1/t13
            t46 = -1.0d+0*t13*t38*t39*t8-2.625411059665811d-1*t12*t36*t3
     1         7*t8
            t47 = t35-1.4847618436281043d-1*t36*t37
            t48 = 1/t18
            t49 = -6.203504908994001d-1*t20*t47*t48*t9-2.067834969664667
     1         d-1*t20*t34*t40
            t50 = 1/t25**2
            t51 = 5.07386806551d+1*t50+1
            t52 = 1/t51
            t53 = 1/t23
            t54 = -1.0d+0*t20*t23*t47*t48-2.625411059665811d-1*t20*t22*t
     1         36*t37
            t55 = t35-9.26825237694284d-1*t36*t37
            t56 = 1/t27
            t57 = -6.203504908994001d-1*t29*t55*t56*t9-2.067834969664667
     1         d-1*t29*t34*t40
            t58 = 1/t32**2
            t59 = 2.238166942360001d+1*t58+1
            t60 = 1/t59
            t61 = 1/t31
            t62 = -1.0d+0*t29*t31*t55*t56-2.625411059665811d-1*t29*t30*t
     1         36*t37
            t63 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-9
     1         .690227711544375d-4*t45*t46*t7-5.011795824473985d-2*t34*t
     2         41*t7+2.2478670955426108d-3*t28*t61*t62+6.519760588836059
     3         d-2*t36*t37*t58*t60+2.5058979122369923d-2*t28*t34*t57-6.2
     4         64085709464389d-2*t36*t37*t42*t44)+6.991732350764465d-6*t
     5         19*t53*t54+1.0033305979455584d-2*t36*t37*t50*t52+2.722148
     6         880047894d-2*t19*t34*t49)-6.991732350764465d-6*t19*t53*t5
     7         4-1.0033305979455584d-2*t36*t37*t50*t52-2.722148880047894
     8         d-2*t19*t34*t49)+9.690227711544375d-4*t45*t46*t7+5.011795
     9         824473985d-2*t34*t41*t7+6.264085709464389d-2*t36*t37*t42*
     :         t44
            t64 = 1/t43**2
            t65 = 1/t16**5
            t66 = 1/rhoa**2.3333333333333334d+0
            t67 = 1/t16**3
            t68 = 1/rhoa**1.6666666666666669d+0
            t69 = t38**2
            t70 = 1/t6**2
            t71 = 2.7571132928862224d-1/rhoa**2.333333333333333d+0
            t72 = 1/t2**5
            t73 = 1/rhoa**1.3333333333333336d+0
            t74 = 2.4465155500601823d-1*t72*t73+t71+3.262020733413577d-1
     1         *t36*t68
            t75 = 1/rhoa**2.6666666666666666d+0
            t76 = -6.203504908994001d-1*t39*t74*t8*t9+1.2407009817988002
     1         d+0*t69*t70*t8*t9+2.7571132928862224d-1*t34*t75*t8+4.1356
     2         69939329334d-1*t34*t38*t39*t40*t8
            t77 = 1/rhoa**9.999999999999999d-1
            t78 = 1/t12**3
            t79 = -1.0d+0*t13*t39*t74*t8+1.3127055298329054d-1*t12*t72*t
     1         73*t8+2.0d+0*t13*t69*t70*t8+1.7502740397772074d-1*t12*t36
     2         *t68*t8+3.446391616107778d-2*t66*t8+5.250822119331622d-1*
     3         t12*t36*t37*t38*t39*t8
            t80 = 1/t51**2
            t81 = 1/t25**5
            t82 = 1/t25**3
            t83 = t47**2
            t84 = 1/t18**2
            t85 = 7.423809218140521d-2*t72*t73+t71+9.89841229085403d-2*t
     1         36*t68
            t86 = -6.203504908994001d-1*t20*t48*t85*t9+1.240700981798800
     1         2d+0*t20*t83*t84*t9+2.7571132928862224d-1*t20*t34*t75+4.1
     2         35669939329334d-1*t20*t34*t40*t47*t48
            t87 = 1/t22**3
            t88 = -1.0d+0*t20*t23*t48*t85+2.0d+0*t20*t23*t83*t84+1.31270
     1         55298329054d-1*t20*t22*t72*t73+1.7502740397772074d-1*t20*
     2         t22*t36*t68+3.446391616107778d-2*t20*t66+5.25082211933162
     3         2d-1*t20*t22*t36*t37*t47*t48
            t89 = 1/t59**2
            t90 = 1/t32**5
            t91 = 1/t32**3
            t92 = t55**2
            t93 = 1/t27**2
            t94 = 4.63412618847142d-1*t72*t73+t71+6.178834917961894d-1*t
     1         36*t68
            t95 = -6.203504908994001d-1*t29*t56*t9*t94+1.240700981798800
     1         2d+0*t29*t9*t92*t93+2.7571132928862224d-1*t29*t34*t75+4.1
     2         35669939329334d-1*t29*t34*t40*t55*t56
            t96 = 1/t30**3
            t97 = -1.0d+0*t29*t31*t56*t94+2.0d+0*t29*t31*t92*t93+1.31270
     1         55298329054d-1*t29*t30*t72*t73+1.7502740397772074d-1*t29*
     2         t30*t36*t68+3.446391616107778d-2*t29*t66+5.25082211933162
     3         2d-1*t29*t30*t36*t37*t55*t56
            t98 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(2.
     1         2478670955426108d-3*t28*t61*t97+5.901575133296435d-4*t28*
     2         t36*t37*t62*t96+2.5058979122369923d-2*t28*t34*t95+3.42341
     3         03112606934d-2*t60*t66*t91-7.662163788798045d-1*t66*t89*t
     4         90-9.690227711544375d-4*t38*t45*t46*t6*t8-5.0117958244739
     5         85d-2*t34*t38*t41*t6*t8-9.690227711544375d-4*t45*t7*t79-2
     6         .544083100456872d-4*t36*t37*t46*t7*t78-1.670598608157995d
     7         -2*t34*t41*t7*t77+8.352993040789976d-3*t28*t34*t57*t77-5.
     8         011795824473985d-2*t34*t7*t76-3.2598802944180294d-2*t58*t
     9         60*t72*t73+3.1320428547321943d-2*t42*t44*t72*t73-4.346507
     :         0592240396d-2*t36*t58*t60*t68+4.176057139642926d-2*t36*t4
     ;         2*t44*t68-3.289159980064472d-2*t44*t66*t67+1.244848083156
     <         7728d+0*t64*t65*t66+2.2478670955426108d-3*t27*t29*t55*t61
     =         *t62+2.5058979122369923d-2*t27*t29*t34*t55*t57)+6.9917323
     >         50764465d-6*t19*t53*t88+1.8356171439920266d-6*t19*t36*t37
     ?         *t54*t87+2.722148880047894d-2*t19*t34*t86+5.2683104966947
     @         6d-3*t52*t66*t82-2.6730712388370664d-1*t66*t80*t81+9.0738
     1         29600159646d-3*t19*t34*t49*t77-5.016652989727792d-3*t50*t
     2         52*t72*t73-6.68887065297039d-3*t36*t50*t52*t68+6.99173235
     3         0764465d-6*t18*t20*t47*t53*t54+2.722148880047894d-2*t18*t
     4         20*t34*t47*t49)-6.991732350764465d-6*t19*t53*t88-1.835617
     5         1439920266d-6*t19*t36*t37*t54*t87-2.722148880047894d-2*t1
     6         9*t34*t86-5.26831049669476d-3*t52*t66*t82+2.6730712388370
     7         664d-1*t66*t80*t81-9.073829600159646d-3*t19*t34*t49*t77+5
     8         .016652989727792d-3*t50*t52*t72*t73+6.68887065297039d-3*t
     9         36*t50*t52*t68-6.991732350764465d-6*t18*t20*t47*t53*t54-2
     :         .722148880047894d-2*t18*t20*t34*t47*t49)+9.69022771154437
     ;         5d-4*t38*t45*t46*t6*t8+5.011795824473985d-2*t34*t38*t41*t
     <         6*t8+9.690227711544375d-4*t45*t7*t79+2.544083100456872d-4
     =         *t36*t37*t46*t7*t78+1.670598608157995d-2*t34*t41*t7*t77+5
     >         .011795824473985d-2*t34*t7*t76-3.1320428547321943d-2*t42*
     ?         t44*t72*t73-4.176057139642926d-2*t36*t42*t44*t68+3.289159
     @         980064472d-2*t44*t66*t67-1.2448480831567728d+0*t64*t65*t6
     1         6
            t99 = 1/rhoa**3.3333333333333337d+0
            t100 = 1/t43**3
            t101 = 1/t16**8
            t102 = 1/rhoa**3.0d+0
            t103 = 1/t16**6
            t104 = 1/t16**4
            t105 = 1/rhoa**2.666666666666667d+0
            t106 = 1/t12**4
            t107 = 1/t2**7
            t108 = 1/rhoa**2.0d+0
            t109 = 1/rhoa**1.9999999999999998d+0
            t110 = t38**3
            t111 = 1/t6**3
            t112 = -6.433264350067851d-1/rhoa**3.333333333333333d+0
            t113 = -4.893031100120365d-1*t66*t72-5.436701222355962d-1*t1
     1         05*t36+t112-2.0387629583834851d-1*t107*t108
            t114 = 1/rhoa**3.6666666666666664d+0
            t115 = 3.7221029453964005d+0*t38*t70*t74*t8*t9-6.20350490899
     1         4001d-1*t113*t39*t8*t9-3.7221029453964005d+0*t110*t111*t8
     2         *t9-8.271339878658668d-1*t34*t38*t39*t75*t8+6.20350490899
     3         4001d-1*t34*t39*t40*t74*t8-1.2407009817988002d+0*t34*t40*
     4         t69*t70*t8-6.433264350067852d-1*t114*t34*t8
            t116 = -1.2062370656377223d-1*t8*t99+6.0d+0*t13*t38*t70*t74*
     1         t8+7.876233178997433d-1*t12*t36*t37*t39*t74*t8-3.93811658
     2         94987163d-1*t12*t38*t39*t72*t73*t8-2.625411059665811d-1*t
     3         12*t66*t72*t8-1.5752466357994865d+0*t12*t36*t37*t69*t70*t
     4         8-5.250822119331622d-1*t12*t36*t38*t39*t68*t8-1.033917484
     5         8323335d-1*t38*t39*t66*t8-1.0d+0*t113*t13*t39*t8-2.917123
     6         399628679d-1*t105*t12*t36*t8-6.0d+0*t110*t111*t13*t8-1.09
     7         39212748607545d-1*t107*t108*t12*t8
            t117 = 1/t51**3
            t118 = 1/t25**8
            t119 = 1/t25**6
            t120 = 1/t25**4
            t121 = 1/t22**4
            t122 = t47**3
            t123 = 1/t18**3
            t124 = -1.4847618436281043d-1*t66*t72-1.649735381809005d-1*t
     1         105*t36+t112-6.186507681783768d-2*t107*t108
            t125 = 3.7221029453964005d+0*t20*t47*t84*t85*t9-6.2035049089
     1         94001d-1*t124*t20*t48*t9-3.7221029453964005d+0*t122*t123*
     2         t20*t9+6.203504908994001d-1*t20*t34*t40*t48*t85-1.2407009
     3         817988002d+0*t20*t34*t40*t83*t84-8.271339878658668d-1*t20
     4         *t34*t47*t48*t75-6.433264350067852d-1*t114*t20*t34
            t126 = -1.2062370656377223d-1*t20*t99+6.0d+0*t20*t23*t47*t84
     1         *t85+7.876233178997433d-1*t20*t22*t36*t37*t48*t85-1.57524
     2         66357994865d+0*t20*t22*t36*t37*t83*t84-3.9381165894987163
     3         d-1*t20*t22*t47*t48*t72*t73-2.625411059665811d-1*t20*t22*
     4         t66*t72-5.250822119331622d-1*t20*t22*t36*t47*t48*t68-1.03
     5         39174848323335d-1*t20*t47*t48*t66-1.0d+0*t124*t20*t23*t48
     6         -2.917123399628679d-1*t105*t20*t22*t36-6.0d+0*t122*t123*t
     7         20*t23-1.0939212748607545d-1*t107*t108*t20*t22
            t127 = t55**3
            t128 = 1/t27**3
            t129 = -9.26825237694284d-1*t66*t72-1.0298058196603158d+0*t1
     1         05*t36+t112-3.8617718237261833d-1*t107*t108
            fnc(iq) = 1.0d+0*rhoa*t33*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t63*wght+1.0d+0*t33*wght+Amat(i
     1         q,D1_RA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*rhoa*t98*wght+2.0d+0*t63*wght+Am
     1         at2(iq,D2_RA_RA)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*rhoa*(5.848223622634643d-1*(1
     1         .0d+0*(1.709920934161365d+0*(2.2478670955426108d-3*t28*t6
     2         1*(-1.2062370656377223d-1*t29*t99+6.0d+0*t29*t31*t55*t93*
     3         t94+7.876233178997433d-1*t29*t30*t36*t37*t56*t94-1.575246
     4         6357994865d+0*t29*t30*t36*t37*t92*t93-3.9381165894987163d
     5         -1*t29*t30*t55*t56*t72*t73-2.625411059665811d-1*t29*t30*t
     6         66*t72-5.250822119331622d-1*t29*t30*t36*t55*t56*t68-1.033
     7         9174848323335d-1*t29*t55*t56*t66-1.0d+0*t129*t29*t31*t56-
     8         2.917123399628679d-1*t105*t29*t30*t36-6.0d+0*t127*t128*t2
     9         9*t31-1.0939212748607545d-1*t107*t108*t29*t30)-1.19819360
     :         89412427d-1*t60*t91*t99+2.681757326079316d+0*t89*t90*t99+
     ;         1.1512059930225654d-1*t44*t67*t99-4.356968291048705d+0*t6
     <         4*t65*t99+1.1803150266592868d-3*t28*t36*t37*t96*t97+4.495
     =         7341910852217d-3*t27*t29*t55*t61*t97-2.9507875666482175d-
     >         4*t28*t62*t72*t73*t96-3.934383422197623d-4*t28*t36*t62*t6
     ?         8*t96+1.1803150266592868d-3*t27*t29*t36*t37*t55*t62*t96+1
     @         .670598608157995d-2*t28*t34*t77*t95+5.011795824473985d-2*
     1         t27*t29*t34*t55*t95+2.5058979122369923d-2*t28*t34*(3.7221
     2         029453964005d+0*t29*t55*t9*t93*t94+6.203504908994001d-1*t
     3         29*t34*t40*t56*t94-1.2407009817988002d+0*t29*t34*t40*t92*
     4         t93-6.203504908994001d-1*t129*t29*t56*t9-3.72210294539640
     5         05d+0*t127*t128*t29*t9-8.271339878658668d-1*t29*t34*t55*t
     6         56*t75-6.433264350067852d-1*t114*t29*t34)+2.2478670955426
     7         108d-3*t27*t29*t61*t62*t94+2.5058979122369923d-2*t27*t29*
     8         t34*t57*t94-1.4081430686456894d+0*t102*t36*t89/t32**6-1.9
     9         38045542308875d-3*t38*t45*t6*t79*t8-5.088166200913744d-4*
     :         t36*t37*t38*t46*t6*t78*t8-3.34119721631599d-2*t34*t38*t41
     ;         *t6*t77*t8-1.002359164894797d-1*t34*t38*t6*t76*t8-9.69022
     <         7711544375d-4*t45*t46*t6*t74*t8-5.011795824473985d-2*t34*
     =         t41*t6*t74*t8-5.088166200913744d-4*t36*t37*t7*t78*t79+1.2
     >         72041550228436d-4*t46*t7*t72*t73*t78+1.696055400304582d-4
     ?         *t36*t46*t68*t7*t78-3.34119721631599d-2*t34*t7*t76*t77+1.
     @         670598608157995d-2*t27*t29*t34*t55*t57*t77+6.519760588836
     1         06d-2*t58*t60*t66*t72-6.26408570946439d-2*t42*t44*t66*t72
     2         -1.0018895862972538d-4*t106*t46*t66*t7-9.690227711544375d
     3         -4*t116*t45*t7-5.568662027193316d-3*t109*t34*t41*t7+1.670
     4         5986081579946d-2*t108*t34*t41*t7-5.011795824473985d-2*t11
     5         5*t34*t7+2.3241090936607786d-4*t28*t62*t66/t30**4+2.28776
     6         65475865033d+0*t102*t103*t36*t64+7.244178432040066d-2*t10
     7         5*t36*t58*t60+2.716566912015024d-2*t107*t108*t58*t60+2.69
     8         635778788734d-2*t102*t36*t60/t32**4+1.8009481522035156d+1
     9         *t102*t36/(t32**8*t59**3)+2.784331013596658d-3*t109*t28*t
     :         34*t57-8.352993040789973d-3*t108*t28*t34*t57-6.9600952327
     ;         3821d-2*t105*t36*t42*t44-2.610035712276828d-2*t107*t108*t
     <         42*t44-2.590619096601433d-2*t102*t104*t36*t44-4.947718859
     =         586276d+1*t100*t101*t102*t36)-1.843908673843166d-2*t52*t8
     >         2*t99+9.355749335929733d-1*t80*t81*t99+3.671234287984053d
     ?         -6*t19*t36*t37*t87*t88+1.3983464701528928d-5*t18*t20*t47*
     @         t53*t88-9.178085719960132d-7*t19*t54*t72*t73*t87-1.223744
     1         7626613511d-6*t19*t36*t54*t68*t87+3.671234287984053d-6*t1
     2         8*t20*t36*t37*t47*t54*t87+1.8147659200319294d-2*t19*t34*t
     3         77*t86+5.444297760095788d-2*t18*t20*t34*t47*t86+6.9917323
     4         50764465d-6*t18*t20*t53*t54*t85+2.722148880047894d-2*t18*
     5         t20*t34*t49*t85-4.9125375556021966d-1*t102*t119*t36*t80+1
     6         .8147659200319294d-2*t18*t20*t34*t47*t49*t77+1.0033305979
     7         455585d-2*t50*t52*t66*t72+7.228874326723254d-7*t121*t19*t
     8         54*t66+6.991732350764465d-6*t126*t19*t53+1.11481177549506
     9         5d-2*t105*t36*t50*t52+4.180544158106493d-3*t107*t108*t50*
     :         t52+4.1494441931327714d-3*t102*t120*t36*t52+3.02460986671
     ;         9882d-3*t109*t19*t34*t49-9.073829600159644d-3*t108*t19*t3
     <         4*t49+1.424318138513631d+1*t102*t117*t118*t36+2.722148880
     =         047894d-2*t125*t19*t34)+1.843908673843166d-2*t52*t82*t99-
     >         9.355749335929733d-1*t80*t81*t99-3.671234287984053d-6*t19
     ?         *t36*t37*t87*t88-1.3983464701528928d-5*t18*t20*t47*t53*t8
     @         8+9.178085719960132d-7*t19*t54*t72*t73*t87+1.223744762661
     1         3511d-6*t19*t36*t54*t68*t87-3.671234287984053d-6*t18*t20*
     2         t36*t37*t47*t54*t87-1.8147659200319294d-2*t19*t34*t77*t86
     3         -5.444297760095788d-2*t18*t20*t34*t47*t86-6.9917323507644
     4         65d-6*t18*t20*t53*t54*t85-2.722148880047894d-2*t18*t20*t3
     5         4*t49*t85+4.9125375556021966d-1*t102*t119*t36*t80-1.81476
     6         59200319294d-2*t18*t20*t34*t47*t49*t77-1.0033305979455585
     7         d-2*t50*t52*t66*t72-7.228874326723254d-7*t121*t19*t54*t66
     8         -6.991732350764465d-6*t126*t19*t53-1.114811775495065d-2*t
     9         105*t36*t50*t52-4.180544158106493d-3*t107*t108*t50*t52-4.
     :         1494441931327714d-3*t102*t120*t36*t52-3.024609866719882d-
     ;         3*t109*t19*t34*t49+9.073829600159644d-3*t108*t19*t34*t49-
     <         1.424318138513631d+1*t102*t117*t118*t36-2.722148880047894
     =         d-2*t125*t19*t34)-1.1512059930225654d-1*t44*t67*t99+4.356
     >         968291048705d+0*t64*t65*t99+1.938045542308875d-3*t38*t45*
     ?         t6*t79*t8+5.088166200913744d-4*t36*t37*t38*t46*t6*t78*t8+
     @         3.34119721631599d-2*t34*t38*t41*t6*t77*t8+1.0023591648947
     1         97d-1*t34*t38*t6*t76*t8+9.690227711544375d-4*t45*t46*t6*t
     2         74*t8+5.011795824473985d-2*t34*t41*t6*t74*t8+5.0881662009
     3         13744d-4*t36*t37*t7*t78*t79-1.272041550228436d-4*t46*t7*t
     4         72*t73*t78-1.696055400304582d-4*t36*t46*t68*t7*t78+3.3411
     5         9721631599d-2*t34*t7*t76*t77+6.26408570946439d-2*t42*t44*
     6         t66*t72+1.0018895862972538d-4*t106*t46*t66*t7+9.690227711
     7         544375d-4*t116*t45*t7+5.568662027193316d-3*t109*t34*t41*t
     8         7-1.6705986081579946d-2*t108*t34*t41*t7+5.011795824473985
     9         d-2*t115*t34*t7-2.2877665475865033d+0*t102*t103*t36*t64+6
     :         .96009523273821d-2*t105*t36*t42*t44+2.610035712276828d-2*
     ;         t107*t108*t42*t44+2.590619096601433d-2*t102*t104*t36*t44+
     <         4.947718859586276d+1*t100*t101*t102*t36)*wght+3.0d+0*t98*
     =         wght+Amat3(iq,D3_RA_RA_RA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+8.908571061768626d-1*t3+1.30045d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = log(6.203504908994001d-1*t20*t9)
            t22 = t11+4.7584000000000004d-3
            t23 = t22**2
            t24 = log(1.0d+0*t20*t23)
            t25 = t15+1.13107d+0
            t26 = atan(7.123108917818117d+0/t25)
            t27 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = t11+3.25d-1
            t31 = t30**2
            t32 = t15+7.06042d+0
            t33 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         554535d-2*log(6.203504908994001d-1*t29*t9)+5.249139316978
     2         092d-2*atan(4.7309269095601136d+0/t32)+2.2478670955426108
     3         d-3*log(1.0d+0*t29*t31)-3.8783294878113006d-2*t17-9.69022
     4         7711544375d-4*t14-3.10907d-2*t10)+5.365091848883603d-3*t2
     5         6+6.991732350764465d-6*t24+1.688686394038963d-2*t21)-5.36
     6         5091848883603d-3*t26-6.991732350764465d-6*t24-1.688686394
     7         038963d-2*t21)+3.8783294878113006d-2*t17+9.69022771154437
     8         5d-4*t14+3.10907d-2*t10
            t34 = 1/t9
            t35 = -2.067834969664667d-1/rhob**1.3333333333333333d+0
            t36 = 1/t2**3
            t37 = 1/rhob**6.666666666666667d-1
            t38 = t35-4.8930311001203647d-1*t36*t37
            t39 = 1/t6
            t40 = 1/rhob**1.6666666666666666d+0
            t41 = -6.203504908994001d-1*t38*t39*t8*t9-2.067834969664667d
     1         -1*t34*t40*t8
            t42 = 1/t16**2
            t43 = 3.784699104639999d+1*t42+1
            t44 = 1/t43
            t45 = 1/t13
            t46 = -1.0d+0*t13*t38*t39*t8-2.625411059665811d-1*t12*t36*t3
     1         7*t8
            t47 = t35-1.4847618436281043d-1*t36*t37
            t48 = 1/t18
            t49 = -6.203504908994001d-1*t20*t47*t48*t9-2.067834969664667
     1         d-1*t20*t34*t40
            t50 = 1/t25**2
            t51 = 5.07386806551d+1*t50+1
            t52 = 1/t51
            t53 = 1/t23
            t54 = -1.0d+0*t20*t23*t47*t48-2.625411059665811d-1*t20*t22*t
     1         36*t37
            t55 = t35-9.26825237694284d-1*t36*t37
            t56 = 1/t27
            t57 = -6.203504908994001d-1*t29*t55*t56*t9-2.067834969664667
     1         d-1*t29*t34*t40
            t58 = 1/t32**2
            t59 = 2.238166942360001d+1*t58+1
            t60 = 1/t59
            t61 = 1/t31
            t62 = -1.0d+0*t29*t31*t55*t56-2.625411059665811d-1*t29*t30*t
     1         36*t37
            t63 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-9
     1         .690227711544375d-4*t45*t46*t7-5.011795824473985d-2*t34*t
     2         41*t7+2.2478670955426108d-3*t28*t61*t62+6.519760588836059
     3         d-2*t36*t37*t58*t60+2.5058979122369923d-2*t28*t34*t57-6.2
     4         64085709464389d-2*t36*t37*t42*t44)+6.991732350764465d-6*t
     5         19*t53*t54+1.0033305979455584d-2*t36*t37*t50*t52+2.722148
     6         880047894d-2*t19*t34*t49)-6.991732350764465d-6*t19*t53*t5
     7         4-1.0033305979455584d-2*t36*t37*t50*t52-2.722148880047894
     8         d-2*t19*t34*t49)+9.690227711544375d-4*t45*t46*t7+5.011795
     9         824473985d-2*t34*t41*t7+6.264085709464389d-2*t36*t37*t42*
     :         t44
            t64 = 1/t43**2
            t65 = 1/t16**5
            t66 = 1/rhob**2.3333333333333334d+0
            t67 = 1/t16**3
            t68 = 1/rhob**1.6666666666666669d+0
            t69 = t38**2
            t70 = 1/t6**2
            t71 = 2.7571132928862224d-1/rhob**2.333333333333333d+0
            t72 = 1/t2**5
            t73 = 1/rhob**1.3333333333333336d+0
            t74 = 2.4465155500601823d-1*t72*t73+t71+3.262020733413577d-1
     1         *t36*t68
            t75 = 1/rhob**2.6666666666666666d+0
            t76 = -6.203504908994001d-1*t39*t74*t8*t9+1.2407009817988002
     1         d+0*t69*t70*t8*t9+2.7571132928862224d-1*t34*t75*t8+4.1356
     2         69939329334d-1*t34*t38*t39*t40*t8
            t77 = 1/rhob**9.999999999999999d-1
            t78 = 1/t12**3
            t79 = -1.0d+0*t13*t39*t74*t8+1.3127055298329054d-1*t12*t72*t
     1         73*t8+2.0d+0*t13*t69*t70*t8+1.7502740397772074d-1*t12*t36
     2         *t68*t8+3.446391616107778d-2*t66*t8+5.250822119331622d-1*
     3         t12*t36*t37*t38*t39*t8
            t80 = 1/t51**2
            t81 = 1/t25**5
            t82 = 1/t25**3
            t83 = t47**2
            t84 = 1/t18**2
            t85 = 7.423809218140521d-2*t72*t73+t71+9.89841229085403d-2*t
     1         36*t68
            t86 = -6.203504908994001d-1*t20*t48*t85*t9+1.240700981798800
     1         2d+0*t20*t83*t84*t9+2.7571132928862224d-1*t20*t34*t75+4.1
     2         35669939329334d-1*t20*t34*t40*t47*t48
            t87 = 1/t22**3
            t88 = -1.0d+0*t20*t23*t48*t85+2.0d+0*t20*t23*t83*t84+1.31270
     1         55298329054d-1*t20*t22*t72*t73+1.7502740397772074d-1*t20*
     2         t22*t36*t68+3.446391616107778d-2*t20*t66+5.25082211933162
     3         2d-1*t20*t22*t36*t37*t47*t48
            t89 = 1/t59**2
            t90 = 1/t32**5
            t91 = 1/t32**3
            t92 = t55**2
            t93 = 1/t27**2
            t94 = 4.63412618847142d-1*t72*t73+t71+6.178834917961894d-1*t
     1         36*t68
            t95 = -6.203504908994001d-1*t29*t56*t9*t94+1.240700981798800
     1         2d+0*t29*t9*t92*t93+2.7571132928862224d-1*t29*t34*t75+4.1
     2         35669939329334d-1*t29*t34*t40*t55*t56
            t96 = 1/t30**3
            t97 = -1.0d+0*t29*t31*t56*t94+2.0d+0*t29*t31*t92*t93+1.31270
     1         55298329054d-1*t29*t30*t72*t73+1.7502740397772074d-1*t29*
     2         t30*t36*t68+3.446391616107778d-2*t29*t66+5.25082211933162
     3         2d-1*t29*t30*t36*t37*t55*t56
            t98 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(2.
     1         2478670955426108d-3*t28*t61*t97+5.901575133296435d-4*t28*
     2         t36*t37*t62*t96+2.5058979122369923d-2*t28*t34*t95+3.42341
     3         03112606934d-2*t60*t66*t91-7.662163788798045d-1*t66*t89*t
     4         90-9.690227711544375d-4*t38*t45*t46*t6*t8-5.0117958244739
     5         85d-2*t34*t38*t41*t6*t8-9.690227711544375d-4*t45*t7*t79-2
     6         .544083100456872d-4*t36*t37*t46*t7*t78-1.670598608157995d
     7         -2*t34*t41*t7*t77+8.352993040789976d-3*t28*t34*t57*t77-5.
     8         011795824473985d-2*t34*t7*t76-3.2598802944180294d-2*t58*t
     9         60*t72*t73+3.1320428547321943d-2*t42*t44*t72*t73-4.346507
     :         0592240396d-2*t36*t58*t60*t68+4.176057139642926d-2*t36*t4
     ;         2*t44*t68-3.289159980064472d-2*t44*t66*t67+1.244848083156
     <         7728d+0*t64*t65*t66+2.2478670955426108d-3*t27*t29*t55*t61
     =         *t62+2.5058979122369923d-2*t27*t29*t34*t55*t57)+6.9917323
     >         50764465d-6*t19*t53*t88+1.8356171439920266d-6*t19*t36*t37
     ?         *t54*t87+2.722148880047894d-2*t19*t34*t86+5.2683104966947
     @         6d-3*t52*t66*t82-2.6730712388370664d-1*t66*t80*t81+9.0738
     1         29600159646d-3*t19*t34*t49*t77-5.016652989727792d-3*t50*t
     2         52*t72*t73-6.68887065297039d-3*t36*t50*t52*t68+6.99173235
     3         0764465d-6*t18*t20*t47*t53*t54+2.722148880047894d-2*t18*t
     4         20*t34*t47*t49)-6.991732350764465d-6*t19*t53*t88-1.835617
     5         1439920266d-6*t19*t36*t37*t54*t87-2.722148880047894d-2*t1
     6         9*t34*t86-5.26831049669476d-3*t52*t66*t82+2.6730712388370
     7         664d-1*t66*t80*t81-9.073829600159646d-3*t19*t34*t49*t77+5
     8         .016652989727792d-3*t50*t52*t72*t73+6.68887065297039d-3*t
     9         36*t50*t52*t68-6.991732350764465d-6*t18*t20*t47*t53*t54-2
     :         .722148880047894d-2*t18*t20*t34*t47*t49)+9.69022771154437
     ;         5d-4*t38*t45*t46*t6*t8+5.011795824473985d-2*t34*t38*t41*t
     <         6*t8+9.690227711544375d-4*t45*t7*t79+2.544083100456872d-4
     =         *t36*t37*t46*t7*t78+1.670598608157995d-2*t34*t41*t7*t77+5
     >         .011795824473985d-2*t34*t7*t76-3.1320428547321943d-2*t42*
     ?         t44*t72*t73-4.176057139642926d-2*t36*t42*t44*t68+3.289159
     @         980064472d-2*t44*t66*t67-1.2448480831567728d+0*t64*t65*t6
     1         6
            t99 = 1/rhob**3.3333333333333337d+0
            t100 = 1/t43**3
            t101 = 1/t16**8
            t102 = 1/rhob**3.0d+0
            t103 = 1/t16**6
            t104 = 1/t16**4
            t105 = 1/rhob**2.666666666666667d+0
            t106 = 1/t12**4
            t107 = 1/t2**7
            t108 = 1/rhob**2.0d+0
            t109 = 1/rhob**1.9999999999999998d+0
            t110 = t38**3
            t111 = 1/t6**3
            t112 = -6.433264350067851d-1/rhob**3.333333333333333d+0
            t113 = -4.893031100120365d-1*t66*t72-5.436701222355962d-1*t1
     1         05*t36+t112-2.0387629583834851d-1*t107*t108
            t114 = 1/rhob**3.6666666666666664d+0
            t115 = 3.7221029453964005d+0*t38*t70*t74*t8*t9-6.20350490899
     1         4001d-1*t113*t39*t8*t9-3.7221029453964005d+0*t110*t111*t8
     2         *t9-8.271339878658668d-1*t34*t38*t39*t75*t8+6.20350490899
     3         4001d-1*t34*t39*t40*t74*t8-1.2407009817988002d+0*t34*t40*
     4         t69*t70*t8-6.433264350067852d-1*t114*t34*t8
            t116 = -1.2062370656377223d-1*t8*t99+6.0d+0*t13*t38*t70*t74*
     1         t8+7.876233178997433d-1*t12*t36*t37*t39*t74*t8-3.93811658
     2         94987163d-1*t12*t38*t39*t72*t73*t8-2.625411059665811d-1*t
     3         12*t66*t72*t8-1.5752466357994865d+0*t12*t36*t37*t69*t70*t
     4         8-5.250822119331622d-1*t12*t36*t38*t39*t68*t8-1.033917484
     5         8323335d-1*t38*t39*t66*t8-1.0d+0*t113*t13*t39*t8-2.917123
     6         399628679d-1*t105*t12*t36*t8-6.0d+0*t110*t111*t13*t8-1.09
     7         39212748607545d-1*t107*t108*t12*t8
            t117 = 1/t51**3
            t118 = 1/t25**8
            t119 = 1/t25**6
            t120 = 1/t25**4
            t121 = 1/t22**4
            t122 = t47**3
            t123 = 1/t18**3
            t124 = -1.4847618436281043d-1*t66*t72-1.649735381809005d-1*t
     1         105*t36+t112-6.186507681783768d-2*t107*t108
            t125 = 3.7221029453964005d+0*t20*t47*t84*t85*t9-6.2035049089
     1         94001d-1*t124*t20*t48*t9-3.7221029453964005d+0*t122*t123*
     2         t20*t9+6.203504908994001d-1*t20*t34*t40*t48*t85-1.2407009
     3         817988002d+0*t20*t34*t40*t83*t84-8.271339878658668d-1*t20
     4         *t34*t47*t48*t75-6.433264350067852d-1*t114*t20*t34
            t126 = -1.2062370656377223d-1*t20*t99+6.0d+0*t20*t23*t47*t84
     1         *t85+7.876233178997433d-1*t20*t22*t36*t37*t48*t85-1.57524
     2         66357994865d+0*t20*t22*t36*t37*t83*t84-3.9381165894987163
     3         d-1*t20*t22*t47*t48*t72*t73-2.625411059665811d-1*t20*t22*
     4         t66*t72-5.250822119331622d-1*t20*t22*t36*t47*t48*t68-1.03
     5         39174848323335d-1*t20*t47*t48*t66-1.0d+0*t124*t20*t23*t48
     6         -2.917123399628679d-1*t105*t20*t22*t36-6.0d+0*t122*t123*t
     7         20*t23-1.0939212748607545d-1*t107*t108*t20*t22
            t127 = t55**3
            t128 = 1/t27**3
            t129 = -9.26825237694284d-1*t66*t72-1.0298058196603158d+0*t1
     1         05*t36+t112-3.8617718237261833d-1*t107*t108
            fnc(iq) = 1.0d+0*rhob*t33*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t63*wght+1.0d+0*t33*wght+Amat(i
     1         q,D1_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*rhob*t98*wght+2.0d+0*t63*wght+Am
     1         at2(iq,D2_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*rhob*(5.848223622634643d-1*(1
     1         .0d+0*(1.709920934161365d+0*(2.2478670955426108d-3*t28*t6
     2         1*(-1.2062370656377223d-1*t29*t99+6.0d+0*t29*t31*t55*t93*
     3         t94+7.876233178997433d-1*t29*t30*t36*t37*t56*t94-1.575246
     4         6357994865d+0*t29*t30*t36*t37*t92*t93-3.9381165894987163d
     5         -1*t29*t30*t55*t56*t72*t73-2.625411059665811d-1*t29*t30*t
     6         66*t72-5.250822119331622d-1*t29*t30*t36*t55*t56*t68-1.033
     7         9174848323335d-1*t29*t55*t56*t66-1.0d+0*t129*t29*t31*t56-
     8         2.917123399628679d-1*t105*t29*t30*t36-6.0d+0*t127*t128*t2
     9         9*t31-1.0939212748607545d-1*t107*t108*t29*t30)-1.19819360
     :         89412427d-1*t60*t91*t99+2.681757326079316d+0*t89*t90*t99+
     ;         1.1512059930225654d-1*t44*t67*t99-4.356968291048705d+0*t6
     <         4*t65*t99+1.1803150266592868d-3*t28*t36*t37*t96*t97+4.495
     =         7341910852217d-3*t27*t29*t55*t61*t97-2.9507875666482175d-
     >         4*t28*t62*t72*t73*t96-3.934383422197623d-4*t28*t36*t62*t6
     ?         8*t96+1.1803150266592868d-3*t27*t29*t36*t37*t55*t62*t96+1
     @         .670598608157995d-2*t28*t34*t77*t95+5.011795824473985d-2*
     1         t27*t29*t34*t55*t95+2.5058979122369923d-2*t28*t34*(3.7221
     2         029453964005d+0*t29*t55*t9*t93*t94+6.203504908994001d-1*t
     3         29*t34*t40*t56*t94-1.2407009817988002d+0*t29*t34*t40*t92*
     4         t93-6.203504908994001d-1*t129*t29*t56*t9-3.72210294539640
     5         05d+0*t127*t128*t29*t9-8.271339878658668d-1*t29*t34*t55*t
     6         56*t75-6.433264350067852d-1*t114*t29*t34)+2.2478670955426
     7         108d-3*t27*t29*t61*t62*t94+2.5058979122369923d-2*t27*t29*
     8         t34*t57*t94-1.4081430686456894d+0*t102*t36*t89/t32**6-1.9
     9         38045542308875d-3*t38*t45*t6*t79*t8-5.088166200913744d-4*
     :         t36*t37*t38*t46*t6*t78*t8-3.34119721631599d-2*t34*t38*t41
     ;         *t6*t77*t8-1.002359164894797d-1*t34*t38*t6*t76*t8-9.69022
     <         7711544375d-4*t45*t46*t6*t74*t8-5.011795824473985d-2*t34*
     =         t41*t6*t74*t8-5.088166200913744d-4*t36*t37*t7*t78*t79+1.2
     >         72041550228436d-4*t46*t7*t72*t73*t78+1.696055400304582d-4
     ?         *t36*t46*t68*t7*t78-3.34119721631599d-2*t34*t7*t76*t77+1.
     @         670598608157995d-2*t27*t29*t34*t55*t57*t77+6.519760588836
     1         06d-2*t58*t60*t66*t72-6.26408570946439d-2*t42*t44*t66*t72
     2         -1.0018895862972538d-4*t106*t46*t66*t7-9.690227711544375d
     3         -4*t116*t45*t7-5.568662027193316d-3*t109*t34*t41*t7+1.670
     4         5986081579946d-2*t108*t34*t41*t7-5.011795824473985d-2*t11
     5         5*t34*t7+2.3241090936607786d-4*t28*t62*t66/t30**4+2.28776
     6         65475865033d+0*t102*t103*t36*t64+7.244178432040066d-2*t10
     7         5*t36*t58*t60+2.716566912015024d-2*t107*t108*t58*t60+2.69
     8         635778788734d-2*t102*t36*t60/t32**4+1.8009481522035156d+1
     9         *t102*t36/(t32**8*t59**3)+2.784331013596658d-3*t109*t28*t
     :         34*t57-8.352993040789973d-3*t108*t28*t34*t57-6.9600952327
     ;         3821d-2*t105*t36*t42*t44-2.610035712276828d-2*t107*t108*t
     <         42*t44-2.590619096601433d-2*t102*t104*t36*t44-4.947718859
     =         586276d+1*t100*t101*t102*t36)-1.843908673843166d-2*t52*t8
     >         2*t99+9.355749335929733d-1*t80*t81*t99+3.671234287984053d
     ?         -6*t19*t36*t37*t87*t88+1.3983464701528928d-5*t18*t20*t47*
     @         t53*t88-9.178085719960132d-7*t19*t54*t72*t73*t87-1.223744
     1         7626613511d-6*t19*t36*t54*t68*t87+3.671234287984053d-6*t1
     2         8*t20*t36*t37*t47*t54*t87+1.8147659200319294d-2*t19*t34*t
     3         77*t86+5.444297760095788d-2*t18*t20*t34*t47*t86+6.9917323
     4         50764465d-6*t18*t20*t53*t54*t85+2.722148880047894d-2*t18*
     5         t20*t34*t49*t85-4.9125375556021966d-1*t102*t119*t36*t80+1
     6         .8147659200319294d-2*t18*t20*t34*t47*t49*t77+1.0033305979
     7         455585d-2*t50*t52*t66*t72+7.228874326723254d-7*t121*t19*t
     8         54*t66+6.991732350764465d-6*t126*t19*t53+1.11481177549506
     9         5d-2*t105*t36*t50*t52+4.180544158106493d-3*t107*t108*t50*
     :         t52+4.1494441931327714d-3*t102*t120*t36*t52+3.02460986671
     ;         9882d-3*t109*t19*t34*t49-9.073829600159644d-3*t108*t19*t3
     <         4*t49+1.424318138513631d+1*t102*t117*t118*t36+2.722148880
     =         047894d-2*t125*t19*t34)+1.843908673843166d-2*t52*t82*t99-
     >         9.355749335929733d-1*t80*t81*t99-3.671234287984053d-6*t19
     ?         *t36*t37*t87*t88-1.3983464701528928d-5*t18*t20*t47*t53*t8
     @         8+9.178085719960132d-7*t19*t54*t72*t73*t87+1.223744762661
     1         3511d-6*t19*t36*t54*t68*t87-3.671234287984053d-6*t18*t20*
     2         t36*t37*t47*t54*t87-1.8147659200319294d-2*t19*t34*t77*t86
     3         -5.444297760095788d-2*t18*t20*t34*t47*t86-6.9917323507644
     4         65d-6*t18*t20*t53*t54*t85-2.722148880047894d-2*t18*t20*t3
     5         4*t49*t85+4.9125375556021966d-1*t102*t119*t36*t80-1.81476
     6         59200319294d-2*t18*t20*t34*t47*t49*t77-1.0033305979455585
     7         d-2*t50*t52*t66*t72-7.228874326723254d-7*t121*t19*t54*t66
     8         -6.991732350764465d-6*t126*t19*t53-1.114811775495065d-2*t
     9         105*t36*t50*t52-4.180544158106493d-3*t107*t108*t50*t52-4.
     :         1494441931327714d-3*t102*t120*t36*t52-3.024609866719882d-
     ;         3*t109*t19*t34*t49+9.073829600159644d-3*t108*t19*t34*t49-
     <         1.424318138513631d+1*t102*t117*t118*t36-2.722148880047894
     =         d-2*t125*t19*t34)-1.1512059930225654d-1*t44*t67*t99+4.356
     >         968291048705d+0*t64*t65*t99+1.938045542308875d-3*t38*t45*
     ?         t6*t79*t8+5.088166200913744d-4*t36*t37*t38*t46*t6*t78*t8+
     @         3.34119721631599d-2*t34*t38*t41*t6*t77*t8+1.0023591648947
     1         97d-1*t34*t38*t6*t76*t8+9.690227711544375d-4*t45*t46*t6*t
     2         74*t8+5.011795824473985d-2*t34*t41*t6*t74*t8+5.0881662009
     3         13744d-4*t36*t37*t7*t78*t79-1.272041550228436d-4*t46*t7*t
     4         72*t73*t78-1.696055400304582d-4*t36*t46*t68*t7*t78+3.3411
     5         9721631599d-2*t34*t7*t76*t77+6.26408570946439d-2*t42*t44*
     6         t66*t72+1.0018895862972538d-4*t106*t46*t66*t7+9.690227711
     7         544375d-4*t116*t45*t7+5.568662027193316d-3*t109*t34*t41*t
     8         7-1.6705986081579946d-2*t108*t34*t41*t7+5.011795824473985
     9         d-2*t115*t34*t7-2.2877665475865033d+0*t102*t103*t36*t64+6
     :         .96009523273821d-2*t105*t36*t42*t44+2.610035712276828d-2*
     ;         t107*t108*t42*t44+2.590619096601433d-2*t102*t104*t36*t44+
     <         4.947718859586276d+1*t100*t101*t102*t36)*wght+3.0d+0*t98*
     =         wght+Amat3(iq,D3_RB_RB_RB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
