/*
 * Copyright (c) 2012 CTTC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Nicola Baldo <nbaldo@cttc.es>
 */

#include "buildings-helper.h"

#include <ns3/abort.h>
#include <ns3/building-list.h>
#include <ns3/building.h>
#include <ns3/log.h>
#include <ns3/mobility-building-info.h>
#include <ns3/mobility-model.h>
#include <ns3/node-list.h>

namespace ns3
{

NS_LOG_COMPONENT_DEFINE("BuildingsHelper");

void
BuildingsHelper::Install(NodeContainer c)
{
    for (auto i = c.Begin(); i != c.End(); ++i)
    {
        Install(*i);
    }
}

void
BuildingsHelper::Install(Ptr<Node> node)
{
    Ptr<Object> object = node;
    Ptr<MobilityModel> model = object->GetObject<MobilityModel>();

    NS_ABORT_MSG_UNLESS(model, "node " << node->GetId() << " does not have a MobilityModel");

    Ptr<MobilityBuildingInfo> buildingInfo = CreateObject<MobilityBuildingInfo>();
    model->AggregateObject(buildingInfo);
}

} // namespace ns3
