"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.YAMLOMap = void 0;

var _errors = require("../../errors");

var _toJSON = _interopRequireDefault(require("../../toJSON"));

var _Map = _interopRequireDefault(require("../../schema/Map"));

var _Pair = _interopRequireDefault(require("../../schema/Pair"));

var _Scalar = _interopRequireDefault(require("../../schema/Scalar"));

var _Seq = _interopRequireDefault(require("../../schema/Seq"));

var _pairs = require("./pairs");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class YAMLOMap extends _Seq.default {
  constructor() {
    super();

    _defineProperty(this, "add", _Map.default.prototype.add.bind(this));

    _defineProperty(this, "delete", _Map.default.prototype.delete.bind(this));

    _defineProperty(this, "get", _Map.default.prototype.get.bind(this));

    _defineProperty(this, "has", _Map.default.prototype.has.bind(this));

    _defineProperty(this, "set", _Map.default.prototype.set.bind(this));

    this.tag = YAMLOMap.tag;
  }

  toJSON(_, ctx) {
    const map = new Map();
    if (ctx && ctx.onCreate) ctx.onCreate(map);

    for (const pair of this.items) {
      let key, value;

      if (pair instanceof _Pair.default) {
        key = (0, _toJSON.default)(pair.key, '', ctx);
        value = (0, _toJSON.default)(pair.value, key, ctx);
      } else {
        key = (0, _toJSON.default)(pair, '', ctx);
      }

      if (map.has(key)) throw new Error('Ordered maps must not include duplicate keys');
      map.set(key, value);
    }

    return map;
  }

}

exports.YAMLOMap = YAMLOMap;

_defineProperty(YAMLOMap, "tag", 'tag:yaml.org,2002:omap');

function parseOMap(doc, cst) {
  const pairs = (0, _pairs.parsePairs)(doc, cst);
  const seenKeys = [];

  for (const {
    key
  } of pairs.items) {
    if (key instanceof _Scalar.default) {
      if (seenKeys.includes(key.value)) {
        const msg = 'Ordered maps must not include duplicate keys';
        throw new _errors.YAMLSemanticError(cst, msg);
      } else {
        seenKeys.push(key.value);
      }
    }
  }

  return Object.assign(new YAMLOMap(), pairs);
}

function createOMap(schema, iterable, ctx) {
  const pairs = (0, _pairs.createPairs)(schema, iterable, ctx);
  const omap = new YAMLOMap();
  omap.items = pairs.items;
  return omap;
}

var _default = {
  identify: value => value instanceof Map,
  nodeClass: YAMLOMap,
  default: false,
  tag: 'tag:yaml.org,2002:omap',
  resolve: parseOMap,
  createNode: createOMap
};
exports.default = _default;