/*
* @license Apache-2.0
*
* Copyright (c) 2021 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 2.0

/* tslint:disable:max-line-length */
/* tslint:disable:max-file-line-count */

import base = require( './../../base' );
import iterators = require( './../../iter' );
import sample = require( './../../sample' );
import shuffle = require( './../../shuffle' );
import streams = require( './../../streams' );

/**
* Interface describing the `random` namespace.
*/
interface Namespace {
	/**
	* Standard library base pseudorandom number generators.
	*/
	base: typeof base;

	/**
	* Standard library pseudorandom number generator iterators.
	*/
	iterators: typeof iterators;

	/**
	* Samples elements from an array-like object.
	*
	* @param x - array-like object from which to sample
	* @param options - function options
	* @param options.size - sample size
	* @param options.probs - element probabilities
	* @param options.replace - boolean indicating whether to sample with replacement (default: true)
	* @throws must provide valid options
	* @throws `size` option must be less than or equal to the length of `x` when the `replace` option is `false`
	* @returns sample
	*
	* @example
	* var out = ns.sample( [ 3, null, NaN, 'abc', function(){} ] );
	* // e.g., returns [ 3, 'abc', null, 3, null ]
	*/
	sample: typeof sample;

	/**
	* Returns a random permutation of elements in `arr`.
	*
	* @param arr - array-like object to shuffle
	* @param options - function options
	* @param options.copy - string indicating whether to return a copy (`deep`, `shallow`, or `none`; default: 'shallow')
	* @throws must provide valid options
	* @returns the shuffled array-like object
	*
	* @example
	* var data = [ 1, 2, 3 ];
	* var out = ns.shuffle( data );
	* // e.g., returns [ 3, 1, 2 ]
	*
	* @example
	* var data = [ 1, 2, 3 ];
	* var out = ns.shuffle( data, {
	*     'copy': 'none'
	* });
	* var bool = ( data === out );
	* // returns true
	*/
	shuffle: typeof shuffle;

	/**
	* Standard library pseudorandom number generator streams.
	*/
	streams: typeof streams;
}

/**
* Standard library generic random functions.
*/
declare var ns: Namespace;


// EXPORTS //

export = ns;
