#include "osl/pieceStandIO.h"
#include "osl/pieceStand.h"
#include "osl/misc/random.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <sstream>
using namespace osl;

class PieceStandIOTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(PieceStandIOTest);
  CPPUNIT_TEST(testNumbers);
  CPPUNIT_TEST_SUITE_END();
public:
  void testNumbers() 
  {
    PieceStand src;
    for (unsigned int i=0; i<PieceStand::order.size(); ++i)
    {
      const Ptype ptype = PieceStand::order[i];
      src.add(ptype, osl::random() % 3);
    }
    std::stringstream ss;
    PieceStandIO::writeNumbers(ss, src);
    PieceStand dst;
    PieceStandIO::readNumbers(ss, dst);
    
    CPPUNIT_ASSERT_EQUAL(src, dst);
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(PieceStandIOTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
