/* ----- decode/953xint16, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_953xint16_checksums[] = {
  "b85dffbe410d5d88bd60d7ea927e051ce0795e26b2524a9e8abefda128a92e7e",
  "7b1c952f6e7c01227dbbe8e0418cc4d5ea1860eba1f27166cdd9ba5af60586f9",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_953xint16_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_953xint16_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_953xint16_ITEMBYTES

static void *storage_decode_953xint16_x;
static unsigned char *test_decode_953xint16_x;
static void *storage_decode_953xint16_s;
static unsigned char *test_decode_953xint16_s;
static void *storage_decode_953xint16_x2;
static unsigned char *test_decode_953xint16_x2;
static void *storage_decode_953xint16_s2;
static unsigned char *test_decode_953xint16_s2;

#define precomputed_decode_953xint16_NUM 4

static const uint16_t precomputed_decode_953xint16_x[precomputed_decode_953xint16_NUM][crypto_decode_ITEMS] = {
  {15003,6220,7256,52746,55739,3493,30670,27584,51704,61310,31928,18691,35685,20668,15193,23373,39148,10607,59502,28220,20727,21564,24462,11989,62502,56097,24216,57245,58129,50219,36342,41646,14188,10212,49717,15813,63876,21643,59831,38939,2856,4848,58136,60018,63430,56898,5175,14548,9156,18910,63336,5099,37507,42922,21497,62501,33415,33052,11244,45524,4393,52594,52064,56102,51816,33990,61785,17812,32424,55556,27366,28067,26398,28575,22134,11158,37469,29634,14348,54419,48328,28187,56830,47089,39262,57783,26719,19325,38395,6967,42532,50056,1446,50483,58152,14182,46305,10731,25931,9528,3822,51230,9349,61348,62848,46608,22349,52592,22624,8289,34130,9373,46109,49669,35435,11530,35310,54974,2812,18954,2687,18487,5751,47668,33244,52663,64766,20550,12302,19422,1541,65199,40248,19653,53746,10494,32227,4354,45060,33208,19009,19581,11133,14616,47589,30866,57223,60082,5068,57946,11923,9829,39850,22648,24521,4119,28490,13682,32481,39620,21011,11625,58776,17575,61020,29253,17836,30523,32595,22284,65304,54861,54861,49795,57473,51378,60521,5599,6107,22950,20697,25920,59051,34555,34376,7294,59863,7885,50518,52117,40172,12831,2773,35710,26335,13864,18184,9682,25664,46819,36344,55426,42982,28383,59293,28498,25386,5205,2616,21054,77,62161,34993,52849,21442,25074,50776,30950,60245,35848,45974,35038,9080,44879,5198,49334,15706,15640,34429,64297,6757,27393,51304,47162,29335,25457,41446,32315,64845,27507,30642,55779,29954,28995,54601,53345,29705,36835,52806,1135,52039,10632,13412,49108,53018,50517,50315,12546,34668,6163,57306,36447,25842,49530,26758,26882,46316,25048,59982,16480,2977,63632,19244,26184,7070,5382,53171,14448,5925,56674,6140,61973,13252,48233,43239,27739,7800,57786,32090,6335,29504,13099,57063,17919,40575,55593,16347,45169,26988,30050,12403,17694,3799,10062,11365,55814,5618,51073,22407,61752,41799,43660,39609,55885,11888,5343,6624,9879,54075,11636,50160,61017,56934,1911,26013,37104,16222,39566,32424,15856,46191,43627,6448,51341,52439,20105,47257,9714,56877,3799,5515,29721,58337,45338,17285,40450,51839,48880,23722,46730,12580,10700,28354,200,44126,54135,65246,37318,62406,12774,33233,589,12546,30487,51009,55192,62452,31432,22014,37448,65423,18555,34107,20216,27211,54152,14481,5985,7336,8024,5795,29093,17087,17726,18252,56615,65244,35656,27043,29785,34798,21447,13773,39108,54370,1805,25394,18911,29066,63570,51925,15067,16007,14478,32366,42271,57589,30323,52466,29086,17251,49202,38724,49050,51412,22903,11121,11943,23907,6592,47592,41040,38658,49518,38902,59915,6540,47223,23585,2263,63123,4557,62516,6582,50054,5857,35392,26264,998,17056,29224,38543,3299,3965,53484,12840,62398,17620,42378,27825,47101,43446,49720,62415,57592,932,23128,43161,10132,51422,12830,36050,31906,3895,60320,14521,57054,60422,55935,31470,47487,65161,7465,29702,1428,58395,9688,6152,64948,2961,9508,3162,45520,24614,11405,7904,14796,24762,11618,945,48454,10066,51564,15845,12018,8064,3051,52435,54092,27540,58429,30787,35567,39884,19628,36529,38177,19976,42476,17427,17318,32460,30399,35155,62506,2399,54592,46481,46794,65351,13488,52200,29357,25018,8883,38550,4783,33746,17408,36424,7762,30472,61433,4940,22429,47082,37542,42894,3242,31801,25412,6567,24716,7120,26610,34330,42993,60842,11559,55312,1703,26398,27337,27525,38944,46397,10427,54557,13048,63226,18046,18842,39172,6435,52240,10773,40070,7238,19666,6953,21499,47394,25910,25823,20343,52050,60645,20439,12141,61355,51145,7356,59605,11680,36061,20125,20263,51744,46755,34800,42075,5410,49117,34187,17956,63191,30148,32411,9934,37373,48625,13921,37779,56575,52328,15734,52265,6343,27287,63023,33589,45960,29937,20826,2152,53078,24441,51705,8884,38868,61339,32010,16751,39348,39101,37959,17672,18088,10181,37791,29000,19147,38693,63317,23914,39103,22454,14784,46107,28948,20006,20229,47202,54212,24711,50806,21107,32350,19171,20403,38362,24841,6199,59010,44433,1854,46979,36445,877,19704,26526,53567,8675,45736,54085,58605,55807,28855,41217,60763,21249,25687,44449,63464,6997,257,574,36276,35656,34849,39067,18633,19639,51785,28574,13150,58543,32479,376,25976,2236,23830,23379,53911,14389,38736,11032,9556,1474,45522,20232,34444,31887,63939,38837,43605,10689,53731,36785,39152,61687,63330,10994,25939,23177,11644,30553,7512,5512,5576,49748,17176,37415,38016,30937,2685,26889,42545,3987,7734,45718,36196,54622,17450,26543,17727,21522,62233,61845,1800,31275,53396,54671,37635,6891,2653,16406,29275,32388,52972,5818,42578,41434,576,49488,19805,46709,31370,61873,61281,9057,37476,7408,31092,6751,45272,40780,10511,53364,5576,24685,23136,55637,57413,33326,48037,8245,26333,51680,47968,26368,23107,16427,60508,43714,450,41248,9133,22183,31639,30983,52766,45949,7850,43989,23954,41120,48163,37514,64566,47381,54482,18998,44288,42790,42067,52830,30495,42220,1566,33827,587,31968,18910,26426,58522,17485,28826,33695,6046,79,64081,20991,9064,11264,60696,60801,46602,3039,34409,56504,61558,53737,6907,19258,35587,21507,39337,33562,51613,35196,58456,4831,64119,44355,9330,64786,12004,42352,26576,57796,7480,64014,55068,9493,58938,20346,64754,62243,10624,59139,40067,41252,36584,65199,14913,9155,11671,55631,36409,31732,38591,28653,20761,31089,37579,61708,6134,30010,13916,53611,39061,59166,28128,44583,34857,61321,41889,57043,20000,11484,44887,53077,1029,11140,13488,50416,18210,39887,11437,31478,3120,62590,24639,26629,16971,17587,17815,15764,11817,53689,2852,61398,45286,1553,5302,60226,65153,20791,10615,1258,58268,42185,21122,25550,63119,2253,49387,40532,1288,23371,17637,25136,26468,24548,24242,36052,19230,46398,6137,46593,34886,51716,26529,53950,44266,55472,2582,42977,13656,61113,20760,6530},
  {9228,27026,5581,58173,22855,7858,9171,3933,51254,62611,43835,4474,28204,50516,1921,4681,26344,7965,61238,17555,40671,37972,27521,26872,1728,29500,29924,41411,12320,2657,49680,9652,33030,10004,5334,50967,26882,59843,33063,45794,2018,64073,4934,65135,59018,15962,17662,12065,33645,54025,2455,35574,58148,44697,23257,5249,36230,27594,62004,6925,28858,49420,61345,26183,25010,62396,2923,60911,53760,35784,32433,44754,16902,52769,38089,11727,57062,64736,20578,51166,34503,48449,31675,40273,31687,4199,65008,51088,45561,57257,60882,61307,61181,37961,58686,61086,30246,23157,11304,62486,18211,35095,11527,18865,12310,60068,9533,55160,49680,31284,37113,16296,46606,24338,33751,40645,30543,2371,47923,42926,3003,46017,59157,56284,15120,21537,37687,57201,20676,20056,16419,47248,16875,2011,61512,58279,40725,8803,29160,46346,48713,4846,57618,28873,48340,24387,62447,21902,26831,49083,11623,26181,53945,50322,50628,20199,39077,61284,19413,32308,47022,61669,988,11008,33076,9297,55269,13438,45958,39057,1691,43468,7861,7036,39296,60193,16346,6884,54140,64954,8822,49184,9361,26341,9392,37768,37509,62027,57418,1605,36740,13014,54926,27521,47091,55183,7242,5258,55748,30573,7162,10807,35793,6913,59540,34252,9193,42763,45719,61683,42195,32230,43703,57842,59708,4337,28954,50201,34758,19414,22600,12378,65139,16645,19216,4532,48577,34684,29943,48714,21213,49061,12114,44757,21728,8679,59708,37702,16850,61816,18026,11468,51836,19684,51745,16244,64856,37799,36573,49403,47801,52128,52637,11083,45114,24786,18817,13134,31842,61692,28287,41715,20248,22393,61634,36263,59204,9100,26593,25153,24692,12389,47955,57926,59563,22967,48766,17406,39811,41745,1791,64863,30946,46767,13564,14601,51575,46695,5245,15652,57684,2419,35488,8914,61630,45621,46360,18571,38851,26169,63843,42036,29373,46215,37134,55473,10986,48620,30736,30239,19289,41513,37984,26692,6853,44571,37755,50663,21169,18062,56622,52013,32330,56081,5283,47557,28554,10620,42865,46924,4132,5991,6616,9800,50310,65483,48052,4166,29737,5402,34547,16154,18502,2768,9217,20474,12151,50304,45668,17165,50701,18798,33029,36873,61486,59225,10894,53327,40341,45548,45547,6087,38102,8278,19101,25116,24045,4336,38281,36546,17151,51931,40975,42173,52493,33695,42936,4953,12654,19600,1196,37673,64788,17930,46859,52309,55566,37047,56617,57498,3589,26368,60259,61707,45214,1143,27675,35901,36596,30821,54772,14851,41562,19207,59811,64834,34972,63056,49415,11760,46733,12335,34025,3370,30569,41170,17325,61125,57131,1871,17702,56842,3901,64928,63491,12210,15320,49758,31220,39528,42858,6158,34551,56347,29580,59262,1339,33750,52548,42426,33548,55763,64444,2291,33863,28977,6291,2699,50560,5646,3622,56885,44358,25524,55174,9275,19983,44704,61278,59435,10659,32244,29732,47216,34478,28038,16243,32976,38562,32928,15439,25484,55675,55746,31324,41785,6786,63283,31752,60184,26244,28421,39791,31667,22143,46070,1020,54576,64493,47013,45111,41222,34808,10765,19097,24021,27563,18280,26400,15615,64707,14709,53818,47798,55823,62950,43446,54262,40612,16540,20210,57353,64495,56455,21110,54670,6658,47689,25092,4718,9446,7175,24481,3202,32665,52518,28922,27600,12326,49866,27174,29283,16565,8594,6616,53203,61251,52555,45741,56152,20302,17466,10482,42704,27735,31840,59924,38862,29880,6890,27359,48664,17297,25828,13873,35003,62684,19612,19072,41771,17857,25963,17521,43143,38366,42788,17037,45055,47675,23566,47794,55663,39899,20816,14430,26728,61418,63710,55092,9908,15035,52418,55082,58094,13170,40427,10460,11553,43820,64724,16555,53576,32073,43588,30784,35054,31056,1695,53958,18751,25149,32849,48857,36908,16305,22755,16707,27892,15269,49987,47105,10370,30212,3020,33469,19054,17583,49178,60452,16511,48192,1324,17964,24314,250,1236,20961,30193,41290,22755,8925,11902,8491,26995,7448,9420,16295,41713,7529,3817,28023,19837,2917,2556,60671,18458,36447,55316,1866,23357,3163,12220,12744,14726,37069,62243,30374,45526,37185,32107,24461,46990,26966,34787,64844,62631,44849,36164,12125,25722,33645,26788,17174,56511,49797,20821,39402,21381,13497,10414,1013,4857,61905,61648,61169,18215,60581,4228,16082,29929,63845,36306,54214,6459,32168,61552,32429,61549,49378,1231,10403,46221,65095,60264,53748,22931,38308,29600,45600,37840,53938,12406,60671,41762,5680,44727,6093,13788,40091,22748,46867,40995,3416,22949,17004,52963,4287,23897,25576,57388,46472,11683,14623,63575,31942,13858,41333,34552,22194,62444,4082,50230,16926,47287,53880,46670,32010,33525,5605,12807,47701,52728,19068,38420,27173,63105,45876,28550,35587,51380,38022,29295,19638,33242,49043,12585,60672,64854,9080,9826,522,20892,20767,48206,4925,34328,47349,9964,56489,56876,44638,61896,22686,61541,34412,16321,13109,40358,45026,2917,59214,17174,15732,64481,62632,9589,29635,65205,27005,62890,62947,26631,25634,15004,11674,45030,48209,48507,38539,28320,51527,31257,32863,40960,1914,2518,49646,34700,23436,48067,28513,33068,45290,39524,34916,32389,20117,18951,32318,41377,20411,19190,53835,20937,29027,43426,60425,7242,59802,27603,18735,47689,40231,30256,50545,13028,5623,40269,9334,51190,41272,45514,2599,5938,1009,21384,31949,36578,58401,38174,2471,40689,61469,29570,60575,55643,62411,1552,26527,16232,57869,33340,4532,61685,20356,27081,7786,18449,50866,37270,9433,40033,33706,923,13443,61922,33026,23162,4087,51069,46171,61995,43837,62714,17102,48199,23768,42948,203,19337,42145,40642,24431,710,2626,29274,18819,52970,4825,40054,22478,40477,14522,41708,15905,65051,13187,33684,14471,38709,59345,10049,55195,58688,16087,3829,12682,137,2553,47653,47922,39668,45971,26166,50082,31175,47360,21071,27675,33206,5882,16637,4833,19830,15144,48761,21694,37387,39725,21317,61445,38010,34757},
  {48953,26865,40734,44099,41804,613,12756,9907,44941,4359,14023,51814,52221,37510,4830,5494,8507,25871,17275,11753,23008,58819,63088,43804,38570,23442,47503,55144,41679,46216,21312,49641,1913,53959,42573,8985,2856,7824,16406,36873,11509,39948,48508,7177,27153,30776,20403,8647,18070,33341,38664,48465,30398,35805,54670,28468,59042,50439,5102,4181,9704,60108,23074,43917,23165,59956,28557,3239,36507,17256,22046,57373,44883,36591,47437,38924,39408,54504,23285,55058,56054,56915,52330,26254,29131,58255,5685,12497,37720,12083,1291,37392,1045,57782,65198,6122,55576,17776,17684,42767,41407,29474,13618,14659,61947,10460,52111,14853,11806,2403,28434,18995,53411,36765,10997,64453,39387,5323,54494,999,47812,7120,54246,382,26303,7423,19753,26562,62492,62165,63491,43910,2254,57336,45419,1531,58105,24863,6368,18676,52035,56921,45830,54241,37743,29412,1842,29903,49755,28344,21158,42518,45930,2137,485,62102,33199,12861,21676,33370,52526,54293,51954,22639,43474,57998,43181,18130,58596,29892,57133,4828,20276,16238,16732,51820,35669,10210,4411,11244,463,31725,36361,2267,11583,52621,55941,12249,59082,25092,63553,31043,46936,24084,29547,15598,41881,30279,53473,11783,63863,12739,49732,22328,11275,28243,9130,52719,27167,49409,1141,55998,49625,13489,1318,37458,60946,53976,50370,37041,4956,26057,33953,10065,63899,43244,23610,22432,43353,39400,36381,38898,13590,17210,15521,28258,50941,34534,44781,35469,31640,30120,27904,45196,28479,25187,9777,7015,4198,35769,31524,17260,16089,28781,25962,38068,58602,42171,22872,48911,58816,48876,47124,56111,64379,42842,56816,739,53745,27977,44115,60562,1483,55236,17850,1802,62988,32669,49867,42840,24952,51601,60353,39464,27497,22516,11225,22324,47881,22816,12133,18585,24110,52786,40092,56570,7437,50235,39037,47303,17009,44078,14781,27308,41832,9614,28912,13828,37827,44318,53366,38270,36708,19148,6775,26299,49067,36868,7310,60037,61396,25907,43005,23005,39997,4126,37245,64793,47071,7060,22604,63006,37601,54996,39510,20196,48653,7571,46942,19244,28291,22095,49352,43695,29130,57183,1156,49679,65118,35332,50385,19385,49565,17341,32833,40482,57978,37719,42277,9551,48050,24737,37214,41066,32127,16900,9624,54723,12464,9682,23876,40012,10830,59036,39502,20682,26982,45078,3327,43602,30485,51348,51969,38381,20501,2099,61770,22710,30075,29559,44721,61127,34647,47402,57279,18525,60294,38498,28546,33572,4618,6679,54712,48054,9781,44298,15921,49562,16133,21260,24625,10439,48969,10322,8896,44463,51222,15089,34733,29240,12022,57782,30604,25935,20715,62801,3222,44746,65107,45951,36418,10286,24948,23029,48503,43114,39263,39923,26038,41494,24124,35605,53191,49419,64344,57108,32597,47591,54904,49586,9292,3364,23824,3434,24107,12048,26541,64252,12899,32331,31542,35330,30378,11297,53588,13092,33018,22847,51024,52684,10927,6978,51757,20154,3801,28202,37283,34042,26324,45199,55293,14086,23443,23574,44724,45168,6515,10208,54113,17496,39755,5775,37056,3703,13367,60520,52832,34556,52722,63749,24863,41095,9461,2931,38575,54285,12073,2806,42000,54722,8381,27147,44097,44076,33589,8332,63760,15033,9103,54702,61140,50707,30109,25873,10915,480,9148,55715,61305,18916,22458,30858,11456,11116,15433,42943,27023,17771,1580,25590,40757,52408,20514,28098,26104,12913,22241,10028,35880,20824,18752,8481,1366,33550,47219,35196,51505,2924,6944,13503,4002,36751,61586,58142,34875,61725,47474,13338,40782,55637,59431,48709,35859,23019,65198,10438,63330,6137,30763,56300,5638,29321,60721,47405,61707,36260,35472,38996,4841,65130,62389,59897,16403,62356,10174,52498,50384,28834,8083,14232,63356,45368,27016,42952,57586,14842,54766,1731,13803,51292,35704,25584,50939,9543,14396,7031,5233,42982,14904,18105,46574,13202,3639,33174,26996,3196,18647,14179,49023,58775,36792,47194,44943,29199,40959,61445,50408,31931,56583,60867,45379,55046,1446,3,51390,44646,22665,44759,49870,45120,4253,49987,23378,6778,10983,16799,49567,62772,35001,32039,956,22917,6070,24320,46485,13127,22107,20868,34431,55893,1064,54270,604,44310,6418,31315,51172,46077,39138,65175,46331,11147,10997,63370,35789,15378,23976,37126,19921,44610,56266,63560,24341,40675,42813,20156,35198,18690,32508,63889,42538,64721,39662,29204,17662,5660,52905,51602,38881,28514,42988,13409,26495,15757,52087,24259,49107,37011,14882,62627,42624,33395,9811,20089,37103,31121,17133,39422,11440,41751,29167,45666,51235,58196,972,22986,8714,32130,54439,36663,6224,35578,37848,53089,30821,14370,24840,37402,45553,35411,15929,34450,26764,15618,61624,42505,55562,2022,24933,43840,58229,37068,9952,4493,39665,27525,22150,24473,20160,21449,45383,25688,25109,30116,12269,27350,23058,64665,20255,50238,1891,53730,60594,26038,20749,61905,23393,38805,18299,55744,20468,39157,40629,7413,44439,60856,17824,158,45839,35995,30530,56759,51008,10610,8682,12350,22376,49665,30265,15188,16654,28858,4501,21499,45737,37699,26365,22005,48661,50458,5658,16930,9328,61688,28343,41164,26029,58394,23790,44424,52829,54602,24396,54431,7282,34148,18268,11646,9957,12472,3332,35832,5703,10005,18410,11691,19472,3510,46394,65026,4071,15350,37779,11057,3425,23032,49261,30590,56702,39239,26017,18238,31432,52393,2095,38537,33555,35062,20009,53807,41588,39277,41133,30793,36632,22163,41677,44861,40967,61133,61877,15444,27397,29671,628,51894,46915,46345,34295,59919,23050,17128,63755,7606,19420,48363,13126,18828,12957,27972,32180,63977,46277,46216,6662,28916,11369,44016,1679,49091,30577,16115,48343,39469,52080,42677,47465,40756,45685,8342,3071,65031,46237,8903,37955,29148,54806,3544,19886,26685,3367,51157,20937,45610,44531,62204,57722,58177,38399,8306,33348,12394,62529,14663,53304,36331,48487,50733,47953,62676,20291,16907,3391},
  {63909,45979,57284,25770,42294,54851,52709,60835,58397,24103,50442,59367,26779,59667,64772,2888,41078,5804,54879,26305,523,35453,22597,15512,47706,19564,10393,9752,19729,44788,42236,58843,15365,49433,36364,3426,32843,6936,64209,57201,53929,22308,11247,25164,32199,25652,62020,14557,18391,19509,1030,26930,1925,51829,6229,15733,50835,5142,33050,31698,4296,62286,25056,39992,62739,25330,58554,47300,64184,63571,45180,2166,13005,8757,22233,10803,47642,29129,778,51891,7083,63620,59941,26245,24257,33330,25719,13802,20301,30006,10135,53296,503,6716,12086,16483,21688,54256,55348,1052,59044,23549,49115,11558,34433,48731,4826,21608,59911,18146,34975,31308,62814,57997,5114,57493,25928,1944,61302,7542,11119,21542,20789,55290,25844,39234,2699,46370,28272,8764,58371,26017,45341,48265,41406,22650,14738,17556,61558,16211,1989,39768,947,9351,43435,1894,49365,12049,63667,14666,61696,44255,60387,31524,34754,41713,59087,54417,60001,16135,35006,60058,6184,4132,35678,51152,1996,54711,9452,35150,33205,45960,20498,29610,56183,46754,62328,21788,46099,2610,1525,10774,52195,42927,45600,48566,57814,62884,18904,55653,3638,12198,41724,37018,5937,22869,5795,62416,26929,64798,7394,41298,58179,16457,1663,1023,59767,41230,39224,27004,53291,43277,45746,18168,21141,34161,26625,6100,59825,28032,45153,39088,52501,22657,63224,28069,11791,28789,52588,6540,11004,29937,53485,64991,9276,18960,7755,58387,40522,9994,34821,58780,49050,32063,50226,63992,43041,62101,47058,41530,22766,11517,38909,28926,34476,16013,58399,8559,7424,20817,53048,41532,55150,2897,21049,62657,8307,34975,3273,3590,63599,59306,41339,63205,10773,25158,44052,30435,60981,57871,7105,440,37742,36620,27132,11562,20542,58819,5212,56578,57849,4292,52372,3422,19017,63758,28342,18719,25078,31527,28988,65058,50422,31415,38908,17567,10733,27871,12255,42307,24980,33923,55003,32216,29951,43983,20588,38499,46497,35012,39190,45591,60988,53878,10225,27317,15409,26751,29337,23306,19276,6989,13736,50050,40166,45599,33783,10010,19888,39811,31787,26543,22578,53567,30161,38996,30529,45024,14299,10666,33953,13592,10,28416,60399,49609,17379,11458,1211,49205,65179,37041,498,37382,38918,24309,22872,12047,56431,12228,55492,49490,38601,15288,31049,2199,3867,3079,4618,35056,47304,46533,31664,6931,17007,45223,49866,23302,26608,59195,3917,39170,33147,52788,37366,22716,34874,27544,14350,45975,58944,7277,39064,35711,1803,38139,34576,23679,43499,16554,1113,18568,22492,18019,19745,2703,32719,49886,44482,4647,59849,18011,889,4771,26624,15779,37438,32377,47651,40315,15059,1115,1212,47076,37473,54039,50098,27543,34409,45624,18627,58355,49010,33203,59671,57335,24902,57237,57493,7133,56132,14323,6726,59975,52713,39519,39526,39183,60650,49470,21376,34908,51208,57433,50664,8441,39324,17047,23254,46011,32894,61903,48644,43988,18153,60171,51181,51755,19791,25346,32747,55929,64067,10647,42814,28725,49413,44996,33580,45394,42897,54479,29445,9630,5497,24918,21781,24592,28663,12594,14646,62337,8337,19660,29928,19417,63103,4152,34711,40228,12021,41290,13239,7784,10622,24226,31193,31783,16608,22903,19431,22117,21364,35422,33686,52594,45157,59568,58779,52000,47981,35962,25620,36105,42127,23542,25100,60974,7357,19486,62219,12024,3252,17837,61817,9358,27101,40258,31748,24597,31717,2529,54789,35282,27156,50116,41009,2045,60293,25918,1287,43587,42485,25861,49211,10999,27173,22949,12450,64697,52531,46495,12586,17745,40850,24702,19824,36060,64699,45283,35676,35400,63285,51601,40494,9716,44832,32785,7688,63542,10819,63269,40678,28611,23170,23547,4395,25874,8788,26209,51356,59122,2130,60133,12684,3551,7588,52743,3155,57350,17084,58047,39922,23646,59509,18937,50275,48448,29457,43407,23831,8310,14264,17287,12825,36207,56829,21375,50097,17371,23603,4310,17767,39288,62180,21681,10446,33793,62227,51933,51444,49045,27623,49735,43866,41970,55504,19322,40931,14001,47800,19614,15107,61143,43890,38371,33198,17364,14070,60039,48656,10309,2516,45345,17915,2883,54087,900,7861,56207,8376,31308,44086,38750,50584,7104,23307,35445,52820,64400,59643,7748,21195,15576,37244,29638,15912,40662,10168,52596,30103,11611,65361,20506,38108,46362,34126,14027,60911,42072,8457,24930,29095,3380,8209,56910,44843,58890,5359,48914,34915,54344,56415,57062,61058,54758,45377,8400,37771,4543,46455,11514,19259,37841,59530,56060,45419,20779,22794,62799,41793,57732,30567,7005,1784,24176,9235,42948,17505,65267,62308,23910,2797,17891,40268,56914,6155,12790,5932,35785,14411,28857,25688,12791,4919,3533,9097,4592,42535,46396,15156,40922,33633,51215,27013,58318,10641,61466,42354,44642,7143,25574,59063,25801,22049,44861,10386,21634,34479,42343,14796,55030,50021,10113,64626,16344,12372,65137,14741,33480,43612,28988,7752,20220,64966,63502,6118,32571,34553,44619,31511,24027,26565,60471,24816,427,45194,5607,47206,53165,9841,52341,48694,39512,3609,56436,42404,17782,47897,32926,64185,44822,59024,23476,34822,54361,15437,61532,61251,14673,6287,59749,38799,51182,6328,12722,54446,16373,48831,58771,33106,8817,39076,11099,46715,44774,46262,35236,15258,37660,61017,35938,41357,41912,52914,60289,39340,27614,30391,7495,25700,20488,3358,54462,43252,10437,39825,55992,20521,36698,48300,45133,41688,34552,16650,33854,12952,64485,24730,43442,17153,3741,15774,37930,14237,18121,3856,39771,40876,61780,51351,59455,33506,57671,393,6545,43111,12407,2565,50797,1651,44543,26289,35631,55348,13183,49399,35568,18818,62827,3710,18162,39004,19873,11650,15181,39396,40861,15716,27898,64608,4884,20617,27206,4975,47522,52534,3313,62656,26509,64221,65360,34187,26319,29843,19269,41039,54096,42520,28641,11968,56940,6729,5495,28819,49090,50967,19344,27611,49139,1602,51798,23033},
} ;

static const unsigned char precomputed_decode_953xint16_s[precomputed_decode_953xint16_NUM][crypto_decode_STRBYTES] = {
  {155,58,76,24,88,28,10,206,187,217,165,13,206,119,192,107,248,201,126,239,184,124,3,73,101,139,188,80,89,59,77,91,236,152,111,41,110,232,60,110,247,80,60,84,142,95,213,46,38,244,33,219,152,94,157,223,17,227,43,196,246,141,174,162,108,55,228,39,53,194,197,61,132,249,139,84,183,233,27,152,40,11,240,18,24,227,114,234,198,247,66,222,55,20,212,56,196,35,222,73,104,247,235,19,131,146,170,167,249,83,37,244,135,130,28,129,236,43,212,177,41,17,114,205,96,203,38,219,104,202,198,132,89,241,148,69,168,126,4,217,230,106,163,109,30,103,159,111,118,86,150,43,93,146,194,115,12,56,147,212,200,188,27,110,254,221,241,183,94,153,183,225,95,104,125,75,251,149,55,27,36,166,136,195,166,5,51,197,40,227,102,55,225,180,235,41,75,101,56,37,238,14,30,200,133,36,164,239,128,245,16,182,77,87,112,205,96,88,97,32,82,133,157,36,29,180,5,194,107,138,10,45,238,137,190,214,252,10,10,74,127,10,55,72,119,22,52,186,220,129,183,205,254,252,70,80,14,48,222,75,5,6,175,254,56,157,197,76,242,209,254,40,227,125,2,17,4,176,184,129,65,74,125,76,125,43,24,57,229,185,146,120,135,223,178,234,204,19,90,226,147,46,101,38,170,155,120,88,201,95,23,16,74,111,114,53,225,126,196,154,19,82,105,45,152,229,167,68,92,238,69,114,172,69,59,119,83,127,12,87,24,255,77,214,77,214,131,194,129,224,178,200,105,236,223,21,219,23,166,89,217,80,64,101,171,230,251,134,72,134,126,28,215,233,205,30,86,197,149,203,236,156,31,50,213,10,126,139,223,102,40,54,8,71,210,37,64,100,227,182,248,141,130,216,230,167,223,110,157,231,82,111,42,99,85,20,56,10,62,82,77,0,209,242,177,136,113,206,194,83,242,97,88,198,230,120,85,235,8,140,150,179,222,136,120,35,79,175,78,20,182,192,90,61,24,61,125,134,41,251,101,26,1,107,104,200,58,184,151,114,113,99,230,161,59,126,77,253,115,107,178,119,227,217,2,117,67,113,73,213,97,208,9,116,227,143,70,206,111,4,71,203,136,41,100,52,212,191,26,207,85,197,139,196,2,49,108,135,19,24,218,223,95,142,242,100,122,193,134,104,2,105,236,180,216,97,78,234,96,64,161,11,144,248,44,75,72,102,158,27,6,21,179,207,112,56,37,23,98,221,252,23,21,242,196,51,105,188,231,168,91,108,120,30,186,225,90,125,191,24,64,115,43,51,231,222,255,69,127,158,41,217,219,63,113,176,108,105,98,117,115,48,30,69,215,14,78,39,101,44,6,218,242,21,129,199,135,87,56,241,71,163,140,170,185,154,77,218,112,46,223,20,224,25,151,38,59,211,116,45,240,195,89,238,102,222,119,7,157,101,240,144,94,63,142,154,168,126,240,61,111,180,107,170,48,25,141,200,215,204,137,78,153,184,242,37,45,222,215,14,139,21,25,116,225,227,26,177,133,67,2,158,127,202,240,190,170,92,138,182,36,49,204,41,194,110,200,0,94,172,119,211,222,254,198,145,198,243,230,49,209,129,77,2,2,49,23,119,65,199,152,215,244,243,200,122,254,85,72,146,143,255,123,72,59,133,248,78,75,106,136,211,145,56,97,23,168,28,88,31,163,22,165,113,191,66,62,69,76,71,39,221,220,254,72,139,163,105,89,116,238,135,199,83,205,53,196,152,98,212,13,7,50,99,223,73,138,113,82,248,213,202,219,58,135,62,142,56,110,126,31,165,245,224,115,118,242,204,158,113,99,67,50,192,68,151,154,191,212,200,119,89,113,43,167,46,99,93,192,25,232,185,80,160,2,151,110,193,246,151,11,234,140,25,119,184,33,92,215,8,147,246,205,17,52,244,182,25,134,195,225,22,64,138,152,102,230,3,160,66,40,114,143,150,227,12,125,15,236,208,40,50,190,243,212,68,138,165,177,108,253,183,182,169,56,194,207,243,248,224,164,3,88,90,153,168,148,39,222,200,30,50,210,140,162,124,55,15,160,235,185,56,222,222,6,236,127,218,238,122,127,185,137,254,41,29,6,116,148,5,27,228,216,37,8,24,180,253,145,11,36,37,90,12,208,177,38,96,141,44,224,30,204,57,186,96,98,45,177,3,70,189,82,39,108,201,229,61,242,46,128,31,235,11,211,204,76,211,148,107,61,228,67,120,239,138,204,155,172,76,177,142,33,149,8,78,236,165,19,68,166,67,204,126,191,118,83,137,42,244,95,9,64,213,145,181,202,182,71,255,176,52,232,203,173,114,186,97,179,34,150,150,175,18,210,131,0,68,72,142,82,30,8,119,249,239,76,19,157,87,234,183,166,146,142,167,170,12,57,124,68,99,167,25,140,96,208,27,242,103,26,134,241,167,170,237,39,45,16,216,167,6,30,103,201,106,133,107,32,152,61,181,187,40,29,213,248,50,250,246,126,70,154,73,4,153,35,25,16,204,21,42,134,156,70,28,210,76,41,27,251,83,34,185,54,101,223,100,119,79,82,203,229,236,215,79,109,47,171,239,201,199,188,28,213,232,160,45,221,140,157,78,39,79,32,202,163,182,240,135,91,164,34,21,221,191,139,133,36,70,215,246,196,117,155,126,206,38,253,145,241,189,97,54,147,147,255,220,104,204,118,61,41,204,199,24,151,106,47,246,53,131,136,179,241,116,90,81,104,8,86,207,121,95,249,201,180,34,212,151,155,239,10,125,111,65,180,153,189,152,71,148,8,69,168,70,197,39,159,147,72,113,203,74,37,151,85,247,106,93,191,152,182,87,192,57,27,180,20,113,38,78,5,79,98,184,196,211,135,96,118,198,115,82,94,126,227,74,179,79,218,149,9,97,55,24,130,230,145,173,62,7,131,183,93,142,109,3,248,76,158,103,63,209,227,33,168,178,69,211,237,228,255,217,183,112,1,161,91,237,1,83,87,100,161,173,232,247,85,27,1,1,62,2,180,141,72,139,33,136,155,152,201,72,183,76,73,202,158,111,94,51,175,228,223,126,120,1,120,101,188,8,22,93,83,91,151,210,53,56,80,151,24,43,84,37,194,5,210,177,8,79,140,134,143,124,195,249,181,151,85,170,193,41,227,209,177,143,240,152,247,240,98,247,242,42,83,101,137,90,124,45,89,119,88,29,136,21,200,21,84,194,24,67,39,146,128,148,217,120,125,10,9,105,49,166,147,15,54,30,150,178,100,141,94,213,42,68,175,103,63,69,18,84,25,243,149,241,8,7,43,122,148,208,143,213,3,147,235,26,93,10,22,64,91,114,132,126,236,206,186,22,82,166,218,161,64,2,80,193,93,77,117,182,138,122,177,241,97,239,97,35,100,146,240,28,116,121,95,26,216,176,76,159,15,41,116,208,200,21,109,96,96,90,85,217,69,224,46,130,165,187,53,32,221,102,224,201,96,187,0,103,67,90,43,64,92,236,194,170,194,1,32,161,173,35,167,86,151,123,7,121,30,206,125,179,170,30,213,171,146,93,160,160,35,188,138,146,54,252,21,185,210,212,54,74,0,173,38,167,83,164,94,206,31,119,236,164,30,6,35,132,75,2,224,124,222,73,58,103,154,228,77,68,154,112,159,131,158,23,79,0,81,250,255,81,104,35,0,44,24,237,129,237,10,182,223,11,105,134,184,220,118,240,233,209,251,26,58,75,3,139,3,84,169,153,26,131,157,201,124,137,88,228,223,18,119,250,67,173,114,36,18,253,228,46,112,165,208,103,196,225,56,29,14,250,28,215,21,37,58,230,122,79,242,252,35,243,128,41,3,231,131,156,36,161,232,142,175,254,65,58,195,35,151,45,79,217,57,142,244,123,191,150,237,111,25,81,113,121,203,146,12,241,246,23,58,117,92,54,107,209,149,152,30,231,224,109,39,174,41,136,137,239,161,163,211,222,32,78,220,44,87,175,85,207,5,4,132,43,176,52,240,196,34,71,207,155,173,44,246,122,48,12,126,244,63,96,5,104,75,66,179,68,151,69,148,61,41,46,185,209,36,11,214,239,230,176,17,6,182,20,66,235,129,254,55,81,119,41,234,4,156,227,201,164,130,82,206,99,143,246,205,8,235,192,84,158,8,5,75,91,229,68,48,98,100,103,228,95,178,94,212,140,30,75,62,181,249,23,1,182,70,136,4,202,161,103,190,210,234,172,176,216,22,10,225,167,88,53,185,238,24,81,130,25},
  {12,36,146,105,205,21,61,227,71,89,178,30,211,35,93,15,54,200,147,244,59,171,122,17,44,110,84,197,129,7,73,18,232,102,29,31,54,239,147,68,223,158,84,148,129,107,248,104,192,6,60,115,228,116,195,161,32,48,97,10,16,194,180,37,6,129,20,39,214,20,23,199,2,105,195,233,39,129,226,178,226,7,73,250,70,19,111,254,138,230,90,62,254,68,33,47,109,131,9,211,151,9,246,138,36,227,153,174,217,90,129,20,134,141,202,107,52,242,13,27,186,112,12,193,161,239,71,102,178,97,188,243,107,11,239,237,0,210,200,139,177,126,210,174,6,66,33,206,201,148,207,45,230,222,224,252,98,80,222,199,199,134,65,189,187,123,81,157,199,123,103,16,240,253,144,199,249,177,169,223,210,237,123,239,253,238,73,148,62,229,158,238,38,118,117,90,40,44,22,244,35,71,23,137,7,45,177,73,22,48,164,234,61,37,120,215,16,194,52,122,249,144,168,63,14,182,18,95,215,131,197,158,79,119,67,9,51,187,174,167,187,11,193,179,21,231,220,219,16,59,33,84,55,147,113,223,196,80,88,78,35,64,144,184,235,65,219,7,72,240,167,227,21,159,99,34,232,113,10,181,73,190,238,18,18,225,201,112,212,188,67,95,239,243,142,85,207,104,187,191,103,45,69,102,185,210,146,196,196,197,231,78,165,152,100,239,213,75,52,126,174,183,229,240,220,3,0,43,52,129,81,36,229,215,126,52,134,179,145,152,155,6,204,169,181,30,124,27,128,153,33,235,218,63,228,26,124,211,186,253,118,34,32,192,145,36,229,102,176,36,136,147,133,146,75,242,74,224,69,6,132,143,214,50,142,214,129,107,243,183,143,215,74,28,138,20,196,217,109,119,250,27,55,42,209,139,1,27,148,232,204,133,233,35,11,167,151,178,243,240,211,164,230,125,183,170,242,225,60,233,241,16,26,113,25,196,198,135,214,75,72,88,90,48,115,254,5,65,16,75,180,17,193,189,124,135,247,116,74,190,221,82,165,191,82,47,213,174,224,84,231,33,60,233,70,147,210,65,120,241,106,70,204,44,124,202,228,76,33,202,116,63,88,253,167,147,221,142,251,192,185,186,160,203,157,205,75,43,58,176,210,96,129,73,78,51,98,124,252,240,127,110,243,162,24,79,121,87,194,240,167,141,68,231,140,35,225,103,65,98,116,96,101,48,83,187,70,226,171,232,183,89,126,190,254,67,131,155,17,163,255,6,95,253,226,120,175,182,252,52,9,57,119,201,103,182,125,20,36,61,84,225,115,9,160,138,210,34,190,240,53,178,24,181,139,72,195,151,57,102,99,249,52,164,189,114,135,180,14,145,177,216,234,42,236,189,16,120,31,118,89,75,41,162,96,148,68,104,197,26,27,174,123,147,231,197,177,82,142,70,46,221,45,203,74,126,17,219,163,20,197,185,138,111,124,41,113,167,76,183,36,16,103,23,216,25,72,38,134,196,203,255,180,187,70,16,41,116,26,21,243,134,26,63,70,72,208,10,1,36,250,79,119,47,128,196,100,178,13,67,13,198,110,73,5,129,9,144,46,240,89,231,142,42,79,208,149,157,236,177,235,177,199,23,214,148,86,32,157,74,28,98,237,93,240,16,137,149,194,142,255,66,219,202,15,160,189,164,13,205,159,131,184,167,89,19,110,49,144,76,172,4,41,147,20,253,10,70,11,183,85,204,14,217,183,144,41,221,154,224,5,14,0,103,99,235,11,241,158,176,119,4,27,108,61,140,244,142,101,120,244,213,3,58,90,162,7,75,163,233,66,253,156,136,80,246,7,193,240,45,141,182,47,48,233,132,42,13,105,119,210,160,173,67,197,238,43,223,79,7,38,69,10,222,61,15,160,253,3,248,178,47,216,59,94,194,244,121,104,154,106,167,14,24,247,134,27,220,140,115,126,231,59,5,214,131,68,205,186,165,12,131,211,217,188,251,243,8,71,132,49,113,147,24,139,10,128,197,14,22,38,14,53,222,70,173,180,99,134,215,59,36,15,78,160,174,94,239,43,232,163,41,244,125,36,116,112,184,174,134,134,109,115,63,208,128,162,150,160,128,79,60,140,99,123,217,194,217,92,122,57,163,130,26,51,247,8,124,24,235,132,102,5,111,111,155,179,123,127,86,246,179,252,3,48,213,237,251,165,183,55,176,6,161,248,135,13,42,153,74,213,93,171,107,104,71,32,103,255,60,195,252,117,57,58,210,182,186,15,218,230,245,182,169,246,211,164,158,156,64,242,78,9,224,239,251,135,220,118,82,142,213,2,26,73,186,4,98,110,18,230,36,7,28,161,95,130,12,153,127,38,205,250,112,208,107,38,48,202,194,38,106,99,114,181,64,146,33,216,25,211,207,67,239,75,205,173,178,88,219,78,79,58,68,242,40,208,166,87,108,96,124,20,234,206,151,184,116,234,26,223,106,24,190,145,67,228,100,49,54,187,136,220,244,156,76,128,74,43,163,193,69,107,101,113,68,135,168,222,149,36,167,141,66,255,175,59,186,14,92,178,186,111,217,219,155,80,81,94,56,104,104,234,239,222,248,52,215,180,38,187,58,194,204,42,215,238,226,114,51,235,157,220,40,33,45,44,171,212,252,171,64,72,209,73,125,68,170,64,120,238,136,80,121,159,6,198,210,63,73,61,98,81,128,217,190,44,144,177,63,227,88,67,65,244,108,165,59,67,195,1,184,130,40,4,118,204,11,189,130,110,74,175,68,26,192,36,236,127,64,64,188,44,5,44,70,250,94,250,0,212,4,225,81,241,117,74,161,227,88,221,34,126,46,43,33,115,105,24,29,204,36,167,63,241,162,105,29,233,14,119,109,125,77,101,11,252,9,255,236,26,72,95,142,20,216,74,7,61,91,91,12,188,47,200,49,134,57,205,144,35,243,166,118,214,177,65,145,107,125,141,95,142,183,86,105,227,135,76,253,167,244,49,175,68,141,93,47,122,100,109,131,164,104,22,67,191,220,133,194,85,81,234,153,133,83,185,52,174,40,245,3,249,18,209,241,208,240,241,238,39,71,165,236,132,16,210,62,233,116,101,249,210,141,198,211,59,25,168,125,112,240,173,126,109,240,226,192,207,4,163,40,141,180,71,254,104,235,244,209,147,89,164,149,160,115,32,178,208,147,178,210,118,48,255,236,34,163,48,22,183,174,205,23,220,53,155,156,220,88,19,183,35,160,88,13,165,89,108,66,227,206,191,16,89,93,232,99,44,224,136,181,163,45,31,57,87,248,198,124,34,54,117,161,248,134,178,86,236,243,242,15,54,196,30,66,183,184,120,210,78,182,10,125,245,130,229,21,7,50,85,186,248,205,124,74,20,150,37,106,129,246,52,179,134,111,3,139,180,200,134,148,111,114,182,76,218,129,147,191,41,49,0,237,86,253,120,35,98,38,10,2,156,81,31,81,78,188,61,19,24,134,245,184,236,38,169,220,44,222,94,174,200,241,158,88,101,240,108,134,193,63,53,51,166,157,226,175,101,11,78,231,22,67,116,61,225,251,168,244,117,37,195,115,181,254,125,105,170,245,227,245,7,104,34,100,156,58,154,45,230,175,81,188,123,189,139,150,160,110,71,201,25,122,95,128,0,160,122,7,214,9,238,193,140,135,140,91,195,187,97,111,44,129,234,176,100,154,100,136,133,126,149,78,7,74,62,126,161,161,187,79,246,74,75,210,201,81,99,113,162,169,9,236,74,28,154,233,211,107,47,73,73,186,39,157,48,118,113,197,228,50,247,21,77,157,118,36,246,199,56,161,202,177,39,10,50,23,241,3,136,83,205,124,226,142,33,228,30,149,167,9,241,158,29,240,130,115,159,236,91,217,203,243,16,6,159,103,104,63,13,226,60,130,180,17,245,240,132,79,201,105,106,30,17,72,178,198,150,145,217,36,97,156,170,131,155,3,131,52,226,241,2,129,122,90,247,15,125,199,91,180,43,242,61,171,250,244,206,66,71,188,216,92,196,167,203,0,137,75,161,164,194,158,111,95,198,2,66,10,90,114,131,73,234,206,217,18,118,156,206,87,29,158,186,56,236,162,33,62,27,254,131,51,148,131,135,56,53,151,209,231,65,39,155,215,64,229,215,62,245,14,138,49,137,0,249,9,37,186,50,187,244,154,147,179,54,102,162,195,199,121,0,185,79,82,27,108,182,129,250,22,253,64,225,18,118,77,40,59,121,190,190,84,11,146,45,155,69,83,5,240,122,148,197,135},
  {57,191,241,104,30,159,67,172,76,163,101,2,212,49,179,38,141,175,7,17,199,54,102,202,253,203,134,146,222,18,118,21,59,33,15,101,123,67,233,45,224,89,195,229,112,246,28,171,170,150,146,91,143,185,104,215,207,162,136,180,64,83,233,193,121,7,199,210,77,166,25,35,40,11,144,30,22,64,9,144,245,44,12,156,124,189,9,28,17,106,56,120,179,79,199,33,150,70,61,130,8,151,81,189,190,118,221,139,142,213,52,111,162,230,7,197,238,19,85,16,232,37,204,234,34,90,141,171,125,90,52,234,141,111,167,12,155,142,104,67,30,86,29,224,83,175,239,142,77,185,12,152,240,153,232,212,245,90,18,215,246,218,83,222,106,204,142,102,203,113,143,227,53,22,209,48,88,147,51,47,11,5,16,146,21,4,182,225,174,254,234,23,24,217,112,69,20,69,15,167,191,161,34,115,50,53,67,57,251,241,220,40,143,203,5,58,30,46,99,9,18,111,51,74,163,208,157,143,245,42,197,251,219,153,203,20,222,212,231,3,196,186,208,27,230,211,126,1,191,102,255,28,41,77,194,103,28,244,213,242,3,248,134,171,206,8,248,223,107,177,251,5,249,226,31,97,224,24,244,72,67,203,89,222,6,179,225,211,111,147,228,114,50,7,207,116,91,194,184,110,166,82,22,166,106,179,89,8,229,1,150,242,175,129,61,50,172,84,90,130,46,205,21,212,242,202,111,88,210,169,142,226,173,168,210,70,228,228,196,116,45,223,220,18,52,79,110,63,92,65,108,202,85,139,226,39,59,17,236,43,207,1,237,123,9,142,219,8,63,45,141,205,133,218,217,47,202,230,4,98,65,248,67,121,88,183,20,94,107,115,238,60,153,163,71,118,225,208,7,46,119,249,195,49,68,194,56,87,11,44,83,110,170,35,239,205,31,106,1,193,117,4,190,218,217,193,177,52,38,5,82,146,18,238,216,210,194,196,177,144,92,19,201,101,161,132,81,39,155,249,236,168,58,92,160,87,89,169,232,153,29,142,242,151,22,53,58,67,161,60,98,110,253,198,230,134,237,174,141,138,152,123,168,117,0,109,140,176,63,111,99,98,49,38,103,27,102,16,185,139,36,123,108,67,217,62,109,112,106,101,180,148,234,228,187,164,88,89,15,191,192,229,236,190,20,184,47,219,123,251,90,167,240,221,227,2,241,209,73,109,83,172,146,236,203,5,196,215,186,69,10,7,12,246,157,127,203,194,88,167,120,97,145,201,193,235,40,154,105,107,244,87,217,43,52,87,9,187,32,89,101,47,153,72,46,94,50,206,156,156,250,220,13,29,59,196,125,152,199,184,113,66,46,172,189,57,172,106,104,163,142,37,240,112,4,54,195,147,30,173,118,208,126,149,100,143,204,74,119,26,187,102,171,191,4,144,142,28,133,234,212,239,51,101,253,167,221,89,61,156,30,16,125,145,25,253,223,183,148,27,76,88,30,246,225,146,212,214,86,154,228,78,13,190,147,29,94,183,44,75,131,110,79,86,200,192,175,170,202,113,95,223,132,4,15,194,94,254,4,138,209,196,185,75,157,193,189,67,65,128,34,158,122,226,87,147,37,165,79,37,178,187,161,96,94,145,106,160,127,125,4,66,152,37,195,213,176,48,210,37,68,93,76,156,78,42,156,230,78,154,202,80,102,105,22,176,255,12,82,170,21,119,148,200,1,203,237,149,21,80,51,8,74,241,182,88,123,117,119,115,177,174,199,238,87,135,42,185,191,223,93,72,134,235,98,150,130,111,36,131,10,18,23,26,184,213,182,187,53,38,10,173,49,62,154,193,5,63,12,83,49,96,199,40,73,191,82,40,192,34,175,173,22,200,241,58,173,135,56,114,246,46,182,225,140,119,79,101,235,80,81,245,150,12,202,174,83,254,127,179,66,142,46,40,116,97,245,89,119,189,106,168,95,153,243,155,182,101,22,162,60,94,21,139,199,207,11,193,88,251,20,223,85,127,231,185,120,214,178,193,76,36,36,13,16,93,106,13,43,94,16,47,173,103,252,250,99,50,75,126,54,123,2,138,170,118,33,44,84,209,36,51,250,128,63,89,80,199,204,205,175,42,66,27,45,202,186,78,217,14,42,110,163,145,250,132,212,102,143,176,253,215,6,55,147,91,22,92,180,174,112,176,115,25,224,39,97,211,88,68,75,155,143,22,192,144,119,14,55,52,104,236,96,206,252,134,242,205,5,249,31,97,135,160,245,36,115,11,175,150,13,212,41,47,246,10,16,164,194,213,189,32,11,106,65,172,44,172,53,131,140,32,16,249,185,58,143,35,174,213,212,238,19,198,157,117,17,101,163,42,224,1,188,35,163,217,121,239,228,73,186,87,138,120,192,44,108,43,73,60,191,167,143,105,107,69,44,6,246,99,53,159,184,204,34,80,194,109,248,101,113,50,225,86,44,39,40,140,88,81,64,73,33,33,86,5,14,131,115,184,124,137,49,201,108,11,32,27,191,52,162,15,143,143,146,240,30,227,59,136,29,241,114,185,26,52,78,159,85,217,39,232,69,190,19,140,235,89,174,254,198,40,98,247,249,23,43,120,236,219,6,22,137,114,49,237,45,185,11,241,164,141,144,138,84,152,233,18,106,254,181,243,249,233,19,64,148,243,190,39,18,205,208,196,162,112,147,31,152,55,124,247,56,177,136,105,200,167,242,224,250,57,238,213,195,6,235,53,92,200,120,139,240,99,251,198,71,37,60,56,119,27,113,20,230,167,56,58,185,70,238,181,146,51,55,14,150,129,116,105,124,12,215,72,99,55,127,191,151,229,184,143,90,184,143,175,15,114,255,159,5,240,232,196,187,124,7,221,195,237,67,177,6,215,166,5,3,0,190,200,102,174,137,88,215,174,206,194,64,176,157,16,67,195,82,91,122,26,231,42,159,65,159,193,52,245,185,136,39,125,188,3,133,89,182,23,0,95,149,181,71,51,91,86,132,81,127,134,85,218,40,4,254,211,92,2,22,173,18,25,83,122,228,199,253,179,226,152,151,254,251,180,139,43,245,42,138,247,205,139,18,60,168,93,6,145,209,77,66,174,202,219,72,248,21,95,227,158,61,167,188,78,126,137,2,73,252,126,145,249,42,166,209,252,238,154,20,114,254,68,28,22,169,206,146,201,225,151,98,111,236,167,97,52,127,103,141,61,119,203,195,94,211,191,147,144,34,58,163,244,128,166,115,130,83,38,121,78,239,144,145,121,237,66,254,153,176,44,23,163,239,113,98,178,35,200,84,227,204,3,202,89,10,34,130,125,167,212,55,143,80,24,250,138,216,147,97,207,101,120,34,56,8,97,26,146,241,177,83,138,57,62,146,134,140,104,2,61,184,240,9,166,10,217,230,7,101,97,64,171,117,227,204,144,224,38,141,17,241,154,133,107,134,86,153,95,192,78,201,83,71,177,88,100,21,98,164,117,237,47,214,106,18,90,153,252,31,79,62,196,99,7,226,209,178,236,182,101,13,81,209,241,97,91,149,151,123,71,192,217,244,79,245,152,181,158,245,28,151,173,184,237,160,69,158,0,15,179,155,140,66,119,183,221,64,199,114,41,234,33,62,48,104,87,1,194,57,118,84,59,14,65,186,112,149,17,251,83,169,178,67,147,253,102,245,85,21,190,26,197,26,22,34,66,112,36,248,240,183,110,204,160,173,101,26,228,238,92,136,173,93,206,74,213,76,95,159,212,114,28,100,133,92,71,126,45,229,38,184,48,4,13,248,139,71,22,21,39,234,71,171,45,16,76,182,13,58,181,2,254,231,15,246,59,147,147,49,43,97,13,248,89,109,192,126,119,126,221,71,153,161,101,62,71,200,122,169,204,47,8,137,150,19,131,246,136,41,78,47,210,116,162,109,153,173,160,73,120,24,143,147,86,205,162,61,175,7,160,205,238,181,241,84,60,5,107,231,115,116,2,182,202,67,183,9,181,247,133,15,234,10,90,232,66,11,249,182,29,220,75,235,188,70,51,140,73,157,50,68,109,180,125,233,249,197,180,136,180,6,26,244,112,105,44,240,171,143,6,195,191,113,119,243,62,215,188,45,154,112,203,181,166,105,185,52,159,117,178,150,32,255,11,7,254,157,180,199,34,67,148,220,113,22,214,216,13,174,77,61,104,39,13,213,199,201,81,42,178,243,173,252,242,122,225,65,227,255,149,114,32,68,130,106,48,65,244,71,57,56,208,235,141,103,189,45,198,81,187,212,244,67,79,11,66,63,13},
  {165,249,155,179,196,223,170,100,54,165,67,214,229,205,163,237,29,228,39,94,10,197,231,231,155,104,19,233,4,253,72,11,118,160,172,22,95,214,193,102,11,2,125,138,69,88,152,60,90,186,108,76,153,40,24,38,17,77,244,174,252,164,219,229,5,60,25,193,12,142,98,13,75,128,24,27,209,250,113,223,169,210,36,87,239,43,76,98,199,125,52,100,68,242,221,56,215,71,53,76,6,4,50,105,133,7,117,202,85,24,117,61,147,198,22,20,26,129,210,123,200,16,78,243,224,97,56,156,19,245,242,98,186,228,196,184,184,250,83,248,124,176,118,8,205,50,53,34,217,86,51,42,26,186,201,113,10,3,179,202,171,27,132,248,37,234,133,102,193,94,50,130,119,100,234,53,77,79,54,117,151,39,48,208,247,1,60,26,54,47,99,64,184,84,240,211,52,216,28,4,164,230,253,91,219,191,38,45,129,134,91,190,218,18,104,84,7,234,226,70,159,136,76,122,94,245,141,226,250,19,149,224,72,101,152,7,118,239,118,29,111,43,38,84,53,81,250,215,244,100,66,153,139,10,34,181,112,110,60,34,3,228,161,101,29,177,137,188,190,161,122,88,146,57,148,68,118,240,83,63,197,7,88,155,179,3,135,36,171,169,102,7,213,192,17,47,179,248,74,57,0,241,223,172,227,235,36,123,194,135,241,162,207,230,145,212,97,234,7,63,190,136,154,234,40,24,36,16,94,139,208,199,204,7,183,213,236,36,78,137,181,129,136,179,18,80,170,115,119,219,162,182,120,243,28,85,19,180,50,10,245,5,22,42,227,203,175,167,32,178,182,189,214,225,164,245,216,73,101,217,54,14,166,47,252,162,154,144,49,23,85,89,163,22,208,243,49,105,30,253,226,28,82,161,67,227,73,64,127,6,255,3,119,233,14,161,56,153,124,105,43,208,13,169,178,178,248,70,149,82,113,133,1,104,212,23,177,233,128,109,97,176,176,152,21,205,129,88,248,246,165,109,15,46,117,112,108,205,140,25,252,42,241,116,237,208,223,253,60,36,16,74,75,30,19,228,74,158,10,39,5,136,156,229,154,191,63,125,50,196,248,249,33,168,149,242,210,183,58,162,238,88,253,44,253,151,254,112,172,134,141,62,31,228,111,33,0,29,81,81,56,207,60,162,110,215,81,11,57,82,193,244,115,32,159,136,201,12,6,14,111,248,170,231,123,161,229,246,21,42,70,98,20,172,227,118,53,238,15,226,193,27,184,1,110,147,12,143,252,105,42,45,62,80,195,229,92,20,2,221,249,225,196,16,148,204,94,13,73,74,14,249,182,110,31,73,246,97,39,123,60,113,34,254,246,196,183,122,252,151,159,68,237,41,223,108,223,47,67,165,148,97,131,132,219,214,216,125,255,116,207,171,108,80,99,150,161,181,196,136,22,153,23,178,60,238,118,210,241,39,181,106,49,60,127,104,153,114,10,91,76,75,77,27,168,53,130,195,230,156,31,178,247,131,26,39,176,77,131,155,43,124,175,103,50,88,63,209,209,117,84,152,65,119,224,175,219,55,170,41,161,132,24,53,10,0,0,111,239,235,201,193,227,67,194,44,187,4,53,192,155,254,177,144,242,1,6,146,6,152,245,94,88,89,15,47,111,220,196,47,196,216,82,193,201,150,184,59,73,121,151,8,27,15,7,12,10,18,240,136,200,184,197,181,176,123,19,27,111,66,167,176,202,194,6,91,240,103,59,231,77,15,2,153,123,129,52,206,246,145,188,88,58,136,152,107,14,56,151,179,64,230,109,28,152,152,127,139,11,7,251,148,16,135,127,92,235,169,170,64,89,4,136,72,220,87,99,70,33,77,143,10,207,127,222,194,194,173,39,18,201,233,91,70,121,3,163,18,0,104,163,61,62,146,121,126,35,186,123,157,211,58,91,4,188,4,228,183,97,146,23,211,178,195,151,107,105,134,56,178,195,72,243,227,114,191,179,129,23,233,247,223,70,97,149,223,149,224,221,27,68,219,243,55,70,26,71,234,233,205,95,154,102,154,15,153,234,236,62,193,128,83,92,136,8,200,89,224,232,197,249,32,156,153,151,66,214,90,187,179,126,128,207,241,4,190,212,171,233,70,11,235,237,199,43,202,79,77,2,99,235,127,121,218,67,250,151,41,62,167,53,112,5,193,196,175,44,131,82,177,145,167,207,212,5,115,158,37,121,21,86,97,21,85,16,96,247,111,50,49,54,57,129,243,145,32,204,76,232,116,217,75,127,246,56,16,151,135,36,157,245,46,74,161,183,51,104,30,126,41,162,94,217,121,39,124,224,64,119,89,231,75,101,86,116,83,94,138,150,131,114,205,101,176,176,232,155,229,32,203,109,187,122,140,20,100,9,141,143,164,246,91,12,98,46,238,189,28,30,76,11,243,248,46,180,12,173,69,121,241,142,36,221,105,66,157,4,124,21,96,229,123,225,9,5,214,210,137,20,106,196,195,49,160,253,7,133,235,62,101,7,5,67,170,245,165,5,101,59,192,247,42,37,106,165,89,162,48,185,252,51,205,159,181,42,49,81,69,146,159,126,96,112,77,220,140,187,252,227,176,92,139,72,138,53,247,145,201,46,158,244,37,32,175,17,128,8,30,54,248,67,42,37,247,230,158,195,111,130,90,251,91,43,17,18,101,84,34,97,102,156,200,242,230,82,8,229,234,140,49,223,13,164,29,7,206,83,12,6,224,188,66,191,226,242,155,94,92,117,232,249,73,99,196,64,189,17,115,143,169,23,93,118,32,184,55,135,67,25,50,111,141,253,221,127,83,177,195,219,67,51,92,214,16,103,69,120,153,228,242,177,84,206,40,1,132,19,243,221,202,244,200,149,191,231,107,71,194,90,171,242,163,208,216,122,75,227,159,177,54,184,186,158,76,3,59,215,238,114,171,227,149,174,129,212,67,246,54,135,234,16,190,69,40,212,9,33,177,251,69,67,11,71,211,132,3,181,30,143,219,184,32,76,122,54,172,94,151,152,197,192,27,11,91,117,138,84,206,144,251,251,232,68,30,203,82,216,60,124,145,198,115,40,62,214,158,184,39,116,205,151,117,91,45,81,255,26,80,220,148,26,181,78,133,203,54,239,237,88,164,9,33,98,97,167,113,52,13,17,32,78,222,43,175,10,230,239,20,18,191,99,136,72,212,95,220,230,222,130,238,230,213,65,177,208,32,139,147,191,17,119,181,250,44,59,75,209,147,138,232,252,218,107,177,43,81,10,89,79,245,65,163,132,225,103,119,93,27,248,6,112,94,19,36,196,167,97,68,243,254,100,243,102,93,237,10,227,69,76,157,82,222,11,24,246,49,44,23,201,139,75,56,185,112,88,100,247,49,55,19,205,13,137,35,240,17,39,166,60,181,52,59,218,159,97,131,15,200,133,105,206,227,145,41,26,240,114,165,98,174,231,27,230,99,183,230,201,100,33,86,61,175,146,40,130,84,175,134,103,165,204,57,246,214,101,195,129,39,114,252,216,63,84,48,113,254,149,57,200,130,92,170,60,113,72,30,252,78,198,253,14,248,230,23,59,127,249,134,75,174,23,123,219,93,197,103,55,236,240,96,171,1,138,176,231,21,102,184,173,207,113,38,117,204,54,190,88,154,25,14,116,220,164,165,118,69,25,187,158,128,185,250,22,175,144,230,180,91,6,136,89,212,77,60,92,240,67,239,81,57,143,24,101,233,143,151,238,199,184,24,178,49,174,212,245,63,191,190,147,229,82,129,113,34,164,152,91,43,123,182,230,174,182,180,164,137,154,59,28,147,89,238,98,140,141,161,184,163,178,206,129,235,172,153,222,107,183,118,71,29,100,100,8,80,30,13,190,212,244,168,197,40,145,155,184,218,41,80,90,143,172,188,77,176,216,162,248,134,10,65,62,132,152,50,229,251,154,96,178,169,1,67,157,14,158,61,42,148,157,55,201,70,16,15,91,155,172,159,84,241,151,200,63,232,226,130,71,225,137,1,145,25,103,168,119,48,5,10,109,198,115,6,255,173,177,102,47,139,52,216,127,51,247,192,240,138,130,73,107,245,126,14,242,70,92,152,161,77,130,45,77,59,228,153,157,159,100,61,250,108,96,252,20,19,137,80,70,106,111,19,162,185,54,205,241,12,192,244,141,103,221,250,80,255,139,133,207,102,147,116,69,75,79,160,80,211,24,166,225,111,192,46,108,222,73,26,119,21,147,112,194,191,23,199,144,75,219,107,243,191,66,6,86,202,249,89},
} ;

static void test_decode_953xint16_impl(long long impl)
{
  unsigned char *x = test_decode_953xint16_x;
  unsigned char *s = test_decode_953xint16_s;
  unsigned char *x2 = test_decode_953xint16_x2;
  unsigned char *s2 = test_decode_953xint16_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_953xint16_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_953xint16(impl);
    printf("decode_953xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_953xint16_implementation(impl),ntruprime_dispatch_decode_953xint16_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_953xint16;
    printf("decode_953xint16 selected implementation %s compiler %s\n",ntruprime_decode_953xint16_implementation(),ntruprime_decode_953xint16_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_953xint16_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_953xint16_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_953xint16_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_953xint16_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_953xint16_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_953xint16_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_953xint16(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"953xint16")) return;
  storage_decode_953xint16_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_953xint16_x = aligned(storage_decode_953xint16_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_953xint16_s = callocplus(crypto_decode_STRBYTES);
  test_decode_953xint16_s = aligned(storage_decode_953xint16_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_953xint16_x2 = callocplus(maxalloc);
  test_decode_953xint16_x2 = aligned(storage_decode_953xint16_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_953xint16_s2 = callocplus(maxalloc);
  test_decode_953xint16_s2 = aligned(storage_decode_953xint16_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_953xint16 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_953xint16();++impl)
      forked(test_decode_953xint16_impl,impl);
    ++test_decode_953xint16_x;
    ++test_decode_953xint16_s;
    ++test_decode_953xint16_x2;
    ++test_decode_953xint16_s2;
  }
  free(storage_decode_953xint16_s2);
  free(storage_decode_953xint16_x2);
  free(storage_decode_953xint16_s);
  free(storage_decode_953xint16_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

