/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "hud.h"

#include <QDebug>

using namespace Ubuntu::HUD;

class QML::HUD::HUD::Private : public QObject
{
    Q_OBJECT

public:
    QString applicationIdentifier;
};

QML::HUD::HUD(QObject *parent)
    : Ubuntu::HUD::HUD(parent)
{
    d = new Private();
}

QML::HUD::~HUD()
{
    delete d;
}

QQmlListProperty<QML::Context>
QML::HUD::contexts_list()
{
    return QQmlListProperty<QML::Context>(this,
                                          0,
                                          QML::HUD::append,
                                          QML::HUD::count,
                                          QML::HUD::at,
                                          QML::HUD::clear);
}

void
QML::HUD::append(QQmlListProperty<QML::Context> *list, QML::Context *context)
{
    QML::HUD *hud = qobject_cast<QML::HUD *>(list->object);
    if (hud)
        hud->addContext(context);
}

QML::Context *
QML::HUD::at(QQmlListProperty<QML::Context> *list, int index)
{
    QML::HUD *hud = qobject_cast<QML::HUD *>(list->object);
    if (hud)
        return qobject_cast<QML::Context *>(hud->contexts().at(index));

    Q_ASSERT(0); // should not be reached
    return 0;
}

void
QML::HUD::clear(QQmlListProperty<QML::Context> *list)
{
    QML::HUD *hud = qobject_cast<QML::HUD *>(list->object);
    if (hud) {
    QList< ::Context *> contexts = hud->contexts();
    foreach(::Context *context, contexts)
        hud->removeContext(context);
    }
}

int
QML::HUD::count(QQmlListProperty<QML::Context> *list)
{
    QML::HUD *hud = qobject_cast<QML::HUD *>(list->object);
    if (hud)
        return hud->contexts().count();
    Q_ASSERT(0); // should not be reached
    return 0;
}

QString
QML::HUD::applicationIdentifier() const
{
    return d->applicationIdentifier;
}

void
QML::HUD::setApplicationIdentifier(const QString &identifier)
{
    if (d->applicationIdentifier == identifier)
        return;

    if (!d->applicationIdentifier.isEmpty()) {
        qWarning("Application Identifier can be set only once!");
        return;
    }

    d->applicationIdentifier = identifier;
    emit applicationIdentifierChanged(identifier);

     _register(identifier);
}

#include "hud.moc"
