/* testbinreader.c generated by valac 0.16.1, the Vala compiler
 * generated from testbinreader.vala, do not modify */

/* 
 * File Name: 
 * Creation Date: 
 * Last Modified: 
 *
 * Authored by Frederik 'playya' Sdun <Frederik.Sdun@googlemail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <fsobasics.h>


#define TYPE_UINT8_TEST_DATA (uint8_test_data_get_type ())
typedef struct _uint8TestData uint8TestData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_UINT16_TEST_DATA (uint16_test_data_get_type ())
typedef struct _uint16TestData uint16TestData;

#define TYPE_UINT32_TEST_DATA (uint32_test_data_get_type ())
typedef struct _uint32TestData uint32TestData;

#define TYPE_STRING_TEST_DATA (string_test_data_get_type ())
typedef struct _stringTestData stringTestData;

#define TYPE_DATA_TEST_DATA (data_test_data_get_type ())
typedef struct _dataTestData dataTestData;

#define TYPE_BITFIELDS_TEST_DATA (bitfields_test_data_get_type ())
typedef struct _bitfieldsTestData bitfieldsTestData;

struct _uint8TestData {
	guint8* data;
	gint data_length1;
	gint _data_size_;
	guint8 expected;
	gint alignment;
	gint offset;
	gboolean expect_exception;
	GDataStreamByteOrder endianess;
	gchar* name;
};

struct _uint16TestData {
	guint8* data;
	gint data_length1;
	gint _data_size_;
	guint16 expected;
	gint alignment;
	gint offset;
	gboolean expect_exception;
	GDataStreamByteOrder endianess;
	gchar* name;
};

struct _uint32TestData {
	guint8* data;
	gint data_length1;
	gint _data_size_;
	guint32 expected;
	gint alignment;
	gint offset;
	gboolean expect_exception;
	GDataStreamByteOrder endianess;
	gchar* name;
};

struct _stringTestData {
	guint8* data;
	gint data_length1;
	gint _data_size_;
	gint alignment;
	gchar* expected;
	gboolean expect_exception;
	gchar* name;
	gint offset;
	gint length;
};

struct _dataTestData {
	guint8* data;
	gint data_length1;
	gint _data_size_;
	gint alignment;
	guint8* expected;
	gint expected_length1;
	gint _expected_size_;
	gboolean expect_exception;
	gchar* name;
	gint offset;
	gint length;
};

struct _bitfieldsTestData {
	guint8* data;
	gint data_length1;
	gint _data_size_;
	gint alignment;
	GDataStreamByteOrder endianess;
	guint64 expected;
	gboolean expect_exception;
	gint position;
	gint offset;
	gint length;
	gchar* name;
};



GType uint8_test_data_get_type (void) G_GNUC_CONST;
uint8TestData* uint8_test_data_dup (const uint8TestData* self);
void uint8_test_data_free (uint8TestData* self);
void uint8_test_data_copy (const uint8TestData* self, uint8TestData* dest);
void uint8_test_data_destroy (uint8TestData* self);
void uint8_test_data_init (uint8TestData *self, guint8* d, int d_length1, guint8 exp, gint align, gint off, gboolean exceptions, GDataStreamByteOrder e, const gchar* n);
static guint8* _vala_array_dup1 (guint8* self, int length);
static guint8* _vala_array_dup2 (guint8* self, int length);
void test_uint8 (uint8TestData* datas, int datas_length1);
void named_assert_uint8 (const gchar* name, guint8 expected, guint8 _result_);
void test_uint8_le (void);
static void _vala_uint8TestData_array_free (uint8TestData* array, gint array_length);
void test_uint8_be (void);
void test_exception_uint8 (void);
GType uint16_test_data_get_type (void) G_GNUC_CONST;
uint16TestData* uint16_test_data_dup (const uint16TestData* self);
void uint16_test_data_free (uint16TestData* self);
void uint16_test_data_copy (const uint16TestData* self, uint16TestData* dest);
void uint16_test_data_destroy (uint16TestData* self);
void uint16_test_data_init (uint16TestData *self, guint8* d, int d_length1, guint16 exp, gint align, gint off, gboolean exceptions, GDataStreamByteOrder e, const gchar* n);
static guint8* _vala_array_dup3 (guint8* self, int length);
static guint8* _vala_array_dup4 (guint8* self, int length);
void test_uint16 (uint16TestData* datas, int datas_length1);
void named_assert_uint16 (const gchar* name, guint16 expected, guint16 _result_);
void test_uint16_le (void);
static void _vala_uint16TestData_array_free (uint16TestData* array, gint array_length);
void test_uint16_be (void);
void test_exception_uint16 (void);
GType uint32_test_data_get_type (void) G_GNUC_CONST;
uint32TestData* uint32_test_data_dup (const uint32TestData* self);
void uint32_test_data_free (uint32TestData* self);
void uint32_test_data_copy (const uint32TestData* self, uint32TestData* dest);
void uint32_test_data_destroy (uint32TestData* self);
void uint32_test_data_init (uint32TestData *self, guint8* d, int d_length1, guint32 exp, gint align, gint off, gboolean exceptions, GDataStreamByteOrder e, const gchar* n);
static guint8* _vala_array_dup5 (guint8* self, int length);
static guint8* _vala_array_dup6 (guint8* self, int length);
void test_uint32 (uint32TestData* datas, int datas_length1);
void named_assert_uint32 (const gchar* name, guint32 expected, guint32 _result_);
void test_uint32_be (void);
static void _vala_uint32TestData_array_free (uint32TestData* array, gint array_length);
void test_uint32_le (void);
void test_exception_uint32 (void);
GType string_test_data_get_type (void) G_GNUC_CONST;
stringTestData* string_test_data_dup (const stringTestData* self);
void string_test_data_free (stringTestData* self);
void string_test_data_copy (const stringTestData* self, stringTestData* dest);
void string_test_data_destroy (stringTestData* self);
void string_test_data_init (stringTestData *self, guint8* d, int d_length1, gint a, const gchar* e, gboolean exc, const gchar* n, gint o, gint l);
static guint8* _vala_array_dup7 (guint8* self, int length);
static guint8* _vala_array_dup8 (guint8* self, int length);
void named_assert_string (const gchar* name, const gchar* expected, const gchar* _result_);
void test_string (stringTestData* datas, int datas_length1);
void test_strings (void);
static void _vala_stringTestData_array_free (stringTestData* array, gint array_length);
GType data_test_data_get_type (void) G_GNUC_CONST;
dataTestData* data_test_data_dup (const dataTestData* self);
void data_test_data_free (dataTestData* self);
void data_test_data_copy (const dataTestData* self, dataTestData* dest);
void data_test_data_destroy (dataTestData* self);
void data_test_data_init (dataTestData *self, guint8* d, int d_length1, gint a, guint8* e, int e_length1, gboolean exc, const gchar* n, gint o, gint l);
static guint8* _vala_array_dup9 (guint8* self, int length);
static guint8* _vala_array_dup10 (guint8* self, int length);
static guint8* _vala_array_dup11 (guint8* self, int length);
static guint8* _vala_array_dup12 (guint8* self, int length);
void named_assert_data (const gchar* name, guint8* expected, int expected_length1, guint8* _result_, int _result__length1);
gboolean uint8_array_equal (guint8* a, int a_length1, guint8* b, int b_length1);
gchar* uint8_array_to_string (guint8* data, int data_length1);
void test_data (dataTestData* datas, int datas_length1);
void test_datas (void);
static void _vala_dataTestData_array_free (dataTestData* array, gint array_length);
GType bitfields_test_data_get_type (void) G_GNUC_CONST;
bitfieldsTestData* bitfields_test_data_dup (const bitfieldsTestData* self);
void bitfields_test_data_free (bitfieldsTestData* self);
void bitfields_test_data_copy (const bitfieldsTestData* self, bitfieldsTestData* dest);
void bitfields_test_data_destroy (bitfieldsTestData* self);
static void bitfields_test_data_init (bitfieldsTestData *self, guint8* d, int d_length1, gint a, GDataStreamByteOrder e, guint64 exp, gboolean excp, gint pos, gint off, gint l, const gchar* n);
static guint8* _vala_array_dup13 (guint8* self, int length);
static guint8* _vala_array_dup14 (guint8* self, int length);
void run_test_bitfields (bitfieldsTestData* datas, int datas_length1);
void named_assert_uint64 (const gchar* name, guint64 _result_, guint64 expected);
void test_bitfields (void);
static void _vala_bitfieldsTestData_array_free (bitfieldsTestData* array, gint array_length);
void _vala_main (gchar** args, int args_length1);
static void _test_strings_gcallback (void);
static void _test_datas_gcallback (void);
static void _test_uint8_le_gcallback (void);
static void _test_uint16_le_gcallback (void);
static void _test_uint32_le_gcallback (void);
static void _test_uint8_be_gcallback (void);
static void _test_uint16_be_gcallback (void);
static void _test_uint32_be_gcallback (void);
static void _test_exception_uint8_gcallback (void);
static void _test_exception_uint16_gcallback (void);
static void _test_exception_uint32_gcallback (void);
static void _test_bitfields_gcallback (void);


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void uint8_test_data_init (uint8TestData *self, guint8* d, int d_length1, guint8 exp, gint align, gint off, gboolean exceptions, GDataStreamByteOrder e, const gchar* n) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8 _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	GDataStreamByteOrder _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (n != NULL);
	memset (self, 0, sizeof (uint8TestData));
	_tmp0_ = d;
	_tmp0__length1 = d_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	(*self).data = (g_free ((*self).data), NULL);
	(*self).data = _tmp1_;
	(*self).data_length1 = _tmp1__length1;
	(*self)._data_size_ = (*self).data_length1;
	_tmp2_ = exp;
	(*self).expected = _tmp2_;
	_tmp3_ = align;
	(*self).alignment = _tmp3_;
	_tmp4_ = off;
	(*self).offset = _tmp4_;
	_tmp5_ = exceptions;
	(*self).expect_exception = _tmp5_;
	_tmp6_ = e;
	(*self).endianess = _tmp6_;
	_tmp7_ = n;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 ((*self).name);
	(*self).name = _tmp8_;
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void uint8_test_data_copy (const uint8TestData* self, uint8TestData* dest) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8 _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	GDataStreamByteOrder _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	_tmp0_ = (*self).data;
	_tmp0__length1 = (*self).data_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup2 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	(*dest).data = (g_free ((*dest).data), NULL);
	(*dest).data = _tmp1_;
	(*dest).data_length1 = _tmp1__length1;
	(*dest)._data_size_ = (*dest).data_length1;
	_tmp2_ = (*self).expected;
	(*dest).expected = _tmp2_;
	_tmp3_ = (*self).alignment;
	(*dest).alignment = _tmp3_;
	_tmp4_ = (*self).offset;
	(*dest).offset = _tmp4_;
	_tmp5_ = (*self).expect_exception;
	(*dest).expect_exception = _tmp5_;
	_tmp6_ = (*self).endianess;
	(*dest).endianess = _tmp6_;
	_tmp7_ = (*self).name;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp8_;
}


void uint8_test_data_destroy (uint8TestData* self) {
	(*self).data = (g_free ((*self).data), NULL);
	_g_free0 ((*self).name);
}


uint8TestData* uint8_test_data_dup (const uint8TestData* self) {
	uint8TestData* dup;
	dup = g_new0 (uint8TestData, 1);
	uint8_test_data_copy (self, dup);
	return dup;
}


void uint8_test_data_free (uint8TestData* self) {
	uint8_test_data_destroy (self);
	g_free (self);
}


GType uint8_test_data_get_type (void) {
	static volatile gsize uint8_test_data_type_id__volatile = 0;
	if (g_once_init_enter (&uint8_test_data_type_id__volatile)) {
		GType uint8_test_data_type_id;
		uint8_test_data_type_id = g_boxed_type_register_static ("uint8TestData", (GBoxedCopyFunc) uint8_test_data_dup, (GBoxedFreeFunc) uint8_test_data_free);
		g_once_init_leave (&uint8_test_data_type_id__volatile, uint8_test_data_type_id);
	}
	return uint8_test_data_type_id__volatile;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void test_uint8 (uint8TestData* datas, int datas_length1) {
	uint8TestData* _tmp0_;
	gint _tmp0__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = datas;
	_tmp0__length1 = datas_length1;
	{
		uint8TestData* data_collection = NULL;
		gint data_collection_length1 = 0;
		gint _data_collection_size_ = 0;
		gint data_it = 0;
		data_collection = _tmp0_;
		data_collection_length1 = _tmp0__length1;
		for (data_it = 0; data_it < _tmp0__length1; data_it = data_it + 1) {
			uint8TestData _tmp1_ = {0};
			uint8TestData data = {0};
			uint8_test_data_copy (&data_collection[data_it], &_tmp1_);
			data = _tmp1_;
			{
				guint8 _result_;
				uint8TestData _tmp2_;
				guint8* _tmp3_;
				gint _tmp3__length1;
				uint8TestData _tmp4_;
				gint _tmp5_;
				uint8TestData _tmp6_;
				GDataStreamByteOrder _tmp7_;
				FsoFrameworkBinReader* _tmp8_;
				FsoFrameworkBinReader* reader;
				gboolean caught;
				uint8TestData _tmp24_;
				gboolean _tmp25_;
				_result_ = (guint8) 0;
				_tmp2_ = data;
				_tmp3_ = _tmp2_.data;
				_tmp3__length1 = _tmp2_.data_length1;
				_tmp4_ = data;
				_tmp5_ = _tmp4_.alignment;
				_tmp6_ = data;
				_tmp7_ = _tmp6_.endianess;
				_tmp8_ = fso_framework_bin_reader_new (_tmp3_, _tmp3__length1, _tmp5_, _tmp7_);
				reader = _tmp8_;
				caught = FALSE;
				{
					FsoFrameworkBinReader* _tmp9_;
					uint8TestData _tmp10_;
					gint _tmp11_;
					guint8 _tmp12_ = 0U;
					guint8 _tmp13_;
					_tmp9_ = reader;
					_tmp10_ = data;
					_tmp11_ = _tmp10_.offset;
					_tmp12_ = fso_framework_bin_reader_get_uint8 (_tmp9_, _tmp11_, &_inner_error_);
					_tmp13_ = _tmp12_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
							goto __catch0_fso_framework_bin_reader_error;
						}
						_g_object_unref0 (reader);
						uint8_test_data_destroy (&data);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_result_ = _tmp13_;
				}
				goto __finally0;
				__catch0_fso_framework_bin_reader_error:
				{
					GError* e = NULL;
					uint8TestData _tmp14_;
					gboolean _tmp15_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp14_ = data;
					_tmp15_ = _tmp14_.expect_exception;
					if (!_tmp15_) {
						uint8TestData _tmp16_;
						const gchar* _tmp17_;
						const gchar* _tmp18_ = NULL;
						GError* _tmp19_;
						const gchar* _tmp20_;
						const gchar* _tmp21_ = NULL;
						gchar* _tmp22_ = NULL;
						gchar* _tmp23_;
						_tmp16_ = data;
						_tmp17_ = _tmp16_.name;
						_tmp18_ = string_to_string (_tmp17_);
						_tmp19_ = e;
						_tmp20_ = _tmp19_->message;
						_tmp21_ = string_to_string (_tmp20_);
						_tmp22_ = g_strconcat ("[", _tmp18_, "] doesn't expect an exception: ", _tmp21_, NULL);
						_tmp23_ = _tmp22_;
						g_error ("testbinreader.vala:60: %s", _tmp23_);
						_g_free0 (_tmp23_);
					}
					caught = TRUE;
					_g_error_free0 (e);
				}
				__finally0:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (reader);
					uint8_test_data_destroy (&data);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp24_ = data;
				_tmp25_ = _tmp24_.expect_exception;
				if (!_tmp25_) {
					uint8TestData _tmp26_;
					const gchar* _tmp27_;
					guint8 _tmp28_;
					uint8TestData _tmp29_;
					guint8 _tmp30_;
					_tmp26_ = data;
					_tmp27_ = _tmp26_.name;
					_tmp28_ = _result_;
					_tmp29_ = data;
					_tmp30_ = _tmp29_.expected;
					named_assert_uint8 (_tmp27_, _tmp28_, _tmp30_);
				} else {
					gboolean _tmp31_ = FALSE;
					uint8TestData _tmp32_;
					gboolean _tmp33_;
					gboolean _tmp35_;
					_tmp32_ = data;
					_tmp33_ = _tmp32_.expect_exception;
					if (!_tmp33_) {
						gboolean _tmp34_;
						_tmp34_ = caught;
						_tmp31_ = !_tmp34_;
					} else {
						_tmp31_ = FALSE;
					}
					_tmp35_ = _tmp31_;
					if (_tmp35_) {
						uint8TestData _tmp36_;
						const gchar* _tmp37_;
						const gchar* _tmp38_ = NULL;
						gchar* _tmp39_ = NULL;
						gchar* _tmp40_;
						_tmp36_ = data;
						_tmp37_ = _tmp36_.name;
						_tmp38_ = string_to_string (_tmp37_);
						_tmp39_ = g_strconcat ("[", _tmp38_, "] expected exception", NULL);
						_tmp40_ = _tmp39_;
						g_error ("testbinreader.vala:66: %s", _tmp40_);
						_g_free0 (_tmp40_);
					}
				}
				_g_object_unref0 (reader);
				uint8_test_data_destroy (&data);
			}
		}
	}
}


inline void named_assert_uint8 (const gchar* name, guint8 expected, guint8 _result_) {
	guint8 _tmp0_;
	guint8 _tmp1_;
	g_return_if_fail (name != NULL);
	_tmp0_ = expected;
	_tmp1_ = _result_;
	if (_tmp0_ != _tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		guint8 _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		guint8 _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp2_ = name;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = _result_;
		_tmp5_ = g_strdup_printf ("%hhu", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = expected;
		_tmp8_ = g_strdup_printf ("%hhu", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("[", _tmp3_, "] ", _tmp6_, " != ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		g_error ("testbinreader.vala:73: %s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp6_);
	}
}


static void _vala_uint8TestData_array_free (uint8TestData* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			uint8_test_data_destroy (&array[i]);
		}
	}
	g_free (array);
}


void test_uint8_le (void) {
	guint8* _tmp0_ = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	uint8TestData _tmp2_ = {0};
	guint8* _tmp3_ = NULL;
	guint8* _tmp4_;
	gint _tmp4__length1;
	uint8TestData _tmp5_ = {0};
	guint8* _tmp6_ = NULL;
	guint8* _tmp7_;
	gint _tmp7__length1;
	uint8TestData _tmp8_ = {0};
	uint8TestData* _tmp9_ = NULL;
	uint8TestData* _tmp10_;
	gint _tmp10__length1;
	uint8TestData* tests;
	gint tests_length1;
	gint _tests_size_;
	_tmp0_ = g_new0 (guint8, 4);
	_tmp0_[0] = (guint8) 0;
	_tmp0_[1] = (guint8) 0;
	_tmp0_[2] = (guint8) 0;
	_tmp0_[3] = (guint8) 42;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 4;
	uint8_test_data_init (&_tmp2_, _tmp1_, 4, (guint8) 42, 4, 0, FALSE, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, "0 offset");
	_tmp3_ = g_new0 (guint8, 8);
	_tmp3_[0] = (guint8) 0;
	_tmp3_[1] = (guint8) 0;
	_tmp3_[2] = (guint8) 0;
	_tmp3_[3] = (guint8) 0;
	_tmp3_[4] = (guint8) 0;
	_tmp3_[5] = (guint8) 0;
	_tmp3_[6] = (guint8) 0;
	_tmp3_[7] = (guint8) 42;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 8;
	uint8_test_data_init (&_tmp5_, _tmp4_, 8, (guint8) 42, 4, 4, FALSE, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, "4 offset");
	_tmp6_ = g_new0 (guint8, 8);
	_tmp6_[0] = (guint8) 0;
	_tmp6_[1] = (guint8) 0;
	_tmp6_[2] = (guint8) 0;
	_tmp6_[3] = (guint8) 0;
	_tmp6_[4] = (guint8) 0;
	_tmp6_[5] = (guint8) 0;
	_tmp6_[6] = (guint8) 0;
	_tmp6_[7] = (guint8) 42;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 8;
	uint8_test_data_init (&_tmp8_, _tmp7_, 8, (guint8) 42, 4, 5, FALSE, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, "5 offset");
	_tmp9_ = g_new0 (uint8TestData, 3);
	_tmp9_[0] = _tmp2_;
	_tmp9_[1] = _tmp5_;
	_tmp9_[2] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 3;
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp1_ = (g_free (_tmp1_), NULL);
	tests = _tmp10_;
	tests_length1 = _tmp10__length1;
	_tests_size_ = tests_length1;
	test_uint8 (tests, tests_length1);
	tests = (_vala_uint8TestData_array_free (tests, tests_length1), NULL);
}


void test_uint8_be (void) {
	guint8* _tmp0_ = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	uint8TestData _tmp2_ = {0};
	guint8* _tmp3_ = NULL;
	guint8* _tmp4_;
	gint _tmp4__length1;
	uint8TestData _tmp5_ = {0};
	uint8TestData* _tmp6_ = NULL;
	uint8TestData* _tmp7_;
	gint _tmp7__length1;
	uint8TestData* tests;
	gint tests_length1;
	gint _tests_size_;
	_tmp0_ = g_new0 (guint8, 4);
	_tmp0_[0] = (guint8) 42;
	_tmp0_[1] = (guint8) 0;
	_tmp0_[2] = (guint8) 0;
	_tmp0_[3] = (guint8) 0;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 4;
	uint8_test_data_init (&_tmp2_, _tmp1_, 4, (guint8) 42, 4, 0, FALSE, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN, "0 offset");
	_tmp3_ = g_new0 (guint8, 8);
	_tmp3_[0] = (guint8) 0;
	_tmp3_[1] = (guint8) 0;
	_tmp3_[2] = (guint8) 0;
	_tmp3_[3] = (guint8) 0;
	_tmp3_[4] = (guint8) 42;
	_tmp3_[5] = (guint8) 0;
	_tmp3_[6] = (guint8) 0;
	_tmp3_[7] = (guint8) 0;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 8;
	uint8_test_data_init (&_tmp5_, _tmp4_, 8, (guint8) 42, 4, 4, FALSE, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN, "4 offset");
	_tmp6_ = g_new0 (uint8TestData, 2);
	_tmp6_[0] = _tmp2_;
	_tmp6_[1] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 2;
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp1_ = (g_free (_tmp1_), NULL);
	tests = _tmp7_;
	tests_length1 = _tmp7__length1;
	_tests_size_ = tests_length1;
	test_uint8 (tests, tests_length1);
	tests = (_vala_uint8TestData_array_free (tests, tests_length1), NULL);
}


void test_exception_uint8 (void) {
	guint8* _tmp0_ = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	uint8TestData _tmp2_ = {0};
	guint8* _tmp3_ = NULL;
	guint8* _tmp4_;
	gint _tmp4__length1;
	uint8TestData _tmp5_ = {0};
	uint8TestData* _tmp6_ = NULL;
	uint8TestData* _tmp7_;
	gint _tmp7__length1;
	uint8TestData* tests;
	gint tests_length1;
	gint _tests_size_;
	_tmp0_ = g_new0 (guint8, 3);
	_tmp0_[0] = (guint8) 0;
	_tmp0_[1] = (guint8) 0;
	_tmp0_[2] = (guint8) 0;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 3;
	uint8_test_data_init (&_tmp2_, _tmp1_, 3, (guint8) 0, 4, 0, TRUE, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, "0 offset exception");
	_tmp3_ = g_new0 (guint8, 7);
	_tmp3_[0] = (guint8) 0;
	_tmp3_[1] = (guint8) 0;
	_tmp3_[2] = (guint8) 0;
	_tmp3_[3] = (guint8) 0;
	_tmp3_[4] = (guint8) 0;
	_tmp3_[5] = (guint8) 0;
	_tmp3_[6] = (guint8) 0;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 7;
	uint8_test_data_init (&_tmp5_, _tmp4_, 7, (guint8) 0, 4, 4, TRUE, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, "4 offset exception");
	_tmp6_ = g_new0 (uint8TestData, 2);
	_tmp6_[0] = _tmp2_;
	_tmp6_[1] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 2;
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp1_ = (g_free (_tmp1_), NULL);
	tests = _tmp7_;
	tests_length1 = _tmp7__length1;
	_tests_size_ = tests_length1;
	test_uint8 (tests, tests_length1);
	tests = (_vala_uint8TestData_array_free (tests, tests_length1), NULL);
}


static guint8* _vala_array_dup3 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void uint16_test_data_init (uint16TestData *self, guint8* d, int d_length1, guint16 exp, gint align, gint off, gboolean exceptions, GDataStreamByteOrder e, const gchar* n) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint16 _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	GDataStreamByteOrder _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (n != NULL);
	memset (self, 0, sizeof (uint16TestData));
	_tmp0_ = d;
	_tmp0__length1 = d_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	(*self).data = (g_free ((*self).data), NULL);
	(*self).data = _tmp1_;
	(*self).data_length1 = _tmp1__length1;
	(*self)._data_size_ = (*self).data_length1;
	_tmp2_ = exp;
	(*self).expected = _tmp2_;
	_tmp3_ = align;
	(*self).alignment = _tmp3_;
	_tmp4_ = off;
	(*self).offset = _tmp4_;
	_tmp5_ = exceptions;
	(*self).expect_exception = _tmp5_;
	_tmp6_ = e;
	(*self).endianess = _tmp6_;
	_tmp7_ = n;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 ((*self).name);
	(*self).name = _tmp8_;
}


static guint8* _vala_array_dup4 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void uint16_test_data_copy (const uint16TestData* self, uint16TestData* dest) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint16 _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	GDataStreamByteOrder _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	_tmp0_ = (*self).data;
	_tmp0__length1 = (*self).data_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup4 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	(*dest).data = (g_free ((*dest).data), NULL);
	(*dest).data = _tmp1_;
	(*dest).data_length1 = _tmp1__length1;
	(*dest)._data_size_ = (*dest).data_length1;
	_tmp2_ = (*self).expected;
	(*dest).expected = _tmp2_;
	_tmp3_ = (*self).alignment;
	(*dest).alignment = _tmp3_;
	_tmp4_ = (*self).offset;
	(*dest).offset = _tmp4_;
	_tmp5_ = (*self).expect_exception;
	(*dest).expect_exception = _tmp5_;
	_tmp6_ = (*self).endianess;
	(*dest).endianess = _tmp6_;
	_tmp7_ = (*self).name;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp8_;
}


void uint16_test_data_destroy (uint16TestData* self) {
	(*self).data = (g_free ((*self).data), NULL);
	_g_free0 ((*self).name);
}


uint16TestData* uint16_test_data_dup (const uint16TestData* self) {
	uint16TestData* dup;
	dup = g_new0 (uint16TestData, 1);
	uint16_test_data_copy (self, dup);
	return dup;
}


void uint16_test_data_free (uint16TestData* self) {
	uint16_test_data_destroy (self);
	g_free (self);
}


GType uint16_test_data_get_type (void) {
	static volatile gsize uint16_test_data_type_id__volatile = 0;
	if (g_once_init_enter (&uint16_test_data_type_id__volatile)) {
		GType uint16_test_data_type_id;
		uint16_test_data_type_id = g_boxed_type_register_static ("uint16TestData", (GBoxedCopyFunc) uint16_test_data_dup, (GBoxedFreeFunc) uint16_test_data_free);
		g_once_init_leave (&uint16_test_data_type_id__volatile, uint16_test_data_type_id);
	}
	return uint16_test_data_type_id__volatile;
}


void test_uint16 (uint16TestData* datas, int datas_length1) {
	uint16TestData* _tmp0_;
	gint _tmp0__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = datas;
	_tmp0__length1 = datas_length1;
	{
		uint16TestData* data_collection = NULL;
		gint data_collection_length1 = 0;
		gint _data_collection_size_ = 0;
		gint data_it = 0;
		data_collection = _tmp0_;
		data_collection_length1 = _tmp0__length1;
		for (data_it = 0; data_it < _tmp0__length1; data_it = data_it + 1) {
			uint16TestData _tmp1_ = {0};
			uint16TestData data = {0};
			uint16_test_data_copy (&data_collection[data_it], &_tmp1_);
			data = _tmp1_;
			{
				guint16 _result_;
				uint16TestData _tmp2_;
				guint8* _tmp3_;
				gint _tmp3__length1;
				uint16TestData _tmp4_;
				gint _tmp5_;
				uint16TestData _tmp6_;
				GDataStreamByteOrder _tmp7_;
				FsoFrameworkBinReader* _tmp8_;
				FsoFrameworkBinReader* reader;
				gboolean caught;
				uint16TestData _tmp24_;
				gboolean _tmp25_;
				_result_ = (guint16) 0;
				_tmp2_ = data;
				_tmp3_ = _tmp2_.data;
				_tmp3__length1 = _tmp2_.data_length1;
				_tmp4_ = data;
				_tmp5_ = _tmp4_.alignment;
				_tmp6_ = data;
				_tmp7_ = _tmp6_.endianess;
				_tmp8_ = fso_framework_bin_reader_new (_tmp3_, _tmp3__length1, _tmp5_, _tmp7_);
				reader = _tmp8_;
				caught = FALSE;
				{
					FsoFrameworkBinReader* _tmp9_;
					uint16TestData _tmp10_;
					gint _tmp11_;
					guint16 _tmp12_ = 0U;
					guint16 _tmp13_;
					_tmp9_ = reader;
					_tmp10_ = data;
					_tmp11_ = _tmp10_.offset;
					_tmp12_ = fso_framework_bin_reader_get_uint16 (_tmp9_, _tmp11_, &_inner_error_);
					_tmp13_ = _tmp12_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
							goto __catch1_fso_framework_bin_reader_error;
						}
						_g_object_unref0 (reader);
						uint16_test_data_destroy (&data);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_result_ = _tmp13_;
				}
				goto __finally1;
				__catch1_fso_framework_bin_reader_error:
				{
					GError* e = NULL;
					uint16TestData _tmp14_;
					gboolean _tmp15_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp14_ = data;
					_tmp15_ = _tmp14_.expect_exception;
					if (!_tmp15_) {
						uint16TestData _tmp16_;
						const gchar* _tmp17_;
						const gchar* _tmp18_ = NULL;
						GError* _tmp19_;
						const gchar* _tmp20_;
						const gchar* _tmp21_ = NULL;
						gchar* _tmp22_ = NULL;
						gchar* _tmp23_;
						_tmp16_ = data;
						_tmp17_ = _tmp16_.name;
						_tmp18_ = string_to_string (_tmp17_);
						_tmp19_ = e;
						_tmp20_ = _tmp19_->message;
						_tmp21_ = string_to_string (_tmp20_);
						_tmp22_ = g_strconcat ("[", _tmp18_, "] doesn't expect an exception: ", _tmp21_, NULL);
						_tmp23_ = _tmp22_;
						g_error ("testbinreader.vala:140: %s", _tmp23_);
						_g_free0 (_tmp23_);
					}
					caught = TRUE;
					_g_error_free0 (e);
				}
				__finally1:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (reader);
					uint16_test_data_destroy (&data);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp24_ = data;
				_tmp25_ = _tmp24_.expect_exception;
				if (!_tmp25_) {
					uint16TestData _tmp26_;
					const gchar* _tmp27_;
					guint16 _tmp28_;
					uint16TestData _tmp29_;
					guint16 _tmp30_;
					_tmp26_ = data;
					_tmp27_ = _tmp26_.name;
					_tmp28_ = _result_;
					_tmp29_ = data;
					_tmp30_ = _tmp29_.expected;
					named_assert_uint16 (_tmp27_, _tmp28_, _tmp30_);
				} else {
					gboolean _tmp31_ = FALSE;
					uint16TestData _tmp32_;
					gboolean _tmp33_;
					gboolean _tmp35_;
					_tmp32_ = data;
					_tmp33_ = _tmp32_.expect_exception;
					if (_tmp33_) {
						gboolean _tmp34_;
						_tmp34_ = caught;
						_tmp31_ = !_tmp34_;
					} else {
						_tmp31_ = FALSE;
					}
					_tmp35_ = _tmp31_;
					if (_tmp35_) {
						uint16TestData _tmp36_;
						const gchar* _tmp37_;
						const gchar* _tmp38_ = NULL;
						gchar* _tmp39_ = NULL;
						gchar* _tmp40_;
						_tmp36_ = data;
						_tmp37_ = _tmp36_.name;
						_tmp38_ = string_to_string (_tmp37_);
						_tmp39_ = g_strconcat ("[", _tmp38_, "] expected exception", NULL);
						_tmp40_ = _tmp39_;
						g_error ("testbinreader.vala:146: %s", _tmp40_);
						_g_free0 (_tmp40_);
					}
				}
				_g_object_unref0 (reader);
				uint16_test_data_destroy (&data);
			}
		}
	}
}


inline void named_assert_uint16 (const gchar* name, guint16 expected, guint16 _result_) {
	guint16 _tmp0_;
	guint16 _tmp1_;
	g_return_if_fail (name != NULL);
	_tmp0_ = expected;
	_tmp1_ = _result_;
	if (_tmp0_ != _tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		guint16 _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		guint16 _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp2_ = name;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = _result_;
		_tmp5_ = g_strdup_printf ("%hu", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = expected;
		_tmp8_ = g_strdup_printf ("%hu", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("[", _tmp3_, "] result [", _tmp6_, "] != expected [", _tmp9_, "]", NULL);
		_tmp11_ = _tmp10_;
		g_error ("testbinreader.vala:153: %s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp6_);
	}
}


static void _vala_uint16TestData_array_free (uint16TestData* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			uint16_test_data_destroy (&array[i]);
		}
	}
	g_free (array);
}


void test_uint16_le (void) {
	guint8* _tmp0_ = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	uint16TestData _tmp2_ = {0};
	guint8* _tmp3_ = NULL;
	guint8* _tmp4_;
	gint _tmp4__length1;
	uint16TestData _tmp5_ = {0};
	guint8* _tmp6_ = NULL;
	guint8* _tmp7_;
	gint _tmp7__length1;
	uint16TestData _tmp8_ = {0};
	guint8* _tmp9_ = NULL;
	guint8* _tmp10_;
	gint _tmp10__length1;
	uint16TestData _tmp11_ = {0};
	uint16TestData* _tmp12_ = NULL;
	uint16TestData* _tmp13_;
	gint _tmp13__length1;
	uint16TestData* tests;
	gint tests_length1;
	gint _tests_size_;
	_tmp0_ = g_new0 (guint8, 4);
	_tmp0_[0] = (guint8) 0;
	_tmp0_[1] = (guint8) 0;
	_tmp0_[2] = (guint8) 0x11;
	_tmp0_[3] = (guint8) 0x22;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 4;
	uint16_test_data_init (&_tmp2_, _tmp1_, 4, (guint16) 0x1122, 4, 0, FALSE, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, "0 offset 4 byte alignment");
	_tmp3_ = g_new0 (guint8, 8);
	_tmp3_[0] = (guint8) 0;
	_tmp3_[1] = (guint8) 0;
	_tmp3_[2] = (guint8) 0;
	_tmp3_[3] = (guint8) 0;
	_tmp3_[4] = (guint8) 0;
	_tmp3_[5] = (guint8) 0;
	_tmp3_[6] = (guint8) 0x11;
	_tmp3_[7] = (guint8) 0x22;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 8;
	uint16_test_data_init (&_tmp5_, _tmp4_, 8, (guint16) 0x1122, 4, 4, FALSE, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, "4 offset 4 byte alignment");
	_tmp6_ = g_new0 (guint8, 2);
	_tmp6_[0] = (guint8) 0x11;
	_tmp6_[1] = (guint8) 0x22;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 2;
	uint16_test_data_init (&_tmp8_, _tmp7_, 2, (guint16) 0x1122, 2, 0, FALSE, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, "0 offset 2 byte alignment");
	_tmp9_ = g_new0 (guint8, 4);
	_tmp9_[0] = (guint8) 0;
	_tmp9_[1] = (guint8) 0;
	_tmp9_[2] = (guint8) 0x11;
	_tmp9_[3] = (guint8) 0x22;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 4;
	uint16_test_data_init (&_tmp11_, _tmp10_, 4, (guint16) 0x1122, 2, 2, FALSE, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, "2 offset 2 byte alignment");
	_tmp12_ = g_new0 (uint16TestData, 4);
	_tmp12_[0] = _tmp2_;
	_tmp12_[1] = _tmp5_;
	_tmp12_[2] = _tmp8_;
	_tmp12_[3] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 4;
	_tmp10_ = (g_free (_tmp10_), NULL);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp1_ = (g_free (_tmp1_), NULL);
	tests = _tmp13_;
	tests_length1 = _tmp13__length1;
	_tests_size_ = tests_length1;
	test_uint16 (tests, tests_length1);
	tests = (_vala_uint16TestData_array_free (tests, tests_length1), NULL);
}


void test_uint16_be (void) {
	guint8* _tmp0_ = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	uint16TestData _tmp2_ = {0};
	guint8* _tmp3_ = NULL;
	guint8* _tmp4_;
	gint _tmp4__length1;
	uint16TestData _tmp5_ = {0};
	guint8* _tmp6_ = NULL;
	guint8* _tmp7_;
	gint _tmp7__length1;
	uint16TestData _tmp8_ = {0};
	guint8* _tmp9_ = NULL;
	guint8* _tmp10_;
	gint _tmp10__length1;
	uint16TestData _tmp11_ = {0};
	uint16TestData* _tmp12_ = NULL;
	uint16TestData* _tmp13_;
	gint _tmp13__length1;
	uint16TestData* tests;
	gint tests_length1;
	gint _tests_size_;
	_tmp0_ = g_new0 (guint8, 4);
	_tmp0_[0] = (guint8) 0x22;
	_tmp0_[1] = (guint8) 0x11;
	_tmp0_[2] = (guint8) 0;
	_tmp0_[3] = (guint8) 0;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 4;
	uint16_test_data_init (&_tmp2_, _tmp1_, 4, (guint16) 0x1122, 4, 0, FALSE, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN, "0 offset 4 byte alignment");
	_tmp3_ = g_new0 (guint8, 8);
	_tmp3_[0] = (guint8) 0;
	_tmp3_[1] = (guint8) 0;
	_tmp3_[2] = (guint8) 0;
	_tmp3_[3] = (guint8) 0;
	_tmp3_[4] = (guint8) 0x22;
	_tmp3_[5] = (guint8) 0x11;
	_tmp3_[6] = (guint8) 0;
	_tmp3_[7] = (guint8) 0;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 8;
	uint16_test_data_init (&_tmp5_, _tmp4_, 8, (guint16) 0x1122, 4, 4, FALSE, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN, "4 offset 4 byte alignment");
	_tmp6_ = g_new0 (guint8, 2);
	_tmp6_[0] = (guint8) 0x22;
	_tmp6_[1] = (guint8) 0x11;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 2;
	uint16_test_data_init (&_tmp8_, _tmp7_, 2, (guint16) 0x1122, 2, 0, FALSE, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN, "0 offset 2 byte alignment");
	_tmp9_ = g_new0 (guint8, 4);
	_tmp9_[0] = (guint8) 0;
	_tmp9_[1] = (guint8) 0;
	_tmp9_[2] = (guint8) 0x22;
	_tmp9_[3] = (guint8) 0x11;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 4;
	uint16_test_data_init (&_tmp11_, _tmp10_, 4, (guint16) 0x1122, 2, 2, FALSE, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN, "2 offset 2 byte alignment");
	_tmp12_ = g_new0 (uint16TestData, 4);
	_tmp12_[0] = _tmp2_;
	_tmp12_[1] = _tmp5_;
	_tmp12_[2] = _tmp8_;
	_tmp12_[3] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 4;
	_tmp10_ = (g_free (_tmp10_), NULL);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp1_ = (g_free (_tmp1_), NULL);
	tests = _tmp13_;
	tests_length1 = _tmp13__length1;
	_tests_size_ = tests_length1;
	test_uint16 (tests, tests_length1);
	tests = (_vala_uint16TestData_array_free (tests, tests_length1), NULL);
}


void test_exception_uint16 (void) {
	guint8* _tmp0_ = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	uint16TestData _tmp2_ = {0};
	guint8* _tmp3_ = NULL;
	guint8* _tmp4_;
	gint _tmp4__length1;
	uint16TestData _tmp5_ = {0};
	guint8* _tmp6_ = NULL;
	guint8* _tmp7_;
	gint _tmp7__length1;
	uint16TestData _tmp8_ = {0};
	uint16TestData* _tmp9_ = NULL;
	uint16TestData* _tmp10_;
	gint _tmp10__length1;
	uint16TestData* tests;
	gint tests_length1;
	gint _tests_size_;
	_tmp0_ = g_new0 (guint8, 5);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 5;
	uint16_test_data_init (&_tmp2_, _tmp1_, 5, (guint16) 0x1122, 2, 4, TRUE, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN, "5 byte 4 bytes alignment 4 offset");
	_tmp3_ = g_new0 (guint8, 1);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	uint16_test_data_init (&_tmp5_, _tmp4_, 1, (guint16) 0x1122, 2, 0, TRUE, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN, "1 byte 2 bytes alignment");
	_tmp6_ = g_new0 (guint8, 1);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 1;
	uint16_test_data_init (&_tmp8_, _tmp7_, 1, (guint16) 0x1122, 0, 0, TRUE, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN, "1 byte no alignment");
	_tmp9_ = g_new0 (uint16TestData, 3);
	_tmp9_[0] = _tmp2_;
	_tmp9_[1] = _tmp5_;
	_tmp9_[2] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 3;
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp1_ = (g_free (_tmp1_), NULL);
	tests = _tmp10_;
	tests_length1 = _tmp10__length1;
	_tests_size_ = tests_length1;
	test_uint16 (tests, tests_length1);
	tests = (_vala_uint16TestData_array_free (tests, tests_length1), NULL);
}


static guint8* _vala_array_dup5 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void uint32_test_data_init (uint32TestData *self, guint8* d, int d_length1, guint32 exp, gint align, gint off, gboolean exceptions, GDataStreamByteOrder e, const gchar* n) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint32 _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	GDataStreamByteOrder _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (n != NULL);
	memset (self, 0, sizeof (uint32TestData));
	_tmp0_ = d;
	_tmp0__length1 = d_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	(*self).data = (g_free ((*self).data), NULL);
	(*self).data = _tmp1_;
	(*self).data_length1 = _tmp1__length1;
	(*self)._data_size_ = (*self).data_length1;
	_tmp2_ = exp;
	(*self).expected = _tmp2_;
	_tmp3_ = align;
	(*self).alignment = _tmp3_;
	_tmp4_ = off;
	(*self).offset = _tmp4_;
	_tmp5_ = exceptions;
	(*self).expect_exception = _tmp5_;
	_tmp6_ = e;
	(*self).endianess = _tmp6_;
	_tmp7_ = n;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 ((*self).name);
	(*self).name = _tmp8_;
}


static guint8* _vala_array_dup6 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void uint32_test_data_copy (const uint32TestData* self, uint32TestData* dest) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint32 _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	GDataStreamByteOrder _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	_tmp0_ = (*self).data;
	_tmp0__length1 = (*self).data_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup6 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	(*dest).data = (g_free ((*dest).data), NULL);
	(*dest).data = _tmp1_;
	(*dest).data_length1 = _tmp1__length1;
	(*dest)._data_size_ = (*dest).data_length1;
	_tmp2_ = (*self).expected;
	(*dest).expected = _tmp2_;
	_tmp3_ = (*self).alignment;
	(*dest).alignment = _tmp3_;
	_tmp4_ = (*self).offset;
	(*dest).offset = _tmp4_;
	_tmp5_ = (*self).expect_exception;
	(*dest).expect_exception = _tmp5_;
	_tmp6_ = (*self).endianess;
	(*dest).endianess = _tmp6_;
	_tmp7_ = (*self).name;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp8_;
}


void uint32_test_data_destroy (uint32TestData* self) {
	(*self).data = (g_free ((*self).data), NULL);
	_g_free0 ((*self).name);
}


uint32TestData* uint32_test_data_dup (const uint32TestData* self) {
	uint32TestData* dup;
	dup = g_new0 (uint32TestData, 1);
	uint32_test_data_copy (self, dup);
	return dup;
}


void uint32_test_data_free (uint32TestData* self) {
	uint32_test_data_destroy (self);
	g_free (self);
}


GType uint32_test_data_get_type (void) {
	static volatile gsize uint32_test_data_type_id__volatile = 0;
	if (g_once_init_enter (&uint32_test_data_type_id__volatile)) {
		GType uint32_test_data_type_id;
		uint32_test_data_type_id = g_boxed_type_register_static ("uint32TestData", (GBoxedCopyFunc) uint32_test_data_dup, (GBoxedFreeFunc) uint32_test_data_free);
		g_once_init_leave (&uint32_test_data_type_id__volatile, uint32_test_data_type_id);
	}
	return uint32_test_data_type_id__volatile;
}


void test_uint32 (uint32TestData* datas, int datas_length1) {
	uint32TestData* _tmp0_;
	gint _tmp0__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = datas;
	_tmp0__length1 = datas_length1;
	{
		uint32TestData* data_collection = NULL;
		gint data_collection_length1 = 0;
		gint _data_collection_size_ = 0;
		gint data_it = 0;
		data_collection = _tmp0_;
		data_collection_length1 = _tmp0__length1;
		for (data_it = 0; data_it < _tmp0__length1; data_it = data_it + 1) {
			uint32TestData _tmp1_ = {0};
			uint32TestData data = {0};
			uint32_test_data_copy (&data_collection[data_it], &_tmp1_);
			data = _tmp1_;
			{
				guint32 _result_;
				uint32TestData _tmp2_;
				guint8* _tmp3_;
				gint _tmp3__length1;
				uint32TestData _tmp4_;
				gint _tmp5_;
				uint32TestData _tmp6_;
				GDataStreamByteOrder _tmp7_;
				FsoFrameworkBinReader* _tmp8_;
				FsoFrameworkBinReader* reader;
				gboolean caught;
				uint32TestData _tmp24_;
				gboolean _tmp25_;
				_result_ = (guint32) 0;
				_tmp2_ = data;
				_tmp3_ = _tmp2_.data;
				_tmp3__length1 = _tmp2_.data_length1;
				_tmp4_ = data;
				_tmp5_ = _tmp4_.alignment;
				_tmp6_ = data;
				_tmp7_ = _tmp6_.endianess;
				_tmp8_ = fso_framework_bin_reader_new (_tmp3_, _tmp3__length1, _tmp5_, _tmp7_);
				reader = _tmp8_;
				caught = FALSE;
				{
					FsoFrameworkBinReader* _tmp9_;
					uint32TestData _tmp10_;
					gint _tmp11_;
					guint32 _tmp12_ = 0U;
					guint32 _tmp13_;
					_tmp9_ = reader;
					_tmp10_ = data;
					_tmp11_ = _tmp10_.offset;
					_tmp12_ = fso_framework_bin_reader_get_uint32 (_tmp9_, _tmp11_, &_inner_error_);
					_tmp13_ = _tmp12_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
							goto __catch2_fso_framework_bin_reader_error;
						}
						_g_object_unref0 (reader);
						uint32_test_data_destroy (&data);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_result_ = _tmp13_;
				}
				goto __finally2;
				__catch2_fso_framework_bin_reader_error:
				{
					GError* e = NULL;
					uint32TestData _tmp14_;
					gboolean _tmp15_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp14_ = data;
					_tmp15_ = _tmp14_.expect_exception;
					if (!_tmp15_) {
						uint32TestData _tmp16_;
						const gchar* _tmp17_;
						const gchar* _tmp18_ = NULL;
						GError* _tmp19_;
						const gchar* _tmp20_;
						const gchar* _tmp21_ = NULL;
						gchar* _tmp22_ = NULL;
						gchar* _tmp23_;
						_tmp16_ = data;
						_tmp17_ = _tmp16_.name;
						_tmp18_ = string_to_string (_tmp17_);
						_tmp19_ = e;
						_tmp20_ = _tmp19_->message;
						_tmp21_ = string_to_string (_tmp20_);
						_tmp22_ = g_strconcat ("[", _tmp18_, "] doesn't expect an exception: ", _tmp21_, NULL);
						_tmp23_ = _tmp22_;
						g_error ("testbinreader.vala:226: %s", _tmp23_);
						_g_free0 (_tmp23_);
					}
					caught = TRUE;
					_g_error_free0 (e);
				}
				__finally2:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (reader);
					uint32_test_data_destroy (&data);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp24_ = data;
				_tmp25_ = _tmp24_.expect_exception;
				if (!_tmp25_) {
					uint32TestData _tmp26_;
					const gchar* _tmp27_;
					guint32 _tmp28_;
					uint32TestData _tmp29_;
					guint32 _tmp30_;
					_tmp26_ = data;
					_tmp27_ = _tmp26_.name;
					_tmp28_ = _result_;
					_tmp29_ = data;
					_tmp30_ = _tmp29_.expected;
					named_assert_uint32 (_tmp27_, _tmp28_, _tmp30_);
				} else {
					gboolean _tmp31_ = FALSE;
					uint32TestData _tmp32_;
					gboolean _tmp33_;
					gboolean _tmp35_;
					_tmp32_ = data;
					_tmp33_ = _tmp32_.expect_exception;
					if (_tmp33_) {
						gboolean _tmp34_;
						_tmp34_ = caught;
						_tmp31_ = !_tmp34_;
					} else {
						_tmp31_ = FALSE;
					}
					_tmp35_ = _tmp31_;
					if (_tmp35_) {
						uint32TestData _tmp36_;
						const gchar* _tmp37_;
						const gchar* _tmp38_ = NULL;
						gchar* _tmp39_ = NULL;
						gchar* _tmp40_;
						_tmp36_ = data;
						_tmp37_ = _tmp36_.name;
						_tmp38_ = string_to_string (_tmp37_);
						_tmp39_ = g_strconcat ("[", _tmp38_, "] expected exception", NULL);
						_tmp40_ = _tmp39_;
						g_error ("testbinreader.vala:232: %s", _tmp40_);
						_g_free0 (_tmp40_);
					}
				}
				_g_object_unref0 (reader);
				uint32_test_data_destroy (&data);
			}
		}
	}
}


inline void named_assert_uint32 (const gchar* name, guint32 expected, guint32 _result_) {
	guint32 _tmp0_;
	guint32 _tmp1_;
	g_return_if_fail (name != NULL);
	_tmp0_ = expected;
	_tmp1_ = _result_;
	if (_tmp0_ != _tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		guint32 _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		guint32 _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp2_ = name;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = _result_;
		_tmp5_ = g_strdup_printf ("%u", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = expected;
		_tmp8_ = g_strdup_printf ("%u", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("[", _tmp3_, "] result [", _tmp6_, "] != expected [", _tmp9_, "]", NULL);
		_tmp11_ = _tmp10_;
		g_error ("testbinreader.vala:239: %s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp6_);
	}
}


static void _vala_uint32TestData_array_free (uint32TestData* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			uint32_test_data_destroy (&array[i]);
		}
	}
	g_free (array);
}


void test_uint32_be (void) {
	guint8* _tmp0_ = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	uint32TestData _tmp2_ = {0};
	guint8* _tmp3_ = NULL;
	guint8* _tmp4_;
	gint _tmp4__length1;
	uint32TestData _tmp5_ = {0};
	guint8* _tmp6_ = NULL;
	guint8* _tmp7_;
	gint _tmp7__length1;
	uint32TestData _tmp8_ = {0};
	guint8* _tmp9_ = NULL;
	guint8* _tmp10_;
	gint _tmp10__length1;
	uint32TestData _tmp11_ = {0};
	guint8* _tmp12_ = NULL;
	guint8* _tmp13_;
	gint _tmp13__length1;
	uint32TestData _tmp14_ = {0};
	uint32TestData* _tmp15_ = NULL;
	uint32TestData* _tmp16_;
	gint _tmp16__length1;
	uint32TestData* tests;
	gint tests_length1;
	gint _tests_size_;
	_tmp0_ = g_new0 (guint8, 4);
	_tmp0_[0] = (guint8) 0x44;
	_tmp0_[1] = (guint8) 0x33;
	_tmp0_[2] = (guint8) 0x22;
	_tmp0_[3] = (guint8) 0x11;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 4;
	uint32_test_data_init (&_tmp2_, _tmp1_, 4, (guint32) 0x11223344, 4, 0, FALSE, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN, "0 offset 4 bytes alignment");
	_tmp3_ = g_new0 (guint8, 8);
	_tmp3_[0] = (guint8) 0;
	_tmp3_[1] = (guint8) 0;
	_tmp3_[2] = (guint8) 0;
	_tmp3_[3] = (guint8) 0;
	_tmp3_[4] = (guint8) 0x44;
	_tmp3_[5] = (guint8) 0x33;
	_tmp3_[6] = (guint8) 0x22;
	_tmp3_[7] = (guint8) 0x11;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 8;
	uint32_test_data_init (&_tmp5_, _tmp4_, 8, (guint32) 0x11223344, 4, 4, FALSE, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN, "4 offset 4 bytes alignment");
	_tmp6_ = g_new0 (guint8, 4);
	_tmp6_[0] = (guint8) 0x44;
	_tmp6_[1] = (guint8) 0x33;
	_tmp6_[2] = (guint8) 0x22;
	_tmp6_[3] = (guint8) 0x11;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 4;
	uint32_test_data_init (&_tmp8_, _tmp7_, 4, (guint32) 0x11223344, 2, 0, FALSE, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN, "0 offset 2 bytes alignment");
	_tmp9_ = g_new0 (guint8, 6);
	_tmp9_[0] = (guint8) 0;
	_tmp9_[1] = (guint8) 0;
	_tmp9_[2] = (guint8) 0x44;
	_tmp9_[3] = (guint8) 0x33;
	_tmp9_[4] = (guint8) 0x22;
	_tmp9_[5] = (guint8) 0x11;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 6;
	uint32_test_data_init (&_tmp11_, _tmp10_, 6, (guint32) 0x11223344, 2, 3, FALSE, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN, "3 offset 2 bytes alignment");
	_tmp12_ = g_new0 (guint8, 9);
	_tmp12_[0] = (guint8) 0;
	_tmp12_[1] = (guint8) 0;
	_tmp12_[2] = (guint8) 0;
	_tmp12_[3] = (guint8) 0;
	_tmp12_[4] = (guint8) 0;
	_tmp12_[5] = (guint8) 0x44;
	_tmp12_[6] = (guint8) 0x33;
	_tmp12_[7] = (guint8) 0x22;
	_tmp12_[8] = (guint8) 0x11;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 9;
	uint32_test_data_init (&_tmp14_, _tmp13_, 9, (guint32) 0x11223344, 0, 5, FALSE, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN, "5 offset packed");
	_tmp15_ = g_new0 (uint32TestData, 5);
	_tmp15_[0] = _tmp2_;
	_tmp15_[1] = _tmp5_;
	_tmp15_[2] = _tmp8_;
	_tmp15_[3] = _tmp11_;
	_tmp15_[4] = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 5;
	_tmp13_ = (g_free (_tmp13_), NULL);
	_tmp10_ = (g_free (_tmp10_), NULL);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp1_ = (g_free (_tmp1_), NULL);
	tests = _tmp16_;
	tests_length1 = _tmp16__length1;
	_tests_size_ = tests_length1;
	test_uint32 (tests, tests_length1);
	tests = (_vala_uint32TestData_array_free (tests, tests_length1), NULL);
}


void test_uint32_le (void) {
	guint8* _tmp0_ = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	uint32TestData _tmp2_ = {0};
	guint8* _tmp3_ = NULL;
	guint8* _tmp4_;
	gint _tmp4__length1;
	uint32TestData _tmp5_ = {0};
	guint8* _tmp6_ = NULL;
	guint8* _tmp7_;
	gint _tmp7__length1;
	uint32TestData _tmp8_ = {0};
	guint8* _tmp9_ = NULL;
	guint8* _tmp10_;
	gint _tmp10__length1;
	uint32TestData _tmp11_ = {0};
	guint8* _tmp12_ = NULL;
	guint8* _tmp13_;
	gint _tmp13__length1;
	uint32TestData _tmp14_ = {0};
	uint32TestData* _tmp15_ = NULL;
	uint32TestData* _tmp16_;
	gint _tmp16__length1;
	uint32TestData* tests;
	gint tests_length1;
	gint _tests_size_;
	_tmp0_ = g_new0 (guint8, 4);
	_tmp0_[0] = (guint8) 0x11;
	_tmp0_[1] = (guint8) 0x22;
	_tmp0_[2] = (guint8) 0x33;
	_tmp0_[3] = (guint8) 0x44;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 4;
	uint32_test_data_init (&_tmp2_, _tmp1_, 4, (guint32) 0x11223344, 4, 0, FALSE, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, "0 offset 4 bytes alignment");
	_tmp3_ = g_new0 (guint8, 8);
	_tmp3_[0] = (guint8) 0;
	_tmp3_[1] = (guint8) 0;
	_tmp3_[2] = (guint8) 0;
	_tmp3_[3] = (guint8) 0;
	_tmp3_[4] = (guint8) 0x11;
	_tmp3_[5] = (guint8) 0x22;
	_tmp3_[6] = (guint8) 0x33;
	_tmp3_[7] = (guint8) 0x44;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 8;
	uint32_test_data_init (&_tmp5_, _tmp4_, 8, (guint32) 0x11223344, 4, 4, FALSE, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, "4 offset 4 bytes alignment");
	_tmp6_ = g_new0 (guint8, 4);
	_tmp6_[0] = (guint8) 0x11;
	_tmp6_[1] = (guint8) 0x22;
	_tmp6_[2] = (guint8) 0x33;
	_tmp6_[3] = (guint8) 0x44;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 4;
	uint32_test_data_init (&_tmp8_, _tmp7_, 4, (guint32) 0x11223344, 2, 0, FALSE, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, "0 offset 2 bytes alignment");
	_tmp9_ = g_new0 (guint8, 6);
	_tmp9_[0] = (guint8) 0;
	_tmp9_[1] = (guint8) 0;
	_tmp9_[2] = (guint8) 0x11;
	_tmp9_[3] = (guint8) 0x22;
	_tmp9_[4] = (guint8) 0x33;
	_tmp9_[5] = (guint8) 0x44;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 6;
	uint32_test_data_init (&_tmp11_, _tmp10_, 6, (guint32) 0x11223344, 2, 3, FALSE, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, "3 offset 2 bytes alignment");
	_tmp12_ = g_new0 (guint8, 9);
	_tmp12_[0] = (guint8) 0;
	_tmp12_[1] = (guint8) 0;
	_tmp12_[2] = (guint8) 0;
	_tmp12_[3] = (guint8) 0;
	_tmp12_[4] = (guint8) 0;
	_tmp12_[5] = (guint8) 0x11;
	_tmp12_[6] = (guint8) 0x22;
	_tmp12_[7] = (guint8) 0x33;
	_tmp12_[8] = (guint8) 0x44;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 9;
	uint32_test_data_init (&_tmp14_, _tmp13_, 9, (guint32) 0x11223344, 0, 5, FALSE, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, "5 offset packed");
	_tmp15_ = g_new0 (uint32TestData, 5);
	_tmp15_[0] = _tmp2_;
	_tmp15_[1] = _tmp5_;
	_tmp15_[2] = _tmp8_;
	_tmp15_[3] = _tmp11_;
	_tmp15_[4] = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 5;
	_tmp13_ = (g_free (_tmp13_), NULL);
	_tmp10_ = (g_free (_tmp10_), NULL);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp1_ = (g_free (_tmp1_), NULL);
	tests = _tmp16_;
	tests_length1 = _tmp16__length1;
	_tests_size_ = tests_length1;
	test_uint32 (tests, tests_length1);
	tests = (_vala_uint32TestData_array_free (tests, tests_length1), NULL);
}


void test_exception_uint32 (void) {
	guint8* _tmp0_ = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	uint32TestData _tmp2_ = {0};
	guint8* _tmp3_ = NULL;
	guint8* _tmp4_;
	gint _tmp4__length1;
	uint32TestData _tmp5_ = {0};
	guint8* _tmp6_ = NULL;
	guint8* _tmp7_;
	gint _tmp7__length1;
	uint32TestData _tmp8_ = {0};
	guint8* _tmp9_ = NULL;
	guint8* _tmp10_;
	gint _tmp10__length1;
	uint32TestData _tmp11_ = {0};
	uint32TestData* _tmp12_ = NULL;
	uint32TestData* _tmp13_;
	gint _tmp13__length1;
	uint32TestData* tests;
	gint tests_length1;
	gint _tests_size_;
	_tmp0_ = g_new0 (guint8, 3);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 3;
	uint32_test_data_init (&_tmp2_, _tmp1_, 3, (guint32) 0, 4, 0, TRUE, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN, "3bytes 0 offset");
	_tmp3_ = g_new0 (guint8, 7);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 7;
	uint32_test_data_init (&_tmp5_, _tmp4_, 7, (guint32) 0, 4, 4, TRUE, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN, "7bytes 4 offset");
	_tmp6_ = g_new0 (guint8, 8);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 8;
	uint32_test_data_init (&_tmp8_, _tmp7_, 8, (guint32) 0, 0, 5, TRUE, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN, "8bytes 5 offset packet");
	_tmp9_ = g_new0 (guint8, 5);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 5;
	uint32_test_data_init (&_tmp11_, _tmp10_, 5, (guint32) 0, 2, 2, TRUE, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN, "5bytes 0 offset 2 bytes alignment");
	_tmp12_ = g_new0 (uint32TestData, 4);
	_tmp12_[0] = _tmp2_;
	_tmp12_[1] = _tmp5_;
	_tmp12_[2] = _tmp8_;
	_tmp12_[3] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 4;
	_tmp10_ = (g_free (_tmp10_), NULL);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp1_ = (g_free (_tmp1_), NULL);
	tests = _tmp13_;
	tests_length1 = _tmp13__length1;
	_tests_size_ = tests_length1;
	test_uint32 (tests, tests_length1);
	tests = (_vala_uint32TestData_array_free (tests, tests_length1), NULL);
}


static guint8* _vala_array_dup7 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void string_test_data_init (stringTestData *self, guint8* d, int d_length1, gint a, const gchar* e, gboolean exc, const gchar* n, gint o, gint l) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_if_fail (e != NULL);
	g_return_if_fail (n != NULL);
	memset (self, 0, sizeof (stringTestData));
	_tmp0_ = d;
	_tmp0__length1 = d_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup7 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	(*self).data = (g_free ((*self).data), NULL);
	(*self).data = _tmp1_;
	(*self).data_length1 = _tmp1__length1;
	(*self)._data_size_ = (*self).data_length1;
	_tmp2_ = a;
	(*self).alignment = _tmp2_;
	_tmp3_ = e;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*self).expected);
	(*self).expected = _tmp4_;
	_tmp5_ = exc;
	(*self).expect_exception = _tmp5_;
	_tmp6_ = n;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*self).name);
	(*self).name = _tmp7_;
	_tmp8_ = o;
	(*self).offset = _tmp8_;
	_tmp9_ = l;
	(*self).length = _tmp9_;
}


static guint8* _vala_array_dup8 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void string_test_data_copy (const stringTestData* self, stringTestData* dest) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	_tmp0_ = (*self).data;
	_tmp0__length1 = (*self).data_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup8 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	(*dest).data = (g_free ((*dest).data), NULL);
	(*dest).data = _tmp1_;
	(*dest).data_length1 = _tmp1__length1;
	(*dest)._data_size_ = (*dest).data_length1;
	_tmp2_ = (*self).alignment;
	(*dest).alignment = _tmp2_;
	_tmp3_ = (*self).expected;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).expected);
	(*dest).expected = _tmp4_;
	_tmp5_ = (*self).expect_exception;
	(*dest).expect_exception = _tmp5_;
	_tmp6_ = (*self).name;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp7_;
	_tmp8_ = (*self).offset;
	(*dest).offset = _tmp8_;
	_tmp9_ = (*self).length;
	(*dest).length = _tmp9_;
}


void string_test_data_destroy (stringTestData* self) {
	(*self).data = (g_free ((*self).data), NULL);
	_g_free0 ((*self).expected);
	_g_free0 ((*self).name);
}


stringTestData* string_test_data_dup (const stringTestData* self) {
	stringTestData* dup;
	dup = g_new0 (stringTestData, 1);
	string_test_data_copy (self, dup);
	return dup;
}


void string_test_data_free (stringTestData* self) {
	string_test_data_destroy (self);
	g_free (self);
}


GType string_test_data_get_type (void) {
	static volatile gsize string_test_data_type_id__volatile = 0;
	if (g_once_init_enter (&string_test_data_type_id__volatile)) {
		GType string_test_data_type_id;
		string_test_data_type_id = g_boxed_type_register_static ("stringTestData", (GBoxedCopyFunc) string_test_data_dup, (GBoxedFreeFunc) string_test_data_free);
		g_once_init_leave (&string_test_data_type_id__volatile, string_test_data_type_id);
	}
	return string_test_data_type_id__volatile;
}


inline void named_assert_string (const gchar* name, const gchar* expected, const gchar* _result_) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (name != NULL);
	g_return_if_fail (expected != NULL);
	g_return_if_fail (_result_ != NULL);
	_tmp0_ = expected;
	_tmp1_ = _result_;
	if (g_strcmp0 (_tmp0_, _tmp1_) != 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp2_ = name;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = _result_;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = expected;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("[", _tmp3_, "] result [", _tmp5_, "] != expected [", _tmp7_, "]", NULL);
		_tmp9_ = _tmp8_;
		g_error ("testbinreader.vala:303: %s", _tmp9_);
		_g_free0 (_tmp9_);
	}
}


void test_string (stringTestData* datas, int datas_length1) {
	stringTestData* _tmp0_;
	gint _tmp0__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = datas;
	_tmp0__length1 = datas_length1;
	{
		stringTestData* data_collection = NULL;
		gint data_collection_length1 = 0;
		gint _data_collection_size_ = 0;
		gint data_it = 0;
		data_collection = _tmp0_;
		data_collection_length1 = _tmp0__length1;
		for (data_it = 0; data_it < _tmp0__length1; data_it = data_it + 1) {
			stringTestData _tmp1_ = {0};
			stringTestData data = {0};
			string_test_data_copy (&data_collection[data_it], &_tmp1_);
			data = _tmp1_;
			{
				stringTestData _tmp2_;
				guint8* _tmp3_;
				gint _tmp3__length1;
				FsoFrameworkBinReader* _tmp4_;
				FsoFrameworkBinReader* reader;
				gboolean caught;
				gchar* _tmp5_;
				gchar* _result_;
				stringTestData _tmp23_;
				gboolean _tmp24_;
				_tmp2_ = data;
				_tmp3_ = _tmp2_.data;
				_tmp3__length1 = _tmp2_.data_length1;
				_tmp4_ = fso_framework_bin_reader_new (_tmp3_, _tmp3__length1, 0, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
				reader = _tmp4_;
				caught = FALSE;
				_tmp5_ = g_strdup ("");
				_result_ = _tmp5_;
				{
					FsoFrameworkBinReader* _tmp6_;
					stringTestData _tmp7_;
					gint _tmp8_;
					stringTestData _tmp9_;
					gint _tmp10_;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					_tmp6_ = reader;
					_tmp7_ = data;
					_tmp8_ = _tmp7_.offset;
					_tmp9_ = data;
					_tmp10_ = _tmp9_.length;
					_tmp11_ = fso_framework_bin_reader_get_string (_tmp6_, _tmp8_, _tmp10_, &_inner_error_);
					_tmp12_ = _tmp11_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
							goto __catch3_fso_framework_bin_reader_error;
						}
						_g_free0 (_result_);
						_g_object_unref0 (reader);
						string_test_data_destroy (&data);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_free0 (_result_);
					_result_ = _tmp12_;
				}
				goto __finally3;
				__catch3_fso_framework_bin_reader_error:
				{
					GError* e = NULL;
					stringTestData _tmp13_;
					gboolean _tmp14_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp13_ = data;
					_tmp14_ = _tmp13_.expect_exception;
					if (!_tmp14_) {
						stringTestData _tmp15_;
						const gchar* _tmp16_;
						const gchar* _tmp17_ = NULL;
						GError* _tmp18_;
						const gchar* _tmp19_;
						const gchar* _tmp20_ = NULL;
						gchar* _tmp21_ = NULL;
						gchar* _tmp22_;
						_tmp15_ = data;
						_tmp16_ = _tmp15_.name;
						_tmp17_ = string_to_string (_tmp16_);
						_tmp18_ = e;
						_tmp19_ = _tmp18_->message;
						_tmp20_ = string_to_string (_tmp19_);
						_tmp21_ = g_strconcat ("[", _tmp17_, "] doesn't expect an exception: ", _tmp20_, NULL);
						_tmp22_ = _tmp21_;
						g_error ("testbinreader.vala:320: %s", _tmp22_);
						_g_free0 (_tmp22_);
					}
					caught = TRUE;
					_g_error_free0 (e);
				}
				__finally3:
				if (_inner_error_ != NULL) {
					_g_free0 (_result_);
					_g_object_unref0 (reader);
					string_test_data_destroy (&data);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp23_ = data;
				_tmp24_ = _tmp23_.expect_exception;
				if (!_tmp24_) {
					stringTestData _tmp25_;
					const gchar* _tmp26_;
					stringTestData _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					_tmp25_ = data;
					_tmp26_ = _tmp25_.name;
					_tmp27_ = data;
					_tmp28_ = _tmp27_.expected;
					_tmp29_ = _result_;
					named_assert_string (_tmp26_, _tmp28_, _tmp29_);
				} else {
					gboolean _tmp30_ = FALSE;
					stringTestData _tmp31_;
					gboolean _tmp32_;
					gboolean _tmp34_;
					_tmp31_ = data;
					_tmp32_ = _tmp31_.expect_exception;
					if (_tmp32_) {
						gboolean _tmp33_;
						_tmp33_ = caught;
						_tmp30_ = !_tmp33_;
					} else {
						_tmp30_ = FALSE;
					}
					_tmp34_ = _tmp30_;
					if (_tmp34_) {
						stringTestData _tmp35_;
						const gchar* _tmp36_;
						const gchar* _tmp37_ = NULL;
						gchar* _tmp38_ = NULL;
						gchar* _tmp39_;
						_tmp35_ = data;
						_tmp36_ = _tmp35_.name;
						_tmp37_ = string_to_string (_tmp36_);
						_tmp38_ = g_strconcat ("[", _tmp37_, "] expected exception", NULL);
						_tmp39_ = _tmp38_;
						g_error ("testbinreader.vala:326: %s", _tmp39_);
						_g_free0 (_tmp39_);
					}
				}
				_g_free0 (_result_);
				_g_object_unref0 (reader);
				string_test_data_destroy (&data);
			}
		}
	}
}


static void _vala_stringTestData_array_free (stringTestData* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			string_test_data_destroy (&array[i]);
		}
	}
	g_free (array);
}


void test_strings (void) {
	guint8* _tmp0_ = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	stringTestData _tmp2_ = {0};
	guint8* _tmp3_ = NULL;
	guint8* _tmp4_;
	gint _tmp4__length1;
	stringTestData _tmp5_ = {0};
	guint8* _tmp6_ = NULL;
	guint8* _tmp7_;
	gint _tmp7__length1;
	stringTestData _tmp8_ = {0};
	guint8* _tmp9_ = NULL;
	guint8* _tmp10_;
	gint _tmp10__length1;
	stringTestData _tmp11_ = {0};
	guint8* _tmp12_ = NULL;
	guint8* _tmp13_;
	gint _tmp13__length1;
	stringTestData _tmp14_ = {0};
	stringTestData* _tmp15_ = NULL;
	stringTestData* _tmp16_;
	gint _tmp16__length1;
	stringTestData* tests;
	gint tests_length1;
	gint _tests_size_;
	_tmp0_ = g_new0 (guint8, 23);
	_tmp0_[0] = (guint8) 0;
	_tmp0_[1] = (guint8) 0;
	_tmp0_[2] = (guint8) 0;
	_tmp0_[3] = (guint8) 0;
	_tmp0_[4] = (guint8) 0;
	_tmp0_[5] = (guint8) 0;
	_tmp0_[6] = (guint8) 0;
	_tmp0_[7] = (guint8) 0;
	_tmp0_[8] = (guint8) 0;
	_tmp0_[9] = (guint8) 0;
	_tmp0_[10] = (guint8) 0;
	_tmp0_[11] = (guint8) 0;
	_tmp0_[12] = (guint8) 'H';
	_tmp0_[13] = (guint8) 'A';
	_tmp0_[14] = (guint8) 'L';
	_tmp0_[15] = (guint8) 'L';
	_tmp0_[16] = (guint8) 'O';
	_tmp0_[17] = (guint8) ' ';
	_tmp0_[18] = (guint8) 'W';
	_tmp0_[19] = (guint8) 'E';
	_tmp0_[20] = (guint8) 'L';
	_tmp0_[21] = (guint8) 'T';
	_tmp0_[22] = (guint8) 0;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 23;
	string_test_data_init (&_tmp2_, _tmp1_, 23, 4, "HALLO WELT", FALSE, "string @12", 12, -1);
	_tmp3_ = g_new0 (guint8, 21);
	_tmp3_[0] = (guint8) 0;
	_tmp3_[1] = (guint8) 0;
	_tmp3_[2] = (guint8) 0;
	_tmp3_[3] = (guint8) 0;
	_tmp3_[4] = (guint8) 0;
	_tmp3_[5] = (guint8) 0;
	_tmp3_[6] = (guint8) 0;
	_tmp3_[7] = (guint8) 0;
	_tmp3_[8] = (guint8) 0;
	_tmp3_[9] = (guint8) 0;
	_tmp3_[10] = (guint8) 'H';
	_tmp3_[11] = (guint8) 'A';
	_tmp3_[12] = (guint8) 'L';
	_tmp3_[13] = (guint8) 'L';
	_tmp3_[14] = (guint8) 'O';
	_tmp3_[15] = (guint8) ' ';
	_tmp3_[16] = (guint8) 'W';
	_tmp3_[17] = (guint8) 'E';
	_tmp3_[18] = (guint8) 'L';
	_tmp3_[19] = (guint8) 'T';
	_tmp3_[20] = (guint8) 0;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 21;
	string_test_data_init (&_tmp5_, _tmp4_, 21, 0, "HALLO WELT", FALSE, "string @10 packed", 10, -1);
	_tmp6_ = g_new0 (guint8, 21);
	_tmp6_[0] = (guint8) 0;
	_tmp6_[1] = (guint8) 0;
	_tmp6_[2] = (guint8) 0;
	_tmp6_[3] = (guint8) 0;
	_tmp6_[4] = (guint8) 0;
	_tmp6_[5] = (guint8) 0;
	_tmp6_[6] = (guint8) 0;
	_tmp6_[7] = (guint8) 0;
	_tmp6_[8] = (guint8) 0;
	_tmp6_[9] = (guint8) 0;
	_tmp6_[10] = (guint8) 'H';
	_tmp6_[11] = (guint8) 'A';
	_tmp6_[12] = (guint8) 'L';
	_tmp6_[13] = (guint8) 'L';
	_tmp6_[14] = (guint8) 'O';
	_tmp6_[15] = (guint8) ' ';
	_tmp6_[16] = (guint8) 'W';
	_tmp6_[17] = (guint8) 'E';
	_tmp6_[18] = (guint8) 'L';
	_tmp6_[19] = (guint8) 'T';
	_tmp6_[20] = (guint8) 0;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 21;
	string_test_data_init (&_tmp8_, _tmp7_, 21, 0, "HALLO", FALSE, "string @10 packed limit 5", 10, 5);
	_tmp9_ = g_new0 (guint8, 21);
	_tmp9_[0] = (guint8) 0;
	_tmp9_[1] = (guint8) 0;
	_tmp9_[2] = (guint8) 0;
	_tmp9_[3] = (guint8) 0;
	_tmp9_[4] = (guint8) 0;
	_tmp9_[5] = (guint8) 0;
	_tmp9_[6] = (guint8) 0;
	_tmp9_[7] = (guint8) 0;
	_tmp9_[8] = (guint8) 0;
	_tmp9_[9] = (guint8) 0;
	_tmp9_[10] = (guint8) 'H';
	_tmp9_[11] = (guint8) 'A';
	_tmp9_[12] = (guint8) 'L';
	_tmp9_[13] = (guint8) 'L';
	_tmp9_[14] = (guint8) 'O';
	_tmp9_[15] = (guint8) ' ';
	_tmp9_[16] = (guint8) 'W';
	_tmp9_[17] = (guint8) 'E';
	_tmp9_[18] = (guint8) 'L';
	_tmp9_[19] = (guint8) 'T';
	_tmp9_[20] = (guint8) 0;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 21;
	string_test_data_init (&_tmp11_, _tmp10_, 21, 0, "", FALSE, "string @20 empty packed", 20, 5);
	_tmp12_ = g_new0 (guint8, 21);
	_tmp12_[0] = (guint8) 0;
	_tmp12_[1] = (guint8) 0;
	_tmp12_[2] = (guint8) 0;
	_tmp12_[3] = (guint8) 0;
	_tmp12_[4] = (guint8) 0;
	_tmp12_[5] = (guint8) 0;
	_tmp12_[6] = (guint8) 0;
	_tmp12_[7] = (guint8) 0;
	_tmp12_[8] = (guint8) 0;
	_tmp12_[9] = (guint8) 0;
	_tmp12_[10] = (guint8) 'H';
	_tmp12_[11] = (guint8) 'A';
	_tmp12_[12] = (guint8) 'L';
	_tmp12_[13] = (guint8) 'L';
	_tmp12_[14] = (guint8) 'O';
	_tmp12_[15] = (guint8) ' ';
	_tmp12_[16] = (guint8) 'W';
	_tmp12_[17] = (guint8) 'E';
	_tmp12_[18] = (guint8) 'L';
	_tmp12_[19] = (guint8) 'T';
	_tmp12_[20] = (guint8) 0;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 21;
	string_test_data_init (&_tmp14_, _tmp13_, 21, 0, "", FALSE, "string @10 0 length packed", 10, 0);
	_tmp15_ = g_new0 (stringTestData, 5);
	_tmp15_[0] = _tmp2_;
	_tmp15_[1] = _tmp5_;
	_tmp15_[2] = _tmp8_;
	_tmp15_[3] = _tmp11_;
	_tmp15_[4] = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 5;
	_tmp13_ = (g_free (_tmp13_), NULL);
	_tmp10_ = (g_free (_tmp10_), NULL);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp1_ = (g_free (_tmp1_), NULL);
	tests = _tmp16_;
	tests_length1 = _tmp16__length1;
	_tests_size_ = tests_length1;
	test_string (tests, tests_length1);
	tests = (_vala_stringTestData_array_free (tests, tests_length1), NULL);
}


static guint8* _vala_array_dup9 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static guint8* _vala_array_dup10 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void data_test_data_init (dataTestData *self, guint8* d, int d_length1, gint a, guint8* e, int e_length1, gboolean exc, const gchar* n, gint o, gint l) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_if_fail (n != NULL);
	memset (self, 0, sizeof (dataTestData));
	_tmp0_ = d;
	_tmp0__length1 = d_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup9 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	(*self).data = (g_free ((*self).data), NULL);
	(*self).data = _tmp1_;
	(*self).data_length1 = _tmp1__length1;
	(*self)._data_size_ = (*self).data_length1;
	_tmp2_ = a;
	(*self).alignment = _tmp2_;
	_tmp3_ = e;
	_tmp3__length1 = e_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup10 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	(*self).expected = (g_free ((*self).expected), NULL);
	(*self).expected = _tmp4_;
	(*self).expected_length1 = _tmp4__length1;
	(*self)._expected_size_ = (*self).expected_length1;
	_tmp5_ = exc;
	(*self).expect_exception = _tmp5_;
	_tmp6_ = n;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*self).name);
	(*self).name = _tmp7_;
	_tmp8_ = o;
	(*self).offset = _tmp8_;
	_tmp9_ = l;
	(*self).length = _tmp9_;
}


static guint8* _vala_array_dup11 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static guint8* _vala_array_dup12 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void data_test_data_copy (const dataTestData* self, dataTestData* dest) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	_tmp0_ = (*self).data;
	_tmp0__length1 = (*self).data_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup11 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	(*dest).data = (g_free ((*dest).data), NULL);
	(*dest).data = _tmp1_;
	(*dest).data_length1 = _tmp1__length1;
	(*dest)._data_size_ = (*dest).data_length1;
	_tmp2_ = (*self).alignment;
	(*dest).alignment = _tmp2_;
	_tmp3_ = (*self).expected;
	_tmp3__length1 = (*self).expected_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup12 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	(*dest).expected = (g_free ((*dest).expected), NULL);
	(*dest).expected = _tmp4_;
	(*dest).expected_length1 = _tmp4__length1;
	(*dest)._expected_size_ = (*dest).expected_length1;
	_tmp5_ = (*self).expect_exception;
	(*dest).expect_exception = _tmp5_;
	_tmp6_ = (*self).name;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp7_;
	_tmp8_ = (*self).offset;
	(*dest).offset = _tmp8_;
	_tmp9_ = (*self).length;
	(*dest).length = _tmp9_;
}


void data_test_data_destroy (dataTestData* self) {
	(*self).data = (g_free ((*self).data), NULL);
	(*self).expected = (g_free ((*self).expected), NULL);
	_g_free0 ((*self).name);
}


dataTestData* data_test_data_dup (const dataTestData* self) {
	dataTestData* dup;
	dup = g_new0 (dataTestData, 1);
	data_test_data_copy (self, dup);
	return dup;
}


void data_test_data_free (dataTestData* self) {
	data_test_data_destroy (self);
	g_free (self);
}


GType data_test_data_get_type (void) {
	static volatile gsize data_test_data_type_id__volatile = 0;
	if (g_once_init_enter (&data_test_data_type_id__volatile)) {
		GType data_test_data_type_id;
		data_test_data_type_id = g_boxed_type_register_static ("dataTestData", (GBoxedCopyFunc) data_test_data_dup, (GBoxedFreeFunc) data_test_data_free);
		g_once_init_leave (&data_test_data_type_id__volatile, data_test_data_type_id);
	}
	return data_test_data_type_id__volatile;
}


inline void named_assert_data (const gchar* name, guint8* expected, int expected_length1, guint8* _result_, int _result__length1) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (name != NULL);
	_tmp0_ = expected;
	_tmp0__length1 = expected_length1;
	_tmp1_ = _result_;
	_tmp1__length1 = _result__length1;
	_tmp2_ = uint8_array_equal (_tmp0_, _tmp0__length1, _tmp1_, _tmp1__length1);
	if (!_tmp2_) {
		const gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		guint8* _tmp5_;
		gint _tmp5__length1;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		const gchar* _tmp8_ = NULL;
		guint8* _tmp9_;
		gint _tmp9__length1;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		_tmp3_ = name;
		_tmp4_ = string_to_string (_tmp3_);
		_tmp5_ = _result_;
		_tmp5__length1 = _result__length1;
		_tmp6_ = uint8_array_to_string (_tmp5_, _tmp5__length1);
		_tmp7_ = _tmp6_;
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = expected;
		_tmp9__length1 = expected_length1;
		_tmp10_ = uint8_array_to_string (_tmp9_, _tmp9__length1);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_to_string (_tmp11_);
		_tmp13_ = g_strconcat ("[", _tmp4_, "] result [", _tmp8_, "] != expected [", _tmp12_, "]", NULL);
		_tmp14_ = _tmp13_;
		g_error ("testbinreader.vala:367: %s", _tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp7_);
	}
}


gchar* uint8_array_to_string (guint8* data, int data_length1) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _result_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	_tmp0_ = g_strdup ("");
	_result_ = _tmp0_;
	_tmp1_ = data;
	_tmp1__length1 = data_length1;
	{
		guint8* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
		d_collection = _tmp1_;
		d_collection_length1 = _tmp1__length1;
		for (d_it = 0; d_it < _tmp1__length1; d_it = d_it + 1) {
			guint8 d = 0U;
			d = d_collection[d_it];
			{
				const gchar* _tmp2_;
				guint8 _tmp3_;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp2_ = _result_;
				_tmp3_ = d;
				_tmp4_ = g_strdup_printf ("'%02X', ", (guint) _tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat (_tmp2_, _tmp5_, NULL);
				_g_free0 (_result_);
				_result_ = _tmp6_;
				_g_free0 (_tmp5_);
			}
		}
	}
	result = _result_;
	return result;
}


gboolean uint8_array_equal (guint8* a, int a_length1, guint8* b, int b_length1) {
	gboolean result = FALSE;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	_tmp0_ = a;
	_tmp0__length1 = a_length1;
	_tmp1_ = b;
	_tmp1__length1 = b_length1;
	if (_tmp0__length1 != _tmp1__length1) {
		result = FALSE;
		return result;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				guint8* _tmp6_;
				gint _tmp6__length1;
				guint8* _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				guint8 _tmp9_;
				guint8* _tmp10_;
				gint _tmp10__length1;
				gint _tmp11_;
				guint8 _tmp12_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = a;
				_tmp6__length1 = a_length1;
				if (!(_tmp5_ < _tmp6__length1)) {
					break;
				}
				_tmp7_ = a;
				_tmp7__length1 = a_length1;
				_tmp8_ = i;
				_tmp9_ = _tmp7_[_tmp8_];
				_tmp10_ = b;
				_tmp10__length1 = b_length1;
				_tmp11_ = i;
				_tmp12_ = _tmp10_[_tmp11_];
				if (_tmp9_ != _tmp12_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


void test_data (dataTestData* datas, int datas_length1) {
	dataTestData* _tmp0_;
	gint _tmp0__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = datas;
	_tmp0__length1 = datas_length1;
	{
		dataTestData* data_collection = NULL;
		gint data_collection_length1 = 0;
		gint _data_collection_size_ = 0;
		gint data_it = 0;
		data_collection = _tmp0_;
		data_collection_length1 = _tmp0__length1;
		for (data_it = 0; data_it < _tmp0__length1; data_it = data_it + 1) {
			dataTestData _tmp1_ = {0};
			dataTestData data = {0};
			data_test_data_copy (&data_collection[data_it], &_tmp1_);
			data = _tmp1_;
			{
				dataTestData _tmp2_;
				guint8* _tmp3_;
				gint _tmp3__length1;
				FsoFrameworkBinReader* _tmp4_;
				FsoFrameworkBinReader* reader;
				gboolean caught;
				guint8* _tmp5_ = NULL;
				guint8* _result_;
				gint _result__length1;
				gint __result__size_;
				dataTestData _tmp24_;
				gboolean _tmp25_;
				_tmp2_ = data;
				_tmp3_ = _tmp2_.data;
				_tmp3__length1 = _tmp2_.data_length1;
				_tmp4_ = fso_framework_bin_reader_new (_tmp3_, _tmp3__length1, 0, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
				reader = _tmp4_;
				caught = FALSE;
				_tmp5_ = g_new0 (guint8, 0);
				_result_ = _tmp5_;
				_result__length1 = 0;
				__result__size_ = _result__length1;
				{
					FsoFrameworkBinReader* _tmp6_;
					dataTestData _tmp7_;
					gint _tmp8_;
					dataTestData _tmp9_;
					gint _tmp10_;
					gint _tmp11_ = 0;
					guint8* _tmp12_ = NULL;
					guint8* _tmp13_;
					gint _tmp13__length1;
					gint __tmp13__size_;
					_tmp6_ = reader;
					_tmp7_ = data;
					_tmp8_ = _tmp7_.offset;
					_tmp9_ = data;
					_tmp10_ = _tmp9_.length;
					_tmp12_ = fso_framework_bin_reader_get_data (_tmp6_, _tmp8_, _tmp10_, &_tmp11_, &_inner_error_);
					_tmp13_ = _tmp12_;
					_tmp13__length1 = _tmp11_;
					__tmp13__size_ = _tmp13__length1;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
							goto __catch4_fso_framework_bin_reader_error;
						}
						_result_ = (g_free (_result_), NULL);
						_g_object_unref0 (reader);
						data_test_data_destroy (&data);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_result_ = (g_free (_result_), NULL);
					_result_ = _tmp13_;
					_result__length1 = _tmp13__length1;
					__result__size_ = _result__length1;
				}
				goto __finally4;
				__catch4_fso_framework_bin_reader_error:
				{
					GError* e = NULL;
					dataTestData _tmp14_;
					gboolean _tmp15_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp14_ = data;
					_tmp15_ = _tmp14_.expect_exception;
					if (!_tmp15_) {
						dataTestData _tmp16_;
						const gchar* _tmp17_;
						const gchar* _tmp18_ = NULL;
						GError* _tmp19_;
						const gchar* _tmp20_;
						const gchar* _tmp21_ = NULL;
						gchar* _tmp22_ = NULL;
						gchar* _tmp23_;
						_tmp16_ = data;
						_tmp17_ = _tmp16_.name;
						_tmp18_ = string_to_string (_tmp17_);
						_tmp19_ = e;
						_tmp20_ = _tmp19_->message;
						_tmp21_ = string_to_string (_tmp20_);
						_tmp22_ = g_strconcat ("[", _tmp18_, "] doesn't expect an exception: ", _tmp21_, NULL);
						_tmp23_ = _tmp22_;
						g_error ("testbinreader.vala:404: %s", _tmp23_);
						_g_free0 (_tmp23_);
					}
					caught = TRUE;
					_g_error_free0 (e);
				}
				__finally4:
				if (_inner_error_ != NULL) {
					_result_ = (g_free (_result_), NULL);
					_g_object_unref0 (reader);
					data_test_data_destroy (&data);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp24_ = data;
				_tmp25_ = _tmp24_.expect_exception;
				if (!_tmp25_) {
					dataTestData _tmp26_;
					const gchar* _tmp27_;
					dataTestData _tmp28_;
					guint8* _tmp29_;
					gint _tmp29__length1;
					guint8* _tmp30_;
					gint _tmp30__length1;
					_tmp26_ = data;
					_tmp27_ = _tmp26_.name;
					_tmp28_ = data;
					_tmp29_ = _tmp28_.expected;
					_tmp29__length1 = _tmp28_.expected_length1;
					_tmp30_ = _result_;
					_tmp30__length1 = _result__length1;
					named_assert_data (_tmp27_, _tmp29_, _tmp29__length1, _tmp30_, _tmp30__length1);
				} else {
					gboolean _tmp31_ = FALSE;
					dataTestData _tmp32_;
					gboolean _tmp33_;
					gboolean _tmp35_;
					_tmp32_ = data;
					_tmp33_ = _tmp32_.expect_exception;
					if (_tmp33_) {
						gboolean _tmp34_;
						_tmp34_ = caught;
						_tmp31_ = !_tmp34_;
					} else {
						_tmp31_ = FALSE;
					}
					_tmp35_ = _tmp31_;
					if (_tmp35_) {
						dataTestData _tmp36_;
						const gchar* _tmp37_;
						const gchar* _tmp38_ = NULL;
						gchar* _tmp39_ = NULL;
						gchar* _tmp40_;
						_tmp36_ = data;
						_tmp37_ = _tmp36_.name;
						_tmp38_ = string_to_string (_tmp37_);
						_tmp39_ = g_strconcat ("[", _tmp38_, "] expected exception", NULL);
						_tmp40_ = _tmp39_;
						g_error ("testbinreader.vala:410: %s", _tmp40_);
						_g_free0 (_tmp40_);
					}
				}
				_result_ = (g_free (_result_), NULL);
				_g_object_unref0 (reader);
				data_test_data_destroy (&data);
			}
		}
	}
}


static void _vala_dataTestData_array_free (dataTestData* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			data_test_data_destroy (&array[i]);
		}
	}
	g_free (array);
}


void test_datas (void) {
	guint8* _tmp0_ = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_ = NULL;
	guint8* _tmp3_;
	gint _tmp3__length1;
	dataTestData _tmp4_ = {0};
	guint8* _tmp5_ = NULL;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8* _tmp7_ = NULL;
	guint8* _tmp8_;
	gint _tmp8__length1;
	dataTestData _tmp9_ = {0};
	guint8* _tmp10_ = NULL;
	guint8* _tmp11_;
	gint _tmp11__length1;
	guint8* _tmp12_ = NULL;
	guint8* _tmp13_;
	gint _tmp13__length1;
	dataTestData _tmp14_ = {0};
	guint8* _tmp15_ = NULL;
	guint8* _tmp16_;
	gint _tmp16__length1;
	guint8* _tmp17_ = NULL;
	guint8* _tmp18_;
	gint _tmp18__length1;
	dataTestData _tmp19_ = {0};
	dataTestData* _tmp20_ = NULL;
	dataTestData* _tmp21_;
	gint _tmp21__length1;
	dataTestData* tests;
	gint tests_length1;
	gint _tests_size_;
	_tmp0_ = g_new0 (guint8, 0);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	_tmp2_ = g_new0 (guint8, 0);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 0;
	data_test_data_init (&_tmp4_, _tmp1_, 0, 4, _tmp3_, 0, FALSE, "empty", 0, 0);
	_tmp5_ = g_new0 (guint8, 4);
	_tmp5_[0] = (guint8) 0;
	_tmp5_[1] = (guint8) 1;
	_tmp5_[2] = (guint8) 2;
	_tmp5_[3] = (guint8) 3;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 4;
	_tmp7_ = g_new0 (guint8, 4);
	_tmp7_[0] = (guint8) 0;
	_tmp7_[1] = (guint8) 1;
	_tmp7_[2] = (guint8) 2;
	_tmp7_[3] = (guint8) 3;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 4;
	data_test_data_init (&_tmp9_, _tmp6_, 4, 4, _tmp8_, 4, FALSE, "full", 0, 4);
	_tmp10_ = g_new0 (guint8, 8);
	_tmp10_[0] = (guint8) 0;
	_tmp10_[1] = (guint8) 0;
	_tmp10_[2] = (guint8) 0;
	_tmp10_[3] = (guint8) 0;
	_tmp10_[4] = (guint8) 0;
	_tmp10_[5] = (guint8) 1;
	_tmp10_[6] = (guint8) 2;
	_tmp10_[7] = (guint8) 3;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 8;
	_tmp12_ = g_new0 (guint8, 4);
	_tmp12_[0] = (guint8) 0;
	_tmp12_[1] = (guint8) 1;
	_tmp12_[2] = (guint8) 2;
	_tmp12_[3] = (guint8) 3;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 4;
	data_test_data_init (&_tmp14_, _tmp11_, 8, 4, _tmp13_, 4, FALSE, "full offset 4", 4, 4);
	_tmp15_ = g_new0 (guint8, 8);
	_tmp15_[0] = (guint8) 0;
	_tmp15_[1] = (guint8) 1;
	_tmp15_[2] = (guint8) 2;
	_tmp15_[3] = (guint8) 3;
	_tmp15_[4] = (guint8) 0;
	_tmp15_[5] = (guint8) 0;
	_tmp15_[6] = (guint8) 0;
	_tmp15_[7] = (guint8) 0;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 8;
	_tmp17_ = g_new0 (guint8, 4);
	_tmp17_[0] = (guint8) 0;
	_tmp17_[1] = (guint8) 1;
	_tmp17_[2] = (guint8) 2;
	_tmp17_[3] = (guint8) 3;
	_tmp18_ = _tmp17_;
	_tmp18__length1 = 4;
	data_test_data_init (&_tmp19_, _tmp16_, 8, 4, _tmp18_, 4, FALSE, "full", 0, 4);
	_tmp20_ = g_new0 (dataTestData, 4);
	_tmp20_[0] = _tmp4_;
	_tmp20_[1] = _tmp9_;
	_tmp20_[2] = _tmp14_;
	_tmp20_[3] = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp21__length1 = 4;
	_tmp18_ = (g_free (_tmp18_), NULL);
	_tmp16_ = (g_free (_tmp16_), NULL);
	_tmp13_ = (g_free (_tmp13_), NULL);
	_tmp11_ = (g_free (_tmp11_), NULL);
	_tmp8_ = (g_free (_tmp8_), NULL);
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp1_ = (g_free (_tmp1_), NULL);
	tests = _tmp21_;
	tests_length1 = _tmp21__length1;
	_tests_size_ = tests_length1;
	test_data (tests, tests_length1);
	tests = (_vala_dataTestData_array_free (tests, tests_length1), NULL);
}


static guint8* _vala_array_dup13 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void bitfields_test_data_init (bitfieldsTestData *self, guint8* d, int d_length1, gint a, GDataStreamByteOrder e, guint64 exp, gboolean excp, gint pos, gint off, gint l, const gchar* n) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	GDataStreamByteOrder _tmp3_;
	guint64 _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (n != NULL);
	memset (self, 0, sizeof (bitfieldsTestData));
	_tmp0_ = d;
	_tmp0__length1 = d_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup13 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	(*self).data = (g_free ((*self).data), NULL);
	(*self).data = _tmp1_;
	(*self).data_length1 = _tmp1__length1;
	(*self)._data_size_ = (*self).data_length1;
	_tmp2_ = a;
	(*self).alignment = _tmp2_;
	_tmp3_ = e;
	(*self).endianess = _tmp3_;
	_tmp4_ = exp;
	(*self).expected = _tmp4_;
	_tmp5_ = excp;
	(*self).expect_exception = _tmp5_;
	_tmp6_ = pos;
	(*self).position = _tmp6_;
	_tmp7_ = off;
	(*self).offset = _tmp7_;
	_tmp8_ = l;
	(*self).length = _tmp8_;
	_tmp9_ = n;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 ((*self).name);
	(*self).name = _tmp10_;
}


static guint8* _vala_array_dup14 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void bitfields_test_data_copy (const bitfieldsTestData* self, bitfieldsTestData* dest) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	GDataStreamByteOrder _tmp3_;
	guint64 _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	_tmp0_ = (*self).data;
	_tmp0__length1 = (*self).data_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup14 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	(*dest).data = (g_free ((*dest).data), NULL);
	(*dest).data = _tmp1_;
	(*dest).data_length1 = _tmp1__length1;
	(*dest)._data_size_ = (*dest).data_length1;
	_tmp2_ = (*self).alignment;
	(*dest).alignment = _tmp2_;
	_tmp3_ = (*self).endianess;
	(*dest).endianess = _tmp3_;
	_tmp4_ = (*self).expected;
	(*dest).expected = _tmp4_;
	_tmp5_ = (*self).expect_exception;
	(*dest).expect_exception = _tmp5_;
	_tmp6_ = (*self).position;
	(*dest).position = _tmp6_;
	_tmp7_ = (*self).offset;
	(*dest).offset = _tmp7_;
	_tmp8_ = (*self).length;
	(*dest).length = _tmp8_;
	_tmp9_ = (*self).name;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp10_;
}


void bitfields_test_data_destroy (bitfieldsTestData* self) {
	(*self).data = (g_free ((*self).data), NULL);
	_g_free0 ((*self).name);
}


bitfieldsTestData* bitfields_test_data_dup (const bitfieldsTestData* self) {
	bitfieldsTestData* dup;
	dup = g_new0 (bitfieldsTestData, 1);
	bitfields_test_data_copy (self, dup);
	return dup;
}


void bitfields_test_data_free (bitfieldsTestData* self) {
	bitfields_test_data_destroy (self);
	g_free (self);
}


GType bitfields_test_data_get_type (void) {
	static volatile gsize bitfields_test_data_type_id__volatile = 0;
	if (g_once_init_enter (&bitfields_test_data_type_id__volatile)) {
		GType bitfields_test_data_type_id;
		bitfields_test_data_type_id = g_boxed_type_register_static ("bitfieldsTestData", (GBoxedCopyFunc) bitfields_test_data_dup, (GBoxedFreeFunc) bitfields_test_data_free);
		g_once_init_leave (&bitfields_test_data_type_id__volatile, bitfields_test_data_type_id);
	}
	return bitfields_test_data_type_id__volatile;
}


void run_test_bitfields (bitfieldsTestData* datas, int datas_length1) {
	bitfieldsTestData* _tmp0_;
	gint _tmp0__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = datas;
	_tmp0__length1 = datas_length1;
	{
		bitfieldsTestData* data_collection = NULL;
		gint data_collection_length1 = 0;
		gint _data_collection_size_ = 0;
		gint data_it = 0;
		data_collection = _tmp0_;
		data_collection_length1 = _tmp0__length1;
		for (data_it = 0; data_it < _tmp0__length1; data_it = data_it + 1) {
			bitfieldsTestData _tmp1_ = {0};
			bitfieldsTestData data = {0};
			bitfields_test_data_copy (&data_collection[data_it], &_tmp1_);
			data = _tmp1_;
			{
				guint64 _result_;
				bitfieldsTestData _tmp2_;
				guint8* _tmp3_;
				gint _tmp3__length1;
				bitfieldsTestData _tmp4_;
				gint _tmp5_;
				bitfieldsTestData _tmp6_;
				GDataStreamByteOrder _tmp7_;
				FsoFrameworkBinReader* _tmp8_;
				FsoFrameworkBinReader* reader;
				gboolean caught;
				bitfieldsTestData _tmp28_;
				gboolean _tmp29_;
				_result_ = (guint64) 0;
				_tmp2_ = data;
				_tmp3_ = _tmp2_.data;
				_tmp3__length1 = _tmp2_.data_length1;
				_tmp4_ = data;
				_tmp5_ = _tmp4_.alignment;
				_tmp6_ = data;
				_tmp7_ = _tmp6_.endianess;
				_tmp8_ = fso_framework_bin_reader_new (_tmp3_, _tmp3__length1, _tmp5_, _tmp7_);
				reader = _tmp8_;
				caught = FALSE;
				{
					FsoFrameworkBinReader* _tmp9_;
					bitfieldsTestData _tmp10_;
					gint _tmp11_;
					bitfieldsTestData _tmp12_;
					gint _tmp13_;
					bitfieldsTestData _tmp14_;
					gint _tmp15_;
					guint64 _tmp16_ = 0ULL;
					guint64 _tmp17_;
					_tmp9_ = reader;
					_tmp10_ = data;
					_tmp11_ = _tmp10_.position;
					_tmp12_ = data;
					_tmp13_ = _tmp12_.offset;
					_tmp14_ = data;
					_tmp15_ = _tmp14_.length;
					_tmp16_ = fso_framework_bin_reader_get_bits (_tmp9_, _tmp11_, _tmp13_, _tmp15_, &_inner_error_);
					_tmp17_ = _tmp16_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
							goto __catch5_fso_framework_bin_reader_error;
						}
						_g_object_unref0 (reader);
						bitfields_test_data_destroy (&data);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_result_ = _tmp17_;
				}
				goto __finally5;
				__catch5_fso_framework_bin_reader_error:
				{
					GError* e = NULL;
					bitfieldsTestData _tmp18_;
					gboolean _tmp19_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp18_ = data;
					_tmp19_ = _tmp18_.expect_exception;
					if (!_tmp19_) {
						bitfieldsTestData _tmp20_;
						const gchar* _tmp21_;
						const gchar* _tmp22_ = NULL;
						GError* _tmp23_;
						const gchar* _tmp24_;
						const gchar* _tmp25_ = NULL;
						gchar* _tmp26_ = NULL;
						gchar* _tmp27_;
						_tmp20_ = data;
						_tmp21_ = _tmp20_.name;
						_tmp22_ = string_to_string (_tmp21_);
						_tmp23_ = e;
						_tmp24_ = _tmp23_->message;
						_tmp25_ = string_to_string (_tmp24_);
						_tmp26_ = g_strconcat ("[", _tmp22_, "] doesn't expect an exception: ", _tmp25_, NULL);
						_tmp27_ = _tmp26_;
						g_error ("testbinreader.vala:464: %s", _tmp27_);
						_g_free0 (_tmp27_);
					}
					caught = TRUE;
					_g_error_free0 (e);
				}
				__finally5:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (reader);
					bitfields_test_data_destroy (&data);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp28_ = data;
				_tmp29_ = _tmp28_.expect_exception;
				if (!_tmp29_) {
					bitfieldsTestData _tmp30_;
					const gchar* _tmp31_;
					guint64 _tmp32_;
					bitfieldsTestData _tmp33_;
					guint64 _tmp34_;
					_tmp30_ = data;
					_tmp31_ = _tmp30_.name;
					_tmp32_ = _result_;
					_tmp33_ = data;
					_tmp34_ = _tmp33_.expected;
					named_assert_uint64 (_tmp31_, _tmp32_, _tmp34_);
				} else {
					gboolean _tmp35_ = FALSE;
					bitfieldsTestData _tmp36_;
					gboolean _tmp37_;
					gboolean _tmp39_;
					_tmp36_ = data;
					_tmp37_ = _tmp36_.expect_exception;
					if (_tmp37_) {
						gboolean _tmp38_;
						_tmp38_ = caught;
						_tmp35_ = !_tmp38_;
					} else {
						_tmp35_ = FALSE;
					}
					_tmp39_ = _tmp35_;
					if (_tmp39_) {
						bitfieldsTestData _tmp40_;
						const gchar* _tmp41_;
						const gchar* _tmp42_ = NULL;
						gchar* _tmp43_ = NULL;
						gchar* _tmp44_;
						_tmp40_ = data;
						_tmp41_ = _tmp40_.name;
						_tmp42_ = string_to_string (_tmp41_);
						_tmp43_ = g_strconcat ("[", _tmp42_, "] expected exception", NULL);
						_tmp44_ = _tmp43_;
						g_error ("testbinreader.vala:470: %s", _tmp44_);
						_g_free0 (_tmp44_);
					}
				}
				_g_object_unref0 (reader);
				bitfields_test_data_destroy (&data);
			}
		}
	}
}


inline void named_assert_uint64 (const gchar* name, guint64 _result_, guint64 expected) {
	guint64 _tmp0_;
	guint64 _tmp1_;
	g_return_if_fail (name != NULL);
	_tmp0_ = expected;
	_tmp1_ = _result_;
	if (_tmp0_ != _tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		guint64 _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		guint64 _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp2_ = name;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = _result_;
		_tmp5_ = g_strdup_printf ("%" G_GUINT64_FORMAT, _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = expected;
		_tmp8_ = g_strdup_printf ("%" G_GUINT64_FORMAT, _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("[", _tmp3_, "] result [", _tmp6_, "] != expected [", _tmp9_, "]", NULL);
		_tmp11_ = _tmp10_;
		g_error ("testbinreader.vala:477: %s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp6_);
	}
}


static void _vala_bitfieldsTestData_array_free (bitfieldsTestData* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			bitfields_test_data_destroy (&array[i]);
		}
	}
	g_free (array);
}


void test_bitfields (void) {
	guint8* _tmp0_ = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	bitfieldsTestData _tmp2_ = {0};
	guint8* _tmp3_ = NULL;
	guint8* _tmp4_;
	gint _tmp4__length1;
	bitfieldsTestData _tmp5_ = {0};
	guint8* _tmp6_ = NULL;
	guint8* _tmp7_;
	gint _tmp7__length1;
	bitfieldsTestData _tmp8_ = {0};
	bitfieldsTestData* _tmp9_ = NULL;
	bitfieldsTestData* _tmp10_;
	gint _tmp10__length1;
	bitfieldsTestData* tests;
	gint tests_length1;
	gint _tests_size_;
	_tmp0_ = g_new0 (guint8, 2);
	_tmp0_[0] = (guint8) 0x01;
	_tmp0_[1] = (guint8) 0x20;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 2;
	bitfields_test_data_init (&_tmp2_, _tmp1_, 2, 4, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, (guint64) 0x12, FALSE, 0, 4, 8, "offset 0.4 length 8");
	_tmp3_ = g_new0 (guint8, 5);
	_tmp3_[0] = (guint8) 0xFF;
	_tmp3_[1] = (guint8) 0x11;
	_tmp3_[2] = (guint8) 0x22;
	_tmp3_[3] = (guint8) 0x33;
	_tmp3_[4] = (guint8) 0xFF;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 5;
	bitfields_test_data_init (&_tmp5_, _tmp4_, 5, 0, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, (guint64) 0x112233, FALSE, 1, 0, 24, "offset 1.0 length 24");
	_tmp6_ = g_new0 (guint8, 5);
	_tmp6_[0] = (guint8) 0xFF;
	_tmp6_[1] = (guint8) 0x11;
	_tmp6_[2] = (guint8) 0x22;
	_tmp6_[3] = (guint8) 0x33;
	_tmp6_[4] = (guint8) 0xFF;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 5;
	bitfields_test_data_init (&_tmp8_, _tmp7_, 5, 0, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN, (guint64) 0x12233, FALSE, 1, 4, 20, "offset 1.4 length 20");
	_tmp9_ = g_new0 (bitfieldsTestData, 3);
	_tmp9_[0] = _tmp2_;
	_tmp9_[1] = _tmp5_;
	_tmp9_[2] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 3;
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp1_ = (g_free (_tmp1_), NULL);
	tests = _tmp10_;
	tests_length1 = _tmp10__length1;
	_tests_size_ = tests_length1;
	run_test_bitfields (tests, tests_length1);
	tests = (_vala_bitfieldsTestData_array_free (tests, tests_length1), NULL);
}


static void _test_strings_gcallback (void) {
	test_strings ();
}


static void _test_datas_gcallback (void) {
	test_datas ();
}


static void _test_uint8_le_gcallback (void) {
	test_uint8_le ();
}


static void _test_uint16_le_gcallback (void) {
	test_uint16_le ();
}


static void _test_uint32_le_gcallback (void) {
	test_uint32_le ();
}


static void _test_uint8_be_gcallback (void) {
	test_uint8_be ();
}


static void _test_uint16_be_gcallback (void) {
	test_uint16_be ();
}


static void _test_uint32_be_gcallback (void) {
	test_uint32_be ();
}


static void _test_exception_uint8_gcallback (void) {
	test_exception_uint8 ();
}


static void _test_exception_uint16_gcallback (void) {
	test_exception_uint16 ();
}


static void _test_exception_uint32_gcallback (void) {
	test_exception_uint32 ();
}


static void _test_bitfields_gcallback (void) {
	test_bitfields ();
}


void _vala_main (gchar** args, int args_length1) {
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/FsoFramework.BinReader/String", _test_strings_gcallback);
	g_test_add_func ("/FsoFramework.BinReader/Data", _test_datas_gcallback);
	g_test_add_func ("/FsoFramework.BinReader/LittleEndian/uint8", _test_uint8_le_gcallback);
	g_test_add_func ("/FsoFramework.BinReader/LittleEndian/uint16", _test_uint16_le_gcallback);
	g_test_add_func ("/FsoFramework.BinReader/LittleEndian/uint32", _test_uint32_le_gcallback);
	g_test_add_func ("/FsoFramework.BinReader/BigEndian/uint8", _test_uint8_be_gcallback);
	g_test_add_func ("/FsoFramework.BinReader/BigEndian/uint16", _test_uint16_be_gcallback);
	g_test_add_func ("/FsoFramework.BinReader/BigEndian/uint32", _test_uint32_be_gcallback);
	g_test_add_func ("/FsoFramework.BinReader/Exception/uint8", _test_exception_uint8_gcallback);
	g_test_add_func ("/FsoFramework.BinReader/Exception/uint16", _test_exception_uint16_gcallback);
	g_test_add_func ("/FsoFramework.BinReader/Exception/uint32", _test_exception_uint32_gcallback);
	g_test_add_func ("/FsoFramework.BinReader/Bitfields", _test_bitfields_gcallback);
	g_test_run ();
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	_vala_main (argv, argc);
	return 0;
}



