/* vfs-volume-impl-thunar-vfs.c generated by valac 0.10.4, the Vala compiler
 * generated from vfs-volume-impl-thunar-vfs.vala, do not modify */

/*
 * Desktop Agnostic Library: VFS Volume implementation (Thunar VFS).
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/vfs.h>
#include <thunar-vfs/thunar-vfs.h>
#include <gtk/gtk.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS (desktop_agnostic_vfs_volume_thunar_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS, DesktopAgnosticVFSVolumeThunarVFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS, DesktopAgnosticVFSVolumeThunarVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS, DesktopAgnosticVFSVolumeThunarVFSClass))

typedef struct _DesktopAgnosticVFSVolumeThunarVFS DesktopAgnosticVFSVolumeThunarVFS;
typedef struct _DesktopAgnosticVFSVolumeThunarVFSClass DesktopAgnosticVFSVolumeThunarVFSClass;
typedef struct _DesktopAgnosticVFSVolumeThunarVFSPrivate DesktopAgnosticVFSVolumeThunarVFSPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _thunar_vfs_path_unref0(var) ((var == NULL) ? NULL : (var = (thunar_vfs_path_unref (var), NULL)))

#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_THUNAR_VFS (desktop_agnostic_vfs_volume_monitor_thunar_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_THUNAR_VFS, DesktopAgnosticVFSVolumeMonitorThunarVFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_THUNAR_VFS, DesktopAgnosticVFSVolumeMonitorThunarVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_MONITOR_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_MONITOR_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_THUNAR_VFS, DesktopAgnosticVFSVolumeMonitorThunarVFSClass))

typedef struct _DesktopAgnosticVFSVolumeMonitorThunarVFS DesktopAgnosticVFSVolumeMonitorThunarVFS;
typedef struct _DesktopAgnosticVFSVolumeMonitorThunarVFSClass DesktopAgnosticVFSVolumeMonitorThunarVFSClass;
typedef struct _DesktopAgnosticVFSVolumeMonitorThunarVFSPrivate DesktopAgnosticVFSVolumeMonitorThunarVFSPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _DesktopAgnosticVFSVolumeThunarVFS {
	GObject parent_instance;
	DesktopAgnosticVFSVolumeThunarVFSPrivate * priv;
};

struct _DesktopAgnosticVFSVolumeThunarVFSClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSVolumeThunarVFSPrivate {
	ThunarVfsVolume* vol;
	DesktopAgnosticVFSFile* _uri;
	DesktopAgnosticVFSVolumeCallback _mount_callback;
	gpointer _mount_callback_target;
	GDestroyNotify _mount_callback_target_destroy_notify;
	DesktopAgnosticVFSVolumeCallback _unmount_callback;
	gpointer _unmount_callback_target;
	GDestroyNotify _unmount_callback_target_destroy_notify;
	DesktopAgnosticVFSVolumeCallback _eject_callback;
	gpointer _eject_callback_target;
	GDestroyNotify _eject_callback_target_destroy_notify;
};

struct _DesktopAgnosticVFSVolumeMonitorThunarVFS {
	GObject parent_instance;
	DesktopAgnosticVFSVolumeMonitorThunarVFSPrivate * priv;
};

struct _DesktopAgnosticVFSVolumeMonitorThunarVFSClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSVolumeMonitorThunarVFSPrivate {
	ThunarVfsVolumeManager* manager;
	GHashTable* _volumes;
};


static gpointer desktop_agnostic_vfs_volume_thunar_vfs_parent_class = NULL;
static DesktopAgnosticVFSVolumeIface* desktop_agnostic_vfs_volume_thunar_vfs_desktop_agnostic_vfs_volume_parent_iface = NULL;
static gpointer desktop_agnostic_vfs_volume_monitor_thunar_vfs_parent_class = NULL;
static DesktopAgnosticVFSVolumeMonitorIface* desktop_agnostic_vfs_volume_monitor_thunar_vfs_desktop_agnostic_vfs_volume_monitor_parent_iface = NULL;

GType desktop_agnostic_vfs_volume_thunar_vfs_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS, DesktopAgnosticVFSVolumeThunarVFSPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_IMPLEMENTATION,
	DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_NAME,
	DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_URI,
	DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_ICON
};
DesktopAgnosticVFSVolumeThunarVFS* desktop_agnostic_vfs_volume_thunar_vfs_new_for_implementation (ThunarVfsVolume* impl);
DesktopAgnosticVFSVolumeThunarVFS* desktop_agnostic_vfs_volume_thunar_vfs_construct_for_implementation (GType object_type, ThunarVfsVolume* impl);
static gboolean desktop_agnostic_vfs_volume_thunar_vfs_real_is_mounted (DesktopAgnosticVFSVolume* base);
gboolean desktop_agnostic_vfs_volume_thunar_vfs_do_mount (DesktopAgnosticVFSVolumeThunarVFS* self);
static void desktop_agnostic_vfs_volume_thunar_vfs_real_mount (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
static gboolean _desktop_agnostic_vfs_volume_thunar_vfs_do_mount_gsource_func (gpointer self);
static gboolean desktop_agnostic_vfs_volume_thunar_vfs_real_mount_finish (DesktopAgnosticVFSVolume* base, GError** error);
gboolean desktop_agnostic_vfs_volume_thunar_vfs_do_unmount (DesktopAgnosticVFSVolumeThunarVFS* self);
static void desktop_agnostic_vfs_volume_thunar_vfs_real_unmount (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
static gboolean _desktop_agnostic_vfs_volume_thunar_vfs_do_unmount_gsource_func (gpointer self);
static gboolean desktop_agnostic_vfs_volume_thunar_vfs_real_unmount_finish (DesktopAgnosticVFSVolume* base, GError** error);
static gboolean desktop_agnostic_vfs_volume_thunar_vfs_real_can_eject (DesktopAgnosticVFSVolume* base);
gboolean desktop_agnostic_vfs_volume_thunar_vfs_do_eject (DesktopAgnosticVFSVolumeThunarVFS* self);
static void desktop_agnostic_vfs_volume_thunar_vfs_real_eject (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
static gboolean _desktop_agnostic_vfs_volume_thunar_vfs_do_eject_gsource_func (gpointer self);
static gboolean desktop_agnostic_vfs_volume_thunar_vfs_real_eject_finish (DesktopAgnosticVFSVolume* base, GError** error);
DesktopAgnosticVFSVolumeThunarVFS* desktop_agnostic_vfs_volume_thunar_vfs_new (void);
DesktopAgnosticVFSVolumeThunarVFS* desktop_agnostic_vfs_volume_thunar_vfs_construct (GType object_type);
static void desktop_agnostic_vfs_volume_thunar_vfs_set_implementation (DesktopAgnosticVFSVolumeThunarVFS* self, ThunarVfsVolume* value);
static void desktop_agnostic_vfs_volume_thunar_vfs_finalize (GObject* obj);
static void desktop_agnostic_vfs_volume_thunar_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_vfs_volume_thunar_vfs_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType desktop_agnostic_vfs_volume_monitor_thunar_vfs_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_THUNAR_VFS, DesktopAgnosticVFSVolumeMonitorThunarVFSPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS_IMPLEMENTATION,
	DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS_VOLUMES
};
static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_thunar_vfs_create_volume (DesktopAgnosticVFSVolumeMonitorThunarVFS* self, ThunarVfsVolume* vol);
static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_thunar_vfs_check_volume (DesktopAgnosticVFSVolumeMonitorThunarVFS* self, ThunarVfsVolume* tvol);
static void desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_mount_added (DesktopAgnosticVFSVolumeMonitorThunarVFS* self, ThunarVfsVolumeManager* manager, ThunarVfsVolume* vol);
static void desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_mount_removed (DesktopAgnosticVFSVolumeMonitorThunarVFS* self, ThunarVfsVolumeManager* manager, ThunarVfsVolume* vol);
static void desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_volumes_added (DesktopAgnosticVFSVolumeMonitorThunarVFS* self, ThunarVfsVolumeManager* manager, void* ptr);
static void desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_volumes_removed (DesktopAgnosticVFSVolumeMonitorThunarVFS* self, ThunarVfsVolumeManager* manager, void* ptr);
DesktopAgnosticVFSVolumeMonitorThunarVFS* desktop_agnostic_vfs_volume_monitor_thunar_vfs_new (void);
DesktopAgnosticVFSVolumeMonitorThunarVFS* desktop_agnostic_vfs_volume_monitor_thunar_vfs_construct (GType object_type);
static void _desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_mount_added_thunar_vfs_volume_manager_volume_mounted (ThunarVfsVolumeManager* _sender, ThunarVfsVolume* p0, gpointer self);
static void _desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_mount_removed_thunar_vfs_volume_manager_volume_unmounted (ThunarVfsVolumeManager* _sender, ThunarVfsVolume* p0, gpointer self);
static void _desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_volumes_added_thunar_vfs_volume_manager_volumes_added (ThunarVfsVolumeManager* _sender, void* p0, gpointer self);
static void _desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_volumes_removed_thunar_vfs_volume_manager_volumes_removed (ThunarVfsVolumeManager* _sender, void* p0, gpointer self);
static GObject * desktop_agnostic_vfs_volume_monitor_thunar_vfs_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void desktop_agnostic_vfs_volume_monitor_thunar_vfs_finalize (GObject* obj);
static void desktop_agnostic_vfs_volume_monitor_thunar_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);



DesktopAgnosticVFSVolumeThunarVFS* desktop_agnostic_vfs_volume_thunar_vfs_construct_for_implementation (GType object_type, ThunarVfsVolume* impl) {
	DesktopAgnosticVFSVolumeThunarVFS * self = NULL;
	g_return_val_if_fail (impl != NULL, NULL);
	self = (DesktopAgnosticVFSVolumeThunarVFS*) g_object_new (object_type, "implementation", impl, NULL);
	return self;
}


DesktopAgnosticVFSVolumeThunarVFS* desktop_agnostic_vfs_volume_thunar_vfs_new_for_implementation (ThunarVfsVolume* impl) {
	return desktop_agnostic_vfs_volume_thunar_vfs_construct_for_implementation (DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS, impl);
}


static gboolean desktop_agnostic_vfs_volume_thunar_vfs_real_is_mounted (DesktopAgnosticVFSVolume* base) {
	DesktopAgnosticVFSVolumeThunarVFS * self;
	gboolean result = FALSE;
	self = (DesktopAgnosticVFSVolumeThunarVFS*) base;
	result = thunar_vfs_volume_is_mounted (self->priv->vol);
	return result;
}


gboolean desktop_agnostic_vfs_volume_thunar_vfs_do_mount (DesktopAgnosticVFSVolumeThunarVFS* self) {
	gboolean result = FALSE;
	DesktopAgnosticVFSVolumeCallback _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->_mount_callback (self->priv->_mount_callback_target);
	self->priv->_mount_callback = (_tmp0_ = NULL, ((self->priv->_mount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_mount_callback_target_destroy_notify (self->priv->_mount_callback_target), NULL), self->priv->_mount_callback = NULL, self->priv->_mount_callback_target = NULL, self->priv->_mount_callback_target_destroy_notify = NULL), self->priv->_mount_callback_target = NULL, self->priv->_mount_callback_target_destroy_notify = NULL, _tmp0_);
	result = FALSE;
	return result;
}


static gboolean _desktop_agnostic_vfs_volume_thunar_vfs_do_mount_gsource_func (gpointer self) {
	gboolean result;
	result = desktop_agnostic_vfs_volume_thunar_vfs_do_mount (self);
	return result;
}


static void desktop_agnostic_vfs_volume_thunar_vfs_real_mount (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target) {
	DesktopAgnosticVFSVolumeThunarVFS * self;
	self = (DesktopAgnosticVFSVolumeThunarVFS*) base;
	if (self->priv->_mount_callback == NULL) {
		DesktopAgnosticVFSVolumeCallback _tmp0_;
		self->priv->_mount_callback = (_tmp0_ = callback, ((self->priv->_mount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_mount_callback_target_destroy_notify (self->priv->_mount_callback_target), NULL), self->priv->_mount_callback = NULL, self->priv->_mount_callback_target = NULL, self->priv->_mount_callback_target_destroy_notify = NULL), self->priv->_mount_callback_target = callback_target, self->priv->_mount_callback_target_destroy_notify = NULL, _tmp0_);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _desktop_agnostic_vfs_volume_thunar_vfs_do_mount_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static gboolean desktop_agnostic_vfs_volume_thunar_vfs_real_mount_finish (DesktopAgnosticVFSVolume* base, GError** error) {
	DesktopAgnosticVFSVolumeThunarVFS * self;
	gboolean result = FALSE;
	gboolean _result_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSVolumeThunarVFS*) base;
	_result_ = FALSE;
	{
		gboolean _tmp0_;
		_tmp0_ = thunar_vfs_volume_mount (self->priv->vol, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_result_ = _tmp0_;
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR, DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_MOUNT, err->message);
			{
				_g_error_free0 (err);
				goto __finally5;
			}
			_g_error_free0 (err);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _result_;
	return result;
}


gboolean desktop_agnostic_vfs_volume_thunar_vfs_do_unmount (DesktopAgnosticVFSVolumeThunarVFS* self) {
	gboolean result = FALSE;
	DesktopAgnosticVFSVolumeCallback _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->_unmount_callback (self->priv->_unmount_callback_target);
	self->priv->_unmount_callback = (_tmp0_ = NULL, ((self->priv->_unmount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_unmount_callback_target_destroy_notify (self->priv->_unmount_callback_target), NULL), self->priv->_unmount_callback = NULL, self->priv->_unmount_callback_target = NULL, self->priv->_unmount_callback_target_destroy_notify = NULL), self->priv->_unmount_callback_target = NULL, self->priv->_unmount_callback_target_destroy_notify = NULL, _tmp0_);
	result = FALSE;
	return result;
}


static gboolean _desktop_agnostic_vfs_volume_thunar_vfs_do_unmount_gsource_func (gpointer self) {
	gboolean result;
	result = desktop_agnostic_vfs_volume_thunar_vfs_do_unmount (self);
	return result;
}


static void desktop_agnostic_vfs_volume_thunar_vfs_real_unmount (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target) {
	DesktopAgnosticVFSVolumeThunarVFS * self;
	self = (DesktopAgnosticVFSVolumeThunarVFS*) base;
	if (self->priv->_unmount_callback == NULL) {
		DesktopAgnosticVFSVolumeCallback _tmp0_;
		self->priv->_unmount_callback = (_tmp0_ = callback, ((self->priv->_unmount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_unmount_callback_target_destroy_notify (self->priv->_unmount_callback_target), NULL), self->priv->_unmount_callback = NULL, self->priv->_unmount_callback_target = NULL, self->priv->_unmount_callback_target_destroy_notify = NULL), self->priv->_unmount_callback_target = callback_target, self->priv->_unmount_callback_target_destroy_notify = NULL, _tmp0_);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _desktop_agnostic_vfs_volume_thunar_vfs_do_unmount_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static gboolean desktop_agnostic_vfs_volume_thunar_vfs_real_unmount_finish (DesktopAgnosticVFSVolume* base, GError** error) {
	DesktopAgnosticVFSVolumeThunarVFS * self;
	gboolean result = FALSE;
	gboolean _result_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSVolumeThunarVFS*) base;
	_result_ = FALSE;
	{
		gboolean _tmp0_;
		_tmp0_ = thunar_vfs_volume_unmount (self->priv->vol, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_result_ = _tmp0_;
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR, DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_UNMOUNT, err->message);
			{
				_g_error_free0 (err);
				goto __finally6;
			}
			_g_error_free0 (err);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _result_;
	return result;
}


static gboolean desktop_agnostic_vfs_volume_thunar_vfs_real_can_eject (DesktopAgnosticVFSVolume* base) {
	DesktopAgnosticVFSVolumeThunarVFS * self;
	gboolean result = FALSE;
	self = (DesktopAgnosticVFSVolumeThunarVFS*) base;
	result = thunar_vfs_volume_is_ejectable (self->priv->vol);
	return result;
}


gboolean desktop_agnostic_vfs_volume_thunar_vfs_do_eject (DesktopAgnosticVFSVolumeThunarVFS* self) {
	gboolean result = FALSE;
	DesktopAgnosticVFSVolumeCallback _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->_eject_callback (self->priv->_eject_callback_target);
	self->priv->_eject_callback = (_tmp0_ = NULL, ((self->priv->_eject_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_eject_callback_target_destroy_notify (self->priv->_eject_callback_target), NULL), self->priv->_eject_callback = NULL, self->priv->_eject_callback_target = NULL, self->priv->_eject_callback_target_destroy_notify = NULL), self->priv->_eject_callback_target = NULL, self->priv->_eject_callback_target_destroy_notify = NULL, _tmp0_);
	result = FALSE;
	return result;
}


static gboolean _desktop_agnostic_vfs_volume_thunar_vfs_do_eject_gsource_func (gpointer self) {
	gboolean result;
	result = desktop_agnostic_vfs_volume_thunar_vfs_do_eject (self);
	return result;
}


static void desktop_agnostic_vfs_volume_thunar_vfs_real_eject (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target) {
	DesktopAgnosticVFSVolumeThunarVFS * self;
	self = (DesktopAgnosticVFSVolumeThunarVFS*) base;
	if (self->priv->_eject_callback == NULL) {
		DesktopAgnosticVFSVolumeCallback _tmp0_;
		self->priv->_eject_callback = (_tmp0_ = callback, ((self->priv->_eject_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_eject_callback_target_destroy_notify (self->priv->_eject_callback_target), NULL), self->priv->_eject_callback = NULL, self->priv->_eject_callback_target = NULL, self->priv->_eject_callback_target_destroy_notify = NULL), self->priv->_eject_callback_target = callback_target, self->priv->_eject_callback_target_destroy_notify = NULL, _tmp0_);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _desktop_agnostic_vfs_volume_thunar_vfs_do_eject_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static gboolean desktop_agnostic_vfs_volume_thunar_vfs_real_eject_finish (DesktopAgnosticVFSVolume* base, GError** error) {
	DesktopAgnosticVFSVolumeThunarVFS * self;
	gboolean result = FALSE;
	gboolean _result_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSVolumeThunarVFS*) base;
	_result_ = FALSE;
	{
		gboolean _tmp0_;
		_tmp0_ = thunar_vfs_volume_eject (self->priv->vol, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_result_ = _tmp0_;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR, DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_EJECT, err->message);
			{
				_g_error_free0 (err);
				goto __finally7;
			}
			_g_error_free0 (err);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _result_;
	return result;
}


DesktopAgnosticVFSVolumeThunarVFS* desktop_agnostic_vfs_volume_thunar_vfs_construct (GType object_type) {
	DesktopAgnosticVFSVolumeThunarVFS * self = NULL;
	self = (DesktopAgnosticVFSVolumeThunarVFS*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticVFSVolumeThunarVFS* desktop_agnostic_vfs_volume_thunar_vfs_new (void) {
	return desktop_agnostic_vfs_volume_thunar_vfs_construct (DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void desktop_agnostic_vfs_volume_thunar_vfs_set_implementation (DesktopAgnosticVFSVolumeThunarVFS* self, ThunarVfsVolume* value) {
	ThunarVfsVolume* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->vol = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->vol), _tmp0_);
	g_object_notify ((GObject *) self, "implementation");
}


static const char* desktop_agnostic_vfs_volume_thunar_vfs_real_get_name (DesktopAgnosticVFSVolume* base) {
	const char* result;
	DesktopAgnosticVFSVolumeThunarVFS* self;
	self = (DesktopAgnosticVFSVolumeThunarVFS*) base;
	result = thunar_vfs_volume_get_name (self->priv->vol);
	return result;
}


static gpointer _thunar_vfs_path_ref0 (gpointer self) {
	return self ? thunar_vfs_path_ref (self) : NULL;
}


static DesktopAgnosticVFSFile* desktop_agnostic_vfs_volume_thunar_vfs_real_get_uri (DesktopAgnosticVFSVolume* base) {
	DesktopAgnosticVFSFile* result;
	DesktopAgnosticVFSVolumeThunarVFS* self;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSVolumeThunarVFS*) base;
	if (self->priv->_uri == NULL) {
		ThunarVfsPath* path;
		DesktopAgnosticVFSFile* _tmp0_;
		DesktopAgnosticVFSFile* _tmp1_;
		path = _thunar_vfs_path_ref0 (thunar_vfs_volume_get_mount_point (self->priv->vol));
		_tmp0_ = desktop_agnostic_vfs_file_new_for_uri (thunar_vfs_path_dup_uri (path), &_inner_error_);
		if (_inner_error_ != NULL) {
			_thunar_vfs_path_unref0 (path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		self->priv->_uri = (_tmp1_ = _tmp0_, _g_object_unref0 (self->priv->_uri), _tmp1_);
		_thunar_vfs_path_unref0 (path);
	}
	result = self->priv->_uri;
	return result;
}


static char* desktop_agnostic_vfs_volume_thunar_vfs_real_get_icon (DesktopAgnosticVFSVolume* base) {
	char* result;
	DesktopAgnosticVFSVolumeThunarVFS* self;
	self = (DesktopAgnosticVFSVolumeThunarVFS*) base;
	result = g_strdup (thunar_vfs_volume_lookup_icon_name (self->priv->vol, gtk_icon_theme_get_default ()));
	return result;
}


static void desktop_agnostic_vfs_volume_thunar_vfs_class_init (DesktopAgnosticVFSVolumeThunarVFSClass * klass) {
	desktop_agnostic_vfs_volume_thunar_vfs_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSVolumeThunarVFSPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_volume_thunar_vfs_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_vfs_volume_thunar_vfs_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_volume_thunar_vfs_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_IMPLEMENTATION, g_param_spec_object ("implementation", "implementation", "implementation", THUNAR_VFS_TYPE_VOLUME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_NAME, "name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_URI, "uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_ICON, "icon");
}


static void desktop_agnostic_vfs_volume_thunar_vfs_desktop_agnostic_vfs_volume_interface_init (DesktopAgnosticVFSVolumeIface * iface) {
	desktop_agnostic_vfs_volume_thunar_vfs_desktop_agnostic_vfs_volume_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_mounted = desktop_agnostic_vfs_volume_thunar_vfs_real_is_mounted;
	iface->mount = desktop_agnostic_vfs_volume_thunar_vfs_real_mount;
	iface->mount_finish = desktop_agnostic_vfs_volume_thunar_vfs_real_mount_finish;
	iface->unmount = desktop_agnostic_vfs_volume_thunar_vfs_real_unmount;
	iface->unmount_finish = desktop_agnostic_vfs_volume_thunar_vfs_real_unmount_finish;
	iface->can_eject = desktop_agnostic_vfs_volume_thunar_vfs_real_can_eject;
	iface->eject = desktop_agnostic_vfs_volume_thunar_vfs_real_eject;
	iface->eject_finish = desktop_agnostic_vfs_volume_thunar_vfs_real_eject_finish;
	iface->get_name = desktop_agnostic_vfs_volume_thunar_vfs_real_get_name;
	iface->get_uri = desktop_agnostic_vfs_volume_thunar_vfs_real_get_uri;
	iface->get_icon = desktop_agnostic_vfs_volume_thunar_vfs_real_get_icon;
}


static void desktop_agnostic_vfs_volume_thunar_vfs_instance_init (DesktopAgnosticVFSVolumeThunarVFS * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_volume_thunar_vfs_finalize (GObject* obj) {
	DesktopAgnosticVFSVolumeThunarVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS (obj);
	_g_object_unref0 (self->priv->vol);
	_g_object_unref0 (self->priv->_uri);
	(self->priv->_mount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_mount_callback_target_destroy_notify (self->priv->_mount_callback_target), NULL);
	self->priv->_mount_callback = NULL;
	self->priv->_mount_callback_target = NULL;
	self->priv->_mount_callback_target_destroy_notify = NULL;
	(self->priv->_unmount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_unmount_callback_target_destroy_notify (self->priv->_unmount_callback_target), NULL);
	self->priv->_unmount_callback = NULL;
	self->priv->_unmount_callback_target = NULL;
	self->priv->_unmount_callback_target_destroy_notify = NULL;
	(self->priv->_eject_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_eject_callback_target_destroy_notify (self->priv->_eject_callback_target), NULL);
	self->priv->_eject_callback = NULL;
	self->priv->_eject_callback_target = NULL;
	self->priv->_eject_callback_target_destroy_notify = NULL;
	G_OBJECT_CLASS (desktop_agnostic_vfs_volume_thunar_vfs_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_volume_thunar_vfs_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_volume_thunar_vfs_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_volume_thunar_vfs_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSVolumeThunarVFSClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_volume_thunar_vfs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSVolumeThunarVFS), 0, (GInstanceInitFunc) desktop_agnostic_vfs_volume_thunar_vfs_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_vfs_volume_info = { (GInterfaceInitFunc) desktop_agnostic_vfs_volume_thunar_vfs_desktop_agnostic_vfs_volume_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType desktop_agnostic_vfs_volume_thunar_vfs_type_id;
		desktop_agnostic_vfs_volume_thunar_vfs_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSVolumeThunarVFS", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_vfs_volume_thunar_vfs_type_id, DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME, &desktop_agnostic_vfs_volume_info);
		g_once_init_leave (&desktop_agnostic_vfs_volume_thunar_vfs_type_id__volatile, desktop_agnostic_vfs_volume_thunar_vfs_type_id);
	}
	return desktop_agnostic_vfs_volume_thunar_vfs_type_id__volatile;
}


static void desktop_agnostic_vfs_volume_thunar_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSVolumeThunarVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_NAME:
		g_value_set_string (value, desktop_agnostic_vfs_volume_get_name ((DesktopAgnosticVFSVolume*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_URI:
		g_value_set_object (value, desktop_agnostic_vfs_volume_get_uri ((DesktopAgnosticVFSVolume*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_ICON:
		g_value_take_string (value, desktop_agnostic_vfs_volume_get_icon ((DesktopAgnosticVFSVolume*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_vfs_volume_thunar_vfs_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSVolumeThunarVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_IMPLEMENTATION:
		desktop_agnostic_vfs_volume_thunar_vfs_set_implementation (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_thunar_vfs_create_volume (DesktopAgnosticVFSVolumeMonitorThunarVFS* self, ThunarVfsVolume* vol) {
	DesktopAgnosticVFSVolume* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (vol != NULL, NULL);
	result = (DesktopAgnosticVFSVolume*) desktop_agnostic_vfs_volume_thunar_vfs_new_for_implementation (vol);
	return result;
}


static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_thunar_vfs_check_volume (DesktopAgnosticVFSVolumeMonitorThunarVFS* self, ThunarVfsVolume* tvol) {
	DesktopAgnosticVFSVolume* result = NULL;
	DesktopAgnosticVFSVolume* vol;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tvol != NULL, NULL);
	vol = _g_object_ref0 ((DesktopAgnosticVFSVolume*) g_hash_table_lookup (self->priv->_volumes, tvol));
	if (vol == NULL) {
		DesktopAgnosticVFSVolume* _tmp0_;
		vol = (_tmp0_ = desktop_agnostic_vfs_volume_monitor_thunar_vfs_create_volume (self, tvol), _g_object_unref0 (vol), _tmp0_);
		g_hash_table_insert (self->priv->_volumes, _g_object_ref0 (tvol), _g_object_ref0 (vol));
	}
	result = vol;
	return result;
}


static void desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_mount_added (DesktopAgnosticVFSVolumeMonitorThunarVFS* self, ThunarVfsVolumeManager* manager, ThunarVfsVolume* vol) {
	DesktopAgnosticVFSVolume* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	g_return_if_fail (vol != NULL);
	g_signal_emit_by_name ((DesktopAgnosticVFSVolumeMonitor*) self, "volume-mounted", _tmp0_ = desktop_agnostic_vfs_volume_monitor_thunar_vfs_check_volume (self, vol));
	_g_object_unref0 (_tmp0_);
}


static void desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_mount_removed (DesktopAgnosticVFSVolumeMonitorThunarVFS* self, ThunarVfsVolumeManager* manager, ThunarVfsVolume* vol) {
	DesktopAgnosticVFSVolume* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	g_return_if_fail (vol != NULL);
	g_signal_emit_by_name ((DesktopAgnosticVFSVolumeMonitor*) self, "volume-unmounted", _tmp0_ = desktop_agnostic_vfs_volume_monitor_thunar_vfs_check_volume (self, vol));
	_g_object_unref0 (_tmp0_);
}


static void desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_volumes_added (DesktopAgnosticVFSVolumeMonitorThunarVFS* self, ThunarVfsVolumeManager* manager, void* ptr) {
	GList* vols;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	vols = (GList*) ptr;
	{
		GList* tvol_collection;
		GList* tvol_it;
		tvol_collection = vols;
		for (tvol_it = tvol_collection; tvol_it != NULL; tvol_it = tvol_it->next) {
			ThunarVfsVolume* tvol;
			tvol = (ThunarVfsVolume*) tvol_it->data;
			{
				DesktopAgnosticVFSVolume* _tmp0_;
				_tmp0_ = desktop_agnostic_vfs_volume_monitor_thunar_vfs_check_volume (self, tvol);
				_g_object_unref0 (_tmp0_);
			}
		}
	}
}


static void desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_volumes_removed (DesktopAgnosticVFSVolumeMonitorThunarVFS* self, ThunarVfsVolumeManager* manager, void* ptr) {
	GList* vols;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	vols = (GList*) ptr;
	{
		GList* tvol_collection;
		GList* tvol_it;
		tvol_collection = vols;
		for (tvol_it = tvol_collection; tvol_it != NULL; tvol_it = tvol_it->next) {
			ThunarVfsVolume* tvol;
			tvol = (ThunarVfsVolume*) tvol_it->data;
			{
				DesktopAgnosticVFSVolume* vol;
				vol = _g_object_ref0 ((DesktopAgnosticVFSVolume*) g_hash_table_lookup (self->priv->_volumes, tvol));
				if (vol != NULL) {
					g_hash_table_remove (self->priv->_volumes, tvol);
				}
				_g_object_unref0 (vol);
			}
		}
	}
}


DesktopAgnosticVFSVolumeMonitorThunarVFS* desktop_agnostic_vfs_volume_monitor_thunar_vfs_construct (GType object_type) {
	DesktopAgnosticVFSVolumeMonitorThunarVFS * self = NULL;
	self = (DesktopAgnosticVFSVolumeMonitorThunarVFS*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticVFSVolumeMonitorThunarVFS* desktop_agnostic_vfs_volume_monitor_thunar_vfs_new (void) {
	return desktop_agnostic_vfs_volume_monitor_thunar_vfs_construct (DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_THUNAR_VFS);
}


static void* desktop_agnostic_vfs_volume_monitor_thunar_vfs_real_get_implementation (DesktopAgnosticVFSVolumeMonitor* base) {
	void* result;
	DesktopAgnosticVFSVolumeMonitorThunarVFS* self;
	self = (DesktopAgnosticVFSVolumeMonitorThunarVFS*) base;
	result = (void*) self->priv->manager;
	return result;
}


static GList* desktop_agnostic_vfs_volume_monitor_thunar_vfs_real_get_volumes (DesktopAgnosticVFSVolumeMonitor* base) {
	GList* result;
	DesktopAgnosticVFSVolumeMonitorThunarVFS* self;
	self = (DesktopAgnosticVFSVolumeMonitorThunarVFS*) base;
	result = g_hash_table_get_values (self->priv->_volumes);
	return result;
}


static void _desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_mount_added_thunar_vfs_volume_manager_volume_mounted (ThunarVfsVolumeManager* _sender, ThunarVfsVolume* p0, gpointer self) {
	desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_mount_added (self, _sender, p0);
}


static void _desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_mount_removed_thunar_vfs_volume_manager_volume_unmounted (ThunarVfsVolumeManager* _sender, ThunarVfsVolume* p0, gpointer self) {
	desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_mount_removed (self, _sender, p0);
}


static void _desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_volumes_added_thunar_vfs_volume_manager_volumes_added (ThunarVfsVolumeManager* _sender, void* p0, gpointer self) {
	desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_volumes_added (self, _sender, p0);
}


static void _desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_volumes_removed_thunar_vfs_volume_manager_volumes_removed (ThunarVfsVolumeManager* _sender, void* p0, gpointer self) {
	desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_volumes_removed (self, _sender, p0);
}


static GObject * desktop_agnostic_vfs_volume_monitor_thunar_vfs_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DesktopAgnosticVFSVolumeMonitorThunarVFS * self;
	parent_class = G_OBJECT_CLASS (desktop_agnostic_vfs_volume_monitor_thunar_vfs_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS (obj);
	{
		ThunarVfsVolumeManager* _tmp0_;
		GHashTable* _tmp1_;
		GList* vols;
		self->priv->manager = (_tmp0_ = _g_object_ref0 (thunar_vfs_volume_manager_get_default ()), _g_object_unref0 (self->priv->manager), _tmp0_);
		self->priv->_volumes = (_tmp1_ = g_hash_table_new_full (g_direct_hash, g_direct_equal, g_object_unref, g_object_unref), _g_hash_table_unref0 (self->priv->_volumes), _tmp1_);
		vols = thunar_vfs_volume_manager_get_volumes (self->priv->manager);
		{
			GList* tvol_collection;
			GList* tvol_it;
			tvol_collection = vols;
			for (tvol_it = tvol_collection; tvol_it != NULL; tvol_it = tvol_it->next) {
				ThunarVfsVolume* tvol;
				tvol = (ThunarVfsVolume*) tvol_it->data;
				{
					g_hash_table_insert (self->priv->_volumes, _g_object_ref0 (tvol), desktop_agnostic_vfs_volume_monitor_thunar_vfs_create_volume (self, tvol));
				}
			}
		}
		g_signal_connect_object (self->priv->manager, "volume-mounted", (GCallback) _desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_mount_added_thunar_vfs_volume_manager_volume_mounted, self, 0);
		g_signal_connect_object (self->priv->manager, "volume-unmounted", (GCallback) _desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_mount_removed_thunar_vfs_volume_manager_volume_unmounted, self, 0);
		g_signal_connect_object (self->priv->manager, "volumes-added", (GCallback) _desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_volumes_added_thunar_vfs_volume_manager_volumes_added, self, 0);
		g_signal_connect_object (self->priv->manager, "volumes-removed", (GCallback) _desktop_agnostic_vfs_volume_monitor_thunar_vfs_on_volumes_removed_thunar_vfs_volume_manager_volumes_removed, self, 0);
	}
	return obj;
}


static void desktop_agnostic_vfs_volume_monitor_thunar_vfs_class_init (DesktopAgnosticVFSVolumeMonitorThunarVFSClass * klass) {
	desktop_agnostic_vfs_volume_monitor_thunar_vfs_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSVolumeMonitorThunarVFSPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_volume_monitor_thunar_vfs_get_property;
	G_OBJECT_CLASS (klass)->constructor = desktop_agnostic_vfs_volume_monitor_thunar_vfs_constructor;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_volume_monitor_thunar_vfs_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS_IMPLEMENTATION, "implementation");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS_VOLUMES, "volumes");
}


static void desktop_agnostic_vfs_volume_monitor_thunar_vfs_desktop_agnostic_vfs_volume_monitor_interface_init (DesktopAgnosticVFSVolumeMonitorIface * iface) {
	desktop_agnostic_vfs_volume_monitor_thunar_vfs_desktop_agnostic_vfs_volume_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_implementation = desktop_agnostic_vfs_volume_monitor_thunar_vfs_real_get_implementation;
	iface->get_volumes = desktop_agnostic_vfs_volume_monitor_thunar_vfs_real_get_volumes;
}


static void desktop_agnostic_vfs_volume_monitor_thunar_vfs_instance_init (DesktopAgnosticVFSVolumeMonitorThunarVFS * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_volume_monitor_thunar_vfs_finalize (GObject* obj) {
	DesktopAgnosticVFSVolumeMonitorThunarVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS (obj);
	_g_object_unref0 (self->priv->manager);
	_g_hash_table_unref0 (self->priv->_volumes);
	G_OBJECT_CLASS (desktop_agnostic_vfs_volume_monitor_thunar_vfs_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_volume_monitor_thunar_vfs_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_volume_monitor_thunar_vfs_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_volume_monitor_thunar_vfs_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSVolumeMonitorThunarVFSClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_volume_monitor_thunar_vfs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSVolumeMonitorThunarVFS), 0, (GInstanceInitFunc) desktop_agnostic_vfs_volume_monitor_thunar_vfs_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_vfs_volume_monitor_info = { (GInterfaceInitFunc) desktop_agnostic_vfs_volume_monitor_thunar_vfs_desktop_agnostic_vfs_volume_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType desktop_agnostic_vfs_volume_monitor_thunar_vfs_type_id;
		desktop_agnostic_vfs_volume_monitor_thunar_vfs_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSVolumeMonitorThunarVFS", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_vfs_volume_monitor_thunar_vfs_type_id, DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR, &desktop_agnostic_vfs_volume_monitor_info);
		g_once_init_leave (&desktop_agnostic_vfs_volume_monitor_thunar_vfs_type_id__volatile, desktop_agnostic_vfs_volume_monitor_thunar_vfs_type_id);
	}
	return desktop_agnostic_vfs_volume_monitor_thunar_vfs_type_id__volatile;
}


static void desktop_agnostic_vfs_volume_monitor_thunar_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSVolumeMonitorThunarVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS_IMPLEMENTATION:
		g_value_set_pointer (value, desktop_agnostic_vfs_volume_monitor_get_implementation ((DesktopAgnosticVFSVolumeMonitor*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS_VOLUMES:
		g_value_set_pointer (value, desktop_agnostic_vfs_volume_monitor_get_volumes ((DesktopAgnosticVFSVolumeMonitor*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




