/***************************************************************************
                          csearchsocket.h  -  description
                             -------------------
    begin                : Thu May 27 2004
    copyright            : (C) 2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSEARCHSOCKET_H
#define CSEARCHSOCKET_H

/**
  *@author Mathias Küster
  *
  * This class receives UDP packets and parses them into search results.
  * Because originally dclib did not terminate it's search results with a |,
  * the parser adds one. I think only 1 result is allowed per packet,
  * but like with most of the NMDC protocol it's probably undefined.
  */

#include <dclib/dcos.h>
#include <dclib/core/csocket.h>
#include <dclib/core/ccallback.h>
#include <dclib/core/cmutex.h>
#include <dclib/core/cbytearray.h>

class CMessageSearchResult;

class CSearchSocket : private CSocket {
public:
	/** */
	CSearchSocket();
	/** */
	virtual ~CSearchSocket();

	/** */
	void SetCallBackFunction( _CCallback1<CMessageSearchResult*> * callback );

	/** CSocket function made public and protected by mutex */
	eConnectState Connect( CString Host, int Port, bool iAsync );
	/** CSocket function made public and protected by mutex */
	int Disconnect();

	/**
	 * Receives up to maxpackets UDP packets,
	 * returning earlier if no more data available from the socket.
	 * Parses the data and sends the results over the callback.
	 */
	void Receive( int maxpackets = 25 );

private:
	/** callback function */
	_CCallback1<CMessageSearchResult*> * m_pCallback;
	/** */
	CMutex m_SearchSocketMutex;
	/** */
	CByteArray m_Buffer;
};

/** */
inline void CSearchSocket::SetCallBackFunction( _CCallback1<CMessageSearchResult*> * callback )
{ m_SearchSocketMutex.Lock(); delete m_pCallback; m_pCallback = callback; m_SearchSocketMutex.UnLock(); }

#endif
